// LSM9DS90/uLCD Demo
// ECE 4180 Lab Code Template

#include "mbed.h"
#include "LSM9DS0.h"
#include "uLCD_4DGL.h"

// uncomment this line to enable the uLCD for Part 4 of the lab
#define PART_4

// SDO_XM and SDO_G are pulled up, so our addresses are:
#define LSM9DS0_XM_ADDR  0x1D // Would be 0x1E if SDO_XM is LOW
#define LSM9DS0_G_ADDR   0x6B // Would be 0x6A if SDO_G is LOW

// refresh time. set to 500 for part 2 and 50 for part 4
#define REFRESH_TIME_MS 300

// Verify that the pin assignments below match your breadboard
LSM9DS0 imu(p9, p10, LSM9DS0_G_ADDR, LSM9DS0_XM_ADDR);
Serial pc(USBTX, USBRX);
DigitalIn sw(p18);

#ifdef PART_4
uLCD_4DGL lcd(p28, p27, p30);
#endif

//Init Serial port and LSM9DS0 chip
void setup()
{
#ifdef PART_4
	lcd.baudrate(3000000);
	lcd.background_color(0);
	lcd.cls();
	
	lcd.printf("Initializing...");
#endif

	// Use the begin() function to initialize the LSM9DS0 library.
    // You can either call it with no parameters (the easy way):
    uint16_t status = imu.begin();

    //Make sure communication is working
    pc.printf("LSM9DS0 WHO_AM_I's returned: 0x%X\n", status);
    pc.printf("Should be 0x49D4\n\n");
}

int main()
{
    setup();  //Setup sensor and Serial
    pc.printf("------ LSM0DS0 Demo -----------\n");
    lcd.cls();
	float prevheading = imu.calcHeading();
	float pi = 3.14;
	float prevline_x = 30*cos(prevheading*pi/180) + 64;
	float prevline_y = 30*sin(prevheading*pi/180) + 64;
	float prevcirc_x = 64;
	float prevcirc_y = 64;
	if (sw == 1) {
		lcd.line(64,64,prevline_x, prevline_y, BLUE);
		lcd.circle(64, 64, 30, GREEN);
	} else {
		lcd.circle(64, 64, 10, BLUE);
	}	
    while (true)
    {
    	// TODO - add code here to read compass or accelerometer data
    	// and print it to the USB serial port (part 2) and display it on the uLCD (part 3)
    	
    	// Compass Trigonometry tip: you can retrieve the compass heading (in degrees) directly from
    	// the IMU library. Example:
    	// 		imu.readMag();
    	//		float heading = imu.calcHeading();
    	// Remember that x = length*cos(heading) and y = length*sin(heading)
    	// to convert from degrees to radians (for sin/cos functions), multiply by pi/180
    	sw.read();
    	if (sw) {
    		imu.readMag();
			imu.readAccel();
			imu.readTemp();
			float heading = imu.calcHeading();
			//lcd.circle(64, 64, 30, WHITE);
			lcd.line(64,64,prevline_x,prevline_y, BLACK);
			lcd.circle(prevcirc_x,prevcirc_y, 10, BLACK);
			float line_x = 30*cos(heading*pi/180) + 64;
			float line_y = 30*sin(heading*pi/180) + 64;
			lcd.circle(64, 64, 30, GREEN);
			lcd.line(64,64,line_x, line_y, BLUE);
			prevline_x = line_x;
			prevline_y = line_y;
			wait_ms(REFRESH_TIME_MS);
		} else {
			imu.readMag();
			imu.readAccel();
			//lcd.circle(64, 64, 30, WHITE);
			lcd.line(64,64,prevline_x,prevline_y, BLACK);
			lcd.circle(64, 64, 30, BLACK);
			lcd.circle(prevcirc_x,prevcirc_y, 10, BLACK);
			float circ_x = imu.ax_raw*0.01 + 64;
			float circ_y = imu.ay_raw*0.01 + 64;
			lcd.circle(circ_x,circ_y,10, BLUE);
			prevcirc_x = circ_x;
			prevcirc_y = circ_y;
			wait_ms(REFRESH_TIME_MS);
		}
	}
}
