// LSM9DS90/uLCD Demo
// ECE 4180 Lab Code Template

#include "mbed.h"
#include "LSM9DS0.h"
#include "uLCD_4DGL.h"

// uncomment this line to enable the uLCD for Part 4 of the lab
//#define PART_4

// SDO_XM and SDO_G are pulled up, so our addresses are:
#define LSM9DS0_XM_ADDR  0x1D // Would be 0x1E if SDO_XM is LOW
#define LSM9DS0_G_ADDR   0x6B // Would be 0x6A if SDO_G is LOW

// refresh time. set to 500 for part 2 and 50 for part 4
#define REFRESH_TIME_MS 500

// Verify that the pin assignments below match your breadboard
LSM9DS0 imu(p9, p10, LSM9DS0_G_ADDR, LSM9DS0_XM_ADDR);
Serial pc(USBTX, USBRX);
Serial device(p13, p14);

#ifdef PART_4
uLCD_4DGL lcd(p28, p27, p30);X
#endif

//Init Serial port and LSM9DS0 chip
void setup()
{
#ifdef PART_4
	lcd.baudrate(3000000);
	lcd.background_color(0);
	lcd.cls();
	
	lcd.printf("Initializing...");
#endif

	// Use the begin() function to initialize the LSM9DS0 library.
    // You can either call it with no parameters (the easy way):
    uint16_t status = imu.begin();

    //Make sure communication is working
    pc.printf("LSM9DS0 WHO_AM_I's returned: 0x%X\n", status);
    pc.printf("Should be 0x49D4\n\n");
}

int main()
{
    setup();  //Setup sensor and Serial
    pc.printf("------ LSM0DS0 Demo -----------\n");
    while (true)
    {
    	// TODO - add code here to read compass or accelerometer data
    	// and print it to the USB serial port (part 2) and display it on the uLCD (part 3)
    	
    	// Compass Trigonometry tip: you can retrieve the compass heading (in degrees) directly from
    	// the IMU library. Example:
    	// 		imu.readMag();
    	//		float heading = imu.calcHeading();
    	// Remember that x = length*cos(heading) and y = length*sin(heading)
    	// to convert from degrees to radians (for sin/cos functions), multiply by pi/180
    	imu.readMag();
		imu.readAccel();
		imu.readTemp();
		float heading = imu.calcHeading();
        //if(device.readable()) {
        //    pc.putc(device.getc());
        //}
		//if(pc.readable()) {
        //    device.putc(pc.getc());
        //}
		pc.printf("Accelaration_x: %d\n", imu.ax_raw);
		pc.printf("Accelaration_y: %d\n", imu.ay_raw);
		pc.printf("Accelaration_z: %d\n", imu.az_raw);
		pc.printf("Temperature in C: %2.4f\n", imu.temperature_c);
		pc.printf("Heading: %2.4f\n", heading);
		wait_ms(REFRESH_TIME_MS);
	}
}
