#include "mbed.h"
 
DigitalOut latch(p15);
DigitalOut enable(p16);
DigitalIn r(p5);
DigitalIn g(p6);
DigitalIn b(p7);
 
SPI spi(p11, p12, p13);
 
void RGB_LED(int red, int green, int blue) {
    unsigned int low_color=0;
    unsigned int high_color=0;
    high_color=(blue<<4)|((red&0x3C0)>>6);
    low_color=(((red&0x3F)<<10)|(green));
    spi.write(high_color);
    spi.write(low_color);
    latch=1;
    latch=0;
}
 
int main() {
    int red=0;
    int green=0;
    int blue=0;
    spi.format(16,0);
    spi.frequency(500000);
    enable=0;
    latch=0;
    wait(2);
    while(1) {
        if (r == 1){
            if (red < 255) red += 5;
        } else {
            if (red > 0) red -= 5;
        }
        if (b == 1){
            if (blue < 255) blue += 5;
        } else {
            if (blue > 0) blue -= 5;
        }
        if (g == 1){
            if (green < 255) green += 5;
        } else {
            if (green > 0) green -= 5;
        }
        RGB_LED(red, green, blue);
        wait(0.5);
    }

}