#include "mbed.h"

DigitalIn sw(p5);
DigitalOut led(p10);
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

class Watchdog {
public:
// Load timeout value in watchdog timer and enable
    void kick(float s) {
        LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
        uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4
        LPC_WDT->WDTC = s * (float)clk;
        LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset
        kick();
    }
// "kick" or "feed" the dog - reset the watchdog timer
// by writing this required bit pattern
    void kick() {
        LPC_WDT->WDFEED = 0xAA;
        LPC_WDT->WDFEED = 0x55;
    }
};
 
// Setup the watchdog timer
Watchdog wdt;

int main() {
    int count = 0;
    if ((LPC_WDT->WDMOD >> 2) & 1)
    myled4 = 1; else myled3 = 1;
    
    wdt.kick(10.0); 
    
    while(1) {
        if (sw == 1) {
        led = 1;
        myled1 = 1;
        wait(0.2);
        } else {
            if (count >= 20) while(1) {};
            led = 0;
            myled1 = 0;
            wait(0.2);
        }
        count++;
        wdt.kick(); 
    }
    
}
