#include "mbed.h"
#include "MAX31865.h"

Serial pc(SERIAL_TX, SERIAL_RX);
MAX31865_RTD rtd(MAX31865_RTD::RTD_PT100,D11, D12, D13, D10);

int main()
{
    // int i = 0;
    rtd.configure( true, true, false, true, MAX31865_FAULT_DETECTION_NONE,
                   true, true, 0x0000, 0x7fff );

    while (1) {
        rtd.read_all( );

        if( rtd.status( ) == 0 ) {
            double temperature1 = rtd.temperature( );
            pc.printf( " T = %f deg C \r\n",temperature1);

        } else
        {
            pc.printf( "RTD fault register: %d :\r\n",rtd.status( ));
            if( rtd.status( ) & MAX31865_FAULT_HIGH_THRESHOLD ) {
                pc.printf( "RTD high threshold exceeded\r\n" );
            } else if( rtd.status( ) & MAX31865_FAULT_LOW_THRESHOLD ) {
                pc.printf( "RTD low threshold exceeded\r\n" );
            } else if( rtd.status( ) & MAX31865_FAULT_REFIN ) {
                pc.printf( "REFIN- > 0.85 x V_BIAS\r\n" );
            } else if( rtd.status( ) & MAX31865_FAULT_REFIN_FORCE ) {
                pc.printf( "REFIN- < 0.85 x V_BIAS, FORCE- open\r\n" );
            } else if( rtd.status( ) & MAX31865_FAULT_RTDIN_FORCE ) {
                pc.printf( "RTDIN- < 0.85 x V_BIAS, FORCE- open\r\n" );
            } else if( rtd.status( ) & MAX31865_FAULT_VOLTAGE ) {
                pc.printf( "Overvoltage/undervoltage fault\r\n");
            } else {
                pc.printf( "Unknown fault; check connection\r\n" );
            }
        }
        wait(1);

    }
}
