#include "mbed.h"

InterruptIn event(PC_13);
DigitalOut myled(PB_3);
Serial pc(PB_6, PB_7);
DigitalOut VccEnable(PB_5);
int go_to_sleep = 0;

void pressed()
{
    pc.printf("Button pressed\n");
    go_to_sleep = go_to_sleep + 1;
    if (go_to_sleep > 3) go_to_sleep = 0;

}

int main()
{
    int i = 0;
    VccEnable = 0;   //功能电源开关,0:on,1:off
    pc.printf("\nPress Button to enter/exit sleep & deepsleep\n");
  //  VccEnable = 0;

    event.fall(&pressed);

    while (1) {

        if ((go_to_sleep == 0) || (go_to_sleep == 2)) {
            pc.printf("%d: Running\n", i);
            myled = !myled;
            wait(1.0);
        }

        if (go_to_sleep == 1) {
            myled = 0;
            pc.printf("%d: Entering sleep (press user button to resume)\n", i);
            sleep();
        }

        if (go_to_sleep == 2) {
            myled = 0;
            pc.printf("%d: Entering deepsleep (press user button to resume)\n", i);
            deepsleep();
        }

        i++;
    }
}
