#include "mbed.h"

int debug = 1;
Serial pc(USBTX, USBRX); // tx, rx

AnalogIn spare(p20); // spare pin for extra sensors if needed
AnalogIn inputx(p19); // input pins for x,y,z axis respectively.
AnalogIn inputy(p18);
AnalogIn inputz(p17);
DigitalIn selftest(p21); // self test pin for the accelerometer
DigitalOut redundant_1(p15); // pull adjacent pins low to reduce noise
DigitalOut redundant_2(p16);
Ticker ticker;
float acc_sampling_time = 1; // time between each sample in s
float offset_x=0,offset_y=0,offset_z=0;  // calibration offsets
float scale_factor = 100; // calibration scale factor

int no_of_spokes = 5; // 5 readings per rev
int count_delay_time = 10; // minimum interval between spikes in ms
InterruptIn front_left(p5);
InterruptIn front_right(p6);
InterruptIn back_left(p7);
Timer t_fl, t_fr, t_bl;
volatile int count_fl, count_fr, count_bl;
Ticker time_interrupt;
float rpm_sampling_time = 2; // time in seconds between samples

CAN can(p30, p29); // rx tx
int can_id_acc_xy = 0x100;
int can_id_acc_z = 0x101;
int can_id_rpm_front = 0x102;
int can_id_rpm_back = 0x103;
typedef union {
    char can_string[8];
    float fl_data[2];
} can_msg_t;


void count_rev_fl()
{
    if(debug) pc.printf("yo! count %d\n", count_fl);

    static int last_count_time=0;
    int crt_time  = t_fl.read_ms();
    if ( last_count_time > crt_time ) last_count_time = 0;
    if ( crt_time - last_count_time < count_delay_time ) return;
    last_count_time = t_fl.read_ms();
    count_fl++;
}


void count_rev_fr()
{
    static int last_count_time=0;
    int crt_time  = t_fl.read_ms();
    if ( last_count_time > crt_time ) last_count_time = 0;
    if ( crt_time - last_count_time < count_delay_time ) return;
    last_count_time = t_fl.read_ms();
    count_fr++;
}


void count_rev_bl()
{
    static int last_count_time=0;
    int crt_time  = t_fl.read_ms();
    if ( last_count_time > crt_time ) last_count_time = 0;
    if ( crt_time - last_count_time < count_delay_time ) return;
    last_count_time = t_fl.read_ms();
    count_bl++;
}


void time_interrupt_call()
{
    float rpm_fl = (float)count_fl/(float)no_of_spokes/rpm_sampling_time;
    float rpm_fr = (float)count_fr/(float)no_of_spokes/rpm_sampling_time;
    float rpm_bl = (float)count_bl/(float)no_of_spokes/rpm_sampling_time;
    count_fl = 0;
    count_fr = 0;
    count_bl = 0;

    if(debug) {
        pc.printf("rpm: fl: %f fr: %f bl: %f\n", rpm_fl, rpm_fr, rpm_bl);
    } else {
        can_msg_t can_msg_1;
        can_msg_t can_msg_2;
        can_msg_1.fl_data[0] = rpm_fl;
        can_msg_1.fl_data[1] = rpm_fr;
        can_msg_2.fl_data[0] = rpm_bl;
        can_msg_2.fl_data[1] = 0;
        can.write( CANMessage(can_id_rpm_front, can_msg_1.can_string, 8) );
        can.write( CANMessage(can_id_rpm_back,  can_msg_2.can_string, 8) );
    }
}


void read_accelerometer_and_send()
{
    float x=0,y=0,z=0; // variables for x,y,z axes
    x=(inputx+offset_x)*scale_factor;
    y=(inputy+offset_y)*scale_factor;
    z=(inputz+offset_z)*scale_factor;

    if(debug) {
        pc.printf("x: %03d y: %03d z: %03d\n", (int)x,(int)y,(int)z);
    } else {
        can_msg_t can_msg_1;
        can_msg_t can_msg_2;
        can_msg_1.fl_data[0] = x;
        can_msg_1.fl_data[1] = y;
        can_msg_2.fl_data[0] = z;
        can_msg_2.fl_data[1] = 0;
        can.write( CANMessage(can_id_acc_xy, can_msg_1.can_string, 8) );
        can.write( CANMessage(can_id_acc_z, can_msg_2.can_string, 8) );
    }
}


int main()
{
    redundant_1 = 0; // pull unused analogue in pins low to reduce noise
    redundant_2 = 0;
    
    ticker.attach(&read_accelerometer_and_send, acc_sampling_time);
    time_interrupt.attach(&time_interrupt_call, rpm_sampling_time);

    t_fl.reset();
    t_fl.start();
    t_fr.reset();
    t_fr.start();
    t_bl.reset();
    t_bl.start();
    front_left.rise(&count_rev_fl);
    front_right.rise(&count_rev_fr);
    back_left.rise(&count_rev_bl);
    
    if(debug) pc.printf("debugging\n");

    while(1);
}