#include "mbed.h"
#include "WiflyInterface.h"

Serial pc(USBTX, USBRX);

/* wifly object where:
*     - p9 and p10 are for the serial communication
*     - p25 is for the reset pin
*     - p26 is for the connection status
*     - "hotspot_name" is the ssid of the network
*     - "password" is the password
*     - WPA is the security method
*/
WiflyInterface eth(p9, p10, p25, p26, "hotspot_name", "password", WPA);

int main()
{
    int s = eth.init(); //Use DHCP

    if( s != NULL ) {
        printf( "Could not initialise. Will halt!\n" );
        exit( 0 );
    }

    s = eth.connect(); // set up the chip and join the network

    if( s == false ) {
        printf( "Could not connect. Will halt!\n" );
        exit( 0 );
    } else {
        // print the IP address of the shield
        printf( "IP: %s\n", eth.getIPAddress() );
    }
}
