#include "mbed.h"
#include "BitmapFile.h"
#include <string>
#include "PinDetect.h"
#include "NeoStrip.h"

# define MAX_FILE 30

#define N 32
NeoStrip strip(p5, N);
float bright = 0.2; // 20% is plenty for indoor use

PinDetect b1(p25, PullUp);
PinDetect b2(p29, PullUp);
PinDetect b3(p22, PullUp);
PinDetect b4(p27, PullUp);

LocalFileSystem local("local");               // Create the local filesystem under the name "local"
Serial pc(USBTX, USBRX); // tx, rx
BitmapFile *MyBitmap;

char *f_list[MAX_FILE];
int file_index = 0; // get the index of file being displayed
unsigned max_file = 0; // register how many files there are

char * get_file_name() {
    char *fn = NULL;
    unsigned i = 0; // index in the file list;
    DIR *d = opendir("/local");               // Opens the root directory of the local file system
    struct dirent *p;
    while((p = readdir(d)) != NULL) {         // Print the names of the files in the local file system
        int l = strlen(p->d_name);
        if (strcmp(&(p->d_name[l-3]), "BMP") == 0) {
            i++;
            if (file_index == i) {
                fn = (char *) malloc(50);
                strcpy(fn, p->d_name);
                break;
            }
        }
    }
    closedir(d);

    return fn;
}

void strip_off() {
    for (int i=0; i<N; i++) {
        strip.setPixel(i, 0);
    }
    strip.write();
}

void display_number(float f) {
    for (int i=0; i<N; i++) {
        if (i<(f*N))
            strip.setPixel(i, 0xffffff);
    }
    strip.write();
    wait(0.2);
    strip_off();
}

void brightnessUp(void) {
    if (bright < 1)
    {
        bright += 0.01;
        if (bright > 1)
            bright = 1;
        printf("increase brightness\r\n");
        strip.setBrightness(bright);
        display_number(bright);
    }
}

void brightnessDown(void) {
    if (bright > 0)
    {
        bright -= 0.01;
        if (bright < 0)
            bright = 0;
        printf("decrease brightness\r\n");
        strip.setBrightness(bright);
        display_number(bright);
    }
}

void fileDown(void) {
    file_index--;
    if (file_index < 0)
        file_index = max_file;
    printf("fileDown to %i:%s\r\n", file_index, f_list[file_index]);
    display_number(file_index/float(N));
}

void fileUp(void) {
    file_index++;
    if (file_index > max_file)
        file_index = 0;
    printf("fileUp to %i:%s\r\n", file_index, f_list[file_index]);
    display_number(file_index/float(N));
}


// Converts HSV to RGB with the given hue, assuming
// maximum saturation and value
int hueToRGB(float h)
{
    // lots of floating point magic from the internet and scratching my head
    float r, g, b;
    if (h > 360)
        h -= 360;
    if (h < 0)
        h += 360;
    int i = (int)(h / 60.0);
    float f = (h / 60.0) - i;
    float q = 1 - f;
    
    switch (i % 6)
    {
        case 0: r = 1; g = f; b = 0; break;
        case 1: r = q; g = 1; b = 0; break;
        case 2: r = 0; g = 1; b = f; break;
        case 3: r = 0; g = q; b = 1; break;
        case 4: r = f; g = 0; b = 1; break;
        case 5: r = 1; g = 0; b = q; break;
        default: r = 0; g = 0; b = 0; break;
    }
    
    // scale to integers and return the packed value
    uint8_t R = (uint8_t)(r * 255);
    uint8_t G = (uint8_t)(g * 255);
    uint8_t B = (uint8_t)(b * 255);

    return (R << 16) | (G << 8) | B;
}


void pattern1()
{
    static float dh = 360.0 / N;
    static float x = 0;
    printf("%f\r\n",x);

    for (int i = 0; i < N; i++) {
        int c = hueToRGB((dh * i) - x);
        //printf("R %i, G %i, B %i\r\n", (c>>16)&0xff, (c>>8)&0xff, c&0xff);
        strip.setPixel(i, c);
    }
    
    x += 1;
    if (x > 360)
        x = 0;
}


void patternStart(void) {    
    printf("file_index: %i\r\n", file_index);
    if (file_index == 0) {
        for ( int j=0; j<100; j++ ){
            pattern1();
            strip.write();
            wait_ms(20);
        }
        return;
    }
    
    printf("fn: %s\r\n", f_list[file_index]);
    
    char *fn = get_file_name();
    
    unsigned l = strlen(fn);
    char *path = (char *) malloc(l+7);
    path[0] = 0;
    strcat(path, "/local/");
    strcat(path, fn);
    printf("path: %s\r\n", path);
    
    MyBitmap = new BitmapFile(path);
    for(int row = 0; row < MyBitmap->getHeight(); row++)
    {
        int *row_color = MyBitmap->getRow(row, false);
        for(int col = 0; col < MyBitmap->getWidth(); col++)
        {
            unsigned c = row_color[col] & 0xffffff;
            strip.setPixel(col, c);
            if ( c > 0xfff )
                printf(" ");
            else
                printf("*");
        }
        strip.write();
        wait_ms(20);
        printf("\r\n");
        delete [] row_color;
    }
    printf("closing\r\n");
    MyBitmap->close();
    printf("closed\r\n");
    free(fn);
    free(path);
    strip_off();
}




int main() {
    b1.setAssertValue( 0 );
    b2.setAssertValue( 0 );
    b3.setAssertValue( 0 );
    b4.setAssertValue( 0 );
    
    b1.attach_asserted( &brightnessDown );
    b2.attach_asserted( &patternStart );
    b3.attach_asserted( &brightnessUp );
    
    b1.attach_asserted_held( &fileDown );
    b3.attach_asserted_held( &fileUp );

    strip.setBrightness(bright);    // set default brightness

    
    // build a list of files
    for (unsigned i=0; i<MAX_FILE; i++)
        f_list[i] = NULL;

    unsigned i = 0; // index in the file list;
    DIR *d = opendir("/local");               // Opens the root directory of the local file system
    struct dirent *p;
    while((p = readdir(d)) != NULL) {         // Print the names of the files in the local file system
        int l = strlen(p->d_name);
        if (strcmp(&(p->d_name[l-3]), "BMP") == 0) {
            char *tmp_str = (char *) malloc(l+1);
            strcpy(tmp_str, p->d_name);
            i++;
            f_list[i] = tmp_str;
            printf("f_list: %i:%s\r\n", i, tmp_str);
        }
    }
    closedir(d);
    
    max_file = i;
    b1.setSampleFrequency();
    b2.setSampleFrequency();
    b3.setSampleFrequency();
    b4.setSampleFrequency();
    
    while(1)
        __WFI();
}