#include "mbed.h"
#include "WiflyInterface.h"
#include "xively.h"
#include "xi_err.h"

#define XI_FEED_ID 273104668 // set Xively Feed ID (numerical, no quoutes)
#define XI_API_KEY "Your API Key" // set Xively API key (double-quoted string)

Serial pc(USBTX, USBRX);

/* wifly object where:
*     - p9 and p10 are for the serial communication
*     - p25 is for the reset pin
*     - p26 is for the connection status
*     - "mbed" is the ssid of the network
*     - "password" is the password
*     - WPA is the security
*/
WiflyInterface eth(p9, p10, p25, p26, "ssid", "passwd", WPA);

int main()
{
    int s = eth.init(); //Use DHCP

    if( s != NULL ) {
        printf( "Could not initialise. Will halt!\n" );
        exit( 0 );
    }

    s = eth.connect();

    if( s == false ) {
        printf( "Could not connect. Will halt!\n" );
        exit( 0 );
    } else {
        printf( "IP: %s\n", eth.getIPAddress() );
    }

    xi_feed_t feed;
    memset( &feed, NULL, sizeof( xi_feed_t ) );

    feed.feed_id = XI_FEED_ID;
    feed.datastream_count = 1;

    feed.datastreams[0].datapoint_count = 1;
    xi_datastream_t* orientation_datastream = &feed.datastreams[0];
    strcpy( orientation_datastream->datastream_id, "orientation" );
    xi_datapoint_t* current_orientation = &orientation_datastream->datapoints[0];

    // create the cosm library context
    xi_context_t* xi_context
    = xi_create_context( XI_HTTP, XI_API_KEY, feed.feed_id );

    // check if everything works
    if( xi_context == NULL ) {
        return -1;
    }

    while(1) {
        time_t seconds = time(NULL);
        char buffer[32];
        // get the current time
        strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
        xi_set_value_str( current_orientation, buffer );
        printf( "update...\n" );
        // send to xively server
        xi_feed_update( xi_context, &feed );
        printf( "done...\n" );
        wait( 1.0 );
    }
}
