#include "mbed.h"
#define RATIO 2000                      //The amplified factor of the OA
#define SAMPLE_TIME 500             // Sample time, default is 100ms
void MassCompute(float);            // The function of computing mass from voltage.
void SerialInit(void);              // The function fo serial initial
void SerialTransmit(void);          // Transmit the data through the serial

AnalogIn voltage(p20);              // AnalogIn is a class of anlog input, p20 is the pin you use for anlog input,
                                    // You can change the pin from pin15 to pin20
float voltage_measure;
Serial pc(USBTX, USBRX);            // Communicate with PC through the serial

DigitalOut high_pin(p5);            //test pin, p5 is the high level pin
DigitalOut low_pin(p6);             //test pin, p6 is the low level pin
                                    
float mass;                         // The mass of the object
unsigned char mass_trans_high;      // A 8 bits mass used for transmitting
unsigned char mass_trans_low;

unsigned short int test;

int main()
{
    SerialInit();                   //Initial the serial
    
    high_pin = 1;
    low_pin = 0;
    
    test = 0xff;
    
    while(1)
    {
        voltage_measure = voltage.read();
        MassCompute(voltage_measure);  
        SerialTransmit();
        //pc.printf("%d",test);
        wait_ms(SAMPLE_TIME);               //Wait for 100ms, this is the sample time.
    }      
}

void MassCompute(float vol)
{
    //float ratio;                    //The amplified factor of the OA
    float vol_ref;                  //Reference voltage, the basic voltage of the MCU, the default number is 3.3
    
    vol_ref = 3.3;
    
    mass = 334.36*vol_ref*vol/RATIO-0.12513 ;        //The compute function of mass from the voltage
}

void SerialInit(void)
{
    pc.baud(9600);                     //Set the baud rate
    pc.format(8,SerialBase::None,1);   //8bit number,no parity has been used,stop bits 1 
}

void SerialTransmit(void)
{   
    unsigned char start,end,voltage_high,voltage_low,voltage_test;
    start = '#';
    end   = '$';


    if(mass>0.3)
        mass =0.3;
    mass_trans_low = (unsigned int)(mass*10000);
    mass_trans_high = (unsigned int)(mass*10000)>>8;
    //voltage_test = (unsigned int)voltage_measure*10;
    
    //voltage_high = (unsigned int)(voltage_measure*10000)>>8;
   // voltage_low  = (unsigned int)(voltage_measure*10000);
    
    pc.printf("%c",start);
    pc.printf("%c",mass_trans_high);
    pc.printf("%c",mass_trans_low);
    
    //pc.printf("%c",voltage_high);
    //pc.printf("%c",voltage_low);
    pc.printf("%c",end);
}