#include "mbed.h"
#include "MemoryController.h"
#include "FastPWM.h"

DigitalOut CE(PA_5);
DigitalOut CLE(PA_6);
DigitalOut ALE(PA_7);
DigitalOut WE(PA_8);
DigitalOut RE(PA_9);
DigitalOut WP(PA_10);
DigitalIn  RDY(PA_3);

FastPWM PWMTrial(PC_12);

//Not sure what to do here

void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */

  /* USER CODE END Error_Handler_Debug */
}

void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

  /** Configure the main internal regulator output voltage
  */
  __HAL_RCC_PWR_CLK_ENABLE();
  __HAL_PWR_VOLTAGESCALING_CONFIG(PWR_REGULATOR_VOLTAGE_SCALE1);
  /** Initializes the RCC Oscillators according to the specified parameters
  * in the RCC_OscInitTypeDef structure.
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSI;
  RCC_OscInitStruct.HSIState = RCC_HSI_ON;
  RCC_OscInitStruct.HSICalibrationValue = RCC_HSICALIBRATION_DEFAULT;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSI;
  RCC_OscInitStruct.PLL.PLLM = 16;
  RCC_OscInitStruct.PLL.PLLN = 336;
  RCC_OscInitStruct.PLL.PLLP = RCC_PLLP_DIV4;
  RCC_OscInitStruct.PLL.PLLQ = 4;
  RCC_OscInitStruct.PLL.PLLR = 2;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    Error_Handler();
  }
  /** Initializes the CPU, AHB and APB buses clocks
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV2;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_2) != HAL_OK)
  {
    Error_Handler();
  }
}


DigitalOut led(LED1);

int main()
{
    wait(1);
    printf("Program Begin\r\n");
    PWMTrial.pulsewidth_ticks(50);
    PWMTrial.period_ticks(100);
    PWMTrial.write(0.5);
    
    /*
    //Initialize 
    PinName DQ[8];
    DQ[0] = PA_13;
    DQ[1] = PA_14;
    DQ[2] = PA_15;
    DQ[3] = PB_7;
    DQ[4] = PC_13;
    DQ[5] = PC_11;
    DQ[6] = PA_0;
    DQ[7] = PA_1;
    
    MemoryController mem(CE,CLE,ALE,WE,RE,WP,DQ,RDY);
    char *dataOutput;
    //Reserve Output Data Space
    dataOutput = (char*)malloc(4321 * sizeof(char));
    //Set Test Address
    mem.Address.col1 = 0x02;
    mem.Address.col2 = 0x02;
    mem.Address.page = 0x02;
    mem.Address.block1= 0x02;
    mem.Address.block2= 0x02;
    
    
    //Initialize the device
    printf("Reset Being\r\n");
    mem.ResetDevice();
    printf("ResetComplete\r\n");
    wait_us(100);
    
    //read a page
    printf("Bein Page Read\r\n");
    dataOutput[0] = 1;
    dataOutput[1] = 2;
    printf("%i, %i\r\n",dataOutput[0],dataOutput[1]);
    mem.ReadPage(mem.Address, dataOutput);
    printf("Page Read Complete\r\n");
    
    printf("Printing Data Values\r\n");
    for(int i =0; i<128;i++){
        printf("%i\r\n",dataOutput[i]);
    }
    
    for (int i=0; i<128;i++){
        dataOutput[i]=i;
    }
    printf("Program New Values\r\n");
    mem.ProgramPage(mem.Address, dataOutput);
    for(int i = 0;i<150;i++){
        dataOutput[i] = 0;
    }
    printf("Reading New Values\r\n");
    mem.ReadPage(mem.Address,dataOutput);
    for(int i =0;i<150;i++){
        printf("%i\r\n",dataOutput[i]);    
    }
    */
    //write that page
    
    //read that page
    
    //erase that page
    
    //read that page

}
