#include "MemoryController.h"
 
 
 
 
 
 //Notes : May have to add pull-up resistor to busy line (see page 25 of data sheet)
 //         Must initialize device by sending reset command at power-on (page 36)
 //         Chip uses 3.3V logic :( sad face
 //         Collumn Address can be sent up to 4320 (0x10E0) to be valid.
 //         Pages are programmed at a time (4320 Bytes per page)
//          Blocks are erased at a time (128 Pages each, 1024 Blocks in total)
 
 
 
 
 
 
 
//******************************************************************************
MemoryController::MemoryController(DigitalOut CE,DigitalOut CLE,DigitalOut ALE,DigitalOut WE,DigitalOut RE,DigitalOut WP,PinName *DQ, DigitalIn RDY): 
m_CE(CE), m_CLE(CLE), m_ALE(ALE), m_WE(WE), m_RE(RE), m_WP(WP), m_DQ(DQ), m_RDY(RDY)
{
}
 
 
//******************************************************************************
MemoryController::~MemoryController(void) 
{
  //empty block
}

void MemoryController::setDQ(const char set, bool *values){
    for (int i = 0;i<8;i++){
        values[i] = ((set >> i) & 1);
    }
}

void MemoryController::ResetDevice(){
    //CMD 0xFF, wait
    
    bool DQOut[8];
    m_WE =1;
    m_CE = 0;
    m_WP =1;
    m_CLE = 0;
    m_RE = 1;
    setDQ(MemoryController::RESET, DQOut);
    for(int i = 0;i<8;i++){
        printf("%i\r\n",DQOut[i]);
    }
    //Set DQs
    DigitalOut dq1(m_DQ[0],DQOut[0]);
    DigitalOut dq2(m_DQ[1],DQOut[1]);
    DigitalOut dq3(m_DQ[2],DQOut[2]);
    DigitalOut dq4(m_DQ[3],DQOut[3]);
    DigitalOut dq5(m_DQ[4],DQOut[4]);
    DigitalOut dq6(m_DQ[5],DQOut[5]);
    DigitalOut dq7(m_DQ[6],DQOut[6]);
    DigitalOut dq8(m_DQ[7],DQOut[7]);
    wait(1);
    m_CLE =1;
    m_WE = 0;
    wait_ms(1);
    m_WE =1;
    wait_us(5);
    //m_CLE = 0;
    /*m_WE = 0;
    wait_us(1);
    m_WE = 1;
    wait_us(10);
    m_CLE = 0;
    m_CE = 1;*/
    //while(m_RDY ==1);
    while(m_RDY != 1){
        printf("Writing\r\n");
    }
    //setLogicStandby();
    printf("System Reset -- Ready to rock and roll\r\n");
}

void MemoryController::ReadPage(DataAddress &address, char *DataOut){
    //Start CMD 00, AADR c1, ADDR c2, ADDR r1, ADDR r2, ADDR r3, CMD 0x30, wait for rdy=1, data out
    while (m_RDY == 0);   //Bus is Busy, do not write yet
    startPageRead(address);
    //WriteAddressPage(address);
    //endPageRead();
    ReadData(DataOut);
    setLogicStandby();
    printf("Page Read Complete\r\n");
}

void MemoryController::sendPageData(char *DataIn){
    setLogicDataOut();
    DigitalOut dq1(m_DQ[0],0);
    DigitalOut dq2(m_DQ[1],0);
    DigitalOut dq3(m_DQ[2],0);
    DigitalOut dq4(m_DQ[3],0);
    DigitalOut dq5(m_DQ[4],0);
    DigitalOut dq6(m_DQ[5],0);
    DigitalOut dq7(m_DQ[6],0);
    DigitalOut dq8(m_DQ[7],0);
    wait_us(1);
    int time =1;
    Timer timer1;
    timer1.start();
    while(m_RDY == 0);
    for (int i=0;i < 4320;i++){
        bool DQOut[8];
        setDQ(DataIn[i], DQOut);
        dq1=DQOut[0];
        dq2=DQOut[1];
        dq3=DQOut[2];
        dq4=DQOut[3];
        dq5=DQOut[4];
        dq6=DQOut[5];
        dq7=DQOut[6];
        dq8=DQOut[7];
        m_WE = 0;
        while(timer1.read_us() < time);
        m_WE = 1;
        time++;
        while(timer1.read_us() < time);
        time++;
    }
}

void MemoryController::ReadData(char *DataOut){
    setLogicDataOut();
    DigitalIn dq1(m_DQ[0]);
    DigitalIn dq2(m_DQ[1]);
    DigitalIn dq3(m_DQ[2]);
    DigitalIn dq4(m_DQ[3]);
    DigitalIn dq5(m_DQ[4]);
    DigitalIn dq6(m_DQ[5]);
    DigitalIn dq7(m_DQ[6]);
    DigitalIn dq8(m_DQ[7]);
    Data dataOut;
    wait_us(1);
    while(m_RDY == 0);
    m_RE = 0;
    wait_us(1);
    int time =1;
    Timer timer1;
    timer1.start();
    for (int i=0;i < 4320;i++){
        m_RE = 1;
        dataOut.bits.dq1 = dq1;
        dataOut.bits.dq2 = dq2;
        dataOut.bits.dq3 = dq3;
        dataOut.bits.dq4 = dq4;
        dataOut.bits.dq5 = dq5;
        dataOut.bits.dq6 = dq6;
        dataOut.bits.dq7 = dq7;
        dataOut.bits.dq8 = dq8;
        DataOut[i] = dataOut.all;
        while(timer1.read_us()<time);
        m_RE = 0;
        time++;
        while(timer1.read_us() <time);
        time++;
    }
}

void MemoryController::startPageRead(DataAddress &address){
    bool DQOut[8];
    Timer timer1;
    timer1.start();
    setDQ(MemoryController::READADDRINIT, DQOut);
    setLogicCommandInput();
    m_WE =1;
    while (timer1.read_us() < 1);
    //Set DQs
    DigitalOut dq1(m_DQ[0],DQOut[0]);
    DigitalOut dq2(m_DQ[1],DQOut[1]);
    DigitalOut dq3(m_DQ[2],DQOut[2]);
    DigitalOut dq4(m_DQ[3],DQOut[3]);
    DigitalOut dq5(m_DQ[4],DQOut[4]);
    DigitalOut dq6(m_DQ[5],DQOut[5]);
    DigitalOut dq7(m_DQ[6],DQOut[6]);
    DigitalOut dq8(m_DQ[7],0);
    m_WE = 0;
    while (timer1.read_us() < 2);
    wait_us(30);
    m_WE = 1;
    while(timer1.read_us() < 3);
    m_WE=0;
    setLogicAddressInput();
    //collumn 1
    setDQ(address.col1, DQOut);
    dq1 = DQOut[0];
    dq2 = DQOut[1];
    dq3 = DQOut[2];
    dq4 = DQOut[3];
    dq5 = DQOut[4];
    dq6 = DQOut[5];
    dq7 = DQOut[6];
    dq8 = DQOut[7];
    while(timer1.read_us() < 5);
    m_WE = 1;
    while(timer1.read_us() < 6);
    m_WE = 0;
    
    //collumn 2
    setDQ(address.col2, DQOut);
    dq1 = DQOut[0];
    dq2 = DQOut[1];
    dq3 = DQOut[2];
    dq4 = DQOut[3];
    dq5 = DQOut[4];
    dq6 = DQOut[5];
    dq7 = DQOut[6];
    dq8 = DQOut[7];
    while(timer1.read_us() < 7);
    m_WE = 1;
    while(timer1.read_us() < 8);
    m_WE =0;
    
    //page
    setDQ(address.page, DQOut);
    dq1 = DQOut[0];
    dq2 = DQOut[1];
    dq3 = DQOut[2];
    dq4 = DQOut[3];
    dq5 = DQOut[4];
    dq6 = DQOut[5];
    dq7 = DQOut[6];
    dq8 = DQOut[7];
    while(timer1.read_us() < 9);
    m_WE = 1;
    while(timer1.read_us() < 10);
    m_WE = 0;
    
    //Block1
    setDQ(address.block1, DQOut);
    dq1 = DQOut[0];
    dq2 = DQOut[1];
    dq3 = DQOut[2];
    dq4 = DQOut[3];
    dq5 = DQOut[4];
    dq6 = DQOut[5];
    dq7 = DQOut[6];
    dq8 = DQOut[7];
    while(timer1.read_us() < 11);
    m_WE = 1;
    while(timer1.read_us() < 12);
    m_WE = 0;
        
    //Block2
    setDQ(address.block2, DQOut);
    dq1 = DQOut[0];
    dq2 = DQOut[1];
    dq3 = DQOut[2];
    dq4 = DQOut[3];
    dq5 = DQOut[4];
    dq6 = DQOut[5];
    dq7 = DQOut[6];
    dq8 = DQOut[7];
    while(timer1.read_us() < 13);
    m_WE = 1;
    while(timer1.read_us() < 14);
    m_ALE = 0;
    wait_us(1);
    m_WE = 0;
    wait_us(1);
    //setLogicCommandInput();
    setDQ(MemoryController::READADDREND, DQOut);
    //Set DQs
    dq1 = DQOut[0];
    dq2 = DQOut[1];
    dq3 = DQOut[2];
    dq4 = DQOut[3];
    dq5 = DQOut[4];
    dq6 = DQOut[5];
    dq7 = DQOut[6];
    dq8 = DQOut[7];
    m_CLE = 1;
    wait_us(30);
    m_WE = 1;
    wait_us(10);
    //while(timer1.read_us() < 17);
}

void MemoryController::startPageWrite(DataAddress &address){
    bool DQOut[8];
    Timer timer1;
    timer1.start();
    setDQ(MemoryController::WRITEPAGEINIT, DQOut);
    setLogicCommandInput();
    m_WE =1;
    while (timer1.read_us() < 1);
    //Set DQs
    DigitalOut dq1(m_DQ[0],DQOut[0]);
    DigitalOut dq2(m_DQ[1],DQOut[1]);
    DigitalOut dq3(m_DQ[2],DQOut[2]);
    DigitalOut dq4(m_DQ[3],DQOut[3]);
    DigitalOut dq5(m_DQ[4],DQOut[4]);
    DigitalOut dq6(m_DQ[5],DQOut[5]);
    DigitalOut dq7(m_DQ[6],DQOut[6]);
    DigitalOut dq8(m_DQ[7],DQOut[7]);
    m_WE = 0;
    while (timer1.read_us() < 2);
    m_WE = 1;
    while(timer1.read_us() < 3);
    setLogicAddressInput();
    m_WE=0;
    //collumn 1
    setDQ(address.col1, DQOut);
    dq1 = DQOut[0];
    dq2 = DQOut[1];
    dq3 = DQOut[2];
    dq4 = DQOut[3];
    dq5 = DQOut[4];
    dq6 = DQOut[5];
    dq7 = DQOut[6];
    dq8 = DQOut[7];
    while(timer1.read_us() < 5);
    m_WE = 1;
    while(timer1.read_us() < 6);
    m_WE = 0;
    
    //collumn 2
    setDQ(address.col2, DQOut);
    dq1 = DQOut[0];
    dq2 = DQOut[1];
    dq3 = DQOut[2];
    dq4 = DQOut[3];
    dq5 = DQOut[4];
    dq6 = DQOut[5];
    dq7 = DQOut[6];
    dq8 = DQOut[7];
    while(timer1.read_us() < 7);
    m_WE = 1;
    while(timer1.read_us() < 8);
    m_WE =0;
    
    //page
    setDQ(address.page, DQOut);
    dq1 = DQOut[0];
    dq2 = DQOut[1];
    dq3 = DQOut[2];
    dq4 = DQOut[3];
    dq5 = DQOut[4];
    dq6 = DQOut[5];
    dq7 = DQOut[6];
    dq8 = DQOut[7];
    while(timer1.read_us() < 9);
    m_WE = 1;
    while(timer1.read_us() < 10);
    m_WE = 0;
    
    //Block1
    setDQ(address.block1, DQOut);
    dq1 = DQOut[0];
    dq2 = DQOut[1];
    dq3 = DQOut[2];
    dq4 = DQOut[3];
    dq5 = DQOut[4];
    dq6 = DQOut[5];
    dq7 = DQOut[6];
    dq8 = DQOut[7];
    while(timer1.read_us() < 11);
    m_WE = 1;
    while(timer1.read_us() < 12);
    m_WE = 0;
        
    //Block2
    setDQ(address.block2, DQOut);
    dq1 = DQOut[0];
    dq2 = DQOut[1];
    dq3 = DQOut[2];
    dq4 = DQOut[3];
    dq5 = DQOut[4];
    dq6 = DQOut[5];
    dq7 = DQOut[6];
    dq8 = DQOut[7];
    while(timer1.read_us() < 13);
    m_WE = 1;
    while(timer1.read_us() < 14);
}

void MemoryController::endPageRead(){
    bool DQOut[8];
    Timer timer1;
    setDQ(MemoryController::READADDREND, DQOut);
    setLogicCommandInput();
    timer1.start();
    //Set DQs
    DigitalOut dq1(m_DQ[0],DQOut[0]);
    DigitalOut dq2(m_DQ[1],DQOut[1]);
    DigitalOut dq3(m_DQ[2],DQOut[2]);
    DigitalOut dq4(m_DQ[3],DQOut[3]);
    DigitalOut dq5(m_DQ[4],DQOut[4]);
    DigitalOut dq6(m_DQ[5],DQOut[5]);
    DigitalOut dq7(m_DQ[6],DQOut[6]);
    DigitalOut dq8(m_DQ[7],DQOut[7]);
    while(timer1.read_us() < 1);
    m_WE = 1;
    while(timer1.read_us() < 2);
}

void MemoryController::endPageWrite(){
    bool DQOut[8];
    Timer timer1;
    setDQ(MemoryController::WRITEPAGEEND, DQOut);
    setLogicCommandInput();
    timer1.start();
    //Set DQs
    DigitalOut dq1(m_DQ[0],DQOut[0]);
    DigitalOut dq2(m_DQ[1],DQOut[1]);
    DigitalOut dq3(m_DQ[2],DQOut[2]);
    DigitalOut dq4(m_DQ[3],DQOut[3]);
    DigitalOut dq5(m_DQ[4],DQOut[4]);
    DigitalOut dq6(m_DQ[5],DQOut[5]);
    DigitalOut dq7(m_DQ[6],DQOut[6]);
    DigitalOut dq8(m_DQ[7],DQOut[7]);
    while(timer1.read_us() < 1);
    m_WE = 1;
    while(timer1.read_us() < 2);
}

void MemoryController::WriteAddressBlock(DataAddress &address){
    
}

void MemoryController::WriteAddressPage(DataAddress &address){
    bool DQOut[8];
    Timer timer1;
    timer1.start();
    
    //collumn 1
    setDQ(address.col1, DQOut);
    setLogicAddressInput();
    DigitalOut dq1(m_DQ[0],DQOut[0]);
    DigitalOut dq2(m_DQ[1],DQOut[1]);
    DigitalOut dq3(m_DQ[2],DQOut[2]);
    DigitalOut dq4(m_DQ[3],DQOut[3]);
    DigitalOut dq5(m_DQ[4],DQOut[4]);
    DigitalOut dq6(m_DQ[5],DQOut[5]);
    DigitalOut dq7(m_DQ[6],DQOut[6]);
    DigitalOut dq8(m_DQ[7],DQOut[7]);
    while(timer1.read_us() < 1);
    m_WE = 1;
    while(timer1.read_us() < 2);
    m_WE = 0;
    
    //collumn 2
    setDQ(address.col2, DQOut);
    setLogicAddressInput();
    dq1 = DQOut[0];
    dq2 = DQOut[1];
    dq3 = DQOut[2];
    dq4 = DQOut[3];
    dq5 = DQOut[4];
    dq6 = DQOut[5];
    dq7 = DQOut[6];
    dq8 = DQOut[7];
    while(timer1.read_us() < 3);
    m_WE = 1;
    while(timer1.read_us() < 4);
    m_WE =0;
    
    //page
    setDQ(address.page, DQOut);
    setLogicAddressInput();
    dq1 = DQOut[0];
    dq2 = DQOut[1];
    dq3 = DQOut[2];
    dq4 = DQOut[3];
    dq5 = DQOut[4];
    dq6 = DQOut[5];
    dq7 = DQOut[6];
    dq8 = DQOut[7];
    while(timer1.read_us() < 5);
    m_WE = 1;
    while(timer1.read_us() < 6);
    m_WE = 0;
    
    //Block1
    setDQ(address.block1, DQOut);
    setLogicAddressInput();
    dq1 = DQOut[0];
    dq2 = DQOut[1];
    dq3 = DQOut[2];
    dq4 = DQOut[3];
    dq5 = DQOut[4];
    dq6 = DQOut[5];
    dq7 = DQOut[6];
    dq8 = DQOut[7];
    while(timer1.read_us() < 7);
    m_WE = 1;
    while(timer1.read_us() < 8);
    m_WE = 0;
        
    //Block2
    setDQ(address.block2, DQOut);
    setLogicAddressInput();
    dq1 = DQOut[0];
    dq2 = DQOut[1];
    dq3 = DQOut[2];
    dq4 = DQOut[3];
    dq5 = DQOut[4];
    dq6 = DQOut[5];
    dq7 = DQOut[6];
    dq8 = DQOut[7];
    while(timer1.read_us() < 9);
    m_WE = 1;
    while(timer1.read_us() < 10);
    m_WE = 0;
    
}
    
void MemoryController::ProgramPage(DataAddress &address, char *DataIn){
    //CMD 0x80, AADR c1, ADDR c2, ADDR r1, ADDR r2, ADDR r3, Page Data, CMD 0x10
    while (m_RDY == 0);
    startPageWrite(address);
    //WriteAddressPage(address);
    sendPageData(DataIn);
    endPageWrite();
    setLogicStandby();
    printf("Page Write Complete\r\n");
    
}

void MemoryController::EraseBlock(DataAddress &address){
    //CMD 0x60, ADDR R1, ADDR r2, ADDR r3, CMD oxD1
    while (m_RDY == 0);
    
    
}

void MemoryController::setLogicStandby(){
    m_CE = 1;
    m_CLE = 0;
    m_ALE = 0;
    m_WE = 0;
    m_RE = 0;
    m_WP = 0;
}
    
void MemoryController::setLogicBusIdle(){
    m_CE = 0;
    m_CLE = 0;
    m_ALE = 0;
    m_WE = 1;
    m_RE = 1;
    m_WP = 0;
}
    
void MemoryController::setLogicCommandInput(){
    m_CE = 0;
    m_CLE = 1;
    m_ALE = 0;
    m_WE = 0;   //rising edge
    m_RE = 1;
    m_WP = 1; 
}
    
void MemoryController::setLogicAddressInput(){
    m_CE = 0;
    m_CLE = 0;
    m_ALE = 1;
    m_WE = 0;   //rising edge
    m_RE = 1;
    m_WP = 1;    
}
    
void MemoryController::setLogicDataInput(){
    m_CE = 0;
    m_CLE = 0;
    m_ALE = 0;
    m_WE = 1;   //rising edge
    m_RE = 1;
    m_WP = 1;    
}
    
void MemoryController::setLogicDataOut(){
    m_CE = 0;
    m_CLE = 0;
    m_ALE = 0;
    m_WE = 1;
    m_RE = 1;   //falling edge
    m_WP = 0;   
}
    
void MemoryController::setLogicWriteProtect(){
    m_CE = 0;
    m_CLE = 0;
    m_ALE = 0;
    m_WE = 0;
    m_RE = 0;
    m_WP = 0;        
}