// ALO-095BWNN-J9 test program
// See also "http://www.aitendo.co.jp/product/2099"


#include "mbed.h"
#include "spioled.h"
#define countof(x) ( sizeof(x) / sizeof(x[0]) )

SPIOLED oled(p21, p22, p23, p5, p6, p7);    //cs res dc mosi miso sck

bool kstate = false;
unsigned int kbuf;
unsigned char x_locale = 0;
unsigned char y_locale = 0;


unsigned int findface(unsigned short c){
    unsigned int p = 0;
    int i, sum;
    for(sum = i = 0; i < countof(font8table); i++){
        if(font8table[i].start <= c && c <= font8table[i].end){
            p = (sum + c - font8table[i].start);
            break;
        }
        sum += font8table[i].end - font8table[i].start + 1;
    }
    return p;
}

void drawc(unsigned char c){
    if(kstate){ // 2nd byte of shift-jis
        kstate = false;
        unsigned int p = findface(kbuf << 8 | c);
        oled.PutChar( x_locale , y_locale ,p);
        //   printf("%x %x\r\n",( kbuf << 8 | c),p); //for debug
        x_locale += X_Witch;
        if(x_locale + (X_Witch - 1) >= Dis_X_MAX){
            x_locale = 0;
            y_locale += Y_Witch;
            if(y_locale >= Dis_Y_MAX)y_locale=0;
        }
            
    } else if((0x81 <= c && c <= 0x9f) || (0xe0 <= c && c <= 0xfc)){ // 1st byte of shift-jis
        kstate = true;
        kbuf = c;
    } else {        
        oled.PutChar_ABC( x_locale , y_locale ,c);
        x_locale += 6;
        if(x_locale + (X_Witch - 1) >= Dis_X_MAX){
            x_locale = 0;
            y_locale += Y_Witch;
            if(y_locale >= Dis_Y_MAX)y_locale=0;
        }
    }
       
}

void draws(unsigned char x, unsigned char y, char *s){
    unsigned char c;
    x_locale = x;
    y_locale = y;
    while((c = *s++) != '\0')drawc(c);
}
    
    
    
int main() {
    LocalFileSystem local( "local" );
    char            s[ 256 ];
    FILE            *fp;

    printf( "\r\nreading a message file.\r\n" );

    if ( NULL == (fp = fopen( "/local/test.txt", "r" )) ) {
        printf( "\r\nError: The message file cannot be accessed\r\n" );
        return -1;
    }

    fgets( s, 256, fp );
    fclose( fp );
    
      

   
while(1){
  //  OLED_Init();

    oled.Full_Screen(0x0018);    //full red color in OLED
 //   wait_ms(500);
    oled.Full_Screen(0x07e0);    //full green color in OLED
 //   wait_ms(500);
    oled.Full_Screen(0xf800);    //full blue color in OLED
 //   wait_ms(500);
    oled.Full_Screen(0xffff);    //full white color in OLED
    wait_ms(500);

    
    

    oled.ChangeFontColor(0);
    draws(1,0,s);    
    wait_ms(5000);
    oled.Full_Screen(0);
    oled.ChangeFontColor(0xffff);
    draws(1,0,s);    
    wait_ms(5000);
    }
}
