/* DPCM & Rice Golomb Lossless Audio Player and Realtime encoder */
#include "SDHCFileSystem.h"
#include "mbed.h"
#include "string"
#include "_bitio.h"

//FILE    *infp,*outfp;
SDFileSystem sd(p5, p6, p7, p8, "sd");
DigitalOut led1(LED1);
DigitalOut led2(LED2);
AnalogOut DACout(p18);
Ticker tick;

// BU9480F define
SPI bu9480f(p11,p12,p13);
DigitalOut LRCLK(p14);
// BU9480F define.end


// a FIFO for the DAC
#define TXFIFO_FULL 1
#define RAM_LENGTH 8192//8192
#define RAM_LIMIT (RAM_LENGTH - 1) 
volatile short DAC_fifo[RAM_LENGTH];
volatile short DAC_wptr=0;
volatile short DAC_rptr=0;
volatile short DAC_on;
volatile short DAC_diff=0;

void dac_out()
{
  //  printf("\t%d\r\n",DAC_diff);
    if (DAC_diff > 1) {
        led2 = 0;        
        
        LRCLK = 0;
        bu9480f.write(DAC_fifo[DAC_rptr++]);
        DAC_rptr &= RAM_LIMIT;
        
        LRCLK = 1;
        bu9480f.write(DAC_fifo[DAC_rptr++]);
        DAC_rptr &= RAM_LIMIT;
        
        DAC_diff-=2;
        
   }else led2 = 1;
}

void encode(long int n){
    int zero_shift = 0;
    
    if(n < 0){
        putbit(0);                    // sign (put 0:if n as negative)
        n = -n;                        // n = abs(n)
        //printf("\t 0");
    }
    else{ 
        putbit(1);                    // sign (put 1:if n as positive)
        //printf("\t 1");
    }
    zero_shift = (n >> (k));
    //printf("\t shift= %d",zero_shift);
    while(zero_shift > 0){

        zero_shift--;
        putbit(0);
    }    // put n/(2^k) 0's
    
    putbit(1);                        // terminating "1"
    putbits(k,rightbits(k,n));
    //printf("\t finish= %d \r\n",(n & ((1U<<k)-1)));
}



void decode(void){
    //short dac_data;
    long int decode_buff;
    short diff,diff2;
    unsigned int buff_sign,zero_shift;
    //char flag;
    
    diff = 0;
    diff2 = 0;
    // get sign(1 for positive, 0 for negative)
    while(1){
        
        if((buff_sign = getbit())==OVERRUN)break;
        zero_shift = 0;
        while(getbit()==0)zero_shift++;
        
        decode_buff = (signed int)((1U << k)*zero_shift);
        decode_buff += (getbits(k));
        
        if(!buff_sign)decode_buff =- decode_buff;
        /* return decode_buff; */
        diff =(diff + decode_buff);
        DAC_fifo[DAC_wptr++]=(short)diff;
        DAC_wptr &= RAM_LIMIT;
        //DAC_diff++;
        while (DAC_diff > RAM_LIMIT){
            led1 = 1;
        }   //wait
        led1=0;
        
        if((buff_sign = getbit())==OVERRUN)break;
        zero_shift = 0;
        while(getbit()==0)zero_shift++;
        
        decode_buff = (signed int)((1U << k)*zero_shift);
        decode_buff += (getbits(k));
        
        if(!buff_sign)decode_buff =- decode_buff;
        /* return decode_buff; */
        diff2 =(diff2 + decode_buff);

        DAC_fifo[DAC_wptr++]=(short)diff2;
        DAC_wptr &= RAM_LIMIT;
        DAC_diff+=2;
        
        while (DAC_diff > RAM_LIMIT){
            led1 = 1;
        }   //wait
        led1=0;
        
    
         
    }
}

  
int main() {

    
    if ( NULL == (infp = fopen( "/sd/test.rgm", "rb" )) ) {
        printf( "\r\nError: The message file cannot be accessed\r\n" );
        return -1;
    }
    // bu9480f init
    bu9480f.format(16,0);
    bu9480f.frequency(16000000); //16MHz
    // bu9480f init.end
    
      
    tick.attach_us(&dac_out, 41); //set 24.000kHz sampling data   
    decode();
    tick.detach();    
        
    fclose( infp );
    //fclose( outfp );  

 
    
    while (1);
}

