static const char FontLookup_ABC[][5] =
{
  { 0x00, 0x00, 0x00, 0x00, 0x00 }, // sp
  { 0x00, 0x00, 0x2f, 0x00, 0x00 }, // ! 
  { 0x00, 0x07, 0x00, 0x07, 0x00 }, // "
  { 0x14, 0x7f, 0x14, 0x7f, 0x14 }, // #
  { 0x24, 0x2a, 0x7f, 0x2a, 0x12 }, // $
  { 0xc4, 0xc8, 0x10, 0x26, 0x46 }, // %
  { 0x36, 0x49, 0x55, 0x22, 0x50 }, // &
  { 0x00, 0x05, 0x03, 0x00, 0x00 }, // '
  { 0x00, 0x1c, 0x22, 0x41, 0x00 }, // (
  { 0x00, 0x41, 0x22, 0x1c, 0x00 }, // )
  { 0x14, 0x08, 0x3E, 0x08, 0x14 }, // *
  { 0x08, 0x08, 0x3E, 0x08, 0x08 }, // +
  { 0x00, 0x00, 0x50, 0x30, 0x00 }, // ,
  { 0x10, 0x10, 0x10, 0x10, 0x10 }, // -
  { 0x00, 0x60, 0x60, 0x00, 0x00 }, // .
  { 0x20, 0x10, 0x08, 0x04, 0x02 }, // /
  { 0x3E, 0x51, 0x49, 0x45, 0x3E }, // 0
  { 0x00, 0x42, 0x7F, 0x40, 0x00 }, // 1
  { 0x42, 0x61, 0x51, 0x49, 0x46 }, // 2
  { 0x21, 0x41, 0x45, 0x4B, 0x31 }, // 3
  { 0x18, 0x14, 0x12, 0x7F, 0x10 }, // 4  
  { 0x27, 0x45, 0x45, 0x45, 0x39 }, // 5
  { 0x3C, 0x4A, 0x49, 0x49, 0x30 }, // 6
  { 0x01, 0x71, 0x09, 0x05, 0x03 }, // 7
  { 0x36, 0x49, 0x49, 0x49, 0x36 }, // 8
  { 0x06, 0x49, 0x49, 0x29, 0x1E }, // 9
  { 0x00, 0x36, 0x36, 0x00, 0x00 }, // :
  { 0x00, 0x56, 0x36, 0x00, 0x00 }, // ;
  { 0x08, 0x14, 0x22, 0x41, 0x00 }, // <
  { 0x14, 0x14, 0x14, 0x14, 0x14 }, // =
  { 0x00, 0x41, 0x22, 0x14, 0x08 }, // >
  { 0x02, 0x01, 0x51, 0x09, 0x06 }, // ?
  { 0x32, 0x49, 0x59, 0x51, 0x3E }, // @
  { 0x7E, 0x11, 0x11, 0x11, 0x7E }, // A
  { 0x7F, 0x49, 0x49, 0x49, 0x36 }, // B
  { 0x3E, 0x41, 0x41, 0x41, 0x22 }, // C
  { 0x7F, 0x41, 0x41, 0x22, 0x1C }, // D
  { 0x7F, 0x49, 0x49, 0x49, 0x41 }, // E
  { 0x7F, 0x09, 0x09, 0x09, 0x01 }, // F
  { 0x3E, 0x41, 0x49, 0x49, 0x7A }, // G
  { 0x7F, 0x08, 0x08, 0x08, 0x7F }, // H
  { 0x00, 0x41, 0x7F, 0x41, 0x00 }, // I
  { 0x20, 0x40, 0x41, 0x3F, 0x01 }, // J
  { 0x7F, 0x08, 0x14, 0x22, 0x41 }, // K
  { 0x7F, 0x40, 0x40, 0x40, 0x40 }, // L
  { 0x7F, 0x02, 0x0C, 0x02, 0x7F }, // M
  { 0x7F, 0x04, 0x08, 0x10, 0x7F }, // N
  { 0x3E, 0x41, 0x41, 0x41, 0x3E }, // O
  { 0x7F, 0x09, 0x09, 0x09, 0x06 }, // P
  { 0x3E, 0x41, 0x51, 0x21, 0x5E }, // Q
  { 0x7F, 0x09, 0x19, 0x29, 0x46 }, // R
  { 0x46, 0x49, 0x49, 0x49, 0x31 }, // S
  { 0x01, 0x01, 0x7F, 0x01, 0x01 }, // T
  { 0x3F, 0x40, 0x40, 0x40, 0x3F }, // U
  { 0x1F, 0x20, 0x40, 0x20, 0x1F }, // V
  { 0x3F, 0x40, 0x38, 0x40, 0x3F }, // W
  { 0x63, 0x14, 0x08, 0x14, 0x63 }, // X
  { 0x07, 0x08, 0x70, 0x08, 0x07 }, // Y
  { 0x61, 0x51, 0x49, 0x45, 0x43 }, // Z
  { 0x00, 0x7F, 0x41, 0x41, 0x00 }, // [
  { 0x55, 0x2A, 0x55, 0x2A, 0x55 }, // 55
  { 0x00, 0x41, 0x41, 0x7F, 0x00 }, // ]
  { 0x04, 0x02, 0x01, 0x02, 0x04 }, // ^
  { 0x40, 0x40, 0x40, 0x40, 0x40 }, // _
  { 0x00, 0x01, 0x02, 0x04, 0x00 }, // '
  { 0x20, 0x54, 0x54, 0x54, 0x78 }, // a
  { 0x7F, 0x48, 0x44, 0x44, 0x38 }, // b
  { 0x38, 0x44, 0x44, 0x44, 0x20 }, // c
  { 0x38, 0x44, 0x44, 0x48, 0x7F }, // d
  { 0x38, 0x54, 0x54, 0x54, 0x18 }, // e
  { 0x08, 0x7E, 0x09, 0x01, 0x02 }, // f
  { 0x0C, 0x52, 0x52, 0x52, 0x3E }, // g
  { 0x7F, 0x08, 0x04, 0x04, 0x78 }, // h
  { 0x00, 0x44, 0x7D, 0x40, 0x00 }, // i
  { 0x20, 0x40, 0x44, 0x3D, 0x00 }, // j
  { 0x7F, 0x10, 0x28, 0x44, 0x00 }, // k
  { 0x00, 0x41, 0x7F, 0x40, 0x00 }, // l
  { 0x7C, 0x04, 0x18, 0x04, 0x78 }, // m
  { 0x7C, 0x08, 0x04, 0x04, 0x78 }, // n
  { 0x38, 0x44, 0x44, 0x44, 0x38 }, // o
  { 0x7C, 0x14, 0x14, 0x14, 0x08 }, // p
  { 0x08, 0x14, 0x14, 0x18, 0x7C }, // q
  { 0x7C, 0x08, 0x04, 0x04, 0x08 }, // r
  { 0x48, 0x54, 0x54, 0x54, 0x20 }, // s
  { 0x04, 0x3F, 0x44, 0x40, 0x20 }, // t
  { 0x3C, 0x40, 0x40, 0x20, 0x7C }, // u
  { 0x1C, 0x20, 0x40, 0x20, 0x1C }, // v
  { 0x3C, 0x40, 0x30, 0x40, 0x3C }, // w
  { 0x44, 0x28, 0x10, 0x28, 0x44 }, // x
  { 0x0C, 0x50, 0x50, 0x50, 0x3C }, // y
  { 0x44, 0x64, 0x54, 0x4C, 0x44 }  // z
};
const struct {
    unsigned short start, end;
} font8table[92] = {
    {0x8140, 0x817e},
    {0x8180, 0x81ac},
    {0x81b8, 0x81bf},
    {0x81c8, 0x81ce},
    {0x81da, 0x81e8},
    {0x81f0, 0x81f7},
    {0x81fc, 0x81fc},
    {0x824f, 0x8258},
    {0x8260, 0x8279},
    {0x8281, 0x829a},
    {0x829f, 0x82f1},
    {0x8340, 0x837e},
    {0x8380, 0x8396},
    {0x839f, 0x83b6},
    {0x83bf, 0x83d6},
    {0x8440, 0x8460},
    {0x8470, 0x847e},
    {0x8480, 0x8491},
    {0x849f, 0x84be},
    {0x8740, 0x875d},
    {0x875f, 0x8775},
    {0x877e, 0x877e},
    {0x8780, 0x879c},
    {0x889f, 0x88fc},
    {0x8940, 0x897e},
    {0x8980, 0x89fc},
    {0x8a40, 0x8a7e},
    {0x8a80, 0x8afc},
    {0x8b40, 0x8b7e},
    {0x8b80, 0x8bfc},
    {0x8c40, 0x8c7e},
    {0x8c80, 0x8cfc},
    {0x8d40, 0x8d7e},
    {0x8d80, 0x8dfc},
    {0x8e40, 0x8e7e},
    {0x8e80, 0x8efc},
    {0x8f40, 0x8f7e},
    {0x8f80, 0x8ffc},
    {0x9040, 0x907e},
    {0x9080, 0x90fc},
    {0x9140, 0x917e},
    {0x9180, 0x91fc},
    {0x9240, 0x927e},
    {0x9280, 0x92fc},
    {0x9340, 0x937e},
    {0x9380, 0x93fc},
    {0x9440, 0x947e},
    {0x9480, 0x94fc},
    {0x9540, 0x957e},
    {0x9580, 0x95fc},
    {0x9640, 0x967e},
    {0x9680, 0x96fc},
    {0x9740, 0x977e},
    {0x9780, 0x97fc},
    {0x9840, 0x9872},
    {0x989f, 0x98fc},
    {0x9940, 0x997e},
    {0x9980, 0x99fc},
    {0x9a40, 0x9a7e},
    {0x9a80, 0x9afc},
    {0x9b40, 0x9b7e},
    {0x9b80, 0x9bfc},
    {0x9c40, 0x9c7e},
    {0x9c80, 0x9cfc},
    {0x9d40, 0x9d7e},
    {0x9d80, 0x9dfc},
    {0x9e40, 0x9e7e},
    {0x9e80, 0x9efc},
    {0x9f40, 0x9f7e},
    {0x9f80, 0x9ffc},
    {0xe040, 0xe07e},
    {0xe080, 0xe0fc},
    {0xe140, 0xe17e},
    {0xe180, 0xe1fc},
    {0xe240, 0xe27e},
    {0xe280, 0xe2fc},
    {0xe340, 0xe37e},
    {0xe380, 0xe3fc},
    {0xe440, 0xe47e},
    {0xe480, 0xe4fc},
    {0xe540, 0xe57e},
    {0xe580, 0xe5fc},
    {0xe640, 0xe67e},
    {0xe680, 0xe6fc},
    {0xe740, 0xe77e},
    {0xe780, 0xe7fc},
    {0xe840, 0xe87e},
    {0xe880, 0xe8fc},
    {0xe940, 0xe97e},
    {0xe980, 0xe9fc},
    {0xea40, 0xea7e},
    {0xea80, 0xeaa4},
};
// converted MISAKI font
// Please refer to following URL for the MISAKI font. 
// http://www.geocities.jp/littlimi/misaki.htm
const unsigned char FontLookup[/*6962*/][8] = {
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},   // 00 0000 8140 Ã£â‚¬â‚¬
    {0x20, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},   // 00 0001 8141 Ã£â‚¬Â
    {0x20, 0x50, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00},   // 00 0002 8142 Ã£â‚¬â€š
    {0x50, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},   // 00 0003 8143 Ã¯Â¼Å’
    {0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},   // 00 0004 8144 Ã¯Â¼Å½
    {0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},   // 00 0005 8145 Ã£Æ’Â»
    {0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00},   // 00 0006 8146 Ã¯Â¼Å¡
    {0x00, 0x00, 0x56, 0x36, 0x00, 0x00, 0x00, 0x00},   // 00 0007 8147 Ã¯Â¼â€º
    {0x00, 0x02, 0x01, 0x51, 0x09, 0x09, 0x06, 0x00},   // 00 0008 8148 Ã¯Â¼Å¸
    {0x00, 0x00, 0x00, 0x5f, 0x00, 0x00, 0x00, 0x00},   // 00 0009 8149 Ã¯Â¼Â
    {0x01, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00},   // 00 000a 814a Ã£â€šâ€º
    {0x00, 0x02, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00},   // 00 000b 814b Ã£â€šÅ“
    {0x00, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00},   // 00 000c 814c Ã‚Â´
    {0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00},   // 00 000d 814d Ã¯Â½â‚¬
    {0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00},   // 00 000e 814e Ã‚Â¨
    {0x00, 0x00, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00},   // 00 000f 814f Ã¯Â¼Â¾
    {0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00},   // 00 0010 8150 Ã¯Â¿Â£
    {0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00},   // 00 0011 8151 Ã¯Â¼Â¿
    {0x00, 0x00, 0x04, 0x08, 0x30, 0x00, 0x00, 0x00},   // 00 0012 8152 Ã£Æ’Â½
    {0x00, 0x00, 0x04, 0x08, 0x31, 0x00, 0x01, 0x00},   // 00 0013 8153 Ã£Æ’Â¾
    {0x00, 0x00, 0x02, 0x24, 0x18, 0x10, 0x00, 0x00},   // 00 0014 8154 Ã£â€šÂ
    {0x00, 0x00, 0x02, 0x24, 0x19, 0x10, 0x01, 0x00},   // 00 0015 8155 Ã£â€šÅ¾
    {0x00, 0x20, 0x1c, 0x00, 0x20, 0x1c, 0x00, 0x00},   // 00 0016 8156 Ã£â‚¬Æ’
    {0x44, 0x4c, 0x4a, 0x79, 0x4a, 0x4c, 0x44, 0x00},   // 00 0017 8157 Ã¤Â»Â
    {0x00, 0x10, 0x08, 0x16, 0x24, 0x54, 0x0c, 0x00},   // 00 0018 8158 Ã£â‚¬â€¦
    {0x70, 0x28, 0x14, 0x08, 0x14, 0x02, 0x01, 0x00},   // 00 0019 8159 Ã£â‚¬â€ 
    {0x18, 0x24, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00},   // 00 001a 815a Ã£â‚¬â€¡
    {0x04, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00},   // 00 001b 815b Ã£Æ’Â¼
    {0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08},   // 00 001c 815c Ã¢â‚¬â€¢
    {0x00, 0x00, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00},   // 00 001d 815d Ã¢â‚¬Â
    {0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01, 0x00},   // 00 001e 815e Ã¯Â¼Â
    {0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00},   // 00 001f 815f Ã¯Â¼Â¼
    {0x08, 0x04, 0x04, 0x08, 0x10, 0x10, 0x08, 0x00},   // 00 0020 8160 Ã¯Â½Å¾
    {0x00, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x00, 0x00},   // 00 0021 8161 Ã¢Ë†Â¥
    {0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00},   // 00 0022 8162 Ã¯Â½Å“
    {0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00},   // 00 0023 8163 Ã¢â‚¬Â¦
    {0x00, 0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00},   // 00 0024 8164 Ã¢â‚¬Â¥
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x05, 0x00},   // 00 0025 8165 Ã¢â‚¬Ëœ
    {0x05, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},   // 00 0026 8166 Ã¢â‚¬â„¢
    {0x00, 0x00, 0x06, 0x05, 0x00, 0x06, 0x05, 0x00},   // 00 0027 8167 Ã¢â‚¬Å“
    {0x05, 0x03, 0x00, 0x05, 0x03, 0x00, 0x00, 0x00},   // 00 0028 8168 Ã¢â‚¬Â
    {0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x41, 0x00},   // 00 0029 8169 Ã¯Â¼Ë†
    {0x41, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00},   // 00 002a 816a Ã¯Â¼â€°
    {0x00, 0x00, 0x00, 0x3e, 0x22, 0x41, 0x41, 0x00},   // 00 002b 816b Ã£â‚¬â€
    {0x41, 0x41, 0x22, 0x3e, 0x00, 0x00, 0x00, 0x00},   // 00 002c 816c Ã£â‚¬â€¢
    {0x00, 0x00, 0x00, 0x00, 0x7f, 0x41, 0x41, 0x00},   // 00 002d 816d Ã¯Â¼Â»
    {0x41, 0x41, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00},   // 00 002e 816e Ã¯Â¼Â½
    {0x00, 0x00, 0x00, 0x08, 0x36, 0x41, 0x41, 0x00},   // 00 002f 816f Ã¯Â½â€º
    {0x41, 0x41, 0x36, 0x08, 0x00, 0x00, 0x00, 0x00},   // 00 0030 8170 Ã¯Â½Â
    {0x00, 0x00, 0x00, 0x08, 0x14, 0x22, 0x41, 0x00},   // 00 0031 8171 Ã£â‚¬Ë†
    {0x41, 0x22, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00},   // 00 0032 8172 Ã£â‚¬â€°
    {0x00, 0x08, 0x14, 0x2a, 0x55, 0x22, 0x41, 0x00},   // 00 0033 8173 Ã£â‚¬Å 
    {0x41, 0x22, 0x55, 0x2a, 0x14, 0x08, 0x00, 0x00},   // 00 0034 8174 Ã£â‚¬â€¹
    {0x00, 0x00, 0x00, 0x3f, 0x01, 0x01, 0x01, 0x00},   // 00 0035 8175 Ã£â‚¬Å’
    {0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00},   // 00 0036 8176 Ã£â‚¬Â
    {0x00, 0x00, 0x7f, 0x41, 0x7d, 0x05, 0x07, 0x00},   // 00 0037 8177 Ã£â‚¬Å½
    {0x70, 0x50, 0x5f, 0x41, 0x7f, 0x00, 0x00, 0x00},   // 00 0038 8178 Ã£â‚¬Â
    {0x00, 0x00, 0x00, 0x00, 0x7f, 0x63, 0x41, 0x00},   // 00 0039 8179 Ã£â‚¬Â
    {0x41, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00},   // 00 003a 817a Ã£â‚¬â€˜
    {0x08, 0x08, 0x08, 0x7f, 0x08, 0x08, 0x08, 0x00},   // 00 003b 817b Ã¯Â¼â€¹
    {0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00},   // 00 003c 817c Ã¯Â¼Â
    {0x44, 0x44, 0x44, 0x5f, 0x44, 0x44, 0x44, 0x00},   // 00 003d 817d Ã‚Â±
    {0x41, 0x22, 0x14, 0x08, 0x14, 0x22, 0x41, 0x00},   // 00 003e 817e Ãƒâ€”
    {0x08, 0x08, 0x08, 0x2a, 0x08, 0x08, 0x08, 0x00},   // 01 003f 8180 ÃƒÂ·
    {0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00},   // 01 0040 8181 Ã¯Â¼Â
    {0x14, 0x34, 0x14, 0x1c, 0x14, 0x16, 0x14, 0x00},   // 01 0041 8182 Ã¢â€°Â 
    {0x08, 0x08, 0x14, 0x14, 0x14, 0x22, 0x22, 0x00},   // 01 0042 8183 Ã¯Â¼Å“
    {0x22, 0x22, 0x14, 0x14, 0x14, 0x08, 0x08, 0x00},   // 01 0043 8184 Ã¯Â¼Å¾
    {0x44, 0x44, 0x4a, 0x4a, 0x4a, 0x51, 0x51, 0x00},   // 01 0044 8185 Ã¢â€°Â¦
    {0x51, 0x51, 0x4a, 0x4a, 0x4a, 0x44, 0x44, 0x00},   // 01 0045 8186 Ã¢â€°Â§
    {0x1c, 0x22, 0x22, 0x1c, 0x22, 0x22, 0x1c, 0x00},   // 01 0046 8187 Ã¢Ë†Å¾
    {0x00, 0x20, 0x00, 0x02, 0x00, 0x20, 0x00, 0x00},   // 01 0047 8188 Ã¢Ë†Â´
    {0x30, 0x48, 0x48, 0x39, 0x05, 0x03, 0x0f, 0x00},   // 01 0048 8189 Ã¢â„¢â€š
    {0x00, 0x26, 0x29, 0x79, 0x29, 0x26, 0x00, 0x00},   // 01 0049 818a Ã¢â„¢â‚¬
    {0x02, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00},   // 01 004a 818b Ã‚Â°
    {0x06, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00},   // 01 004b 818c Ã¢â‚¬Â²
    {0x06, 0x03, 0x01, 0x06, 0x03, 0x01, 0x00, 0x00},   // 01 004c 818d Ã¢â‚¬Â³
    {0x02, 0x05, 0x02, 0x3c, 0x42, 0x42, 0x24, 0x00},   // 01 004d 818e Ã¢â€žÆ’
    {0x00, 0x2b, 0x2c, 0x78, 0x2c, 0x2b, 0x00, 0x00},   // 01 004e 818f Ã¯Â¿Â¥
    {0x00, 0x24, 0x2a, 0x7a, 0x2f, 0x2a, 0x12, 0x00},   // 01 004f 8190 Ã¯Â¼â€ž
    {0x00, 0x1c, 0x62, 0x32, 0x2e, 0x23, 0x14, 0x00},   // 01 0050 8191 Ã¯Â¿Â 
    {0x20, 0x54, 0x5e, 0x25, 0x41, 0x42, 0x20, 0x00},   // 01 0051 8192 Ã¯Â¿Â¡
    {0x42, 0x25, 0x12, 0x08, 0x24, 0x52, 0x21, 0x00},   // 01 0052 8193 Ã¯Â¼â€¦
    {0x20, 0x62, 0x3e, 0x63, 0x3e, 0x23, 0x02, 0x00},   // 01 0053 8194 Ã¯Â¼Æ’
    {0x20, 0x56, 0x49, 0x55, 0x22, 0x58, 0x40, 0x00},   // 01 0054 8195 Ã¯Â¼â€ 
    {0x00, 0x22, 0x14, 0x7f, 0x14, 0x22, 0x00, 0x00},   // 01 0055 8196 Ã¯Â¼Å 
    {0x1c, 0x22, 0x59, 0x55, 0x4d, 0x12, 0x0c, 0x00},   // 01 0056 8197 Ã¯Â¼Â 
    {0x00, 0x00, 0x4a, 0x55, 0x55, 0x29, 0x00, 0x00},   // 01 0057 8198 Ã‚Â§
    {0x04, 0x64, 0x3c, 0x17, 0x3c, 0x64, 0x04, 0x00},   // 01 0058 8199 Ã¢Ëœâ€ 
    {0x04, 0x64, 0x3c, 0x1f, 0x3c, 0x64, 0x04, 0x00},   // 01 0059 819a Ã¢Ëœâ€¦
    {0x1c, 0x22, 0x41, 0x41, 0x41, 0x22, 0x1c, 0x00},   // 01 005a 819b Ã¢â€”â€¹
    {0x1c, 0x3e, 0x7f, 0x7f, 0x7f, 0x3e, 0x1c, 0x00},   // 01 005b 819c Ã¢â€”Â
    {0x1c, 0x22, 0x5d, 0x55, 0x5d, 0x22, 0x1c, 0x00},   // 01 005c 819d Ã¢â€”Å½
    {0x08, 0x14, 0x22, 0x41, 0x22, 0x14, 0x08, 0x00},   // 01 005d 819e Ã¢â€”â€¡
    {0x08, 0x1c, 0x3e, 0x7f, 0x3e, 0x1c, 0x08, 0x00},   // 01 005e 819f Ã¢â€”â€ 
    {0x7f, 0x41, 0x41, 0x41, 0x41, 0x41, 0x7f, 0x00},   // 01 005f 81a0 Ã¢â€“Â¡
    {0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x00},   // 01 0060 81a1 Ã¢â€“Â 
    {0x40, 0x70, 0x4c, 0x43, 0x4c, 0x70, 0x40, 0x00},   // 01 0061 81a2 Ã¢â€“Â³
    {0x40, 0x70, 0x7c, 0x7f, 0x7c, 0x70, 0x40, 0x00},   // 01 0062 81a3 Ã¢â€“Â²
    {0x01, 0x07, 0x19, 0x61, 0x19, 0x07, 0x01, 0x00},   // 01 0063 81a4 Ã¢â€“Â½
    {0x01, 0x07, 0x1f, 0x7f, 0x1f, 0x07, 0x01, 0x00},   // 01 0064 81a5 Ã¢â€“Â¼
    {0x49, 0x22, 0x14, 0x49, 0x14, 0x22, 0x49, 0x00},   // 01 0065 81a6 Ã¢â‚¬Â»
    {0x05, 0x05, 0x05, 0x7d, 0x05, 0x05, 0x05, 0x00},   // 01 0066 81a7 Ã£â‚¬â€™
    {0x08, 0x08, 0x08, 0x08, 0x2a, 0x1c, 0x08, 0x00},   // 01 0067 81a8 Ã¢â€ â€™
    {0x08, 0x1c, 0x2a, 0x08, 0x08, 0x08, 0x08, 0x00},   // 01 0068 81a9 Ã¢â€ Â
    {0x00, 0x04, 0x02, 0x7f, 0x02, 0x04, 0x00, 0x00},   // 01 0069 81aa Ã¢â€ â€˜
    {0x00, 0x10, 0x20, 0x7f, 0x20, 0x10, 0x00, 0x00},   // 01 006a 81ab Ã¢â€ â€œ
    {0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x00},   // 01 006b 81ac Ã£â‚¬â€œ
    {0x00, 0x1c, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x00},   // 02 006c 81b8 Ã¢Ë†Ë†
    {0x00, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x1c, 0x00},   // 02 006d 81b9 Ã¢Ë†â€¹
    {0x00, 0x4e, 0x51, 0x51, 0x51, 0x51, 0x51, 0x00},   // 02 006e 81ba Ã¢Å â€ 
    {0x00, 0x51, 0x51, 0x51, 0x51, 0x51, 0x4e, 0x00},   // 02 006f 81bb Ã¢Å â€¡
    {0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00},   // 02 0070 81bc Ã¢Å â€š
    {0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00},   // 02 0071 81bd Ã¢Å Æ’
    {0x00, 0x1f, 0x20, 0x20, 0x20, 0x20, 0x1f, 0x00},   // 02 0072 81be Ã¢Ë†Âª
    {0x00, 0x7c, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x00},   // 02 0073 81bf Ã¢Ë†Â©
    {0x40, 0x30, 0x0c, 0x03, 0x0c, 0x30, 0x40, 0x00},   // 03 0074 81c8 Ã¢Ë†Â§
    {0x01, 0x06, 0x18, 0x60, 0x18, 0x06, 0x01, 0x00},   // 03 0075 81c9 Ã¢Ë†Â¨
    {0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x38, 0x00},   // 03 0076 81ca Ã¯Â¿Â¢
    {0x14, 0x14, 0x14, 0x14, 0x36, 0x14, 0x08, 0x00},   // 03 0077 81cb Ã¢â€¡â€™
    {0x08, 0x14, 0x36, 0x14, 0x36, 0x14, 0x08, 0x00},   // 03 0078 81cc Ã¢â€¡â€
    {0x03, 0x0c, 0x34, 0x44, 0x34, 0x0c, 0x03, 0x00},   // 03 0079 81cd Ã¢Ë†â‚¬
    {0x00, 0x49, 0x49, 0x49, 0x49, 0x49, 0x7f, 0x00},   // 03 007a 81ce Ã¢Ë†Æ’
    {0x00, 0x40, 0x60, 0x50, 0x48, 0x44, 0x42, 0x00},   // 04 007b 81da Ã¢Ë†Â 
    {0x40, 0x40, 0x40, 0x7e, 0x40, 0x40, 0x40, 0x00},   // 04 007c 81db Ã¢Å Â¥
    {0x00, 0x02, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00},   // 04 007d 81dc Ã¢Å’â€™
    {0x00, 0x30, 0x4a, 0x49, 0x31, 0x0e, 0x00, 0x00},   // 04 007e 81dd Ã¢Ë†â€š
    {0x03, 0x0d, 0x31, 0x41, 0x31, 0x0d, 0x03, 0x00},   // 04 007f 81de Ã¢Ë†â€¡
    {0x00, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x00},   // 04 0080 81df Ã¢â€°Â¡
    {0x14, 0x15, 0x14, 0x14, 0x14, 0x54, 0x14, 0x00},   // 04 0081 81e0 Ã¢â€°â€™
    {0x08, 0x14, 0x22, 0x49, 0x14, 0x22, 0x41, 0x00},   // 04 0082 81e1 Ã¢â€°Âª
    {0x41, 0x22, 0x14, 0x49, 0x22, 0x14, 0x08, 0x00},   // 04 0083 81e2 Ã¢â€°Â«
    {0x10, 0x70, 0x1c, 0x03, 0x01, 0x01, 0x01, 0x00},   // 04 0084 81e3 Ã¢Ë†Å¡
    {0x1c, 0x22, 0x20, 0x1c, 0x02, 0x22, 0x1c, 0x00},   // 04 0085 81e4 Ã¢Ë†Â½
    {0x1c, 0x22, 0x22, 0x1c, 0x22, 0x22, 0x14, 0x00},   // 04 0086 81e5 Ã¢Ë†Â
    {0x00, 0x02, 0x00, 0x20, 0x00, 0x02, 0x00, 0x00},   // 04 0087 81e6 Ã¢Ë†Âµ
    {0x00, 0x00, 0x46, 0x49, 0x31, 0x00, 0x00, 0x00},   // 04 0088 81e7 Ã¢Ë†Â«
    {0x00, 0x46, 0x49, 0x31, 0x46, 0x49, 0x31, 0x00},   // 04 0089 81e8 Ã¢Ë†Â¬
    {0x40, 0x30, 0x2a, 0x25, 0x2a, 0x30, 0x40, 0x00},   // 05 008a 81f0 Ãƒâ€¦
    {0x22, 0x15, 0x2a, 0x54, 0x22, 0x51, 0x20, 0x00},   // 05 008b 81f1 Ã¢â‚¬Â°
    {0x00, 0x28, 0x7e, 0x14, 0x14, 0x3f, 0x0a, 0x00},   // 05 008c 81f2 Ã¢â„¢Â¯
    {0x00, 0x00, 0x7f, 0x48, 0x24, 0x18, 0x00, 0x00},   // 05 008d 81f3 Ã¢â„¢Â­
    {0x00, 0x60, 0x70, 0x3f, 0x02, 0x0c, 0x00, 0x00},   // 05 008e 81f4 Ã¢â„¢Âª
    {0x00, 0x00, 0x02, 0x7f, 0x02, 0x00, 0x00, 0x00},   // 05 008f 81f5 Ã¢â‚¬Â 
    {0x00, 0x00, 0x22, 0x7f, 0x22, 0x00, 0x00, 0x00},   // 05 0090 81f6 Ã¢â‚¬Â¡
    {0x00, 0x06, 0x0f, 0x7f, 0x01, 0x7f, 0x00, 0x00},   // 05 0091 81f7 Ã‚Â¶
    {0x3e, 0x41, 0x41, 0x41, 0x41, 0x41, 0x3e, 0x00},   // 06 0092 81fc Ã¢â€”Â¯
    {0x00, 0x3e, 0x41, 0x41, 0x41, 0x41, 0x3e, 0x00},   // 07 0093 824f Ã¯Â¼Â
    {0x00, 0x00, 0x42, 0x7f, 0x40, 0x00, 0x00, 0x00},   // 07 0094 8250 Ã¯Â¼â€˜
    {0x00, 0x62, 0x51, 0x51, 0x49, 0x49, 0x46, 0x00},   // 07 0095 8251 Ã¯Â¼â€™
    {0x00, 0x22, 0x41, 0x49, 0x49, 0x49, 0x36, 0x00},   // 07 0096 8252 Ã¯Â¼â€œ
    {0x00, 0x30, 0x28, 0x24, 0x22, 0x7f, 0x20, 0x00},   // 07 0097 8253 Ã¯Â¼â€
    {0x00, 0x2f, 0x45, 0x45, 0x45, 0x45, 0x39, 0x00},   // 07 0098 8254 Ã¯Â¼â€¢
    {0x00, 0x3e, 0x49, 0x49, 0x49, 0x49, 0x32, 0x00},   // 07 0099 8255 Ã¯Â¼â€“
    {0x00, 0x01, 0x01, 0x61, 0x19, 0x05, 0x03, 0x00},   // 07 009a 8256 Ã¯Â¼â€”
    {0x00, 0x36, 0x49, 0x49, 0x49, 0x49, 0x36, 0x00},   // 07 009b 8257 Ã¯Â¼Ëœ
    {0x00, 0x26, 0x49, 0x49, 0x49, 0x49, 0x3e, 0x00},   // 07 009c 8258 Ã¯Â¼â„¢
    {0x60, 0x18, 0x16, 0x11, 0x16, 0x18, 0x60, 0x00},   // 08 009d 8260 Ã¯Â¼Â¡
    {0x00, 0x7f, 0x49, 0x49, 0x49, 0x49, 0x36, 0x00},   // 08 009e 8261 Ã¯Â¼Â¢
    {0x00, 0x1c, 0x22, 0x41, 0x41, 0x41, 0x22, 0x00},   // 08 009f 8262 Ã¯Â¼Â£
    {0x00, 0x7f, 0x41, 0x41, 0x41, 0x22, 0x1c, 0x00},   // 08 00a0 8263 Ã¯Â¼Â¤
    {0x00, 0x7f, 0x49, 0x49, 0x49, 0x49, 0x41, 0x00},   // 08 00a1 8264 Ã¯Â¼Â¥
    {0x00, 0x7f, 0x09, 0x09, 0x09, 0x09, 0x01, 0x00},   // 08 00a2 8265 Ã¯Â¼Â¦
    {0x00, 0x1c, 0x22, 0x41, 0x49, 0x49, 0x3a, 0x00},   // 08 00a3 8266 Ã¯Â¼Â§
    {0x00, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x7f, 0x00},   // 08 00a4 8267 Ã¯Â¼Â¨
    {0x00, 0x00, 0x41, 0x7f, 0x41, 0x00, 0x00, 0x00},   // 08 00a5 8268 Ã¯Â¼Â©
    {0x00, 0x20, 0x40, 0x40, 0x40, 0x40, 0x3f, 0x00},   // 08 00a6 8269 Ã¯Â¼Âª
    {0x00, 0x7f, 0x10, 0x08, 0x14, 0x22, 0x41, 0x00},   // 08 00a7 826a Ã¯Â¼Â«
    {0x00, 0x7f, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00},   // 08 00a8 826b Ã¯Â¼Â¬
    {0x7f, 0x02, 0x0c, 0x30, 0x0c, 0x02, 0x7f, 0x00},   // 08 00a9 826c Ã¯Â¼Â­
    {0x00, 0x7f, 0x02, 0x04, 0x08, 0x10, 0x7f, 0x00},   // 08 00aa 826d Ã¯Â¼Â®
    {0x00, 0x1c, 0x22, 0x41, 0x41, 0x22, 0x1c, 0x00},   // 08 00ab 826e Ã¯Â¼Â¯
    {0x00, 0x7f, 0x09, 0x09, 0x09, 0x09, 0x06, 0x00},   // 08 00ac 826f Ã¯Â¼Â°
    {0x00, 0x1c, 0x22, 0x41, 0x51, 0x22, 0x5c, 0x00},   // 08 00ad 8270 Ã¯Â¼Â±
    {0x00, 0x7f, 0x09, 0x09, 0x19, 0x29, 0x46, 0x00},   // 08 00ae 8271 Ã¯Â¼Â²
    {0x00, 0x26, 0x49, 0x49, 0x49, 0x49, 0x32, 0x00},   // 08 00af 8272 Ã¯Â¼Â³
    {0x01, 0x01, 0x01, 0x7f, 0x01, 0x01, 0x01, 0x00},   // 08 00b0 8273 Ã¯Â¼Â´
    {0x00, 0x3f, 0x40, 0x40, 0x40, 0x40, 0x3f, 0x00},   // 08 00b1 8274 Ã¯Â¼Âµ
    {0x03, 0x0c, 0x30, 0x40, 0x30, 0x0c, 0x03, 0x00},   // 08 00b2 8275 Ã¯Â¼Â¶
    {0x1f, 0x60, 0x18, 0x06, 0x18, 0x60, 0x1f, 0x00},   // 08 00b3 8276 Ã¯Â¼Â·
    {0x41, 0x22, 0x14, 0x08, 0x14, 0x22, 0x41, 0x00},   // 08 00b4 8277 Ã¯Â¼Â¸
    {0x01, 0x02, 0x04, 0x78, 0x04, 0x02, 0x01, 0x00},   // 08 00b5 8278 Ã¯Â¼Â¹
    {0x00, 0x41, 0x61, 0x51, 0x49, 0x45, 0x43, 0x00},   // 08 00b6 8279 Ã¯Â¼Âº
    {0x00, 0x20, 0x54, 0x54, 0x54, 0x78, 0x00, 0x00},   // 09 00b7 8281 Ã¯Â½Â
    {0x00, 0x7f, 0x48, 0x44, 0x44, 0x38, 0x00, 0x00},   // 09 00b8 8282 Ã¯Â½â€š
    {0x00, 0x38, 0x44, 0x44, 0x44, 0x28, 0x00, 0x00},   // 09 00b9 8283 Ã¯Â½Æ’
    {0x00, 0x38, 0x44, 0x44, 0x48, 0x7f, 0x00, 0x00},   // 09 00ba 8284 Ã¯Â½â€ž
    {0x00, 0x38, 0x54, 0x54, 0x54, 0x18, 0x00, 0x00},   // 09 00bb 8285 Ã¯Â½â€¦
    {0x00, 0x00, 0x04, 0x7e, 0x05, 0x01, 0x00, 0x00},   // 09 00bc 8286 Ã¯Â½â€ 
    {0x00, 0x08, 0x54, 0x54, 0x54, 0x3c, 0x00, 0x00},   // 09 00bd 8287 Ã¯Â½â€¡
    {0x00, 0x7f, 0x08, 0x04, 0x04, 0x78, 0x00, 0x00},   // 09 00be 8288 Ã¯Â½Ë†
    {0x00, 0x00, 0x00, 0x7d, 0x00, 0x00, 0x00, 0x00},   // 09 00bf 8289 Ã¯Â½â€°
    {0x00, 0x20, 0x40, 0x40, 0x3d, 0x00, 0x00, 0x00},   // 09 00c0 828a Ã¯Â½Å 
    {0x00, 0x00, 0x7f, 0x10, 0x28, 0x44, 0x00, 0x00},   // 09 00c1 828b Ã¯Â½â€¹
    {0x00, 0x00, 0x01, 0x7f, 0x00, 0x00, 0x00, 0x00},   // 09 00c2 828c Ã¯Â½Å’
    {0x00, 0x7c, 0x04, 0x78, 0x04, 0x78, 0x00, 0x00},   // 09 00c3 828d Ã¯Â½Â
    {0x00, 0x7c, 0x08, 0x04, 0x04, 0x78, 0x00, 0x00},   // 09 00c4 828e Ã¯Â½Å½
    {0x00, 0x38, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00},   // 09 00c5 828f Ã¯Â½Â
    {0x00, 0x7c, 0x14, 0x14, 0x14, 0x08, 0x00, 0x00},   // 09 00c6 8290 Ã¯Â½Â
    {0x00, 0x08, 0x14, 0x14, 0x14, 0x7c, 0x00, 0x00},   // 09 00c7 8291 Ã¯Â½â€˜
    {0x00, 0x7c, 0x08, 0x04, 0x04, 0x08, 0x00, 0x00},   // 09 00c8 8292 Ã¯Â½â€™
    {0x00, 0x48, 0x54, 0x54, 0x54, 0x24, 0x00, 0x00},   // 09 00c9 8293 Ã¯Â½â€œ
    {0x00, 0x04, 0x3e, 0x44, 0x44, 0x20, 0x00, 0x00},   // 09 00ca 8294 Ã¯Â½â€
    {0x00, 0x3c, 0x40, 0x40, 0x20, 0x7c, 0x00, 0x00},   // 09 00cb 8295 Ã¯Â½â€¢
    {0x00, 0x0c, 0x30, 0x40, 0x30, 0x0c, 0x00, 0x00},   // 09 00cc 8296 Ã¯Â½â€“
    {0x00, 0x1c, 0x60, 0x18, 0x60, 0x1c, 0x00, 0x00},   // 09 00cd 8297 Ã¯Â½â€”
    {0x00, 0x44, 0x28, 0x10, 0x28, 0x44, 0x00, 0x00},   // 09 00ce 8298 Ã¯Â½Ëœ
    {0x00, 0x44, 0x58, 0x20, 0x18, 0x04, 0x00, 0x00},   // 09 00cf 8299 Ã¯Â½â„¢
    {0x00, 0x44, 0x64, 0x54, 0x4c, 0x44, 0x00, 0x00},   // 09 00d0 829a Ã¯Â½Å¡
    {0x00, 0x20, 0x54, 0x7e, 0x34, 0x14, 0x60, 0x00},   // 0a 00d1 829f Ã£ÂÂ
    {0x20, 0x52, 0x7f, 0x2a, 0x1a, 0x4a, 0x30, 0x00},   // 0a 00d2 82a0 Ã£Ââ€š
    {0x00, 0x3c, 0x40, 0x20, 0x04, 0x18, 0x00, 0x00},   // 0a 00d3 82a1 Ã£ÂÆ’
    {0x1e, 0x20, 0x40, 0x20, 0x02, 0x04, 0x18, 0x00},   // 0a 00d4 82a2 Ã£Ââ€ž
    {0x00, 0x10, 0x4a, 0x4a, 0x2a, 0x10, 0x00, 0x00},   // 0a 00d5 82a3 Ã£Ââ€¦
    {0x00, 0x08, 0x45, 0x45, 0x45, 0x25, 0x18, 0x00},   // 0a 00d6 82a4 Ã£Ââ€ 
    {0x00, 0x48, 0x2a, 0x3a, 0x4a, 0x40, 0x00, 0x00},   // 0a 00d7 82a5 Ã£Ââ€¡
    {0x00, 0x44, 0x25, 0x15, 0x3d, 0x45, 0x40, 0x00},   // 0a 00d8 82a6 Ã£ÂË†
    {0x00, 0x24, 0x7e, 0x14, 0x50, 0x24, 0x00, 0x00},   // 0a 00d9 82a7 Ã£Ââ€°
    {0x22, 0x52, 0x7f, 0x0a, 0x48, 0x4a, 0x34, 0x00},   // 0a 00da 82a8 Ã£ÂÅ 
    {0x44, 0x34, 0x4f, 0x44, 0x38, 0x04, 0x18, 0x00},   // 0a 00db 82a9 Ã£Ââ€¹
    {0x44, 0x34, 0x4f, 0x44, 0x39, 0x04, 0x19, 0x00},   // 0a 00dc 82aa Ã£ÂÅ’
    {0x00, 0x2a, 0x5a, 0x4b, 0x4e, 0x5a, 0x08, 0x00},   // 0a 00dd 82ab Ã£ÂÂ
    {0x00, 0x2a, 0x5a, 0x4b, 0x4e, 0x5b, 0x08, 0x00},   // 0a 00de 82ac Ã£ÂÅ½
    {0x00, 0x08, 0x14, 0x14, 0x22, 0x41, 0x00, 0x00},   // 0a 00df 82ad Ã£ÂÂ
    {0x00, 0x08, 0x14, 0x14, 0x22, 0x45, 0x04, 0x00},   // 0a 00e0 82ae Ã£ÂÂ
    {0x3f, 0x00, 0x04, 0x44, 0x3f, 0x04, 0x04, 0x00},   // 0a 00e1 82af Ã£Ââ€˜
    {0x3f, 0x00, 0x04, 0x44, 0x3f, 0x04, 0x05, 0x00},   // 0a 00e2 82b0 Ã£Ââ€™
    {0x00, 0x20, 0x52, 0x42, 0x42, 0x42, 0x40, 0x00},   // 0a 00e3 82b1 Ã£Ââ€œ
    {0x00, 0x20, 0x52, 0x42, 0x43, 0x42, 0x41, 0x00},   // 0a 00e4 82b2 Ã£Ââ€
    {0x00, 0x24, 0x54, 0x44, 0x47, 0x5c, 0x04, 0x00},   // 0a 00e5 82b3 Ã£Ââ€¢
    {0x00, 0x24, 0x54, 0x44, 0x47, 0x5c, 0x05, 0x00},   // 0a 00e6 82b4 Ã£Ââ€“
    {0x00, 0x00, 0x3f, 0x40, 0x40, 0x40, 0x20, 0x00},   // 0a 00e7 82b5 Ã£Ââ€”
    {0x00, 0x00, 0x3f, 0x40, 0x41, 0x40, 0x21, 0x00},   // 0a 00e8 82b6 Ã£ÂËœ
    {0x02, 0x02, 0x0a, 0x56, 0x3f, 0x02, 0x02, 0x00},   // 0a 00e9 82b7 Ã£Ââ„¢
    {0x02, 0x02, 0x0a, 0x56, 0x3f, 0x02, 0x03, 0x00},   // 0a 00ea 82b8 Ã£ÂÅ¡
    {0x04, 0x04, 0x3f, 0x44, 0x54, 0x5f, 0x44, 0x00},   // 0a 00eb 82b9 Ã£Ââ€º
    {0x04, 0x04, 0x3f, 0x44, 0x54, 0x5f, 0x45, 0x00},   // 0a 00ec 82ba Ã£ÂÅ“
    {0x00, 0x08, 0x09, 0x3d, 0x4b, 0x49, 0x08, 0x00},   // 0a 00ed 82bb Ã£ÂÂ
    {0x00, 0x08, 0x09, 0x3d, 0x4b, 0x49, 0x0a, 0x00},   // 0a 00ee 82bc Ã£ÂÅ¾
    {0x42, 0x3a, 0x07, 0x22, 0x54, 0x44, 0x44, 0x00},   // 0a 00ef 82bd Ã£ÂÅ¸
    {0x42, 0x3a, 0x07, 0x22, 0x55, 0x44, 0x45, 0x00},   // 0a 00f0 82be Ã£ÂÂ 
    {0x00, 0x02, 0x12, 0x4e, 0x4b, 0x4a, 0x32, 0x00},   // 0a 00f1 82bf Ã£ÂÂ¡
    {0x00, 0x02, 0x12, 0x4e, 0x4b, 0x4a, 0x33, 0x00},   // 0a 00f2 82c0 Ã£ÂÂ¢
    {0x00, 0x10, 0x10, 0x48, 0x48, 0x30, 0x00, 0x00},   // 0a 00f3 82c1 Ã£ÂÂ£
    {0x04, 0x04, 0x02, 0x22, 0x22, 0x22, 0x1c, 0x00},   // 0a 00f4 82c2 Ã£ÂÂ¤
    {0x04, 0x04, 0x02, 0x22, 0x23, 0x22, 0x1d, 0x00},   // 0a 00f5 82c3 Ã£ÂÂ¥
    {0x00, 0x02, 0x02, 0x1a, 0x25, 0x43, 0x41, 0x00},   // 0a 00f6 82c4 Ã£ÂÂ¦
    {0x00, 0x02, 0x02, 0x1a, 0x25, 0x43, 0x45, 0x00},   // 0a 00f7 82c5 Ã£ÂÂ§
    {0x00, 0x20, 0x57, 0x48, 0x48, 0x44, 0x44, 0x00},   // 0a 00f8 82c6 Ã£ÂÂ¨
    {0x00, 0x20, 0x57, 0x48, 0x49, 0x44, 0x45, 0x00},   // 0a 00f9 82c7 Ã£ÂÂ©
    {0x12, 0x0a, 0x27, 0x52, 0x50, 0x3a, 0x24, 0x00},   // 0a 00fa 82c8 Ã£ÂÂª
    {0x7f, 0x00, 0x20, 0x52, 0x42, 0x42, 0x40, 0x00},   // 0a 00fb 82c9 Ã£ÂÂ«
    {0x30, 0x4e, 0x38, 0x54, 0x0f, 0x64, 0x78, 0x00},   // 0a 00fc 82ca Ã£ÂÂ¬
    {0x24, 0x14, 0x7f, 0x04, 0x22, 0x52, 0x3c, 0x00},   // 0a 00fd 82cb Ã£ÂÂ­
    {0x18, 0x24, 0x12, 0x4e, 0x42, 0x24, 0x18, 0x00},   // 0a 00fe 82cc Ã£ÂÂ®
    {0x7f, 0x00, 0x24, 0x54, 0x54, 0x3f, 0x44, 0x00},   // 0a 00ff 82cd Ã£ÂÂ¯
    {0x7f, 0x00, 0x24, 0x54, 0x54, 0x3f, 0x45, 0x00},   // 0a 0100 82ce Ã£ÂÂ°
    {0x7f, 0x00, 0x24, 0x54, 0x56, 0x3d, 0x46, 0x00},   // 0a 0101 82cf Ã£ÂÂ±
    {0x02, 0x3a, 0x47, 0x40, 0x41, 0x3e, 0x04, 0x00},   // 0a 0102 82d0 Ã£ÂÂ²
    {0x02, 0x3a, 0x47, 0x40, 0x41, 0x3e, 0x05, 0x00},   // 0a 0103 82d1 Ã£ÂÂ³
    {0x02, 0x3a, 0x47, 0x40, 0x43, 0x3d, 0x06, 0x00},   // 0a 0104 82d2 Ã£ÂÂ´
    {0x40, 0x30, 0x40, 0x4d, 0x32, 0x10, 0x60, 0x00},   // 0a 0105 82d3 Ã£ÂÂµ
    {0x40, 0x30, 0x40, 0x4d, 0x32, 0x11, 0x61, 0x00},   // 0a 0106 82d4 Ã£ÂÂ¶
    {0x40, 0x30, 0x40, 0x4d, 0x32, 0x15, 0x62, 0x00},   // 0a 0107 82d5 Ã£ÂÂ·
    {0x08, 0x04, 0x02, 0x04, 0x08, 0x10, 0x10, 0x00},   // 0a 0108 82d6 Ã£ÂÂ¸
    {0x08, 0x04, 0x02, 0x04, 0x09, 0x10, 0x11, 0x00},   // 0a 0109 82d7 Ã£ÂÂ¹
    {0x08, 0x04, 0x02, 0x04, 0x0a, 0x15, 0x12, 0x00},   // 0a 010a 82d8 Ã£ÂÂº
    {0x7f, 0x00, 0x6a, 0x6a, 0x7e, 0x2a, 0x4a, 0x00},   // 0a 010b 82d9 Ã£ÂÂ»
    {0x7f, 0x00, 0x6a, 0x6a, 0x7f, 0x2a, 0x4b, 0x00},   // 0a 010c 82da Ã£ÂÂ¼
    {0x7f, 0x00, 0x6a, 0x6a, 0x7e, 0x2d, 0x4a, 0x00},   // 0a 010d 82db Ã£ÂÂ½
    {0x00, 0x6a, 0x6a, 0x6a, 0x7f, 0x2a, 0x4a, 0x00},   // 0a 010e 82dc Ã£ÂÂ¾
    {0x30, 0x29, 0x1d, 0x4b, 0x48, 0x3c, 0x10, 0x00},   // 0a 010f 82dd Ã£ÂÂ¿
    {0x12, 0x2a, 0x7f, 0x42, 0x40, 0x42, 0x24, 0x00},   // 0a 0110 82de Ã£â€šâ‚¬
    {0x30, 0x4e, 0x38, 0x54, 0x0f, 0x44, 0x38, 0x00},   // 0a 0111 82df Ã£â€šÂ
    {0x00, 0x0a, 0x3e, 0x4b, 0x4a, 0x4a, 0x30, 0x00},   // 0a 0112 82e0 Ã£â€šâ€š
    {0x00, 0x08, 0x0c, 0x38, 0x46, 0x14, 0x08, 0x00},   // 0a 0113 82e1 Ã£â€šÆ’
    {0x04, 0x07, 0x1c, 0x62, 0x03, 0x0a, 0x04, 0x00},   // 0a 0114 82e2 Ã£â€šâ€ž
    {0x00, 0x1c, 0x48, 0x3e, 0x24, 0x18, 0x00, 0x00},   // 0a 0115 82e3 Ã£â€šâ€¦
    {0x1e, 0x04, 0x52, 0x3f, 0x12, 0x12, 0x0c, 0x00},   // 0a 0116 82e4 Ã£â€šâ€ 
    {0x00, 0x20, 0x50, 0x50, 0x3e, 0x48, 0x00, 0x00},   // 0a 0117 82e5 Ã£â€šâ€¡
    {0x00, 0x20, 0x50, 0x50, 0x3f, 0x24, 0x44, 0x00},   // 0a 0118 82e6 Ã£â€šË†
    {0x00, 0x1c, 0x51, 0x49, 0x4a, 0x48, 0x30, 0x00},   // 0a 0119 82e7 Ã£â€šâ€°
    {0x00, 0x0f, 0x42, 0x41, 0x21, 0x1e, 0x00, 0x00},   // 0a 011a 82e8 Ã£â€šÅ 
    {0x00, 0x10, 0x69, 0x6d, 0x4b, 0x49, 0x30, 0x00},   // 0a 011b 82e9 Ã£â€šâ€¹
    {0x24, 0x14, 0x7f, 0x04, 0x02, 0x3e, 0x40, 0x00},   // 0a 011c 82ea Ã£â€šÅ’
    {0x00, 0x10, 0x49, 0x4d, 0x4b, 0x49, 0x30, 0x00},   // 0a 011d 82eb Ã£â€šÂ
    {0x00, 0x28, 0x18, 0x7e, 0x08, 0x44, 0x38, 0x00},   // 0a 011e 82ec Ã£â€šÅ½
    {0x24, 0x14, 0x7f, 0x04, 0x42, 0x42, 0x3c, 0x00},   // 0a 011f 82ed Ã£â€šÂ
    {0x30, 0x49, 0x25, 0x1f, 0x24, 0x54, 0x38, 0x00},   // 0a 0120 82ee Ã£â€šÂ
    {0x40, 0x28, 0x25, 0x57, 0x35, 0x28, 0x40, 0x00},   // 0a 0121 82ef Ã£â€šâ€˜
    {0x10, 0x0a, 0x2e, 0x5b, 0x72, 0x4a, 0x48, 0x00},   // 0a 0122 82f0 Ã£â€šâ€™
    {0x40, 0x30, 0x0c, 0x33, 0x40, 0x40, 0x20, 0x00},   // 0a 0123 82f1 Ã£â€šâ€œ
    {0x00, 0x04, 0x44, 0x3c, 0x14, 0x0c, 0x00, 0x00},   // 0b 0124 8340 Ã£â€šÂ¡
    {0x00, 0x01, 0x41, 0x3d, 0x09, 0x05, 0x03, 0x00},   // 0b 0125 8341 Ã£â€šÂ¢
    {0x00, 0x20, 0x20, 0x10, 0x78, 0x04, 0x00, 0x00},   // 0b 0126 8342 Ã£â€šÂ£
    {0x00, 0x10, 0x10, 0x08, 0x7c, 0x02, 0x01, 0x00},   // 0b 0127 8343 Ã£â€šÂ¤
    {0x00, 0x18, 0x48, 0x4c, 0x28, 0x18, 0x00, 0x00},   // 0b 0128 8344 Ã£â€šÂ¥
    {0x00, 0x06, 0x42, 0x43, 0x22, 0x12, 0x0e, 0x00},   // 0b 0129 8345 Ã£â€šÂ¦
    {0x00, 0x40, 0x48, 0x78, 0x48, 0x40, 0x00, 0x00},   // 0b 012a 8346 Ã£â€šÂ§
    {0x20, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x20, 0x00},   // 0b 012b 8347 Ã£â€šÂ¨
    {0x00, 0x28, 0x28, 0x58, 0x7c, 0x08, 0x00, 0x00},   // 0b 012c 8348 Ã£â€šÂ©
    {0x22, 0x22, 0x12, 0x4a, 0x7f, 0x02, 0x02, 0x00},   // 0b 012d 8349 Ã£â€šÂª
    {0x00, 0x42, 0x22, 0x1f, 0x02, 0x42, 0x7e, 0x00},   // 0b 012e 834a Ã£â€šÂ«
    {0x00, 0x42, 0x22, 0x1f, 0x02, 0x42, 0x7f, 0x00},   // 0b 012f 834b Ã£â€šÂ¬
    {0x00, 0x12, 0x12, 0x1f, 0x72, 0x12, 0x10, 0x00},   // 0b 0130 834c Ã£â€šÂ­
    {0x00, 0x12, 0x12, 0x1f, 0x72, 0x13, 0x10, 0x00},   // 0b 0131 834d Ã£â€šÂ®
    {0x00, 0x08, 0x44, 0x43, 0x22, 0x12, 0x0e, 0x00},   // 0b 0132 834e Ã£â€šÂ¯
    {0x00, 0x08, 0x44, 0x43, 0x22, 0x12, 0x0f, 0x00},   // 0b 0133 834f Ã£â€šÂ°
    {0x08, 0x07, 0x42, 0x22, 0x1e, 0x02, 0x02, 0x00},   // 0b 0134 8350 Ã£â€šÂ±
    {0x08, 0x07, 0x42, 0x22, 0x1f, 0x02, 0x03, 0x00},   // 0b 0135 8351 Ã£â€šÂ²
    {0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x00},   // 0b 0136 8352 Ã£â€šÂ³
    {0x00, 0x42, 0x42, 0x42, 0x43, 0x42, 0x7f, 0x00},   // 0b 0137 8353 Ã£â€šÂ´
    {0x02, 0x02, 0x4f, 0x42, 0x22, 0x1f, 0x02, 0x00},   // 0b 0138 8354 Ã£â€šÂµ
    {0x02, 0x02, 0x4f, 0x42, 0x23, 0x1e, 0x03, 0x00},   // 0b 0139 8355 Ã£â€šÂ¶
    {0x00, 0x45, 0x4a, 0x40, 0x20, 0x10, 0x0c, 0x00},   // 0b 013a 8356 Ã£â€šÂ·
    {0x00, 0x45, 0x4a, 0x40, 0x21, 0x10, 0x0d, 0x00},   // 0b 013b 8357 Ã£â€šÂ¸
    {0x40, 0x42, 0x22, 0x22, 0x1a, 0x26, 0x40, 0x00},   // 0b 013c 8358 Ã£â€šÂ¹
    {0x40, 0x42, 0x22, 0x22, 0x1b, 0x26, 0x41, 0x00},   // 0b 013d 8359 Ã£â€šÂº
    {0x04, 0x04, 0x3f, 0x44, 0x44, 0x54, 0x4c, 0x00},   // 0b 013e 835a Ã£â€šÂ»
    {0x04, 0x04, 0x3f, 0x44, 0x45, 0x54, 0x4d, 0x00},   // 0b 013f 835b Ã£â€šÂ¼
    {0x00, 0x01, 0x46, 0x40, 0x20, 0x10, 0x0f, 0x00},   // 0b 0140 835c Ã£â€šÂ½
    {0x00, 0x01, 0x46, 0x40, 0x20, 0x11, 0x0f, 0x00},   // 0b 0141 835d Ã£â€šÂ¾
    {0x00, 0x08, 0x44, 0x4b, 0x2a, 0x12, 0x0e, 0x00},   // 0b 0142 835e Ã£â€šÂ¿
    {0x00, 0x08, 0x44, 0x4b, 0x2a, 0x12, 0x0f, 0x00},   // 0b 0143 835f Ã£Æ’â‚¬
    {0x08, 0x0a, 0x4a, 0x3e, 0x09, 0x09, 0x08, 0x00},   // 0b 0144 8360 Ã£Æ’Â
    {0x08, 0x0a, 0x4a, 0x3e, 0x09, 0x08, 0x09, 0x00},   // 0b 0145 8361 Ã£Æ’â€š
    {0x00, 0x18, 0x40, 0x58, 0x20, 0x18, 0x00, 0x00},   // 0b 0146 8362 Ã£Æ’Æ’
    {0x02, 0x0c, 0x42, 0x4c, 0x20, 0x10, 0x0e, 0x00},   // 0b 0147 8363 Ã£Æ’â€ž
    {0x02, 0x0c, 0x42, 0x4c, 0x21, 0x10, 0x0d, 0x00},   // 0b 0148 8364 Ã£Æ’â€¦
    {0x04, 0x05, 0x45, 0x3d, 0x05, 0x05, 0x04, 0x00},   // 0b 0149 8365 Ã£Æ’â€ 
    {0x04, 0x05, 0x45, 0x3d, 0x05, 0x04, 0x05, 0x00},   // 0b 014a 8366 Ã£Æ’â€¡
    {0x00, 0x00, 0x7f, 0x08, 0x08, 0x10, 0x00, 0x00},   // 0b 014b 8367 Ã£Æ’Ë†
    {0x00, 0x00, 0x7f, 0x08, 0x09, 0x10, 0x01, 0x00},   // 0b 014c 8368 Ã£Æ’â€°
    {0x04, 0x44, 0x24, 0x1f, 0x04, 0x04, 0x04, 0x00},   // 0b 014d 8369 Ã£Æ’Å 
    {0x20, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x00},   // 0b 014e 836a Ã£Æ’â€¹
    {0x40, 0x41, 0x25, 0x15, 0x19, 0x27, 0x00, 0x00},   // 0b 014f 836b Ã£Æ’Å’
    {0x20, 0x22, 0x12, 0x7b, 0x06, 0x12, 0x20, 0x00},   // 0b 0150 836c Ã£Æ’Â
    {0x40, 0x40, 0x20, 0x10, 0x08, 0x07, 0x00, 0x00},   // 0b 0151 836d Ã£Æ’Å½
    {0x40, 0x30, 0x0e, 0x00, 0x02, 0x0c, 0x70, 0x00},   // 0b 0152 836e Ã£Æ’Â
    {0x40, 0x30, 0x0e, 0x00, 0x02, 0x0d, 0x71, 0x00},   // 0b 0153 836f Ã£Æ’Â
    {0x40, 0x30, 0x0e, 0x00, 0x02, 0x0d, 0x72, 0x00},   // 0b 0154 8370 Ã£Æ’â€˜
    {0x00, 0x3f, 0x48, 0x48, 0x48, 0x44, 0x44, 0x00},   // 0b 0155 8371 Ã£Æ’â€™
    {0x00, 0x3f, 0x48, 0x48, 0x49, 0x44, 0x45, 0x00},   // 0b 0156 8372 Ã£Æ’â€œ
    {0x00, 0x3f, 0x48, 0x48, 0x4a, 0x45, 0x46, 0x00},   // 0b 0157 8373 Ã£Æ’â€
    {0x00, 0x02, 0x42, 0x42, 0x22, 0x12, 0x0e, 0x00},   // 0b 0158 8374 Ã£Æ’â€¢
    {0x00, 0x02, 0x42, 0x42, 0x23, 0x12, 0x0f, 0x00},   // 0b 0159 8375 Ã£Æ’â€“
    {0x00, 0x02, 0x42, 0x42, 0x22, 0x15, 0x0e, 0x00},   // 0b 015a 8376 Ã£Æ’â€”
    {0x08, 0x04, 0x02, 0x04, 0x08, 0x10, 0x20, 0x00},   // 0b 015b 8377 Ã£Æ’Ëœ
    {0x08, 0x04, 0x02, 0x04, 0x09, 0x10, 0x21, 0x00},   // 0b 015c 8378 Ã£Æ’â„¢
    {0x08, 0x04, 0x02, 0x04, 0x0a, 0x15, 0x22, 0x00},   // 0b 015d 8379 Ã£Æ’Å¡
    {0x24, 0x14, 0x44, 0x7f, 0x04, 0x14, 0x24, 0x00},   // 0b 015e 837a Ã£Æ’â€º
    {0x24, 0x14, 0x44, 0x7f, 0x05, 0x14, 0x25, 0x00},   // 0b 015f 837b Ã£Æ’Å“
    {0x24, 0x14, 0x44, 0x7f, 0x06, 0x15, 0x22, 0x00},   // 0b 0160 837c Ã£Æ’Â
    {0x02, 0x02, 0x12, 0x22, 0x52, 0x0a, 0x06, 0x00},   // 0b 0161 837d Ã£Æ’Å¾
    {0x00, 0x21, 0x25, 0x29, 0x4a, 0x42, 0x00, 0x00},   // 0b 0162 837e Ã£Æ’Å¸
    {0x40, 0x70, 0x4c, 0x43, 0x50, 0x20, 0x40, 0x00},   // 0c 0163 8380 Ã£Æ’Â 
    {0x40, 0x44, 0x24, 0x14, 0x08, 0x37, 0x00, 0x00},   // 0c 0164 8381 Ã£Æ’Â¡
    {0x00, 0x08, 0x09, 0x3f, 0x49, 0x49, 0x48, 0x00},   // 0c 0165 8382 Ã£Æ’Â¢
    {0x00, 0x10, 0x1c, 0x68, 0x08, 0x18, 0x00, 0x00},   // 0c 0166 8383 Ã£Æ’Â£
    {0x04, 0x04, 0x0f, 0x74, 0x02, 0x0a, 0x06, 0x00},   // 0c 0167 8384 Ã£Æ’Â¤
    {0x00, 0x40, 0x48, 0x48, 0x78, 0x40, 0x00, 0x00},   // 0c 0168 8385 Ã£Æ’Â¥
    {0x20, 0x22, 0x22, 0x22, 0x3e, 0x20, 0x20, 0x00},   // 0c 0169 8386 Ã£Æ’Â¦
    {0x00, 0x00, 0x44, 0x54, 0x54, 0x7c, 0x00, 0x00},   // 0c 016a 8387 Ã£Æ’Â§
    {0x00, 0x42, 0x4a, 0x4a, 0x4a, 0x4a, 0x7e, 0x00},   // 0c 016b 8388 Ã£Æ’Â¨
    {0x00, 0x04, 0x45, 0x45, 0x25, 0x15, 0x0c, 0x00},   // 0c 016c 8389 Ã£Æ’Â©
    {0x00, 0x0f, 0x40, 0x40, 0x20, 0x1f, 0x00, 0x00},   // 0c 016d 838a Ã£Æ’Âª
    {0x40, 0x20, 0x1e, 0x00, 0x7f, 0x20, 0x10, 0x00},   // 0c 016e 838b Ã£Æ’Â«
    {0x00, 0x00, 0x7f, 0x40, 0x20, 0x10, 0x08, 0x00},   // 0c 016f 838c Ã£Æ’Â¬
    {0x00, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x00},   // 0c 0170 838d Ã£Æ’Â­
    {0x00, 0x0c, 0x44, 0x44, 0x24, 0x1c, 0x00, 0x00},   // 0c 0171 838e Ã£Æ’Â®
    {0x00, 0x06, 0x42, 0x42, 0x22, 0x12, 0x0e, 0x00},   // 0c 0172 838f Ã£Æ’Â¯
    {0x10, 0x12, 0x1e, 0x12, 0x12, 0x7f, 0x12, 0x00},   // 0c 0173 8390 Ã£Æ’Â°
    {0x20, 0x22, 0x22, 0x3a, 0x26, 0x22, 0x20, 0x00},   // 0c 0174 8391 Ã£Æ’Â±
    {0x00, 0x01, 0x45, 0x45, 0x25, 0x15, 0x0f, 0x00},   // 0c 0175 8392 Ã£Æ’Â²
    {0x00, 0x41, 0x42, 0x40, 0x20, 0x10, 0x0c, 0x00},   // 0c 0176 8393 Ã£Æ’Â³
    {0x00, 0x06, 0x42, 0x43, 0x22, 0x12, 0x0f, 0x00},   // 0c 0177 8394 Ã£Æ’Â´
    {0x00, 0x48, 0x28, 0x1c, 0x48, 0x78, 0x00, 0x00},   // 0c 0178 8395 Ã£Æ’Âµ
    {0x00, 0x10, 0x0c, 0x48, 0x38, 0x08, 0x00, 0x00},   // 0c 0179 8396 Ã£Æ’Â¶
    {0x60, 0x18, 0x16, 0x11, 0x16, 0x18, 0x60, 0x00},   // 0d 017a 839f ÃŽâ€˜
    {0x00, 0x7f, 0x49, 0x49, 0x49, 0x49, 0x36, 0x00},   // 0d 017b 83a0 ÃŽâ€™
    {0x00, 0x7f, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00},   // 0d 017c 83a1 ÃŽâ€œ
    {0x60, 0x58, 0x46, 0x41, 0x46, 0x58, 0x60, 0x00},   // 0d 017d 83a2 ÃŽâ€
    {0x00, 0x7f, 0x49, 0x49, 0x49, 0x49, 0x41, 0x00},   // 0d 017e 83a3 ÃŽâ€¢
    {0x00, 0x41, 0x61, 0x51, 0x49, 0x45, 0x43, 0x00},   // 0d 017f 83a4 ÃŽâ€“
    {0x00, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x7f, 0x00},   // 0d 0180 83a5 ÃŽâ€”
    {0x1c, 0x22, 0x49, 0x49, 0x49, 0x22, 0x1c, 0x00},   // 0d 0181 83a6 ÃŽËœ
    {0x00, 0x00, 0x41, 0x7f, 0x41, 0x00, 0x00, 0x00},   // 0d 0182 83a7 ÃŽâ„¢
    {0x00, 0x7f, 0x10, 0x08, 0x14, 0x22, 0x41, 0x00},   // 0d 0183 83a8 ÃŽÅ¡
    {0x60, 0x18, 0x06, 0x01, 0x06, 0x18, 0x60, 0x00},   // 0d 0184 83a9 ÃŽâ€º
    {0x7f, 0x02, 0x0c, 0x30, 0x0c, 0x02, 0x7f, 0x00},   // 0d 0185 83aa ÃŽÅ“
    {0x00, 0x7f, 0x02, 0x04, 0x08, 0x10, 0x7f, 0x00},   // 0d 0186 83ab ÃŽÂ
    {0x00, 0x41, 0x49, 0x49, 0x49, 0x49, 0x41, 0x00},   // 0d 0187 83ac ÃŽÅ¾
    {0x00, 0x1c, 0x22, 0x41, 0x41, 0x22, 0x1c, 0x00},   // 0d 0188 83ad ÃŽÅ¸
    {0x00, 0x7f, 0x01, 0x01, 0x01, 0x01, 0x7f, 0x00},   // 0d 0189 83ae ÃŽÂ 
    {0x00, 0x7f, 0x09, 0x09, 0x09, 0x09, 0x06, 0x00},   // 0d 018a 83af ÃŽÂ¡
    {0x00, 0x41, 0x63, 0x55, 0x49, 0x41, 0x41, 0x00},   // 0d 018b 83b0 ÃŽÂ£
    {0x01, 0x01, 0x01, 0x7f, 0x01, 0x01, 0x01, 0x00},   // 0d 018c 83b1 ÃŽÂ¤
    {0x01, 0x02, 0x04, 0x78, 0x04, 0x02, 0x01, 0x00},   // 0d 018d 83b2 ÃŽÂ¥
    {0x1c, 0x22, 0x22, 0x7f, 0x22, 0x22, 0x1c, 0x00},   // 0d 018e 83b3 ÃŽÂ¦
    {0x41, 0x22, 0x14, 0x08, 0x14, 0x22, 0x41, 0x00},   // 0d 018f 83b4 ÃŽÂ§
    {0x01, 0x06, 0x08, 0x7f, 0x08, 0x06, 0x01, 0x00},   // 0d 0190 83b5 ÃŽÂ¨
    {0x4c, 0x52, 0x61, 0x01, 0x61, 0x52, 0x4c, 0x00},   // 0d 0191 83b6 ÃŽÂ©
    {0x00, 0x30, 0x48, 0x44, 0x34, 0x48, 0x04, 0x00},   // 0e 0192 83bf ÃŽÂ±
    {0x00, 0x60, 0x1c, 0x12, 0x25, 0x25, 0x1a, 0x00},   // 0e 0193 83c0 ÃŽÂ²
    {0x00, 0x04, 0x64, 0x38, 0x08, 0x04, 0x00, 0x00},   // 0e 0194 83c1 ÃŽÂ³
    {0x00, 0x30, 0x4a, 0x45, 0x39, 0x02, 0x00, 0x00},   // 0e 0195 83c2 ÃŽÂ´
    {0x00, 0x20, 0x58, 0x54, 0x44, 0x28, 0x00, 0x00},   // 0e 0196 83c3 ÃŽÂµ
    {0x00, 0x00, 0x4d, 0x52, 0x21, 0x01, 0x00, 0x00},   // 0e 0197 83c4 ÃŽÂ¶
    {0x00, 0x08, 0x24, 0x18, 0x04, 0x64, 0x18, 0x00},   // 0e 0198 83c5 ÃŽÂ·
    {0x00, 0x38, 0x4e, 0x49, 0x39, 0x0e, 0x00, 0x00},   // 0e 0199 83c6 ÃŽÂ¸
    {0x00, 0x00, 0x30, 0x4c, 0x20, 0x00, 0x00, 0x00},   // 0e 019a 83c7 ÃŽÂ¹
    {0x00, 0x60, 0x1c, 0x30, 0x48, 0x44, 0x00, 0x00},   // 0e 019b 83c8 ÃŽÂº
    {0x00, 0x40, 0x30, 0x09, 0x3e, 0x40, 0x00, 0x00},   // 0e 019c 83c9 ÃŽÂ»
    {0x00, 0x40, 0x30, 0x2c, 0x20, 0x10, 0x2c, 0x00},   // 0e 019d 83ca ÃŽÂ¼
    {0x00, 0x04, 0x78, 0x20, 0x10, 0x0c, 0x00, 0x00},   // 0e 019e 83cb ÃŽÂ½
    {0x00, 0x08, 0x56, 0x55, 0x25, 0x05, 0x00, 0x00},   // 0e 019f 83cc ÃŽÂ¾
    {0x00, 0x30, 0x48, 0x44, 0x24, 0x18, 0x00, 0x00},   // 0e 01a0 83cd ÃŽÂ¿
    {0x00, 0x48, 0x24, 0x1c, 0x04, 0x7c, 0x44, 0x00},   // 0e 01a1 83ce Ãâ‚¬
    {0x00, 0x60, 0x18, 0x24, 0x24, 0x24, 0x18, 0x00},   // 0e 01a2 83cf ÃÂ
    {0x00, 0x30, 0x48, 0x44, 0x24, 0x1c, 0x04, 0x00},   // 0e 01a3 83d0 ÃÆ’
    {0x00, 0x08, 0x04, 0x34, 0x4c, 0x24, 0x04, 0x00},   // 0e 01a4 83d1 Ãâ€ž
    {0x00, 0x08, 0x34, 0x4c, 0x40, 0x20, 0x1c, 0x00},   // 0e 01a5 83d2 Ãâ€¦
    {0x00, 0x18, 0x24, 0x64, 0x3c, 0x27, 0x18, 0x00},   // 0e 01a6 83d3 Ãâ€ 
    {0x00, 0x40, 0x24, 0x34, 0x48, 0x44, 0x00, 0x00},   // 0e 01a7 83d4 Ãâ€¡
    {0x00, 0x14, 0x2c, 0x60, 0x3c, 0x23, 0x18, 0x00},   // 0e 01a8 83d5 ÃË†
    {0x00, 0x38, 0x44, 0x20, 0x38, 0x40, 0x3c, 0x00},   // 0e 01a9 83d6 Ãâ€°
    {0x60, 0x18, 0x16, 0x11, 0x16, 0x18, 0x60, 0x00},   // 0f 01aa 8440 ÃÂ
    {0x00, 0x7f, 0x49, 0x49, 0x49, 0x49, 0x31, 0x00},   // 0f 01ab 8441 Ãâ€˜
    {0x00, 0x7f, 0x49, 0x49, 0x49, 0x49, 0x36, 0x00},   // 0f 01ac 8442 Ãâ€™
    {0x00, 0x7f, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00},   // 0f 01ad 8443 Ãâ€œ
    {0x60, 0x30, 0x2f, 0x21, 0x21, 0x3f, 0x60, 0x00},   // 0f 01ae 8444 Ãâ€
    {0x00, 0x7f, 0x49, 0x49, 0x49, 0x49, 0x41, 0x00},   // 0f 01af 8445 Ãâ€¢
    {0x00, 0x7e, 0x4b, 0x4a, 0x4a, 0x4b, 0x42, 0x00},   // 0f 01b0 8446 ÃÂ
    {0x41, 0x36, 0x08, 0x7f, 0x08, 0x36, 0x41, 0x00},   // 0f 01b1 8447 Ãâ€“
    {0x00, 0x22, 0x41, 0x49, 0x49, 0x49, 0x36, 0x00},   // 0f 01b2 8448 Ãâ€”
    {0x00, 0x7f, 0x20, 0x10, 0x08, 0x04, 0x7f, 0x00},   // 0f 01b3 8449 ÃËœ
    {0x00, 0x7e, 0x21, 0x12, 0x0a, 0x05, 0x7e, 0x00},   // 0f 01b4 844a Ãâ„¢
    {0x00, 0x7f, 0x08, 0x08, 0x16, 0x21, 0x41, 0x00},   // 0f 01b5 844b ÃÅ¡
    {0x40, 0x40, 0x3f, 0x01, 0x01, 0x01, 0x7f, 0x00},   // 0f 01b6 844c Ãâ€º
    {0x78, 0x07, 0x18, 0x60, 0x18, 0x07, 0x78, 0x00},   // 0f 01b7 844d ÃÅ“
    {0x00, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x7f, 0x00},   // 0f 01b8 844e ÃÂ
    {0x00, 0x1c, 0x22, 0x41, 0x41, 0x22, 0x1c, 0x00},   // 0f 01b9 844f ÃÅ¾
    {0x00, 0x7f, 0x01, 0x01, 0x01, 0x01, 0x7f, 0x00},   // 0f 01ba 8450 ÃÅ¸
    {0x00, 0x7f, 0x09, 0x09, 0x09, 0x09, 0x06, 0x00},   // 0f 01bb 8451 ÃÂ 
    {0x00, 0x1c, 0x22, 0x41, 0x41, 0x41, 0x22, 0x00},   // 0f 01bc 8452 ÃÂ¡
    {0x01, 0x01, 0x01, 0x7f, 0x01, 0x01, 0x01, 0x00},   // 0f 01bd 8453 ÃÂ¢
    {0x00, 0x41, 0x46, 0x28, 0x18, 0x06, 0x01, 0x00},   // 0f 01be 8454 ÃÂ£
    {0x1c, 0x22, 0x22, 0x7f, 0x22, 0x22, 0x1c, 0x00},   // 0f 01bf 8455 ÃÂ¤
    {0x41, 0x22, 0x14, 0x08, 0x14, 0x22, 0x41, 0x00},   // 0f 01c0 8456 ÃÂ¥
    {0x00, 0x3f, 0x20, 0x20, 0x20, 0x3f, 0x60, 0x00},   // 0f 01c1 8457 ÃÂ¦
    {0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x7f, 0x00},   // 0f 01c2 8458 ÃÂ§
    {0x7f, 0x40, 0x40, 0x7f, 0x40, 0x40, 0x7f, 0x00},   // 0f 01c3 8459 ÃÂ¨
    {0x3f, 0x20, 0x20, 0x3f, 0x20, 0x20, 0x7f, 0x00},   // 0f 01c4 845a ÃÂ©
    {0x00, 0x01, 0x7f, 0x48, 0x48, 0x48, 0x30, 0x00},   // 0f 01c5 845b ÃÂª
    {0x00, 0x7f, 0x48, 0x48, 0x30, 0x00, 0x7f, 0x00},   // 0f 01c6 845c ÃÂ«
    {0x00, 0x00, 0x7f, 0x48, 0x48, 0x48, 0x30, 0x00},   // 0f 01c7 845d ÃÂ¬
    {0x00, 0x22, 0x49, 0x49, 0x49, 0x2a, 0x1c, 0x00},   // 0f 01c8 845e ÃÂ­
    {0x7f, 0x08, 0x3e, 0x41, 0x41, 0x41, 0x3e, 0x00},   // 0f 01c9 845f ÃÂ®
    {0x00, 0x46, 0x39, 0x09, 0x09, 0x09, 0x7f, 0x00},   // 0f 01ca 8460 ÃÂ¯
    {0x00, 0x20, 0x54, 0x54, 0x54, 0x78, 0x00, 0x00},   // 10 01cb 8470 ÃÂ°
    {0x00, 0x3c, 0x46, 0x45, 0x45, 0x39, 0x00, 0x00},   // 10 01cc 8471 ÃÂ±
    {0x00, 0x7c, 0x54, 0x54, 0x54, 0x28, 0x00, 0x00},   // 10 01cd 8472 ÃÂ²
    {0x00, 0x7c, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00},   // 10 01ce 8473 ÃÂ³
    {0x00, 0x60, 0x3c, 0x24, 0x3c, 0x60, 0x00, 0x00},   // 10 01cf 8474 ÃÂ´
    {0x00, 0x38, 0x54, 0x54, 0x54, 0x18, 0x00, 0x00},   // 10 01d0 8475 ÃÂµ
    {0x00, 0x38, 0x55, 0x54, 0x55, 0x18, 0x00, 0x00},   // 10 01d1 8476 Ã‘â€˜
    {0x44, 0x28, 0x10, 0x7c, 0x10, 0x28, 0x44, 0x00},   // 10 01d2 8477 ÃÂ¶
    {0x00, 0x28, 0x44, 0x54, 0x54, 0x28, 0x00, 0x00},   // 10 01d3 8478 ÃÂ·
    {0x00, 0x7c, 0x20, 0x10, 0x08, 0x7c, 0x00, 0x00},   // 10 01d4 8479 ÃÂ¸
    {0x00, 0x7c, 0x21, 0x12, 0x09, 0x7c, 0x00, 0x00},   // 10 01d5 847a ÃÂ¹
    {0x00, 0x7c, 0x10, 0x18, 0x24, 0x44, 0x00, 0x00},   // 10 01d6 847b ÃÂº
    {0x40, 0x40, 0x3c, 0x04, 0x04, 0x7c, 0x00, 0x00},   // 10 01d7 847c ÃÂ»
    {0x00, 0x7c, 0x08, 0x30, 0x08, 0x7c, 0x00, 0x00},   // 10 01d8 847d ÃÂ¼
    {0x00, 0x7c, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00},   // 10 01d9 847e ÃÂ½
    {0x00, 0x38, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00},   // 11 01da 8480 ÃÂ¾
    {0x00, 0x7c, 0x04, 0x04, 0x04, 0x7c, 0x00, 0x00},   // 11 01db 8481 ÃÂ¿
    {0x00, 0x7c, 0x14, 0x14, 0x14, 0x08, 0x00, 0x00},   // 11 01dc 8482 Ã‘â‚¬
    {0x00, 0x38, 0x44, 0x44, 0x44, 0x28, 0x00, 0x00},   // 11 01dd 8483 Ã‘Â
    {0x00, 0x04, 0x04, 0x7c, 0x04, 0x04, 0x00, 0x00},   // 11 01de 8484 Ã‘â€š
    {0x00, 0x44, 0x58, 0x20, 0x18, 0x04, 0x00, 0x00},   // 11 01df 8485 Ã‘Æ’
    {0x00, 0x18, 0x24, 0x7f, 0x24, 0x18, 0x00, 0x00},   // 11 01e0 8486 Ã‘â€ž
    {0x00, 0x44, 0x28, 0x10, 0x28, 0x44, 0x00, 0x00},   // 11 01e1 8487 Ã‘â€¦
    {0x00, 0x3c, 0x20, 0x20, 0x3c, 0x60, 0x00, 0x00},   // 11 01e2 8488 Ã‘â€ 
    {0x00, 0x1c, 0x20, 0x20, 0x20, 0x7c, 0x00, 0x00},   // 11 01e3 8489 Ã‘â€¡
    {0x00, 0x7c, 0x40, 0x7c, 0x40, 0x7c, 0x00, 0x00},   // 11 01e4 848a Ã‘Ë†
    {0x00, 0x3c, 0x20, 0x3c, 0x20, 0x3c, 0x60, 0x00},   // 11 01e5 848b Ã‘â€°
    {0x00, 0x04, 0x7c, 0x50, 0x50, 0x50, 0x20, 0x00},   // 11 01e6 848c Ã‘Å 
    {0x00, 0x7c, 0x50, 0x50, 0x20, 0x7c, 0x00, 0x00},   // 11 01e7 848d Ã‘â€¹
    {0x00, 0x7c, 0x50, 0x50, 0x50, 0x20, 0x00, 0x00},   // 11 01e8 848e Ã‘Å’
    {0x00, 0x28, 0x44, 0x54, 0x54, 0x38, 0x00, 0x00},   // 11 01e9 848f Ã‘Â
    {0x00, 0x7c, 0x10, 0x38, 0x44, 0x44, 0x38, 0x00},   // 11 01ea 8490 Ã‘Å½
    {0x00, 0x48, 0x34, 0x14, 0x14, 0x7c, 0x00, 0x00},   // 11 01eb 8491 Ã‘Â
    {0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08},   // 12 01ec 849f Ã¢â€â‚¬
    {0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00},   // 12 01ed 84a0 Ã¢â€â€š
    {0x00, 0x00, 0x00, 0xf8, 0x08, 0x08, 0x08, 0x08},   // 12 01ee 84a1 Ã¢â€Å’
    {0x08, 0x08, 0x08, 0xf8, 0x00, 0x00, 0x00, 0x00},   // 12 01ef 84a2 Ã¢â€Â
    {0x08, 0x08, 0x08, 0x0f, 0x00, 0x00, 0x00, 0x00},   // 12 01f0 84a3 Ã¢â€Ëœ
    {0x00, 0x00, 0x00, 0x0f, 0x08, 0x08, 0x08, 0x08},   // 12 01f1 84a4 Ã¢â€â€
    {0x00, 0x00, 0x00, 0xff, 0x08, 0x08, 0x08, 0x08},   // 12 01f2 84a5 Ã¢â€Å“
    {0x08, 0x08, 0x08, 0xf8, 0x08, 0x08, 0x08, 0x08},   // 12 01f3 84a6 Ã¢â€Â¬
    {0x08, 0x08, 0x08, 0xff, 0x00, 0x00, 0x00, 0x00},   // 12 01f4 84a7 Ã¢â€Â¤
    {0x08, 0x08, 0x08, 0x0f, 0x08, 0x08, 0x08, 0x08},   // 12 01f5 84a8 Ã¢â€Â´
    {0x08, 0x08, 0x08, 0xff, 0x08, 0x08, 0x08, 0x08},   // 12 01f6 84a9 Ã¢â€Â¼
    {0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},   // 12 01f7 84aa Ã¢â€Â
    {0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00},   // 12 01f8 84ab Ã¢â€Æ’
    {0x00, 0x00, 0x00, 0xf8, 0xf8, 0x18, 0x18, 0x18},   // 12 01f9 84ac Ã¢â€Â
    {0x18, 0x18, 0x18, 0xf8, 0xf8, 0x00, 0x00, 0x00},   // 12 01fa 84ad Ã¢â€â€œ
    {0x18, 0x18, 0x18, 0x1f, 0x1f, 0x00, 0x00, 0x00},   // 12 01fb 84ae Ã¢â€â€º
    {0x00, 0x00, 0x00, 0x1f, 0x1f, 0x18, 0x18, 0x18},   // 12 01fc 84af Ã¢â€â€”
    {0x00, 0x00, 0x00, 0xff, 0xff, 0x18, 0x18, 0x18},   // 12 01fd 84b0 Ã¢â€Â£
    {0x18, 0x18, 0x18, 0xf8, 0xf8, 0x18, 0x18, 0x18},   // 12 01fe 84b1 Ã¢â€Â³
    {0x18, 0x18, 0x18, 0xff, 0xff, 0x00, 0x00, 0x00},   // 12 01ff 84b2 Ã¢â€Â«
    {0x18, 0x18, 0x18, 0x1f, 0x1f, 0x18, 0x18, 0x18},   // 12 0200 84b3 Ã¢â€Â»
    {0x18, 0x18, 0x18, 0xff, 0xff, 0x18, 0x18, 0x18},   // 12 0201 84b4 Ã¢â€¢â€¹
    {0x00, 0x00, 0x00, 0xff, 0xff, 0x08, 0x08, 0x08},   // 12 0202 84b5 Ã¢â€Â 
    {0x18, 0x18, 0x18, 0xf8, 0x18, 0x18, 0x18, 0x18},   // 12 0203 84b6 Ã¢â€Â¯
    {0x08, 0x08, 0x08, 0xff, 0xff, 0x00, 0x00, 0x00},   // 12 0204 84b7 Ã¢â€Â¨
    {0x18, 0x18, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18},   // 12 0205 84b8 Ã¢â€Â·
    {0x18, 0x18, 0x18, 0xff, 0x18, 0x18, 0x18, 0x18},   // 12 0206 84b9 Ã¢â€Â¿
    {0x00, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18},   // 12 0207 84ba Ã¢â€Â
    {0x08, 0x08, 0x08, 0xf8, 0xf8, 0x08, 0x08, 0x08},   // 12 0208 84bb Ã¢â€Â°
    {0x18, 0x18, 0x18, 0xff, 0x00, 0x00, 0x00, 0x00},   // 12 0209 84bc Ã¢â€Â¥
    {0x08, 0x08, 0x08, 0x0f, 0x0f, 0x08, 0x08, 0x08},   // 12 020a 84bd Ã¢â€Â¸
    {0x08, 0x08, 0x08, 0xff, 0xff, 0x08, 0x08, 0x08},   // 12 020b 84be Ã¢â€¢â€š
    {0x3e, 0x41, 0x45, 0x7f, 0x41, 0x41, 0x3e, 0x00},   // 13 020c 8740 Ã¢â€˜Â 
    {0x3e, 0x41, 0x73, 0x6b, 0x65, 0x41, 0x3e, 0x00},   // 13 020d 8741 Ã¢â€˜Â¡
    {0x3e, 0x41, 0x63, 0x6b, 0x55, 0x41, 0x3e, 0x00},   // 13 020e 8742 Ã¢â€˜Â¢
    {0x3e, 0x41, 0x59, 0x55, 0x7f, 0x41, 0x3e, 0x00},   // 13 020f 8743 Ã¢â€˜Â£
    {0x3e, 0x41, 0x6f, 0x6b, 0x53, 0x41, 0x3e, 0x00},   // 13 0210 8744 Ã¢â€˜Â¤
    {0x3e, 0x41, 0x5d, 0x6b, 0x53, 0x41, 0x3e, 0x00},   // 13 0211 8745 Ã¢â€˜Â¥
    {0x3e, 0x41, 0x43, 0x7b, 0x47, 0x41, 0x3e, 0x00},   // 13 0212 8746 Ã¢â€˜Â¦
    {0x3e, 0x41, 0x55, 0x6b, 0x55, 0x41, 0x3e, 0x00},   // 13 0213 8747 Ã¢â€˜Â§
    {0x3e, 0x41, 0x65, 0x6b, 0x5d, 0x41, 0x3e, 0x00},   // 13 0214 8748 Ã¢â€˜Â¨
    {0x3e, 0x45, 0x7f, 0x41, 0x5d, 0x55, 0x3e, 0x00},   // 13 0215 8749 Ã¢â€˜Â©
    {0x3e, 0x45, 0x7f, 0x41, 0x45, 0x7f, 0x3e, 0x00},   // 13 0216 874a Ã¢â€˜Âª
    {0x3e, 0x45, 0x7f, 0x41, 0x7b, 0x6d, 0x3e, 0x00},   // 13 0217 874b Ã¢â€˜Â«
    {0x3e, 0x45, 0x7f, 0x41, 0x6b, 0x55, 0x3e, 0x00},   // 13 0218 874c Ã¢â€˜Â¬
    {0x3e, 0x45, 0x7f, 0x41, 0x5f, 0x79, 0x3e, 0x00},   // 13 0219 874d Ã¢â€˜Â­
    {0x3e, 0x45, 0x7f, 0x41, 0x6f, 0x5b, 0x3e, 0x00},   // 13 021a 874e Ã¢â€˜Â®
    {0x3e, 0x45, 0x7f, 0x41, 0x7d, 0x7b, 0x3e, 0x00},   // 13 021b 874f Ã¢â€˜Â¯
    {0x3e, 0x45, 0x7f, 0x41, 0x7b, 0x47, 0x3e, 0x00},   // 13 021c 8750 Ã¢â€˜Â°
    {0x3e, 0x45, 0x7f, 0x41, 0x77, 0x77, 0x3e, 0x00},   // 13 021d 8751 Ã¢â€˜Â±
    {0x3e, 0x45, 0x7f, 0x41, 0x6f, 0x5f, 0x3e, 0x00},   // 13 021e 8752 Ã¢â€˜Â²
    {0x3e, 0x7b, 0x6f, 0x41, 0x5d, 0x55, 0x3e, 0x00},   // 13 021f 8753 Ã¢â€˜Â³
    {0x00, 0x00, 0x41, 0x7f, 0x41, 0x00, 0x00, 0x00},   // 13 0220 8754 Ã¢â€¦Â 
    {0x00, 0x41, 0x7f, 0x41, 0x7f, 0x41, 0x00, 0x00},   // 13 0221 8755 Ã¢â€¦Â¡
    {0x41, 0x7f, 0x41, 0x7f, 0x41, 0x7f, 0x41, 0x00},   // 13 0222 8756 Ã¢â€¦Â¢
    {0x41, 0x7f, 0x41, 0x0f, 0x71, 0x0f, 0x01, 0x00},   // 13 0223 8757 Ã¢â€¦Â£
    {0x01, 0x07, 0x19, 0x60, 0x19, 0x07, 0x01, 0x00},   // 13 0224 8758 Ã¢â€¦Â¤
    {0x01, 0x0f, 0x71, 0x0f, 0x41, 0x7f, 0x41, 0x00},   // 13 0225 8759 Ã¢â€¦Â¥
    {0x0f, 0x71, 0x0f, 0x7f, 0x41, 0x7f, 0x41, 0x00},   // 13 0226 875a Ã¢â€¦Â¦
    {0x0f, 0x71, 0x0f, 0x7f, 0x7f, 0x7f, 0x41, 0x00},   // 13 0227 875b Ã¢â€¦Â§
    {0x41, 0x7f, 0x41, 0x77, 0x49, 0x77, 0x41, 0x00},   // 13 0228 875c Ã¢â€¦Â¨
    {0x41, 0x63, 0x55, 0x08, 0x55, 0x63, 0x41, 0x00},   // 13 0229 875d Ã¢â€¦Â©
    {0x11, 0x15, 0x15, 0x00, 0x18, 0x40, 0x38, 0x00},   // 14 022a 875f Ã£Ââ€°
    {0x0a, 0x1f, 0x0a, 0x00, 0x78, 0x48, 0x78, 0x00},   // 14 022b 8760 Ã£Å’â€
    {0x2f, 0x7a, 0x26, 0x00, 0x09, 0x09, 0x04, 0x00},   // 14 022c 8761 Ã£Å’Â¢
    {0x75, 0x22, 0x05, 0x40, 0x32, 0x72, 0x42, 0x00},   // 14 022d 8762 Ã£ÂÂ
    {0x4a, 0x69, 0x57, 0x61, 0x0a, 0x0b, 0x07, 0x00},   // 14 022e 8763 Ã£Å’Ëœ
    {0x0f, 0x04, 0x04, 0x00, 0x48, 0x48, 0x20, 0x00},   // 14 022f 8764 Ã£Å’Â§
    {0x49, 0x37, 0x75, 0x43, 0x00, 0x02, 0x02, 0x00},   // 14 0230 8765 Ã£Å’Æ’
    {0x52, 0x29, 0x1a, 0x50, 0x3a, 0x79, 0x47, 0x00},   // 14 0231 8766 Ã£Å’Â¶
    {0x73, 0x20, 0x07, 0x40, 0x32, 0x72, 0x46, 0x00},   // 14 0232 8767 Ã£Ââ€˜
    {0x03, 0x79, 0x27, 0x00, 0x02, 0x02, 0x06, 0x00},   // 14 0233 8768 Ã£Ââ€”
    {0x35, 0x03, 0x77, 0x00, 0x27, 0x25, 0x27, 0x00},   // 14 0234 8769 Ã£Å’Â
    {0x0f, 0x04, 0x45, 0x30, 0x01, 0x70, 0x40, 0x00},   // 14 0235 876a Ã£Å’Â¦
    {0x0f, 0x7a, 0x26, 0x00, 0x09, 0x09, 0x04, 0x00},   // 14 0236 876b Ã£Å’Â£
    {0x76, 0x61, 0x07, 0x53, 0x40, 0x72, 0x22, 0x00},   // 14 0237 876c Ã£Å’Â«
    {0x61, 0x17, 0x77, 0x64, 0x33, 0x70, 0x47, 0x00},   // 14 0238 876d Ã£ÂÅ 
    {0x5a, 0x59, 0x22, 0x15, 0x00, 0x02, 0x02, 0x00},   // 14 0239 876e Ã£Å’Â»
    {0x7c, 0x3c, 0x78, 0x00, 0x7c, 0x3c, 0x78, 0x00},   // 14 023a 876f Ã£Å½Å“
    {0x38, 0x44, 0x44, 0x00, 0x7c, 0x3c, 0x78, 0x00},   // 14 023b 8770 Ã£Å½Â
    {0x7f, 0x10, 0x6c, 0x00, 0x7c, 0x3c, 0x78, 0x00},   // 14 023c 8771 Ã£Å½Å¾
    {0x7c, 0x3c, 0x78, 0x00, 0x48, 0x54, 0x3c, 0x00},   // 14 023d 8772 Ã£Å½Å½
    {0x7f, 0x10, 0x6c, 0x00, 0x48, 0x54, 0x3c, 0x00},   // 14 023e 8773 Ã£Å½Â
    {0x38, 0x44, 0x44, 0x00, 0x38, 0x44, 0x44, 0x00},   // 14 023f 8774 Ã£Ââ€ž
    {0x7c, 0x04, 0x78, 0x04, 0x78, 0x0d, 0x0b, 0x00},   // 14 0240 8775 Ã£Å½Â¡
    {0x15, 0x7f, 0x15, 0x40, 0x3e, 0x3f, 0x52, 0x00},   // 15 0241 877e Ã£ÂÂ»
    {0x00, 0x00, 0x00, 0x03, 0x04, 0x03, 0x04, 0x00},   // 16 0242 8780 Ã£â‚¬Â
    {0x10, 0x60, 0x10, 0x60, 0x00, 0x00, 0x00, 0x00},   // 16 0243 8781 Ã£â‚¬Å¸
    {0x7f, 0x04, 0x08, 0x7f, 0x38, 0x44, 0x38, 0x00},   // 16 0244 8782 Ã¢â€žâ€“
    {0x7f, 0x08, 0x77, 0x00, 0x7f, 0x08, 0x77, 0x00},   // 16 0245 8783 Ã£ÂÂ
    {0x01, 0x7f, 0x01, 0x38, 0x54, 0x08, 0x7f, 0x00},   // 16 0246 8784 Ã¢â€žÂ¡
    {0x3e, 0x41, 0x61, 0x7f, 0x65, 0x41, 0x3e, 0x00},   // 16 0247 8785 Ã£Å Â¤
    {0x3e, 0x5d, 0x55, 0x7f, 0x55, 0x5d, 0x3e, 0x00},   // 16 0248 8786 Ã£Å Â¥
    {0x3e, 0x41, 0x43, 0x7f, 0x4b, 0x41, 0x3e, 0x00},   // 16 0249 8787 Ã£Å Â¦
    {0x3e, 0x53, 0x6f, 0x7b, 0x6b, 0x41, 0x3e, 0x00},   // 16 024a 8788 Ã£Å Â§
    {0x3e, 0x55, 0x4f, 0x75, 0x75, 0x41, 0x3e, 0x00},   // 16 024b 8789 Ã£Å Â¨
    {0x3e, 0x5b, 0x7e, 0x16, 0x7c, 0x55, 0x3e, 0x00},   // 16 024c 878a Ã£Ë†Â±
    {0x3e, 0x51, 0x0a, 0x7f, 0x2a, 0x79, 0x3e, 0x00},   // 16 024d 878b Ã£Ë†Â²
    {0x3e, 0x49, 0x3e, 0x04, 0x1e, 0x65, 0x3e, 0x00},   // 16 024e 878c Ã£Ë†Â¹
    {0x4e, 0x3f, 0x7f, 0x00, 0x75, 0x6e, 0x69, 0x00},   // 16 024f 878d Ã£ÂÂ¾
    {0x64, 0x1f, 0x64, 0x79, 0x41, 0x7f, 0x49, 0x00},   // 16 0250 878e Ã£ÂÂ½
    {0x1e, 0x67, 0x6f, 0x00, 0x35, 0x7f, 0x1e, 0x00},   // 16 0251 878f Ã£ÂÂ¼
    {0x14, 0x15, 0x14, 0x14, 0x14, 0x54, 0x14, 0x00},   // 16 0252 8790 Ã¢â€°â€™
    {0x00, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x00},   // 16 0253 8791 Ã¢â€°Â¡
    {0x00, 0x00, 0x46, 0x49, 0x31, 0x00, 0x00, 0x00},   // 16 0254 8792 Ã¢Ë†Â«
    {0x00, 0x08, 0x56, 0x5d, 0x35, 0x08, 0x00, 0x00},   // 16 0255 8793 Ã¢Ë†Â®
    {0x00, 0x41, 0x63, 0x55, 0x49, 0x41, 0x41, 0x00},   // 16 0256 8794 Ã¢Ë†â€˜
    {0x10, 0x70, 0x1c, 0x03, 0x01, 0x01, 0x01, 0x00},   // 16 0257 8795 Ã¢Ë†Å¡
    {0x40, 0x40, 0x40, 0x7e, 0x40, 0x40, 0x40, 0x00},   // 16 0258 8796 Ã¢Å Â¥
    {0x00, 0x40, 0x60, 0x50, 0x48, 0x44, 0x42, 0x00},   // 16 0259 8797 Ã¢Ë†Â 
    {0x00, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00},   // 16 025a 8798 Ã¢Ë†Å¸
    {0x00, 0x40, 0x60, 0x50, 0x48, 0x44, 0x7e, 0x00},   // 16 025b 8799 Ã¢Å Â¿
    {0x00, 0x02, 0x00, 0x20, 0x00, 0x02, 0x00, 0x00},   // 16 025c 879a Ã¢Ë†Âµ
    {0x00, 0x7c, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x00},   // 16 025d 879b Ã¢Ë†Â©
    {0x00, 0x1f, 0x20, 0x20, 0x20, 0x20, 0x1f, 0x00},   // 16 025e 879c Ã¢Ë†Âª
    {0x5d, 0x55, 0x7f, 0x55, 0x7f, 0x55, 0x5d, 0x00},   // 17 025f 889f Ã¤ÂºÅ“
    {0x1e, 0x12, 0x5d, 0x7f, 0x55, 0x7f, 0x5d, 0x00},   // 17 0260 88a0 Ã¥â€â€“
    {0x44, 0x5c, 0x37, 0x2c, 0x5a, 0x7f, 0x5a, 0x00},   // 17 0261 88a1 Ã¥Â¨Æ’
    {0x7f, 0x25, 0x1b, 0x1d, 0x15, 0x5d, 0x7f, 0x00},   // 17 0262 88a2 Ã©ËœÂ¿
    {0x22, 0x2e, 0x7a, 0x4b, 0x1a, 0x2e, 0x52, 0x00},   // 17 0263 88a3 Ã¥â€œâ‚¬
    {0x4d, 0x57, 0x2d, 0x57, 0x3d, 0x57, 0x4d, 0x00},   // 17 0264 88a4 Ã¦â€žâ€º
    {0x52, 0x7f, 0x0a, 0x56, 0x5d, 0x34, 0x56, 0x00},   // 17 0265 88a5 Ã¦Å’Â¨
    {0x44, 0x5c, 0x37, 0x2c, 0x76, 0x55, 0x76, 0x00},   // 17 0266 88a6 Ã¥Â§Â¶
    {0x49, 0x38, 0x52, 0x56, 0x7d, 0x53, 0x54, 0x00},   // 17 0267 88a7 Ã©â‚¬Â¢
    {0x56, 0x4e, 0x57, 0x32, 0x57, 0x4a, 0x56, 0x00},   // 17 0268 88a8 Ã¨â€˜Âµ
    {0x0a, 0x7a, 0x5f, 0x4a, 0x5f, 0x7a, 0x0a, 0x00},   // 17 0269 88a9 Ã¨Å’Å“
    {0x35, 0x7f, 0x15, 0x3a, 0x2d, 0x7f, 0x58, 0x00},   // 17 026a 88aa Ã§Â©Â
    {0x69, 0x3f, 0x4f, 0x5f, 0x6f, 0x1f, 0x69, 0x00},   // 17 026b 88ab Ã¦â€šÂª
    {0x52, 0x7f, 0x4a, 0x3f, 0x5b, 0x77, 0x53, 0x00},   // 17 026c 88ac Ã¦ÂÂ¡
    {0x75, 0x40, 0x3f, 0x53, 0x5b, 0x77, 0x5b, 0x00},   // 17 026d 88ad Ã¦Â¸Â¥
    {0x42, 0x3f, 0x02, 0x7e, 0x5f, 0x55, 0x5f, 0x00},   // 17 026e 88ae Ã¦â€”Â­
    {0x2a, 0x3a, 0x2f, 0x2a, 0x7b, 0x2e, 0x2a, 0x00},   // 17 026f 88af Ã¨â€˜Â¦
    {0x4a, 0x3a, 0x2f, 0x2a, 0x2f, 0x3a, 0x0a, 0x00},   // 17 0270 88b0 Ã¨Å Â¦
    {0x42, 0x1d, 0x5f, 0x4e, 0x55, 0x2a, 0x14, 0x00},   // 17 0271 88b1 Ã©Â¯Âµ
    {0x1a, 0x7f, 0x2a, 0x2e, 0x7b, 0x2e, 0x2a, 0x00},   // 17 0272 88b2 Ã¦Â¢â€œ
    {0x40, 0x3f, 0x41, 0x49, 0x7f, 0x49, 0x41, 0x00},   // 17 0273 88b3 Ã¥Å“Â§
    {0x2d, 0x77, 0x2d, 0x2a, 0x21, 0x7e, 0x24, 0x00},   // 17 0274 88b4 Ã¦â€“Â¡
    {0x52, 0x7f, 0x21, 0x5f, 0x51, 0x27, 0x5c, 0x00},   // 17 0275 88b5 Ã¦â€°Â±
    {0x56, 0x5a, 0x2a, 0x1b, 0x7a, 0x4a, 0x5e, 0x00},   // 17 0276 88b6 Ã¥Â®â€º
    {0x5c, 0x37, 0x4c, 0x7f, 0x55, 0x7f, 0x40, 0x00},   // 17 0277 88b7 Ã¥Â§Â
    {0x4e, 0x7b, 0x2e, 0x3e, 0x42, 0x43, 0x42, 0x00},   // 17 0278 88b8 Ã¨â„¢Â»
    {0x7a, 0x5d, 0x0a, 0x6c, 0x6b, 0x64, 0x08, 0x00},   // 17 0279 88b9 Ã©Â£Â´
    {0x2a, 0x75, 0x2c, 0x7f, 0x56, 0x7e, 0x7e, 0x00},   // 17 027a 88ba Ã§ÂµÂ¢
    {0x2a, 0x75, 0x28, 0x5a, 0x2f, 0x5a, 0x48, 0x00},   // 17 027b 88bb Ã§Â¶Â¾
    {0x42, 0x1d, 0x5f, 0x70, 0x5f, 0x54, 0x74, 0x00},   // 17 027c 88bc Ã©Â®Å½
    {0x42, 0x5a, 0x1a, 0x42, 0x5f, 0x22, 0x53, 0x00},   // 17 027d 88bd Ã¦Ë†â€“
    {0x51, 0x5b, 0x33, 0x7f, 0x33, 0x5b, 0x51, 0x00},   // 17 027e 88be Ã§Â²Å¸
    {0x12, 0x7b, 0x36, 0x00, 0x76, 0x55, 0x76, 0x00},   // 17 027f 88bf Ã¨Â¢Â·
    {0x46, 0x4a, 0x5a, 0x2f, 0x3a, 0x4a, 0x46, 0x00},   // 17 0280 88c0 Ã¥Â®â€°
    {0x40, 0x3e, 0x0a, 0x36, 0x3b, 0x76, 0x4a, 0x00},   // 17 0281 88c1 Ã¥ÂºÂµ
    {0x52, 0x7f, 0x4e, 0x5a, 0x2f, 0x3a, 0x4e, 0x00},   // 17 0282 88c2 Ã¦Å’â€°
    {0x3e, 0x2a, 0x3e, 0x0e, 0x6b, 0x6e, 0x0a, 0x00},   // 17 0283 88c3 Ã¦Å¡â€”
    {0x56, 0x52, 0x3e, 0x7b, 0x36, 0x5a, 0x56, 0x00},   // 17 0284 88c4 Ã¦Â¡Ë†
    {0x7f, 0x2b, 0x7b, 0x6c, 0x7b, 0x2b, 0x7f, 0x00},   // 17 0285 88c5 Ã©â€”â€¡
    {0x37, 0x7e, 0x4f, 0x5a, 0x2f, 0x3a, 0x4e, 0x00},   // 17 0286 88c6 Ã©Å¾Â
    {0x0a, 0x7a, 0x56, 0x5f, 0x56, 0x7a, 0x0a, 0x00},   // 17 0287 88c7 Ã¦ÂÂ
    {0x20, 0x1f, 0x50, 0x42, 0x24, 0x3f, 0x40, 0x00},   // 17 0288 88c8 Ã¤Â»Â¥
    {0x04, 0x7e, 0x05, 0x55, 0x3f, 0x15, 0x1f, 0x00},   // 17 0289 88c9 Ã¤Â¼Å 
    {0x04, 0x7e, 0x43, 0x7e, 0x63, 0x5e, 0x42, 0x00},   // 17 028a 88ca Ã¤Â½Â
    {0x04, 0x7e, 0x13, 0x7a, 0x4f, 0x32, 0x4a, 0x00},   // 17 028b 88cb Ã¤Â¾Â
    {0x04, 0x7e, 0x29, 0x3a, 0x2f, 0x7a, 0x2e, 0x00},   // 17 028c 88cc Ã¥Ââ€°
    {0x7f, 0x55, 0x7f, 0x55, 0x7f, 0x55, 0x7f, 0x00},   // 17 028d 88cd Ã¥â€ºÂ²
    {0x42, 0x5e, 0x56, 0x3f, 0x56, 0x76, 0x42, 0x00},   // 17 028e 88ce Ã¥Â¤Â·
    {0x4a, 0x5a, 0x77, 0x5f, 0x37, 0x5a, 0x4a, 0x00},   // 17 028f 88cf Ã¥Â§â€
    {0x40, 0x3e, 0x56, 0x2e, 0x56, 0x3f, 0x52, 0x00},   // 17 0290 88d0 Ã¥Â¨Â
    {0x40, 0x3f, 0x6b, 0x2b, 0x02, 0x5a, 0x7f, 0x00},   // 17 0291 88d1 Ã¥Â°â€°
    {0x06, 0x7f, 0x04, 0x7f, 0x4a, 0x7f, 0x4a, 0x00},   // 17 0292 88d2 Ã¦Æ’Å¸
    {0x68, 0x2a, 0x5e, 0x5b, 0x7e, 0x0a, 0x68, 0x00},   // 17 0293 88d3 Ã¦â€žÂ
    {0x50, 0x2f, 0x5b, 0x4b, 0x66, 0x12, 0x5f, 0x00},   // 17 0294 88d4 Ã¦â€¦Â°
    {0x20, 0x57, 0x3d, 0x55, 0x35, 0x57, 0x70, 0x00},   // 17 0295 88d5 Ã¦Ëœâ€œ
    {0x1a, 0x7f, 0x12, 0x5a, 0x17, 0x7a, 0x12, 0x00},   // 17 0296 88d6 Ã¦Â¤â€¦
    {0x20, 0x52, 0x1b, 0x56, 0x17, 0x5c, 0x70, 0x00},   // 17 0297 88d7 Ã§â€šÂº
    {0x50, 0x7f, 0x55, 0x1f, 0x35, 0x5f, 0x50, 0x00},   // 17 0298 88d8 Ã§â€¢Â
    {0x50, 0x57, 0x1d, 0x17, 0x1d, 0x57, 0x50, 0x00},   // 17 0299 88d9 Ã§â€¢Â°
    {0x35, 0x7f, 0x15, 0x4a, 0x55, 0x2b, 0x18, 0x00},   // 17 029a 88da Ã§Â§Â»
    {0x2a, 0x75, 0x28, 0x7f, 0x4a, 0x7f, 0x4a, 0x00},   // 17 029b 88db Ã§Â¶Â­
    {0x2a, 0x75, 0x28, 0x3a, 0x2f, 0x7a, 0x2e, 0x00},   // 17 029c 88dc Ã§Â·Â¯
    {0x00, 0x0f, 0x7d, 0x2f, 0x2d, 0x7d, 0x0f, 0x00},   // 17 029d 88dd Ã¨Æ’Æ’
    {0x52, 0x5a, 0x77, 0x5e, 0x37, 0x5a, 0x52, 0x00},   // 17 029e 88de Ã¨ÂÅ½
    {0x12, 0x52, 0x7a, 0x47, 0x1a, 0x32, 0x4a, 0x00},   // 17 029f 88df Ã¨Â¡Â£
    {0x6b, 0x62, 0x0f, 0x7d, 0x2f, 0x7d, 0x0f, 0x00},   // 17 02a0 88e0 Ã¨Â¬â€š
    {0x49, 0x38, 0x54, 0x5d, 0x57, 0x7d, 0x57, 0x00},   // 17 02a1 88e1 Ã©Ââ€¢
    {0x49, 0x38, 0x6e, 0x5a, 0x5f, 0x5a, 0x6e, 0x00},   // 17 02a2 88e2 Ã©ÂÂº
    {0x7f, 0x41, 0x69, 0x6f, 0x5d, 0x6d, 0x69, 0x00},   // 17 02a3 88e3 Ã¥Å’Â»
    {0x12, 0x52, 0x3f, 0x12, 0x12, 0x7f, 0x12, 0x00},   // 17 02a4 88e4 Ã¤Âºâ€¢
    {0x42, 0x4a, 0x56, 0x2b, 0x12, 0x2a, 0x42, 0x00},   // 17 02a5 88e5 Ã¤ÂºÂ¥
    {0x24, 0x3f, 0x5a, 0x5a, 0x22, 0x3f, 0x52, 0x00},   // 17 02a6 88e6 Ã¥Å¸Å¸
    {0x0a, 0x7a, 0x2e, 0x2b, 0x2a, 0x76, 0x0a, 0x00},   // 17 02a7 88e7 Ã¨â€šÂ²
    {0x12, 0x7f, 0x2a, 0x7a, 0x7f, 0x25, 0x1b, 0x00},   // 17 02a8 88e8 Ã©Æ’Â
    {0x09, 0x37, 0x72, 0x3d, 0x48, 0x3a, 0x55, 0x00},   // 17 02a9 88e9 Ã§Â£Â¯
    {0x08, 0x08, 0x08, 0x08, 0x08, 0x0c, 0x08, 0x00},   // 17 02aa 88ea Ã¤Â¸â‚¬
    {0x1a, 0x0a, 0x7a, 0x5f, 0x5a, 0x4a, 0x1a, 0x00},   // 17 02ab 88eb Ã¥Â£Â±
    {0x75, 0x00, 0x4a, 0x77, 0x72, 0x77, 0x4a, 0x00},   // 17 02ac 88ec Ã¦ÂºÂ¢
    {0x49, 0x38, 0x42, 0x6e, 0x5d, 0x7f, 0x6c, 0x00},   // 17 02ad 88ed Ã©â‚¬Â¸
    {0x35, 0x7f, 0x15, 0x72, 0x06, 0x71, 0x75, 0x00},   // 17 02ae 88ee Ã§Â¨Â²
    {0x4a, 0x02, 0x53, 0x4e, 0x3b, 0x4a, 0x5a, 0x00},   // 17 02af 88ef Ã¨Å’Â¨
    {0x22, 0x2a, 0x6f, 0x7a, 0x2f, 0x2a, 0x22, 0x00},   // 17 02b0 88f0 Ã¨Å â€¹
    {0x5d, 0x1f, 0x5d, 0x77, 0x20, 0x5d, 0x77, 0x00},   // 17 02b1 88f1 Ã©Â°Â¯
    {0x44, 0x24, 0x1e, 0x05, 0x7c, 0x42, 0x64, 0x00},   // 17 02b2 88f2 Ã¥â€¦Â
    {0x3e, 0x2a, 0x29, 0x00, 0x7f, 0x01, 0x1f, 0x00},   // 17 02b3 88f3 Ã¥ÂÂ°
    {0x1e, 0x12, 0x7f, 0x55, 0x4f, 0x55, 0x7f, 0x00},   // 17 02b4 88f4 Ã¥â€™Â½
    {0x40, 0x7c, 0x2f, 0x2d, 0x2f, 0x7c, 0x40, 0x00},   // 17 02b5 88f5 Ã¥â€œÂ¡
    {0x7f, 0x65, 0x55, 0x4f, 0x55, 0x65, 0x7f, 0x00},   // 17 02b6 88f6 Ã¥â€ºÂ 
    {0x5f, 0x3c, 0x7f, 0x55, 0x4f, 0x55, 0x7f, 0x00},   // 17 02b7 88f7 Ã¥Â§Â»
    {0x1d, 0x15, 0x55, 0x77, 0x00, 0x00, 0x7f, 0x00},   // 17 02b8 88f8 Ã¥Â¼â€¢
    {0x7a, 0x5d, 0x5a, 0x04, 0x43, 0x3e, 0x46, 0x00},   // 17 02b9 88f9 Ã©Â£Â²
    {0x75, 0x00, 0x56, 0x52, 0x76, 0x51, 0x55, 0x00},   // 17 02ba 88fa Ã¦Â·Â«
    {0x40, 0x3f, 0x7a, 0x2d, 0x78, 0x7f, 0x40, 0x00},   // 17 02bb 88fb Ã¨Æ’Â¤
    {0x7e, 0x36, 0x53, 0x7a, 0x57, 0x3a, 0x52, 0x00},   // 17 02bc 88fc Ã¨â€Â­
    {0x7f, 0x1b, 0x56, 0x3a, 0x1b, 0x7a, 0x56, 0x00},   // 18 02bd 8940 Ã©â„¢Â¢
    {0x7f, 0x1b, 0x54, 0x76, 0x5d, 0x32, 0x54, 0x00},   // 18 02be 8941 Ã©â„¢Â°
    {0x7f, 0x1b, 0x66, 0x3a, 0x5e, 0x59, 0x65, 0x00},   // 18 02bf 8942 Ã©Å¡Â 
    {0x0a, 0x6e, 0x6b, 0x5e, 0x17, 0x17, 0x5c, 0x00},   // 18 02c0 8943 Ã©Å¸Â»
    {0x1e, 0x12, 0x1e, 0x0a, 0x52, 0x7f, 0x02, 0x00},   // 18 02c1 8944 Ã¥Ââ€¹
    {0x12, 0x0a, 0x7f, 0x4a, 0x4a, 0x7a, 0x02, 0x00},   // 18 02c2 8945 Ã¥ÂÂ³
    {0x16, 0x12, 0x56, 0x7f, 0x16, 0x12, 0x16, 0x00},   // 18 02c3 8946 Ã¥Â®â€¡
    {0x40, 0x1e, 0x5a, 0x1b, 0x5a, 0x1e, 0x70, 0x00},   // 18 02c4 8947 Ã§Æ’Â
    {0x21, 0x25, 0x51, 0x7f, 0x25, 0x51, 0x7f, 0x00},   // 18 02c5 8948 Ã§Â¾Â½
    {0x49, 0x38, 0x44, 0x65, 0x7f, 0x45, 0x44, 0x00},   // 18 02c6 8949 Ã¨Â¿â€š
    {0x7d, 0x05, 0x55, 0x7f, 0x05, 0x55, 0x7d, 0x00},   // 18 02c7 894a Ã©â€ºÂ¨
    {0x1e, 0x52, 0x3d, 0x00, 0x7f, 0x01, 0x1f, 0x00},   // 18 02c8 894b Ã¥ÂÂ¯
    {0x5a, 0x2b, 0x7e, 0x6b, 0x5e, 0x17, 0x76, 0x00},   // 18 02c9 894c Ã©ÂµÅ“
    {0x56, 0x3a, 0x56, 0x43, 0x3e, 0x7a, 0x5e, 0x00},   // 18 02ca 894d Ã§ÂªÂº
    {0x48, 0x49, 0x79, 0x4f, 0x49, 0x7f, 0x48, 0x00},   // 18 02cb 894e Ã¤Â¸â€˜
    {0x09, 0x37, 0x31, 0x7f, 0x4a, 0x7f, 0x4a, 0x00},   // 18 02cc 894f Ã§Â¢â€œ
    {0x7e, 0x4a, 0x49, 0x40, 0x4a, 0x4a, 0x7e, 0x00},   // 18 02cd 8950 Ã¨â€¡Â¼
    {0x75, 0x00, 0x78, 0x0f, 0x69, 0x6f, 0x78, 0x00},   // 18 02ce 8951 Ã¦Â¸Â¦
    {0x1e, 0x52, 0x3e, 0x64, 0x4f, 0x6a, 0x4a, 0x00},   // 18 02cf 8952 Ã¥ËœËœ
    {0x1e, 0x12, 0x1e, 0x5f, 0x15, 0x15, 0x5f, 0x00},   // 18 02d0 8953 Ã¥â€â€ž
    {0x0a, 0x7f, 0x7a, 0x5d, 0x1a, 0x7f, 0x0a, 0x00},   // 18 02d1 8954 Ã¦Â¬Â
    {0x42, 0x3e, 0x6f, 0x2e, 0x1b, 0x4a, 0x7e, 0x00},   // 18 02d2 8955 Ã¨â€Å¡
    {0x5d, 0x1f, 0x4c, 0x5f, 0x2d, 0x5f, 0x4c, 0x00},   // 18 02d3 8956 Ã©Â°Â»
    {0x5c, 0x37, 0x2c, 0x1a, 0x6f, 0x4a, 0x49, 0x00},   // 18 02d4 8957 Ã¥Â§Â¥
    {0x40, 0x3f, 0x2d, 0x53, 0x3f, 0x73, 0x5f, 0x00},   // 18 02d5 8958 Ã¥Å½Â©
    {0x75, 0x00, 0x7a, 0x2a, 0x7f, 0x2a, 0x7b, 0x00},   // 18 02d6 8959 Ã¦ÂµÂ¦
    {0x40, 0x3e, 0x42, 0x7e, 0x41, 0x3d, 0x40, 0x00},   // 18 02d7 895a Ã§â€œÅ“
    {0x7f, 0x05, 0x57, 0x7c, 0x57, 0x05, 0x7f, 0x00},   // 18 02d8 895b Ã©â€“Â
    {0x1e, 0x12, 0x1e, 0x37, 0x52, 0x77, 0x1e, 0x00},   // 18 02d9 895c Ã¥â„¢â€š
    {0x44, 0x45, 0x65, 0x5d, 0x45, 0x25, 0x44, 0x00},   // 18 02da 895d Ã¤Âºâ€˜
    {0x49, 0x38, 0x53, 0x5d, 0x7f, 0x5d, 0x53, 0x00},   // 18 02db 895e Ã©Ââ€¹
    {0x56, 0x52, 0x77, 0x57, 0x53, 0x36, 0x56, 0x00},   // 18 02dc 895f Ã©â€ºÂ²
    {0x12, 0x7a, 0x17, 0x56, 0x7f, 0x56, 0x12, 0x00},   // 18 02dd 8960 Ã¨ÂÂ
    {0x7a, 0x5d, 0x5a, 0x21, 0x3f, 0x2d, 0x7f, 0x00},   // 18 02de 8961 Ã©Â¤Å’
    {0x2c, 0x14, 0x6f, 0x76, 0x4d, 0x31, 0x4f, 0x00},   // 18 02df 8962 Ã¥ÂÂ¡
    {0x06, 0x63, 0x6e, 0x7b, 0x6e, 0x63, 0x06, 0x00},   // 18 02e0 8963 Ã¥â€“Â¶
    {0x54, 0x53, 0x7b, 0x54, 0x33, 0x53, 0x54, 0x00},   // 18 02e1 8964 Ã¥Â¬Â°
    {0x44, 0x1f, 0x75, 0x1f, 0x44, 0x4a, 0x25, 0x00},   // 18 02e2 8965 Ã¥Â½Â±
    {0x3e, 0x2a, 0x7e, 0x4e, 0x3b, 0x4e, 0x48, 0x00},   // 18 02e3 8966 Ã¦ËœÂ 
    {0x4e, 0x4a, 0x4f, 0x5a, 0x2e, 0x50, 0x40, 0x00},   // 18 02e4 8967 Ã¦â€ºÂ³
    {0x46, 0x4b, 0x2a, 0x7f, 0x2a, 0x4b, 0x46, 0x00},   // 18 02e5 8968 Ã¦Â â€ž
    {0x28, 0x18, 0x45, 0x7d, 0x10, 0x28, 0x44, 0x00},   // 18 02e6 8969 Ã¦Â°Â¸
    {0x75, 0x28, 0x18, 0x45, 0x7d, 0x10, 0x28, 0x00},   // 18 02e7 896a Ã¦Â³Â³
    {0x75, 0x00, 0x4e, 0x4a, 0x5f, 0x2e, 0x50, 0x00},   // 18 02e8 896b Ã¦Â´Â©
    {0x2a, 0x3e, 0x5a, 0x57, 0x3a, 0x57, 0x5a, 0x00},   // 18 02e9 896c Ã§â€˜â€º
    {0x49, 0x75, 0x5b, 0x75, 0x5b, 0x72, 0x4e, 0x00},   // 18 02ea 896d Ã§â€ºË†
    {0x57, 0x3a, 0x7a, 0x31, 0x5d, 0x17, 0x5d, 0x00},   // 18 02eb 896e Ã§Â©Å½
    {0x57, 0x1a, 0x7a, 0x11, 0x5d, 0x17, 0x5d, 0x00},   // 18 02ec 896f Ã©Â Â´
    {0x52, 0x5a, 0x57, 0x3a, 0x57, 0x5a, 0x52, 0x00},   // 18 02ed 8970 Ã¨â€¹Â±
    {0x0a, 0x7d, 0x2a, 0x77, 0x2e, 0x45, 0x7d, 0x00},   // 18 02ee 8971 Ã¨Â¡â€º
    {0x6a, 0x63, 0x28, 0x5d, 0x7d, 0x10, 0x28, 0x00},   // 18 02ef 8972 Ã¨Â©Â 
    {0x56, 0x7d, 0x4e, 0x3b, 0x0a, 0x7b, 0x4e, 0x00},   // 18 02f0 8973 Ã©â€¹Â­
    {0x75, 0x00, 0x12, 0x7e, 0x53, 0x2a, 0x5a, 0x00},   // 18 02f1 8974 Ã¦Â¶Â²
    {0x54, 0x3e, 0x52, 0x4e, 0x37, 0x7e, 0x52, 0x00},   // 18 02f2 8975 Ã§â€“Â«
    {0x4a, 0x7a, 0x57, 0x72, 0x56, 0x7b, 0x4a, 0x00},   // 18 02f3 8976 Ã§â€ºÅ 
    {0x5f, 0x1f, 0x75, 0x40, 0x3f, 0x19, 0x67, 0x00},   // 18 02f4 8977 Ã©Â§â€¦
    {0x06, 0x7f, 0x4e, 0x3b, 0x0a, 0x7b, 0x4e, 0x00},   // 18 02f5 8978 Ã¦â€šÂ¦
    {0x6a, 0x6b, 0x10, 0x3f, 0x2d, 0x4f, 0x78, 0x00},   // 18 02f6 8979 Ã¨Â¬Â
    {0x6a, 0x3f, 0x4a, 0x7e, 0x62, 0x5f, 0x6a, 0x00},   // 18 02f7 897a Ã¨Â¶Å 
    {0x7f, 0x43, 0x3f, 0x68, 0x5f, 0x43, 0x7f, 0x00},   // 18 02f8 897b Ã©â€“Â²
    {0x1a, 0x7f, 0x51, 0x5f, 0x2f, 0x5f, 0x41, 0x00},   // 18 02f9 897c Ã¦Â¦Å½
    {0x40, 0x3f, 0x7b, 0x7b, 0x45, 0x3f, 0x45, 0x00},   // 18 02fa 897d Ã¥Å½Â­
    {0x7f, 0x09, 0x09, 0x0f, 0x09, 0x49, 0x7f, 0x00},   // 18 02fb 897e Ã¥â€ â€ 
    {0x7f, 0x65, 0x5f, 0x77, 0x5f, 0x65, 0x7f, 0x00},   // 19 02fc 8980 Ã¥Å“â€™
    {0x24, 0x3f, 0x7f, 0x49, 0x6f, 0x57, 0x69, 0x00},   // 19 02fd 8981 Ã¥Â Â°
    {0x0a, 0x3a, 0x36, 0x3b, 0x76, 0x7a, 0x4a, 0x00},   // 19 02fe 8982 Ã¥Â¥â€ž
    {0x56, 0x52, 0x7e, 0x5b, 0x3e, 0x52, 0x56, 0x00},   // 19 02ff 8983 Ã¥Â®Â´
    {0x55, 0x3b, 0x40, 0x5a, 0x52, 0x5e, 0x55, 0x00},   // 19 0300 8984 Ã¥Â»Â¶
    {0x6a, 0x2b, 0x45, 0x53, 0x6f, 0x19, 0x6b, 0x00},   // 19 0301 8985 Ã¦â‚¬Â¨
    {0x52, 0x7f, 0x0a, 0x36, 0x3b, 0x76, 0x4a, 0x00},   // 19 0302 8986 Ã¦Å½Â©
    {0x52, 0x7f, 0x46, 0x2a, 0x5e, 0x29, 0x5d, 0x00},   // 19 0303 8987 Ã¦ÂÂ´
    {0x75, 0x00, 0x08, 0x77, 0x50, 0x77, 0x08, 0x00},   // 19 0304 8988 Ã¦Â²Â¿
    {0x75, 0x00, 0x36, 0x6a, 0x3b, 0x6a, 0x36, 0x00},   // 19 0305 8989 Ã¦Â¼â€
    {0x48, 0x5a, 0x24, 0x13, 0x24, 0x5a, 0x48, 0x00},   // 19 0306 898a Ã§â€šÅ½
    {0x4c, 0x3f, 0x24, 0x7a, 0x01, 0x7d, 0x7b, 0x00},   // 19 0307 898b Ã§â€žâ€
    {0x4c, 0x3f, 0x24, 0x5d, 0x5f, 0x7f, 0x5d, 0x00},   // 19 0308 898c Ã§â€¦â„¢
    {0x56, 0x1e, 0x43, 0x1e, 0x57, 0x1e, 0x56, 0x00},   // 19 0309 898d Ã§â€¡â€¢
    {0x55, 0x4a, 0x3d, 0x7e, 0x57, 0x36, 0x5c, 0x00},   // 19 030a 898e Ã§Å’Â¿
    {0x2a, 0x75, 0x24, 0x5d, 0x75, 0x27, 0x54, 0x00},   // 19 030b 898f Ã§Â¸Â
    {0x5e, 0x77, 0x76, 0x2f, 0x7a, 0x5d, 0x5b, 0x00},   // 19 030c 8990 Ã¨â€°Â¶
    {0x52, 0x5a, 0x2f, 0x1a, 0x7f, 0x4a, 0x5a, 0x00},   // 19 030d 8991 Ã¨â€¹â€˜
    {0x7e, 0x66, 0x5f, 0x76, 0x5f, 0x66, 0x7e, 0x00},   // 19 030e 8992 Ã¨â€“â€”
    {0x49, 0x38, 0x64, 0x5e, 0x77, 0x5e, 0x64, 0x00},   // 19 030f 8993 Ã©ÂÂ 
    {0x56, 0x7d, 0x0a, 0x77, 0x50, 0x77, 0x08, 0x00},   // 19 0310 8994 Ã©â€°â€º
    {0x4a, 0x0b, 0x5d, 0x1b, 0x5f, 0x19, 0x7b, 0x00},   // 19 0311 8995 Ã©Â´â€º
    {0x24, 0x3f, 0x44, 0x6f, 0x6a, 0x6e, 0x42, 0x00},   // 19 0312 8996 Ã¥Â¡Â©
    {0x62, 0x1f, 0x7a, 0x02, 0x29, 0x52, 0x04, 0x00},   // 19 0313 8997 Ã¦â€“Â¼
    {0x65, 0x10, 0x05, 0x1f, 0x15, 0x55, 0x75, 0x00},   // 19 0314 8998 Ã¦Â±Å¡
    {0x2b, 0x3f, 0x2a, 0x5f, 0x35, 0x5f, 0x7f, 0x00},   // 19 0315 8999 Ã§â€Â¥
    {0x7f, 0x41, 0x4f, 0x48, 0x4f, 0x41, 0x7f, 0x00},   // 19 0316 899a Ã¥â€¡Â¹
    {0x48, 0x4e, 0x2a, 0x1f, 0x2a, 0x4e, 0x48, 0x00},   // 19 0317 899b Ã¥Â¤Â®
    {0x50, 0x5e, 0x5a, 0x3f, 0x56, 0x5e, 0x50, 0x00},   // 19 0318 899c Ã¥Â¥Â¥
    {0x0a, 0x7d, 0x44, 0x55, 0x7e, 0x54, 0x44, 0x00},   // 19 0319 899d Ã¥Â¾â‚¬
    {0x40, 0x3e, 0x22, 0x76, 0x4b, 0x62, 0x22, 0x00},   // 19 031a 899e Ã¥Â¿Å“
    {0x52, 0x7f, 0x1f, 0x15, 0x7f, 0x15, 0x1f, 0x00},   // 19 031b 899f Ã¦Å Â¼
    {0x3e, 0x2a, 0x3e, 0x41, 0x49, 0x7f, 0x49, 0x00},   // 19 031c 89a0 Ã¦â€”Âº
    {0x1a, 0x7f, 0x4a, 0x3f, 0x3a, 0x3f, 0x4a, 0x00},   // 19 031d 89a1 Ã¦Â¨Âª
    {0x7f, 0x55, 0x49, 0x14, 0x43, 0x3e, 0x46, 0x00},   // 19 031e 89a2 Ã¦Â¬Â§
    {0x7f, 0x55, 0x49, 0x14, 0x5b, 0x29, 0x5b, 0x00},   // 19 031f 89a3 Ã¦Â®Â´
    {0x41, 0x49, 0x49, 0x7f, 0x49, 0x49, 0x41, 0x00},   // 19 0320 89a4 Ã§Å½â€¹
    {0x4a, 0x5a, 0x2d, 0x78, 0x59, 0x2a, 0x7a, 0x00},   // 19 0321 89a5 Ã§Â¿Â
    {0x12, 0x7b, 0x36, 0x5e, 0x3b, 0x56, 0x5e, 0x00},   // 19 0322 89a6 Ã¨Â¥â€“
    {0x46, 0x03, 0x5a, 0x1f, 0x5a, 0x13, 0x76, 0x00},   // 19 0323 89a7 Ã©Â´Â¬
    {0x7f, 0x55, 0x49, 0x14, 0x5e, 0x17, 0x76, 0x00},   // 19 0324 89a8 Ã©Â´Å½
    {0x4a, 0x7a, 0x2f, 0x3a, 0x2f, 0x7a, 0x4a, 0x00},   // 19 0325 89a9 Ã©Â»â€ž
    {0x7f, 0x35, 0x27, 0x3d, 0x27, 0x35, 0x7f, 0x00},   // 19 0326 89aa Ã¥Â²Â¡
    {0x75, 0x00, 0x1e, 0x12, 0x7f, 0x12, 0x1e, 0x00},   // 19 0327 89ab Ã¦Â²â€“
    {0x56, 0x4a, 0x37, 0x5a, 0x43, 0x3e, 0x4a, 0x00},   // 19 0328 89ac Ã¨ÂÂ»
    {0x04, 0x7e, 0x6b, 0x3e, 0x5b, 0x5e, 0x6a, 0x00},   // 19 0329 89ad Ã¥â€žâ€ž
    {0x40, 0x3f, 0x55, 0x5d, 0x75, 0x4d, 0x57, 0x00},   // 19 032a 89ae Ã¥Â±â€¹
    {0x06, 0x7f, 0x6a, 0x3e, 0x5b, 0x5e, 0x6a, 0x00},   // 19 032b 89af Ã¦â€ Â¶
    {0x7f, 0x15, 0x7f, 0x6e, 0x3b, 0x5e, 0x6a, 0x00},   // 19 032c 89b0 Ã¨â€¡â€ 
    {0x1a, 0x7f, 0x7c, 0x15, 0x7d, 0x17, 0x7d, 0x00},   // 19 032d 89b1 Ã¦Â¡Â¶
    {0x17, 0x7f, 0x4a, 0x44, 0x7f, 0x44, 0x40, 0x00},   // 19 032e 89b2 Ã§â€°Â¡
    {0x20, 0x51, 0x49, 0x45, 0x43, 0x40, 0x60, 0x00},   // 19 032f 89b3 Ã¤Â¹â„¢
    {0x04, 0x7e, 0x0b, 0x36, 0x3b, 0x76, 0x4a, 0x00},   // 19 0330 89b4 Ã¤Â¿Âº
    {0x6c, 0x4b, 0x3e, 0x2a, 0x7f, 0x01, 0x1f, 0x00},   // 19 0331 89b5 Ã¥ÂÂ¸
    {0x60, 0x3f, 0x4d, 0x5b, 0x6d, 0x1f, 0x60, 0x00},   // 19 0332 89b6 Ã¦ÂÂ©
    {0x75, 0x40, 0x77, 0x55, 0x75, 0x77, 0x40, 0x00},   // 19 0333 89b7 Ã¦Â¸Â©
    {0x35, 0x7f, 0x66, 0x3a, 0x5e, 0x59, 0x65, 0x00},   // 19 0334 89b8 Ã§Â©Â
    {0x08, 0x7a, 0x5e, 0x5b, 0x5e, 0x7a, 0x08, 0x00},   // 19 0335 89b9 Ã©Å¸Â³
    {0x01, 0x01, 0x01, 0x7f, 0x05, 0x09, 0x01, 0x00},   // 19 0336 89ba Ã¤Â¸â€¹
    {0x04, 0x7e, 0x01, 0x7f, 0x48, 0x48, 0x64, 0x00},   // 19 0337 89bb Ã¥Å’â€“
    {0x04, 0x7e, 0x41, 0x3f, 0x5d, 0x25, 0x5d, 0x00},   // 19 0338 89bc Ã¤Â»Â®
    {0x04, 0x7e, 0x01, 0x1d, 0x15, 0x5d, 0x7f, 0x00},   // 19 0339 89bd Ã¤Â½â€¢
    {0x0c, 0x7f, 0x62, 0x1f, 0x7e, 0x42, 0x7e, 0x00},   // 19 033a 89be Ã¤Â¼Â½
    {0x04, 0x7e, 0x01, 0x7d, 0x7f, 0x45, 0x7d, 0x00},   // 19 033b 89bf Ã¤Â¾Â¡
    {0x04, 0x7e, 0x49, 0x5a, 0x7f, 0x5a, 0x48, 0x00},   // 19 033c 89c0 Ã¤Â½Â³
    {0x42, 0x3f, 0x42, 0x7e, 0x7e, 0x42, 0x7e, 0x00},   // 19 033d 89c1 Ã¥Å Â 
    {0x01, 0x1d, 0x15, 0x1d, 0x41, 0x7f, 0x01, 0x00},   // 19 033e 89c2 Ã¥ÂÂ¯
    {0x52, 0x36, 0x5e, 0x77, 0x7e, 0x56, 0x72, 0x00},   // 19 033f 89c3 Ã¥Ëœâ€°
    {0x41, 0x51, 0x5f, 0x2f, 0x5f, 0x41, 0x41, 0x00},   // 19 0340 89c4 Ã¥Â¤Â
    {0x5f, 0x3c, 0x26, 0x5a, 0x7b, 0x2a, 0x56, 0x00},   // 19 0341 89c5 Ã¥Â«Â
    {0x56, 0x52, 0x2e, 0x5f, 0x76, 0x22, 0x56, 0x00},   // 19 0342 89c6 Ã¥Â®Â¶
    {0x56, 0x32, 0x5e, 0x3b, 0x7e, 0x32, 0x56, 0x00},   // 19 0343 89c7 Ã¥Â¯Â¡
    {0x35, 0x7f, 0x25, 0x2a, 0x20, 0x7f, 0x10, 0x00},   // 19 0344 89c8 Ã§Â§â€˜
    {0x3e, 0x2a, 0x7f, 0x2b, 0x58, 0x2d, 0x5f, 0x00},   // 19 0345 89c9 Ã¦Å¡â€¡
    {0x50, 0x5f, 0x35, 0x7f, 0x35, 0x5f, 0x50, 0x00},   // 19 0346 89ca Ã¦Å¾Å“
    {0x5a, 0x57, 0x3a, 0x7e, 0x3e, 0x5a, 0x5e, 0x00},   // 19 0347 89cb Ã¦Å¾Â¶
    {0x2d, 0x49, 0x7f, 0x44, 0x43, 0x3e, 0x46, 0x00},   // 19 0348 89cc Ã¦Â­Å’
    {0x75, 0x00, 0x1d, 0x15, 0x1d, 0x41, 0x7f, 0x00},   // 19 0349 89cd Ã¦Â²Â³
    {0x40, 0x4c, 0x20, 0x1f, 0x28, 0x44, 0x40, 0x00},   // 19 034a 89ce Ã§ÂÂ«
    {0x2a, 0x3e, 0x2a, 0x1d, 0x15, 0x5d, 0x7f, 0x00},   // 19 034b 89cf Ã§Ââ€š
    {0x12, 0x7b, 0x16, 0x78, 0x0f, 0x69, 0x7f, 0x00},   // 19 034c 89d0 Ã§Â¦Â
    {0x24, 0x26, 0x16, 0x7e, 0x15, 0x25, 0x24, 0x00},   // 19 034d 89d1 Ã§Â¦Â¾
    {0x35, 0x7f, 0x26, 0x5a, 0x7b, 0x2a, 0x56, 0x00},   // 19 034e 89d2 Ã§Â¨Â¼
    {0x7c, 0x4b, 0x6e, 0x5c, 0x6b, 0x4e, 0x7a, 0x00},   // 19 034f 89d3 Ã§Â®â€¡
    {0x12, 0x7a, 0x07, 0x02, 0x7f, 0x52, 0x6a, 0x00},   // 19 0350 89d4 Ã¨Å Â±
    {0x0a, 0x7a, 0x5f, 0x7a, 0x0f, 0x7a, 0x0a, 0x00},   // 19 0351 89d5 Ã¨â€¹â€º
    {0x52, 0x3a, 0x57, 0x72, 0x77, 0x52, 0x72, 0x00},   // 19 0352 89d6 Ã¨Å’â€ž
    {0x12, 0x7a, 0x07, 0x6a, 0x6f, 0x0a, 0x7a, 0x00},   // 19 0353 89d7 Ã¨ÂÂ·
    {0x2a, 0x3e, 0x2b, 0x7e, 0x2b, 0x3e, 0x2a, 0x00},   // 19 0354 89d8 Ã¨ÂÂ¯
    {0x52, 0x5e, 0x37, 0x7e, 0x37, 0x5e, 0x52, 0x00},   // 19 0355 89d9 Ã¨Ââ€œ
    {0x4e, 0x7b, 0x7f, 0x2b, 0x58, 0x2d, 0x5f, 0x00},   // 19 0356 89da Ã¨ÂÂ¦
    {0x6b, 0x6a, 0x57, 0x35, 0x7f, 0x35, 0x57, 0x00},   // 19 0357 89db Ã¨ÂªÂ²
    {0x1e, 0x1e, 0x2a, 0x3f, 0x7e, 0x3f, 0x2a, 0x00},   // 19 0358 89dc Ã¥ËœÂ©
    {0x44, 0x4e, 0x31, 0x30, 0x3f, 0x7a, 0x4a, 0x00},   // 19 0359 89dd Ã¨Â²Â¨
    {0x49, 0x38, 0x52, 0x4f, 0x5e, 0x52, 0x5e, 0x00},   // 19 035a 89de Ã¨Â¿Â¦
    {0x49, 0x3a, 0x40, 0x78, 0x4f, 0x69, 0x7f, 0x00},   // 19 035b 89df Ã©ÂÅ½
    {0x7e, 0x2a, 0x2f, 0x07, 0x5b, 0x2e, 0x5e, 0x00},   // 19 035c 89e0 Ã©Å“Å¾
    {0x4e, 0x7b, 0x4e, 0x2e, 0x13, 0x2e, 0x42, 0x00},   // 19 035d 89e1 Ã¨Å¡Å 
    {0x0c, 0x7f, 0x26, 0x7e, 0x25, 0x3f, 0x55, 0x00},   // 19 035e 89e2 Ã¤Â¿â€ž
    {0x38, 0x3f, 0x26, 0x7e, 0x25, 0x3f, 0x55, 0x00},   // 19 035f 89e3 Ã¥Â³Â¨
    {0x14, 0x56, 0x7e, 0x15, 0x5f, 0x24, 0x55, 0x00},   // 19 0360 89e4 Ã¦Ë†â€˜
    {0x28, 0x2f, 0x19, 0x49, 0x7f, 0x09, 0x08, 0x00},   // 19 0361 89e5 Ã§â€°â„¢
    {0x7d, 0x41, 0x5d, 0x5f, 0x5d, 0x41, 0x7d, 0x00},   // 19 0362 89e6 Ã§â€Â»
    {0x7f, 0x55, 0x77, 0x5d, 0x40, 0x3f, 0x40, 0x00},   // 19 0363 89e7 Ã¨â€¡Â¥
    {0x52, 0x5e, 0x37, 0x56, 0x7f, 0x16, 0x12, 0x00},   // 19 0364 89e8 Ã¨Å Â½
    {0x4e, 0x7b, 0x26, 0x7e, 0x25, 0x3f, 0x55, 0x00},   // 19 0365 89e9 Ã¨â€ºÂ¾
    {0x4a, 0x47, 0x3a, 0x2e, 0x2e, 0x7a, 0x4e, 0x00},   // 19 0366 89ea Ã¨Â³â‚¬
    {0x2f, 0x59, 0x7f, 0x04, 0x7f, 0x7e, 0x4b, 0x00},   // 19 0367 89eb Ã©â€ºâ€¦
    {0x7a, 0x59, 0x26, 0x7e, 0x25, 0x3f, 0x55, 0x00},   // 19 0368 89ec Ã©Â¤â€œ
    {0x4a, 0x07, 0x5a, 0x16, 0x5e, 0x1a, 0x7e, 0x00},   // 19 0369 89ed Ã©Â§â€¢
    {0x04, 0x44, 0x3a, 0x01, 0x7a, 0x04, 0x04, 0x00},   // 19 036a 89ee Ã¤Â»â€¹
    {0x54, 0x54, 0x72, 0x55, 0x56, 0x34, 0x54, 0x00},   // 19 036b 89ef Ã¤Â¼Å¡
    {0x42, 0x3d, 0x5f, 0x7c, 0x2d, 0x7b, 0x2f, 0x00},   // 19 036c 89f0 Ã¨Â§Â£
    {0x7f, 0x41, 0x5d, 0x55, 0x5d, 0x41, 0x7f, 0x00},   // 19 036d 89f1 Ã¥â€ºÅ¾
    {0x24, 0x3f, 0x5e, 0x2a, 0x7f, 0x6a, 0x5e, 0x00},   // 19 036e 89f2 Ã¥Â¡Å 
    {0x24, 0x3f, 0x32, 0x7e, 0x5f, 0x3a, 0x5e, 0x00},   // 19 036f 89f3 Ã¥Â£Å 
    {0x55, 0x3b, 0x40, 0x7f, 0x5d, 0x55, 0x7f, 0x00},   // 19 0370 89f4 Ã¥Â»Â»
    {0x06, 0x7f, 0x48, 0x4a, 0x3f, 0x4e, 0x48, 0x00},   // 19 0371 89f5 Ã¥Â¿Â«
    {0x06, 0x7f, 0x49, 0x5b, 0x75, 0x5b, 0x48, 0x00},   // 19 0372 89f6 Ã¦â‚¬Âª
    {0x06, 0x7f, 0x14, 0x33, 0x2e, 0x7e, 0x12, 0x00},   // 19 0373 89f7 Ã¦â€šâ€
    {0x06, 0x7f, 0x42, 0x3f, 0x4d, 0x3f, 0x45, 0x00},   // 19 0374 89f8 Ã¦ÂÂ¢
    {0x06, 0x7f, 0x32, 0x7e, 0x5f, 0x3a, 0x5e, 0x00},   // 19 0375 89f9 Ã¦â€¡Â
    {0x52, 0x3a, 0x12, 0x7a, 0x52, 0x3f, 0x52, 0x00},   // 19 0376 89fa Ã¦Ë†â€™
    {0x52, 0x7f, 0x0a, 0x57, 0x35, 0x55, 0x77, 0x00},   // 19 0377 89fb Ã¦â€¹Â
    {0x3d, 0x25, 0x37, 0x44, 0x5f, 0x22, 0x5e, 0x00},   // 19 0378 89fc Ã¦â€Â¹
    {0x4e, 0x3f, 0x7e, 0x55, 0x50, 0x7f, 0x48, 0x00},   // 1a 0379 8a40 Ã©Â­Â
    {0x3e, 0x2a, 0x3e, 0x33, 0x2e, 0x7e, 0x12, 0x00},   // 1a 037a 8a41 Ã¦â„¢Â¦
    {0x1a, 0x7f, 0x0a, 0x3e, 0x4a, 0x3f, 0x52, 0x00},   // 1a 037b 8a42 Ã¦Â¢Â°
    {0x75, 0x00, 0x14, 0x33, 0x2e, 0x7e, 0x12, 0x00},   // 1a 037c 8a43 Ã¦ÂµÂ·
    {0x40, 0x3f, 0x4d, 0x21, 0x1f, 0x29, 0x45, 0x00},   // 1a 037d 8a44 Ã§ÂÂ°
    {0x20, 0x5f, 0x35, 0x1f, 0x75, 0x1f, 0x20, 0x00},   // 1a 037e 8a45 Ã§â€¢Å’
    {0x08, 0x6f, 0x6a, 0x70, 0x6f, 0x6a, 0x0a, 0x00},   // 1a 037f 8a46 Ã§Å¡â€ 
    {0x2a, 0x75, 0x54, 0x72, 0x55, 0x36, 0x54, 0x00},   // 1a 0380 8a47 Ã§ÂµÂµ
    {0x12, 0x52, 0x3b, 0x06, 0x7b, 0x12, 0x12, 0x00},   // 1a 0381 8a48 Ã¨Å Â¥
    {0x52, 0x4d, 0x5f, 0x78, 0x5d, 0x3b, 0x4f, 0x00},   // 1a 0382 8a49 Ã¨Å¸Â¹
    {0x7f, 0x2b, 0x7b, 0x28, 0x7b, 0x2b, 0x7f, 0x00},   // 1a 0383 8a4a Ã©â€“â€¹
    {0x7f, 0x25, 0x1f, 0x6a, 0x70, 0x6f, 0x0a, 0x00},   // 1a 0384 8a4b Ã©Å¡Å½
    {0x40, 0x5f, 0x15, 0x15, 0x15, 0x5f, 0x40, 0x00},   // 1a 0385 8a4c Ã¨Â²Â
    {0x4b, 0x5a, 0x6b, 0x5a, 0x3f, 0x01, 0x7f, 0x00},   // 1a 0386 8a4d Ã¥â€¡Â±
    {0x4a, 0x56, 0x2b, 0x52, 0x3f, 0x42, 0x7e, 0x00},   // 1a 0387 8a4e Ã¥Å Â¾
    {0x48, 0x47, 0x2a, 0x1e, 0x7f, 0x08, 0x10, 0x00},   // 1a 0388 8a4f Ã¥Â¤â€“
    {0x1e, 0x12, 0x1e, 0x4a, 0x56, 0x2b, 0x52, 0x00},   // 1a 0389 8a50 Ã¥â€™Â³
    {0x26, 0x2a, 0x6a, 0x7f, 0x6a, 0x2a, 0x26, 0x00},   // 1a 038a 8a51 Ã¥Â®Â³
    {0x43, 0x3e, 0x42, 0x57, 0x7e, 0x56, 0x43, 0x00},   // 1a 038b 8a52 Ã¥Â´â€“
    {0x06, 0x7f, 0x3e, 0x2e, 0x49, 0x3f, 0x4f, 0x00},   // 1a 038c 8a53 Ã¦â€¦Â¨
    {0x1a, 0x7f, 0x3e, 0x2e, 0x49, 0x3f, 0x4f, 0x00},   // 1a 038d 8a54 Ã¦Â¦â€š
    {0x75, 0x40, 0x3f, 0x41, 0x55, 0x7f, 0x55, 0x00},   // 1a 038e 8a55 Ã¦Â¶Â¯
    {0x09, 0x37, 0x31, 0x34, 0x57, 0x7f, 0x14, 0x00},   // 1a 038f 8a56 Ã§Â¢Â
    {0x4a, 0x7a, 0x5f, 0x7e, 0x5b, 0x76, 0x4a, 0x00},   // 1a 0390 8a57 Ã¨â€œâ€¹
    {0x0a, 0x7d, 0x2a, 0x3f, 0x2a, 0x45, 0x7d, 0x00},   // 1a 0391 8a58 Ã¨Â¡â€”
    {0x6a, 0x6b, 0x00, 0x4a, 0x56, 0x2b, 0x52, 0x00},   // 1a 0392 8a59 Ã¨Â©Â²
    {0x56, 0x7d, 0x4b, 0x5a, 0x6b, 0x5a, 0x4b, 0x00},   // 1a 0393 8a5a Ã©Å½Â§
    {0x0c, 0x77, 0x35, 0x7f, 0x56, 0x2b, 0x52, 0x00},   // 1a 0394 8a5b Ã©ÂªÂ¸
    {0x75, 0x00, 0x5f, 0x55, 0x7f, 0x55, 0x5f, 0x00},   // 1a 0395 8a5c Ã¦ÂµÂ¬
    {0x2a, 0x26, 0x77, 0x5a, 0x7b, 0x25, 0x2b, 0x00},   // 1a 0396 8a5d Ã©Â¦Â¨
    {0x4e, 0x7b, 0x4e, 0x5a, 0x7f, 0x5a, 0x48, 0x00},   // 1a 0397 8a5e Ã¨â€ºâ„¢
    {0x24, 0x3f, 0x41, 0x7f, 0x6b, 0x7f, 0x41, 0x00},   // 1a 0398 8a5f Ã¥Å¾Â£
    {0x1a, 0x7f, 0x3a, 0x0a, 0x7f, 0x0a, 0x3a, 0x00},   // 1a 0399 8a60 Ã¦Å¸Â¿
    {0x4e, 0x7b, 0x4e, 0x3f, 0x65, 0x1d, 0x75, 0x00},   // 1a 039a 8a61 Ã¨â€ºÅ½
    {0x56, 0x7d, 0x36, 0x34, 0x2b, 0x22, 0x7e, 0x00},   // 1a 039b 8a62 Ã©Ë†Å½
    {0x4a, 0x7a, 0x7f, 0x3e, 0x24, 0x40, 0x7f, 0x00},   // 1a 039c 8a63 Ã¥Å Æ’
    {0x1e, 0x5e, 0x3a, 0x7f, 0x4a, 0x3f, 0x7a, 0x00},   // 1a 039d 8a64 Ã¥Å¡â€¡
    {0x10, 0x72, 0x5a, 0x55, 0x5b, 0x70, 0x10, 0x00},   // 1a 039e 8a65 Ã¥Ââ€ž
    {0x40, 0x3e, 0x3a, 0x6e, 0x3b, 0x7e, 0x36, 0x00},   // 1a 039f 8a66 Ã¥Â»â€œ
    {0x52, 0x7f, 0x40, 0x3e, 0x62, 0x5b, 0x62, 0x00},   // 1a 03a0 8a67 Ã¦â€¹Â¡
    {0x52, 0x7f, 0x45, 0x3a, 0x3b, 0x7a, 0x45, 0x00},   // 1a 03a1 8a68 Ã¦â€™Â¹
    {0x1a, 0x7f, 0x10, 0x6a, 0x65, 0x6b, 0x10, 0x00},   // 1a 03a2 8a69 Ã¦Â Â¼
    {0x1a, 0x7f, 0x4a, 0x56, 0x2b, 0x32, 0x4a, 0x00},   // 1a 03a3 8a6a Ã¦Â Â¸
    {0x5a, 0x2f, 0x6a, 0x58, 0x5b, 0x29, 0x5b, 0x00},   // 1a 03a4 8a6b Ã¦Â®Â»
    {0x55, 0x3e, 0x42, 0x5f, 0x2e, 0x5f, 0x4a, 0x00},   // 1a 03a5 8a6c Ã§ÂÂ²
    {0x09, 0x37, 0x31, 0x16, 0x7a, 0x7f, 0x56, 0x00},   // 1a 03a6 8a6d Ã§Â¢Âº
    {0x35, 0x7f, 0x42, 0x5f, 0x2e, 0x5f, 0x4a, 0x00},   // 1a 03a7 8a6e Ã§Â©Â«
    {0x46, 0x43, 0x3e, 0x2b, 0x7e, 0x43, 0x66, 0x00},   // 1a 03a8 8a6f Ã¨Â¦Å¡
    {0x42, 0x3e, 0x15, 0x1d, 0x17, 0x54, 0x7c, 0x00},   // 1a 03a9 8a70 Ã¨Â§â€™
    {0x58, 0x3a, 0x7f, 0x4a, 0x3a, 0x7f, 0x2a, 0x00},   // 1a 03aa 8a71 Ã¨ÂµÂ«
    {0x2d, 0x7f, 0x4a, 0x56, 0x23, 0x56, 0x4a, 0x00},   // 1a 03ab 8a72 Ã¨Â¼Æ’
    {0x22, 0x2e, 0x7b, 0x1e, 0x7f, 0x25, 0x1b, 0x00},   // 1a 03ac 8a73 Ã©Æ’Â­
    {0x7f, 0x23, 0x6b, 0x54, 0x6f, 0x23, 0x7f, 0x00},   // 1a 03ad 8a74 Ã©â€“Â£
    {0x7f, 0x25, 0x1b, 0x79, 0x2f, 0x6f, 0x79, 0x00},   // 1a 03ae 8a75 Ã©Å¡â€
    {0x22, 0x3a, 0x2f, 0x7a, 0x2f, 0x3a, 0x22, 0x00},   // 1a 03af 8a76 Ã©ÂÂ©
    {0x16, 0x13, 0x56, 0x77, 0x1e, 0x13, 0x16, 0x00},   // 1a 03b0 8a77 Ã¥Â­Â¦
    {0x10, 0x7e, 0x56, 0x76, 0x5d, 0x75, 0x10, 0x00},   // 1a 03b1 8a78 Ã¥Â²Â³
    {0x55, 0x52, 0x36, 0x7d, 0x36, 0x52, 0x55, 0x00},   // 1a 03b2 8a79 Ã¦Â¥Â½
    {0x26, 0x6a, 0x57, 0x6e, 0x5d, 0x17, 0x5d, 0x00},   // 1a 03b3 8a7a Ã©Â¡Â
    {0x0b, 0x3f, 0x6c, 0x0b, 0x5d, 0x17, 0x5d, 0x00},   // 1a 03b4 8a7b Ã©Â¡Å½
    {0x52, 0x7f, 0x2a, 0x3f, 0x2a, 0x7f, 0x08, 0x00},   // 1a 03b5 8a7c Ã¦Å½â€º
    {0x44, 0x53, 0x76, 0x5c, 0x73, 0x56, 0x42, 0x00},   // 1a 03b6 8a7d Ã§Â¬Â 
    {0x1a, 0x7f, 0x47, 0x57, 0x7b, 0x55, 0x4b, 0x00},   // 1a 03b7 8a7e Ã¦Â¨Â«
    {0x1a, 0x7f, 0x02, 0x49, 0x7f, 0x7f, 0x49, 0x00},   // 1b 03b8 8a80 Ã¦Â©Â¿
    {0x1a, 0x7f, 0x4a, 0x3f, 0x2b, 0x7f, 0x57, 0x00},   // 1b 03b9 8a81 Ã¦Â¢Â¶
    {0x5d, 0x1f, 0x35, 0x7f, 0x4c, 0x3f, 0x44, 0x00},   // 1b 03ba 8a82 Ã©Â°Â
    {0x75, 0x20, 0x56, 0x1d, 0x54, 0x17, 0x70, 0x00},   // 1b 03bb 8a83 Ã¦Â½Å¸
    {0x26, 0x6a, 0x7f, 0x6a, 0x2e, 0x40, 0x7f, 0x00},   // 1b 03bc 8a84 Ã¥â€°Â²
    {0x1e, 0x1e, 0x10, 0x3f, 0x2d, 0x4f, 0x78, 0x00},   // 1b 03bd 8a85 Ã¥â€“Â
    {0x06, 0x7f, 0x04, 0x72, 0x55, 0x76, 0x04, 0x00},   // 1b 03be 8a86 Ã¦ÂÂ°
    {0x52, 0x7f, 0x04, 0x76, 0x5e, 0x75, 0x04, 0x00},   // 1b 03bf 8a87 Ã¦â€¹Â¬
    {0x65, 0x10, 0x04, 0x76, 0x5e, 0x75, 0x04, 0x00},   // 1b 03c0 8a88 Ã¦Â´Â»
    {0x75, 0x00, 0x10, 0x3f, 0x2d, 0x4f, 0x78, 0x00},   // 1b 03c1 8a89 Ã¦Â¸â€¡
    {0x75, 0x00, 0x0c, 0x77, 0x35, 0x77, 0x0c, 0x00},   // 1b 03c2 8a8a Ã¦Â»â€˜
    {0x22, 0x1e, 0x7b, 0x5a, 0x1b, 0x5e, 0x72, 0x00},   // 1b 03c3 8a8b Ã¨â€˜â€º
    {0x12, 0x7b, 0x36, 0x3f, 0x2d, 0x4f, 0x78, 0x00},   // 1b 03c4 8a8c Ã¨Â¤Â
    {0x2d, 0x7f, 0x26, 0x6a, 0x7f, 0x6a, 0x26, 0x00},   // 1b 03c5 8a8d Ã¨Â½â€ž
    {0x40, 0x7f, 0x55, 0x55, 0x55, 0x7f, 0x40, 0x00},   // 1b 03c6 8a8e Ã¤Â¸â€
    {0x5d, 0x1f, 0x47, 0x57, 0x7b, 0x55, 0x4b, 0x00},   // 1b 03c7 8a8f Ã©Â°Â¹
    {0x1e, 0x12, 0x1e, 0x04, 0x7f, 0x04, 0x04, 0x00},   // 1b 03c8 8a90 Ã¥ÂÂ¶
    {0x1a, 0x7f, 0x12, 0x7b, 0x02, 0x7f, 0x52, 0x00},   // 1b 03c9 8a91 Ã¦Â¤â€º
    {0x1a, 0x7f, 0x2a, 0x3f, 0x7e, 0x3f, 0x2a, 0x00},   // 1b 03ca 8a92 Ã¦Â¨Âº
    {0x37, 0x7e, 0x37, 0x04, 0x73, 0x56, 0x5e, 0x00},   // 1b 03cb 8a93 Ã©Å¾â€ž
    {0x1a, 0x7f, 0x4c, 0x2b, 0x7f, 0x2a, 0x48, 0x00},   // 1b 03cc 8a94 Ã¦Â Âª
    {0x5e, 0x51, 0x3e, 0x15, 0x7e, 0x51, 0x5f, 0x00},   // 1b 03cd 8a95 Ã¥â€¦Å“
    {0x06, 0x3a, 0x36, 0x3b, 0x7e, 0x7a, 0x46, 0x00},   // 1b 03ce 8a96 Ã§Â«Æ’
    {0x56, 0x02, 0x7b, 0x2a, 0x7f, 0x2a, 0x7a, 0x00},   // 1b 03cf 8a97 Ã¨â€™Â²
    {0x4a, 0x6a, 0x55, 0x7c, 0x55, 0x6a, 0x4a, 0x00},   // 1b 03d0 8a98 Ã©â€¡Å“
    {0x56, 0x7d, 0x4a, 0x2b, 0x7e, 0x3f, 0x5a, 0x00},   // 1b 03d1 8a99 Ã©Å½Å’
    {0x1e, 0x12, 0x7e, 0x6f, 0x54, 0x6f, 0x7a, 0x00},   // 1b 03d2 8a9a Ã¥â„¢â€º
    {0x0f, 0x3f, 0x4f, 0x1e, 0x57, 0x16, 0x70, 0x00},   // 1b 03d3 8a9b Ã©Â´Â¨
    {0x1a, 0x7f, 0x0a, 0x7d, 0x57, 0x55, 0x7d, 0x00},   // 1b 03d4 8a9c Ã¦Â Â¢
    {0x52, 0x56, 0x37, 0x56, 0x7f, 0x16, 0x32, 0x00},   // 1b 03d5 8a9d Ã¨Å’â€¦
    {0x5a, 0x4a, 0x7f, 0x7a, 0x7f, 0x4a, 0x5a, 0x00},   // 1b 03d6 8a9e Ã¨ÂÂ±
    {0x5d, 0x77, 0x2a, 0x7f, 0x2a, 0x5d, 0x77, 0x00},   // 1b 03d7 8a9f Ã§Â²Â¥
    {0x40, 0x24, 0x18, 0x27, 0x0e, 0x40, 0x7f, 0x00},   // 1b 03d8 8aa0 Ã¥Ë†Ë†
    {0x42, 0x2a, 0x13, 0x2e, 0x1b, 0x42, 0x7e, 0x00},   // 1b 03d9 8aa1 Ã¨â€¹â€¦
    {0x41, 0x41, 0x7f, 0x55, 0x05, 0x7d, 0x41, 0x00},   // 1b 03da 8aa2 Ã§â€œÂ¦
    {0x2d, 0x77, 0x2d, 0x23, 0x56, 0x4e, 0x62, 0x00},   // 1b 03db 8aa3 Ã¤Â¹Â¾
    {0x04, 0x7e, 0x41, 0x37, 0x75, 0x05, 0x77, 0x00},   // 1b 03dc 8aa4 Ã¤Â¾Æ’
    {0x53, 0x35, 0x75, 0x51, 0x69, 0x7d, 0x4b, 0x00},   // 1b 03dd 8aa5 Ã¥â€ Â 
    {0x26, 0x1a, 0x3e, 0x3b, 0x5e, 0x1a, 0x26, 0x00},   // 1b 03de 8aa6 Ã¥Â¯â€™
    {0x08, 0x09, 0x7f, 0x09, 0x0e, 0x40, 0x7f, 0x00},   // 1b 03df 8aa7 Ã¥Ë†Å 
    {0x72, 0x5f, 0x72, 0x5f, 0x62, 0x1f, 0x7e, 0x00},   // 1b 03e0 8aa8 Ã¥â€¹Ëœ
    {0x14, 0x7b, 0x7e, 0x4a, 0x62, 0x1f, 0x7e, 0x00},   // 1b 03e1 8aa9 Ã¥â€¹Â§
    {0x14, 0x0d, 0x76, 0x57, 0x5e, 0x4d, 0x14, 0x00},   // 1b 03e2 8aaa Ã¥Â·Â»
    {0x1e, 0x1e, 0x52, 0x5d, 0x3d, 0x5f, 0x50, 0x00},   // 1b 03e3 8aab Ã¥â€“Å¡
    {0x24, 0x3f, 0x72, 0x5f, 0x72, 0x5f, 0x52, 0x00},   // 1b 03e4 8aac Ã¥Â Âª
    {0x52, 0x3a, 0x5e, 0x3b, 0x56, 0x3a, 0x52, 0x00},   // 1b 03e5 8aad Ã¥Â§Â¦
    {0x56, 0x52, 0x36, 0x17, 0x76, 0x52, 0x56, 0x00},   // 1b 03e6 8aae Ã¥Â®Å’
    {0x06, 0x02, 0x7e, 0x57, 0x5e, 0x72, 0x06, 0x00},   // 1b 03e7 8aaf Ã¥Â®Ëœ
    {0x46, 0x4a, 0x3e, 0x3b, 0x7e, 0x4a, 0x66, 0x00},   // 1b 03e8 8ab0 Ã¥Â¯â€º
    {0x08, 0x09, 0x09, 0x7f, 0x09, 0x09, 0x08, 0x00},   // 1b 03e9 8ab1 Ã¥Â¹Â²
    {0x2d, 0x77, 0x2d, 0x00, 0x2a, 0x79, 0x2a, 0x00},   // 1b 03ea 8ab2 Ã¥Â¹Â¹
    {0x60, 0x38, 0x5e, 0x5f, 0x7e, 0x18, 0x60, 0x00},   // 1b 03eb 8ab3 Ã¦â€šÂ£
    {0x68, 0x26, 0x4e, 0x4e, 0x62, 0x07, 0x6a, 0x00},   // 1b 03ec 8ab4 Ã¦â€žÅ¸
    {0x06, 0x7f, 0x42, 0x3f, 0x3d, 0x3f, 0x42, 0x00},   // 1b 03ed 8ab5 Ã¦â€¦Â£
    {0x06, 0x7f, 0x6e, 0x2e, 0x42, 0x47, 0x6a, 0x00},   // 1b 03ee 8ab6 Ã¦â€ Â¾
    {0x52, 0x7f, 0x52, 0x5d, 0x3d, 0x5f, 0x50, 0x00},   // 1b 03ef 8ab7 Ã¦Ââ€º
    {0x24, 0x3d, 0x27, 0x7d, 0x5c, 0x23, 0x5e, 0x00},   // 1b 03f0 8ab8 Ã¦â€¢Â¢
    {0x1a, 0x7f, 0x02, 0x7f, 0x4a, 0x7f, 0x02, 0x00},   // 1b 03f1 8ab9 Ã¦Å¸â€˜
    {0x1a, 0x7f, 0x41, 0x7f, 0x6b, 0x7f, 0x41, 0x00},   // 1b 03f2 8aba Ã¦Â¡â€œ
    {0x1a, 0x7f, 0x06, 0x7a, 0x5b, 0x5a, 0x76, 0x00},   // 1b 03f3 8abb Ã¦Â£Âº
    {0x2a, 0x6f, 0x2a, 0x44, 0x43, 0x3e, 0x46, 0x00},   // 1b 03f4 8abc Ã¦Â¬Â¾
    {0x14, 0x7b, 0x7e, 0x4a, 0x44, 0x3b, 0x46, 0x00},   // 1b 03f5 8abd Ã¦Â­â€œ
    {0x75, 0x00, 0x08, 0x09, 0x7f, 0x09, 0x08, 0x00},   // 1b 03f6 8abe Ã¦Â±â€”
    {0x75, 0x12, 0x5e, 0x5b, 0x3e, 0x5b, 0x5e, 0x00},   // 1b 03f7 8abf Ã¦Â¼Â¢
    {0x75, 0x00, 0x7f, 0x03, 0x38, 0x3b, 0x7f, 0x00},   // 1b 03f8 8ac0 Ã¦Â¾â€”
    {0x75, 0x00, 0x14, 0x7b, 0x4e, 0x7a, 0x4a, 0x00},   // 1b 03f9 8ac1 Ã¦Â½â€¦
    {0x2a, 0x3e, 0x47, 0x3d, 0x6f, 0x3d, 0x47, 0x00},   // 1b 03fa 8ac2 Ã§â€™Â°
    {0x02, 0x02, 0x7f, 0x4a, 0x4a, 0x7f, 0x02, 0x00},   // 1b 03fb 8ac3 Ã§â€Ëœ
    {0x4f, 0x7f, 0x59, 0x74, 0x53, 0x7a, 0x4a, 0x00},   // 1b 03fc 8ac4 Ã§â€ºÂ£
    {0x28, 0x1a, 0x7e, 0x5e, 0x5d, 0x7d, 0x08, 0x00},   // 1b 03fd 8ac5 Ã§Å“â€¹
    {0x24, 0x2b, 0x2e, 0x7c, 0x2b, 0x2e, 0x22, 0x00},   // 1b 03fe 8ac6 Ã§Â«Â¿
    {0x1c, 0x0b, 0x7e, 0x7c, 0x6b, 0x6e, 0x1a, 0x00},   // 1b 03ff 8ac7 Ã§Â®Â¡
    {0x7c, 0x1b, 0x7e, 0x64, 0x7b, 0x1e, 0x7a, 0x00},   // 1b 0400 8ac8 Ã§Â°Â¡
    {0x2a, 0x75, 0x46, 0x2a, 0x5e, 0x29, 0x5d, 0x00},   // 1b 0401 8ac9 Ã§Â·Â©
    {0x0c, 0x6b, 0x4a, 0x7e, 0x4a, 0x6a, 0x08, 0x00},   // 1b 0402 8aca Ã§Â¼Â¶
    {0x2d, 0x77, 0x4d, 0x2a, 0x79, 0x2a, 0x7c, 0x00},   // 1b 0403 8acb Ã§Â¿Â°
    {0x7f, 0x15, 0x7f, 0x08, 0x09, 0x7f, 0x09, 0x00},   // 1b 0404 8acc Ã¨â€šÂ
    {0x7e, 0x13, 0x7e, 0x4f, 0x60, 0x6b, 0x4a, 0x00},   // 1b 0405 8acd Ã¨â€°Â¦
    {0x56, 0x52, 0x37, 0x16, 0x77, 0x52, 0x56, 0x00},   // 1b 0406 8ace Ã¨Å½Å¾
    {0x14, 0x7b, 0x7e, 0x4a, 0x3f, 0x75, 0x5f, 0x00},   // 1b 0407 8acf Ã¨Â¦Â³
    {0x6b, 0x6a, 0x42, 0x2e, 0x7f, 0x2e, 0x42, 0x00},   // 1b 0408 8ad0 Ã¨Â«Å’
    {0x42, 0x7f, 0x2d, 0x2f, 0x2d, 0x7f, 0x42, 0x00},   // 1b 0409 8ad1 Ã¨Â²Â«
    {0x49, 0x38, 0x63, 0x5f, 0x77, 0x5f, 0x63, 0x00},   // 1b 040a 8ad2 Ã©â€šâ€ž
    {0x56, 0x7d, 0x36, 0x4f, 0x60, 0x6b, 0x4a, 0x00},   // 1b 040b 8ad3 Ã©â€˜â€˜
    {0x7f, 0x05, 0x7f, 0x54, 0x7f, 0x05, 0x7f, 0x00},   // 1b 040c 8ad4 Ã©â€“â€œ
    {0x7f, 0x2b, 0x1b, 0x7c, 0x1b, 0x2b, 0x7f, 0x00},   // 1b 040d 8ad5 Ã©â€“â€˜
    {0x7f, 0x13, 0x57, 0x38, 0x57, 0x13, 0x7f, 0x00},   // 1b 040e 8ad6 Ã©â€“Â¢
    {0x7f, 0x25, 0x1b, 0x7a, 0x01, 0x7d, 0x7b, 0x00},   // 1b 040f 8ad7 Ã©â„¢Â¥
    {0x2d, 0x77, 0x2d, 0x3a, 0x2f, 0x7a, 0x2e, 0x00},   // 1b 0410 8ad8 Ã©Å¸â€œ
    {0x7a, 0x5d, 0x5a, 0x06, 0x7a, 0x5b, 0x76, 0x00},   // 1b 0411 8ad9 Ã©Â¤Â¨
    {0x6a, 0x5d, 0x6a, 0x06, 0x7a, 0x5b, 0x76, 0x00},   // 1b 0412 8ada Ã¨Ë†Ëœ
    {0x42, 0x2a, 0x1f, 0x12, 0x7e, 0x40, 0x60, 0x00},   // 1b 0413 8adb Ã¤Â¸Â¸
    {0x04, 0x74, 0x56, 0x55, 0x5e, 0x74, 0x04, 0x00},   // 1b 0414 8adc Ã¥ÂÂ«
    {0x43, 0x3e, 0x22, 0x2b, 0x7a, 0x2a, 0x23, 0x00},   // 1b 0415 8add Ã¥Â²Â¸
    {0x43, 0x3e, 0x2a, 0x7f, 0x5a, 0x2e, 0x5b, 0x00},   // 1b 0416 8ade Ã¥Â·Å’
    {0x2a, 0x3e, 0x44, 0x3d, 0x05, 0x7d, 0x44, 0x00},   // 1b 0417 8adf Ã§Å½Â©
    {0x54, 0x3e, 0x7a, 0x5e, 0x67, 0x5e, 0x7a, 0x00},   // 1b 0418 8ae0 Ã§â„¢Å’
    {0x7f, 0x55, 0x7f, 0x7f, 0x55, 0x35, 0x5f, 0x00},   // 1b 0419 8ae1 Ã§Å“Â¼
    {0x28, 0x1b, 0x6a, 0x6b, 0x6a, 0x6b, 0x08, 0x00},   // 1b 041a 8ae2 Ã¥Â²Â©
    {0x05, 0x6f, 0x75, 0x6f, 0x44, 0x3d, 0x45, 0x00},   // 1b 041b 8ae3 Ã§Â¿Â«
    {0x40, 0x3f, 0x4d, 0x33, 0x3d, 0x3f, 0x4b, 0x00},   // 1b 041c 8ae4 Ã¨Â´â€¹
    {0x40, 0x3f, 0x7d, 0x0b, 0x7d, 0x7f, 0x55, 0x00},   // 1b 041d 8ae5 Ã©â€ºÂ
    {0x24, 0x1d, 0x3d, 0x24, 0x5d, 0x17, 0x5d, 0x00},   // 1b 041e 8ae6 Ã©Â â€˜
    {0x7a, 0x0e, 0x5b, 0x2e, 0x5d, 0x17, 0x5d, 0x00},   // 1b 041f 8ae7 Ã©Â¡â€
    {0x7f, 0x2d, 0x7f, 0x2d, 0x5d, 0x17, 0x5d, 0x00},   // 1b 0420 8ae8 Ã©Â¡Ëœ
    {0x44, 0x74, 0x42, 0x7d, 0x52, 0x54, 0x44, 0x00},   // 1b 0421 8ae9 Ã¤Â¼Â
    {0x04, 0x7e, 0x4b, 0x5a, 0x2f, 0x5a, 0x42, 0x00},   // 1b 0422 8aea Ã¤Â¼Å½
    {0x42, 0x3e, 0x05, 0x7d, 0x4f, 0x5c, 0x64, 0x00},   // 1b 0423 8aeb Ã¥ÂÂ±
    {0x12, 0x76, 0x5e, 0x57, 0x5e, 0x76, 0x12, 0x00},   // 1b 0424 8aec Ã¥â€“Å“
    {0x28, 0x6b, 0x6b, 0x1c, 0x6b, 0x6b, 0x28, 0x00},   // 1b 0425 8aed Ã¥â„¢Â¨
    {0x28, 0x1a, 0x4f, 0x6a, 0x4f, 0x1a, 0x28, 0x00},   // 1b 0426 8aee Ã¥Å¸Âº
    {0x10, 0x72, 0x5a, 0x77, 0x1a, 0x72, 0x10, 0x00},   // 1b 0427 8aef Ã¥Â¥â€¡
    {0x5f, 0x3c, 0x12, 0x7e, 0x57, 0x7e, 0x12, 0x00},   // 1b 0428 8af0 Ã¥Â¬â€°
    {0x16, 0x72, 0x5a, 0x77, 0x1a, 0x72, 0x16, 0x00},   // 1b 0429 8af1 Ã¥Â¯â€ž
    {0x38, 0x3f, 0x4a, 0x5a, 0x2f, 0x5a, 0x42, 0x00},   // 1b 042a 8af2 Ã¥Â²Â
    {0x28, 0x18, 0x6d, 0x2a, 0x7a, 0x2d, 0x68, 0x00},   // 1b 042b 8af3 Ã¥Â¸Å’
    {0x4a, 0x3d, 0x28, 0x4f, 0x5a, 0x2d, 0x50, 0x00},   // 1b 042c 8af4 Ã¥Â¹Â¾
    {0x60, 0x3d, 0x55, 0x55, 0x75, 0x17, 0x60, 0x00},   // 1b 042d 8af5 Ã¥Â¿Å’
    {0x52, 0x7f, 0x27, 0x3d, 0x7f, 0x3d, 0x27, 0x00},   // 1b 042e 8af6 Ã¦ÂÂ®
    {0x1a, 0x7f, 0x4a, 0x3f, 0x01, 0x7f, 0x40, 0x00},   // 1b 042f 8af7 Ã¦Å“Âº
    {0x62, 0x1f, 0x7a, 0x54, 0x1f, 0x1e, 0x52, 0x00},   // 1b 0430 8af8 Ã¦â€”â€”
    {0x7f, 0x55, 0x5f, 0x49, 0x2f, 0x79, 0x4f, 0x00},   // 1b 0431 8af9 Ã¦â€”Â¢
    {0x52, 0x1f, 0x1a, 0x5f, 0x3f, 0x55, 0x7f, 0x00},   // 1b 0432 8afa Ã¦Å“Å¸
    {0x1a, 0x7f, 0x52, 0x1f, 0x1a, 0x1f, 0x52, 0x00},   // 1b 0433 8afb Ã¦Â£â€¹
    {0x52, 0x5a, 0x3e, 0x7b, 0x36, 0x5a, 0x52, 0x00},   // 1b 0434 8afc Ã¦Â£â€ž
    {0x1a, 0x7f, 0x4a, 0x3d, 0x48, 0x3a, 0x55, 0x00},   // 1c 0435 8b40 Ã¦Â©Å¸
    {0x4e, 0x3f, 0x0c, 0x35, 0x7d, 0x37, 0x0c, 0x00},   // 1c 0436 8b41 Ã¥Â¸Â°
    {0x2a, 0x5e, 0x7b, 0x2e, 0x5b, 0x29, 0x5b, 0x00},   // 1c 0437 8b42 Ã¦Â¯â€¦
    {0x44, 0x5b, 0x2e, 0x5e, 0x0e, 0x3a, 0x42, 0x00},   // 1c 0438 8b43 Ã¦Â°â€”
    {0x75, 0x04, 0x0b, 0x0e, 0x0e, 0x3a, 0x42, 0x00},   // 1c 0439 8b44 Ã¦Â±Â½
    {0x6a, 0x6d, 0x68, 0x0f, 0x5a, 0x2d, 0x50, 0x00},   // 1c 043a 8b45 Ã§â€¢Â¿
    {0x12, 0x7b, 0x16, 0x40, 0x3e, 0x0a, 0x79, 0x00},   // 1c 043b 8b46 Ã§Â¥Ë†
    {0x2a, 0x2a, 0x27, 0x6f, 0x3f, 0x26, 0x2a, 0x00},   // 1c 043c 8b47 Ã¥Â­Â£
    {0x35, 0x7f, 0x48, 0x2d, 0x7a, 0x2d, 0x68, 0x00},   // 1c 043d 8b48 Ã§Â¨â‚¬
    {0x2a, 0x75, 0x28, 0x79, 0x49, 0x49, 0x6f, 0x00},   // 1c 043e 8b49 Ã§Â´â‚¬
    {0x0a, 0x7d, 0x2a, 0x77, 0x2a, 0x3f, 0x5e, 0x00},   // 1c 043f 8b4a Ã¥Â¾Â½
    {0x4a, 0x3f, 0x2a, 0x5f, 0x35, 0x75, 0x5f, 0x00},   // 1c 0440 8b4b Ã¨Â¦Â
    {0x6a, 0x6b, 0x02, 0x79, 0x49, 0x49, 0x6f, 0x00},   // 1c 0441 8b4c Ã¨Â¨Ëœ
    {0x48, 0x7e, 0x2a, 0x2f, 0x2a, 0x7e, 0x48, 0x00},   // 1c 0442 8b4d Ã¨Â²Â´
    {0x4a, 0x3a, 0x3f, 0x4a, 0x5d, 0x55, 0x57, 0x00},   // 1c 0443 8b4e Ã¨ÂµÂ·
    {0x2d, 0x7f, 0x42, 0x3f, 0x02, 0x7e, 0x40, 0x00},   // 1c 0444 8b4f Ã¨Â»Å’
    {0x4a, 0x3c, 0x3f, 0x27, 0x3d, 0x7f, 0x27, 0x00},   // 1c 0445 8b50 Ã¨Â¼Â
    {0x7a, 0x5d, 0x5a, 0x3f, 0x01, 0x7f, 0x40, 0x00},   // 1c 0446 8b51 Ã©Â£Â¢
    {0x5f, 0x1f, 0x75, 0x12, 0x5a, 0x17, 0x7a, 0x00},   // 1c 0447 8b52 Ã©Â¨Å½
    {0x40, 0x5e, 0x3a, 0x1f, 0x7a, 0x6e, 0x50, 0x00},   // 1c 0448 8b53 Ã©Â¬Â¼
    {0x3a, 0x2e, 0x2d, 0x3d, 0x6f, 0x78, 0x40, 0x00},   // 1c 0449 8b54 Ã¤Âºâ‚¬
    {0x0c, 0x7f, 0x52, 0x1b, 0x56, 0x1f, 0x70, 0x00},   // 1c 044a 8b55 Ã¥ÂÂ½
    {0x0c, 0x7f, 0x2a, 0x7b, 0x2e, 0x3b, 0x5a, 0x00},   // 1c 044b 8b56 Ã¥â€žâ‚¬
    {0x44, 0x5c, 0x37, 0x4c, 0x5a, 0x2f, 0x5a, 0x00},   // 1c 044c 8b57 Ã¥Â¦â€œ
    {0x46, 0x42, 0x7e, 0x57, 0x7e, 0x42, 0x46, 0x00},   // 1c 044d 8b58 Ã¥Â®Å“
    {0x7c, 0x44, 0x7f, 0x2a, 0x44, 0x3f, 0x55, 0x00},   // 1c 044e 8b59 Ã¦Ë†Â¯
    {0x52, 0x7f, 0x4a, 0x5a, 0x2f, 0x5a, 0x42, 0x00},   // 1c 044f 8b5a Ã¦Å â‚¬
    {0x52, 0x7f, 0x57, 0x3a, 0x5a, 0x3d, 0x57, 0x00},   // 1c 0450 8b5b Ã¦â€œÂ¬
    {0x52, 0x1f, 0x1a, 0x5f, 0x52, 0x3b, 0x46, 0x00},   // 1c 0451 8b5c Ã¦Â¬Âº
    {0x17, 0x7f, 0x2a, 0x7b, 0x2e, 0x3b, 0x5a, 0x00},   // 1c 0452 8b5d Ã§Å Â 
    {0x57, 0x3a, 0x5a, 0x65, 0x3d, 0x57, 0x4d, 0x00},   // 1c 0453 8b5e Ã§â€“â€˜
    {0x12, 0x7b, 0x16, 0x7e, 0x4a, 0x3e, 0x49, 0x00},   // 1c 0454 8b5f Ã§Â¥â€¡
    {0x2a, 0x2a, 0x7b, 0x2e, 0x7a, 0x2b, 0x5a, 0x00},   // 1c 0455 8b60 Ã§Â¾Â©
    {0x4e, 0x7f, 0x2a, 0x7b, 0x2e, 0x3b, 0x5a, 0x00},   // 1c 0456 8b61 Ã¨Å¸Â»
    {0x6b, 0x6a, 0x46, 0x7a, 0x5b, 0x7a, 0x46, 0x00},   // 1c 0457 8b62 Ã¨ÂªÂ¼
    {0x6b, 0x62, 0x2a, 0x7b, 0x2e, 0x3b, 0x5a, 0x00},   // 1c 0458 8b63 Ã¨Â­Â°
    {0x52, 0x7f, 0x04, 0x57, 0x3a, 0x56, 0x7e, 0x00},   // 1c 0459 8b64 Ã¦Å½Â¬
    {0x12, 0x5e, 0x2b, 0x7a, 0x2b, 0x5a, 0x7a, 0x00},   // 1c 045a 8b65 Ã¨ÂÅ 
    {0x37, 0x7e, 0x37, 0x57, 0x3a, 0x56, 0x7e, 0x00},   // 1c 045b 8b66 Ã©Å¾Â 
    {0x02, 0x6a, 0x6a, 0x6f, 0x6a, 0x6a, 0x02, 0x00},   // 1c 045c 8b67 Ã¥Ââ€°
    {0x1e, 0x1e, 0x04, 0x23, 0x56, 0x4e, 0x62, 0x00},   // 1c 045d 8b68 Ã¥ÂÆ’
    {0x1e, 0x1e, 0x4a, 0x5f, 0x3a, 0x57, 0x4f, 0x00},   // 1c 045e 8b69 Ã¥â€“Â«
    {0x1a, 0x7f, 0x02, 0x6a, 0x6f, 0x6a, 0x02, 0x00},   // 1c 045f 8b6a Ã¦Â¡â€
    {0x1a, 0x7f, 0x7a, 0x37, 0x5f, 0x33, 0x76, 0x00},   // 1c 0460 8b6b Ã¦Â©Ëœ
    {0x6b, 0x6a, 0x02, 0x6a, 0x6f, 0x6a, 0x02, 0x00},   // 1c 0461 8b6c Ã¨Â©Â°
    {0x09, 0x37, 0x31, 0x70, 0x5f, 0x54, 0x74, 0x00},   // 1c 0462 8b6d Ã§Â Â§
    {0x1a, 0x7f, 0x14, 0x13, 0x7e, 0x12, 0x10, 0x00},   // 1c 0463 8b6e Ã¦ÂÂµ
    {0x2a, 0x6a, 0x37, 0x6f, 0x37, 0x6a, 0x2a, 0x00},   // 1c 0464 8b6f Ã©Â»Â
    {0x48, 0x6a, 0x5f, 0x2a, 0x7f, 0x01, 0x1f, 0x00},   // 1c 0465 8b70 Ã¥ÂÂ´
    {0x26, 0x2a, 0x6a, 0x57, 0x6e, 0x22, 0x26, 0x00},   // 1c 0466 8b71 Ã¥Â®Â¢
    {0x7f, 0x15, 0x7f, 0x6a, 0x5f, 0x7f, 0x1f, 0x00},   // 1c 0467 8b72 Ã¨â€žÅ¡
    {0x40, 0x3c, 0x04, 0x74, 0x5f, 0x5a, 0x5a, 0x00},   // 1c 0468 8b73 Ã¨â„¢Â
    {0x49, 0x38, 0x5a, 0x73, 0x5e, 0x53, 0x5a, 0x00},   // 1c 0469 8b74 Ã©â‚¬â€ 
    {0x40, 0x7e, 0x4a, 0x4a, 0x79, 0x49, 0x40, 0x00},   // 1c 046a 8b75 Ã¤Â¸Ëœ
    {0x40, 0x48, 0x47, 0x22, 0x1a, 0x26, 0x40, 0x00},   // 1c 046b 8b76 Ã¤Â¹â€¦
    {0x04, 0x7e, 0x43, 0x3e, 0x03, 0x7e, 0x40, 0x00},   // 1c 046c 8b77 Ã¤Â»â€¡
    {0x04, 0x7e, 0x23, 0x1a, 0x7f, 0x1a, 0x22, 0x00},   // 1c 046d 8b78 Ã¤Â¼â€˜
    {0x41, 0x31, 0x4f, 0x51, 0x27, 0x5c, 0x40, 0x00},   // 1c 046e 8b79 Ã¥ÂÅ 
    {0x1e, 0x5e, 0x21, 0x5f, 0x51, 0x27, 0x5c, 0x00},   // 1c 046f 8b7a Ã¥ÂÂ¸
    {0x06, 0x62, 0x6e, 0x7b, 0x6e, 0x62, 0x06, 0x00},   // 1c 0470 8b7b Ã¥Â®Â®
    {0x10, 0x1d, 0x15, 0x15, 0x55, 0x57, 0x70, 0x00},   // 1c 0471 8b7c Ã¥Â¼â€œ
    {0x62, 0x36, 0x55, 0x55, 0x77, 0x1c, 0x60, 0x00},   // 1c 0472 8b7d Ã¦â‚¬Â¥
    {0x2a, 0x52, 0x7f, 0x2a, 0x5c, 0x23, 0x5e, 0x00},   // 1c 0473 8b7e Ã¦â€¢â€˜
    {0x1a, 0x7f, 0x0a, 0x01, 0x0f, 0x49, 0x79, 0x00},   // 1d 0474 8b80 Ã¦Å“Â½
    {0x22, 0x2a, 0x52, 0x7f, 0x12, 0x2b, 0x42, 0x00},   // 1d 0475 8b81 Ã¦Â±â€š
    {0x75, 0x40, 0x21, 0x5f, 0x51, 0x27, 0x5c, 0x00},   // 1d 0476 8b82 Ã¦Â±Â²
    {0x65, 0x10, 0x42, 0x7e, 0x63, 0x5e, 0x42, 0x00},   // 1d 0477 8b83 Ã¦Â³Â£
    {0x48, 0x5a, 0x29, 0x15, 0x25, 0x5b, 0x48, 0x00},   // 1d 0478 8b84 Ã§ÂÂ¸
    {0x2a, 0x3e, 0x2a, 0x52, 0x7f, 0x12, 0x2b, 0x00},   // 1d 0479 8b85 Ã§ÂÆ’
    {0x56, 0x5a, 0x36, 0x13, 0x7e, 0x4a, 0x66, 0x00},   // 1d 047a 8b86 Ã§Â©Â¶
    {0x56, 0x5a, 0x2e, 0x7f, 0x02, 0x5e, 0x76, 0x00},   // 1d 047b 8b87 Ã§ÂªÂ®
    {0x44, 0x4b, 0x2e, 0x5c, 0x2b, 0x5e, 0x42, 0x00},   // 1d 047c 8b88 Ã§Â¬Ë†
    {0x2a, 0x75, 0x28, 0x5f, 0x51, 0x27, 0x5c, 0x00},   // 1d 047d 8b89 Ã§Â´Å¡
    {0x2a, 0x75, 0x28, 0x3e, 0x20, 0x7f, 0x10, 0x00},   // 1d 047e 8b8a Ã§Â³Â¾
    {0x2a, 0x75, 0x04, 0x72, 0x55, 0x76, 0x04, 0x00},   // 1d 047f 8b8b Ã§ÂµÂ¦
    {0x7f, 0x00, 0x7f, 0x49, 0x49, 0x49, 0x7f, 0x00},   // 1d 0480 8b8c Ã¦â€”Â§
    {0x14, 0x13, 0x12, 0x7f, 0x12, 0x12, 0x10, 0x00},   // 1d 0481 8b8d Ã§â€°â€º
    {0x48, 0x4a, 0x6a, 0x5f, 0x4a, 0x2a, 0x48, 0x00},   // 1d 0482 8b8e Ã¥Å½Â»
    {0x40, 0x3f, 0x0b, 0x6b, 0x7f, 0x6b, 0x0b, 0x00},   // 1d 0483 8b8f Ã¥Â±â€¦
    {0x00, 0x7f, 0x55, 0x55, 0x55, 0x5d, 0x41, 0x00},   // 1d 0484 8b90 Ã¥Â·Â¨
    {0x52, 0x7f, 0x0a, 0x7f, 0x55, 0x55, 0x5d, 0x00},   // 1d 0485 8b91 Ã¦â€¹â€™
    {0x52, 0x7f, 0x4c, 0x33, 0x2e, 0x42, 0x5e, 0x00},   // 1d 0486 8b92 Ã¦â€¹Â 
    {0x2a, 0x37, 0x7a, 0x7b, 0x3a, 0x37, 0x2a, 0x00},   // 1d 0487 8b93 Ã¦Å’â„¢
    {0x55, 0x50, 0x3f, 0x7b, 0x3b, 0x5f, 0x59, 0x00},   // 1d 0488 8b94 Ã¦Â¸Â 
    {0x40, 0x3c, 0x44, 0x64, 0x4f, 0x6a, 0x4a, 0x00},   // 1d 0489 8b95 Ã¨â„¢Å¡
    {0x6a, 0x6b, 0x14, 0x13, 0x7e, 0x12, 0x10, 0x00},   // 1d 048a 8b96 Ã¨Â¨Â±
    {0x77, 0x7d, 0x2b, 0x7f, 0x55, 0x55, 0x5d, 0x00},   // 1d 048b 8b97 Ã¨Â·Â
    {0x56, 0x7d, 0x36, 0x3f, 0x6b, 0x5f, 0x6b, 0x00},   // 1d 048c 8b98 Ã©â€¹Â¸
    {0x65, 0x10, 0x42, 0x1e, 0x5d, 0x17, 0x5c, 0x00},   // 1d 048d 8b99 Ã¦Â¼Â
    {0x4a, 0x3d, 0x53, 0x7e, 0x1a, 0x3f, 0x47, 0x00},   // 1d 048e 8b9a Ã§Â¦Â¦
    {0x42, 0x1e, 0x55, 0x1d, 0x57, 0x1c, 0x40, 0x00},   // 1d 048f 8b9b Ã©Â­Å¡
    {0x02, 0x0e, 0x4a, 0x6b, 0x1a, 0x0e, 0x02, 0x00},   // 1d 0490 8b9c Ã¤ÂºÂ¨
    {0x22, 0x2e, 0x2a, 0x6b, 0x3a, 0x2e, 0x22, 0x00},   // 1d 0491 8b9d Ã¤ÂºÂ«
    {0x42, 0x2e, 0x4a, 0x7b, 0x0a, 0x2e, 0x42, 0x00},   // 1d 0492 8b9e Ã¤ÂºÂ¬
    {0x0c, 0x7f, 0x52, 0x1f, 0x12, 0x1f, 0x52, 0x00},   // 1d 0493 8b9f Ã¤Â¾â€º
    {0x04, 0x7e, 0x5b, 0x52, 0x3f, 0x52, 0x5a, 0x00},   // 1d 0494 8ba0 Ã¤Â¾Â 
    {0x0c, 0x7f, 0x7a, 0x17, 0x5b, 0x17, 0x7a, 0x00},   // 1d 0495 8ba1 Ã¥Æ’â€˜
    {0x40, 0x5f, 0x35, 0x12, 0x75, 0x5f, 0x60, 0x00},   // 1d 0496 8ba2 Ã¥â€¦â€¡
    {0x4a, 0x3e, 0x6b, 0x5e, 0x3e, 0x6b, 0x5e, 0x00},   // 1d 0497 8ba3 Ã§Â«Â¶
    {0x50, 0x52, 0x1f, 0x12, 0x1f, 0x52, 0x50, 0x00},   // 1d 0498 8ba4 Ã¥â€¦Â±
    {0x7f, 0x60, 0x54, 0x48, 0x56, 0x40, 0x7f, 0x00},   // 1d 0499 8ba5 Ã¥â€¡Â¶
    {0x04, 0x7f, 0x24, 0x62, 0x37, 0x62, 0x76, 0x00},   // 1d 049a 8ba6 Ã¥Ââ€
    {0x7f, 0x41, 0x63, 0x6b, 0x7f, 0x6b, 0x41, 0x00},   // 1d 049b 8ba7 Ã¥Å’Â¡
    {0x5e, 0x31, 0x7e, 0x4a, 0x2e, 0x7f, 0x1f, 0x00},   // 1d 049c 8ba8 Ã¥ÂÂ¿
    {0x1e, 0x1e, 0x20, 0x3e, 0x20, 0x7f, 0x10, 0x00},   // 1d 049d 8ba9 Ã¥ÂÂ«
    {0x7a, 0x1a, 0x77, 0x5b, 0x77, 0x1a, 0x7a, 0x00},   // 1d 049e 8baa Ã¥â€“Â¬
    {0x24, 0x3f, 0x4a, 0x3e, 0x3b, 0x7e, 0x4a, 0x00},   // 1d 049f 8bab Ã¥Â¢Æ’
    {0x38, 0x3f, 0x5a, 0x52, 0x3f, 0x52, 0x5a, 0x00},   // 1d 04a0 8bac Ã¥Â³Â¡
    {0x5d, 0x77, 0x44, 0x5e, 0x7d, 0x5c, 0x66, 0x00},   // 1d 04a1 8bad Ã¥Â¼Â·
    {0x5d, 0x77, 0x00, 0x49, 0x7f, 0x7f, 0x49, 0x00},   // 1d 04a2 8bae Ã¥Â½Å 
    {0x06, 0x7f, 0x48, 0x6a, 0x5f, 0x2a, 0x48, 0x00},   // 1d 04a3 8baf Ã¦â‚¬Â¯
    {0x69, 0x2f, 0x45, 0x48, 0x67, 0x0f, 0x68, 0x00},   // 1d 04a4 8bb0 Ã¦ÂÂ
    {0x48, 0x1a, 0x6f, 0x0a, 0x4f, 0x1a, 0x48, 0x00},   // 1d 04a5 8bb1 Ã¦ÂÂ­
    {0x52, 0x7f, 0x5a, 0x52, 0x3f, 0x52, 0x5a, 0x00},   // 1d 04a6 8bb2 Ã¦Å’Å¸
    {0x28, 0x1a, 0x6f, 0x3a, 0x5c, 0x23, 0x5e, 0x00},   // 1d 04a7 8bb3 Ã¦â€¢â„¢
    {0x1a, 0x7f, 0x7a, 0x17, 0x5b, 0x17, 0x7a, 0x00},   // 1d 04a8 8bb4 Ã¦Â©â€¹
    {0x75, 0x00, 0x4f, 0x39, 0x09, 0x79, 0x4f, 0x00},   // 1d 04a9 8bb5 Ã¦Â³Â
    {0x55, 0x3e, 0x41, 0x49, 0x7f, 0x49, 0x41, 0x00},   // 1d 04aa 8bb6 Ã§â€¹â€š
    {0x55, 0x3e, 0x5b, 0x52, 0x3f, 0x52, 0x5a, 0x00},   // 1d 04ab 8bb7 Ã§â€¹Â­
    {0x4b, 0x3e, 0x7a, 0x17, 0x5b, 0x17, 0x7a, 0x00},   // 1d 04ac 8bb8 Ã§Å¸Â¯
    {0x7f, 0x15, 0x7f, 0x34, 0x2b, 0x36, 0x7e, 0x00},   // 1d 04ad 8bb9 Ã¨Æ’Â¸
    {0x28, 0x1a, 0x6e, 0x3b, 0x2a, 0x7e, 0x18, 0x00},   // 1d 04ae 8bba Ã¨â€žâ€¦
    {0x5e, 0x55, 0x1e, 0x1a, 0x1e, 0x55, 0x5f, 0x00},   // 1d 04af 8bbb Ã¨Ë†Ë†
    {0x7a, 0x1a, 0x7f, 0x56, 0x7f, 0x1a, 0x7a, 0x00},   // 1d 04b0 8bbc Ã¨â€¢Å½
    {0x5a, 0x35, 0x7e, 0x4a, 0x2e, 0x7f, 0x1b, 0x00},   // 1d 04b1 8bbd Ã©Æ’Â·
    {0x56, 0x7d, 0x4a, 0x3e, 0x3b, 0x7e, 0x4a, 0x00},   // 1d 04b2 8bbe Ã©ÂÂ¡
    {0x2a, 0x25, 0x7f, 0x6b, 0x78, 0x2f, 0x27, 0x00},   // 1d 04b3 8bbf Ã©Å¸Â¿
    {0x2a, 0x25, 0x7f, 0x3b, 0x50, 0x2f, 0x27, 0x00},   // 1d 04b4 8bc0 Ã©Â¥â€”
    {0x4a, 0x07, 0x5e, 0x1f, 0x5a, 0x15, 0x7b, 0x00},   // 1d 04b5 8bc1 Ã©Â©Å¡
    {0x0c, 0x7f, 0x3e, 0x11, 0x7e, 0x02, 0x1e, 0x00},   // 1d 04b6 8bc2 Ã¤Â»Â°
    {0x71, 0x00, 0x57, 0x3a, 0x5a, 0x3d, 0x57, 0x00},   // 1d 04b7 8bc3 Ã¥â€¡Â
    {0x54, 0x56, 0x3e, 0x17, 0x7e, 0x56, 0x54, 0x00},   // 1d 04b8 8bc4 Ã¥Â°Â­
    {0x3e, 0x2a, 0x5e, 0x3e, 0x17, 0x7e, 0x54, 0x00},   // 1d 04b9 8bc5 Ã¦Å¡Â
    {0x53, 0x5a, 0x3f, 0x7a, 0x3f, 0x5a, 0x53, 0x00},   // 1d 04ba 8bc6 Ã¦Â¥Â­
    {0x40, 0x3f, 0x75, 0x55, 0x75, 0x07, 0x7c, 0x00},   // 1d 04bb 8bc7 Ã¥Â±â‚¬
    {0x7e, 0x4a, 0x7f, 0x4a, 0x7f, 0x4a, 0x7e, 0x00},   // 1d 04bc 8bc8 Ã¦â€ºÂ²
    {0x1a, 0x7f, 0x0a, 0x59, 0x47, 0x7d, 0x59, 0x00},   // 1d 04bd 8bc9 Ã¦Â¥Âµ
    {0x41, 0x49, 0x49, 0x7f, 0x49, 0x69, 0x41, 0x00},   // 1d 04be 8bca Ã§Å½â€°
    {0x1a, 0x7f, 0x0a, 0x7f, 0x35, 0x35, 0x7f, 0x00},   // 1d 04bf 8bcb Ã¦Â¡Â
    {0x35, 0x7e, 0x09, 0x0a, 0x7e, 0x09, 0x08, 0x00},   // 1d 04c0 8bcc Ã§Â²Â
    {0x0c, 0x7f, 0x5a, 0x5f, 0x7a, 0x5f, 0x5a, 0x00},   // 1d 04c1 8bcd Ã¥Æ’â€¦
    {0x5a, 0x5f, 0x7a, 0x5f, 0x62, 0x1f, 0x7e, 0x00},   // 1d 04c2 8bce Ã¥â€¹Â¤
    {0x24, 0x3f, 0x14, 0x23, 0x2a, 0x52, 0x7e, 0x00},   // 1d 04c3 8bcf Ã¥Ââ€¡
    {0x3e, 0x02, 0x02, 0x7f, 0x02, 0x22, 0x3e, 0x00},   // 1d 04c4 8bd0 Ã¥Â·Â¾
    {0x56, 0x7d, 0x36, 0x1e, 0x7b, 0x1e, 0x30, 0x00},   // 1d 04c5 8bd1 Ã©Å’Â¦
    {0x40, 0x3e, 0x0a, 0x0a, 0x79, 0x09, 0x08, 0x00},   // 1d 04c6 8bd2 Ã¦â€“Â¤
    {0x3e, 0x0a, 0x79, 0x44, 0x43, 0x3e, 0x46, 0x00},   // 1d 04c7 8bd3 Ã¦Â¬Â£
    {0x56, 0x7d, 0x36, 0x44, 0x43, 0x3e, 0x46, 0x00},   // 1d 04c8 8bd4 Ã¦Â¬Â½
    {0x15, 0x17, 0x2d, 0x28, 0x6d, 0x17, 0x15, 0x00},   // 1d 04c9 8bd5 Ã§ÂÂ´
    {0x5a, 0x36, 0x5f, 0x7a, 0x16, 0x3f, 0x5a, 0x00},   // 1d 04ca 8bd6 Ã§Â¦Â
    {0x72, 0x1e, 0x7a, 0x55, 0x3a, 0x5e, 0x72, 0x00},   // 1d 04cb 8bd7 Ã§Â¦Â½
    {0x44, 0x3b, 0x7e, 0x54, 0x3b, 0x56, 0x72, 0x00},   // 1d 04cc 8bd8 Ã§Â­â€¹
    {0x57, 0x17, 0x1d, 0x70, 0x1b, 0x15, 0x5b, 0x00},   // 1d 04cd 8bd9 Ã§Â·Å 
    {0x42, 0x3a, 0x1f, 0x1a, 0x77, 0x16, 0x12, 0x00},   // 1d 04ce 8bda Ã¨Å Â¹
    {0x7e, 0x6a, 0x5b, 0x7e, 0x5f, 0x6a, 0x7e, 0x00},   // 1d 04cf 8bdb Ã¨ÂÅ’
    {0x12, 0x7b, 0x36, 0x12, 0x55, 0x36, 0x14, 0x00},   // 1d 04d0 8bdc Ã¨Â¡Â¿
    {0x12, 0x7b, 0x56, 0x1f, 0x78, 0x1a, 0x57, 0x00},   // 1d 04d1 8bdd Ã¨Â¥Å¸
    {0x6b, 0x62, 0x5a, 0x5f, 0x7a, 0x5f, 0x5a, 0x00},   // 1d 04d2 8bde Ã¨Â¬Â¹
    {0x49, 0x3a, 0x60, 0x5e, 0x4a, 0x79, 0x48, 0x00},   // 1d 04d3 8bdf Ã¨Â¿â€˜
    {0x54, 0x74, 0x56, 0x7d, 0x56, 0x74, 0x54, 0x00},   // 1d 04d4 8be0 Ã©â€¡â€˜
    {0x1e, 0x12, 0x1e, 0x52, 0x55, 0x36, 0x14, 0x00},   // 1d 04d5 8be1 Ã¥ÂÅ¸
    {0x56, 0x7d, 0x36, 0x7f, 0x55, 0x35, 0x5f, 0x00},   // 1d 04d6 8be2 Ã©Å â‚¬
    {0x42, 0x32, 0x0f, 0x02, 0x7e, 0x40, 0x60, 0x00},   // 1d 04d7 8be3 Ã¤Â¹Â
    {0x04, 0x7e, 0x51, 0x1f, 0x15, 0x1f, 0x50, 0x00},   // 1d 04d8 8be4 Ã¥â‚¬Â¶
    {0x08, 0x07, 0x3a, 0x2a, 0x3a, 0x42, 0x7e, 0x00},   // 1d 04d9 8be5 Ã¥ÂÂ¥
    {0x7f, 0x41, 0x65, 0x55, 0x49, 0x57, 0x41, 0x00},   // 1d 04da 8be6 Ã¥Å’Âº
    {0x55, 0x4a, 0x3d, 0x04, 0x1b, 0x5a, 0x7e, 0x00},   // 1d 04db 8be7 Ã§â€¹â€”
    {0x2a, 0x3e, 0x48, 0x27, 0x12, 0x2e, 0x40, 0x00},   // 1d 04dc 8be8 Ã§Å½â€“
    {0x44, 0x2b, 0x1e, 0x2a, 0x7f, 0x55, 0x5d, 0x00},   // 1d 04dd 8be9 Ã§Å¸Â©
    {0x0a, 0x6a, 0x6f, 0x7a, 0x6f, 0x6a, 0x0a, 0x00},   // 1d 04de 8bea Ã¨â€¹Â¦
    {0x50, 0x5e, 0x2b, 0x7e, 0x7f, 0x49, 0x55, 0x00},   // 1d 04df 8beb Ã¨ÂºÂ¯
    {0x5f, 0x1f, 0x75, 0x00, 0x7f, 0x49, 0x55, 0x00},   // 1d 04e0 8bec Ã©Â§â€ 
    {0x5f, 0x1f, 0x75, 0x7e, 0x4a, 0x79, 0x48, 0x00},   // 1d 04e1 8bed Ã©Â§Ë†
    {0x5f, 0x1f, 0x75, 0x04, 0x1b, 0x5a, 0x7e, 0x00},   // 1d 04e2 8bee Ã©Â§â€™
    {0x50, 0x5f, 0x15, 0x15, 0x15, 0x5f, 0x50, 0x00},   // 1d 04e3 8bef Ã¥â€¦Â·
    {0x60, 0x3c, 0x57, 0x5f, 0x6f, 0x1c, 0x60, 0x00},   // 1d 04e4 8bf0 Ã¦â€žÅ¡
    {0x40, 0x3c, 0x34, 0x64, 0x3f, 0x7a, 0x2a, 0x00},   // 1d 04e5 8bf1 Ã¨â„¢Å¾
    {0x1e, 0x1e, 0x04, 0x7a, 0x5d, 0x22, 0x54, 0x00},   // 1d 04e6 8bf2 Ã¥â€“Â°
    {0x46, 0x4a, 0x56, 0x73, 0x5e, 0x4a, 0x46, 0x00},   // 1d 04e7 8bf3 Ã§Â©Âº
    {0x04, 0x7e, 0x79, 0x4b, 0x7f, 0x2b, 0x78, 0x00},   // 1d 04e8 8bf4 Ã¥ÂÂ¶
    {0x76, 0x12, 0x5e, 0x7f, 0x3e, 0x52, 0x76, 0x00},   // 1d 04e9 8bf5 Ã¥Â¯â€œ
    {0x49, 0x3a, 0x78, 0x6b, 0x7f, 0x5b, 0x78, 0x00},   // 1d 04ea 8bf6 Ã©Ââ€¡
    {0x7f, 0x1b, 0x78, 0x4b, 0x7f, 0x2b, 0x78, 0x00},   // 1d 04eb 8bf7 Ã©Å¡â€¦
    {0x30, 0x36, 0x36, 0x7f, 0x36, 0x36, 0x30, 0x00},   // 1d 04ec 8bf8 Ã¤Â¸Â²
    {0x1a, 0x7f, 0x7b, 0x5e, 0x00, 0x7b, 0x1e, 0x00},   // 1d 04ed 8bf9 Ã¦Â«â€º
    {0x56, 0x7d, 0x56, 0x3f, 0x1e, 0x00, 0x7f, 0x00},   // 1d 04ee 8bfa Ã©â€¡Â§
    {0x40, 0x3f, 0x07, 0x7b, 0x2f, 0x2b, 0x7f, 0x00},   // 1d 04ef 8bfb Ã¥Â±â€˜
    {0x40, 0x3f, 0x65, 0x4d, 0x7d, 0x4d, 0x67, 0x00},   // 1d 04f0 8bfc Ã¥Â±Ë†
    {0x52, 0x7f, 0x3f, 0x65, 0x4d, 0x7d, 0x6f, 0x00},   // 1e 04f1 8c40 Ã¦Å½Ëœ
    {0x46, 0x3a, 0x7e, 0x5f, 0x7a, 0x5e, 0x66, 0x00},   // 1e 04f2 8c41 Ã§ÂªÅ¸
    {0x0a, 0x7a, 0x56, 0x5f, 0x54, 0x7a, 0x08, 0x00},   // 1e 04f3 8c42 Ã¦Â²â€œ
    {0x37, 0x7e, 0x37, 0x7e, 0x01, 0x7f, 0x44, 0x00},   // 1e 04f4 8c43 Ã©ÂÂ´
    {0x0a, 0x7d, 0x6a, 0x7f, 0x6e, 0x6a, 0x1d, 0x00},   // 1e 04f5 8c44 Ã¨Â½Â¡
    {0x56, 0x0a, 0x56, 0x53, 0x7e, 0x5a, 0x56, 0x00},   // 1e 04f6 8c45 Ã§ÂªÂª
    {0x42, 0x1f, 0x4a, 0x1f, 0x40, 0x1b, 0x52, 0x00},   // 1e 04f7 8c46 Ã§â€ Å 
    {0x7f, 0x25, 0x1b, 0x77, 0x55, 0x37, 0x57, 0x00},   // 1e 04f8 8c47 Ã©Å¡Ë†
    {0x48, 0x5a, 0x35, 0x7d, 0x35, 0x5b, 0x48, 0x00},   // 1e 04f9 8c48 Ã§Â²â€š
    {0x51, 0x57, 0x35, 0x7f, 0x35, 0x57, 0x51, 0x00},   // 1e 04fa 8c49 Ã¦Â â€”
    {0x2a, 0x75, 0x5c, 0x37, 0x7d, 0x37, 0x5c, 0x00},   // 1e 04fb 8c4a Ã§Â¹Â°
    {0x54, 0x55, 0x2d, 0x75, 0x33, 0x4d, 0x54, 0x00},   // 1e 04fc 8c4b Ã¦Â¡â€˜
    {0x56, 0x7d, 0x36, 0x7f, 0x4c, 0x3f, 0x44, 0x00},   // 1e 04fd 8c4c Ã©ÂÂ¬
    {0x52, 0x1f, 0x5f, 0x12, 0x5a, 0x07, 0x5e, 0x00},   // 1e 04fe 8c4d Ã¥â€¹Â²
    {0x44, 0x55, 0x35, 0x7f, 0x55, 0x5f, 0x74, 0x00},   // 1e 04ff 8c4e Ã¥Ââ€º
    {0x6a, 0x3a, 0x6f, 0x3e, 0x6f, 0x3a, 0x6a, 0x00},   // 1e 0500 8c4f Ã¨â€“Â«
    {0x6a, 0x6b, 0x40, 0x3f, 0x1e, 0x00, 0x7f, 0x00},   // 1e 0501 8c50 Ã¨Â¨â€œ
    {0x55, 0x3f, 0x75, 0x6f, 0x2b, 0x7e, 0x2b, 0x00},   // 1e 0502 8c51 Ã§Â¾Â¤
    {0x27, 0x3d, 0x2d, 0x7f, 0x2d, 0x3d, 0x27, 0x00},   // 1e 0503 8c52 Ã¨Â»Â
    {0x55, 0x3f, 0x75, 0x6f, 0x04, 0x7f, 0x1b, 0x00},   // 1e 0504 8c53 Ã©Æ’Â¡
    {0x48, 0x5a, 0x3f, 0x2a, 0x7f, 0x08, 0x10, 0x00},   // 1e 0505 8c54 Ã¥ÂÂ¦
    {0x5a, 0x37, 0x7a, 0x5e, 0x3e, 0x5a, 0x5e, 0x00},   // 1e 0506 8c55 Ã¨Â¢Ë†
    {0x12, 0x7b, 0x16, 0x00, 0x7f, 0x25, 0x1b, 0x00},   // 1e 0507 8c56 Ã§Â¥Â
    {0x04, 0x7e, 0x51, 0x15, 0x7b, 0x11, 0x59, 0x00},   // 1e 0508 8c57 Ã¤Â¿â€š
    {0x04, 0x7e, 0x3f, 0x24, 0x5d, 0x17, 0x5d, 0x00},   // 1e 0509 8c58 Ã¥â€šÂ¾
    {0x49, 0x3f, 0x09, 0x7f, 0x09, 0x4e, 0x7f, 0x00},   // 1e 050a 8c59 Ã¥Ë†â€˜
    {0x40, 0x4f, 0x39, 0x09, 0x79, 0x4f, 0x60, 0x00},   // 1e 050b 8c5a Ã¥â€¦â€ž
    {0x09, 0x77, 0x55, 0x57, 0x5a, 0x75, 0x0b, 0x00},   // 1e 050c 8c5b Ã¥â€¢â€œ
    {0x48, 0x5a, 0x5a, 0x7f, 0x5a, 0x5a, 0x48, 0x00},   // 1e 050d 8c5c Ã¥Å“Â­
    {0x2a, 0x3e, 0x48, 0x5a, 0x7f, 0x5a, 0x48, 0x00},   // 1e 050e 8c5d Ã§ÂÂª
    {0x55, 0x4f, 0x55, 0x7f, 0x55, 0x46, 0x5f, 0x00},   // 1e 050f 8c5e Ã¥Å¾â€¹
    {0x4a, 0x5f, 0x5a, 0x39, 0x57, 0x59, 0x4f, 0x00},   // 1e 0510 8c5f Ã¥Â¥â€˜
    {0x49, 0x3f, 0x09, 0x7f, 0x09, 0x4a, 0x25, 0x00},   // 1e 0511 8c60 Ã¥Â½Â¢
    {0x0a, 0x7d, 0x49, 0x5b, 0x75, 0x5b, 0x48, 0x00},   // 1e 0512 8c61 Ã¥Â¾â€ž
    {0x62, 0x3e, 0x56, 0x5f, 0x76, 0x1e, 0x62, 0x00},   // 1e 0513 8c62 Ã¦ÂÂµ
    {0x40, 0x3e, 0x5a, 0x7e, 0x2b, 0x5e, 0x5a, 0x00},   // 1e 0514 8c63 Ã¦â€¦Â¶
    {0x6a, 0x2f, 0x5a, 0x58, 0x7a, 0x1f, 0x6a, 0x00},   // 1e 0515 8c64 Ã¦â€¦Â§
    {0x64, 0x2e, 0x4e, 0x45, 0x6e, 0x0b, 0x6e, 0x00},   // 1e 0516 8c65 Ã¦â€ Â©
    {0x52, 0x7f, 0x10, 0x3f, 0x2d, 0x4f, 0x78, 0x00},   // 1e 0517 8c66 Ã¦Å½Â²
    {0x52, 0x7f, 0x54, 0x3f, 0x1a, 0x3f, 0x6a, 0x00},   // 1e 0518 8c67 Ã¦ÂÂº
    {0x12, 0x2f, 0x4a, 0x7f, 0x5c, 0x23, 0x5e, 0x00},   // 1e 0519 8c68 Ã¦â€¢Â¬
    {0x44, 0x3f, 0x55, 0x75, 0x15, 0x3f, 0x44, 0x00},   // 1e 051a 8c69 Ã¦â„¢Â¯
    {0x1a, 0x7f, 0x48, 0x5a, 0x7f, 0x5a, 0x48, 0x00},   // 1e 051b 8c6a Ã¦Â¡â€š
    {0x75, 0x00, 0x56, 0x5a, 0x3e, 0x59, 0x55, 0x00},   // 1e 051c 8c6b Ã¦Â¸â€œ
    {0x3e, 0x3e, 0x3e, 0x48, 0x5a, 0x7f, 0x5a, 0x00},   // 1e 051d 8c6c Ã§â€¢Â¦
    {0x35, 0x7f, 0x0a, 0x76, 0x6f, 0x6a, 0x0b, 0x00},   // 1e 051e 8c6d Ã§Â¨Â½
    {0x50, 0x15, 0x15, 0x7b, 0x11, 0x09, 0x50, 0x00},   // 1e 051f 8c6e Ã§Â³Â»
    {0x2a, 0x75, 0x49, 0x5b, 0x75, 0x5b, 0x48, 0x00},   // 1e 0520 8c6f Ã§ÂµÅ’
    {0x2a, 0x75, 0x28, 0x7f, 0x55, 0x4e, 0x55, 0x00},   // 1e 0521 8c70 Ã§Â¶â„¢
    {0x45, 0x17, 0x1f, 0x75, 0x1b, 0x15, 0x4b, 0x00},   // 1e 0522 8c71 Ã§Â¹â€¹
    {0x57, 0x7d, 0x57, 0x05, 0x7f, 0x15, 0x27, 0x00},   // 1e 0523 8c72 Ã§Â½Â«
    {0x12, 0x52, 0x57, 0x6a, 0x57, 0x52, 0x12, 0x00},   // 1e 0524 8c73 Ã¨Å’Å½
    {0x56, 0x3e, 0x17, 0x7e, 0x17, 0x42, 0x7a, 0x00},   // 1e 0525 8c74 Ã¨ÂÅ 
    {0x46, 0x5b, 0x5a, 0x7f, 0x5a, 0x3b, 0x46, 0x00},   // 1e 0526 8c75 Ã¨â€ºÂ
    {0x6a, 0x6b, 0x04, 0x04, 0x7f, 0x04, 0x04, 0x00},   // 1e 0527 8c76 Ã¨Â¨Ë†
    {0x6a, 0x6b, 0x00, 0x6f, 0x6a, 0x6a, 0x6d, 0x00},   // 1e 0528 8c77 Ã¨Â©Â£
    {0x2a, 0x27, 0x76, 0x7f, 0x6a, 0x25, 0x2b, 0x00},   // 1e 0529 8c78 Ã¨Â­Â¦
    {0x2d, 0x7f, 0x49, 0x5b, 0x75, 0x5b, 0x48, 0x00},   // 1e 052a 8c79 Ã¨Â»Â½
    {0x49, 0x5b, 0x35, 0x2b, 0x5d, 0x17, 0x5d, 0x00},   // 1e 052b 8c7a Ã©Â Å¡
    {0x55, 0x39, 0x55, 0x1e, 0x56, 0x17, 0x76, 0x00},   // 1e 052c 8c7b Ã©Â¶Â
    {0x52, 0x5a, 0x7f, 0x5a, 0x5f, 0x3a, 0x52, 0x00},   // 1e 052d 8c7c Ã¨Å Â¸
    {0x49, 0x38, 0x5e, 0x51, 0x7e, 0x42, 0x5e, 0x00},   // 1e 052e 8c7d Ã¨Â¿Å½
    {0x42, 0x1d, 0x5f, 0x22, 0x4e, 0x7b, 0x2e, 0x00},   // 1e 052f 8c7e Ã©Â¯Â¨
    {0x7c, 0x2c, 0x57, 0x7a, 0x2e, 0x40, 0x7f, 0x00},   // 1f 0530 8c80 Ã¥Å â€¡
    {0x2d, 0x77, 0x2d, 0x44, 0x5f, 0x24, 0x55, 0x00},   // 1f 0531 8c81 Ã¦Ë†Å¸
    {0x25, 0x37, 0x7f, 0x75, 0x3b, 0x35, 0x2b, 0x00},   // 1f 0532 8c82 Ã¦â€™Æ’
    {0x75, 0x26, 0x5f, 0x36, 0x5c, 0x23, 0x5e, 0x00},   // 1f 0533 8c83 Ã¦Â¿â‚¬
    {0x7f, 0x25, 0x1b, 0x22, 0x4c, 0x7f, 0x22, 0x00},   // 1f 0534 8c84 Ã©Å¡â„¢
    {0x1a, 0x7f, 0x0a, 0x7d, 0x00, 0x45, 0x7d, 0x00},   // 1f 0535 8c85 Ã¦Â¡Â
    {0x0c, 0x7f, 0x5a, 0x35, 0x7b, 0x36, 0x5f, 0x00},   // 1f 0536 8c86 Ã¥â€šâ€˜
    {0x48, 0x47, 0x22, 0x1e, 0x22, 0x42, 0x46, 0x00},   // 1f 0537 8c87 Ã¦Â¬Â 
    {0x75, 0x00, 0x48, 0x4a, 0x3f, 0x4e, 0x48, 0x00},   // 1f 0538 8c88 Ã¦Â±Âº
    {0x75, 0x00, 0x5a, 0x1f, 0x7a, 0x17, 0x5f, 0x00},   // 1f 0539 8c89 Ã¦Â½â€
    {0x46, 0x22, 0x1a, 0x03, 0x1a, 0x22, 0x46, 0x00},   // 1f 053a 8c8a Ã§Â©Â´
    {0x2a, 0x75, 0x02, 0x6a, 0x6f, 0x6a, 0x02, 0x00},   // 1f 053b 8c8b Ã§ÂµÂ
    {0x40, 0x7e, 0x43, 0x7e, 0x42, 0x7e, 0x40, 0x00},   // 1f 053c 8c8c Ã¨Â¡â‚¬
    {0x6a, 0x63, 0x48, 0x4a, 0x3f, 0x4e, 0x48, 0x00},   // 1f 053d 8c8d Ã¨Â¨Â£
    {0x40, 0x20, 0x1f, 0x15, 0x15, 0x55, 0x7f, 0x00},   // 1f 053e 8c8e Ã¦Å“Ë†
    {0x04, 0x7e, 0x15, 0x13, 0x7f, 0x12, 0x10, 0x00},   // 1f 053f 8c8f Ã¤Â»Â¶
    {0x04, 0x7e, 0x5d, 0x56, 0x3d, 0x56, 0x5c, 0x00},   // 1f 0540 8c90 Ã¥â‚¬Â¹
    {0x04, 0x7e, 0x15, 0x6e, 0x57, 0x4e, 0x15, 0x00},   // 1f 0541 8c91 Ã¥â‚¬Â¦
    {0x04, 0x7e, 0x55, 0x3b, 0x56, 0x7f, 0x56, 0x00},   // 1f 0542 8c92 Ã¥ÂÂ¥
    {0x42, 0x36, 0x7f, 0x16, 0x7e, 0x2f, 0x42, 0x00},   // 1f 0543 8c93 Ã¥â€¦Â¼
    {0x14, 0x4d, 0x56, 0x37, 0x56, 0x7d, 0x14, 0x00},   // 1f 0544 8c94 Ã¥Ë†Â¸
    {0x5c, 0x56, 0x3d, 0x56, 0x5c, 0x0e, 0x7f, 0x00},   // 1f 0545 8c95 Ã¥â€°Â£
    {0x1e, 0x1e, 0x46, 0x6a, 0x6b, 0x6a, 0x46, 0x00},   // 1f 0546 8c96 Ã¥â€“Â§
    {0x7f, 0x55, 0x4f, 0x7d, 0x6f, 0x55, 0x7f, 0x00},   // 1f 0547 8c97 Ã¥Å“Â
    {0x47, 0x57, 0x55, 0x78, 0x5b, 0x55, 0x4b, 0x00},   // 1f 0548 8c98 Ã¥Â â€¦
    {0x5f, 0x3c, 0x4a, 0x2b, 0x7e, 0x3f, 0x5a, 0x00},   // 1f 0549 8c99 Ã¥Â«Å’
    {0x55, 0x3b, 0x40, 0x55, 0x7f, 0x57, 0x52, 0x00},   // 1f 054a 8c9a Ã¥Â»Âº
    {0x66, 0x2a, 0x5a, 0x5f, 0x7a, 0x0a, 0x66, 0x00},   // 1f 054b 8c9b Ã¦â€ Â²
    {0x6e, 0x3b, 0x4b, 0x50, 0x6d, 0x1b, 0x69, 0x00},   // 1f 054c 8c9c Ã¦â€¡Â¸
    {0x14, 0x2d, 0x76, 0x77, 0x36, 0x2d, 0x14, 0x00},   // 1f 054d 8c9d Ã¦â€¹Â³
    {0x52, 0x7f, 0x15, 0x6e, 0x57, 0x4e, 0x15, 0x00},   // 1f 054e 8c9e Ã¦ÂÂ²
    {0x1a, 0x7f, 0x5c, 0x56, 0x3d, 0x56, 0x5c, 0x00},   // 1f 054f 8c9f Ã¦Â¤Å“
    {0x1a, 0x7f, 0x0a, 0x14, 0x7b, 0x7e, 0x4a, 0x00},   // 1f 0550 8ca0 Ã¦Â¨Â©
    {0x1a, 0x2e, 0x3e, 0x7b, 0x3a, 0x2e, 0x1a, 0x00},   // 1f 0551 8ca1 Ã§â€°Â½
    {0x44, 0x44, 0x24, 0x1f, 0x24, 0x45, 0x44, 0x00},   // 1f 0552 8ca2 Ã§Å Â¬
    {0x7a, 0x3a, 0x6f, 0x7a, 0x44, 0x3f, 0x45, 0x00},   // 1f 0553 8ca3 Ã§Å’Â®
    {0x09, 0x37, 0x31, 0x49, 0x3f, 0x09, 0x7f, 0x00},   // 1f 0554 8ca4 Ã§Â â€
    {0x09, 0x37, 0x31, 0x5f, 0x35, 0x75, 0x5f, 0x00},   // 1f 0555 8ca5 Ã§Â¡Â¯
    {0x2a, 0x75, 0x28, 0x78, 0x2b, 0x2b, 0x78, 0x00},   // 1f 0556 8ca6 Ã§ÂµÂ¹
    {0x5e, 0x10, 0x1f, 0x75, 0x15, 0x1f, 0x50, 0x00},   // 1f 0557 8ca7 Ã§Å“Å’
    {0x41, 0x3f, 0x05, 0x7d, 0x2d, 0x2f, 0x79, 0x00},   // 1f 0558 8ca8 Ã¨â€šÂ©
    {0x40, 0x5f, 0x35, 0x15, 0x75, 0x5f, 0x60, 0x00},   // 1f 0559 8ca9 Ã¨Â¦â€¹
    {0x6b, 0x62, 0x4a, 0x2b, 0x7e, 0x3f, 0x5a, 0x00},   // 1f 055a 8caa Ã¨Â¬â„¢
    {0x47, 0x77, 0x35, 0x30, 0x3b, 0x75, 0x4b, 0x00},   // 1f 055b 8cab Ã¨Â³Â¢
    {0x2d, 0x7f, 0x2d, 0x08, 0x09, 0x7f, 0x09, 0x00},   // 1f 055c 8cac Ã¨Â»â€™
    {0x49, 0x38, 0x4e, 0x7a, 0x7f, 0x7a, 0x6e, 0x00},   // 1f 055d 8cad Ã©ÂÂ£
    {0x56, 0x7d, 0x36, 0x49, 0x37, 0x4a, 0x5f, 0x00},   // 1f 055e 8cae Ã©ÂÂµ
    {0x7f, 0x1b, 0x5c, 0x56, 0x3d, 0x56, 0x5c, 0x00},   // 1f 055f 8caf Ã©â„¢Âº
    {0x4b, 0x7d, 0x3d, 0x2b, 0x5d, 0x17, 0x5d, 0x00},   // 1f 0560 8cb0 Ã©Â¡â€¢
    {0x5f, 0x1f, 0x7d, 0x56, 0x3d, 0x56, 0x5c, 0x00},   // 1f 0561 8cb1 Ã©Â¨â€œ
    {0x7c, 0x47, 0x7a, 0x56, 0x3d, 0x56, 0x5c, 0x00},   // 1f 0562 8cb2 Ã©Â¹Â¸
    {0x44, 0x25, 0x1d, 0x05, 0x7d, 0x45, 0x64, 0x00},   // 1f 0563 8cb3 Ã¥â€¦Æ’
    {0x40, 0x3f, 0x21, 0x4d, 0x7f, 0x0d, 0x21, 0x00},   // 1f 0564 8cb4 Ã¥Å½Å¸
    {0x40, 0x3f, 0x2e, 0x7b, 0x52, 0x2b, 0x5a, 0x00},   // 1f 0565 8cb5 Ã¥Å½Â³
    {0x44, 0x6c, 0x53, 0x68, 0x02, 0x42, 0x3e, 0x00},   // 1f 0566 8cb6 Ã¥Â¹Â»
    {0x5d, 0x77, 0x4a, 0x6e, 0x53, 0x2a, 0x42, 0x00},   // 1f 0567 8cb7 Ã¥Â¼Â¦
    {0x75, 0x40, 0x3e, 0x6a, 0x6a, 0x3f, 0x52, 0x00},   // 1f 0568 8cb8 Ã¦Â¸â€º
    {0x75, 0x40, 0x3f, 0x21, 0x4d, 0x7f, 0x2d, 0x00},   // 1f 0569 8cb9 Ã¦ÂºÂ
    {0x42, 0x4a, 0x6e, 0x53, 0x4a, 0x22, 0x42, 0x00},   // 1f 056a 8cba Ã§Å½â€ž
    {0x2a, 0x3e, 0x2a, 0x5f, 0x35, 0x75, 0x5f, 0x00},   // 1f 056b 8cbb Ã§ÂÂ¾
    {0x2a, 0x75, 0x4a, 0x6e, 0x53, 0x2a, 0x42, 0x00},   // 1f 056c 8cbc Ã§ÂµÆ’
    {0x7e, 0x13, 0x7e, 0x4a, 0x6e, 0x53, 0x6a, 0x00},   // 1f 056d 8cbd Ã¨Ë†Â·
    {0x02, 0x62, 0x6b, 0x6b, 0x6b, 0x62, 0x02, 0x00},   // 1f 056e 8cbe Ã¨Â¨â‚¬
    {0x6b, 0x62, 0x7a, 0x0e, 0x5b, 0x4e, 0x2a, 0x00},   // 1f 056f 8cbf Ã¨Â«Âº
    {0x7f, 0x25, 0x1b, 0x7f, 0x55, 0x35, 0x5f, 0x00},   // 1f 0570 8cc0 Ã©â„¢Â
    {0x12, 0x16, 0x52, 0x7e, 0x11, 0x15, 0x11, 0x00},   // 1f 0571 8cc1 Ã¤Â¹Å½
    {0x04, 0x7e, 0x7f, 0x75, 0x6f, 0x75, 0x7f, 0x00},   // 1f 0572 8cc2 Ã¥â‚¬â€¹
    {0x04, 0x74, 0x54, 0x5f, 0x54, 0x74, 0x04, 0x00},   // 1f 0573 8cc3 Ã¥ÂÂ¤
    {0x1e, 0x1e, 0x16, 0x52, 0x7e, 0x11, 0x15, 0x00},   // 1f 0574 8cc4 Ã¥â€˜Â¼
    {0x7f, 0x41, 0x75, 0x6f, 0x75, 0x41, 0x7f, 0x00},   // 1f 0575 8cc5 Ã¥â€ºÂº
    {0x44, 0x5c, 0x37, 0x2c, 0x74, 0x5f, 0x74, 0x00},   // 1f 0576 8cc6 Ã¥Â§â€˜
    {0x51, 0x7d, 0x4b, 0x3e, 0x42, 0x3e, 0x61, 0x00},   // 1f 0577 8cc7 Ã¥Â­Â¤
    {0x39, 0x49, 0x49, 0x49, 0x49, 0x4f, 0x60, 0x00},   // 1f 0578 8cc8 Ã¥Â·Â±
    {0x40, 0x3e, 0x2a, 0x3a, 0x7f, 0x3a, 0x2a, 0x00},   // 1f 0579 8cc9 Ã¥ÂºÂ«
    {0x5d, 0x77, 0x40, 0x3e, 0x42, 0x3e, 0x61, 0x00},   // 1f 057a 8cca Ã¥Â¼Â§
    {0x41, 0x3d, 0x15, 0x15, 0x15, 0x1d, 0x01, 0x00},   // 1f 057b 8ccb Ã¦Ë†Â¸
    {0x3a, 0x2f, 0x3a, 0x44, 0x5f, 0x22, 0x5e, 0x00},   // 1f 057c 8ccc Ã¦â€¢â€¦
    {0x1a, 0x7f, 0x04, 0x74, 0x5f, 0x74, 0x04, 0x00},   // 1f 057d 8ccd Ã¦Å¾Â¯
    {0x75, 0x3a, 0x2f, 0x3a, 0x7f, 0x15, 0x7f, 0x00},   // 1f 057e 8cce Ã¦Â¹â€“
    {0x55, 0x3e, 0x41, 0x3e, 0x42, 0x3e, 0x61, 0x00},   // 1f 057f 8ccf Ã§â€¹Â
    {0x35, 0x7e, 0x3a, 0x2f, 0x7a, 0x3f, 0x7f, 0x00},   // 1f 0580 8cd0 Ã§Â³Å 
    {0x12, 0x7b, 0x36, 0x0a, 0x36, 0x37, 0x6a, 0x00},   // 1f 0581 8cd1 Ã¨Â¢Â´
    {0x7f, 0x15, 0x7f, 0x40, 0x5b, 0x29, 0x5b, 0x00},   // 1f 0582 8cd2 Ã¨â€šÂ¡
    {0x3a, 0x2f, 0x3a, 0x40, 0x3f, 0x55, 0x7f, 0x00},   // 1f 0583 8cd3 Ã¨Æ’Â¡
    {0x56, 0x6e, 0x43, 0x3e, 0x47, 0x3e, 0x66, 0x00},   // 1f 0584 8cd4 Ã¨ÂÂ°
    {0x40, 0x3c, 0x44, 0x24, 0x0f, 0x6a, 0x4a, 0x00},   // 1f 0585 8cd5 Ã¨â„¢Å½
    {0x6b, 0x62, 0x0a, 0x36, 0x3b, 0x36, 0x6a, 0x00},   // 1f 0586 8cd6 Ã¨Âªâ€¡
    {0x77, 0x7d, 0x57, 0x0a, 0x36, 0x37, 0x6a, 0x00},   // 1f 0587 8cd7 Ã¨Â·Â¨
    {0x56, 0x7d, 0x06, 0x74, 0x5f, 0x74, 0x04, 0x00},   // 1f 0588 8cd8 Ã©Ë†Â·
    {0x41, 0x3f, 0x25, 0x7d, 0x55, 0x7f, 0x51, 0x00},   // 1f 0589 8cd9 Ã©â€ºâ€¡
    {0x11, 0x7f, 0x7d, 0x57, 0x41, 0x1f, 0x5d, 0x00},   // 1f 058a 8cda Ã©Â¡Â§
    {0x5a, 0x77, 0x2a, 0x40, 0x5a, 0x2f, 0x5a, 0x00},   // 1f 058b 8cdb Ã©Â¼â€œ
    {0x40, 0x49, 0x79, 0x4f, 0x49, 0x79, 0x40, 0x00},   // 1f 058c 8cdc Ã¤Âºâ€
    {0x41, 0x51, 0x5f, 0x55, 0x75, 0x4d, 0x41, 0x00},   // 1f 058d 8cdd Ã¤Âºâ€™
    {0x04, 0x7e, 0x49, 0x79, 0x4f, 0x79, 0x40, 0x00},   // 1f 058e 8cde Ã¤Â¼Â
    {0x14, 0x13, 0x12, 0x7e, 0x12, 0x12, 0x10, 0x00},   // 1f 058f 8cdf Ã¥ÂË†
    {0x50, 0x56, 0x14, 0x17, 0x15, 0x5f, 0x50, 0x00},   // 1f 0590 8ce0 Ã¥â€˜â€°
    {0x10, 0x75, 0x5d, 0x57, 0x5d, 0x71, 0x10, 0x00},   // 1f 0591 8ce1 Ã¥ÂÂ¾
    {0x5c, 0x37, 0x2c, 0x56, 0x14, 0x1f, 0x53, 0x00},   // 1f 0592 8ce2 Ã¥Â¨Â¯
    {0x0a, 0x7d, 0x48, 0x5a, 0x2d, 0x58, 0x4c, 0x00},   // 1f 0593 8ce3 Ã¥Â¾Å’
    {0x0a, 0x7d, 0x33, 0x3e, 0x2a, 0x7f, 0x1f, 0x00},   // 1f 0594 8ce4 Ã¥Â¾Â¡
    {0x06, 0x7f, 0x14, 0x7d, 0x57, 0x7d, 0x10, 0x00},   // 1f 0595 8ce5 Ã¦â€šÅ¸
    {0x1a, 0x7f, 0x14, 0x7d, 0x57, 0x7d, 0x10, 0x00},   // 1f 0596 8ce6 Ã¦Â¢Â§
    {0x1a, 0x7f, 0x7a, 0x4e, 0x7d, 0x2e, 0x7a, 0x00},   // 1f 0597 8ce7 Ã¦ÂªÅ½
    {0x2a, 0x3e, 0x3a, 0x2f, 0x7a, 0x3f, 0x7f, 0x00},   // 1f 0598 8ce8 Ã§â€˜Å¡
    {0x28, 0x5a, 0x2f, 0x6a, 0x6f, 0x1a, 0x28, 0x00},   // 1f 0599 8ce9 Ã§Â¢Â
    {0x6a, 0x6b, 0x14, 0x7d, 0x57, 0x7d, 0x10, 0x00},   // 1f 059a 8cea Ã¨ÂªÅ¾
    {0x6a, 0x6b, 0x00, 0x56, 0x14, 0x1f, 0x53, 0x00},   // 1f 059b 8ceb Ã¨ÂªÂ¤
    {0x6b, 0x6a, 0x42, 0x5f, 0x2e, 0x5f, 0x4a, 0x00},   // 1f 059c 8cec Ã¨Â­Â·
    {0x7d, 0x7f, 0x3a, 0x2f, 0x7a, 0x3f, 0x7f, 0x00},   // 1f 059d 8ced Ã©â€ Â
    {0x04, 0x23, 0x56, 0x56, 0x4e, 0x42, 0x62, 0x00},   // 1f 059e 8cee Ã¤Â¹Å¾
    {0x42, 0x1d, 0x5f, 0x55, 0x7f, 0x55, 0x5f, 0x00},   // 1f 059f 8cef Ã©Â¯â€°
    {0x4a, 0x4a, 0x56, 0x23, 0x56, 0x4a, 0x4a, 0x00},   // 1f 05a0 8cf0 Ã¤ÂºÂ¤
    {0x04, 0x7e, 0x4b, 0x56, 0x23, 0x56, 0x4a, 0x00},   // 1f 05a1 8cf1 Ã¤Â½Â¼
    {0x04, 0x7e, 0x01, 0x54, 0x5d, 0x37, 0x54, 0x00},   // 1f 05a2 8cf2 Ã¤Â¾Â¯
    {0x04, 0x7e, 0x3f, 0x54, 0x5d, 0x37, 0x54, 0x00},   // 1f 05a3 8cf3 Ã¥â‚¬â„¢
    {0x04, 0x7e, 0x15, 0x3e, 0x77, 0x3e, 0x14, 0x00},   // 1f 05a4 8cf4 Ã¥â‚¬â€“
    {0x48, 0x4a, 0x3c, 0x0f, 0x7c, 0x4a, 0x68, 0x00},   // 1f 05a5 8cf5 Ã¥â€¦â€°
    {0x48, 0x44, 0x63, 0x58, 0x43, 0x24, 0x48, 0x00},   // 1f 05a6 8cf6 Ã¥â€¦Â¬
    {0x22, 0x3e, 0x12, 0x42, 0x3f, 0x42, 0x7e, 0x00},   // 1f 05a7 8cf7 Ã¥Å Å¸
    {0x4a, 0x56, 0x23, 0x56, 0x3f, 0x42, 0x7e, 0x00},   // 1f 05a8 8cf8 Ã¥Å Â¹
    {0x08, 0x27, 0x32, 0x2e, 0x12, 0x22, 0x7e, 0x00},   // 1f 05a9 8cf9 Ã¥â€¹Â¾
    {0x40, 0x3f, 0x11, 0x57, 0x77, 0x1f, 0x11, 0x00},   // 1f 05aa 8cfa Ã¥Å½Å¡
    {0x00, 0x7e, 0x22, 0x22, 0x22, 0x22, 0x7e, 0x00},   // 1f 05ab 8cfb Ã¥ÂÂ£
    {0x7e, 0x02, 0x3a, 0x2b, 0x3a, 0x42, 0x7e, 0x00},   // 1f 05ac 8cfc Ã¥Ââ€˜    
    {0x40, 0x3e, 0x0a, 0x6a, 0x69, 0x69, 0x08, 0x00},   // 20 05ad 8d40 Ã¥ÂÅ½
    {0x1e, 0x12, 0x7f, 0x54, 0x5d, 0x37, 0x54, 0x00},   // 20 05ae 8d41 Ã¥â€“â€°
    {0x24, 0x3f, 0x42, 0x3a, 0x0b, 0x7a, 0x42, 0x00},   // 20 05af 8d42 Ã¥Ââ€˜
    {0x24, 0x3f, 0x54, 0x3e, 0x0a, 0x6a, 0x69, 0x00},   // 20 05b0 8d43 Ã¥Å¾Â¢
    {0x44, 0x5c, 0x37, 0x2c, 0x49, 0x7d, 0x0b, 0x00},   // 20 05b1 8d44 Ã¥Â¥Â½
    {0x51, 0x7d, 0x0b, 0x00, 0x7f, 0x40, 0x60, 0x00},   // 20 05b2 8d45 Ã¥Â­â€
    {0x28, 0x2a, 0x1a, 0x2f, 0x6e, 0x3a, 0x29, 0x00},   // 20 05b3 8d46 Ã¥Â­Â
    {0x2e, 0x1a, 0x4e, 0x6b, 0x5a, 0x2a, 0x46, 0x00},   // 20 05b4 8d47 Ã¥Â®Â
    {0x40, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x40, 0x00},   // 20 05b5 8d48 Ã¥Â·Â¥
    {0x22, 0x3e, 0x12, 0x01, 0x0f, 0x49, 0x79, 0x00},   // 20 05b6 8d49 Ã¥Â·Â§
    {0x28, 0x1a, 0x7f, 0x5a, 0x4f, 0x1a, 0x28, 0x00},   // 20 05b7 8d4a Ã¥Â·Â·
    {0x14, 0x36, 0x3e, 0x77, 0x3e, 0x36, 0x14, 0x00},   // 20 05b8 8d4b Ã¥Â¹Â¸
    {0x40, 0x3e, 0x42, 0x62, 0x5b, 0x22, 0x42, 0x00},   // 20 05b9 8d4c Ã¥ÂºÆ’
    {0x40, 0x3e, 0x42, 0x56, 0x3f, 0x56, 0x5e, 0x00},   // 20 05ba 8d4d Ã¥ÂºÅ¡
    {0x40, 0x3e, 0x5a, 0x2a, 0x7f, 0x2e, 0x56, 0x00},   // 20 05bb 8d4e Ã¥ÂºÂ·
    {0x5d, 0x77, 0x40, 0x70, 0x4f, 0x20, 0x40, 0x00},   // 20 05bc 8d4f Ã¥Â¼Ëœ
    {0x06, 0x7f, 0x41, 0x7f, 0x6b, 0x7f, 0x41, 0x00},   // 20 05bd 8d50 Ã¦Ââ€™
    {0x06, 0x7f, 0x42, 0x2f, 0x6a, 0x0b, 0x62, 0x00},   // 20 05be 8d51 Ã¦â€¦Å’
    {0x52, 0x7f, 0x42, 0x3a, 0x0b, 0x7a, 0x42, 0x00},   // 20 05bf 8d52 Ã¦Å â€”
    {0x52, 0x7f, 0x04, 0x1b, 0x1a, 0x42, 0x7e, 0x00},   // 20 05c0 8d53 Ã¦â€¹Ëœ
    {0x52, 0x7f, 0x46, 0x56, 0x73, 0x56, 0x46, 0x00},   // 20 05c1 8d54 Ã¦Å½Â§
    {0x22, 0x3e, 0x12, 0x44, 0x5f, 0x22, 0x5e, 0x00},   // 20 05c2 8d55 Ã¦â€Â»
    {0x30, 0x2f, 0x25, 0x05, 0x7d, 0x0f, 0x38, 0x00},   // 20 05c3 8d56 Ã¦Ëœâ€š
    {0x50, 0x5f, 0x35, 0x1d, 0x75, 0x5f, 0x50, 0x00},   // 20 05c4 8d57 Ã¦â„¢Æ’
    {0x41, 0x5f, 0x35, 0x3f, 0x55, 0x5f, 0x41, 0x00},   // 20 05c5 8d58 Ã¦â€ºÂ´
    {0x1a, 0x7f, 0x42, 0x3a, 0x0b, 0x7a, 0x42, 0x00},   // 20 05c6 8d59 Ã¦ÂÂ­
    {0x1a, 0x7f, 0x4a, 0x56, 0x23, 0x56, 0x4a, 0x00},   // 20 05c7 8d5a Ã¦Â Â¡
    {0x1a, 0x7f, 0x41, 0x57, 0x3f, 0x47, 0x41, 0x00},   // 20 05c8 8d5b Ã¦Â¢â€”
    {0x1a, 0x7f, 0x2a, 0x7f, 0x3a, 0x7f, 0x2a, 0x00},   // 20 05c9 8d5c Ã¦Â§â€¹
    {0x65, 0x10, 0x40, 0x42, 0x7e, 0x42, 0x40, 0x00},   // 20 05ca 8d5d Ã¦Â±Å¸
    {0x75, 0x00, 0x52, 0x1f, 0x12, 0x1f, 0x52, 0x00},   // 20 05cb 8d5e Ã¦Â´Âª
    {0x75, 0x00, 0x0c, 0x6b, 0x6f, 0x6a, 0x08, 0x00},   // 20 05cc 8d5f Ã¦ÂµÂ©
    {0x75, 0x28, 0x1a, 0x6f, 0x5a, 0x4f, 0x12, 0x00},   // 20 05cd 8d60 Ã¦Â¸Â¯
    {0x75, 0x00, 0x2a, 0x7f, 0x3a, 0x7f, 0x2a, 0x00},   // 20 05ce 8d61 Ã¦ÂºÂ
    {0x1f, 0x15, 0x15, 0x7f, 0x15, 0x15, 0x1f, 0x00},   // 20 05cf 8d62 Ã§â€Â²
    {0x50, 0x5e, 0x5a, 0x7b, 0x5a, 0x5e, 0x50, 0x00},   // 20 05d0 8d63 Ã§Å¡â€¡
    {0x09, 0x37, 0x31, 0x41, 0x57, 0x3f, 0x47, 0x00},   // 20 05d1 8d64 Ã§Â¡Â¬
    {0x35, 0x7f, 0x72, 0x1e, 0x5b, 0x1e, 0x72, 0x00},   // 20 05d2 8d65 Ã§Â¨Â¿
    {0x35, 0x7e, 0x3e, 0x52, 0x7f, 0x2e, 0x56, 0x00},   // 20 05d3 8d66 Ã§Â³Â 
    {0x2a, 0x75, 0x48, 0x42, 0x7e, 0x42, 0x40, 0x00},   // 20 05d4 8d67 Ã§Â´â€¦
    {0x2a, 0x75, 0x22, 0x1f, 0x62, 0x5a, 0x62, 0x00},   // 20 05d5 8d68 Ã§Â´Ëœ
    {0x2a, 0x75, 0x4a, 0x56, 0x23, 0x56, 0x4a, 0x00},   // 20 05d6 8d69 Ã§ÂµÅ¾
    {0x2a, 0x75, 0x7f, 0x35, 0x29, 0x35, 0x7f, 0x00},   // 20 05d7 8d6a Ã§Â¶Â±
    {0x2a, 0x7f, 0x52, 0x3f, 0x12, 0x7f, 0x12, 0x00},   // 20 05d8 8d6b Ã¨â‚¬â€¢
    {0x28, 0x2a, 0x1a, 0x3f, 0x2e, 0x2a, 0x69, 0x00},   // 20 05d9 8d6c Ã¨â‚¬Æ’
    {0x08, 0x7e, 0x28, 0x2f, 0x2a, 0x7a, 0x08, 0x00},   // 20 05da 8d6d Ã¨â€šÂ¯
    {0x7f, 0x15, 0x7f, 0x12, 0x6f, 0x52, 0x6a, 0x00},   // 20 05db 8d6e Ã¨â€šÂ±
    {0x7f, 0x15, 0x7f, 0x56, 0x73, 0x56, 0x46, 0x00},   // 20 05dc 8d6f Ã¨â€¦â€
    {0x1a, 0x6e, 0x3a, 0x3b, 0x3a, 0x6e, 0x1a, 0x00},   // 20 05dd 8d70 Ã¨â€ Â
    {0x7e, 0x13, 0x7e, 0x3a, 0x0b, 0x7a, 0x42, 0x00},   // 20 05de 8d71 Ã¨Ë†Âª
    {0x42, 0x2e, 0x0b, 0x6a, 0x0b, 0x6a, 0x42, 0x00},   // 20 05df 8d72 Ã¨Ââ€™
    {0x0a, 0x7d, 0x04, 0x05, 0x45, 0x7d, 0x04, 0x00},   // 20 05e0 8d73 Ã¨Â¡Å’
    {0x0a, 0x7d, 0x5a, 0x3d, 0x5b, 0x05, 0x7d, 0x00},   // 20 05e1 8d74 Ã¨Â¡Â¡
    {0x6b, 0x62, 0x2a, 0x7f, 0x3a, 0x7f, 0x2a, 0x00},   // 20 05e2 8d75 Ã¨Â¬â€º
    {0x44, 0x7d, 0x2d, 0x2f, 0x2d, 0x7d, 0x44, 0x00},   // 20 05e3 8d76 Ã¨Â²Â¢
    {0x5f, 0x1f, 0x2a, 0x7f, 0x3a, 0x7f, 0x2a, 0x00},   // 20 05e4 8d77 Ã¨Â³Â¼
    {0x4a, 0x56, 0x23, 0x56, 0x7f, 0x25, 0x1b, 0x00},   // 20 05e5 8d78 Ã©Æ’Å 
    {0x7d, 0x7f, 0x29, 0x1a, 0x2f, 0x7a, 0x29, 0x00},   // 20 05e6 8d79 Ã©â€¦Âµ
    {0x56, 0x7d, 0x36, 0x3e, 0x62, 0x5b, 0x62, 0x00},   // 20 05e7 8d7a Ã©â€°Â±
    {0x09, 0x37, 0x71, 0x3e, 0x62, 0x5b, 0x62, 0x00},   // 20 05e8 8d7b Ã§Â Â¿
    {0x56, 0x7d, 0x7f, 0x35, 0x29, 0x35, 0x7f, 0x00},   // 20 05e9 8d7c Ã©â€¹Â¼
    {0x7f, 0x13, 0x7b, 0x54, 0x7b, 0x13, 0x7f, 0x00},   // 20 05ea 8d7d Ã©â€“Â¤
    {0x7f, 0x1b, 0x28, 0x3a, 0x35, 0x7b, 0x28, 0x00},   // 20 05eb 8d7e Ã©â„¢Â
    {0x22, 0x3e, 0x12, 0x5d, 0x17, 0x15, 0x5d, 0x00},   // 21 05ec 8d80 Ã©Â â€¦
    {0x14, 0x76, 0x6e, 0x7e, 0x6d, 0x75, 0x14, 0x00},   // 21 05ed 8d81 Ã©Â¦â„¢
    {0x72, 0x12, 0x7e, 0x5b, 0x7e, 0x12, 0x72, 0x00},   // 21 05ee 8d82 Ã©Â«Ëœ
    {0x75, 0x22, 0x3e, 0x52, 0x1e, 0x57, 0x76, 0x00},   // 21 05ef 8d83 Ã©Â´Â»
    {0x7f, 0x35, 0x29, 0x35, 0x7f, 0x0e, 0x7f, 0x00},   // 21 05f0 8d84 Ã¥â€°â€º
    {0x48, 0x6a, 0x5f, 0x2a, 0x62, 0x1f, 0x7e, 0x00},   // 21 05f1 8d85 Ã¥Å Â«
    {0x04, 0x04, 0x1f, 0x15, 0x57, 0x74, 0x04, 0x00},   // 21 05f2 8d86 Ã¥ÂÂ·
    {0x04, 0x74, 0x52, 0x55, 0x56, 0x74, 0x04, 0x00},   // 21 05f3 8d87 Ã¥ÂË†
    {0x24, 0x3f, 0x2a, 0x5e, 0x7b, 0x2e, 0x5a, 0x00},   // 21 05f4 8d88 Ã¥Â£â€¢
    {0x52, 0x7f, 0x28, 0x1a, 0x3f, 0x2a, 0x69, 0x00},   // 21 05f5 8d89 Ã¦â€¹Â·
    {0x75, 0x18, 0x2a, 0x5e, 0x7b, 0x2e, 0x5a, 0x00},   // 21 05f6 8d8a Ã¦Â¿Â 
    {0x5a, 0x5e, 0x2a, 0x5b, 0x7a, 0x2e, 0x5a, 0x00},   // 21 05f7 8d8b Ã¨Â±Âª
    {0x2a, 0x3a, 0x7e, 0x2f, 0x3e, 0x7a, 0x2a, 0x00},   // 21 05f8 8d8c Ã¨Â½Å¸
    {0x52, 0x2f, 0x5a, 0x57, 0x7a, 0x56, 0x7e, 0x00},   // 21 05f9 8d8d Ã©ÂºÂ¹
    {0x42, 0x5e, 0x36, 0x17, 0x76, 0x5e, 0x62, 0x00},   // 21 05fa 8d8e Ã¥â€¦â€¹
    {0x4a, 0x56, 0x2b, 0x52, 0x0e, 0x40, 0x7f, 0x00},   // 21 05fb 8d8f Ã¥Ë†Â»
    {0x0c, 0x6b, 0x6a, 0x6f, 0x6a, 0x6a, 0x08, 0x00},   // 21 05fc 8d90 Ã¥â€˜Å 
    {0x7f, 0x41, 0x6b, 0x7f, 0x6b, 0x51, 0x7f, 0x00},   // 21 05fd 8d91 Ã¥â€ºÂ½
    {0x5a, 0x2a, 0x7f, 0x2a, 0x5b, 0x29, 0x5b, 0x00},   // 21 05fe 8d92 Ã§Â©â‚¬
    {0x7d, 0x6f, 0x7d, 0x0c, 0x6b, 0x6f, 0x6a, 0x00},   // 21 05ff 8d93 Ã©â€¦Â·
    {0x0c, 0x6b, 0x6f, 0x0a, 0x5e, 0x17, 0x76, 0x00},   // 21 0600 8d94 Ã©ÂµÂ 
    {0x50, 0x17, 0x55, 0x1f, 0x55, 0x17, 0x50, 0x00},   // 21 0601 8d95 Ã©Â»â€™
    {0x55, 0x4a, 0x3d, 0x6b, 0x6a, 0x3f, 0x45, 0x00},   // 21 0602 8d96 Ã§Ââ€ž
    {0x75, 0x40, 0x3e, 0x6a, 0x4f, 0x6e, 0x42, 0x00},   // 21 0603 8d97 Ã¦Â¼â€°
    {0x7f, 0x15, 0x7f, 0x51, 0x7f, 0x37, 0x51, 0x00},   // 21 0604 8d98 Ã¨â€¦Â°
    {0x6d, 0x6c, 0x4d, 0x7f, 0x55, 0x3d, 0x41, 0x00},   // 21 0605 8d99 Ã§â€â€˜
    {0x64, 0x33, 0x4e, 0x52, 0x6e, 0x12, 0x6e, 0x00},   // 21 0606 8d9a Ã¥Â¿Â½
    {0x06, 0x7f, 0x64, 0x33, 0x4e, 0x52, 0x6e, 0x00},   // 21 0607 8d9b Ã¦Æ’Å¡
    {0x0c, 0x04, 0x7f, 0x2d, 0x2f, 0x7f, 0x0c, 0x00},   // 21 0608 8d9c Ã©ÂªÂ¨
    {0x55, 0x4a, 0x3d, 0x7e, 0x4b, 0x4a, 0x7e, 0x00},   // 21 0609 8d9d Ã§â€¹â€º
    {0x49, 0x3a, 0x50, 0x49, 0x47, 0x48, 0x50, 0x00},   // 21 060a 8d9e Ã¨Â¾Â¼
    {0x7c, 0x40, 0x3f, 0x24, 0x7f, 0x48, 0x64, 0x00},   // 21 060b 8d9f Ã¦Â­Â¤
    {0x3f, 0x24, 0x32, 0x5d, 0x17, 0x15, 0x5d, 0x00},   // 21 060c 8da0 Ã©Â Æ’
    {0x04, 0x14, 0x52, 0x55, 0x36, 0x14, 0x04, 0x00},   // 21 060d 8da1 Ã¤Â»Å 
    {0x7f, 0x55, 0x4d, 0x7f, 0x4d, 0x55, 0x7f, 0x00},   // 21 060e 8da2 Ã¥â€ºÂ°
    {0x24, 0x3f, 0x3e, 0x2a, 0x7f, 0x2a, 0x3e, 0x00},   // 21 060f 8da3 Ã¥ÂÂ¤
    {0x4a, 0x56, 0x5d, 0x62, 0x5f, 0x4b, 0x54, 0x00},   // 21 0610 8da4 Ã¥Â¢Â¾
    {0x5c, 0x37, 0x2c, 0x1f, 0x75, 0x6f, 0x15, 0x00},   // 21 0611 8da5 Ã¥Â©Å¡
    {0x06, 0x7f, 0x02, 0x7f, 0x55, 0x35, 0x5f, 0x00},   // 21 0612 8da6 Ã¦ÂÂ¨
    {0x6a, 0x36, 0x5d, 0x42, 0x5f, 0x0b, 0x54, 0x00},   // 21 0613 8da7 Ã¦â€¡â€¡
    {0x10, 0x7e, 0x76, 0x66, 0x6d, 0x75, 0x10, 0x00},   // 21 0614 8da8 Ã¦ËœÂ
    {0x40, 0x7f, 0x55, 0x05, 0x7d, 0x57, 0x50, 0x00},   // 21 0615 8da9 Ã¦Ëœâ€ 
    {0x1a, 0x7f, 0x0a, 0x7f, 0x55, 0x35, 0x5f, 0x00},   // 21 0616 8daa Ã¦Â Â¹
    {0x1a, 0x7f, 0x7f, 0x55, 0x7f, 0x55, 0x7f, 0x00},   // 21 0617 8dab Ã¦Â¢Â±
    {0x75, 0x00, 0x7f, 0x55, 0x05, 0x7d, 0x57, 0x00},   // 21 0618 8dac Ã¦Â·Â·
    {0x54, 0x3e, 0x02, 0x7e, 0x57, 0x3e, 0x42, 0x00},   // 21 0619 8dad Ã§â€”â€¢
    {0x2a, 0x75, 0x2a, 0x7f, 0x4a, 0x7f, 0x02, 0x00},   // 21 061a 8dae Ã§Â´Âº
    {0x40, 0x7f, 0x55, 0x15, 0x35, 0x5f, 0x40, 0x00},   // 21 061b 8daf Ã¨â€°Â®
    {0x35, 0x2d, 0x35, 0x5e, 0x3f, 0x7a, 0x5e, 0x00},   // 21 061c 8db0 Ã©Â­â€š
    {0x4e, 0x58, 0x5f, 0x5a, 0x50, 0x5f, 0x4a, 0x00},   // 21 061d 8db1 Ã¤Âºâ€º
    {0x04, 0x7e, 0x23, 0x5e, 0x4b, 0x7a, 0x4a, 0x00},   // 21 061e 8db2 Ã¤Â½Â
    {0x40, 0x45, 0x29, 0x13, 0x29, 0x47, 0x40, 0x00},   // 21 061f 8db3 Ã¥Ââ€°
    {0x1e, 0x1e, 0x2a, 0x57, 0x32, 0x5e, 0x4b, 0x00},   // 21 0620 8db4 Ã¥â€â€ 
    {0x38, 0x3f, 0x4a, 0x3b, 0x5e, 0x7b, 0x5a, 0x00},   // 21 0621 8db5 Ã¥ÂµÂ¯
    {0x22, 0x52, 0x4f, 0x4a, 0x7a, 0x4a, 0x42, 0x00},   // 21 0622 8db6 Ã¥Â·Â¦
    {0x4a, 0x3a, 0x4b, 0x5e, 0x7a, 0x5b, 0x4a, 0x00},   // 21 0623 8db7 Ã¥Â·Â®
    {0x4a, 0x7a, 0x56, 0x5f, 0x56, 0x7a, 0x4a, 0x00},   // 21 0624 8db8 Ã¦Å¸Â»
    {0x75, 0x00, 0x08, 0x46, 0x5f, 0x22, 0x14, 0x00},   // 21 0625 8db9 Ã¦Â²â„¢
    {0x2a, 0x3e, 0x4a, 0x3b, 0x5e, 0x7b, 0x5a, 0x00},   // 21 0626 8dba Ã§â€˜Â³
    {0x09, 0x37, 0x31, 0x46, 0x5f, 0x22, 0x14, 0x00},   // 21 0627 8dbb Ã§Â â€š
    {0x6a, 0x6b, 0x04, 0x03, 0x7e, 0x2a, 0x2a, 0x00},   // 21 0628 8dbc Ã¨Â©Â
    {0x56, 0x7d, 0x36, 0x5d, 0x14, 0x17, 0x5d, 0x00},   // 21 0629 8dbd Ã©Å½â€“
    {0x55, 0x30, 0x7a, 0x58, 0x37, 0x54, 0x52, 0x00},   // 21 062a 8dbe Ã¨Â£Å¸
    {0x44, 0x53, 0x54, 0x7f, 0x54, 0x53, 0x44, 0x00},   // 21 062b 8dbf Ã¥ÂÂ
    {0x40, 0x3e, 0x4a, 0x56, 0x7b, 0x56, 0x4a, 0x00},   // 21 062c 8dc0 Ã¥ÂºÂ§
    {0x52, 0x7f, 0x44, 0x53, 0x7c, 0x53, 0x44, 0x00},   // 21 062d 8dc1 Ã¦Å’Â«
    {0x04, 0x7e, 0x49, 0x3a, 0x3f, 0x3a, 0x48, 0x00},   // 21 062e 8dc2 Ã¥â€šÂµ
    {0x04, 0x7e, 0x13, 0x7e, 0x4b, 0x7e, 0x4b, 0x00},   // 21 062f 8dc3 Ã¥â€šÂ¬
    {0x11, 0x7f, 0x15, 0x1f, 0x55, 0x7f, 0x11, 0x00},   // 21 0630 8dc4 Ã¥â€ Â
    {0x24, 0x3f, 0x25, 0x7d, 0x55, 0x27, 0x5c, 0x00},   // 21 0631 8dc5 Ã¦Å“â‚¬
    {0x08, 0x6a, 0x6f, 0x0a, 0x4f, 0x38, 0x5a, 0x00},   // 21 0632 8dc6 Ã¥â€œâ€°
    {0x56, 0x3a, 0x5e, 0x7b, 0x5e, 0x3a, 0x56, 0x00},   // 21 0633 8dc7 Ã¥Â¡Å¾
    {0x52, 0x5a, 0x7a, 0x5f, 0x3a, 0x5e, 0x52, 0x00},   // 21 0634 8dc8 Ã¥Â¦Â»
    {0x26, 0x2a, 0x3a, 0x6f, 0x3a, 0x2a, 0x26, 0x00},   // 21 0635 8dc9 Ã¥Â®Â°
    {0x56, 0x32, 0x76, 0x39, 0x55, 0x4a, 0x25, 0x00},   // 21 0636 8dca Ã¥Â½Â©
    {0x22, 0x22, 0x22, 0x52, 0x7f, 0x0a, 0x02, 0x00},   // 21 0637 8dcb Ã¦â€°Â
    {0x52, 0x7f, 0x56, 0x32, 0x76, 0x39, 0x55, 0x00},   // 21 0638 8dcc Ã¦Å½Â¡
    {0x48, 0x2a, 0x7f, 0x2a, 0x4f, 0x38, 0x5a, 0x00},   // 21 0639 8dcd Ã¦Â Â½
    {0x48, 0x3e, 0x68, 0x2f, 0x4a, 0x3a, 0x58, 0x00},   // 21 063a 8dce Ã¦Â­Â³
    {0x75, 0x00, 0x52, 0x36, 0x2b, 0x76, 0x12, 0x00},   // 21 063b 8dcf Ã¦Â¸Ë†
    {0x42, 0x55, 0x20, 0x1a, 0x25, 0x52, 0x45, 0x00},   // 21 063c 8dd0 Ã§ÂÂ½
    {0x52, 0x56, 0x32, 0x76, 0x39, 0x55, 0x51, 0x00},   // 21 063d 8dd1 Ã©â€¡â€¡
    {0x40, 0x3f, 0x2b, 0x3b, 0x33, 0x7f, 0x2b, 0x00},   // 21 063e 8dd2 Ã§Å â‚¬
    {0x09, 0x37, 0x31, 0x2a, 0x77, 0x2e, 0x28, 0x00},   // 21 063f 8dd3 Ã§Â â€¢
    {0x2e, 0x18, 0x6f, 0x6a, 0x68, 0x6f, 0x0a, 0x00},   // 21 0640 8dd4 Ã§Â Â¦
    {0x54, 0x2b, 0x55, 0x73, 0x14, 0x2d, 0x53, 0x00},   // 21 0641 8dd5 Ã§Â¥Â­
    {0x4a, 0x3a, 0x2e, 0x77, 0x2e, 0x7a, 0x0a, 0x00},   // 21 0642 8dd6 Ã¦â€“Å½
    {0x2a, 0x75, 0x28, 0x7f, 0x49, 0x7f, 0x7f, 0x00},   // 21 0643 8dd7 Ã§Â´Â°
    {0x52, 0x56, 0x33, 0x76, 0x3b, 0x56, 0x52, 0x00},   // 21 0644 8dd8 Ã¨ÂÅ“
    {0x28, 0x7a, 0x5f, 0x2a, 0x4f, 0x38, 0x5a, 0x00},   // 21 0645 8dd9 Ã¨Â£Â
    {0x28, 0x3a, 0x7f, 0x2a, 0x4f, 0x38, 0x5a, 0x00},   // 21 0646 8dda Ã¨Â¼â€°
    {0x7f, 0x1b, 0x4a, 0x15, 0x73, 0x15, 0x4b, 0x00},   // 21 0647 8ddb Ã©Å¡â€º
    {0x52, 0x36, 0x2b, 0x76, 0x1e, 0x40, 0x7f, 0x00},   // 21 0648 8ddc Ã¥â€°Â¤
    {0x12, 0x7a, 0x47, 0x4a, 0x7e, 0x4a, 0x42, 0x00},   // 21 0649 8ddd Ã¥Å“Â¨
    {0x1a, 0x7f, 0x22, 0x22, 0x52, 0x7f, 0x0a, 0x00},   // 21 064a 8dde Ã¦ÂÂ
    {0x2b, 0x6b, 0x3f, 0x03, 0x7f, 0x2b, 0x2b, 0x00},   // 21 064b 8ddf Ã§Â½Âª
    {0x5f, 0x15, 0x5f, 0x22, 0x52, 0x7f, 0x0a, 0x00},   // 21 064c 8de0 Ã¨Â²Â¡
    {0x71, 0x00, 0x28, 0x2f, 0x59, 0x7f, 0x09, 0x00},   // 21 064d 8de1 Ã¥â€ Â´
    {0x24, 0x3f, 0x54, 0x3f, 0x5d, 0x25, 0x5d, 0x00},   // 21 064e 8de2 Ã¥Ââ€š
    {0x7f, 0x1b, 0x40, 0x3f, 0x5d, 0x25, 0x5d, 0x00},   // 21 064f 8de3 Ã©ËœÂª
    {0x24, 0x3f, 0x2f, 0x75, 0x1f, 0x75, 0x2f, 0x00},   // 21 0650 8de4 Ã¥Â Âº
    {0x1a, 0x7f, 0x0a, 0x77, 0x3e, 0x6b, 0x3e, 0x00},   // 21 0651 8de5 Ã¦Â¦Å 
    {0x28, 0x18, 0x7d, 0x2a, 0x2a, 0x7d, 0x08, 0x00},   // 21 0652 8de6 Ã¨â€šÂ´
    {0x1e, 0x12, 0x5e, 0x55, 0x3c, 0x55, 0x54, 0x00},   // 21 0653 8de7 Ã¥â€™Â²
    {0x38, 0x3f, 0x12, 0x5a, 0x17, 0x7a, 0x12, 0x00},   // 21 0654 8de8 Ã¥Â´Å½
    {0x24, 0x3f, 0x12, 0x5a, 0x17, 0x7a, 0x12, 0x00},   // 21 0655 8de9 Ã¥Å¸Â¼
    {0x09, 0x37, 0x32, 0x5a, 0x17, 0x7a, 0x12, 0x00},   // 21 0656 8dea Ã§Â¢â€¢
    {0x4b, 0x0d, 0x5b, 0x16, 0x5d, 0x1f, 0x74, 0x00},   // 21 0657 8deb Ã©Â·Âº
    {0x04, 0x7e, 0x01, 0x04, 0x7f, 0x2a, 0x2a, 0x00},   // 21 0658 8dec Ã¤Â½Å“
    {0x7d, 0x14, 0x57, 0x7d, 0x0e, 0x40, 0x7f, 0x00},   // 21 0659 8ded Ã¥â€°Å 
    {0x1e, 0x1e, 0x04, 0x03, 0x7e, 0x2a, 0x2a, 0x00},   // 21 065a 8dee Ã¥â€™â€¹
    {0x52, 0x7f, 0x26, 0x1e, 0x73, 0x36, 0x26, 0x00},   // 21 065b 8def Ã¦ÂÂ¾
    {0x3e, 0x2a, 0x3e, 0x04, 0x7f, 0x2a, 0x2a, 0x00},   // 21 065c 8df0 Ã¦ËœÂ¨
    {0x5a, 0x33, 0x1e, 0x53, 0x3f, 0x55, 0x7f, 0x00},   // 21 065d 8df1 Ã¦Å“â€
    {0x1a, 0x7f, 0x08, 0x7f, 0x3f, 0x09, 0x7f, 0x00},   // 21 065e 8df2 Ã¦Å¸Âµ
    {0x26, 0x1a, 0x16, 0x73, 0x2e, 0x2a, 0x26, 0x00},   // 21 065f 8df3 Ã§Âªâ€ž
    {0x5c, 0x4b, 0x2e, 0x7c, 0x2b, 0x4e, 0x5a, 0x00},   // 21 0660 8df4 Ã§Â­â€“
    {0x4c, 0x16, 0x1e, 0x77, 0x0e, 0x16, 0x4c, 0x00},   // 21 0661 8df5 Ã§Â´Â¢
    {0x56, 0x7d, 0x0a, 0x7f, 0x5a, 0x7f, 0x0a, 0x00},   // 21 0662 8df6 Ã©Å’Â¯
    {0x1a, 0x7f, 0x49, 0x58, 0x2d, 0x3a, 0x49, 0x00},   // 21 0663 8df7 Ã¦Â¡Å“
    {0x42, 0x1d, 0x5f, 0x08, 0x5a, 0x7f, 0x5a, 0x00},   // 21 0664 8df8 Ã©Â®Â­
    {0x14, 0x13, 0x7e, 0x54, 0x7b, 0x7e, 0x52, 0x00},   // 21 0665 8df9 Ã§Â¬Â¹
    {0x44, 0x37, 0x3f, 0x54, 0x7f, 0x64, 0x72, 0x00},   // 21 0666 8dfa Ã¥Å’â„¢
    {0x08, 0x7f, 0x3f, 0x09, 0x3f, 0x09, 0x7f, 0x00},   // 21 0667 8dfb Ã¥â€ Å 
    {0x40, 0x3f, 0x15, 0x7d, 0x37, 0x40, 0x7f, 0x00},   // 21 0668 8dfc Ã¥Ë†Â·
    {0x56, 0x2e, 0x56, 0x73, 0x16, 0x2a, 0x56, 0x00},   // 22 0669 8e40 Ã¥Â¯Å¸
    {0x52, 0x7f, 0x0a, 0x52, 0x5d, 0x2a, 0x1d, 0x00},   // 22 066a 8e41 Ã¦â€¹Â¶
    {0x52, 0x7f, 0x24, 0x3f, 0x7d, 0x2f, 0x5c, 0x00},   // 22 066b 8e42 Ã¦â€™Â®
    {0x52, 0x7f, 0x56, 0x2a, 0x67, 0x2a, 0x56, 0x00},   // 22 066c 8e43 Ã¦â€œÂ¦
    {0x22, 0x1a, 0x7f, 0x0a, 0x7f, 0x40, 0x60, 0x00},   // 22 066d 8e44 Ã¦Å“Â­
    {0x54, 0x35, 0x7a, 0x35, 0x5b, 0x29, 0x5b, 0x00},   // 22 066e 8e45 Ã¦Â®Âº
    {0x7e, 0x36, 0x43, 0x3a, 0x4f, 0x7e, 0x4a, 0x00},   // 22 066f 8e46 Ã¨â€“Â©
    {0x5a, 0x37, 0x7e, 0x28, 0x7f, 0x7e, 0x4b, 0x00},   // 22 0670 8e47 Ã©â€ºâ€˜
    {0x28, 0x2e, 0x26, 0x7f, 0x26, 0x2e, 0x28, 0x00},   // 22 0671 8e48 Ã§Å¡Â
    {0x42, 0x1d, 0x5f, 0x08, 0x7a, 0x2f, 0x7a, 0x00},   // 22 0672 8e49 Ã©Â¯â€“
    {0x52, 0x7f, 0x67, 0x1d, 0x77, 0x0e, 0x7f, 0x00},   // 22 0673 8e4a Ã¦ÂÅ’
    {0x56, 0x7d, 0x0a, 0x7a, 0x2f, 0x7a, 0x08, 0x00},   // 22 0674 8e4b Ã©Å’â€ 
    {0x42, 0x1d, 0x5f, 0x56, 0x23, 0x56, 0x4a, 0x00},   // 22 0675 8e4c Ã©Â®Â«
    {0x40, 0x7e, 0x42, 0x7e, 0x42, 0x7e, 0x40, 0x00},   // 22 0676 8e4d Ã§Å¡Â¿
    {0x3e, 0x2a, 0x7d, 0x5f, 0x45, 0x5f, 0x7d, 0x00},   // 22 0677 8e4e Ã¦â„¢â€™
    {0x40, 0x42, 0x4a, 0x4a, 0x4a, 0x42, 0x40, 0x00},   // 22 0678 8e4f Ã¤Â¸â€°
    {0x24, 0x34, 0x2a, 0x7d, 0x2a, 0x34, 0x24, 0x00},   // 22 0679 8e50 Ã¥â€šËœ
    {0x14, 0x4e, 0x57, 0x4e, 0x25, 0x0e, 0x14, 0x00},   // 22 067a 8e51 Ã¥Ââ€š
    {0x7c, 0x40, 0x40, 0x7f, 0x40, 0x40, 0x7c, 0x00},   // 22 067b 8e52 Ã¥Â±Â±
    {0x06, 0x7f, 0x14, 0x4e, 0x55, 0x2a, 0x14, 0x00},   // 22 067c 8e53 Ã¦Æ’Â¨
    {0x52, 0x7f, 0x0a, 0x7f, 0x7e, 0x23, 0x5e, 0x00},   // 22 067d 8e54 Ã¦â€™â€™
    {0x0a, 0x7f, 0x2a, 0x7f, 0x5c, 0x23, 0x5e, 0x00},   // 22 067e 8e55 Ã¦â€¢Â£
    {0x1a, 0x7f, 0x0a, 0x4a, 0x5f, 0x2a, 0x53, 0x00},   // 22 067f 8e56 Ã¦Â¡Å¸
    {0x4c, 0x3f, 0x54, 0x2b, 0x75, 0x2a, 0x56, 0x00},   // 22 0680 8e57 Ã§â€¡Â¦
    {0x2a, 0x3e, 0x2a, 0x7f, 0x3f, 0x09, 0x7f, 0x00},   // 22 0681 8e58 Ã§ÂÅ 
    {0x42, 0x3a, 0x4e, 0x5b, 0x7a, 0x5e, 0x4a, 0x00},   // 22 0682 8e59 Ã§â€Â£
    {0x24, 0x7b, 0x2e, 0x2c, 0x6b, 0x3e, 0x22, 0x00},   // 22 0683 8e5a Ã§Â®â€”
    {0x54, 0x13, 0x3e, 0x7c, 0x3b, 0x16, 0x52, 0x00},   // 22 0684 8e5b Ã§Âºâ€š
    {0x45, 0x5d, 0x55, 0x7b, 0x55, 0x3d, 0x45, 0x00},   // 22 0685 8e5c Ã¨Å¡â€¢
    {0x6b, 0x62, 0x4a, 0x37, 0x3a, 0x37, 0x4a, 0x00},   // 22 0686 8e5d Ã¨Â®Æ’
    {0x4a, 0x77, 0x3a, 0x30, 0x3a, 0x77, 0x4a, 0x00},   // 22 0687 8e5e Ã¨Â³â€º
    {0x7d, 0x6f, 0x7d, 0x2a, 0x57, 0x32, 0x4f, 0x00},   // 22 0688 8e5f Ã©â€¦Â¸
    {0x14, 0x54, 0x7b, 0x5e, 0x2b, 0x55, 0x5b, 0x00},   // 22 0689 8e60 Ã©Â¤Â
    {0x2d, 0x7f, 0x2d, 0x3e, 0x0a, 0x79, 0x08, 0x00},   // 22 068a 8e61 Ã¦â€“Â¬
    {0x0a, 0x6e, 0x7f, 0x6a, 0x67, 0x7d, 0x05, 0x00},   // 22 068b 8e62 Ã¦Å¡Â«
    {0x49, 0x37, 0x1d, 0x4a, 0x5f, 0x2a, 0x53, 0x00},   // 22 068c 8e63 Ã¦Â®â€¹
    {0x04, 0x7e, 0x05, 0x44, 0x7f, 0x44, 0x04, 0x00},   // 22 068d 8e64 Ã¤Â»â€¢
    {0x04, 0x7e, 0x09, 0x49, 0x7d, 0x0b, 0x08, 0x00},   // 22 068e 8e65 Ã¤Â»â€
    {0x04, 0x7e, 0x01, 0x35, 0x35, 0x41, 0x7f, 0x00},   // 22 068f 8e66 Ã¤Â¼Âº
    {0x04, 0x7e, 0x53, 0x5e, 0x3f, 0x4a, 0x4e, 0x00},   // 22 0690 8e67 Ã¤Â½Â¿
    {0x5a, 0x2a, 0x7f, 0x2a, 0x5a, 0x00, 0x7f, 0x00},   // 22 0691 8e68 Ã¥Ë†Âº
    {0x01, 0x35, 0x35, 0x35, 0x35, 0x41, 0x7f, 0x00},   // 22 0692 8e69 Ã¥ÂÂ¸
    {0x40, 0x4e, 0x5a, 0x3f, 0x4a, 0x4e, 0x40, 0x00},   // 22 0693 8e6a Ã¥ÂÂ²
    {0x78, 0x3b, 0x1b, 0x78, 0x35, 0x35, 0x7f, 0x00},   // 22 0694 8e6b Ã¥â€”Â£
    {0x7f, 0x51, 0x4f, 0x41, 0x4f, 0x49, 0x7f, 0x00},   // 22 0695 8e6c Ã¥â€ºâ€º
    {0x04, 0x44, 0x44, 0x7f, 0x44, 0x44, 0x04, 0x00},   // 22 0696 8e6d Ã¥Â£Â«
    {0x44, 0x5c, 0x37, 0x2c, 0x6c, 0x6b, 0x6c, 0x00},   // 22 0697 8e6e Ã¥Â§â€¹
    {0x5c, 0x37, 0x2c, 0x3a, 0x0a, 0x7f, 0x3a, 0x00},   // 22 0698 8e6f Ã¥Â§â€°
    {0x55, 0x50, 0x74, 0x5b, 0x36, 0x5a, 0x56, 0x00},   // 22 0699 8e70 Ã¥Â§Â¿
    {0x08, 0x09, 0x49, 0x7d, 0x0b, 0x09, 0x08, 0x00},   // 22 069a 8e71 Ã¥Â­Â
    {0x40, 0x3f, 0x55, 0x2d, 0x1d, 0x7d, 0x57, 0x00},   // 22 069b 8e72 Ã¥Â±Â
    {0x02, 0x3a, 0x0a, 0x7f, 0x0a, 0x3a, 0x02, 0x00},   // 22 069c 8e73 Ã¥Â¸â€š
    {0x3e, 0x37, 0x3e, 0x05, 0x7f, 0x05, 0x3d, 0x00},   // 22 069d 8e74 Ã¥Â¸Â«
    {0x62, 0x2a, 0x4a, 0x4f, 0x6a, 0x0a, 0x62, 0x00},   // 22 069e 8e75 Ã¥Â¿â€”
    {0x60, 0x3f, 0x55, 0x5f, 0x75, 0x1f, 0x60, 0x00},   // 22 069f 8e76 Ã¦â‚¬Â
    {0x52, 0x7f, 0x00, 0x6f, 0x6a, 0x6a, 0x6d, 0x00},   // 22 06a0 8e77 Ã¦Å’â€¡
    {0x42, 0x4a, 0x5a, 0x2f, 0x5a, 0x42, 0x42, 0x00},   // 22 06a1 8e78 Ã¦â€Â¯
    {0x51, 0x7d, 0x0b, 0x44, 0x5f, 0x22, 0x5e, 0x00},   // 22 06a2 8e79 Ã¥Â­Å“
    {0x52, 0x1f, 0x1a, 0x5f, 0x3e, 0x0a, 0x79, 0x00},   // 22 06a3 8e7a Ã¦â€“Â¯
    {0x62, 0x1f, 0x7a, 0x14, 0x7f, 0x4a, 0x5a, 0x00},   // 22 06a4 8e7b Ã¦â€“Â½
    {0x07, 0x7a, 0x5a, 0x5a, 0x59, 0x79, 0x0c, 0x00},   // 22 06a5 8e7c Ã¦â€”Â¨
    {0x1a, 0x7f, 0x4a, 0x5a, 0x2f, 0x5a, 0x42, 0x00},   // 22 06a6 8e7d Ã¦Å¾Â
    {0x40, 0x7c, 0x40, 0x7f, 0x44, 0x44, 0x40, 0x00},   // 22 06a7 8e7e Ã¦Â­Â¢
    {0x49, 0x37, 0x1d, 0x01, 0x7f, 0x49, 0x65, 0x00},   // 23 06a8 8e80 Ã¦Â­Â»
    {0x40, 0x7e, 0x4a, 0x0e, 0x19, 0x29, 0x48, 0x00},   // 23 06a9 8e81 Ã¦Â°Â
    {0x55, 0x4a, 0x3d, 0x3e, 0x37, 0x7f, 0x3d, 0x00},   // 23 06aa 8e82 Ã§Ââ€¦
    {0x12, 0x7b, 0x56, 0x7c, 0x40, 0x7f, 0x44, 0x00},   // 23 06ab 8e83 Ã§Â¥â€°
    {0x24, 0x15, 0x7f, 0x15, 0x70, 0x4f, 0x60, 0x00},   // 23 06ac 8e84 Ã§Â§Â
    {0x50, 0x12, 0x1a, 0x75, 0x14, 0x0a, 0x50, 0x00},   // 23 06ad 8e85 Ã§Â³Â¸
    {0x2a, 0x75, 0x28, 0x7e, 0x4a, 0x3e, 0x49, 0x00},   // 23 06ae 8e86 Ã§Â´â„¢
    {0x4e, 0x18, 0x1f, 0x7a, 0x10, 0x0f, 0x5a, 0x00},   // 23 06af 8e87 Ã§Â´Â«
    {0x7f, 0x15, 0x7f, 0x4a, 0x5a, 0x2f, 0x5a, 0x00},   // 23 06b0 8e88 Ã¨â€šÂ¢
    {0x7f, 0x15, 0x7f, 0x00, 0x6f, 0x6a, 0x6d, 0x00},   // 23 06b1 8e89 Ã¨â€žâ€š
    {0x41, 0x55, 0x57, 0x7d, 0x53, 0x55, 0x41, 0x00},   // 23 06b2 8e8a Ã¨â€¡Â³
    {0x12, 0x7b, 0x16, 0x5f, 0x35, 0x75, 0x5f, 0x00},   // 23 06b3 8e8b Ã¨Â¦â€“
    {0x6a, 0x6b, 0x02, 0x35, 0x35, 0x41, 0x7f, 0x00},   // 23 06b4 8e8c Ã¨Â©Å¾
    {0x6a, 0x63, 0x28, 0x6a, 0x2f, 0x7a, 0x28, 0x00},   // 23 06b5 8e8d Ã¨Â©Â©
    {0x6a, 0x6b, 0x54, 0x74, 0x57, 0x3c, 0x45, 0x00},   // 23 06b6 8e8e Ã¨Â©Â¦
    {0x6b, 0x6a, 0x42, 0x2a, 0x4f, 0x4a, 0x62, 0x00},   // 23 06b7 8e8f Ã¨ÂªÅ’
    {0x6b, 0x6a, 0x11, 0x64, 0x73, 0x6e, 0x76, 0x00},   // 23 06b8 8e90 Ã¨Â«Â®
    {0x49, 0x70, 0x34, 0x3b, 0x36, 0x7a, 0x46, 0x00},   // 23 06b9 8e91 Ã¨Â³â€¡
    {0x5f, 0x15, 0x5f, 0x27, 0x5d, 0x35, 0x77, 0x00},   // 23 06ba 8e92 Ã¨Â³Å“
    {0x7c, 0x7f, 0x24, 0x7f, 0x4a, 0x7f, 0x4a, 0x00},   // 23 06bb 8e93 Ã©â€ºÅ’
    {0x7a, 0x5d, 0x42, 0x35, 0x35, 0x41, 0x7f, 0x00},   // 23 06bc 8e94 Ã©Â£Â¼
    {0x04, 0x7e, 0x6c, 0x7f, 0x56, 0x6e, 0x7a, 0x00},   // 23 06bd 8e95 Ã¦Â­Â¯
    {0x2a, 0x2e, 0x6a, 0x7f, 0x2a, 0x3e, 0x12, 0x00},   // 23 06be 8e96 Ã¤Âºâ€¹
    {0x04, 0x7e, 0x21, 0x1f, 0x48, 0x22, 0x5f, 0x00},   // 23 06bf 8e97 Ã¤Â¼Â¼
    {0x04, 0x7e, 0x29, 0x6a, 0x2f, 0x7a, 0x28, 0x00},   // 23 06c0 8e98 Ã¤Â¾Â
    {0x40, 0x5f, 0x20, 0x1f, 0x75, 0x5f, 0x60, 0x00},   // 23 06c1 8e99 Ã¥â€¦Â
    {0x16, 0x12, 0x56, 0x77, 0x1e, 0x12, 0x16, 0x00},   // 23 06c2 8e9a Ã¥Â­â€”
    {0x28, 0x2a, 0x6a, 0x2f, 0x7a, 0x2a, 0x28, 0x00},   // 23 06c3 8e9b Ã¥Â¯Âº
    {0x62, 0x2a, 0x57, 0x42, 0x6a, 0x17, 0x62, 0x00},   // 23 06c4 8e9c Ã¦â€¦Ë†
    {0x52, 0x7f, 0x28, 0x6a, 0x2f, 0x7a, 0x28, 0x00},   // 23 06c5 8e9d Ã¦Å’Â
    {0x3e, 0x2a, 0x3e, 0x6a, 0x2f, 0x7a, 0x28, 0x00},   // 23 06c6 8e9e Ã¦â„¢â€š
    {0x61, 0x10, 0x44, 0x23, 0x1e, 0x22, 0x46, 0x00},   // 23 06c7 8e9f Ã¦Â¬Â¡
    {0x75, 0x00, 0x6a, 0x57, 0x02, 0x6b, 0x56, 0x00},   // 23 06c8 8ea0 Ã¦Â»â€¹
    {0x75, 0x00, 0x08, 0x6c, 0x6b, 0x64, 0x08, 0x00},   // 23 06c9 8ea1 Ã¦Â²Â»
    {0x7d, 0x57, 0x2d, 0x7f, 0x55, 0x2f, 0x7d, 0x00},   // 23 06ca 8ea2 Ã§Ë†Â¾
    {0x5d, 0x77, 0x6d, 0x7f, 0x75, 0x6f, 0x5d, 0x00},   // 23 06cb 8ea3 Ã§â€™Â½
    {0x54, 0x3e, 0x12, 0x36, 0x5f, 0x76, 0x12, 0x00},   // 23 06cc 8ea4 Ã§â€”â€
    {0x09, 0x37, 0x31, 0x6a, 0x57, 0x6a, 0x57, 0x00},   // 23 06cd 8ea5 Ã§Â£Â
    {0x24, 0x15, 0x45, 0x7d, 0x05, 0x15, 0x24, 0x00},   // 23 06ce 8ea6 Ã§Â¤Âº
    {0x7d, 0x05, 0x7d, 0x07, 0x7d, 0x05, 0x7d, 0x00},   // 23 06cf 8ea7 Ã¨â‚¬Å’
    {0x21, 0x21, 0x3f, 0x2d, 0x2d, 0x7f, 0x21, 0x00},   // 23 06d0 8ea8 Ã¨â‚¬Â³
    {0x00, 0x7e, 0x4a, 0x5b, 0x5a, 0x52, 0x7e, 0x00},   // 23 06d1 8ea9 Ã¨â€¡Âª
    {0x3a, 0x3a, 0x13, 0x36, 0x5f, 0x76, 0x12, 0x00},   // 23 06d2 8eaa Ã¨â€™â€
    {0x76, 0x5e, 0x75, 0x2a, 0x2e, 0x7b, 0x2e, 0x00},   // 23 06d3 8eab Ã¨Â¾Å¾
    {0x75, 0x00, 0x48, 0x44, 0x2b, 0x12, 0x0e, 0x00},   // 23 06d4 8eac Ã¦Â±Â
    {0x40, 0x3e, 0x7a, 0x5e, 0x0b, 0x7e, 0x52, 0x00},   // 23 06d5 8ead Ã©Â¹Â¿
    {0x42, 0x4a, 0x3a, 0x2a, 0x0f, 0x32, 0x43, 0x00},   // 23 06d6 8eae Ã¥Â¼Â
    {0x6b, 0x62, 0x0a, 0x6f, 0x6e, 0x3f, 0x55, 0x00},   // 23 06d7 8eaf Ã¨Â­Ëœ
    {0x3e, 0x3e, 0x3e, 0x40, 0x1e, 0x57, 0x76, 0x00},   // 23 06d8 8eb0 Ã©Â´Â«
    {0x44, 0x53, 0x56, 0x54, 0x53, 0x56, 0x42, 0x00},   // 23 06d9 8eb1 Ã§Â«Âº
    {0x2d, 0x7f, 0x2d, 0x7e, 0x4a, 0x7f, 0x7e, 0x00},   // 23 06da 8eb2 Ã¨Â»Â¸
    {0x56, 0x52, 0x12, 0x1b, 0x12, 0x52, 0x56, 0x00},   // 23 06db 8eb3 Ã¥Â®Â
    {0x16, 0x12, 0x17, 0x77, 0x33, 0x56, 0x16, 0x00},   // 23 06dc 8eb4 Ã©â€ºÂ«
    {0x08, 0x08, 0x3f, 0x48, 0x44, 0x44, 0x64, 0x00},   // 23 06dd 8eb5 Ã¤Â¸Æ’
    {0x1e, 0x12, 0x1e, 0x7f, 0x48, 0x48, 0x64, 0x00},   // 23 06de 8eb6 Ã¥ÂÂ±
    {0x14, 0x3e, 0x77, 0x3e, 0x13, 0x7e, 0x40, 0x00},   // 23 06df 8eb7 Ã¥Å¸Â·
    {0x4c, 0x4b, 0x2a, 0x1f, 0x2a, 0x4a, 0x48, 0x00},   // 23 06e0 8eb8 Ã¥Â¤Â±
    {0x5f, 0x3c, 0x54, 0x3e, 0x5a, 0x33, 0x52, 0x00},   // 23 06e1 8eb9 Ã¥Â«â€°
    {0x46, 0x52, 0x5e, 0x77, 0x4a, 0x52, 0x46, 0x00},   // 23 06e2 8eba Ã¥Â®Â¤
    {0x55, 0x37, 0x4d, 0x5f, 0x6d, 0x17, 0x55, 0x00},   // 23 06e3 8ebb Ã¦â€šâ€°
    {0x75, 0x00, 0x57, 0x7d, 0x45, 0x7d, 0x57, 0x00},   // 23 06e4 8ebc Ã¦Â¹Â¿
    {0x75, 0x40, 0x2a, 0x56, 0x7f, 0x36, 0x4a, 0x00},   // 23 06e5 8ebd Ã¦Â¼â€ 
    {0x54, 0x3e, 0x52, 0x5e, 0x3b, 0x5a, 0x52, 0x00},   // 23 06e6 8ebe Ã§â€“Â¾
    {0x48, 0x46, 0x3d, 0x28, 0x2e, 0x7d, 0x44, 0x00},   // 23 06e7 8ebf Ã¨Â³Âª
    {0x56, 0x52, 0x56, 0x3f, 0x56, 0x52, 0x56, 0x00},   // 23 06e8 8ec0 Ã¥Â®Å¸
    {0x2a, 0x7a, 0x6f, 0x7a, 0x2b, 0x7e, 0x36, 0x00},   // 23 06e9 8ec1 Ã¨â€â‚¬
    {0x14, 0x7b, 0x56, 0x34, 0x7b, 0x36, 0x52, 0x00},   // 23 06ea 8ec2 Ã§Â¯Â 
    {0x04, 0x7e, 0x6f, 0x2d, 0x4f, 0x4d, 0x6f, 0x00},   // 23 06eb 8ec3 Ã¥ÂÂ²
    {0x5e, 0x58, 0x3f, 0x7a, 0x30, 0x5f, 0x5a, 0x00},   // 23 06ec 8ec4 Ã¦Å¸Â´
    {0x42, 0x2a, 0x4b, 0x6e, 0x5b, 0x4a, 0x42, 0x00},   // 23 06ed 8ec5 Ã¨Å Â
    {0x40, 0x3f, 0x57, 0x7b, 0x5f, 0x3b, 0x57, 0x00},   // 23 06ee 8ec6 Ã¥Â±Â¡
    {0x6a, 0x3e, 0x53, 0x56, 0x3b, 0x46, 0x6a, 0x00},   // 23 06ef 8ec7 Ã¨â€¢Å 
    {0x2a, 0x75, 0x72, 0x1e, 0x5b, 0x1e, 0x72, 0x00},   // 23 06f0 8ec8 Ã§Â¸Å¾
    {0x14, 0x74, 0x5a, 0x5d, 0x5a, 0x74, 0x14, 0x00},   // 23 06f1 8ec9 Ã¨Ë†Å½
    {0x13, 0x11, 0x1f, 0x55, 0x75, 0x15, 0x13, 0x00},   // 23 06f2 8eca Ã¥â€ â„¢
    {0x50, 0x5e, 0x2b, 0x7e, 0x0a, 0x52, 0x7f, 0x00},   // 23 06f3 8ecb Ã¥Â°â€ž
    {0x52, 0x7f, 0x14, 0x7a, 0x5d, 0x7a, 0x14, 0x00},   // 23 06f4 8ecc Ã¦ÂÂ¨
    {0x28, 0x7a, 0x0f, 0x7a, 0x5c, 0x23, 0x5e, 0x00},   // 23 06f5 8ecd Ã¨ÂµÂ¦
    {0x54, 0x16, 0x7d, 0x56, 0x2a, 0x20, 0x7f, 0x00},   // 23 06f6 8ece Ã¦â€“Å“
    {0x48, 0x1a, 0x4a, 0x1f, 0x5e, 0x1b, 0x48, 0x00},   // 23 06f7 8ecf Ã§â€¦Â®
    {0x12, 0x7b, 0x56, 0x44, 0x7f, 0x44, 0x40, 0x00},   // 23 06f8 8ed0 Ã§Â¤Â¾
    {0x2a, 0x75, 0x28, 0x46, 0x5f, 0x22, 0x14, 0x00},   // 23 06f9 8ed1 Ã§Â´â€”
    {0x28, 0x2a, 0x1a, 0x6f, 0x6e, 0x6a, 0x09, 0x00},   // 23 06fa 8ed2 Ã¨â‚¬â€¦
    {0x6b, 0x62, 0x5e, 0x2b, 0x7e, 0x1a, 0x7f, 0x00},   // 23 06fb 8ed3 Ã¨Â¬Â
    {0x22, 0x3e, 0x2a, 0x7f, 0x2a, 0x3e, 0x22, 0x00},   // 23 06fc 8ed4 Ã¨Â»Å 
    {0x49, 0x38, 0x6e, 0x4a, 0x6f, 0x4e, 0x6a, 0x00},   // 23 06fd 8ed5 Ã©ÂÂ®
    {0x4e, 0x7b, 0x2e, 0x06, 0x7b, 0x52, 0x56, 0x00},   // 23 06fe 8ed6 Ã¨â€ºâ€¡
    {0x2f, 0x59, 0x7f, 0x09, 0x7f, 0x25, 0x1b, 0x00},   // 23 06ff 8ed7 Ã©â€šÂª
    {0x0c, 0x7f, 0x0a, 0x7f, 0x5a, 0x7f, 0x0a, 0x00},   // 23 0700 8ed8 Ã¥â‚¬Å¸
    {0x04, 0x03, 0x0a, 0x12, 0x02, 0x42, 0x7e, 0x00},   // 23 0701 8ed9 Ã¥â€¹Âº
    {0x40, 0x3f, 0x05, 0x0d, 0x15, 0x27, 0x40, 0x00},   // 23 0702 8eda Ã¥Â°Âº
    {0x1a, 0x7f, 0x04, 0x0b, 0x12, 0x42, 0x7e, 0x00},   // 23 0703 8edb Ã¦Ââ€œ
    {0x4c, 0x3f, 0x24, 0x0b, 0x12, 0x42, 0x7e, 0x00},   // 23 0704 8edc Ã§ÂÂ¼
    {0x41, 0x7f, 0x5d, 0x6f, 0x0d, 0x5f, 0x7d, 0x00},   // 23 0705 8edd Ã§Ë†Âµ
    {0x7d, 0x6f, 0x7d, 0x04, 0x0b, 0x52, 0x7e, 0x00},   // 23 0706 8ede Ã©â€¦Å’
    {0x55, 0x31, 0x7f, 0x55, 0x3f, 0x19, 0x67, 0x00},   // 23 0707 8edf Ã©â€¡Ë†
    {0x56, 0x7d, 0x36, 0x27, 0x5d, 0x35, 0x77, 0x00},   // 23 0708 8ee0 Ã©Å’Â«
    {0x2a, 0x1a, 0x6f, 0x6a, 0x6b, 0x6a, 0x0a, 0x00},   // 23 0709 8ee1 Ã¨â€¹Â¥
    {0x56, 0x12, 0x7e, 0x17, 0x5a, 0x2a, 0x5e, 0x00},   // 23 070a 8ee2 Ã¥Â¯â€š
    {0x2d, 0x55, 0x77, 0x00, 0x2d, 0x55, 0x77, 0x00},   // 23 070b 8ee3 Ã¥Â¼Â±
    {0x52, 0x2a, 0x5f, 0x5a, 0x7b, 0x0a, 0x6a, 0x00},   // 23 070c 8ee4 Ã¦Æ’Â¹
    {0x44, 0x54, 0x55, 0x7e, 0x54, 0x54, 0x44, 0x00},   // 23 070d 8ee5 Ã¤Â¸Â»
    {0x21, 0x3f, 0x2d, 0x7f, 0x2a, 0x12, 0x2e, 0x00},   // 23 070e 8ee6 Ã¥Ââ€“
    {0x16, 0x12, 0x32, 0x53, 0x7a, 0x12, 0x16, 0x00},   // 23 070f 8ee7 Ã¥Â®Ë†
    {0x14, 0x16, 0x56, 0x7e, 0x15, 0x15, 0x14, 0x00},   // 23 0710 8ee8 Ã¦â€°â€¹
    {0x4c, 0x4b, 0x2a, 0x7f, 0x2a, 0x4a, 0x48, 0x00},   // 23 0711 8ee9 Ã¦Å“Â±
    {0x49, 0x37, 0x5d, 0x2b, 0x7f, 0x2a, 0x48, 0x00},   // 23 0712 8eea Ã¦Â®Å 
    {0x55, 0x4a, 0x3d, 0x36, 0x53, 0x7a, 0x16, 0x00},   // 23 0713 8eeb Ã§â€¹Â©
    {0x2a, 0x3e, 0x4c, 0x2b, 0x7f, 0x2a, 0x48, 0x00},   // 23 0714 8eec Ã§ÂÂ 
    {0x35, 0x7f, 0x44, 0x5e, 0x7e, 0x5d, 0x44, 0x00},   // 23 0715 8eed Ã§Â¨Â®
    {0x7f, 0x15, 0x7f, 0x44, 0x5e, 0x7e, 0x5d, 0x00},   // 23 0716 8eee Ã¨â€¦Â«
    {0x6a, 0x3f, 0x4a, 0x51, 0x7f, 0x4a, 0x56, 0x00},   // 23 0717 8eef Ã¨Â¶Â£
    {0x75, 0x00, 0x7d, 0x6f, 0x65, 0x6f, 0x7d, 0x00},   // 23 0718 8ef0 Ã©â€¦â€™
    {0x02, 0x7a, 0x5b, 0x5e, 0x5a, 0x7b, 0x02, 0x00},   // 23 0719 8ef1 Ã©Â¦â€“
    {0x0c, 0x7f, 0x66, 0x2b, 0x7f, 0x2b, 0x66, 0x00},   // 23 071a 8ef2 Ã¥â€žâ€™
    {0x4d, 0x47, 0x5d, 0x2f, 0x5d, 0x47, 0x4d, 0x00},   // 23 071b 8ef3 Ã¥Ââ€”
    {0x1e, 0x52, 0x4f, 0x39, 0x09, 0x79, 0x4f, 0x00},   // 23 071c 8ef4 Ã¥â€˜Âª
    {0x54, 0x36, 0x1e, 0x57, 0x16, 0x7e, 0x14, 0x00},   // 23 071d 8ef5 Ã¥Â¯Â¿
    {0x52, 0x7f, 0x4d, 0x57, 0x35, 0x57, 0x4d, 0x00},   // 23 071e 8ef6 Ã¦Å½Ë†
    {0x1a, 0x7f, 0x5a, 0x6f, 0x5a, 0x12, 0x7f, 0x00},   // 23 071f 8ef7 Ã¦Â¨Â¹
    {0x2a, 0x75, 0x4d, 0x57, 0x35, 0x57, 0x4d, 0x00},   // 23 0720 8ef8 Ã§Â¶Â¬
    {0x66, 0x2a, 0x6f, 0x3f, 0x6b, 0x2e, 0x66, 0x00},   // 23 0721 8ef9 Ã©Å“â‚¬
    {0x7f, 0x61, 0x51, 0x4f, 0x51, 0x61, 0x7f, 0x00},   // 23 0722 8efa Ã¥â€ºÅ¡
    {0x3e, 0x20, 0x7f, 0x10, 0x4d, 0x31, 0x4f, 0x00},   // 23 0723 8efb Ã¥ÂÅ½
    {0x40, 0x3f, 0x75, 0x5f, 0x75, 0x11, 0x7f, 0x00},   // 23 0724 8efc Ã¥â€˜Â¨
    {0x56, 0x32, 0x56, 0x77, 0x16, 0x32, 0x56, 0x00},   // 24 0725 8f40 Ã¥Â®â€”
    {0x22, 0x4e, 0x7b, 0x2e, 0x44, 0x3f, 0x45, 0x00},   // 24 0726 8f41 Ã¥Â°Â±
    {0x4c, 0x3f, 0x0c, 0x7f, 0x00, 0x0c, 0x7f, 0x00},   // 24 0727 8f42 Ã¥Â·Å¾
    {0x04, 0x7e, 0x3f, 0x04, 0x4b, 0x56, 0x2a, 0x00},   // 24 0728 8f43 Ã¤Â¿Â®
    {0x6a, 0x27, 0x4f, 0x47, 0x6a, 0x07, 0x6a, 0x00},   // 24 0729 8f44 Ã¦â€žÂ
    {0x52, 0x7f, 0x04, 0x72, 0x55, 0x76, 0x04, 0x00},   // 24 072a 8f45 Ã¦â€¹Â¾
    {0x75, 0x4c, 0x3f, 0x0c, 0x7f, 0x0c, 0x7f, 0x00},   // 24 072b 8f46 Ã¦Â´Â²
    {0x4a, 0x5a, 0x37, 0x1f, 0x37, 0x6a, 0x0a, 0x00},   // 24 072c 8f47 Ã§Â§â‚¬
    {0x35, 0x7f, 0x4c, 0x20, 0x1f, 0x28, 0x44, 0x00},   // 24 072d 8f48 Ã§Â§â€¹
    {0x2a, 0x75, 0x28, 0x0a, 0x55, 0x4b, 0x08, 0x00},   // 24 072e 8f49 Ã§Âµâ€š
    {0x2a, 0x75, 0x4a, 0x3a, 0x7f, 0x2e, 0x74, 0x00},   // 24 072f 8f4a Ã§Â¹Â
    {0x09, 0x6b, 0x75, 0x6f, 0x6b, 0x65, 0x0f, 0x00},   // 24 0730 8f4b Ã§Â¿â€™
    {0x50, 0x5e, 0x5a, 0x3b, 0x5a, 0x5e, 0x50, 0x00},   // 24 0731 8f4c Ã¨â€¡Â­
    {0x50, 0x3e, 0x12, 0x77, 0x12, 0x7e, 0x10, 0x00},   // 24 0732 8f4d Ã¨Ë†Å¸
    {0x42, 0x5a, 0x3b, 0x1e, 0x7b, 0x5a, 0x62, 0x00},   // 24 0733 8f4e Ã¨â€™Â
    {0x54, 0x2e, 0x06, 0x7f, 0x16, 0x26, 0x54, 0x00},   // 24 0734 8f4f Ã¨Â¡â€ 
    {0x5a, 0x3e, 0x7b, 0x5e, 0x3a, 0x57, 0x5d, 0x00},   // 24 0735 8f50 Ã¨Â¥Â²
    {0x14, 0x7f, 0x5e, 0x5b, 0x54, 0x7f, 0x1a, 0x00},   // 24 0736 8f51 Ã¨Â®Â
    {0x77, 0x7d, 0x2e, 0x7b, 0x2e, 0x3f, 0x45, 0x00},   // 24 0737 8f52 Ã¨Â¹Â´
    {0x2d, 0x7f, 0x24, 0x3f, 0x2d, 0x7f, 0x24, 0x00},   // 24 0738 8f53 Ã¨Â¼Â¯
    {0x49, 0x38, 0x5f, 0x75, 0x6f, 0x75, 0x7f, 0x00},   // 24 0739 8f54 Ã©â‚¬Â±
    {0x02, 0x7a, 0x5f, 0x4a, 0x5e, 0x7b, 0x02, 0x00},   // 24 073a 8f55 Ã©â€¦â€¹
    {0x7d, 0x6f, 0x7d, 0x0c, 0x7f, 0x0c, 0x7f, 0x00},   // 24 073b 8f56 Ã©â€¦Â¬
    {0x54, 0x52, 0x3f, 0x7a, 0x3f, 0x5a, 0x50, 0x00},   // 24 073c 8f57 Ã©â€ºâ€ 
    {0x7d, 0x6f, 0x7d, 0x5e, 0x3f, 0x7a, 0x5e, 0x00},   // 24 073d 8f58 Ã©â€ Å“
    {0x04, 0x7e, 0x05, 0x04, 0x7f, 0x04, 0x04, 0x00},   // 24 073e 8f59 Ã¤Â»â‚¬
    {0x04, 0x7e, 0x01, 0x44, 0x55, 0x7e, 0x54, 0x00},   // 24 073f 8f5a Ã¤Â½Â
    {0x42, 0x4a, 0x3e, 0x0b, 0x76, 0x4a, 0x62, 0x00},   // 24 0740 8f5b Ã¥â€¦â€¦
    {0x04, 0x04, 0x04, 0x7f, 0x04, 0x04, 0x04, 0x00},   // 24 0741 8f5c Ã¥ÂÂ
    {0x0a, 0x7d, 0x42, 0x3b, 0x42, 0x7f, 0x4a, 0x00},   // 24 0742 8f5d Ã¥Â¾â€œ
    {0x52, 0x3a, 0x12, 0x42, 0x5f, 0x22, 0x53, 0x00},   // 24 0743 8f5e Ã¦Ë†Å½
    {0x52, 0x5a, 0x37, 0x7b, 0x3f, 0x52, 0x56, 0x00},   // 24 0744 8f5f Ã¦Å¸â€
    {0x65, 0x10, 0x04, 0x04, 0x7f, 0x04, 0x04, 0x00},   // 24 0745 8f60 Ã¦Â±Â
    {0x75, 0x00, 0x58, 0x2e, 0x08, 0x2f, 0x5a, 0x00},   // 24 0746 8f61 Ã¦Â¸â€¹
    {0x11, 0x77, 0x56, 0x77, 0x44, 0x3f, 0x45, 0x00},   // 24 0747 8f62 Ã§ÂÂ£
    {0x2a, 0x75, 0x0a, 0x7d, 0x23, 0x7e, 0x4b, 0x00},   // 24 0748 8f63 Ã§Â¸Â¦
    {0x42, 0x5e, 0x6b, 0x7f, 0x6b, 0x5e, 0x42, 0x00},   // 24 0749 8f64 Ã©â€¡Â
    {0x56, 0x7d, 0x4a, 0x3e, 0x0b, 0x76, 0x4a, 0x00},   // 24 074a 8f65 Ã©Å Æ’
    {0x28, 0x48, 0x7f, 0x2a, 0x4d, 0x31, 0x4f, 0x00},   // 24 074b 8f66 Ã¥Ââ€
    {0x40, 0x3f, 0x53, 0x2f, 0x1b, 0x7f, 0x40, 0x00},   // 24 074c 8f67 Ã¥Â¤â„¢
    {0x16, 0x7a, 0x02, 0x6b, 0x7a, 0x6a, 0x6e, 0x00},   // 24 074d 8f68 Ã¥Â®Â¿
    {0x75, 0x28, 0x7f, 0x2a, 0x4d, 0x31, 0x4f, 0x00},   // 24 074e 8f69 Ã¦Â·â€˜
    {0x12, 0x7b, 0x16, 0x4f, 0x39, 0x79, 0x4f, 0x00},   // 24 074f 8f6a Ã§Â¥Â
    {0x2a, 0x75, 0x16, 0x7a, 0x0b, 0x7a, 0x6e, 0x00},   // 24 0750 8f6b Ã§Â¸Â®
    {0x48, 0x3a, 0x2a, 0x7f, 0x2a, 0x5e, 0x74, 0x00},   // 24 0751 8f6c Ã§Â²â€º
    {0x52, 0x4e, 0x5b, 0x6e, 0x5f, 0x5e, 0x50, 0x00},   // 24 0752 8f6d Ã¥Â¡Â¾
    {0x52, 0x0e, 0x5b, 0x0e, 0x5f, 0x1e, 0x50, 0x00},   // 24 0753 8f6e Ã§â€ Å¸
    {0x70, 0x4e, 0x48, 0x7f, 0x48, 0x4e, 0x70, 0x00},   // 24 0754 8f6f Ã¥â€¡Âº
    {0x0a, 0x7d, 0x1a, 0x7f, 0x1a, 0x45, 0x7d, 0x00},   // 24 0755 8f70 Ã¨Â¡â€œ
    {0x49, 0x38, 0x5a, 0x42, 0x7f, 0x42, 0x5b, 0x00},   // 24 0756 8f71 Ã¨Â¿Â°
    {0x04, 0x7e, 0x2b, 0x57, 0x32, 0x5e, 0x4b, 0x00},   // 24 0757 8f72 Ã¤Â¿Å 
    {0x38, 0x3f, 0x2a, 0x57, 0x32, 0x5e, 0x4b, 0x00},   // 24 0758 8f73 Ã¥Â³Â»
    {0x28, 0x1a, 0x6e, 0x6f, 0x6e, 0x1a, 0x28, 0x00},   // 24 0759 8f74 Ã¦ËœÂ¥
    {0x7f, 0x55, 0x7f, 0x37, 0x25, 0x77, 0x2d, 0x00},   // 24 075a 8f75 Ã§Å¾Â¬
    {0x2e, 0x33, 0x2e, 0x57, 0x32, 0x5e, 0x4b, 0x00},   // 24 075b 8f76 Ã§Â«Â£
    {0x4d, 0x57, 0x2d, 0x1f, 0x35, 0x77, 0x2d, 0x00},   // 24 075c 8f77 Ã¨Ë†Å“
    {0x5f, 0x1f, 0x75, 0x2a, 0x57, 0x32, 0x4f, 0x00},   // 24 075d 8f78 Ã©Â§Â¿
    {0x61, 0x10, 0x04, 0x7f, 0x4a, 0x7f, 0x4a, 0x00},   // 24 075e 8f79 Ã¥â€¡â€ 
    {0x0a, 0x7d, 0x20, 0x1e, 0x76, 0x7e, 0x75, 0x00},   // 24 075f 8f7a Ã¥Â¾Âª
    {0x04, 0x03, 0x7e, 0x56, 0x7e, 0x02, 0x7e, 0x00},   // 24 0760 8f7b Ã¦â€”Â¬
    {0x1a, 0x7f, 0x20, 0x1e, 0x76, 0x7e, 0x75, 0x00},   // 24 0761 8f7c Ã¦Â¥Â¯
    {0x49, 0x37, 0x1d, 0x7f, 0x56, 0x7e, 0x7e, 0x00},   // 24 0762 8f7d Ã¦Â®â€°
    {0x75, 0x00, 0x22, 0x2e, 0x6b, 0x3e, 0x22, 0x00},   // 24 0763 8f7e Ã¦Â·Â³
    {0x35, 0x20, 0x24, 0x7f, 0x2a, 0x2f, 0x2a, 0x00},   // 25 0764 8f80 Ã¦Âºâ€“
    {0x75, 0x7f, 0x03, 0x57, 0x7c, 0x57, 0x7f, 0x00},   // 25 0765 8f81 Ã¦Â½Â¤
    {0x40, 0x3e, 0x06, 0x76, 0x7e, 0x75, 0x05, 0x00},   // 25 0766 8f82 Ã§â€ºÂ¾
    {0x2a, 0x75, 0x1a, 0x12, 0x7f, 0x52, 0x5a, 0x00},   // 25 0767 8f83 Ã§Â´â€
    {0x49, 0x3c, 0x5b, 0x44, 0x5b, 0x44, 0x5b, 0x00},   // 25 0768 8f84 Ã¥Â·Â¡
    {0x49, 0x3a, 0x5e, 0x57, 0x72, 0x77, 0x5e, 0x00},   // 25 0769 8f85 Ã©ÂÂµ
    {0x7d, 0x6f, 0x7d, 0x22, 0x2e, 0x6b, 0x3e, 0x00},   // 25 076a 8f86 Ã©â€ â€¡
    {0x40, 0x3f, 0x1e, 0x7f, 0x5d, 0x17, 0x5d, 0x00},   // 25 076b 8f87 Ã©Â â€ 
    {0x48, 0x2f, 0x12, 0x2e, 0x42, 0x5e, 0x50, 0x00},   // 25 076c 8f88 Ã¥â€¡Â¦
    {0x12, 0x7b, 0x36, 0x41, 0x3f, 0x41, 0x7f, 0x00},   // 25 076d 8f89 Ã¥Ë†Â
    {0x41, 0x3d, 0x15, 0x5d, 0x3e, 0x0a, 0x79, 0x00},   // 25 076e 8f8a Ã¦â€°â‚¬
    {0x50, 0x57, 0x3d, 0x7d, 0x5d, 0x77, 0x10, 0x00},   // 25 076f 8f8b Ã¦Å¡â€˜
    {0x3e, 0x2a, 0x5f, 0x35, 0x7f, 0x5d, 0x77, 0x00},   // 25 0770 8f8c Ã¦â€ºâ„¢
    {0x75, 0x00, 0x28, 0x1a, 0x6f, 0x6a, 0x69, 0x00},   // 25 0771 8f8d Ã¦Â¸Å¡
    {0x40, 0x3e, 0x4a, 0x1e, 0x5b, 0x1e, 0x4a, 0x00},   // 25 0772 8f8e Ã¥ÂºÂ¶
    {0x2a, 0x75, 0x28, 0x1a, 0x6f, 0x6a, 0x69, 0x00},   // 25 0773 8f8f Ã§Â·â€™
    {0x57, 0x55, 0x3f, 0x7d, 0x5f, 0x75, 0x17, 0x00},   // 25 0774 8f90 Ã§Â½Â²
    {0x28, 0x6a, 0x6a, 0x7f, 0x6a, 0x6e, 0x24, 0x00},   // 25 0775 8f91 Ã¦â€ºÂ¸
    {0x22, 0x6e, 0x3b, 0x7e, 0x7b, 0x6e, 0x2a, 0x00},   // 25 0776 8f92 Ã¨â€“Â¯
    {0x6a, 0x6e, 0x43, 0x2a, 0x7f, 0x6e, 0x6a, 0x00},   // 25 0777 8f93 Ã¨â€”Â·
    {0x6a, 0x63, 0x28, 0x1a, 0x6f, 0x6a, 0x69, 0x00},   // 25 0778 8f94 Ã¨Â«Â¸
    {0x40, 0x7f, 0x55, 0x3f, 0x62, 0x1f, 0x7e, 0x00},   // 25 0779 8f95 Ã¥Å Â©
    {0x54, 0x16, 0x7d, 0x16, 0x4d, 0x31, 0x4f, 0x00},   // 25 077a 8f96 Ã¥Ââ„¢
    {0x44, 0x54, 0x5c, 0x27, 0x34, 0x4c, 0x44, 0x00},   // 25 077b 8f97 Ã¥Â¥Â³
    {0x40, 0x3e, 0x12, 0x56, 0x77, 0x1e, 0x32, 0x00},   // 25 077c 8f98 Ã¥ÂºÂ
    {0x0a, 0x7d, 0x54, 0x16, 0x7d, 0x16, 0x54, 0x00},   // 25 077d 8f99 Ã¥Â¾Â
    {0x6a, 0x2e, 0x4b, 0x46, 0x6f, 0x09, 0x6f, 0x00},   // 25 077e 8f9a Ã¦Ââ€¢
    {0x56, 0x7d, 0x7e, 0x2a, 0x7e, 0x1f, 0x7c, 0x00},   // 25 077f 8f9b Ã©â€¹Â¤
    {0x7f, 0x1b, 0x54, 0x16, 0x7d, 0x16, 0x54, 0x00},   // 25 0780 8f9c Ã©â„¢Â¤
    {0x04, 0x7e, 0x25, 0x5f, 0x3a, 0x5e, 0x72, 0x00},   // 25 0781 8f9d Ã¥â€šÂ·
    {0x04, 0x7e, 0x45, 0x3e, 0x3b, 0x3e, 0x45, 0x00},   // 25 0782 8f9e Ã¥â€žÅ¸
    {0x7f, 0x15, 0x7f, 0x55, 0x3c, 0x5f, 0x75, 0x00},   // 25 0783 8f9f Ã¥â€¹Â
    {0x7f, 0x61, 0x5d, 0x4d, 0x7b, 0x4b, 0x49, 0x00},   // 25 0784 8fa0 Ã¥Å’Â 
    {0x0a, 0x4a, 0x3e, 0x09, 0x08, 0x7f, 0x08, 0x00},   // 25 0785 8fa1 Ã¥Ââ€¡
    {0x09, 0x79, 0x55, 0x53, 0x51, 0x79, 0x0f, 0x00},   // 25 0786 8fa2 Ã¥ÂÂ¬
    {0x1e, 0x12, 0x1e, 0x7d, 0x14, 0x57, 0x7d, 0x00},   // 25 0787 8fa3 Ã¥â€œÂ¨
    {0x7a, 0x2a, 0x1e, 0x6b, 0x7a, 0x2e, 0x7a, 0x00},   // 25 0788 8fa4 Ã¥â€¢â€ 
    {0x1e, 0x12, 0x7e, 0x57, 0x55, 0x57, 0x7c, 0x00},   // 25 0789 8fa5 Ã¥â€Â±
    {0x06, 0x7b, 0x56, 0x57, 0x56, 0x73, 0x16, 0x00},   // 25 078a 8fa6 Ã¥Ëœâ€”
    {0x4a, 0x5f, 0x50, 0x35, 0x57, 0x5d, 0x57, 0x00},   // 25 078b 8fa7 Ã¥Â¥Â¨
    {0x48, 0x5a, 0x7e, 0x5b, 0x3e, 0x5a, 0x48, 0x00},   // 25 078c 8fa8 Ã¥Â¦Â¾
    {0x44, 0x5c, 0x37, 0x7c, 0x57, 0x57, 0x7c, 0x00},   // 25 078d 8fa9 Ã¥Â¨Â¼
    {0x06, 0x7a, 0x2e, 0x2f, 0x2a, 0x7e, 0x06, 0x00},   // 25 078e 8faa Ã¥Â®Âµ
    {0x14, 0x7f, 0x16, 0x32, 0x56, 0x79, 0x15, 0x00},   // 25 078f 8fab Ã¥Â°â€ 
    {0x10, 0x0c, 0x40, 0x7f, 0x00, 0x04, 0x18, 0x00},   // 25 0790 8fac Ã¥Â°Â
    {0x48, 0x46, 0x50, 0x3f, 0x20, 0x12, 0x04, 0x00},   // 25 0791 8fad Ã¥Â°â€˜
    {0x7d, 0x06, 0x74, 0x57, 0x74, 0x06, 0x7d, 0x00},   // 25 0792 8fae Ã¥Â°Å¡
    {0x40, 0x3e, 0x42, 0x4a, 0x7f, 0x4a, 0x42, 0x00},   // 25 0793 8faf Ã¥Âºâ€ž
    {0x40, 0x3e, 0x4a, 0x2a, 0x7f, 0x2a, 0x4a, 0x00},   // 25 0794 8fb0 Ã¥ÂºÅ 
    {0x40, 0x3e, 0x76, 0x3a, 0x77, 0x2e, 0x5a, 0x00},   // 25 0795 8fb1 Ã¥Â»Â 
    {0x2a, 0x3e, 0x7b, 0x3e, 0x2a, 0x4a, 0x25, 0x00},   // 25 0796 8fb2 Ã¥Â½Â°
    {0x24, 0x1c, 0x29, 0x7d, 0x2b, 0x18, 0x24, 0x00},   // 25 0797 8fb3 Ã¦â€°Â¿
    {0x52, 0x7f, 0x08, 0x46, 0x5f, 0x22, 0x14, 0x00},   // 25 0798 8fb4 Ã¦Å â€ž
    {0x52, 0x7f, 0x0a, 0x75, 0x53, 0x59, 0x7f, 0x00},   // 25 0799 8fb5 Ã¦â€¹â€º
    {0x26, 0x33, 0x7e, 0x7b, 0x3e, 0x33, 0x26, 0x00},   // 25 079a 8fb6 Ã¦Å½Å’
    {0x52, 0x7f, 0x40, 0x2a, 0x4a, 0x7f, 0x56, 0x00},   // 25 079b 8fb7 Ã¦ÂÂ·
    {0x10, 0x57, 0x3d, 0x15, 0x7d, 0x17, 0x10, 0x00},   // 25 079c 8fb8 Ã¦Ëœâ€¡
    {0x7c, 0x57, 0x55, 0x55, 0x55, 0x57, 0x7c, 0x00},   // 25 079d 8fb9 Ã¦ËœÅ’
    {0x3e, 0x2a, 0x3e, 0x75, 0x53, 0x59, 0x7f, 0x00},   // 25 079e 8fba Ã¦ËœÂ­
    {0x78, 0x57, 0x7d, 0x05, 0x7d, 0x57, 0x78, 0x00},   // 25 079f 8fbb Ã¦â„¢Â¶
    {0x1a, 0x7f, 0x44, 0x63, 0x58, 0x23, 0x44, 0x00},   // 25 07a0 8fbc Ã¦ÂÂ¾
    {0x1a, 0x7f, 0x0a, 0x7d, 0x14, 0x57, 0x7d, 0x00},   // 25 07a1 8fbd Ã¦Â¢Â¢
    {0x1a, 0x7f, 0x2a, 0x3e, 0x7b, 0x3e, 0x2a, 0x00},   // 25 07a2 8fbe Ã¦Â¨Å¸
    {0x1a, 0x7f, 0x44, 0x1f, 0x52, 0x1f, 0x52, 0x00},   // 25 07a3 8fbf Ã¦Â¨Âµ
    {0x75, 0x00, 0x09, 0x75, 0x53, 0x59, 0x7f, 0x00},   // 25 07a4 8fc0 Ã¦Â²Â¼
    {0x75, 0x00, 0x7d, 0x14, 0x17, 0x54, 0x7d, 0x00},   // 25 07a5 8fc1 Ã¦Â¶Ë†
    {0x75, 0x00, 0x18, 0x4e, 0x58, 0x2f, 0x1a, 0x00},   // 25 07a6 8fc2 Ã¦Â¸â€°
    {0x75, 0x1a, 0x7f, 0x0a, 0x7f, 0x55, 0x7f, 0x00},   // 25 07a7 8fc3 Ã¦Â¹Ëœ
    {0x4c, 0x3f, 0x54, 0x3e, 0x17, 0x7e, 0x54, 0x00},   // 25 07a8 8fc4 Ã§â€žÂ¼
    {0x48, 0x04, 0x5f, 0x16, 0x5f, 0x16, 0x52, 0x00},   // 25 07a9 8fc5 Ã§â€žÂ¦
    {0x5f, 0x15, 0x5f, 0x05, 0x5b, 0x19, 0x5f, 0x00},   // 25 07aa 8fc6 Ã§â€¦Â§
    {0x54, 0x3e, 0x42, 0x76, 0x47, 0x7e, 0x56, 0x00},   // 25 07ab 8fc7 Ã§â€”â€¡
    {0x14, 0x12, 0x78, 0x57, 0x54, 0x7e, 0x04, 0x00},   // 25 07ac 8fc8 Ã§Å“Â
    {0x09, 0x37, 0x31, 0x7d, 0x14, 0x57, 0x7d, 0x00},   // 25 07ad 8fc9 Ã§Â¡Â
    {0x09, 0x37, 0x31, 0x44, 0x1f, 0x5e, 0x53, 0x00},   // 25 07ae 8fca Ã§Â¤Â
    {0x12, 0x7b, 0x16, 0x22, 0x2b, 0x7e, 0x2b, 0x00},   // 25 07af 8fcb Ã§Â¥Â¥
    {0x35, 0x7f, 0x24, 0x5b, 0x7e, 0x0a, 0x32, 0x00},   // 25 07b0 8fcc Ã§Â§Â°
    {0x28, 0x3a, 0x2e, 0x6b, 0x2e, 0x3a, 0x28, 0x00},   // 25 07b1 8fcd Ã§Â«Â 
    {0x54, 0x53, 0x56, 0x3c, 0x53, 0x56, 0x52, 0x00},   // 25 07b2 8fce Ã§Â¬â€˜
    {0x35, 0x7e, 0x55, 0x3e, 0x4a, 0x7f, 0x4a, 0x00},   // 25 07b3 8fcf Ã§Â²Â§
    {0x2a, 0x75, 0x28, 0x75, 0x53, 0x59, 0x7f, 0x00},   // 25 07b4 8fd0 Ã§Â´Â¹
    {0x00, 0x7d, 0x16, 0x17, 0x14, 0x56, 0x7d, 0x00},   // 25 07b5 8fd1 Ã¨â€šâ€“
    {0x72, 0x5e, 0x5b, 0x5a, 0x5b, 0x5e, 0x72, 0x00},   // 25 07b6 8fd2 Ã¨Ââ€“
    {0x2a, 0x7e, 0x17, 0x32, 0x57, 0x7a, 0x16, 0x00},   // 25 07b7 8fd3 Ã¨â€™â€¹
    {0x4a, 0x06, 0x5f, 0x16, 0x5f, 0x16, 0x52, 0x00},   // 25 07b8 8fd4 Ã¨â€¢â€°
    {0x0a, 0x7d, 0x5a, 0x7e, 0x59, 0x05, 0x7d, 0x00},   // 25 07b9 8fd5 Ã¨Â¡Â
    {0x56, 0x33, 0x7e, 0x5b, 0x3e, 0x53, 0x56, 0x00},   // 25 07ba 8fd6 Ã¨Â£Â³
    {0x6a, 0x6b, 0x44, 0x63, 0x58, 0x23, 0x44, 0x00},   // 25 07bb 8fd7 Ã¨Â¨Å¸
    {0x6b, 0x6a, 0x41, 0x79, 0x41, 0x7f, 0x49, 0x00},   // 25 07bc 8fd8 Ã¨Â¨Â¼
    {0x6a, 0x6b, 0x02, 0x75, 0x53, 0x59, 0x7f, 0x00},   // 25 07bd 8fd9 Ã¨Â©â€
    {0x6b, 0x6a, 0x22, 0x2b, 0x7e, 0x2b, 0x22, 0x00},   // 25 07be 8fda Ã¨Â©Â³
    {0x52, 0x52, 0x2d, 0x5d, 0x7f, 0x2c, 0x50, 0x00},   // 25 07bf 8fdb Ã¨Â±Â¡
    {0x46, 0x7b, 0x2e, 0x2b, 0x2e, 0x7b, 0x46, 0x00},   // 25 07c0 8fdc Ã¨Â³Å¾
    {0x0a, 0x7f, 0x59, 0x4b, 0x5d, 0x7f, 0x09, 0x00},   // 25 07c1 8fdd Ã©â€ Â¤
    {0x56, 0x7d, 0x36, 0x79, 0x41, 0x7f, 0x49, 0x00},   // 25 07c2 8fde Ã©â€°Â¦
    {0x56, 0x7d, 0x46, 0x5e, 0x7e, 0x5d, 0x44, 0x00},   // 25 07c3 8fdf Ã©ÂÂ¾
    {0x56, 0x7d, 0x4a, 0x5e, 0x7b, 0x5e, 0x4a, 0x00},   // 25 07c4 8fe0 Ã©ÂËœ
    {0x7f, 0x1b, 0x2a, 0x3e, 0x7b, 0x3e, 0x2a, 0x00},   // 25 07c5 8fe1 Ã©Å¡Å“
    {0x37, 0x7e, 0x37, 0x7d, 0x14, 0x57, 0x7d, 0x00},   // 25 07c6 8fe2 Ã©Å¾Ëœ
    {0x40, 0x40, 0x40, 0x7f, 0x44, 0x44, 0x40, 0x00},   // 25 07c7 8fe3 Ã¤Â¸Å 
    {0x42, 0x42, 0x2a, 0x1f, 0x22, 0x42, 0x42, 0x00},   // 25 07c8 8fe4 Ã¤Â¸Ë†
    {0x54, 0x4d, 0x61, 0x7d, 0x43, 0x49, 0x54, 0x00},   // 25 07c9 8fe5 Ã¤Â¸Å¾
    {0x4a, 0x5e, 0x2b, 0x7f, 0x2b, 0x5e, 0x4a, 0x00},   // 25 07ca 8fe6 Ã¤Â¹â€”
    {0x43, 0x21, 0x1d, 0x05, 0x7d, 0x41, 0x63, 0x00},   // 25 07cb 8fe7 Ã¥â€ â€”
    {0x5e, 0x2b, 0x7f, 0x2b, 0x5e, 0x00, 0x7f, 0x00},   // 25 07cc 8fe8 Ã¥â€°Â°
    {0x24, 0x3f, 0x7e, 0x2a, 0x5a, 0x3f, 0x52, 0x00},   // 25 07cd 8fe9 Ã¥Å¸Å½
    {0x24, 0x3f, 0x24, 0x5f, 0x35, 0x57, 0x74, 0x00},   // 25 07ce 8fea Ã¥Â Â´
    {0x24, 0x3f, 0x1a, 0x7e, 0x53, 0x3e, 0x5a, 0x00},   // 25 07cf 8feb Ã¥Â£Å’
    {0x5f, 0x3c, 0x1a, 0x7e, 0x53, 0x3e, 0x5a, 0x00},   // 25 07d0 8fec Ã¥Â¬Â¢
    {0x06, 0x33, 0x1e, 0x7b, 0x1e, 0x33, 0x06, 0x00},   // 25 07d1 8fed Ã¥Â¸Â¸
    {0x06, 0x7f, 0x08, 0x7a, 0x2f, 0x7a, 0x08, 0x00},   // 25 07d2 8fee Ã¦Æ’â€¦
    {0x52, 0x7f, 0x59, 0x5f, 0x2f, 0x5f, 0x59, 0x00},   // 25 07d3 8fef Ã¦â€œÂ¾
    {0x48, 0x5a, 0x3a, 0x75, 0x3b, 0x58, 0x48, 0x00},   // 25 07d4 8ff0 Ã¦ÂÂ¡
    {0x1a, 0x7f, 0x42, 0x2a, 0x1f, 0x22, 0x42, 0x00},   // 25 07d5 8ff1 Ã¦Ââ€“
    {0x75, 0x00, 0x2a, 0x6d, 0x7d, 0x2f, 0x3c, 0x00},   // 25 07d6 8ff2 Ã¦Âµâ€ž
    {0x14, 0x7f, 0x44, 0x24, 0x1f, 0x24, 0x45, 0x00},   // 25 07d7 8ff3 Ã§Å Â¶
    {0x58, 0x4f, 0x7d, 0x5f, 0x7d, 0x4f, 0x58, 0x00},   // 25 07d8 8ff4 Ã§â€¢Â³
    {0x35, 0x7f, 0x1a, 0x7e, 0x53, 0x3e, 0x5a, 0x00},   // 25 07d9 8ff5 Ã§Â©Â£
    {0x6a, 0x3a, 0x67, 0x3e, 0x63, 0x2a, 0x76, 0x00},   // 25 07da 8ff6 Ã¨â€™Â¸
    {0x6b, 0x62, 0x1a, 0x7e, 0x53, 0x3e, 0x5a, 0x00},   // 25 07db 8ff7 Ã¨Â­Â²
    {0x7d, 0x7f, 0x1a, 0x7e, 0x53, 0x3e, 0x5a, 0x00},   // 25 07dc 8ff8 Ã©â€ Â¸
    {0x56, 0x7d, 0x46, 0x32, 0x47, 0x7e, 0x56, 0x00},   // 25 07dd 8ff9 Ã©Å’Â 
    {0x1e, 0x52, 0x3f, 0x73, 0x5b, 0x3f, 0x73, 0x00},   // 25 07de 8ffa Ã¥ËœÂ±
    {0x24, 0x3f, 0x7a, 0x42, 0x5f, 0x5a, 0x42, 0x00},   // 25 07df 8ffb Ã¥Å¸Â´
    {0x7a, 0x5d, 0x5a, 0x34, 0x13, 0x7e, 0x32, 0x00},   // 25 07e0 8ffc Ã©Â£Â¾
    {0x52, 0x7f, 0x54, 0x74, 0x57, 0x3c, 0x45, 0x00},   // 26 07e1 9040 Ã¦â€¹Â­
    {0x1a, 0x7f, 0x7a, 0x42, 0x5f, 0x5a, 0x42, 0x00},   // 26 07e2 9041 Ã¦Â¤Â
    {0x49, 0x37, 0x1d, 0x7a, 0x42, 0x5f, 0x5a, 0x00},   // 26 07e3 9042 Ã¦Â®â€“
    {0x4c, 0x3f, 0x4b, 0x75, 0x77, 0x25, 0x7f, 0x00},   // 26 07e4 9043 Ã§â€¡Â­
    {0x2a, 0x75, 0x0a, 0x6f, 0x6e, 0x3f, 0x55, 0x00},   // 26 07e5 9044 Ã§Â¹â€
    {0x21, 0x3f, 0x7f, 0x6b, 0x4e, 0x3f, 0x55, 0x00},   // 26 07e6 9045 Ã¨ÂÂ·
    {0x02, 0x3e, 0x55, 0x5d, 0x57, 0x5c, 0x60, 0x00},   // 26 07e7 9046 Ã¨â€°Â²
    {0x42, 0x3d, 0x7f, 0x4a, 0x7f, 0x4a, 0x6e, 0x00},   // 26 07e8 9047 Ã¨Â§Â¦
    {0x04, 0x44, 0x7a, 0x5d, 0x22, 0x54, 0x44, 0x00},   // 26 07e9 9048 Ã©Â£Å¸
    {0x7a, 0x5d, 0x5a, 0x4e, 0x7f, 0x4a, 0x6e, 0x00},   // 26 07ea 9049 Ã¨Ââ€¢
    {0x18, 0x17, 0x3d, 0x57, 0x7f, 0x17, 0x15, 0x00},   // 26 07eb 904a Ã¨Â¾Â±
    {0x40, 0x3f, 0x55, 0x35, 0x1d, 0x75, 0x47, 0x00},   // 26 07ec 904b Ã¥Â°Â»
    {0x04, 0x7e, 0x3f, 0x2a, 0x7f, 0x2a, 0x3e, 0x00},   // 26 07ed 904c Ã¤Â¼Â¸
    {0x04, 0x7e, 0x01, 0x62, 0x6b, 0x6b, 0x62, 0x00},   // 26 07ee 904d Ã¤Â¿Â¡
    {0x04, 0x7e, 0x59, 0x5d, 0x2d, 0x5f, 0x58, 0x00},   // 26 07ef 904e Ã¤Â¾Âµ
    {0x10, 0x0f, 0x7d, 0x77, 0x6f, 0x77, 0x15, 0x00},   // 26 07f0 904f Ã¥â€â€¡
    {0x5c, 0x37, 0x2c, 0x7f, 0x51, 0x35, 0x55, 0x00},   // 26 07f1 9050 Ã¥Â¨Â 
    {0x2e, 0x7a, 0x02, 0x5b, 0x5e, 0x2a, 0x5e, 0x00},   // 26 07f2 9051 Ã¥Â¯Â
    {0x56, 0x3a, 0x76, 0x7f, 0x76, 0x3a, 0x56, 0x00},   // 26 07f3 9052 Ã¥Â¯Â©
    {0x20, 0x18, 0x7d, 0x42, 0x40, 0x68, 0x10, 0x00},   // 26 07f4 9053 Ã¥Â¿Æ’
    {0x06, 0x7f, 0x52, 0x1e, 0x1f, 0x1e, 0x52, 0x00},   // 26 07f5 9054 Ã¦â€¦Å½
    {0x52, 0x7f, 0x3f, 0x71, 0x55, 0x35, 0x51, 0x00},   // 26 07f6 9055 Ã¦Å’Â¯
    {0x52, 0x36, 0x7b, 0x36, 0x5e, 0x0a, 0x79, 0x00},   // 26 07f7 9056 Ã¦â€“Â°
    {0x09, 0x7b, 0x5f, 0x59, 0x5f, 0x7b, 0x09, 0x00},   // 26 07f8 9057 Ã¦â„¢â€¹
    {0x50, 0x3a, 0x76, 0x5f, 0x36, 0x7a, 0x50, 0x00},   // 26 07f9 9058 Ã¦Â£Â®
    {0x1a, 0x7f, 0x52, 0x2a, 0x77, 0x2a, 0x52, 0x00},   // 26 07fa 9059 Ã¦Â¦â€º
    {0x75, 0x00, 0x58, 0x5d, 0x2d, 0x5f, 0x58, 0x00},   // 26 07fb 905a Ã¦ÂµÂ¸
    {0x75, 0x00, 0x5b, 0x35, 0x71, 0x3d, 0x5b, 0x00},   // 26 07fc 905b Ã¦Â·Â±
    {0x3e, 0x2a, 0x2a, 0x7f, 0x2a, 0x2a, 0x3e, 0x00},   // 26 07fd 905c Ã§â€Â³
    {0x54, 0x3e, 0x12, 0x4a, 0x57, 0x2a, 0x12, 0x00},   // 26 07fe 905d Ã§â€“Â¹
    {0x52, 0x52, 0x1e, 0x1f, 0x1e, 0x52, 0x52, 0x00},   // 26 07ff 905e Ã§Å“Å¸
    {0x12, 0x7b, 0x3e, 0x2a, 0x7f, 0x2a, 0x3e, 0x00},   // 26 0800 905f Ã§Â¥Å¾
    {0x48, 0x5a, 0x2e, 0x7f, 0x2e, 0x5a, 0x48, 0x00},   // 26 0801 9060 Ã§Â§Â¦
    {0x2a, 0x75, 0x3e, 0x2a, 0x7f, 0x2a, 0x3e, 0x00},   // 26 0802 9061 Ã§Â´Â³
    {0x00, 0x7f, 0x55, 0x77, 0x55, 0x5d, 0x41, 0x00},   // 26 0803 9062 Ã¨â€¡Â£
    {0x42, 0x32, 0x7f, 0x42, 0x67, 0x12, 0x62, 0x00},   // 26 0804 9063 Ã¨Å Â¯
    {0x52, 0x36, 0x7b, 0x36, 0x3f, 0x16, 0x72, 0x00},   // 26 0805 9064 Ã¨â€“Âª
    {0x52, 0x36, 0x7b, 0x36, 0x5f, 0x35, 0x5f, 0x00},   // 26 0806 9065 Ã¨Â¦Âª
    {0x6a, 0x6b, 0x04, 0x42, 0x55, 0x2a, 0x14, 0x00},   // 26 0807 9066 Ã¨Â¨Âº
    {0x10, 0x50, 0x5e, 0x2b, 0x6a, 0x7e, 0x08, 0x00},   // 26 0808 9067 Ã¨ÂºÂ«
    {0x08, 0x2a, 0x2e, 0x7b, 0x2e, 0x2a, 0x08, 0x00},   // 26 0809 9068 Ã¨Â¾â€º
    {0x49, 0x38, 0x44, 0x7f, 0x6a, 0x7f, 0x6a, 0x00},   // 26 080a 9069 Ã©â‚¬Â²
    {0x56, 0x7d, 0x36, 0x04, 0x7f, 0x04, 0x04, 0x00},   // 26 080b 906a Ã©â€¡Â
    {0x46, 0x3a, 0x7f, 0x5f, 0x3b, 0x5e, 0x56, 0x00},   // 26 080c 906b Ã©Å“â€¡
    {0x40, 0x20, 0x18, 0x07, 0x18, 0x20, 0x40, 0x00},   // 26 080d 906c Ã¤ÂºÂº
    {0x04, 0x7e, 0x21, 0x22, 0x22, 0x22, 0x20, 0x00},   // 26 080e 906d Ã¤Â»Â
    {0x41, 0x29, 0x19, 0x0f, 0x11, 0x41, 0x7f, 0x00},   // 26 080f 906e Ã¥Ë†Æ’
    {0x40, 0x3e, 0x5a, 0x56, 0x67, 0x5e, 0x52, 0x00},   // 26 0810 906f Ã¥Â¡Âµ
    {0x08, 0x4a, 0x4a, 0x7e, 0x49, 0x49, 0x08, 0x00},   // 26 0811 9070 Ã¥Â£Â¬
    {0x14, 0x1d, 0x35, 0x51, 0x7d, 0x17, 0x1c, 0x00},   // 26 0812 9071 Ã¥Â°â€¹
    {0x12, 0x72, 0x5f, 0x7a, 0x5f, 0x72, 0x52, 0x00},   // 26 0813 9072 Ã§â€Å¡
    {0x20, 0x1f, 0x25, 0x2d, 0x45, 0x1b, 0x20, 0x00},   // 26 0814 9073 Ã¥Â°Â½
    {0x07, 0x77, 0x35, 0x30, 0x3b, 0x75, 0x0b, 0x00},   // 26 0815 9074 Ã¨â€¦Å½
    {0x6b, 0x62, 0x49, 0x3f, 0x05, 0x7f, 0x40, 0x00},   // 26 0816 9075 Ã¨Â¨Å 
    {0x49, 0x38, 0x45, 0x5f, 0x45, 0x4f, 0x50, 0x00},   // 26 0817 9076 Ã¨Â¿â€¦
    {0x7f, 0x1b, 0x22, 0x3e, 0x7f, 0x3e, 0x22, 0x00},   // 26 0818 9077 Ã©â„¢Â£
    {0x37, 0x7e, 0x37, 0x49, 0x3f, 0x51, 0x7f, 0x00},   // 26 0819 9078 Ã©ÂÂ­
    {0x04, 0x6b, 0x6e, 0x6c, 0x0b, 0x4e, 0x7a, 0x00},   // 26 081a 9079 Ã§Â¬Â¥
    {0x6b, 0x6a, 0x21, 0x3f, 0x7f, 0x12, 0x2e, 0x00},   // 26 081b 907a Ã¨Â«Â
    {0x4a, 0x25, 0x00, 0x5d, 0x17, 0x15, 0x5d, 0x00},   // 26 081c 907b Ã©Â Ë†
    {0x7d, 0x6f, 0x7d, 0x04, 0x7f, 0x2a, 0x2a, 0x00},   // 26 081d 907c Ã©â€¦Â¢
    {0x7f, 0x43, 0x69, 0x53, 0x59, 0x65, 0x7f, 0x00},   // 26 081e 907d Ã¥â€ºÂ³
    {0x40, 0x3f, 0x5d, 0x75, 0x2d, 0x49, 0x7d, 0x00},   // 26 081f 907e Ã¥Å½Â¨
    {0x49, 0x3a, 0x41, 0x6f, 0x7b, 0x7b, 0x6f, 0x00},   // 27 0820 9080 Ã©â‚¬â€”
    {0x1e, 0x1e, 0x44, 0x23, 0x1e, 0x22, 0x46, 0x00},   // 27 0821 9081 Ã¥ÂÂ¹
    {0x54, 0x5e, 0x56, 0x7e, 0x55, 0x5d, 0x54, 0x00},   // 27 0822 9082 Ã¥Å¾â€š
    {0x3e, 0x37, 0x3e, 0x02, 0x7f, 0x02, 0x3e, 0x00},   // 27 0823 9083 Ã¥Â¸Â¥
    {0x52, 0x7f, 0x04, 0x7f, 0x4a, 0x7f, 0x4a, 0x00},   // 27 0824 9084 Ã¦Å½Â¨
    {0x24, 0x14, 0x4c, 0x7f, 0x08, 0x14, 0x22, 0x00},   // 27 0825 9085 Ã¦Â°Â´
    {0x4c, 0x3f, 0x44, 0x23, 0x1e, 0x22, 0x46, 0x00},   // 27 0826 9086 Ã§â€šÅ 
    {0x7f, 0x55, 0x7f, 0x14, 0x5d, 0x7f, 0x55, 0x00},   // 27 0827 9087 Ã§ÂÂ¡
    {0x35, 0x7e, 0x2b, 0x26, 0x73, 0x2e, 0x28, 0x00},   // 27 0828 9088 Ã§Â²â€¹
    {0x29, 0x3b, 0x2d, 0x7f, 0x2b, 0x3d, 0x2f, 0x00},   // 27 0829 9089 Ã§Â¿Â 
    {0x2a, 0x2a, 0x7e, 0x57, 0x3e, 0x4a, 0x4a, 0x00},   // 27 082a 908a Ã¨Â¡Â°
    {0x49, 0x38, 0x52, 0x6b, 0x7e, 0x53, 0x6a, 0x00},   // 27 082b 908b Ã©Ââ€š
    {0x7d, 0x6f, 0x7d, 0x2a, 0x77, 0x2e, 0x28, 0x00},   // 27 082c 908c Ã©â€¦â€
    {0x56, 0x7d, 0x36, 0x7f, 0x4a, 0x7f, 0x4a, 0x00},   // 27 082d 908d Ã©Å’Â
    {0x56, 0x7d, 0x56, 0x5d, 0x77, 0x5d, 0x54, 0x00},   // 27 082e 908e Ã©Å’Ëœ
    {0x7f, 0x25, 0x5b, 0x39, 0x4a, 0x77, 0x72, 0x00},   // 27 082f 908f Ã©Å¡Â
    {0x2a, 0x3e, 0x6b, 0x3a, 0x6b, 0x2a, 0x6b, 0x00},   // 27 0830 9090 Ã§â€˜Å¾
    {0x0c, 0x77, 0x3f, 0x79, 0x4a, 0x77, 0x72, 0x00},   // 27 0831 9091 Ã©Â«â€ž
    {0x4c, 0x37, 0x5e, 0x7f, 0x1e, 0x37, 0x4c, 0x00},   // 27 0832 9092 Ã¥Â´â€¡
    {0x74, 0x17, 0x7e, 0x57, 0x7e, 0x17, 0x74, 0x00},   // 27 0833 9093 Ã¥ÂµÂ©
    {0x55, 0x7a, 0x57, 0x32, 0x5d, 0x23, 0x5e, 0x00},   // 27 0834 9094 Ã¦â€¢Â°
    {0x1a, 0x7f, 0x0a, 0x7f, 0x55, 0x49, 0x55, 0x00},   // 27 0835 9095 Ã¦Å¾Â¢
    {0x6a, 0x3f, 0x4a, 0x64, 0x5b, 0x76, 0x76, 0x00},   // 27 0836 9096 Ã¨Â¶Â¨
    {0x24, 0x5b, 0x36, 0x36, 0x7f, 0x7e, 0x4b, 0x00},   // 27 0837 9097 Ã©â€ºâ€º
    {0x52, 0x7f, 0x4a, 0x3f, 0x6b, 0x5f, 0x6b, 0x00},   // 27 0838 9098 Ã¦ÂÂ®
    {0x22, 0x1a, 0x7f, 0x0a, 0x40, 0x4a, 0x25, 0x00},   // 27 0839 9099 Ã¦Ââ€°
    {0x1a, 0x7f, 0x7c, 0x57, 0x55, 0x57, 0x7c, 0x00},   // 27 083a 909a Ã¦Â¤â„¢
    {0x1a, 0x0a, 0x7f, 0x7a, 0x6f, 0x6a, 0x1a, 0x00},   // 27 083b 909b Ã¨Ââ€¦
    {0x7e, 0x5a, 0x2f, 0x5a, 0x5d, 0x17, 0x5d, 0x00},   // 27 083c 909c Ã©Â â€”
    {0x14, 0x12, 0x78, 0x57, 0x7c, 0x56, 0x54, 0x00},   // 27 083d 909d Ã©â€ºâ‚¬
    {0x12, 0x7b, 0x56, 0x3f, 0x6b, 0x5f, 0x6b, 0x00},   // 27 083e 909e Ã¨Â£Â¾
    {0x65, 0x10, 0x45, 0x5b, 0x69, 0x5a, 0x45, 0x00},   // 27 083f 909f Ã¦Â¾â€ž
    {0x52, 0x7f, 0x05, 0x6f, 0x70, 0x65, 0x0f, 0x00},   // 27 0840 90a0 Ã¦â€˜Âº
    {0x02, 0x02, 0x0a, 0x52, 0x7f, 0x02, 0x02, 0x00},   // 27 0841 90a1 Ã¥Â¯Â¸
    {0x04, 0x7f, 0x44, 0x5f, 0x54, 0x5f, 0x44, 0x00},   // 27 0842 90a2 Ã¤Â¸â€“
    {0x75, 0x2e, 0x7f, 0x2e, 0x5d, 0x17, 0x5d, 0x00},   // 27 0843 90a3 Ã§â‚¬Â¬
    {0x7a, 0x7a, 0x7b, 0x7a, 0x44, 0x33, 0x4e, 0x00},   // 27 0844 90a4 Ã§â€¢Â
    {0x44, 0x37, 0x45, 0x7d, 0x55, 0x57, 0x44, 0x00},   // 27 0845 90a5 Ã¦ËœÂ¯
    {0x71, 0x00, 0x52, 0x7a, 0x5f, 0x3e, 0x52, 0x00},   // 27 0846 90a6 Ã¥â€¡â€ž
    {0x64, 0x2b, 0x7f, 0x2a, 0x6e, 0x00, 0x7f, 0x00},   // 27 0847 90a7 Ã¥Ë†Â¶
    {0x14, 0x4e, 0x5f, 0x3a, 0x57, 0x7e, 0x08, 0x00},   // 27 0848 90a8 Ã¥â€¹Â¢
    {0x44, 0x5c, 0x37, 0x4c, 0x53, 0x7f, 0x52, 0x00},   // 27 0849 90a9 Ã¥Â§â€œ
    {0x0a, 0x7d, 0x40, 0x79, 0x41, 0x7f, 0x49, 0x00},   // 27 084a 90aa Ã¥Â¾Â
    {0x06, 0x7f, 0x44, 0x53, 0x7f, 0x52, 0x42, 0x00},   // 27 084b 90ab Ã¦â‚¬Â§
    {0x40, 0x3e, 0x4a, 0x3a, 0x42, 0x3f, 0x52, 0x00},   // 27 084c 90ac Ã¦Ë†Â
    {0x79, 0x41, 0x3f, 0x29, 0x5c, 0x23, 0x5e, 0x00},   // 27 084d 90ad Ã¦â€Â¿
    {0x5a, 0x76, 0x5f, 0x76, 0x7a, 0x75, 0x5b, 0x00},   // 27 084e 90ae Ã¦â€¢Â´
    {0x50, 0x4f, 0x55, 0x7d, 0x55, 0x57, 0x44, 0x00},   // 27 084f 90af Ã¦ËœÅ¸
    {0x3e, 0x2a, 0x3e, 0x08, 0x7a, 0x2f, 0x7a, 0x00},   // 27 0850 90b0 Ã¦â„¢Â´
    {0x1a, 0x7f, 0x52, 0x7a, 0x5f, 0x3e, 0x52, 0x00},   // 27 0851 90b1 Ã¦Â£Â²
    {0x1a, 0x7f, 0x7d, 0x5f, 0x45, 0x5f, 0x7d, 0x00},   // 27 0852 90b2 Ã¦Â â€“
    {0x41, 0x79, 0x41, 0x7f, 0x49, 0x49, 0x41, 0x00},   // 27 0853 90b3 Ã¦Â­Â£
    {0x75, 0x00, 0x08, 0x7a, 0x2f, 0x7a, 0x08, 0x00},   // 27 0854 90b4 Ã¦Â¸â€¦
    {0x17, 0x7f, 0x44, 0x53, 0x7f, 0x52, 0x42, 0x00},   // 27 0855 90b5 Ã§â€°Â²
    {0x44, 0x53, 0x52, 0x7f, 0x52, 0x52, 0x42, 0x00},   // 27 0856 90b6 Ã§â€Å¸
    {0x48, 0x76, 0x5e, 0x72, 0x5a, 0x77, 0x4a, 0x00},   // 27 0857 90b7 Ã§â€ºâ€º
    {0x35, 0x7e, 0x09, 0x7a, 0x2f, 0x7a, 0x08, 0x00},   // 27 0858 90b8 Ã§Â²Â¾
    {0x45, 0x57, 0x57, 0x7d, 0x57, 0x55, 0x47, 0x00},   // 27 0859 90b9 Ã¨Ââ€“
    {0x42, 0x3a, 0x2a, 0x3f, 0x2a, 0x3a, 0x02, 0x00},   // 27 085a 90ba Ã¥Â£Â°
    {0x54, 0x3b, 0x7f, 0x5a, 0x36, 0x50, 0x5f, 0x00},   // 27 085b 90bb Ã¨Â£Â½
    {0x7d, 0x55, 0x4f, 0x45, 0x5f, 0x55, 0x7d, 0x00},   // 27 085c 90bc Ã¨Â¥Â¿
    {0x6b, 0x62, 0x7e, 0x2a, 0x5a, 0x3f, 0x52, 0x00},   // 27 085d 90bd Ã¨ÂªÂ 
    {0x2a, 0x3f, 0x70, 0x6e, 0x66, 0x3d, 0x24, 0x00},   // 27 085e 90be Ã¨Âªâ€œ
    {0x6a, 0x63, 0x08, 0x7a, 0x2f, 0x7a, 0x08, 0x00},   // 27 085f 90bf Ã¨Â«â€¹
    {0x49, 0x38, 0x52, 0x7f, 0x52, 0x4e, 0x7d, 0x00},   // 27 0860 90c0 Ã©â‚¬Â
    {0x7d, 0x6f, 0x7d, 0x48, 0x57, 0x7d, 0x57, 0x00},   // 27 0861 90c1 Ã©â€ â€™
    {0x08, 0x7a, 0x2a, 0x2f, 0x2a, 0x7a, 0x08, 0x00},   // 27 0862 90c2 Ã©Ââ€™
    {0x08, 0x7a, 0x2f, 0x7a, 0x2a, 0x7d, 0x3b, 0x00},   // 27 0863 90c3 Ã©Ââ„¢
    {0x12, 0x52, 0x36, 0x2b, 0x76, 0x12, 0x12, 0x00},   // 27 0864 90c4 Ã¦â€“â€°
    {0x35, 0x7f, 0x4e, 0x3b, 0x0a, 0x7b, 0x4e, 0x00},   // 27 0865 90c5 Ã§Â¨Å½
    {0x7f, 0x15, 0x7f, 0x3e, 0x7d, 0x4f, 0x5c, 0x00},   // 27 0866 90c6 Ã¨â€žâ€ 
    {0x48, 0x44, 0x5f, 0x2a, 0x5f, 0x4a, 0x4a, 0x00},   // 27 0867 90c7 Ã©Å¡Â»
    {0x40, 0x3e, 0x6a, 0x2e, 0x7b, 0x2e, 0x6a, 0x00},   // 27 0868 90c8 Ã¥Â¸Â­
    {0x06, 0x7f, 0x0a, 0x7f, 0x5a, 0x7f, 0x0a, 0x00},   // 27 0869 90c9 Ã¦Æ’Å“
    {0x40, 0x3e, 0x22, 0x7e, 0x2a, 0x3f, 0x52, 0x00},   // 27 086a 90ca Ã¦Ë†Å¡
    {0x40, 0x3e, 0x0a, 0x1a, 0x79, 0x29, 0x08, 0x00},   // 27 086b 90cb Ã¦â€“Â¥
    {0x08, 0x7a, 0x5f, 0x5a, 0x5f, 0x7a, 0x08, 0x00},   // 27 086c 90cc Ã¦Ëœâ€
    {0x1a, 0x7f, 0x40, 0x3e, 0x0a, 0x79, 0x08, 0x00},   // 27 086d 90cd Ã¦Å¾Â
    {0x11, 0x09, 0x7f, 0x49, 0x49, 0x79, 0x01, 0x00},   // 27 086e 90ce Ã§Å¸Â³
    {0x35, 0x7f, 0x48, 0x3a, 0x3f, 0x3a, 0x48, 0x00},   // 27 086f 90cf Ã§Â©Â
    {0x54, 0x33, 0x7e, 0x34, 0x1b, 0x7e, 0x6a, 0x00},   // 27 0870 90d0 Ã§Â±Â
    {0x2a, 0x75, 0x48, 0x3a, 0x3f, 0x3a, 0x48, 0x00},   // 27 0871 90d1 Ã§Â¸Â¾
    {0x15, 0x75, 0x28, 0x2f, 0x28, 0x75, 0x15, 0x00},   // 27 0872 90d2 Ã¨â€žÅ 
    {0x48, 0x7a, 0x2a, 0x2f, 0x2a, 0x7a, 0x48, 0x00},   // 27 0873 90d3 Ã¨Â²Â¬
    {0x28, 0x4a, 0x3a, 0x4f, 0x7a, 0x0a, 0x28, 0x00},   // 27 0874 90d4 Ã¨ÂµÂ¤
    {0x77, 0x7d, 0x5b, 0x3e, 0x43, 0x7e, 0x1a, 0x00},   // 27 0875 90d5 Ã¨Â·Â¡
    {0x77, 0x7d, 0x4b, 0x3a, 0x3f, 0x3a, 0x48, 0x00},   // 27 0876 90d6 Ã¨Â¹Å¸
    {0x09, 0x37, 0x31, 0x5d, 0x17, 0x15, 0x5d, 0x00},   // 27 0877 90d7 Ã§Â¢Â©
    {0x04, 0x3f, 0x24, 0x41, 0x3f, 0x41, 0x7f, 0x00},   // 27 0878 90d8 Ã¥Ë†â€¡
    {0x52, 0x7f, 0x76, 0x44, 0x7f, 0x44, 0x76, 0x00},   // 27 0879 90d9 Ã¦â€¹â„¢
    {0x52, 0x7f, 0x4a, 0x5e, 0x2b, 0x3e, 0x4a, 0x00},   // 27 087a 90da Ã¦Å½Â¥
    {0x52, 0x7f, 0x59, 0x2f, 0x09, 0x2f, 0x59, 0x00},   // 27 087b 90db Ã¦â€˜â€š
    {0x52, 0x7f, 0x40, 0x3e, 0x0a, 0x79, 0x08, 0x00},   // 27 087c 90dc Ã¦Å Ëœ
    {0x6a, 0x6b, 0x44, 0x5b, 0x29, 0x5f, 0x44, 0x00},   // 27 087d 90dd Ã¨Â¨Â­
    {0x16, 0x7a, 0x56, 0x03, 0x5e, 0x3a, 0x76, 0x00},   // 27 087e 90de Ã§ÂªÆ’
    {0x7c, 0x5b, 0x5e, 0x24, 0x7b, 0x0e, 0x3a, 0x00},   // 27 087f 90df Ã§Â¯â‚¬
    {0x6b, 0x62, 0x4e, 0x3b, 0x0a, 0x7b, 0x4e, 0x00},   // 27 0880 90e0 Ã¨ÂªÂ¬
    {0x06, 0x52, 0x57, 0x57, 0x53, 0x76, 0x06, 0x00},   // 27 0881 90e1 Ã©â€ºÂª
    {0x2a, 0x75, 0x2a, 0x7e, 0x5d, 0x57, 0x5c, 0x00},   // 27 0882 90e2 Ã§ÂµÂ¶
    {0x04, 0x76, 0x56, 0x5e, 0x55, 0x75, 0x04, 0x00},   // 27 0883 90e3 Ã¨Ë†Å’
    {0x4e, 0x7b, 0x2d, 0x2c, 0x7d, 0x2e, 0x2d, 0x00},   // 27 0884 90e4 Ã¨Ââ€°
    {0x04, 0x7e, 0x7d, 0x40, 0x7f, 0x40, 0x7c, 0x00},   // 27 0885 90e5 Ã¤Â»â„¢
    {0x4c, 0x4b, 0x3a, 0x0f, 0x7a, 0x4a, 0x68, 0x00},   // 27 0886 90e6 Ã¥â€¦Ë†
    {0x08, 0x0a, 0x0a, 0x7e, 0x09, 0x09, 0x08, 0x00},   // 27 0887 90e7 Ã¥ÂÆ’
    {0x00, 0x70, 0x50, 0x5f, 0x54, 0x54, 0x74, 0x00},   // 27 0888 90e8 Ã¥ÂÂ 
    {0x46, 0x42, 0x76, 0x57, 0x76, 0x42, 0x46, 0x00},   // 27 0889 90e9 Ã¥Â®Â£
    {0x12, 0x12, 0x3e, 0x5f, 0x7e, 0x12, 0x12, 0x00},   // 27 088a 90ea Ã¥Â°â€š
    {0x54, 0x52, 0x58, 0x3f, 0x50, 0x52, 0x54, 0x00},   // 27 088b 90eb Ã¥Â°â€“
    {0x40, 0x3f, 0x00, 0x1e, 0x00, 0x00, 0x7f, 0x00},   // 27 088c 90ec Ã¥Â·Â
    {0x2d, 0x2c, 0x7d, 0x2c, 0x47, 0x3c, 0x55, 0x00},   // 27 088d 90ed Ã¦Ë†Â¦
    {0x41, 0x3f, 0x5b, 0x2b, 0x7b, 0x2b, 0x79, 0x00},   // 27 088e 90ee Ã¦â€°â€¡
    {0x52, 0x7f, 0x4d, 0x1b, 0x10, 0x1d, 0x4b, 0x00},   // 27 088f 90ef Ã¦â€™Â°
    {0x1a, 0x7f, 0x44, 0x56, 0x7d, 0x56, 0x44, 0x00},   // 27 0890 90f0 Ã¦Â â€œ
    {0x1a, 0x7f, 0x24, 0x7b, 0x2a, 0x7a, 0x22, 0x00},   // 27 0891 90f1 Ã¦Â Â´
    {0x50, 0x3e, 0x4a, 0x7b, 0x1a, 0x2e, 0x50, 0x00},   // 27 0892 90f2 Ã¦Â³â€°
    {0x75, 0x00, 0x0a, 0x4a, 0x5f, 0x2a, 0x53, 0x00},   // 27 0893 90f3 Ã¦Âµâ€¦
    {0x75, 0x00, 0x4c, 0x3b, 0x0f, 0x7a, 0x4a, 0x00},   // 27 0894 90f4 Ã¦Â´â€”
    {0x55, 0x50, 0x3a, 0x76, 0x33, 0x5e, 0x58, 0x00},   // 27 0895 90f5 Ã¦Å¸â€œ
    {0x75, 0x00, 0x0a, 0x77, 0x5a, 0x77, 0x0a, 0x00},   // 27 0896 90f6 Ã¦Â½Å“
    {0x42, 0x1e, 0x4b, 0x1e, 0x42, 0x1f, 0x42, 0x00},   // 27 0897 90f7 Ã§â€¦Å½
    {0x4c, 0x3f, 0x45, 0x3f, 0x5b, 0x2b, 0x79, 0x00},   // 27 0898 90f8 Ã§â€¦Â½
    {0x62, 0x1f, 0x7a, 0x44, 0x2b, 0x7a, 0x5a, 0x00},   // 27 0899 90f9 Ã¦â€”â€¹
    {0x26, 0x6a, 0x36, 0x33, 0x7e, 0x2a, 0x26, 0x00},   // 27 089a 90fa Ã§Â©Â¿
    {0x0c, 0x7b, 0x2e, 0x7c, 0x0b, 0x7e, 0x0a, 0x00},   // 27 089b 90fb Ã§Â®Â­
    {0x2a, 0x75, 0x50, 0x3e, 0x7b, 0x2e, 0x50, 0x00},   // 27 089c 90fc Ã§Â·Å¡
    {0x2a, 0x75, 0x4a, 0x7f, 0x2a, 0x3f, 0x55, 0x00},   // 28 089d 9140 Ã§Â¹Å 
    {0x5a, 0x0a, 0x4b, 0x5e, 0x3a, 0x5b, 0x4a, 0x00},   // 28 089e 9141 Ã§Â¾Â¨
    {0x7f, 0x15, 0x7f, 0x3e, 0x7b, 0x2e, 0x50, 0x00},   // 28 089f 9142 Ã¨â€¦Âº
    {0x48, 0x47, 0x2a, 0x1e, 0x12, 0x7f, 0x12, 0x00},   // 28 08a0 9143 Ã¨Ë†â€º
    {0x50, 0x3e, 0x13, 0x7e, 0x77, 0x50, 0x77, 0x00},   // 28 08a1 9144 Ã¨Ë†Â¹
    {0x42, 0x3e, 0x4b, 0x1e, 0x5b, 0x1e, 0x72, 0x00},   // 28 08a2 9145 Ã¨â€“Â¦
    {0x6a, 0x6b, 0x44, 0x56, 0x7d, 0x56, 0x44, 0x00},   // 28 08a3 9146 Ã¨Â©Â®
    {0x5f, 0x15, 0x5f, 0x0a, 0x5f, 0x2a, 0x53, 0x00},   // 28 08a4 9147 Ã¨Â³Å½
    {0x77, 0x7d, 0x57, 0x0a, 0x5f, 0x2a, 0x53, 0x00},   // 28 08a5 9148 Ã¨Â·Âµ
    {0x49, 0x38, 0x6d, 0x5b, 0x50, 0x5d, 0x6b, 0x00},   // 28 08a6 9149 Ã©ÂÂ¸
    {0x49, 0x3a, 0x49, 0x77, 0x6f, 0x67, 0x49, 0x00},   // 28 08a7 914a Ã©ÂÂ·
    {0x56, 0x7d, 0x36, 0x4a, 0x5f, 0x2a, 0x53, 0x00},   // 28 08a8 914b Ã©Å Â­
    {0x56, 0x7d, 0x4e, 0x3b, 0x0f, 0x7a, 0x48, 0x00},   // 28 08a9 914c Ã©Å â€˜
    {0x7f, 0x45, 0x27, 0x18, 0x27, 0x45, 0x7f, 0x00},   // 28 08aa 914d Ã©â€“Æ’
    {0x42, 0x1d, 0x5f, 0x22, 0x2b, 0x7e, 0x2b, 0x00},   // 28 08ab 914e Ã©Â®Â®
    {0x7a, 0x2a, 0x7b, 0x02, 0x1a, 0x43, 0x7a, 0x00},   // 28 08ac 914f Ã¥â€°Â
    {0x2a, 0x7a, 0x6b, 0x7e, 0x6a, 0x7b, 0x2a, 0x00},   // 28 08ad 9150 Ã¥â€“â€ž
    {0x75, 0x00, 0x2d, 0x7f, 0x3e, 0x0a, 0x79, 0x00},   // 28 08ae 9151 Ã¦Â¼Â¸
    {0x54, 0x13, 0x4d, 0x07, 0x52, 0x0f, 0x52, 0x00},   // 28 08af 9152 Ã§â€žÂ¶
    {0x44, 0x54, 0x56, 0x7d, 0x56, 0x54, 0x44, 0x00},   // 28 08b0 9153 Ã¥â€¦Â¨
    {0x12, 0x7b, 0x16, 0x2d, 0x2d, 0x7e, 0x2d, 0x00},   // 28 08b1 9154 Ã§Â¦â€¦
    {0x2a, 0x75, 0x2a, 0x7b, 0x6e, 0x7b, 0x2a, 0x00},   // 28 08b2 9155 Ã§Â¹â€¢
    {0x7f, 0x15, 0x7f, 0x2a, 0x7b, 0x6e, 0x7b, 0x00},   // 28 08b3 9156 Ã¨â€ Â³
    {0x35, 0x7e, 0x55, 0x3f, 0x5d, 0x7d, 0x5d, 0x00},   // 28 08b4 9157 Ã§Â³Å½
    {0x1e, 0x12, 0x1e, 0x7b, 0x5e, 0x7b, 0x0e, 0x00},   // 28 08b5 9158 Ã¥â„¢Å’
    {0x57, 0x5e, 0x4b, 0x6e, 0x5f, 0x45, 0x5f, 0x00},   // 28 08b6 9159 Ã¥Â¡â€˜
    {0x38, 0x3f, 0x40, 0x7f, 0x55, 0x7f, 0x40, 0x00},   // 28 08b7 915a Ã¥Â²Â¨
    {0x52, 0x7f, 0x0a, 0x7f, 0x5a, 0x7f, 0x0a, 0x00},   // 28 08b8 915b Ã¦Å½Âª
    {0x04, 0x7e, 0x55, 0x5c, 0x55, 0x7e, 0x04, 0x00},   // 28 08b9 915c Ã¦â€ºÂ¾
    {0x00, 0x0e, 0x7b, 0x5e, 0x5a, 0x7b, 0x0e, 0x00},   // 28 08ba 915d Ã¦â€ºÂ½
    {0x5a, 0x36, 0x5f, 0x7a, 0x76, 0x5f, 0x4a, 0x00},   // 28 08bb 915e Ã¦Â¥Å¡
    {0x55, 0x4a, 0x3d, 0x7f, 0x55, 0x7f, 0x40, 0x00},   // 28 08bc 915f Ã§â€¹â„¢
    {0x31, 0x3d, 0x5b, 0x3e, 0x7b, 0x06, 0x6a, 0x00},   // 28 08bd 9160 Ã§â€“Â
    {0x31, 0x3d, 0x5b, 0x2e, 0x7f, 0x2a, 0x4e, 0x00},   // 28 08be 9161 Ã§â€“Å½
    {0x09, 0x37, 0x31, 0x4a, 0x37, 0x7a, 0x57, 0x00},   // 28 08bf 9162 Ã§Â¤Å½
    {0x12, 0x7b, 0x56, 0x7f, 0x55, 0x7f, 0x40, 0x00},   // 28 08c0 9163 Ã§Â¥â€“
    {0x35, 0x7f, 0x45, 0x7f, 0x55, 0x7f, 0x40, 0x00},   // 28 08c1 9164 Ã§Â§Å¸
    {0x35, 0x7e, 0x45, 0x7f, 0x55, 0x7f, 0x40, 0x00},   // 28 08c2 9165 Ã§Â²â€”
    {0x54, 0x16, 0x1e, 0x77, 0x16, 0x0e, 0x54, 0x00},   // 28 08c3 9166 Ã§Â´Â 
    {0x2a, 0x75, 0x48, 0x7f, 0x55, 0x7f, 0x40, 0x00},   // 28 08c4 9167 Ã§Âµâ€ž
    {0x4a, 0x16, 0x5f, 0x2a, 0x1f, 0x7e, 0x2a, 0x00},   // 28 08c5 9168 Ã¨Ëœâ€¡
    {0x6a, 0x6b, 0x40, 0x3e, 0x1a, 0x79, 0x28, 0x00},   // 28 08c6 9169 Ã¨Â¨Â´
    {0x7f, 0x1b, 0x40, 0x7f, 0x55, 0x7f, 0x40, 0x00},   // 28 08c7 916a Ã©ËœÂ»
    {0x49, 0x3a, 0x57, 0x4e, 0x67, 0x5f, 0x7f, 0x00},   // 28 08c8 916b Ã©ÂÂ¡
    {0x40, 0x7e, 0x55, 0x2c, 0x55, 0x3f, 0x40, 0x00},   // 28 08c9 916c Ã©Â¼Â 
    {0x0c, 0x7f, 0x0e, 0x7b, 0x5e, 0x7b, 0x0e, 0x00},   // 28 08ca 916d Ã¥Æ’Â§
    {0x44, 0x3e, 0x6d, 0x62, 0x0e, 0x40, 0x7f, 0x00},   // 28 08cb 916e Ã¥â€°Âµ
    {0x41, 0x25, 0x19, 0x27, 0x4d, 0x31, 0x4f, 0x00},   // 28 08cc 916f Ã¥ÂÅ’
    {0x2b, 0x3a, 0x7f, 0x1a, 0x5f, 0x2a, 0x5b, 0x00},   // 28 08cd 9170 Ã¥ÂÂ¢
    {0x44, 0x24, 0x1e, 0x6d, 0x6e, 0x64, 0x04, 0x00},   // 28 08ce 9171 Ã¥â‚¬â€°
    {0x52, 0x36, 0x76, 0x5f, 0x32, 0x56, 0x56, 0x00},   // 28 08cf 9172 Ã¥â€“Âª
    {0x14, 0x7f, 0x04, 0x44, 0x7f, 0x44, 0x04, 0x00},   // 28 08d0 9173 Ã¥Â£Â®
    {0x2a, 0x1a, 0x4e, 0x3f, 0x4e, 0x1a, 0x2a, 0x00},   // 28 08d1 9174 Ã¥Â¥Â
    {0x42, 0x56, 0x2a, 0x1f, 0x2a, 0x56, 0x42, 0x00},   // 28 08d2 9175 Ã§Ë†Â½
    {0x46, 0x4a, 0x2a, 0x7f, 0x2a, 0x4a, 0x46, 0x00},   // 28 08d3 9176 Ã¥Â®â€¹
    {0x40, 0x3f, 0x1b, 0x77, 0x5b, 0x77, 0x1b, 0x00},   // 28 08d4 9177 Ã¥Â±Â¤
    {0x7f, 0x41, 0x5d, 0x45, 0x7f, 0x45, 0x5d, 0x00},   // 28 08d5 9178 Ã¥Å’Â
    {0x6b, 0x3f, 0x4a, 0x54, 0x6b, 0x16, 0x5e, 0x00},   // 28 08d6 9179 Ã¦Æ’Â£
    {0x6a, 0x26, 0x5f, 0x4a, 0x5f, 0x15, 0x5f, 0x00},   // 28 08d7 917a Ã¦Æ’Â³
    {0x52, 0x7f, 0x4e, 0x5a, 0x2f, 0x5a, 0x4e, 0x00},   // 28 08d8 917b Ã¦ÂÅ“
    {0x52, 0x7f, 0x0c, 0x35, 0x7d, 0x37, 0x0c, 0x00},   // 28 08d9 917c Ã¦Å½Æ’
    {0x52, 0x7f, 0x3a, 0x2a, 0x7e, 0x29, 0x39, 0x00},   // 28 08da 917d Ã¦Å’Â¿
    {0x52, 0x7f, 0x49, 0x5b, 0x7d, 0x5b, 0x68, 0x00},   // 28 08db 917e Ã¦Å½Â»
    {0x52, 0x7f, 0x5c, 0x37, 0x7d, 0x37, 0x5c, 0x00},   // 29 08dc 9180 Ã¦â€œÂ
    {0x20, 0x3f, 0x35, 0x75, 0x35, 0x3f, 0x20, 0x00},   // 29 08dd 9181 Ã¦â€”Â©
    {0x1e, 0x76, 0x5f, 0x56, 0x5f, 0x76, 0x1e, 0x00},   // 29 08de 9182 Ã¦â€ºÂ¹
    {0x50, 0x57, 0x36, 0x7f, 0x36, 0x57, 0x50, 0x00},   // 29 08df 9183 Ã¥Â·Â£
    {0x1a, 0x7f, 0x24, 0x1e, 0x6d, 0x62, 0x04, 0x00},   // 29 08e0 9184 Ã¦Â§Â
    {0x1a, 0x7f, 0x1a, 0x7f, 0x5a, 0x7f, 0x1a, 0x00},   // 29 08e1 9185 Ã¦Â§Â½
    {0x75, 0x00, 0x1a, 0x7f, 0x5a, 0x7f, 0x1a, 0x00},   // 29 08e2 9186 Ã¦Â¼â€¢
    {0x4c, 0x3f, 0x5c, 0x37, 0x7d, 0x37, 0x5c, 0x00},   // 29 08e3 9187 Ã§â€¡Â¥
    {0x0a, 0x2e, 0x6d, 0x7d, 0x2f, 0x3c, 0x08, 0x00},   // 29 08e4 9188 Ã¤Âºâ€°
    {0x54, 0x3e, 0x4a, 0x5e, 0x2f, 0x5e, 0x4a, 0x00},   // 29 08e5 9189 Ã§â€”Â©
    {0x22, 0x1a, 0x7f, 0x0a, 0x7f, 0x55, 0x7f, 0x00},   // 29 08e6 918a Ã§â€ºÂ¸
    {0x66, 0x2a, 0x56, 0x53, 0x6e, 0x0a, 0x66, 0x00},   // 29 08e7 918b Ã§Âªâ€œ
    {0x35, 0x7e, 0x1a, 0x7f, 0x5a, 0x7f, 0x1a, 0x00},   // 29 08e8 918c Ã§Â³Å¸
    {0x2a, 0x75, 0x6a, 0x2d, 0x48, 0x45, 0x6a, 0x00},   // 29 08e9 918d Ã§Â·Â
    {0x2a, 0x75, 0x56, 0x1a, 0x7b, 0x1a, 0x56, 0x00},   // 29 08ea 918e Ã§Â¶Å“
    {0x21, 0x3f, 0x7f, 0x6a, 0x2d, 0x48, 0x6b, 0x00},   // 29 08eb 918f Ã¨ÂÂ¡
    {0x22, 0x3e, 0x37, 0x76, 0x37, 0x3e, 0x22, 0x00},   // 29 08ec 9190 Ã¨Ââ€°
    {0x2a, 0x7e, 0x13, 0x52, 0x7b, 0x52, 0x12, 0x00},   // 29 08ed 9191 Ã¨ÂËœ
    {0x2a, 0x76, 0x2f, 0x22, 0x7f, 0x36, 0x32, 0x00},   // 29 08ee 9192 Ã¨â€˜Â¬
    {0x4a, 0x26, 0x1b, 0x7a, 0x7b, 0x66, 0x0a, 0x00},   // 29 08ef 9193 Ã¨â€™Â¼
    {0x56, 0x02, 0x5b, 0x36, 0x7b, 0x36, 0x5a, 0x00},   // 29 08f0 9194 Ã¨â€”Â»
    {0x5a, 0x3f, 0x72, 0x5a, 0x3f, 0x5a, 0x52, 0x00},   // 29 08f1 9195 Ã¨Â£â€¦
    {0x48, 0x2a, 0x4a, 0x7f, 0x5a, 0x5a, 0x48, 0x00},   // 29 08f2 9196 Ã¨ÂµÂ°
    {0x49, 0x38, 0x62, 0x6b, 0x5e, 0x6b, 0x62, 0x00},   // 29 08f3 9197 Ã©â‚¬Â
    {0x49, 0x38, 0x5a, 0x7f, 0x5a, 0x7f, 0x5a, 0x00},   // 29 08f4 9198 Ã©ÂÂ­
    {0x56, 0x7d, 0x36, 0x44, 0x3e, 0x6d, 0x62, 0x00},   // 29 08f5 9199 Ã©Å½â€”
    {0x56, 0x32, 0x7f, 0x37, 0x7b, 0x4e, 0x7e, 0x00},   // 29 08f6 919a Ã©Å“Å“
    {0x5f, 0x1f, 0x75, 0x49, 0x5b, 0x7d, 0x5b, 0x00},   // 29 08f7 919b Ã©Â¨â€™
    {0x04, 0x7e, 0x23, 0x5e, 0x7d, 0x2f, 0x50, 0x00},   // 29 08f8 919c Ã¥Æ’Â
    {0x24, 0x3f, 0x0e, 0x7b, 0x5e, 0x7b, 0x0e, 0x00},   // 29 08f9 919d Ã¥Â¢â€”
    {0x06, 0x7f, 0x0e, 0x7b, 0x5e, 0x7b, 0x0e, 0x00},   // 29 08fa 919e Ã¦â€ Å½
    {0x7f, 0x15, 0x7f, 0x7b, 0x4a, 0x3f, 0x4a, 0x00},   // 29 08fb 919f Ã¨â€¡â€œ
    {0x42, 0x3a, 0x7f, 0x7a, 0x4f, 0x3a, 0x52, 0x00},   // 29 08fc 91a0 Ã¨â€Âµ
    {0x5f, 0x1f, 0x4e, 0x7b, 0x5e, 0x7b, 0x0e, 0x00},   // 29 08fd 91a1 Ã¨Â´Ë†
    {0x49, 0x38, 0x4c, 0x7b, 0x6f, 0x7a, 0x48, 0x00},   // 29 08fe 91a2 Ã©â‚¬Â 
    {0x04, 0x7e, 0x41, 0x37, 0x45, 0x7d, 0x57, 0x00},   // 29 08ff 91a3 Ã¤Â¿Æ’
    {0x04, 0x7e, 0x5f, 0x15, 0x5f, 0x0e, 0x7f, 0x00},   // 29 0900 91a4 Ã¥ÂÂ´
    {0x5f, 0x15, 0x5f, 0x00, 0x0e, 0x40, 0x7f, 0x00},   // 29 0901 91a5 Ã¥â€°â€¡
    {0x7f, 0x55, 0x5f, 0x20, 0x7f, 0x01, 0x1f, 0x00},   // 29 0902 91a6 Ã¥ÂÂ³
    {0x60, 0x3e, 0x5a, 0x5b, 0x7a, 0x1e, 0x60, 0x00},   // 29 0903 91a7 Ã¦ÂÂ¯
    {0x52, 0x7f, 0x4a, 0x37, 0x45, 0x7d, 0x57, 0x00},   // 29 0904 91a8 Ã¦Ââ€°
    {0x42, 0x4e, 0x2a, 0x7f, 0x2a, 0x4e, 0x42, 0x00},   // 29 0905 91a9 Ã¦ÂÅ¸
    {0x75, 0x00, 0x5f, 0x15, 0x5f, 0x0e, 0x7f, 0x00},   // 29 0906 91aa Ã¦Â¸Â¬
    {0x40, 0x37, 0x45, 0x7d, 0x55, 0x57, 0x40, 0x00},   // 29 0907 91ab Ã¨Â¶Â³
    {0x49, 0x3a, 0x6e, 0x5a, 0x7f, 0x5a, 0x6e, 0x00},   // 29 0908 91ac Ã©â‚¬Å¸
    {0x0c, 0x7f, 0x12, 0x69, 0x64, 0x69, 0x12, 0x00},   // 29 0909 91ad Ã¤Â¿â€”
    {0x40, 0x3f, 0x73, 0x5b, 0x7f, 0x3f, 0x73, 0x00},   // 29 090a 91ae Ã¥Â±Å¾
    {0x5f, 0x1f, 0x4a, 0x1e, 0x4a, 0x3f, 0x52, 0x00},   // 29 090b 91af Ã¨Â³Å 
    {0x62, 0x1f, 0x7a, 0x14, 0x5f, 0x3a, 0x52, 0x00},   // 29 090c 91b0 Ã¦â€”Â
    {0x2a, 0x75, 0x5a, 0x2a, 0x0f, 0x6a, 0x5a, 0x00},   // 29 090d 91b1 Ã§Â¶Å¡
    {0x32, 0x2e, 0x32, 0x63, 0x32, 0x2e, 0x32, 0x00},   // 29 090e 91b2 Ã¥Ââ€™
    {0x12, 0x7b, 0x36, 0x7e, 0x4a, 0x7f, 0x7e, 0x00},   // 29 090f 91b3 Ã¨Â¢â€“
    {0x52, 0x52, 0x1f, 0x1a, 0x1f, 0x52, 0x52, 0x00},   // 29 0910 91b4 Ã¥â€¦Â¶
    {0x52, 0x7f, 0x7a, 0x2b, 0x7a, 0x03, 0x7a, 0x00},   // 29 0911 91b5 Ã¦ÂÆ’
    {0x12, 0x7a, 0x17, 0x52, 0x76, 0x1e, 0x12, 0x00},   // 29 0912 91b6 Ã¥Â­Ëœ
    {0x51, 0x7d, 0x0b, 0x50, 0x15, 0x7b, 0x51, 0x00},   // 29 0913 91b7 Ã¥Â­Â«
    {0x12, 0x1e, 0x3b, 0x56, 0x7e, 0x1f, 0x12, 0x00},   // 29 0914 91b8 Ã¥Â°Å 
    {0x52, 0x7f, 0x0a, 0x5c, 0x17, 0x17, 0x5c, 0x00},   // 29 0915 91b9 Ã¦ÂÂ
    {0x22, 0x1a, 0x7f, 0x0a, 0x52, 0x7f, 0x02, 0x00},   // 29 0916 91ba Ã¦Ââ€˜
    {0x49, 0x38, 0x6d, 0x73, 0x55, 0x7b, 0x51, 0x00},   // 29 0917 91bb Ã©ÂÅ“
    {0x04, 0x7e, 0x09, 0x7e, 0x44, 0x5f, 0x6c, 0x00},   // 29 0918 91bc Ã¤Â»â€“
    {0x08, 0x4a, 0x5a, 0x55, 0x2b, 0x28, 0x18, 0x00},   // 29 0919 91bd Ã¥Â¤Å¡
    {0x44, 0x44, 0x24, 0x5f, 0x24, 0x44, 0x44, 0x00},   // 29 091a 91be Ã¥Â¤Âª
    {0x65, 0x10, 0x44, 0x24, 0x5f, 0x24, 0x44, 0x00},   // 29 091b 91bf Ã¦Â±Â°
    {0x6b, 0x6a, 0x06, 0x7a, 0x53, 0x4a, 0x66, 0x00},   // 29 091c 91c0 Ã¨Â©â€˜
    {0x1e, 0x1e, 0x54, 0x5d, 0x77, 0x5d, 0x54, 0x00},   // 29 091d 91c1 Ã¥â€Â¾
    {0x5f, 0x4b, 0x40, 0x6a, 0x47, 0x5a, 0x5a, 0x00},   // 29 091e 91c2 Ã¥Â â€¢
    {0x4a, 0x4e, 0x5a, 0x2e, 0x39, 0x4d, 0x49, 0x00},   // 29 091f 91c3 Ã¥Â¦Â¥
    {0x06, 0x7f, 0x0a, 0x77, 0x3a, 0x7e, 0x0a, 0x00},   // 29 0920 91c4 Ã¦Æ’Â°
    {0x52, 0x7f, 0x0a, 0x01, 0x41, 0x7f, 0x01, 0x00},   // 29 0921 91c5 Ã¦â€°â€œ
    {0x1a, 0x7f, 0x0a, 0x06, 0x7a, 0x53, 0x56, 0x00},   // 29 0922 91c6 Ã¦Å¸Â
    {0x7e, 0x13, 0x7e, 0x06, 0x7a, 0x53, 0x56, 0x00},   // 29 0923 91c7 Ã¨Ë†Âµ
    {0x1a, 0x7f, 0x0a, 0x77, 0x3a, 0x7e, 0x0a, 0x00},   // 29 0924 91c8 Ã¦Â¥â€¢
    {0x7f, 0x25, 0x1b, 0x06, 0x7a, 0x53, 0x56, 0x00},   // 29 0925 91c9 Ã©â„¢â‚¬
    {0x5f, 0x1f, 0x75, 0x40, 0x24, 0x5f, 0x64, 0x00},   // 29 0926 91ca Ã©Â§â€ž
    {0x5f, 0x1f, 0x75, 0x2c, 0x2d, 0x7e, 0x2d, 0x00},   // 29 0927 91cb Ã©Â¨Â¨
    {0x04, 0x7e, 0x13, 0x2a, 0x7f, 0x2a, 0x12, 0x00},   // 29 0928 91cc Ã¤Â½â€œ
    {0x24, 0x3f, 0x14, 0x7f, 0x4a, 0x7f, 0x4a, 0x00},   // 29 0929 91cd Ã¥Â â€ 
    {0x42, 0x2a, 0x13, 0x2e, 0x0a, 0x52, 0x7f, 0x00},   // 29 092a 91ce Ã¥Â¯Â¾
    {0x7d, 0x07, 0x7d, 0x05, 0x7d, 0x1a, 0x7f, 0x00},   // 29 092b 91cf Ã¨â‚¬Â
    {0x64, 0x4e, 0x41, 0x72, 0x43, 0x46, 0x6b, 0x00},   // 29 092c 91d0 Ã¥Â²Â±
    {0x1a, 0x6f, 0x2a, 0x7f, 0x2a, 0x6f, 0x1a, 0x00},   // 29 092d 91d1 Ã¥Â¸Â¯
    {0x0a, 0x7d, 0x28, 0x6a, 0x2f, 0x7a, 0x28, 0x00},   // 29 092e 91d2 Ã¥Â¾â€¦
    {0x64, 0x3c, 0x56, 0x55, 0x74, 0x1a, 0x64, 0x00},   // 29 092f 91d3 Ã¦â‚¬Â 
    {0x62, 0x3f, 0x4a, 0x5f, 0x60, 0x1b, 0x52, 0x00},   // 29 0930 91d4 Ã¦â€¦â€¹
    {0x54, 0x1e, 0x5f, 0x16, 0x5f, 0x24, 0x55, 0x00},   // 29 0931 91d5 Ã¦Ë†Â´
    {0x0a, 0x77, 0x5a, 0x50, 0x5a, 0x77, 0x0a, 0x00},   // 29 0932 91d6 Ã¦â€ºÂ¿
    {0x48, 0x5a, 0x2e, 0x77, 0x2e, 0x5a, 0x48, 0x00},   // 29 0933 91d7 Ã¦Â³Â°
    {0x75, 0x00, 0x1a, 0x6f, 0x3a, 0x6f, 0x1a, 0x00},   // 29 0934 91d8 Ã¦Â»Å¾
    {0x7f, 0x15, 0x7f, 0x08, 0x6c, 0x6b, 0x6c, 0x00},   // 29 0935 91d9 Ã¨Æ’Å½
    {0x7f, 0x15, 0x7f, 0x79, 0x50, 0x4f, 0x57, 0x00},   // 29 0936 91da Ã¨â€¦Â¿
    {0x12, 0x72, 0x5b, 0x56, 0x53, 0x6a, 0x12, 0x00},   // 29 0937 91db Ã¨â€¹â€
    {0x54, 0x3e, 0x71, 0x5a, 0x33, 0x56, 0x5b, 0x00},   // 29 0938 91dc Ã¨Â¢â€¹
    {0x44, 0x4e, 0x31, 0x32, 0x33, 0x76, 0x4b, 0x00},   // 29 0939 91dd Ã¨Â²Â¸
    {0x49, 0x3a, 0x40, 0x7f, 0x55, 0x75, 0x6f, 0x00},   // 29 093a 91de Ã©â‚¬â‚¬
    {0x49, 0x38, 0x6a, 0x56, 0x7f, 0x56, 0x68, 0x00},   // 29 093b 91df Ã©â‚¬Â®
    {0x7f, 0x1b, 0x2a, 0x57, 0x7a, 0x13, 0x2a, 0x00},   // 29 093c 91e0 Ã©Å¡Å 
    {0x64, 0x2e, 0x79, 0x3a, 0x7b, 0x26, 0x6b, 0x00},   // 29 093d 91e1 Ã©Â»â€º
    {0x5d, 0x1f, 0x7f, 0x35, 0x2f, 0x35, 0x7f, 0x00},   // 29 093e 91e2 Ã©Â¯â€º
    {0x04, 0x7e, 0x05, 0x04, 0x0f, 0x34, 0x45, 0x00},   // 29 093f 91e3 Ã¤Â»Â£
    {0x08, 0x68, 0x6c, 0x6b, 0x68, 0x64, 0x08, 0x00},   // 29 0940 91e4 Ã¥ÂÂ°
    {0x44, 0x44, 0x24, 0x1f, 0x24, 0x44, 0x44, 0x00},   // 29 0941 91e5 Ã¥Â¤Â§
    {0x44, 0x5b, 0x2e, 0x7c, 0x2b, 0x2e, 0x62, 0x00},   // 29 0942 91e6 Ã§Â¬Â¬
    {0x7d, 0x6f, 0x7d, 0x34, 0x47, 0x7f, 0x54, 0x00},   // 29 0943 91e7 Ã©â€ Â
    {0x44, 0x37, 0x3f, 0x54, 0x6d, 0x4f, 0x6d, 0x00},   // 29 0944 91e8 Ã©Â¡Å’
    {0x40, 0x3e, 0x4e, 0x12, 0x5f, 0x1e, 0x7a, 0x00},   // 29 0945 91e9 Ã©Â·Â¹
    {0x75, 0x00, 0x0a, 0x3e, 0x3b, 0x7e, 0x4a, 0x00},   // 29 0946 91ea Ã¦Â»Â
    {0x75, 0x0a, 0x7e, 0x2b, 0x7e, 0x77, 0x5d, 0x00},   // 29 0947 91eb Ã§â‚¬Â§
    {0x20, 0x3c, 0x34, 0x77, 0x36, 0x3e, 0x22, 0x00},   // 29 0948 91ec Ã¥Ââ€œ
    {0x1e, 0x1e, 0x29, 0x57, 0x7d, 0x19, 0x25, 0x00},   // 29 0949 91ed Ã¥â€¢â€ž
    {0x16, 0x12, 0x16, 0x7f, 0x56, 0x52, 0x56, 0x00},   // 29 094a 91ee Ã¥Â®â€¦
    {0x52, 0x7f, 0x08, 0x0a, 0x7e, 0x49, 0x68, 0x00},   // 29 094b 91ef Ã¦â€°Ëœ
    {0x52, 0x7f, 0x4a, 0x3f, 0x05, 0x1d, 0x67, 0x00},   // 29 094c 91f0 Ã¦Å Å¾
    {0x52, 0x7f, 0x0a, 0x11, 0x7f, 0x49, 0x79, 0x00},   // 29 094d 91f1 Ã¦â€¹â€œ
    {0x65, 0x10, 0x40, 0x3f, 0x05, 0x1d, 0x67, 0x00},   // 29 094e 91f2 Ã¦Â²Â¢
    {0x75, 0x00, 0x25, 0x7f, 0x50, 0x7d, 0x57, 0x00},   // 29 094f 91f3 Ã¦Â¿Â¯
    {0x2a, 0x3e, 0x29, 0x57, 0x7d, 0x19, 0x25, 0x00},   // 29 0950 91f4 Ã§ÂÂ¢
    {0x6a, 0x63, 0x08, 0x0a, 0x7e, 0x49, 0x68, 0x00},   // 29 0951 91f5 Ã¨Â¨â€”
    {0x56, 0x7d, 0x2b, 0x3b, 0x6f, 0x3b, 0x2b, 0x00},   // 29 0952 91f6 Ã©ÂÂ¸
    {0x75, 0x00, 0x4b, 0x75, 0x77, 0x25, 0x7f, 0x00},   // 29 0953 91f7 Ã¦Â¿Â
    {0x6b, 0x62, 0x2a, 0x1f, 0x6a, 0x6b, 0x6a, 0x00},   // 29 0954 91f8 Ã¨Â«Â¾
    {0x2a, 0x2a, 0x3f, 0x2a, 0x2f, 0x7a, 0x2a, 0x00},   // 29 0955 91f9 Ã¨Å’Â¸
    {0x40, 0x3f, 0x19, 0x7d, 0x19, 0x7f, 0x40, 0x00},   // 29 0956 91fa Ã¥â€¡Â§
    {0x4e, 0x7b, 0x2e, 0x7d, 0x14, 0x57, 0x7d, 0x00},   // 29 0957 91fb Ã¨â€ºÂ¸
    {0x40, 0x4f, 0x29, 0x09, 0x29, 0x4f, 0x40, 0x00},   // 29 0958 91fc Ã¥ÂÂª
    {0x1e, 0x12, 0x1e, 0x7f, 0x01, 0x11, 0x1f, 0x00},   // 2a 0959 9240 Ã¥ÂÂ©
    {0x04, 0x7e, 0x41, 0x5f, 0x55, 0x5f, 0x40, 0x00},   // 2a 095a 9241 Ã¤Â½â€ 
    {0x49, 0x38, 0x54, 0x5e, 0x77, 0x5e, 0x54, 0x00},   // 2a 095b 9242 Ã©Ââ€
    {0x40, 0x3f, 0x71, 0x55, 0x35, 0x55, 0x51, 0x00},   // 2a 095c 9243 Ã¨Â¾Â°
    {0x1a, 0x16, 0x3e, 0x5f, 0x7a, 0x16, 0x1a, 0x00},   // 2a 095d 9244 Ã¥Â¥Âª
    {0x7f, 0x15, 0x7f, 0x4e, 0x3b, 0x7a, 0x4f, 0x00},   // 2a 095e 9245 Ã¨â€žÂ±
    {0x51, 0x55, 0x1f, 0x18, 0x1d, 0x55, 0x57, 0x00},   // 2a 095f 9246 Ã¥Â·Â½
    {0x47, 0x57, 0x75, 0x58, 0x7b, 0x55, 0x4b, 0x00},   // 2a 0960 9247 Ã§Â«Âª
    {0x49, 0x38, 0x5e, 0x50, 0x5f, 0x50, 0x5e, 0x00},   // 2a 0961 9248 Ã¨Â¾Â¿
    {0x1a, 0x7f, 0x3f, 0x55, 0x3f, 0x55, 0x7f, 0x00},   // 2a 0962 9249 Ã¦Â£Å¡
    {0x10, 0x12, 0x69, 0x64, 0x69, 0x12, 0x10, 0x00},   // 2a 0963 924a Ã¨Â°Â·
    {0x55, 0x3e, 0x5f, 0x55, 0x7f, 0x55, 0x5f, 0x00},   // 2a 0964 924b Ã§â€¹Â¸
    {0x42, 0x1d, 0x5f, 0x06, 0x53, 0x57, 0x76, 0x00},   // 2a 0965 924c Ã©Â±Ë†
    {0x1a, 0x7f, 0x1e, 0x37, 0x52, 0x77, 0x1e, 0x00},   // 2a 0966 924d Ã¦Â¨Â½
    {0x6a, 0x6b, 0x04, 0x7f, 0x4a, 0x7f, 0x4a, 0x00},   // 2a 0967 924e Ã¨ÂªÂ°
    {0x50, 0x3f, 0x11, 0x15, 0x51, 0x7f, 0x10, 0x00},   // 2a 0968 924f Ã¤Â¸Â¹
    {0x20, 0x3f, 0x2a, 0x7f, 0x2a, 0x3f, 0x20, 0x00},   // 2a 0969 9250 Ã¥ÂËœ
    {0x1e, 0x12, 0x5e, 0x5b, 0x3e, 0x5b, 0x5e, 0x00},   // 2a 096a 9251 Ã¥Ëœâ€ 
    {0x24, 0x3f, 0x54, 0x5f, 0x55, 0x5f, 0x40, 0x00},   // 2a 096b 9252 Ã¥ÂÂ¦
    {0x52, 0x7f, 0x4a, 0x5f, 0x55, 0x5f, 0x40, 0x00},   // 2a 096c 9253 Ã¦â€¹â€¦
    {0x52, 0x7f, 0x5b, 0x35, 0x71, 0x3d, 0x5b, 0x00},   // 2a 096d 9254 Ã¦Å½Â¢
    {0x40, 0x5f, 0x55, 0x55, 0x55, 0x5f, 0x40, 0x00},   // 2a 096e 9255 Ã¦â€”Â¦
    {0x5a, 0x5f, 0x3a, 0x5f, 0x44, 0x3b, 0x46, 0x00},   // 2a 096f 9256 Ã¦Â­Å½
    {0x75, 0x00, 0x55, 0x22, 0x19, 0x22, 0x55, 0x00},   // 2a 0970 9257 Ã¦Â·Â¡
    {0x75, 0x00, 0x72, 0x5f, 0x72, 0x5f, 0x52, 0x00},   // 2a 0971 9258 Ã¦Â¹â€º
    {0x43, 0x3e, 0x5a, 0x43, 0x3e, 0x52, 0x4b, 0x00},   // 2a 0972 9259 Ã§â€šÂ­
    {0x4b, 0x3e, 0x2a, 0x5d, 0x75, 0x75, 0x5d, 0x00},   // 2a 0973 925a Ã§Å¸Â­
    {0x2e, 0x33, 0x6f, 0x3a, 0x6b, 0x2a, 0x6b, 0x00},   // 2a 0974 925b Ã§Â«Â¯
    {0x24, 0x3b, 0x36, 0x7c, 0x33, 0x3e, 0x22, 0x00},   // 2a 0975 925c Ã§Â®Âª
    {0x2a, 0x75, 0x46, 0x32, 0x47, 0x7e, 0x56, 0x00},   // 2a 0976 925d Ã§Â¶Â»
    {0x21, 0x3f, 0x7f, 0x46, 0x3f, 0x72, 0x46, 0x00},   // 2a 0977 925e Ã¨â‚¬Â½
    {0x7f, 0x15, 0x7f, 0x00, 0x5f, 0x55, 0x5f, 0x00},   // 2a 0978 925f Ã¨Æ’â€ 
    {0x49, 0x45, 0x59, 0x7f, 0x5b, 0x29, 0x4b, 0x00},   // 2a 0979 9260 Ã¨â€ºâ€¹
    {0x6b, 0x62, 0x55, 0x3b, 0x52, 0x5e, 0x55, 0x00},   // 2a 097a 9261 Ã¨Âªâ€¢
    {0x56, 0x7d, 0x36, 0x7e, 0x55, 0x2b, 0x5b, 0x00},   // 2a 097b 9262 Ã©Ââ€º
    {0x7f, 0x45, 0x4d, 0x65, 0x7f, 0x45, 0x7f, 0x00},   // 2a 097c 9263 Ã¥â€ºÂ£
    {0x24, 0x3f, 0x4e, 0x7e, 0x5b, 0x7e, 0x4e, 0x00},   // 2a 097d 9264 Ã¥Â£â€¡
    {0x5d, 0x77, 0x2d, 0x2c, 0x7d, 0x2e, 0x2d, 0x00},   // 2a 097e 9265 Ã¥Â¼Â¾
    {0x7f, 0x55, 0x4e, 0x55, 0x3e, 0x0a, 0x79, 0x00},   // 2a 097f 9266 Ã¦â€“Â­
    {0x3e, 0x2a, 0x7e, 0x2a, 0x5e, 0x29, 0x5d, 0x00},   // 2a 0980 9267 Ã¦Å¡â€“
    {0x1a, 0x7f, 0x4e, 0x7e, 0x5b, 0x7e, 0x4e, 0x00},   // 2a 0981 9268 Ã¦Âªâ‚¬
    {0x20, 0x7e, 0x15, 0x40, 0x5b, 0x29, 0x5b, 0x00},   // 2a 0982 9269 Ã¦Â®Âµ
    {0x50, 0x5f, 0x35, 0x1f, 0x15, 0x5f, 0x70, 0x00},   // 2a 0983 926a Ã§â€Â·
    {0x6b, 0x6a, 0x55, 0x22, 0x19, 0x22, 0x55, 0x00},   // 2a 0984 926b Ã¨Â«â€¡
    {0x04, 0x7e, 0x7b, 0x42, 0x5f, 0x5a, 0x42, 0x00},   // 2a 0985 926c Ã¥â‚¬Â¤
    {0x44, 0x2b, 0x1e, 0x2a, 0x7e, 0x42, 0x7e, 0x00},   // 2a 0986 926d Ã§Å¸Â¥
    {0x24, 0x3f, 0x08, 0x7e, 0x44, 0x5f, 0x6c, 0x00},   // 2a 0987 926e Ã¥Å“Â°
    {0x5d, 0x77, 0x08, 0x7e, 0x44, 0x5f, 0x6c, 0x00},   // 2a 0988 926f Ã¥Â¼â€º
    {0x21, 0x3f, 0x7f, 0x18, 0x7d, 0x42, 0x68, 0x00},   // 2a 0989 9270 Ã¦ÂÂ¥
    {0x14, 0x7b, 0x56, 0x5a, 0x5e, 0x7a, 0x0e, 0x00},   // 2a 098a 9271 Ã¦â„¢Âº
    {0x75, 0x00, 0x08, 0x7e, 0x44, 0x5f, 0x6c, 0x00},   // 2a 098b 9272 Ã¦Â±Â 
    {0x54, 0x3e, 0x52, 0x3e, 0x4b, 0x3a, 0x3a, 0x00},   // 2a 098c 9273 Ã§â€”Â´
    {0x35, 0x7f, 0x15, 0x7f, 0x4a, 0x7f, 0x4a, 0x00},   // 2a 098d 9274 Ã§Â¨Å¡
    {0x77, 0x45, 0x7f, 0x55, 0x57, 0x7d, 0x47, 0x00},   // 2a 098e 9275 Ã§Â½Â®
    {0x49, 0x5d, 0x3b, 0x2d, 0x5c, 0x23, 0x5e, 0x00},   // 2a 098f 9276 Ã¨â€¡Â´
    {0x4e, 0x7f, 0x4b, 0x3e, 0x4a, 0x3e, 0x3e, 0x00},   // 2a 0990 9277 Ã¨Å“Ëœ
    {0x49, 0x3a, 0x60, 0x5f, 0x5b, 0x73, 0x5b, 0x00},   // 2a 0991 9278 Ã©Ââ€¦
    {0x5f, 0x1f, 0x75, 0x7e, 0x44, 0x5f, 0x6c, 0x00},   // 2a 0992 9279 Ã©Â¦Â³
    {0x54, 0x5b, 0x36, 0x64, 0x3b, 0x5e, 0x52, 0x00},   // 2a 0993 927a Ã§Â¯â€°
    {0x12, 0x76, 0x56, 0x7b, 0x52, 0x72, 0x1a, 0x00},   // 2a 0994 927b Ã§â€¢Å“
    {0x04, 0x03, 0x7e, 0x04, 0x43, 0x7e, 0x02, 0x00},   // 2a 0995 927c Ã§Â«Â¹
    {0x54, 0x73, 0x56, 0x44, 0x33, 0x76, 0x42, 0x00},   // 2a 0996 927d Ã§Â­â€˜
    {0x12, 0x76, 0x57, 0x7a, 0x53, 0x72, 0x1a, 0x00},   // 2a 0997 927e Ã¨â€œâ€ž
    {0x49, 0x3a, 0x69, 0x57, 0x7d, 0x49, 0x55, 0x00},   // 2b 0998 9280 Ã©â‚¬Â
    {0x35, 0x7f, 0x4c, 0x2b, 0x1f, 0x2a, 0x48, 0x00},   // 2b 0999 9281 Ã§Â§Â©
    {0x46, 0x5a, 0x56, 0x7b, 0x5e, 0x4a, 0x56, 0x00},   // 2b 099a 9282 Ã§Âªâ€™
    {0x52, 0x32, 0x1b, 0x76, 0x1b, 0x32, 0x52, 0x00},   // 2b 099b 9283 Ã¨Å’Â¶
    {0x5f, 0x3c, 0x7a, 0x6e, 0x5b, 0x6e, 0x7a, 0x00},   // 2b 099c 9284 Ã¥Â«Â¡
    {0x4a, 0x3a, 0x7b, 0x5e, 0x5a, 0x7b, 0x0a, 0x00},   // 2b 099d 9285 Ã§Ââ‚¬
    {0x1e, 0x12, 0x12, 0x7f, 0x12, 0x12, 0x1e, 0x00},   // 2b 099e 9286 Ã¤Â¸Â­
    {0x04, 0x7e, 0x1f, 0x12, 0x7f, 0x12, 0x1e, 0x00},   // 2b 099f 9287 Ã¤Â»Â²
    {0x06, 0x7a, 0x5a, 0x7f, 0x5a, 0x7a, 0x06, 0x00},   // 2b 09a0 9288 Ã¥Â®â„¢
    {0x60, 0x2e, 0x4a, 0x5f, 0x6a, 0x0e, 0x60, 0x00},   // 2b 09a1 9289 Ã¥Â¿Â 
    {0x52, 0x7f, 0x7e, 0x4a, 0x7f, 0x4a, 0x7e, 0x00},   // 2b 09a2 928a Ã¦Å Â½
    {0x50, 0x4f, 0x75, 0x55, 0x75, 0x4b, 0x50, 0x00},   // 2b 09a3 928b Ã¦ËœÂ¼
    {0x1a, 0x7f, 0x44, 0x55, 0x7e, 0x54, 0x44, 0x00},   // 2b 09a4 928c Ã¦Å¸Â±
    {0x65, 0x10, 0x44, 0x55, 0x7e, 0x54, 0x44, 0x00},   // 2b 09a5 928d Ã¦Â³Â¨
    {0x40, 0x5e, 0x52, 0x7f, 0x52, 0x3e, 0x40, 0x00},   // 2b 09a6 928e Ã¨â„¢Â«
    {0x22, 0x2e, 0x7a, 0x4f, 0x1a, 0x2e, 0x52, 0x00},   // 2b 09a7 928f Ã¨Â¡Â·
    {0x6a, 0x6b, 0x44, 0x55, 0x7e, 0x54, 0x44, 0x00},   // 2b 09a8 9290 Ã¨Â¨Â»
    {0x7d, 0x6f, 0x7d, 0x0a, 0x52, 0x7f, 0x02, 0x00},   // 2b 09a9 9291 Ã©â€¦Å½
    {0x56, 0x7d, 0x36, 0x5e, 0x17, 0x7e, 0x14, 0x00},   // 2b 09aa 9292 Ã©â€¹Â³
    {0x5f, 0x1f, 0x75, 0x44, 0x55, 0x7e, 0x54, 0x00},   // 2b 09ab 9293 Ã©Â§Â
    {0x1a, 0x7f, 0x06, 0x1b, 0x1f, 0x5b, 0x76, 0x00},   // 2b 09ac 9294 Ã¦Â¨â€”
    {0x75, 0x28, 0x55, 0x3f, 0x1a, 0x6f, 0x6a, 0x00},   // 2b 09ad 9295 Ã§â‚¬Â¦
    {0x55, 0x4a, 0x3d, 0x28, 0x1a, 0x6f, 0x6a, 0x00},   // 2b 09ae 9296 Ã§Å’Âª
    {0x1a, 0x0a, 0x5f, 0x7a, 0x1f, 0x0a, 0x1a, 0x00},   // 2b 09af 9297 Ã¨â€¹Â§
    {0x52, 0x52, 0x37, 0x7e, 0x5f, 0x76, 0x12, 0x00},   // 2b 09b0 9298 Ã¨â€˜â€”
    {0x5f, 0x15, 0x5f, 0x06, 0x4a, 0x7b, 0x0e, 0x00},   // 2b 09b1 9299 Ã¨Â²Â¯
    {0x01, 0x01, 0x41, 0x7f, 0x01, 0x01, 0x01, 0x00},   // 2b 09b2 929a Ã¤Â¸Â
    {0x52, 0x54, 0x3f, 0x00, 0x7f, 0x4c, 0x52, 0x00},   // 2b 09b3 929b Ã¥â€¦â€ 
    {0x71, 0x00, 0x7f, 0x35, 0x2f, 0x35, 0x7f, 0x00},   // 2b 09b4 929c Ã¥â€¡â€¹
    {0x1e, 0x12, 0x5f, 0x32, 0x77, 0x36, 0x57, 0x00},   // 2b 09b5 929d Ã¥â€“â€¹
    {0x0e, 0x7a, 0x2e, 0x7b, 0x0a, 0x6e, 0x56, 0x00},   // 2b 09b6 929e Ã¥Â¯Âµ
    {0x0e, 0x7f, 0x0e, 0x70, 0x5f, 0x54, 0x74, 0x00},   // 2b 09b7 929f Ã¥Â¸â€“
    {0x0e, 0x7f, 0x10, 0x7f, 0x55, 0x35, 0x51, 0x00},   // 2b 09b8 92a0 Ã¥Â¸Â³
    {0x40, 0x3e, 0x0a, 0x4a, 0x7b, 0x0a, 0x0a, 0x00},   // 2b 09b9 92a1 Ã¥ÂºÂ
    {0x10, 0x1d, 0x15, 0x7f, 0x15, 0x57, 0x70, 0x00},   // 2b 09ba 92a2 Ã¥Â¼â€
    {0x5d, 0x77, 0x10, 0x7f, 0x55, 0x35, 0x51, 0x00},   // 2b 09bb 92a3 Ã¥Â¼Âµ
    {0x7f, 0x35, 0x2f, 0x35, 0x7f, 0x4a, 0x25, 0x00},   // 2b 09bc 92a4 Ã¥Â½Â«
    {0x0a, 0x7d, 0x56, 0x77, 0x56, 0x3f, 0x5e, 0x00},   // 2b 09bd 92a5 Ã¥Â¾Â´
    {0x6a, 0x3d, 0x4a, 0x5b, 0x7a, 0x0f, 0x56, 0x00},   // 2b 09be 92a6 Ã¦â€¡Â²
    {0x52, 0x7f, 0x4a, 0x3f, 0x00, 0x7f, 0x4a, 0x00},   // 2b 09bf 92a7 Ã¦Å’â€˜
    {0x3e, 0x6b, 0x3e, 0x24, 0x5f, 0x35, 0x77, 0x00},   // 2b 09c0 92a8 Ã¦Å¡Â¢
    {0x2d, 0x77, 0x2d, 0x40, 0x3f, 0x55, 0x7f, 0x00},   // 2b 09c1 92a9 Ã¦Å“Â
    {0x75, 0x00, 0x2d, 0x7f, 0x3f, 0x15, 0x7f, 0x00},   // 2b 09c2 92aa Ã¦Â½Â®
    {0x7f, 0x14, 0x77, 0x3e, 0x73, 0x36, 0x57, 0x00},   // 2b 09c3 92ab Ã§â€°â€™
    {0x3f, 0x25, 0x3f, 0x3f, 0x42, 0x7e, 0x02, 0x00},   // 2b 09c4 92ac Ã§â€Âº
    {0x7f, 0x55, 0x7f, 0x3f, 0x00, 0x7f, 0x4a, 0x00},   // 2b 09c5 92ad Ã§Å“Âº
    {0x21, 0x3f, 0x7f, 0x62, 0x2e, 0x4f, 0x6e, 0x00},   // 2b 09c6 92ae Ã¨ÂÂ´
    {0x7f, 0x15, 0x7f, 0x70, 0x5f, 0x35, 0x55, 0x00},   // 2b 09c7 92af Ã¨â€žÂ¹
    {0x7f, 0x15, 0x7f, 0x24, 0x5f, 0x35, 0x77, 0x00},   // 2b 09c8 92b0 Ã¨â€¦Â¸
    {0x4e, 0x7b, 0x5f, 0x32, 0x77, 0x36, 0x57, 0x00},   // 2b 09c9 92b1 Ã¨ÂÂ¶
    {0x6b, 0x62, 0x7f, 0x35, 0x2f, 0x35, 0x7f, 0x00},   // 2b 09ca 92b2 Ã¨ÂªÂ¿
    {0x6b, 0x62, 0x5f, 0x32, 0x77, 0x36, 0x57, 0x00},   // 2b 09cb 92b3 Ã¨Â«Å“
    {0x4a, 0x3a, 0x3f, 0x4a, 0x75, 0x53, 0x77, 0x00},   // 2b 09cc 92b4 Ã¨Â¶â€¦
    {0x77, 0x7d, 0x57, 0x3f, 0x00, 0x7f, 0x4a, 0x00},   // 2b 09cd 92b5 Ã¨Â·Â³
    {0x56, 0x7d, 0x76, 0x3f, 0x00, 0x7f, 0x4a, 0x00},   // 2b 09ce 92b6 Ã©Å Å¡
    {0x10, 0x50, 0x7f, 0x55, 0x35, 0x51, 0x50, 0x00},   // 2b 09cf 92b7 Ã©â€¢Â·
    {0x21, 0x3f, 0x01, 0x5d, 0x17, 0x15, 0x5d, 0x00},   // 2b 09d0 92b8 Ã©Â â€š
    {0x40, 0x1e, 0x56, 0x17, 0x56, 0x16, 0x70, 0x00},   // 2b 09d1 92b9 Ã©Â³Â¥
    {0x42, 0x2e, 0x7f, 0x2a, 0x6e, 0x1f, 0x7e, 0x00},   // 2b 09d2 92ba Ã¥â€¹â€¦
    {0x52, 0x7f, 0x18, 0x4e, 0x58, 0x2f, 0x1a, 0x00},   // 2b 09d3 92bb Ã¦Ââ€”
    {0x7a, 0x42, 0x7a, 0x6f, 0x6a, 0x7a, 0x42, 0x00},   // 2b 09d4 92bc Ã§â€ºÂ´
    {0x7f, 0x15, 0x7f, 0x54, 0x55, 0x3c, 0x55, 0x00},   // 2b 09d5 92bd Ã¦Å“â€¢
    {0x65, 0x10, 0x46, 0x22, 0x1f, 0x7a, 0x46, 0x00},   // 2b 09d6 92be Ã¦Â²Ë†
    {0x2a, 0x3e, 0x04, 0x42, 0x55, 0x2a, 0x14, 0x00},   // 2b 09d7 92bf Ã§ÂÂ
    {0x44, 0x4e, 0x35, 0x36, 0x3e, 0x75, 0x44, 0x00},   // 2b 09d8 92c0 Ã¨Â³Æ’
    {0x56, 0x7d, 0x36, 0x52, 0x1e, 0x1f, 0x52, 0x00},   // 2b 09d9 92c1 Ã©Å½Â®
    {0x7f, 0x1b, 0x42, 0x2e, 0x7f, 0x2e, 0x42, 0x00},   // 2b 09da 92c2 Ã©â„¢Â³
    {0x75, 0x00, 0x2a, 0x2a, 0x7f, 0x2e, 0x24, 0x00},   // 2b 09db 92c3 Ã¦Â´Â¥
    {0x5f, 0x4b, 0x4a, 0x77, 0x5e, 0x4b, 0x56, 0x00},   // 2b 09dc 92c4 Ã¥Â¢Å“
    {0x1a, 0x7f, 0x04, 0x7f, 0x4a, 0x7f, 0x4a, 0x00},   // 2b 09dd 92c5 Ã¦Â¤Å½
    {0x1a, 0x7f, 0x4a, 0x39, 0x40, 0x7e, 0x77, 0x00},   // 2b 09de 92c6 Ã¦Â§Å’
    {0x49, 0x3a, 0x40, 0x7e, 0x57, 0x56, 0x76, 0x00},   // 2b 09df 92c7 Ã¨Â¿Â½
    {0x56, 0x7d, 0x2e, 0x79, 0x40, 0x7e, 0x77, 0x00},   // 2b 09e0 92c8 Ã©Å½Å¡
    {0x54, 0x3e, 0x7a, 0x2a, 0x7b, 0x2e, 0x7a, 0x00},   // 2b 09e1 92c9 Ã§â€”â€º
    {0x49, 0x38, 0x7d, 0x55, 0x7d, 0x57, 0x7d, 0x00},   // 2b 09e2 92ca Ã©â‚¬Å¡
    {0x24, 0x3f, 0x2b, 0x5d, 0x7d, 0x35, 0x4b, 0x00},   // 2b 09e3 92cb Ã¥Â¡Å¡
    {0x1a, 0x7f, 0x38, 0x2f, 0x69, 0x7f, 0x28, 0x00},   // 2b 09e4 92cc Ã¦Â â€š
    {0x52, 0x7f, 0x41, 0x6b, 0x7f, 0x6b, 0x7f, 0x00},   // 2b 09e5 92cd Ã¦Å½Â´
    {0x1a, 0x7f, 0x2a, 0x1f, 0x6a, 0x3f, 0x5f, 0x00},   // 2b 09e6 92ce Ã¦Â§Â»
    {0x04, 0x7e, 0x7f, 0x49, 0x7f, 0x49, 0x7f, 0x00},   // 2b 09e7 92cf Ã¤Â½Æ’
    {0x75, 0x00, 0x48, 0x3a, 0x3f, 0x3a, 0x48, 0x00},   // 2b 09e8 92d0 Ã¦Â¼Â¬
    {0x1a, 0x7f, 0x0a, 0x11, 0x7f, 0x49, 0x79, 0x00},   // 2b 09e9 92d1 Ã¦Å¸Ëœ
    {0x49, 0x38, 0x44, 0x44, 0x7f, 0x44, 0x44, 0x00},   // 2b 09ea 92d2 Ã¨Â¾Â»
    {0x42, 0x1a, 0x5b, 0x1e, 0x5b, 0x12, 0x72, 0x00},   // 2b 09eb 92d3 Ã¨â€Â¦
    {0x2a, 0x75, 0x5d, 0x2b, 0x5d, 0x2b, 0x5d, 0x00},   // 2b 09ec 92d4 Ã§Â¶Â´
    {0x56, 0x7d, 0x36, 0x0b, 0x3f, 0x2c, 0x6b, 0x00},   // 2b 09ed 92d5 Ã©Ââ€
    {0x1a, 0x7f, 0x2a, 0x1e, 0x6f, 0x7e, 0x2a, 0x00},   // 2b 09ee 92d6 Ã¦Â¤Â¿
    {0x75, 0x00, 0x4e, 0x3a, 0x3f, 0x3a, 0x4e, 0x00},   // 2b 09ef 92d7 Ã¦Â½Â°
    {0x24, 0x3f, 0x15, 0x11, 0x7f, 0x11, 0x15, 0x00},   // 2b 09f0 92d8 Ã¥ÂÂª
    {0x5a, 0x6a, 0x7a, 0x6f, 0x7a, 0x6a, 0x5a, 0x00},   // 2b 09f1 92d9 Ã¥Â£Â·
    {0x5f, 0x3c, 0x66, 0x2b, 0x7f, 0x2b, 0x66, 0x00},   // 2b 09f2 92da Ã¥Â¬Â¬
    {0x2a, 0x75, 0x7e, 0x4a, 0x7f, 0x4a, 0x7e, 0x00},   // 2b 09f3 92db Ã§Â´Â¬
    {0x40, 0x3e, 0x02, 0x7e, 0x01, 0x3d, 0x40, 0x00},   // 2b 09f4 92dc Ã§Ë†Âª
    {0x38, 0x0f, 0x0d, 0x7d, 0x0d, 0x2f, 0x38, 0x00},   // 2b 09f5 92dd Ã¥ÂÅ 
    {0x56, 0x7d, 0x36, 0x04, 0x0b, 0x52, 0x7e, 0x00},   // 2b 09f6 92de Ã©â€¡Â£
    {0x16, 0x7a, 0x7f, 0x06, 0x5e, 0x17, 0x76, 0x00},   // 2b 09f7 92df Ã©Â¶Â´
    {0x1a, 0x0e, 0x5a, 0x7b, 0x1a, 0x0e, 0x1a, 0x00},   // 2b 09f8 92e0 Ã¤ÂºÂ­
    {0x04, 0x7e, 0x41, 0x7e, 0x4a, 0x5e, 0x69, 0x00},   // 2b 09f9 92e1 Ã¤Â½Å½
    {0x04, 0x7e, 0x0b, 0x5e, 0x7b, 0x1e, 0x1a, 0x00},   // 2b 09fa 92e2 Ã¥ÂÅ“
    {0x04, 0x7e, 0x41, 0x3c, 0x37, 0x3e, 0x42, 0x00},   // 2b 09fb 92e3 Ã¥ÂÂµ
    {0x5a, 0x2b, 0x7e, 0x2b, 0x6e, 0x00, 0x7f, 0x00},   // 2b 09fc 92e4 Ã¥â€°Æ’
    {0x40, 0x7c, 0x34, 0x37, 0x36, 0x7e, 0x42, 0x00},   // 2b 09fd 92e5 Ã¨Â²Å¾
    {0x44, 0x57, 0x55, 0x7d, 0x55, 0x57, 0x44, 0x00},   // 2b 09fe 92e6 Ã¥â€˜Ë†
    {0x24, 0x3f, 0x44, 0x34, 0x47, 0x7f, 0x54, 0x00},   // 2b 09ff 92e7 Ã¥Â Â¤
    {0x46, 0x32, 0x46, 0x7f, 0x56, 0x52, 0x46, 0x00},   // 2b 0a00 92e8 Ã¥Â®Å¡
    {0x1a, 0x6a, 0x2e, 0x7b, 0x2a, 0x6e, 0x1a, 0x00},   // 2b 0a01 92e9 Ã¥Â¸Â
    {0x40, 0x3e, 0x42, 0x7e, 0x57, 0x3e, 0x56, 0x00},   // 2b 0a02 92ea Ã¥Âºâ€¢
    {0x40, 0x3e, 0x56, 0x2e, 0x53, 0x7a, 0x56, 0x00},   // 2b 0a03 92eb Ã¥ÂºÂ­
    {0x55, 0x3b, 0x48, 0x6a, 0x7e, 0x69, 0x48, 0x00},   // 2b 0a04 92ec Ã¥Â»Â·
    {0x42, 0x5a, 0x2b, 0x7e, 0x2a, 0x2b, 0x6e, 0x00},   // 2b 0a05 92ed Ã¥Â¼Å¸
    {0x06, 0x7f, 0x5a, 0x2b, 0x7e, 0x2b, 0x6e, 0x00},   // 2b 0a06 92ee Ã¦â€šÅ’
    {0x52, 0x7f, 0x40, 0x7e, 0x4a, 0x5e, 0x69, 0x00},   // 2b 0a07 92ef Ã¦Å Âµ
    {0x52, 0x7f, 0x55, 0x3b, 0x6a, 0x7e, 0x69, 0x00},   // 2b 0a08 92f0 Ã¦Å’Âº
    {0x52, 0x7f, 0x42, 0x34, 0x47, 0x7f, 0x54, 0x00},   // 2b 0a09 92f1 Ã¦ÂÂ
    {0x1a, 0x7f, 0x5a, 0x2b, 0x7e, 0x2b, 0x6e, 0x00},   // 2b 0a0a 92f2 Ã¦Â¢Â¯
    {0x65, 0x10, 0x01, 0x41, 0x7f, 0x01, 0x01, 0x00},   // 2b 0a0b 92f3 Ã¦Â±â‚¬
    {0x09, 0x37, 0x31, 0x46, 0x2a, 0x7b, 0x56, 0x00},   // 2b 0a0c 92f4 Ã§Â¢â€¡
    {0x12, 0x7b, 0x16, 0x40, 0x3c, 0x3f, 0x42, 0x00},   // 2b 0a0d 92f5 Ã§Â¦Å½
    {0x35, 0x7f, 0x44, 0x57, 0x7d, 0x57, 0x44, 0x00},   // 2b 0a0e 92f6 Ã§Â¨â€¹
    {0x2a, 0x75, 0x1a, 0x6e, 0x3b, 0x6e, 0x1a, 0x00},   // 2b 0a0f 92f7 Ã§Â·Â 
    {0x7e, 0x7f, 0x55, 0x3b, 0x6a, 0x7e, 0x69, 0x00},   // 2b 0a10 92f8 Ã¨â€°â€¡
    {0x6a, 0x6b, 0x6a, 0x01, 0x41, 0x7f, 0x01, 0x00},   // 2b 0a11 92f9 Ã¨Â¨â€š
    {0x6b, 0x62, 0x1a, 0x6e, 0x3b, 0x6e, 0x1a, 0x00},   // 2b 0a12 92fa Ã¨Â«Â¦
    {0x77, 0x7d, 0x1b, 0x6e, 0x3b, 0x6e, 0x1a, 0x00},   // 2b 0a13 92fb Ã¨Â¹â€ž
    {0x49, 0x3a, 0x60, 0x5e, 0x4a, 0x7e, 0x59, 0x00},   // 2b 0a14 92fc Ã©â‚¬â€œ
    {0x7e, 0x4a, 0x5e, 0x29, 0x40, 0x7f, 0x1b, 0x00},   // 2c 0a15 9340 Ã©â€šÂ¸
    {0x5e, 0x57, 0x32, 0x57, 0x5e, 0x7f, 0x1b, 0x00},   // 2c 0a16 9341 Ã©â€žÂ­
    {0x56, 0x7d, 0x36, 0x01, 0x41, 0x7f, 0x01, 0x00},   // 2c 0a17 9342 Ã©â€¡Ëœ
    {0x4f, 0x28, 0x7f, 0x07, 0x7f, 0x28, 0x6f, 0x00},   // 2c 0a18 9343 Ã©Â¼Å½
    {0x75, 0x40, 0x3f, 0x05, 0x7d, 0x55, 0x57, 0x00},   // 2c 0a19 9344 Ã¦Â³Â¥
    {0x52, 0x7f, 0x7a, 0x6e, 0x5b, 0x6e, 0x7a, 0x00},   // 2c 0a1a 9345 Ã¦â€˜Ëœ
    {0x52, 0x7f, 0x25, 0x7f, 0x50, 0x7d, 0x57, 0x00},   // 2c 0a1b 9346 Ã¦â€œÂ¢
    {0x7a, 0x6e, 0x5b, 0x6e, 0x7c, 0x23, 0x5e, 0x00},   // 2c 0a1c 9347 Ã¦â€¢Âµ
    {0x75, 0x00, 0x7a, 0x6e, 0x5b, 0x6e, 0x7a, 0x00},   // 2c 0a1d 9348 Ã¦Â»Â´
    {0x3e, 0x2b, 0x3e, 0x04, 0x0b, 0x52, 0x7e, 0x00},   // 2c 0a1e 9349 Ã§Å¡â€ž
    {0x04, 0x73, 0x56, 0x7c, 0x53, 0x76, 0x02, 0x00},   // 2c 0a1f 934a Ã§Â¬â€º
    {0x49, 0x38, 0x7a, 0x6e, 0x5b, 0x6e, 0x7a, 0x00},   // 2c 0a20 934b Ã©ÂÂ©
    {0x56, 0x7d, 0x7a, 0x6e, 0x5b, 0x6e, 0x7a, 0x00},   // 2c 0a21 934c Ã©Ââ€˜
    {0x75, 0x20, 0x5d, 0x77, 0x20, 0x5d, 0x77, 0x00},   // 2c 0a22 934d Ã¦ÂºÂº
    {0x0a, 0x7f, 0x50, 0x5e, 0x56, 0x7d, 0x04, 0x00},   // 2c 0a23 934e Ã¥â€œÂ²
    {0x0a, 0x7d, 0x0a, 0x77, 0x72, 0x3f, 0x5e, 0x00},   // 2c 0a24 934f Ã¥Â¾Â¹
    {0x52, 0x7f, 0x0a, 0x77, 0x72, 0x3f, 0x5e, 0x00},   // 2c 0a25 9350 Ã¦â€™Â¤
    {0x2d, 0x7f, 0x0a, 0x77, 0x72, 0x3f, 0x5e, 0x00},   // 2c 0a26 9351 Ã¨Â½Â
    {0x49, 0x38, 0x44, 0x6b, 0x6a, 0x5f, 0x6a, 0x00},   // 2c 0a27 9352 Ã¨Â¿Â­
    {0x56, 0x7d, 0x4e, 0x2b, 0x1f, 0x2a, 0x48, 0x00},   // 2c 0a28 9353 Ã©â€°â€ž
    {0x50, 0x5e, 0x1f, 0x1a, 0x1f, 0x5e, 0x50, 0x00},   // 2c 0a29 9354 Ã¥â€¦Â¸
    {0x24, 0x3f, 0x52, 0x1e, 0x1f, 0x1e, 0x52, 0x00},   // 2c 0a2a 9355 Ã¥Â¡Â«
    {0x41, 0x45, 0x25, 0x1f, 0x25, 0x45, 0x41, 0x00},   // 2c 0a2b 9356 Ã¥Â¤Â©
    {0x40, 0x3f, 0x75, 0x5d, 0x35, 0x5d, 0x57, 0x00},   // 2c 0a2c 9357 Ã¥Â±â€¢
    {0x40, 0x3e, 0x02, 0x62, 0x7f, 0x6a, 0x6a, 0x00},   // 2c 0a2d 9358 Ã¥Âºâ€”
    {0x75, 0x00, 0x54, 0x0e, 0x76, 0x0d, 0x54, 0x00},   // 2c 0a2e 9359 Ã¦Â·Â»
    {0x2a, 0x75, 0x3e, 0x5a, 0x6f, 0x5e, 0x5a, 0x00},   // 2c 0a2f 935a Ã§ÂºÂ
    {0x76, 0x5e, 0x75, 0x02, 0x7f, 0x4a, 0x7f, 0x00},   // 2c 0a30 935b Ã§â€Å“
    {0x5f, 0x15, 0x5f, 0x70, 0x5f, 0x54, 0x74, 0x00},   // 2c 0a31 935c Ã¨Â²Â¼
    {0x2d, 0x7f, 0x44, 0x65, 0x5d, 0x25, 0x44, 0x00},   // 2c 0a32 935d Ã¨Â»Â¢
    {0x52, 0x1e, 0x1f, 0x52, 0x1d, 0x17, 0x5d, 0x00},   // 2c 0a33 935e Ã©Â¡â€º
    {0x40, 0x18, 0x58, 0x1f, 0x5a, 0x1a, 0x40, 0x00},   // 2c 0a34 935f Ã§â€šÂ¹
    {0x04, 0x7e, 0x45, 0x65, 0x5d, 0x25, 0x44, 0x00},   // 2c 0a35 9360 Ã¤Â¼Â
    {0x40, 0x3f, 0x5d, 0x15, 0x5b, 0x29, 0x5b, 0x00},   // 2c 0a36 9361 Ã¦Â®Â¿
    {0x75, 0x3f, 0x5d, 0x15, 0x5b, 0x29, 0x5b, 0x00},   // 2c 0a37 9362 Ã¦Â¾Â±
    {0x7f, 0x49, 0x49, 0x7f, 0x49, 0x49, 0x7f, 0x00},   // 2c 0a38 9363 Ã§â€Â°
    {0x06, 0x3a, 0x2f, 0x3f, 0x6b, 0x7e, 0x46, 0x00},   // 2c 0a39 9364 Ã©â€ºÂ»
    {0x42, 0x5e, 0x36, 0x1e, 0x75, 0x5d, 0x60, 0x00},   // 2c 0a3a 9365 Ã¥â€¦Å½
    {0x1e, 0x12, 0x5e, 0x44, 0x7f, 0x44, 0x40, 0x00},   // 2c 0a3b 9366 Ã¥ÂÂ
    {0x24, 0x3f, 0x28, 0x1a, 0x6f, 0x6a, 0x69, 0x00},   // 2c 0a3c 9367 Ã¥Â Âµ
    {0x55, 0x40, 0x54, 0x76, 0x5d, 0x46, 0x54, 0x00},   // 2c 0a3d 9368 Ã¥Â¡â€”
    {0x5c, 0x37, 0x2c, 0x11, 0x7f, 0x49, 0x79, 0x00},   // 2c 0a3e 9369 Ã¥Â¦Â¬
    {0x40, 0x3f, 0x53, 0x37, 0x7f, 0x77, 0x13, 0x00},   // 2c 0a3f 936a Ã¥Â±Â 
    {0x0a, 0x7d, 0x48, 0x2a, 0x7f, 0x5a, 0x48, 0x00},   // 2c 0a40 936b Ã¥Â¾â€™
    {0x20, 0x25, 0x2a, 0x20, 0x7f, 0x10, 0x10, 0x00},   // 2c 0a41 936c Ã¦â€“â€”
    {0x1a, 0x7f, 0x4a, 0x44, 0x7f, 0x44, 0x40, 0x00},   // 2c 0a42 936d Ã¦ÂÅ“
    {0x75, 0x40, 0x3e, 0x4a, 0x5f, 0x2e, 0x5a, 0x00},   // 2c 0a43 936e Ã¦Â¸Â¡
    {0x4a, 0x45, 0x5b, 0x69, 0x5a, 0x45, 0x4a, 0x00},   // 2c 0a44 936f Ã§â„¢Â»
    {0x4a, 0x5a, 0x37, 0x1e, 0x77, 0x5e, 0x62, 0x00},   // 2c 0a45 9370 Ã¨ÂÅ¸
    {0x5f, 0x15, 0x5f, 0x28, 0x1a, 0x6f, 0x6a, 0x00},   // 2c 0a46 9371 Ã¨Â³Â­
    {0x49, 0x38, 0x54, 0x46, 0x7d, 0x46, 0x54, 0x00},   // 2c 0a47 9372 Ã©â‚¬â€
    {0x28, 0x1a, 0x6f, 0x6a, 0x7f, 0x25, 0x1b, 0x00},   // 2c 0a48 9373 Ã©Æ’Â½
    {0x56, 0x7d, 0x3e, 0x4a, 0x5f, 0x2e, 0x5a, 0x00},   // 2c 0a49 9374 Ã©ÂÂ
    {0x09, 0x37, 0x31, 0x7e, 0x4a, 0x5e, 0x69, 0x00},   // 2c 0a4a 9375 Ã§Â Â¥
    {0x09, 0x37, 0x71, 0x3f, 0x65, 0x1d, 0x75, 0x00},   // 2c 0a4b 9376 Ã§Â Âº
    {0x12, 0x4e, 0x5b, 0x36, 0x5b, 0x75, 0x0b, 0x00},   // 2c 0a4c 9377 Ã¥Å Âª
    {0x40, 0x3e, 0x4a, 0x5e, 0x2b, 0x5e, 0x4a, 0x00},   // 2c 0a4d 9378 Ã¥ÂºÂ¦
    {0x40, 0x44, 0x44, 0x7f, 0x44, 0x44, 0x40, 0x00},   // 2c 0a4e 9379 Ã¥Å“Å¸
    {0x44, 0x5c, 0x37, 0x2c, 0x4d, 0x31, 0x4f, 0x00},   // 2c 0a4f 937a Ã¥Â¥Â´
    {0x6a, 0x2e, 0x4b, 0x46, 0x6b, 0x05, 0x6b, 0x00},   // 2c 0a50 937b Ã¦â‚¬â€™
    {0x04, 0x7e, 0x2d, 0x3b, 0x29, 0x4e, 0x7f, 0x00},   // 2c 0a51 937c Ã¥â‚¬â€™
    {0x46, 0x43, 0x3e, 0x17, 0x7e, 0x43, 0x66, 0x00},   // 2c 0a52 937d Ã¥â€¦Å¡
    {0x10, 0x12, 0x2a, 0x35, 0x4b, 0x50, 0x10, 0x00},   // 2c 0a53 937e Ã¥â€ Â¬
    {0x61, 0x10, 0x42, 0x2e, 0x7f, 0x2e, 0x42, 0x00},   // 2d 0a54 9380 Ã¥â€¡Â
    {0x41, 0x21, 0x19, 0x07, 0x01, 0x41, 0x7f, 0x00},   // 2d 0a55 9381 Ã¥Ë†â‚¬
    {0x40, 0x3e, 0x12, 0x76, 0x5f, 0x7e, 0x0a, 0x00},   // 2d 0a56 9382 Ã¥â€Â
    {0x24, 0x3f, 0x12, 0x7b, 0x56, 0x7b, 0x12, 0x00},   // 2d 0a57 9383 Ã¥Â¡â€
    {0x24, 0x3f, 0x7e, 0x12, 0x77, 0x5e, 0x6a, 0x00},   // 2d 0a58 9384 Ã¥Â¡Ëœ
    {0x5a, 0x56, 0x7e, 0x5b, 0x52, 0x36, 0x5a, 0x00},   // 2d 0a59 9385 Ã¥Â¥â€”
    {0x46, 0x2a, 0x7a, 0x6b, 0x6a, 0x6a, 0x06, 0x00},   // 2d 0a5a 9386 Ã¥Â®â€¢
    {0x60, 0x5e, 0x76, 0x57, 0x76, 0x16, 0x70, 0x00},   // 2d 0a5b 9387 Ã¥Â³Â¶
    {0x38, 0x3f, 0x58, 0x1e, 0x57, 0x16, 0x70, 0x00},   // 2d 0a5c 9388 Ã¥Â¶â€¹
    {0x06, 0x7f, 0x22, 0x3c, 0x77, 0x3e, 0x22, 0x00},   // 2d 0a5d 9389 Ã¦â€šÂ¼
    {0x52, 0x7f, 0x44, 0x5b, 0x29, 0x5f, 0x44, 0x00},   // 2d 0a5e 938a Ã¦Å â€¢
    {0x52, 0x7f, 0x12, 0x7b, 0x56, 0x7b, 0x12, 0x00},   // 2d 0a5f 938b Ã¦ÂÂ­
    {0x42, 0x5e, 0x2a, 0x7f, 0x2a, 0x5e, 0x42, 0x00},   // 2d 0a60 938c Ã¦ÂÂ±
    {0x1a, 0x7f, 0x4a, 0x3f, 0x00, 0x7f, 0x4a, 0x00},   // 2d 0a61 938d Ã¦Â¡Æ’
    {0x1a, 0x7f, 0x34, 0x5e, 0x17, 0x7e, 0x14, 0x00},   // 2d 0a62 938e Ã¦Â¢Â¼
    {0x1a, 0x7f, 0x42, 0x2e, 0x7f, 0x2e, 0x42, 0x00},   // 2d 0a63 938f Ã¦Â£Å¸
    {0x49, 0x70, 0x54, 0x7b, 0x56, 0x7a, 0x46, 0x00},   // 2d 0a64 9390 Ã§â€ºâ€”
    {0x75, 0x00, 0x64, 0x4b, 0x7e, 0x6a, 0x7e, 0x00},   // 2d 0a65 9391 Ã¦Â·Ëœ
    {0x75, 0x00, 0x24, 0x5f, 0x35, 0x57, 0x74, 0x00},   // 2d 0a66 9392 Ã¦Â¹Â¯
    {0x75, 0x50, 0x34, 0x5e, 0x17, 0x7e, 0x14, 0x00},   // 2d 0a67 9393 Ã¦Â¶â€º
    {0x4c, 0x3f, 0x24, 0x01, 0x41, 0x7f, 0x01, 0x00},   // 2d 0a68 9394 Ã§ÂÂ¯
    {0x4c, 0x3f, 0x45, 0x5b, 0x69, 0x5a, 0x45, 0x00},   // 2d 0a69 9395 Ã§â€¡Ë†
    {0x00, 0x45, 0x56, 0x57, 0x54, 0x56, 0x7d, 0x00},   // 2d 0a6a 9396 Ã¥Â½â€œ
    {0x54, 0x3e, 0x02, 0x5e, 0x77, 0x76, 0x5e, 0x00},   // 2d 0a6b 9397 Ã§â€”Ëœ
    {0x12, 0x7b, 0x36, 0x5e, 0x17, 0x7e, 0x14, 0x00},   // 2d 0a6c 9398 Ã§Â¥Â·
    {0x14, 0x13, 0x36, 0x5c, 0x7b, 0x16, 0x12, 0x00},   // 2d 0a6d 9399 Ã§Â­â€°
    {0x14, 0x13, 0x6e, 0x6c, 0x6b, 0x16, 0x12, 0x00},   // 2d 0a6e 939a Ã§Â­â€
    {0x7c, 0x0b, 0x6e, 0x6c, 0x6b, 0x0e, 0x7a, 0x00},   // 2d 0a6f 939b Ã§Â­â€™
    {0x35, 0x7e, 0x3e, 0x12, 0x77, 0x5e, 0x6a, 0x00},   // 2d 0a70 939c Ã§Â³â€“
    {0x2a, 0x75, 0x4a, 0x3e, 0x0b, 0x76, 0x4a, 0x00},   // 2d 0a71 939d Ã§ÂµÂ±
    {0x49, 0x5d, 0x3b, 0x2d, 0x0e, 0x40, 0x7f, 0x00},   // 2d 0a72 939e Ã¥Ë†Â°
    {0x4a, 0x7a, 0x6f, 0x7e, 0x6f, 0x7a, 0x4a, 0x00},   // 2d 0a73 939f Ã¨â€˜Â£
    {0x56, 0x02, 0x53, 0x3e, 0x5b, 0x3e, 0x72, 0x00},   // 2d 0a74 93a0 Ã¨â€¢Â©
    {0x7a, 0x2a, 0x7f, 0x2a, 0x77, 0x2a, 0x56, 0x00},   // 2d 0a75 93a1 Ã¨â€”Â¤
    {0x6a, 0x6b, 0x00, 0x0a, 0x52, 0x7f, 0x02, 0x00},   // 2d 0a76 93a2 Ã¨Â¨Å½
    {0x7f, 0x15, 0x7f, 0x15, 0x6c, 0x6f, 0x15, 0x00},   // 2d 0a77 93a3 Ã¨Â¬â€ž
    {0x41, 0x5d, 0x75, 0x55, 0x75, 0x5d, 0x41, 0x00},   // 2d 0a78 93a4 Ã¨Â±â€ 
    {0x77, 0x7d, 0x2b, 0x76, 0x5f, 0x74, 0x0a, 0x00},   // 2d 0a79 93a5 Ã¨Â¸Â
    {0x49, 0x38, 0x6a, 0x5f, 0x40, 0x7f, 0x6a, 0x00},   // 2d 0a7a 93a6 Ã©â‚¬Æ’
    {0x49, 0x38, 0x4a, 0x67, 0x5f, 0x77, 0x4a, 0x00},   // 2d 0a7b 93a7 Ã©â‚¬Â
    {0x56, 0x7d, 0x47, 0x5b, 0x69, 0x5a, 0x45, 0x00},   // 2d 0a7c 93a8 Ã©Ââ„¢
    {0x7f, 0x1b, 0x64, 0x4b, 0x7e, 0x6a, 0x7e, 0x00},   // 2d 0a7d 93a9 Ã©â„¢Â¶
    {0x2d, 0x35, 0x2d, 0x40, 0x1d, 0x17, 0x5d, 0x00},   // 2d 0a7e 93aa Ã©Â Â­
    {0x7f, 0x15, 0x7f, 0x45, 0x1c, 0x5f, 0x75, 0x00},   // 2d 0a7f 93ab Ã©Â¨Â°
    {0x7f, 0x5b, 0x6b, 0x58, 0x13, 0x7b, 0x7f, 0x00},   // 2d 0a80 93ac Ã©â€”Ëœ
    {0x04, 0x7e, 0x2d, 0x3f, 0x62, 0x1f, 0x7e, 0x00},   // 2d 0a81 93ad Ã¥Æ’Â
    {0x5d, 0x7f, 0x5d, 0x42, 0x3f, 0x42, 0x7e, 0x00},   // 2d 0a82 93ae Ã¥â€¹â€¢
    {0x7f, 0x01, 0x75, 0x55, 0x75, 0x01, 0x7f, 0x00},   // 2d 0a83 93af Ã¥ÂÅ’
    {0x46, 0x53, 0x5e, 0x7b, 0x5e, 0x53, 0x46, 0x00},   // 2d 0a84 93b0 Ã¥Â â€š
    {0x14, 0x1d, 0x32, 0x5f, 0x7e, 0x1f, 0x12, 0x00},   // 2d 0a85 93b1 Ã¥Â°Å½
    {0x06, 0x7f, 0x4a, 0x5e, 0x7b, 0x5e, 0x4a, 0x00},   // 2d 0a86 93b2 Ã¦â€ Â§
    {0x52, 0x7f, 0x4a, 0x5e, 0x7b, 0x5e, 0x4a, 0x00},   // 2d 0a87 93b3 Ã¦â€™Å¾
    {0x75, 0x00, 0x7f, 0x35, 0x35, 0x41, 0x7f, 0x00},   // 2d 0a88 93b4 Ã¦Â´Å¾
    {0x7f, 0x55, 0x7f, 0x5e, 0x7b, 0x5e, 0x4a, 0x00},   // 2d 0a89 93b5 Ã§Å¾Â³
    {0x48, 0x5a, 0x5e, 0x7b, 0x5e, 0x5a, 0x48, 0x00},   // 2d 0a8a 93b6 Ã§Â«Â¥
    {0x7f, 0x15, 0x7f, 0x7f, 0x35, 0x35, 0x7f, 0x00},   // 2d 0a8b 93b7 Ã¨Æ’Â´
    {0x12, 0x6e, 0x57, 0x7e, 0x57, 0x66, 0x7e, 0x00},   // 2d 0a8c 93b8 Ã¨Ââ€ž
    {0x49, 0x38, 0x42, 0x7b, 0x56, 0x7b, 0x42, 0x00},   // 2d 0a8d 93b9 Ã©Ââ€œ
    {0x56, 0x7d, 0x36, 0x7f, 0x35, 0x35, 0x7f, 0x00},   // 2d 0a8e 93ba Ã©Å â€¦
    {0x38, 0x3f, 0x38, 0x08, 0x7f, 0x1a, 0x2a, 0x00},   // 2d 0a8f 93bb Ã¥Â³Â 
    {0x2f, 0x7a, 0x2a, 0x5e, 0x17, 0x56, 0x70, 0x00},   // 2d 0a90 93bc Ã©Â´â€¡
    {0x7f, 0x55, 0x4f, 0x7d, 0x57, 0x75, 0x45, 0x00},   // 2d 0a91 93bd Ã¥Å’Â¿
    {0x0a, 0x7d, 0x14, 0x37, 0x55, 0x7f, 0x14, 0x00},   // 2d 0a92 93be Ã¥Â¾â€”
    {0x0a, 0x7d, 0x62, 0x2e, 0x4f, 0x4e, 0x62, 0x00},   // 2d 0a93 93bf Ã¥Â¾Â³
    {0x75, 0x00, 0x5a, 0x2a, 0x0f, 0x6a, 0x5a, 0x00},   // 2d 0a94 93c0 Ã¦Â¶Å“
    {0x17, 0x7f, 0x2a, 0x6a, 0x2f, 0x7a, 0x28, 0x00},   // 2d 0a95 93c1 Ã§â€°Â¹
    {0x0c, 0x74, 0x5f, 0x56, 0x5b, 0x75, 0x0b, 0x00},   // 2d 0a96 93c2 Ã§ÂÂ£
    {0x4a, 0x4a, 0x37, 0x0f, 0x77, 0x4a, 0x6a, 0x00},   // 2d 0a97 93c3 Ã§Â¦Â¿
    {0x44, 0x1b, 0x56, 0x1c, 0x57, 0x16, 0x72, 0x00},   // 2d 0a98 93c4 Ã§Â¯Â¤
    {0x28, 0x7a, 0x6a, 0x7f, 0x6a, 0x7a, 0x28, 0x00},   // 2d 0a99 93c5 Ã¦Â¯â€™
    {0x55, 0x4a, 0x3d, 0x4e, 0x7f, 0x4a, 0x6e, 0x00},   // 2d 0a9a 93c6 Ã§â€¹Â¬
    {0x6b, 0x62, 0x5a, 0x2a, 0x0f, 0x6a, 0x5a, 0x00},   // 2d 0a9b 93c7 Ã¨ÂªÂ­
    {0x1a, 0x7f, 0x4a, 0x3f, 0x65, 0x1d, 0x75, 0x00},   // 2d 0a9c 93c8 Ã¦Â Æ’
    {0x1a, 0x7f, 0x22, 0x5e, 0x7d, 0x2f, 0x50, 0x00},   // 2d 0a9d 93c9 Ã¦Â©Â¡
    {0x78, 0x48, 0x4f, 0x41, 0x4f, 0x48, 0x78, 0x00},   // 2d 0a9e 93ca Ã¥â€¡Â¸
    {0x56, 0x5a, 0x56, 0x33, 0x5e, 0x5a, 0x56, 0x00},   // 2d 0a9f 93cb Ã§ÂªÂ
    {0x1a, 0x7f, 0x7e, 0x15, 0x5b, 0x29, 0x5b, 0x00},   // 2d 0aa0 93cc Ã¦Â¤Â´
    {0x40, 0x3f, 0x75, 0x55, 0x7d, 0x55, 0x77, 0x00},   // 2d 0aa1 93cd Ã¥Â±Å 
    {0x42, 0x1a, 0x5a, 0x1e, 0x5b, 0x16, 0x7b, 0x00},   // 2d 0aa2 93ce Ã©Â³Â¶
    {0x02, 0x62, 0x63, 0x7e, 0x6b, 0x6a, 0x02, 0x00},   // 2d 0aa3 93cf Ã¨â€¹Â«
    {0x46, 0x7a, 0x2e, 0x3f, 0x2e, 0x7a, 0x46, 0x00},   // 2d 0aa4 93d0 Ã¥Â¯â€¦
    {0x7d, 0x75, 0x6f, 0x65, 0x7f, 0x75, 0x7d, 0x00},   // 2d 0aa5 93d1 Ã©â€¦â€°
    {0x75, 0x7a, 0x2f, 0x7a, 0x2a, 0x7d, 0x3b, 0x00},   // 2d 0aa6 93d2 Ã§â‚¬Å¾
    {0x1e, 0x12, 0x3f, 0x2a, 0x4d, 0x1f, 0x5d, 0x00},   // 2d 0aa7 93d3 Ã¥â„¢Â¸
    {0x02, 0x1a, 0x12, 0x7f, 0x52, 0x51, 0x59, 0x00},   // 2d 0aa8 93d4 Ã¥Â±Â¯
    {0x06, 0x7f, 0x22, 0x2e, 0x6b, 0x3e, 0x22, 0x00},   // 2d 0aa9 93d5 Ã¦Æ’â€¡
    {0x22, 0x2e, 0x7b, 0x1e, 0x5c, 0x23, 0x5e, 0x00},   // 2d 0aaa 93d6 Ã¦â€¢Â¦
    {0x75, 0x00, 0x1a, 0x12, 0x7f, 0x52, 0x5a, 0x00},   // 2d 0aab 93d7 Ã¦Â²Å’
    {0x7f, 0x15, 0x7f, 0x29, 0x57, 0x7d, 0x29, 0x00},   // 2d 0aac 93d8 Ã¨Â±Å¡
    {0x49, 0x3a, 0x50, 0x4e, 0x76, 0x7e, 0x75, 0x00},   // 2d 0aad 93d9 Ã©ÂÂ
    {0x1a, 0x12, 0x7f, 0x52, 0x5d, 0x17, 0x5d, 0x00},   // 2d 0aae 93da Ã©Â â€œ
    {0x14, 0x0e, 0x76, 0x56, 0x75, 0x0d, 0x14, 0x00},   // 2d 0aaf 93db Ã¥â€˜â€˜
    {0x4c, 0x57, 0x7d, 0x5d, 0x55, 0x2f, 0x4c, 0x00},   // 2d 0ab0 93dc Ã¦â€ºâ€¡
    {0x56, 0x7d, 0x1a, 0x12, 0x7f, 0x52, 0x5a, 0x00},   // 2d 0ab1 93dd Ã©Ë†Â
    {0x4a, 0x3a, 0x56, 0x73, 0x16, 0x3a, 0x4a, 0x00},   // 2d 0ab2 93de Ã¥Â¥Ë†
    {0x55, 0x3f, 0x55, 0x7f, 0x00, 0x7f, 0x1b, 0x00},   // 2d 0ab3 93df Ã©â€šÂ£
    {0x7e, 0x12, 0x0a, 0x07, 0x0a, 0x52, 0x7e, 0x00},   // 2d 0ab4 93e0 Ã¥â€ â€¦
    {0x08, 0x04, 0x03, 0x7e, 0x2a, 0x2a, 0x2a, 0x00},   // 2d 0ab5 93e1 Ã¤Â¹Â
    {0x40, 0x3f, 0x31, 0x3d, 0x29, 0x7f, 0x40, 0x00},   // 2d 0ab6 93e2 Ã¥â€¡Âª
    {0x52, 0x3e, 0x4b, 0x12, 0x7f, 0x7a, 0x56, 0x00},   // 2d 0ab7 93e3 Ã¨â€“â„¢
    {0x6b, 0x62, 0x79, 0x54, 0x4d, 0x7e, 0x55, 0x00},   // 2d 0ab8 93e4 Ã¨Â¬Å½
    {0x75, 0x5b, 0x3e, 0x5b, 0x7f, 0x7e, 0x55, 0x00},   // 2d 0ab9 93e5 Ã§ÂËœ
    {0x52, 0x7f, 0x4a, 0x16, 0x73, 0x16, 0x4a, 0x00},   // 2d 0aba 93e6 Ã¦ÂÂº
    {0x56, 0x7d, 0x36, 0x78, 0x0f, 0x69, 0x7f, 0x00},   // 2d 0abb 93e7 Ã©Ââ€¹
    {0x1a, 0x7f, 0x7a, 0x5f, 0x4a, 0x5f, 0x7a, 0x00},   // 2d 0abc 93e8 Ã¦Â¥Â¢
    {0x5f, 0x1f, 0x75, 0x3f, 0x1e, 0x00, 0x7f, 0x00},   // 2d 0abd 93e9 Ã©Â¦Â´
    {0x2a, 0x75, 0x28, 0x3f, 0x2d, 0x77, 0x5c, 0x00},   // 2d 0abe 93ea Ã§Â¸â€ž
    {0x3e, 0x3e, 0x5d, 0x2b, 0x5d, 0x2b, 0x5d, 0x00},   // 2d 0abf 93eb Ã§â€¢Â·
    {0x7a, 0x2a, 0x3a, 0x6f, 0x3a, 0x2a, 0x7a, 0x00},   // 2d 0ac0 93ec Ã¥Ââ€”
    {0x1a, 0x7f, 0x7a, 0x2a, 0x77, 0x2a, 0x7a, 0x00},   // 2d 0ac1 93ed Ã¦Â¥Â 
    {0x2d, 0x7f, 0x2d, 0x44, 0x43, 0x3e, 0x46, 0x00},   // 2d 0ac2 93ee Ã¨Â»Å¸
    {0x5a, 0x5f, 0x3a, 0x5f, 0x7f, 0x7e, 0x4b, 0x00},   // 2d 0ac3 93ef Ã©â€ºÂ£
    {0x75, 0x00, 0x44, 0x5c, 0x37, 0x2c, 0x44, 0x00},   // 2d 0ac4 93f0 Ã¦Â±Â
    {0x40, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x00},   // 2d 0ac5 93f1 Ã¤ÂºÅ’
    {0x40, 0x3f, 0x05, 0x7d, 0x55, 0x55, 0x57, 0x00},   // 2d 0ac6 93f2 Ã¥Â°Â¼
    {0x44, 0x4d, 0x2d, 0x24, 0x0f, 0x34, 0x45, 0x00},   // 2d 0ac7 93f3 Ã¥Â¼Â
    {0x49, 0x38, 0x54, 0x4b, 0x62, 0x7e, 0x52, 0x00},   // 2d 0ac8 93f4 Ã¨Â¿Â©
    {0x04, 0x03, 0x3e, 0x2a, 0x2a, 0x42, 0x7e, 0x00},   // 2d 0ac9 93f5 Ã¥Å’â€š
    {0x5f, 0x15, 0x5f, 0x7f, 0x51, 0x35, 0x55, 0x00},   // 2d 0aca 93f6 Ã¨Â³â€˜
    {0x7e, 0x02, 0x2a, 0x17, 0x2a, 0x42, 0x7e, 0x00},   // 2d 0acb 93f7 Ã¨â€šâ€°
    {0x4e, 0x7b, 0x4e, 0x42, 0x7e, 0x42, 0x40, 0x00},   // 2d 0acc 93f8 Ã¨â„¢Â¹
    {0x04, 0x04, 0x7f, 0x44, 0x44, 0x7f, 0x04, 0x00},   // 2d 0acd 93f9 Ã¥Â»Â¿
    {0x00, 0x7f, 0x49, 0x49, 0x49, 0x49, 0x7f, 0x00},   // 2d 0ace 93fa Ã¦â€”Â¥
    {0x22, 0x2a, 0x69, 0x3b, 0x21, 0x7f, 0x40, 0x00},   // 2d 0acf 93fb Ã¤Â¹Â³
    {0x40, 0x21, 0x19, 0x07, 0x18, 0x20, 0x40, 0x00},   // 2d 0ad0 93fc Ã¥â€¦Â¥
    {0x44, 0x5c, 0x37, 0x2c, 0x7e, 0x42, 0x7e, 0x00},   // 2e 0ad1 9440 Ã¥Â¦â€š
    {0x40, 0x3f, 0x55, 0x35, 0x7d, 0x25, 0x57, 0x00},   // 2e 0ad2 9441 Ã¥Â°Â¿
    {0x42, 0x56, 0x7f, 0x42, 0x7f, 0x56, 0x42, 0x00},   // 2e 0ad3 9442 Ã©Å¸Â®
    {0x04, 0x7e, 0x09, 0x4a, 0x7e, 0x49, 0x08, 0x00},   // 2e 0ad4 9443 Ã¤Â»Â»
    {0x44, 0x5c, 0x37, 0x2c, 0x4a, 0x7e, 0x49, 0x00},   // 2e 0ad5 9444 Ã¥Â¦Å 
    {0x68, 0x39, 0x4b, 0x55, 0x6b, 0x0f, 0x60, 0x00},   // 2e 0ad6 9445 Ã¥Â¿Â
    {0x6b, 0x62, 0x49, 0x2b, 0x45, 0x4b, 0x6f, 0x00},   // 2e 0ad7 9446 Ã¨ÂªÂ
    {0x75, 0x00, 0x66, 0x2b, 0x7f, 0x2b, 0x66, 0x00},   // 2e 0ad8 9447 Ã¦Â¿Â¡
    {0x12, 0x7b, 0x16, 0x7d, 0x57, 0x2f, 0x7d, 0x00},   // 2e 0ad9 9448 Ã§Â¦Â°
    {0x12, 0x7b, 0x16, 0x24, 0x5b, 0x7e, 0x32, 0x00},   // 2e 0ada 9449 Ã§Â¥Â¢
    {0x16, 0x1a, 0x56, 0x7b, 0x1e, 0x1a, 0x16, 0x00},   // 2e 0adb 944a Ã¥Â¯Â§
    {0x6a, 0x36, 0x4f, 0x56, 0x6f, 0x1e, 0x62, 0x00},   // 2e 0adc 944b Ã¨â€˜Â±
    {0x55, 0x3e, 0x7a, 0x5f, 0x7a, 0x5f, 0x7a, 0x00},   // 2e 0add 944c Ã§Å’Â«
    {0x54, 0x0e, 0x5f, 0x14, 0x4b, 0x1e, 0x50, 0x00},   // 2e 0ade 944d Ã§â€ Â±
    {0x24, 0x3b, 0x2a, 0x7e, 0x2a, 0x2a, 0x22, 0x00},   // 2e 0adf 944e Ã¥Â¹Â´
    {0x64, 0x24, 0x4a, 0x4d, 0x5e, 0x04, 0x64, 0x00},   // 2e 0ae0 944f Ã¥Â¿Âµ
    {0x52, 0x7f, 0x64, 0x2a, 0x4d, 0x5e, 0x64, 0x00},   // 2e 0ae1 9450 Ã¦ÂÂ»
    {0x52, 0x7f, 0x54, 0x0b, 0x56, 0x0f, 0x52, 0x00},   // 2e 0ae2 9451 Ã¦â€™Å¡
    {0x4c, 0x3f, 0x54, 0x0b, 0x56, 0x0f, 0x52, 0x00},   // 2e 0ae3 9452 Ã§â€¡Æ’
    {0x35, 0x7e, 0x15, 0x70, 0x5f, 0x54, 0x74, 0x00},   // 2e 0ae4 9453 Ã§Â²Ëœ
    {0x41, 0x31, 0x0f, 0x01, 0x07, 0x44, 0x7c, 0x00},   // 2e 0ae5 9454 Ã¤Â¹Æ’
    {0x55, 0x3b, 0x40, 0x7d, 0x6f, 0x67, 0x7d, 0x00},   // 2e 0ae6 9455 Ã¥Â»Â¼
    {0x40, 0x32, 0x22, 0x53, 0x4a, 0x46, 0x40, 0x00},   // 2e 0ae7 9456 Ã¤Â¹â€¹
    {0x4a, 0x56, 0x5f, 0x7a, 0x56, 0x5f, 0x4a, 0x00},   // 2e 0ae8 9457 Ã¥Å¸Å“
    {0x5a, 0x3e, 0x7a, 0x5f, 0x3a, 0x5e, 0x5a, 0x00},   // 2e 0ae9 9458 Ã¥Å¡Â¢
    {0x06, 0x7f, 0x79, 0x54, 0x49, 0x54, 0x7b, 0x00},   // 2e 0aea 9459 Ã¦â€šÂ©
    {0x75, 0x40, 0x36, 0x77, 0x56, 0x37, 0x56, 0x00},   // 2e 0aeb 945a Ã¦Â¿Æ’
    {0x2a, 0x75, 0x7e, 0x12, 0x0f, 0x52, 0x7e, 0x00},   // 2e 0aec 945b Ã§Â´Â
    {0x04, 0x7e, 0x2d, 0x7e, 0x00, 0x7f, 0x5a, 0x00},   // 2e 0aed 945c Ã¨Æ’Â½
    {0x7f, 0x15, 0x7f, 0x75, 0x49, 0x54, 0x7b, 0x00},   // 2e 0aee 945d Ã¨â€žÂ³
    {0x7f, 0x15, 0x7f, 0x76, 0x57, 0x36, 0x57, 0x00},   // 2e 0aef 945e Ã¨â€ Â¿
    {0x40, 0x36, 0x77, 0x56, 0x37, 0x56, 0x50, 0x00},   // 2e 0af0 945f Ã¨Â¾Â²
    {0x35, 0x35, 0x7f, 0x40, 0x3f, 0x75, 0x5f, 0x00},   // 2e 0af1 9460 Ã¨Â¦â€”
    {0x48, 0x59, 0x57, 0x7d, 0x55, 0x3b, 0x48, 0x00},   // 2e 0af2 9461 Ã¨Å¡Â¤
    {0x3f, 0x49, 0x49, 0x4f, 0x49, 0x4f, 0x60, 0x00},   // 2e 0af3 9462 Ã¥Â·Â´
    {0x52, 0x7f, 0x3f, 0x49, 0x4f, 0x49, 0x6f, 0x00},   // 2e 0af4 9463 Ã¦Å Å 
    {0x52, 0x7f, 0x15, 0x6f, 0x7d, 0x6f, 0x15, 0x00},   // 2e 0af5 9464 Ã¦â€™Â­
    {0x29, 0x77, 0x2d, 0x47, 0x3d, 0x2f, 0x79, 0x00},   // 2e 0af6 9465 Ã¨Â¦â€¡
    {0x1a, 0x7f, 0x3f, 0x49, 0x4f, 0x49, 0x6f, 0x00},   // 2e 0af7 9466 Ã¦ÂÂ·
    {0x75, 0x40, 0x3e, 0x5a, 0x2f, 0x5a, 0x46, 0x00},   // 2e 0af8 9467 Ã¦Â³Â¢
    {0x75, 0x40, 0x3e, 0x7a, 0x0a, 0x35, 0x55, 0x00},   // 2e 0af9 9468 Ã¦Â´Â¾
    {0x05, 0x3f, 0x55, 0x5c, 0x55, 0x5f, 0x65, 0x00},   // 2e 0afa 9469 Ã§ÂÂ¶
    {0x09, 0x37, 0x71, 0x3e, 0x5a, 0x2f, 0x5e, 0x00},   // 2e 0afb 946a Ã§Â Â´
    {0x55, 0x50, 0x78, 0x56, 0x3a, 0x57, 0x5a, 0x00},   // 2e 0afc 946b Ã¥Â©â€ 
    {0x47, 0x1d, 0x57, 0x1d, 0x57, 0x15, 0x77, 0x00},   // 2e 0afd 946c Ã§Â½Âµ
    {0x02, 0x3e, 0x57, 0x5e, 0x57, 0x5e, 0x62, 0x00},   // 2e 0afe 946d Ã¨Å Â­
    {0x40, 0x1f, 0x55, 0x1f, 0x55, 0x15, 0x71, 0x00},   // 2e 0aff 946e Ã©Â¦Â¬
    {0x0c, 0x7f, 0x2a, 0x7f, 0x00, 0x7f, 0x2a, 0x00},   // 2e 0b00 946f Ã¤Â¿Â³
    {0x40, 0x3e, 0x56, 0x4e, 0x37, 0x7a, 0x56, 0x00},   // 2e 0b01 9470 Ã¥Â»Æ’
    {0x52, 0x7f, 0x21, 0x2b, 0x7f, 0x2b, 0x21, 0x00},   // 2e 0b02 9471 Ã¦â€¹Â
    {0x52, 0x7f, 0x2a, 0x7f, 0x00, 0x7f, 0x2a, 0x00},   // 2e 0b03 9472 Ã¦Å½â€™
    {0x5f, 0x15, 0x5f, 0x04, 0x5f, 0x22, 0x5e, 0x00},   // 2e 0b04 9473 Ã¦â€¢â€”
    {0x1a, 0x7f, 0x11, 0x09, 0x7f, 0x09, 0x11, 0x00},   // 2e 0b05 9474 Ã¦ÂÂ¯
    {0x49, 0x79, 0x55, 0x7f, 0x51, 0x75, 0x49, 0x00},   // 2e 0b06 9475 Ã§â€ºÆ’
    {0x7f, 0x14, 0x77, 0x2e, 0x3f, 0x7a, 0x2e, 0x00},   // 2e 0b07 9476 Ã§â€°Å’
    {0x0a, 0x7a, 0x2f, 0x28, 0x2f, 0x7a, 0x0a, 0x00},   // 2e 0b08 9477 Ã¨Æ’Å’
    {0x7f, 0x15, 0x7f, 0x3a, 0x0a, 0x7f, 0x3a, 0x00},   // 2e 0b09 9478 Ã¨â€šÂº
    {0x2a, 0x3a, 0x2f, 0x78, 0x2f, 0x3a, 0x2a, 0x00},   // 2e 0b0a 9479 Ã¨Â¼Â©
    {0x7d, 0x6f, 0x7d, 0x00, 0x79, 0x49, 0x6f, 0x00},   // 2e 0b0b 947a Ã©â€¦Â
    {0x04, 0x7e, 0x0b, 0x6e, 0x6b, 0x6e, 0x0a, 0x00},   // 2e 0b0c 947b Ã¥â‚¬Â
    {0x24, 0x3f, 0x0a, 0x6e, 0x6b, 0x6e, 0x0a, 0x00},   // 2e 0b0d 947c Ã¥Å¸Â¹
    {0x5f, 0x3c, 0x52, 0x3f, 0x7a, 0x3f, 0x52, 0x00},   // 2e 0b0e 947d Ã¥Âªâ€™
    {0x1a, 0x7f, 0x14, 0x33, 0x2e, 0x7e, 0x12, 0x00},   // 2e 0b0f 947e Ã¦Â¢â€¦
    {0x1a, 0x7f, 0x52, 0x3f, 0x7a, 0x3f, 0x52, 0x00},   // 2f 0b10 9480 Ã¦Â¥Â³
    {0x4c, 0x3f, 0x52, 0x3f, 0x7a, 0x3f, 0x52, 0x00},   // 2f 0b11 9481 Ã§â€¦Â¤
    {0x55, 0x4a, 0x3d, 0x40, 0x1f, 0x15, 0x5f, 0x00},   // 2f 0b12 9482 Ã§â€¹Â½
    {0x47, 0x7d, 0x2f, 0x2d, 0x2f, 0x7d, 0x47, 0x00},   // 2f 0b13 9483 Ã¨Â²Â·
    {0x5a, 0x4a, 0x2a, 0x0f, 0x6a, 0x4a, 0x5a, 0x00},   // 2f 0b14 9484 Ã¥Â£Â²
    {0x5f, 0x15, 0x5f, 0x0e, 0x6b, 0x6e, 0x0a, 0x00},   // 2f 0b15 9485 Ã¨Â³Â 
    {0x7f, 0x25, 0x1b, 0x6e, 0x6b, 0x6e, 0x0a, 0x00},   // 2f 0b16 9486 Ã©â„¢Âª
    {0x49, 0x3a, 0x40, 0x62, 0x6b, 0x6b, 0x62, 0x00},   // 2f 0b17 9487 Ã©â‚¬â„¢
    {0x4e, 0x7b, 0x4e, 0x38, 0x2f, 0x77, 0x5c, 0x00},   // 2f 0b18 9488 Ã¨ÂÂ¿
    {0x35, 0x7f, 0x15, 0x11, 0x7f, 0x11, 0x15, 0x00},   // 2f 0b19 9489 Ã§Â§Â¤
    {0x4b, 0x3e, 0x2a, 0x5d, 0x77, 0x00, 0x7f, 0x00},   // 2f 0b1a 948a Ã§Å¸Â§
    {0x2a, 0x7a, 0x27, 0x5a, 0x43, 0x3e, 0x4a, 0x00},   // 2f 0b1b 948b Ã¨ÂÂ©
    {0x04, 0x7e, 0x01, 0x7e, 0x4b, 0x4a, 0x7e, 0x00},   // 2f 0b1c 948c Ã¤Â¼Â¯
    {0x54, 0x25, 0x7f, 0x24, 0x5e, 0x00, 0x7f, 0x00},   // 2f 0b1d 948d Ã¥â€°Â¥
    {0x04, 0x7f, 0x12, 0x3e, 0x5f, 0x7e, 0x13, 0x00},   // 2f 0b1e 948e Ã¥ÂÅ¡
    {0x52, 0x7f, 0x0a, 0x7e, 0x4b, 0x4a, 0x7e, 0x00},   // 2f 0b1f 948f Ã¦â€¹Â
    {0x1a, 0x7f, 0x0a, 0x7e, 0x4b, 0x4a, 0x7e, 0x00},   // 2f 0b20 9490 Ã¦Å¸Â
    {0x75, 0x00, 0x7e, 0x4a, 0x4b, 0x4a, 0x7e, 0x00},   // 2f 0b21 9491 Ã¦Â³Å 
    {0x00, 0x7e, 0x4a, 0x4b, 0x4a, 0x4a, 0x7e, 0x00},   // 2f 0b22 9492 Ã§â„¢Â½
    {0x54, 0x03, 0x76, 0x54, 0x5b, 0x56, 0x72, 0x00},   // 2f 0b23 9493 Ã§Â®â€
    {0x35, 0x7e, 0x15, 0x7e, 0x4b, 0x4a, 0x7e, 0x00},   // 2f 0b24 9494 Ã§Â²â€¢
    {0x7e, 0x13, 0x7e, 0x7e, 0x4b, 0x4a, 0x7e, 0x00},   // 2f 0b25 9495 Ã¨Ë†Â¶
    {0x56, 0x02, 0x13, 0x3e, 0x5f, 0x7e, 0x12, 0x00},   // 2f 0b26 9496 Ã¨â€“â€ž
    {0x49, 0x3a, 0x40, 0x7e, 0x6b, 0x6a, 0x7e, 0x00},   // 2f 0b27 9497 Ã¨Â¿Â«
    {0x3e, 0x2a, 0x5e, 0x2b, 0x7f, 0x2f, 0x5b, 0x00},   // 2f 0b28 9498 Ã¦â€ºÂ
    {0x75, 0x00, 0x52, 0x5f, 0x36, 0x5f, 0x52, 0x00},   // 2f 0b29 9499 Ã¦Â¼Â 
    {0x4c, 0x3f, 0x5b, 0x2f, 0x7b, 0x2f, 0x5b, 0x00},   // 2f 0b2a 949a Ã§Ë†â€ 
    {0x2a, 0x75, 0x12, 0x3e, 0x5f, 0x7e, 0x13, 0x00},   // 2f 0b2b 949b Ã§Â¸â€º
    {0x52, 0x5e, 0x57, 0x36, 0x57, 0x5e, 0x52, 0x00},   // 2f 0b2c 949c Ã¨Å½Â«
    {0x5f, 0x1f, 0x75, 0x40, 0x55, 0x22, 0x55, 0x00},   // 2f 0b2d 949d Ã©Â§Â
    {0x48, 0x2a, 0x5a, 0x2f, 0x5a, 0x4a, 0x48, 0x00},   // 2f 0b2e 949e Ã©ÂºÂ¦
    {0x7d, 0x69, 0x57, 0x7d, 0x51, 0x69, 0x7d, 0x00},   // 2f 0b2f 949f Ã¥â€¡Â½
    {0x54, 0x33, 0x7e, 0x34, 0x7b, 0x56, 0x7a, 0x00},   // 2f 0b30 94a0 Ã§Â®Â±
    {0x09, 0x37, 0x32, 0x09, 0x64, 0x69, 0x12, 0x00},   // 2f 0b31 94a1 Ã§Â¡Â²
    {0x54, 0x53, 0x36, 0x7c, 0x5b, 0x76, 0x12, 0x00},   // 2f 0b32 94a2 Ã§Â®Â¸
    {0x29, 0x37, 0x35, 0x77, 0x3b, 0x35, 0x2b, 0x00},   // 2f 0b33 94a3 Ã¨â€šâ€¡
    {0x24, 0x2b, 0x6e, 0x7c, 0x6b, 0x26, 0x22, 0x00},   // 2f 0b34 94a4 Ã§Â­Ë†
    {0x1a, 0x7f, 0x3c, 0x44, 0x6f, 0x6a, 0x4a, 0x00},   // 2f 0b35 94a5 Ã¦Â«Â¨
    {0x0e, 0x7f, 0x15, 0x6f, 0x7d, 0x6f, 0x15, 0x00},   // 2f 0b36 94a6 Ã¥Â¹Â¡
    {0x7f, 0x15, 0x7f, 0x3f, 0x01, 0x7f, 0x40, 0x00},   // 2f 0b37 94a7 Ã¨â€šÅ’
    {0x4c, 0x3f, 0x24, 0x7f, 0x49, 0x7f, 0x7f, 0x00},   // 2f 0b38 94a8 Ã§â€¢â€˜
    {0x00, 0x78, 0x5e, 0x7b, 0x5a, 0x5e, 0x78, 0x00},   // 2f 0b39 94a9 Ã§â€¢Â 
    {0x40, 0x30, 0x0f, 0x00, 0x0f, 0x30, 0x40, 0x00},   // 2f 0b3a 94aa Ã¥â€¦Â«
    {0x56, 0x7d, 0x36, 0x2a, 0x7f, 0x2a, 0x12, 0x00},   // 2f 0b3b 94ab Ã©â€°Â¢
    {0x75, 0x00, 0x55, 0x3b, 0x19, 0x7a, 0x55, 0x00},   // 2f 0b3c 94ac Ã¦ÂºÅ’
    {0x4a, 0x55, 0x3b, 0x19, 0x7a, 0x55, 0x4a, 0x00},   // 2f 0b3d 94ad Ã§â„¢Âº
    {0x7d, 0x7f, 0x55, 0x3b, 0x19, 0x7a, 0x55, 0x00},   // 2f 0b3e 94ae Ã©â€ â€”
    {0x44, 0x4f, 0x2d, 0x5d, 0x38, 0x5a, 0x4d, 0x00},   // 2f 0b3f 94af Ã©Â«Âª
    {0x04, 0x7e, 0x01, 0x44, 0x5f, 0x24, 0x55, 0x00},   // 2f 0b40 94b0 Ã¤Â¼Â
    {0x67, 0x6d, 0x6f, 0x05, 0x1f, 0x45, 0x7f, 0x00},   // 2f 0b41 94b1 Ã§Â½Â°
    {0x52, 0x7f, 0x22, 0x52, 0x2f, 0x5a, 0x42, 0x00},   // 2f 0b42 94b2 Ã¦Å Å“
    {0x14, 0x7b, 0x06, 0x54, 0x53, 0x3e, 0x4a, 0x00},   // 2f 0b43 94b3 Ã§Â­Â
    {0x7f, 0x13, 0x7b, 0x50, 0x3b, 0x4b, 0x7f, 0x00},   // 2f 0b44 94b4 Ã©â€“Â¥
    {0x22, 0x1f, 0x3e, 0x20, 0x5e, 0x17, 0x76, 0x00},   // 2f 0b45 94b5 Ã©Â³Â©
    {0x1e, 0x5e, 0x36, 0x7b, 0x3e, 0x0a, 0x79, 0x00},   // 2f 0b46 94b6 Ã¥â„¢Âº
    {0x24, 0x3f, 0x72, 0x1e, 0x5b, 0x1e, 0x72, 0x00},   // 2f 0b47 94b7 Ã¥Â¡â„¢
    {0x4e, 0x7b, 0x2e, 0x00, 0x76, 0x55, 0x76, 0x00},   // 2f 0b48 94b8 Ã¨â€ºÂ¤
    {0x28, 0x24, 0x2f, 0x7a, 0x2f, 0x2a, 0x2a, 0x00},   // 2f 0b49 94b9 Ã©Å¡Â¼
    {0x04, 0x7e, 0x01, 0x2a, 0x28, 0x7f, 0x2a, 0x00},   // 2f 0b4a 94ba Ã¤Â¼Â´
    {0x2a, 0x28, 0x7f, 0x28, 0x2a, 0x40, 0x7f, 0x00},   // 2f 0b4b 94bb Ã¥Ë†Â¤
    {0x20, 0x2a, 0x28, 0x7f, 0x28, 0x2a, 0x20, 0x00},   // 2f 0b4c 94bc Ã¥ÂÅ 
    {0x40, 0x3f, 0x45, 0x5d, 0x25, 0x5d, 0x41, 0x00},   // 2f 0b4d 94bd Ã¥ÂÂ
    {0x55, 0x3e, 0x15, 0x7f, 0x5d, 0x25, 0x5d, 0x00},   // 2f 0b4e 94be Ã¥Ââ€º
    {0x0e, 0x7f, 0x40, 0x3f, 0x09, 0x7f, 0x40, 0x00},   // 2f 0b4f 94bf Ã¥Â¸â€ 
    {0x52, 0x7f, 0x7e, 0x13, 0x7e, 0x29, 0x5b, 0x00},   // 2f 0b50 94c0 Ã¦ÂÂ¬
    {0x49, 0x7f, 0x4a, 0x33, 0x4e, 0x7f, 0x49, 0x00},   // 2f 0b51 94c1 Ã¦â€“â€˜
    {0x1a, 0x7f, 0x4a, 0x3f, 0x5d, 0x25, 0x5d, 0x00},   // 2f 0b52 94c2 Ã¦ÂÂ¿
    {0x75, 0x00, 0x3f, 0x41, 0x49, 0x4f, 0x60, 0x00},   // 2f 0b53 94c3 Ã¦Â°Â¾
    {0x75, 0x40, 0x3f, 0x05, 0x09, 0x7f, 0x40, 0x00},   // 2f 0b54 94c4 Ã¦Â±Å½
    {0x7f, 0x14, 0x77, 0x3f, 0x5d, 0x25, 0x5d, 0x00},   // 2f 0b55 94c5 Ã§â€°Ë†
    {0x55, 0x4a, 0x3d, 0x7f, 0x41, 0x49, 0x6f, 0x00},   // 2f 0b56 94c6 Ã§Å Â¯
    {0x29, 0x3f, 0x4d, 0x20, 0x5e, 0x7f, 0x49, 0x00},   // 2f 0b57 94c7 Ã§ÂÂ­
    {0x3e, 0x3e, 0x3e, 0x2a, 0x28, 0x7f, 0x2a, 0x00},   // 2f 0b58 94c8 Ã§â€¢â€
    {0x4b, 0x1e, 0x1e, 0x76, 0x1a, 0x15, 0x4b, 0x00},   // 2f 0b59 94c9 Ã§Â¹Â
    {0x50, 0x3e, 0x13, 0x7e, 0x5b, 0x29, 0x5b, 0x00},   // 2f 0b5a 94ca Ã¨Ë†Â¬
    {0x56, 0x02, 0x2b, 0x1e, 0x6f, 0x7e, 0x2a, 0x00},   // 2f 0b5b 94cb Ã¨â€”Â©
    {0x5f, 0x15, 0x5f, 0x3f, 0x5d, 0x25, 0x5d, 0x00},   // 2f 0b5c 94cc Ã¨Â²Â©
    {0x2c, 0x3b, 0x7e, 0x2c, 0x7b, 0x4e, 0x5a, 0x00},   // 2f 0b5d 94cd Ã§Â¯â€ž
    {0x4a, 0x4e, 0x2a, 0x7e, 0x29, 0x4d, 0x49, 0x00},   // 2f 0b5e 94ce Ã©â€¡â€ 
    {0x4c, 0x3f, 0x24, 0x5d, 0x17, 0x15, 0x5d, 0x00},   // 2f 0b5f 94cf Ã§â€¦Â©
    {0x44, 0x3b, 0x48, 0x7b, 0x5d, 0x17, 0x5d, 0x00},   // 2f 0b60 94d0 Ã©Â â€™
    {0x7a, 0x5d, 0x5a, 0x3f, 0x5d, 0x25, 0x5d, 0x00},   // 2f 0b61 94d1 Ã©Â£Â¯
    {0x52, 0x7f, 0x5c, 0x36, 0x1d, 0x77, 0x5c, 0x00},   // 2f 0b62 94d2 Ã¦Å’Â½
    {0x3e, 0x2a, 0x5e, 0x36, 0x1d, 0x77, 0x5c, 0x00},   // 2f 0b63 94d3 Ã¦â„¢Â©
    {0x15, 0x77, 0x6d, 0x7f, 0x6d, 0x77, 0x15, 0x00},   // 2f 0b64 94d4 Ã§â€¢Âª
    {0x4c, 0x77, 0x5f, 0x74, 0x5b, 0x75, 0x4b, 0x00},   // 2f 0b65 94d5 Ã§â€ºÂ¤
    {0x5c, 0x37, 0x7f, 0x54, 0x5b, 0x75, 0x1b, 0x00},   // 2f 0b66 94d6 Ã§Â£Â
    {0x2a, 0x1e, 0x6b, 0x7e, 0x6b, 0x1e, 0x2a, 0x00},   // 2f 0b67 94d7 Ã¨â€¢Æ’
    {0x4a, 0x42, 0x5e, 0x7b, 0x5e, 0x22, 0x4a, 0x00},   // 2f 0b68 94d8 Ã¨â€ºÂ®
    {0x7f, 0x55, 0x75, 0x5f, 0x41, 0x7f, 0x55, 0x00},   // 2f 0b69 94d9 Ã¥Å’Âª
    {0x20, 0x2e, 0x3a, 0x2f, 0x7a, 0x2e, 0x20, 0x00},   // 2f 0b6a 94da Ã¥Ââ€˜
    {0x09, 0x79, 0x55, 0x5f, 0x51, 0x75, 0x09, 0x00},   // 2f 0b6b 94db Ã¥ÂÂ¦
    {0x44, 0x5c, 0x37, 0x2c, 0x79, 0x49, 0x6f, 0x00},   // 2f 0b6c 94dc Ã¥Â¦Æ’
    {0x40, 0x3e, 0x7a, 0x52, 0x03, 0x7a, 0x52, 0x00},   // 2f 0b6d 94dd Ã¥Âºâ€¡
    {0x0a, 0x7d, 0x3e, 0x5a, 0x2f, 0x5a, 0x46, 0x00},   // 2f 0b6e 94de Ã¥Â½Â¼
    {0x6a, 0x2a, 0x5f, 0x40, 0x5f, 0x0a, 0x6a, 0x00},   // 2f 0b6f 94df Ã¦â€šÂ²
    {0x41, 0x3f, 0x6d, 0x3d, 0x05, 0x7f, 0x29, 0x00},   // 2f 0b70 94e0 Ã¦â€°â€°
    {0x52, 0x7f, 0x0a, 0x7f, 0x24, 0x7f, 0x44, 0x00},   // 2f 0b71 94e1 Ã¦â€°Â¹
    {0x52, 0x7f, 0x3e, 0x5a, 0x2f, 0x5a, 0x46, 0x00},   // 2f 0b72 94e2 Ã¦Å Â«
    {0x4a, 0x4a, 0x5f, 0x28, 0x5f, 0x4a, 0x4a, 0x00},   // 2f 0b73 94e3 Ã¦â€“Â
    {0x40, 0x7f, 0x24, 0x24, 0x7f, 0x48, 0x64, 0x00},   // 2f 0b74 94e4 Ã¦Â¯â€
    {0x75, 0x00, 0x58, 0x3d, 0x52, 0x48, 0x56, 0x00},   // 2f 0b75 94e5 Ã¦Â³Å’
    {0x54, 0x3e, 0x42, 0x3a, 0x5b, 0x2e, 0x5a, 0x00},   // 2f 0b76 94e6 Ã§â€“Â²
    {0x40, 0x3e, 0x4a, 0x5a, 0x2f, 0x5a, 0x46, 0x00},   // 2f 0b77 94e7 Ã§Å¡Â®
    {0x09, 0x37, 0x31, 0x2e, 0x3f, 0x7a, 0x2e, 0x00},   // 2f 0b78 94e8 Ã§Â¢â€˜
    {0x35, 0x7f, 0x58, 0x3d, 0x52, 0x48, 0x56, 0x00},   // 2f 0b79 94e9 Ã§Â§Ëœ
    {0x2a, 0x75, 0x2a, 0x7f, 0x00, 0x7f, 0x2a, 0x00},   // 2f 0b7a 94ea Ã§Â·â€¹
    {0x17, 0x7d, 0x37, 0x7d, 0x07, 0x7d, 0x57, 0x00},   // 2f 0b7b 94eb Ã§Â½Â·
    {0x7f, 0x15, 0x7f, 0x49, 0x4f, 0x49, 0x6f, 0x00},   // 2f 0b7c 94ec Ã¨â€šÂ¥
    {0x12, 0x7b, 0x36, 0x7e, 0x5a, 0x2f, 0x5e, 0x00},   // 2f 0b7d 94ed Ã¨Â¢Â«
    {0x6b, 0x62, 0x2a, 0x7f, 0x00, 0x7f, 0x2a, 0x00},   // 2f 0b7e 94ee Ã¨ÂªÂ¹
    {0x5a, 0x7a, 0x2f, 0x2a, 0x2f, 0x7a, 0x4e, 0x00},   // 2f 0b7f 94ef Ã¨Â²Â»
    {0x49, 0x38, 0x5f, 0x5b, 0x56, 0x7b, 0x56, 0x00},   // 2f 0b80 94f0 Ã©ÂÂ¿
    {0x2a, 0x6a, 0x3f, 0x00, 0x7f, 0x2a, 0x2a, 0x00},   // 2f 0b81 94f1 Ã©ÂÅ¾
    {0x55, 0x3f, 0x09, 0x7f, 0x09, 0x3b, 0x54, 0x00},   // 2f 0b82 94f2 Ã©Â£â€º
    {0x1a, 0x7f, 0x49, 0x38, 0x5d, 0x4f, 0x5c, 0x00},   // 2f 0b83 94f3 Ã¦Â¨â€¹
    {0x54, 0x1b, 0x56, 0x3c, 0x5b, 0x2e, 0x5a, 0x00},   // 2f 0b84 94f4 Ã§Â°Â¸
    {0x0c, 0x7f, 0x3a, 0x0f, 0x6a, 0x2f, 0x6a, 0x00},   // 2f 0b85 94f5 Ã¥â€šâ„¢
    {0x40, 0x3f, 0x2b, 0x2b, 0x7f, 0x57, 0x53, 0x00},   // 2f 0b86 94f6 Ã¥Â°Â¾
    {0x0a, 0x7d, 0x56, 0x37, 0x56, 0x3f, 0x5e, 0x00},   // 2f 0b87 94f7 Ã¥Â¾Â®
    {0x1a, 0x7f, 0x0a, 0x7f, 0x24, 0x7f, 0x44, 0x00},   // 2f 0b88 94f8 Ã¦Å¾â€¡
    {0x40, 0x7f, 0x55, 0x07, 0x7d, 0x57, 0x50, 0x00},   // 2f 0b89 94f9 Ã¦Â¯Ëœ
    {0x45, 0x7f, 0x55, 0x00, 0x7d, 0x57, 0x55, 0x00},   // 2f 0b8a 94fa Ã§ÂÂµ
    {0x40, 0x3f, 0x05, 0x7d, 0x57, 0x55, 0x7f, 0x00},   // 2f 0b8b 94fb Ã§Å“â€°
    {0x52, 0x56, 0x57, 0x3e, 0x56, 0x57, 0x52, 0x00},   // 2f 0b8c 94fc Ã§Â¾Å½    
    {0x20, 0x78, 0x2e, 0x3b, 0x6e, 0x38, 0x20, 0x00},   // 30 0b8d 9540 Ã©Â¼Â»
    {0x1a, 0x7f, 0x08, 0x0a, 0x55, 0x4b, 0x08, 0x00},   // 30 0b8e 9541 Ã¦Å¸Å 
    {0x35, 0x7f, 0x2e, 0x3a, 0x2f, 0x7a, 0x2e, 0x00},   // 30 0b8f 9542 Ã§Â¨â€”
    {0x7f, 0x51, 0x4f, 0x41, 0x5f, 0x51, 0x59, 0x00},   // 30 0b90 9543 Ã¥Å’Â¹
    {0x41, 0x39, 0x41, 0x7f, 0x49, 0x49, 0x43, 0x00},   // 30 0b91 9544 Ã§â€“â€¹
    {0x64, 0x4f, 0x7d, 0x55, 0x00, 0x7a, 0x55, 0x00},   // 30 0b92 9545 Ã©Â«Â­
    {0x42, 0x3a, 0x0e, 0x5b, 0x5a, 0x4e, 0x2a, 0x00},   // 30 0b93 9546 Ã¥Â½Â¦
    {0x7f, 0x15, 0x7f, 0x2a, 0x77, 0x2a, 0x52, 0x00},   // 30 0b94 9547 Ã¨â€ Â
    {0x2a, 0x5a, 0x5f, 0x2e, 0x3f, 0x5a, 0x52, 0x00},   // 30 0b95 9548 Ã¨ÂÂ±
    {0x7f, 0x15, 0x7f, 0x0a, 0x52, 0x7f, 0x02, 0x00},   // 30 0b96 9549 Ã¨â€šËœ
    {0x5d, 0x77, 0x3a, 0x2e, 0x3a, 0x5d, 0x77, 0x00},   // 30 0b97 954a Ã¥Â¼Â¼
    {0x58, 0x40, 0x3d, 0x52, 0x48, 0x46, 0x58, 0x00},   // 30 0b98 954b Ã¥Â¿â€¦
    {0x28, 0x3f, 0x2d, 0x7f, 0x2d, 0x3f, 0x28, 0x00},   // 30 0b99 954c Ã§â€¢Â¢
    {0x24, 0x2b, 0x2e, 0x7c, 0x2b, 0x3e, 0x2a, 0x00},   // 30 0b9a 954d Ã§Â­â€ 
    {0x49, 0x3a, 0x71, 0x57, 0x75, 0x57, 0x71, 0x00},   // 30 0b9b 954e Ã©â‚¬Â¼
    {0x1a, 0x7f, 0x54, 0x72, 0x55, 0x36, 0x54, 0x00},   // 30 0b9c 954f Ã¦Â¡Â§
    {0x5c, 0x37, 0x2c, 0x7f, 0x55, 0x77, 0x5d, 0x00},   // 30 0b9d 9550 Ã¥Â§Â«
    {0x5f, 0x3c, 0x46, 0x2a, 0x5e, 0x29, 0x5d, 0x00},   // 30 0b9e 9551 Ã¥Âªâ€º
    {0x2a, 0x75, 0x49, 0x7f, 0x49, 0x7f, 0x48, 0x00},   // 30 0b9f 9552 Ã§Â´Â
    {0x01, 0x7d, 0x55, 0x57, 0x55, 0x7d, 0x01, 0x00},   // 30 0ba0 9553 Ã§â„¢Â¾
    {0x6b, 0x6a, 0x11, 0x4b, 0x54, 0x29, 0x13, 0x00},   // 30 0ba1 9554 Ã¨Â¬Â¬
    {0x04, 0x7e, 0x2b, 0x7a, 0x5f, 0x2a, 0x52, 0x00},   // 30 0ba2 9555 Ã¤Â¿Âµ
    {0x7c, 0x44, 0x2f, 0x6a, 0x40, 0x6a, 0x55, 0x00},   // 30 0ba3 9556 Ã¥Â½Âª
    {0x1a, 0x7f, 0x51, 0x17, 0x77, 0x17, 0x51, 0x00},   // 30 0ba4 9557 Ã¦Â¨â„¢
    {0x24, 0x15, 0x4c, 0x7f, 0x08, 0x14, 0x22, 0x00},   // 30 0ba5 9558 Ã¦Â°Â·
    {0x75, 0x00, 0x51, 0x17, 0x77, 0x17, 0x51, 0x00},   // 30 0ba6 9559 Ã¦Â¼â€š
    {0x51, 0x17, 0x77, 0x5d, 0x3e, 0x02, 0x7d, 0x00},   // 30 0ba7 955a Ã§â€œÂ¢
    {0x51, 0x37, 0x55, 0x77, 0x15, 0x37, 0x51, 0x00},   // 30 0ba8 955b Ã§Â¥Â¨
    {0x28, 0x2a, 0x7a, 0x4f, 0x1a, 0x2a, 0x50, 0x00},   // 30 0ba9 955c Ã¨Â¡Â¨
    {0x6b, 0x6a, 0x15, 0x11, 0x7f, 0x11, 0x15, 0x00},   // 30 0baa 955d Ã¨Â©â€¢
    {0x2a, 0x56, 0x3d, 0x04, 0x0b, 0x52, 0x7e, 0x00},   // 30 0bab 955e Ã¨Â±Â¹
    {0x40, 0x3e, 0x7e, 0x36, 0x7b, 0x2a, 0x7a, 0x00},   // 30 0bac 955f Ã¥Â»Å¸
    {0x52, 0x7f, 0x7a, 0x5f, 0x7a, 0x5f, 0x7a, 0x00},   // 30 0bad 9560 Ã¦ÂÂ
    {0x54, 0x3e, 0x7a, 0x2e, 0x1f, 0x2e, 0x7a, 0x00},   // 30 0bae 9561 Ã§â€”â€¦
    {0x35, 0x7f, 0x08, 0x46, 0x5f, 0x22, 0x14, 0x00},   // 30 0baf 9562 Ã§Â§â€™
    {0x02, 0x7a, 0x5f, 0x7a, 0x5f, 0x7a, 0x02, 0x00},   // 30 0bb0 9563 Ã¨â€¹â€”
    {0x56, 0x7d, 0x7a, 0x5f, 0x7a, 0x5f, 0x7a, 0x00},   // 30 0bb1 9564 Ã©Å’Â¨
    {0x56, 0x7d, 0x52, 0x1e, 0x16, 0x1d, 0x54, 0x00},   // 30 0bb2 9565 Ã©â€¹Â²
    {0x2a, 0x7e, 0x2f, 0x02, 0x2b, 0x7e, 0x2e, 0x00},   // 30 0bb3 9566 Ã¨â€™Å“
    {0x4e, 0x7b, 0x2e, 0x45, 0x57, 0x7d, 0x55, 0x00},   // 30 0bb4 9567 Ã¨â€ºÂ­
    {0x42, 0x1d, 0x5f, 0x0a, 0x67, 0x7e, 0x75, 0x00},   // 30 0bb5 9568 Ã©Â°Â­
    {0x70, 0x57, 0x75, 0x05, 0x75, 0x57, 0x70, 0x00},   // 30 0bb6 9569 Ã¥â€œÂ
    {0x1a, 0x7f, 0x1a, 0x7f, 0x1a, 0x4a, 0x25, 0x00},   // 30 0bb7 956a Ã¥Â½Â¬
    {0x4a, 0x33, 0x4e, 0x75, 0x65, 0x3e, 0x45, 0x00},   // 30 0bb8 956b Ã¦â€“Å’
    {0x75, 0x00, 0x50, 0x1e, 0x16, 0x1d, 0x54, 0x00},   // 30 0bb9 956c Ã¦ÂµÅ“
    {0x75, 0x48, 0x5f, 0x2a, 0x5d, 0x17, 0x5d, 0x00},   // 30 0bba 956d Ã§â‚¬â€¢
    {0x44, 0x42, 0x35, 0x3c, 0x35, 0x7e, 0x44, 0x00},   // 30 0bbb 956e Ã¨Â²Â§
    {0x46, 0x5a, 0x36, 0x3f, 0x36, 0x4a, 0x46, 0x00},   // 30 0bbc 956f Ã¨Â³â€œ
    {0x5e, 0x48, 0x3f, 0x1a, 0x5d, 0x17, 0x5d, 0x00},   // 30 0bbd 9570 Ã©Â Â»
    {0x33, 0x2e, 0x7e, 0x12, 0x5c, 0x23, 0x5e, 0x00},   // 30 0bbe 9571 Ã¦â€¢Â
    {0x55, 0x3e, 0x7d, 0x7f, 0x55, 0x3d, 0x41, 0x00},   // 30 0bbf 9572 Ã§â€œÂ¶
    {0x11, 0x11, 0x09, 0x7f, 0x01, 0x09, 0x11, 0x00},   // 30 0bc0 9573 Ã¤Â¸Â
    {0x04, 0x7e, 0x01, 0x0a, 0x52, 0x7f, 0x02, 0x00},   // 30 0bc1 9574 Ã¤Â»Ëœ
    {0x24, 0x3f, 0x24, 0x3e, 0x6b, 0x2e, 0x38, 0x00},   // 30 0bc2 9575 Ã¥Å¸Â 
    {0x48, 0x4a, 0x2a, 0x1f, 0x2a, 0x4a, 0x48, 0x00},   // 30 0bc3 9576 Ã¥Â¤Â«
    {0x5c, 0x37, 0x2c, 0x35, 0x7d, 0x37, 0x0c, 0x00},   // 30 0bc4 9577 Ã¥Â©Â¦
    {0x06, 0x72, 0x5e, 0x7b, 0x5e, 0x72, 0x06, 0x00},   // 30 0bc5 9578 Ã¥Â¯Å’
    {0x03, 0x71, 0x5f, 0x7b, 0x5f, 0x71, 0x03, 0x00},   // 30 0bc6 9579 Ã¥â€ Â¨
    {0x12, 0x0a, 0x3f, 0x0a, 0x7e, 0x0a, 0x3a, 0x00},   // 30 0bc7 957a Ã¥Â¸Æ’
    {0x40, 0x3e, 0x12, 0x7e, 0x2b, 0x4a, 0x7e, 0x00},   // 30 0bc8 957b Ã¥ÂºÅ“
    {0x06, 0x7f, 0x0a, 0x37, 0x12, 0x7a, 0x32, 0x00},   // 30 0bc9 957c Ã¦â‚¬â€“
    {0x52, 0x7f, 0x48, 0x2a, 0x1f, 0x2a, 0x48, 0x00},   // 30 0bca 957d Ã¦â€°Â¶
    {0x52, 0x3e, 0x5f, 0x32, 0x5c, 0x23, 0x5e, 0x00},   // 30 0bcb 957e Ã¦â€¢Â·
    {0x4a, 0x3a, 0x15, 0x14, 0x75, 0x1a, 0x0a, 0x00},   // 31 0bcc 9580 Ã¦â€“Â§
    {0x12, 0x76, 0x5f, 0x52, 0x5e, 0x77, 0x12, 0x00},   // 31 0bcd 9581 Ã¦â„¢Â®
    {0x75, 0x00, 0x22, 0x2a, 0x69, 0x3b, 0x21, 0x00},   // 31 0bce 9582 Ã¦ÂµÂ®
    {0x42, 0x42, 0x2d, 0x10, 0x2d, 0x42, 0x42, 0x00},   // 31 0bcf 9583 Ã§Ë†Â¶
    {0x14, 0x7b, 0x06, 0x2c, 0x4b, 0x7e, 0x0a, 0x00},   // 31 0bd0 9584 Ã§Â¬Â¦
    {0x40, 0x3e, 0x7a, 0x56, 0x3b, 0x5e, 0x72, 0x00},   // 31 0bd1 9585 Ã¨â€¦Â
    {0x40, 0x3c, 0x04, 0x7c, 0x3f, 0x3a, 0x7a, 0x00},   // 31 0bd2 9586 Ã¨â€ Å¡
    {0x52, 0x5a, 0x5b, 0x3e, 0x5b, 0x5a, 0x52, 0x00},   // 31 0bd3 9587 Ã¨Å â„¢
    {0x6b, 0x62, 0x2a, 0x7f, 0x62, 0x7f, 0x2a, 0x00},   // 31 0bd4 9588 Ã¨Â­Å“
    {0x42, 0x7e, 0x35, 0x35, 0x37, 0x7c, 0x40, 0x00},   // 31 0bd5 9589 Ã¨Â²Â 
    {0x5f, 0x1f, 0x65, 0x7d, 0x54, 0x3f, 0x45, 0x00},   // 31 0bd6 958a Ã¨Â³Â¦
    {0x4a, 0x3a, 0x3f, 0x5a, 0x40, 0x5f, 0x44, 0x00},   // 31 0bd7 958b Ã¨ÂµÂ´
    {0x20, 0x3e, 0x2a, 0x6b, 0x2e, 0x38, 0x20, 0x00},   // 31 0bd8 958c Ã©ËœÅ“
    {0x7f, 0x25, 0x1b, 0x7e, 0x09, 0x42, 0x7f, 0x00},   // 31 0bd9 958d Ã©â„¢â€ž
    {0x04, 0x7e, 0x15, 0x33, 0x2e, 0x7e, 0x12, 0x00},   // 31 0bda 958e Ã¤Â¾Â®
    {0x52, 0x7f, 0x6b, 0x3e, 0x6a, 0x3e, 0x6a, 0x00},   // 31 0bdb 958f Ã¦â€™Â«
    {0x44, 0x75, 0x7d, 0x54, 0x0f, 0x34, 0x45, 0x00},   // 31 0bdc 9590 Ã¦Â­Â¦
    {0x2b, 0x5e, 0x2a, 0x3e, 0x2a, 0x7e, 0x2a, 0x00},   // 31 0bdd 9591 Ã¨Ë†Å¾
    {0x0a, 0x76, 0x37, 0x7e, 0x77, 0x06, 0x7e, 0x00},   // 31 0bde 9592 Ã¨â€˜Â¡
    {0x6a, 0x3e, 0x6b, 0x3a, 0x6b, 0x3a, 0x6a, 0x00},   // 31 0bdf 9593 Ã¨â€¢Âª
    {0x0a, 0x6e, 0x6b, 0x0e, 0x7f, 0x25, 0x1b, 0x00},   // 31 0be0 9594 Ã©Æ’Â¨
    {0x48, 0x5a, 0x3f, 0x2a, 0x0a, 0x52, 0x7f, 0x00},   // 31 0be1 9595 Ã¥Â°Â
    {0x1a, 0x7f, 0x3f, 0x4d, 0x7f, 0x2d, 0x7f, 0x00},   // 31 0be2 9596 Ã¦Â¥â€œ
    {0x40, 0x3f, 0x4d, 0x7f, 0x2d, 0x7f, 0x40, 0x00},   // 31 0be3 9597 Ã©Â¢Â¨
    {0x2a, 0x2e, 0x3b, 0x2a, 0x2b, 0x7e, 0x2a, 0x00},   // 31 0be4 9598 Ã¨â€˜Âº
    {0x6e, 0x76, 0x2f, 0x6a, 0x57, 0x6e, 0x22, 0x00},   // 31 0be5 9599 Ã¨â€¢â€”
    {0x04, 0x7e, 0x45, 0x24, 0x1f, 0x24, 0x45, 0x00},   // 31 0be6 959a Ã¤Â¼Â
    {0x71, 0x57, 0x75, 0x57, 0x71, 0x0e, 0x7f, 0x00},   // 31 0be7 959b Ã¥â€°Â¯
    {0x0a, 0x7d, 0x44, 0x53, 0x2e, 0x5e, 0x42, 0x00},   // 31 0be8 959c Ã¥Â¾Â©
    {0x0e, 0x7f, 0x71, 0x57, 0x75, 0x57, 0x71, 0x00},   // 31 0be9 959d Ã¥Â¹â€¦
    {0x40, 0x3f, 0x55, 0x7f, 0x59, 0x29, 0x5b, 0x00},   // 31 0bea 959e Ã¦Å“Â
    {0x12, 0x7b, 0x16, 0x71, 0x57, 0x77, 0x71, 0x00},   // 31 0beb 959f Ã§Â¦Â
    {0x7f, 0x15, 0x7f, 0x53, 0x2e, 0x5e, 0x42, 0x00},   // 31 0bec 95a0 Ã¨â€¦Â¹
    {0x12, 0x7b, 0x36, 0x53, 0x2e, 0x5e, 0x42, 0x00},   // 31 0bed 95a1 Ã¨Â¤â€¡
    {0x29, 0x77, 0x45, 0x57, 0x2d, 0x5f, 0x41, 0x00},   // 31 0bee 95a2 Ã¨Â¦â€ 
    {0x75, 0x40, 0x3f, 0x14, 0x77, 0x14, 0x7f, 0x00},   // 31 0bef 95a3 Ã¦Â·Âµ
    {0x5a, 0x5a, 0x3f, 0x16, 0x7f, 0x16, 0x36, 0x00},   // 31 0bf0 95a4 Ã¥Â¼â€”
    {0x52, 0x7f, 0x4a, 0x70, 0x4f, 0x20, 0x40, 0x00},   // 31 0bf1 95a5 Ã¦â€°â€¢
    {0x75, 0x00, 0x5a, 0x3f, 0x16, 0x7f, 0x36, 0x00},   // 31 0bf2 95a6 Ã¦Â²Â¸
    {0x04, 0x7e, 0x41, 0x70, 0x4f, 0x20, 0x40, 0x00},   // 31 0bf3 95a7 Ã¤Â»Â
    {0x17, 0x7f, 0x24, 0x53, 0x2e, 0x5e, 0x7e, 0x00},   // 31 0bf4 95a8 Ã§â€°Â©
    {0x42, 0x1d, 0x5f, 0x7e, 0x09, 0x42, 0x7f, 0x00},   // 31 0bf5 95a9 Ã©Â®â€™
    {0x48, 0x44, 0x2b, 0x18, 0x4b, 0x7c, 0x08, 0x00},   // 31 0bf6 95aa Ã¥Ë†â€ 
    {0x3e, 0x22, 0x3e, 0x53, 0x2e, 0x5e, 0x7e, 0x00},   // 31 0bf7 95ab Ã¥ÂÂ»
    {0x1e, 0x1e, 0x4a, 0x3e, 0x2b, 0x3e, 0x4a, 0x00},   // 31 0bf8 95ac Ã¥â„¢Â´
    {0x24, 0x3f, 0x4a, 0x3e, 0x2b, 0x3e, 0x4a, 0x00},   // 31 0bf9 95ad Ã¥Â¢Â³
    {0x06, 0x7f, 0x4a, 0x3e, 0x2b, 0x3e, 0x4a, 0x00},   // 31 0bfa 95ae Ã¦â€ Â¤
    {0x52, 0x7f, 0x44, 0x3b, 0x48, 0x7b, 0x04, 0x00},   // 31 0bfb 95af Ã¦â€°Â®
    {0x4a, 0x56, 0x2f, 0x1a, 0x26, 0x5f, 0x4a, 0x00},   // 31 0bfc 95b0 Ã§â€žÅ¡
    {0x0a, 0x76, 0x5e, 0x7f, 0x5a, 0x76, 0x0a, 0x00},   // 31 0bfd 95b1 Ã¥Â¥Â®
    {0x35, 0x7e, 0x45, 0x3b, 0x48, 0x7b, 0x04, 0x00},   // 31 0bfe 95b2 Ã§Â²â€°
    {0x2a, 0x67, 0x3a, 0x3f, 0x3a, 0x67, 0x2a, 0x00},   // 31 0bff 95b3 Ã§Â³Å¾
    {0x2a, 0x75, 0x44, 0x3b, 0x48, 0x7b, 0x04, 0x00},   // 31 0c00 95b4 Ã§Â´â€º
    {0x16, 0x4a, 0x57, 0x37, 0x53, 0x7e, 0x16, 0x00},   // 31 0c01 95b5 Ã©â€ºÂ°
    {0x42, 0x42, 0x2e, 0x13, 0x2e, 0x42, 0x42, 0x00},   // 31 0c02 95b6 Ã¦â€“â€¡
    {0x7f, 0x2b, 0x3b, 0x38, 0x7b, 0x0b, 0x7f, 0x00},   // 31 0c03 95b7 Ã¨ÂÅ¾
    {0x7d, 0x25, 0x15, 0x0f, 0x15, 0x45, 0x7d, 0x00},   // 31 0c04 95b8 Ã¤Â¸â„¢
    {0x04, 0x7e, 0x55, 0x3d, 0x14, 0x7d, 0x14, 0x00},   // 31 0c05 95b9 Ã¤Â½Âµ
    {0x50, 0x5e, 0x16, 0x16, 0x1d, 0x55, 0x50, 0x00},   // 31 0c06 95ba Ã¥â€¦Âµ
    {0x24, 0x3f, 0x3f, 0x6d, 0x35, 0x7d, 0x27, 0x00},   // 31 0c07 95bb Ã¥Â¡â‚¬
    {0x0d, 0x36, 0x1e, 0x75, 0x1a, 0x35, 0x0b, 0x00},   // 31 0c08 95bc Ã¥Â¹Â£
    {0x11, 0x13, 0x15, 0x7f, 0x15, 0x13, 0x11, 0x00},   // 31 0c09 95bd Ã¥Â¹Â³
    {0x1d, 0x56, 0x3e, 0x15, 0x7a, 0x15, 0x1b, 0x00},   // 31 0c0a 95be Ã¥Â¼Å 
    {0x1a, 0x7f, 0x7d, 0x15, 0x0f, 0x55, 0x7d, 0x00},   // 31 0c0b 95bf Ã¦Å¸â€ž
    {0x42, 0x5a, 0x7f, 0x42, 0x7e, 0x53, 0x4a, 0x00},   // 31 0c0c 95c0 Ã¤Â¸Â¦
    {0x76, 0x5a, 0x2b, 0x76, 0x53, 0x2e, 0x5a, 0x00},   // 31 0c0d 95c1 Ã¨â€Â½
    {0x7f, 0x55, 0x37, 0x78, 0x17, 0x45, 0x7f, 0x00},   // 31 0c0e 95c2 Ã©â€“â€°
    {0x7f, 0x1b, 0x4f, 0x5a, 0x70, 0x5f, 0x4a, 0x00},   // 31 0c0f 95c3 Ã©â„¢â€º
    {0x24, 0x25, 0x16, 0x7f, 0x16, 0x25, 0x24, 0x00},   // 31 0c10 95c4 Ã§Â±Â³
    {0x41, 0x7d, 0x2d, 0x2f, 0x2d, 0x7d, 0x41, 0x00},   // 31 0c11 95c5 Ã©Â Â
    {0x04, 0x7e, 0x3f, 0x36, 0x2e, 0x7b, 0x2e, 0x00},   // 31 0c12 95c6 Ã¥Æ’Â»
    {0x48, 0x5f, 0x5b, 0x6a, 0x4e, 0x5b, 0x4e, 0x00},   // 31 0c13 95c7 Ã¥Â£Â
    {0x54, 0x3e, 0x7e, 0x6e, 0x3b, 0x6e, 0x3a, 0x00},   // 31 0c14 95c8 Ã§â„¢â€“
    {0x55, 0x3f, 0x75, 0x50, 0x5e, 0x7b, 0x1e, 0x00},   // 31 0c15 95c9 Ã§Â¢Â§
    {0x47, 0x3d, 0x55, 0x77, 0x0e, 0x40, 0x7f, 0x00},   // 31 0c16 95ca Ã¥Ë†Â¥
    {0x0d, 0x76, 0x7e, 0x75, 0x7a, 0x75, 0x0b, 0x00},   // 31 0c17 95cb Ã§Å¾Â¥
    {0x42, 0x3e, 0x2b, 0x0e, 0x5b, 0x2e, 0x5a, 0x00},   // 31 0c18 95cc Ã¨â€â€˜
    {0x44, 0x7b, 0x56, 0x0c, 0x77, 0x5e, 0x42, 0x00},   // 31 0c19 95cd Ã§Â®â€ 
    {0x04, 0x7e, 0x21, 0x1f, 0x75, 0x37, 0x71, 0x00},   // 31 0c1a 95ce Ã¥ÂÂ
    {0x4a, 0x52, 0x5e, 0x2b, 0x5e, 0x42, 0x4a, 0x00},   // 31 0c1b 95cf Ã¥Â¤â€°
    {0x40, 0x3f, 0x14, 0x14, 0x17, 0x74, 0x04, 0x00},   // 31 0c1c 95d0 Ã§â€°â€¡
    {0x44, 0x3b, 0x1e, 0x7c, 0x3b, 0x7e, 0x62, 0x00},   // 31 0c1d 95d1 Ã§Â¯â€¡
    {0x2a, 0x75, 0x21, 0x1f, 0x75, 0x37, 0x71, 0x00},   // 31 0c1e 95d2 Ã§Â·Â¨
    {0x49, 0x3a, 0x51, 0x49, 0x47, 0x51, 0x5f, 0x00},   // 31 0c1f 95d3 Ã¨Â¾Âº
    {0x49, 0x3a, 0x60, 0x5f, 0x6d, 0x55, 0x6d, 0x00},   // 31 0c20 95d4 Ã¨Â¿â€
    {0x49, 0x3a, 0x51, 0x4f, 0x7b, 0x5b, 0x79, 0x00},   // 31 0c21 95d5 Ã©ÂÂ
    {0x04, 0x7e, 0x41, 0x57, 0x3f, 0x47, 0x41, 0x00},   // 31 0c22 95d6 Ã¤Â¾Â¿
    {0x5e, 0x35, 0x7f, 0x5c, 0x72, 0x4f, 0x7e, 0x00},   // 31 0c23 95d7 Ã¥â€¹â€°
    {0x5c, 0x37, 0x2c, 0x5e, 0x3d, 0x77, 0x5c, 0x00},   // 31 0c24 95d8 Ã¥Â¨Â©
    {0x14, 0x54, 0x3e, 0x15, 0x7c, 0x12, 0x14, 0x00},   // 31 0c25 95d9 Ã¥Â¼Â
    {0x37, 0x7e, 0x37, 0x7e, 0x5d, 0x3f, 0x4d, 0x00},   // 31 0c26 95da Ã©Å¾Â­
    {0x04, 0x7e, 0x51, 0x37, 0x7d, 0x37, 0x50, 0x00},   // 31 0c27 95db Ã¤Â¿Â
    {0x6a, 0x6d, 0x7a, 0x2a, 0x7f, 0x2a, 0x7b, 0x00},   // 31 0c28 95dc Ã¨Ë†â€”
    {0x56, 0x7d, 0x7a, 0x2a, 0x7f, 0x2a, 0x7b, 0x00},   // 31 0c29 95dd Ã©â€¹Âª
    {0x7f, 0x45, 0x7d, 0x5f, 0x7d, 0x47, 0x7f, 0x00},   // 31 0c2a 95de Ã¥Å“Æ’
    {0x52, 0x7f, 0x7a, 0x2a, 0x7f, 0x2a, 0x7b, 0x00},   // 31 0c2b 95df Ã¦Ââ€¢
    {0x28, 0x5e, 0x48, 0x7f, 0x2a, 0x1a, 0x28, 0x00},   // 31 0c2c 95e0 Ã¦Â­Â©
    {0x00, 0x7a, 0x2a, 0x7f, 0x2a, 0x2b, 0x7a, 0x00},   // 31 0c2d 95e1 Ã§â€Â«
    {0x12, 0x7b, 0x36, 0x7a, 0x7f, 0x2a, 0x7b, 0x00},   // 31 0c2e 95e2 Ã¨Â£Å“
    {0x2d, 0x7f, 0x7a, 0x2a, 0x7f, 0x2a, 0x7b, 0x00},   // 31 0c2f 95e3 Ã¨Â¼â€
    {0x35, 0x7f, 0x62, 0x3e, 0x5f, 0x5e, 0x62, 0x00},   // 31 0c30 95e4 Ã§Â©â€š
    {0x2a, 0x5a, 0x3f, 0x5e, 0x7f, 0x1a, 0x2a, 0x00},   // 31 0c31 95e5 Ã¥â€¹Å¸
    {0x2a, 0x1a, 0x4f, 0x6e, 0x4f, 0x1a, 0x2a, 0x00},   // 31 0c32 95e6 Ã¥Â¢â€œ
    {0x4a, 0x1a, 0x6f, 0x0e, 0x4f, 0x1a, 0x4a, 0x00},   // 31 0c33 95e7 Ã¦â€¦â€¢
    {0x40, 0x3e, 0x02, 0x42, 0x5f, 0x22, 0x53, 0x00},   // 31 0c34 95e8 Ã¦Ë†Å 
    {0x2a, 0x1a, 0x6f, 0x6e, 0x6f, 0x1a, 0x2a, 0x00},   // 31 0c35 95e9 Ã¦Å¡Â®
    {0x08, 0x38, 0x2f, 0x3b, 0x69, 0x7f, 0x28, 0x00},   // 31 0c36 95ea Ã¦Â¯Â
    {0x54, 0x03, 0x16, 0x3c, 0x5b, 0x7e, 0x12, 0x00},   // 31 0c37 95eb Ã§Â°Â¿
    {0x12, 0x76, 0x5f, 0x56, 0x5f, 0x76, 0x12, 0x00},   // 31 0c38 95ec Ã¨ÂÂ©
    {0x0c, 0x7f, 0x62, 0x1f, 0x7a, 0x3f, 0x5e, 0x00},   // 31 0c39 95ed Ã¥â‚¬Â£
    {0x04, 0x7e, 0x15, 0x2e, 0x77, 0x2e, 0x14, 0x00},   // 31 0c3a 95ee Ã¤Â¿Â¸
    {0x04, 0x73, 0x56, 0x56, 0x5e, 0x42, 0x5e, 0x00},   // 31 0c3b 95ef Ã¥Å’â€¦
    {0x50, 0x57, 0x35, 0x7d, 0x35, 0x57, 0x50, 0x00},   // 31 0c3c 95f0 Ã¥â€˜â€ 
    {0x14, 0x3e, 0x77, 0x3e, 0x5f, 0x29, 0x5b, 0x00},   // 31 0c3d 95f1 Ã¥Â Â±
    {0x28, 0x1a, 0x2e, 0x7f, 0x2e, 0x1a, 0x28, 0x00},   // 31 0c3e 95f2 Ã¥Â¥â€°
    {0x46, 0x42, 0x56, 0x7f, 0x56, 0x62, 0x46, 0x00},   // 31 0c3f 95f3 Ã¥Â®Â
    {0x38, 0x3f, 0x28, 0x2a, 0x75, 0x2b, 0x28, 0x00},   // 31 0c40 95f4 Ã¥Â³Â°
    {0x13, 0x16, 0x2e, 0x7b, 0x2e, 0x12, 0x13, 0x00},   // 31 0c41 95f5 Ã¥Â³Â¯
    {0x43, 0x3e, 0x56, 0x7f, 0x3e, 0x56, 0x7f, 0x00},   // 31 0c42 95f6 Ã¥Â´Â©
    {0x40, 0x3e, 0x0a, 0x76, 0x5f, 0x46, 0x5e, 0x00},   // 31 0c43 95f7 Ã¥Âºâ€“
    {0x52, 0x7f, 0x04, 0x77, 0x5e, 0x42, 0x5e, 0x00},   // 31 0c44 95f8 Ã¦Å Â±
    {0x52, 0x7f, 0x14, 0x2e, 0x77, 0x2e, 0x14, 0x00},   // 31 0c45 95f9 Ã¦ÂÂ§
    {0x42, 0x3e, 0x4b, 0x7a, 0x5c, 0x23, 0x5e, 0x00},   // 31 0c46 95fa Ã¦â€Â¾
    {0x42, 0x22, 0x1e, 0x0b, 0x4a, 0x7a, 0x02, 0x00},   // 31 0c47 95fb Ã¦â€“Â¹
    {0x40, 0x3f, 0x55, 0x7f, 0x3f, 0x55, 0x7f, 0x00},   // 31 0c48 95fc Ã¦Å“â€¹
    {0x75, 0x00, 0x48, 0x6a, 0x5f, 0x2a, 0x48, 0x00},   // 32 0c49 9640 Ã¦Â³â€¢
    {0x75, 0x00, 0x04, 0x77, 0x5e, 0x42, 0x5e, 0x00},   // 32 0c4a 9641 Ã¦Â³Â¡
    {0x42, 0x0e, 0x4a, 0x0b, 0x5a, 0x0e, 0x42, 0x00},   // 32 0c4b 9642 Ã§Æ’Â¹
    {0x09, 0x37, 0x31, 0x04, 0x73, 0x56, 0x5e, 0x00},   // 32 0c4c 9643 Ã§Â Â²
    {0x2a, 0x75, 0x48, 0x39, 0x5a, 0x75, 0x5b, 0x00},   // 32 0c4d 9644 Ã§Â¸Â«
    {0x7f, 0x15, 0x7f, 0x04, 0x73, 0x56, 0x5e, 0x00},   // 32 0c4e 9645 Ã¨Æ’Å¾
    {0x4a, 0x4a, 0x3b, 0x2e, 0x2b, 0x6a, 0x0a, 0x00},   // 32 0c4f 9646 Ã¨Å Â³
    {0x3e, 0x2a, 0x3f, 0x42, 0x3f, 0x2a, 0x7e, 0x00},   // 32 0c50 9647 Ã¨ÂÅ’
    {0x52, 0x36, 0x4b, 0x5a, 0x77, 0x4e, 0x52, 0x00},   // 32 0c51 9648 Ã¨â€œÂ¬
    {0x4e, 0x7b, 0x2e, 0x2a, 0x75, 0x2b, 0x28, 0x00},   // 32 0c52 9649 Ã¨Å“â€š
    {0x2a, 0x2e, 0x72, 0x4f, 0x1a, 0x2e, 0x52, 0x00},   // 32 0c53 964a Ã¨Â¤â€™
    {0x6b, 0x6a, 0x42, 0x3e, 0x0b, 0x4a, 0x7a, 0x00},   // 32 0c54 964b Ã¨Â¨Âª
    {0x48, 0x5e, 0x77, 0x56, 0x77, 0x5e, 0x48, 0x00},   // 32 0c55 964c Ã¨Â±Å 
    {0x2a, 0x6a, 0x3f, 0x2a, 0x7f, 0x25, 0x1b, 0x00},   // 32 0c56 964d Ã©â€šÂ¦
    {0x56, 0x7d, 0x2a, 0x2a, 0x75, 0x2b, 0x28, 0x00},   // 32 0c57 964e Ã©â€¹â€™
    {0x7a, 0x5d, 0x5a, 0x04, 0x73, 0x56, 0x5e, 0x00},   // 32 0c58 964f Ã©Â£Â½
    {0x40, 0x3f, 0x5d, 0x1f, 0x71, 0x7f, 0x40, 0x00},   // 32 0c59 9650 Ã©Â³Â³
    {0x7f, 0x15, 0x7f, 0x7f, 0x5e, 0x17, 0x76, 0x00},   // 32 0c5a 9651 Ã©ÂµÂ¬
    {0x40, 0x35, 0x25, 0x57, 0x4d, 0x45, 0x40, 0x00},   // 32 0c5b 9652 Ã¤Â¹Â
    {0x02, 0x3e, 0x42, 0x43, 0x42, 0x42, 0x42, 0x00},   // 32 0c5c 9653 Ã¤ÂºÂ¡
    {0x04, 0x7e, 0x1b, 0x4e, 0x3b, 0x6e, 0x1a, 0x00},   // 32 0c5d 9654 Ã¥â€šÂ
    {0x0a, 0x6e, 0x6b, 0x6e, 0x0e, 0x40, 0x7f, 0x00},   // 32 0c5e 9655 Ã¥â€°â€“
    {0x24, 0x3f, 0x14, 0x42, 0x3e, 0x4b, 0x7a, 0x00},   // 32 0c5f 9656 Ã¥ÂÅ 
    {0x5c, 0x37, 0x2c, 0x42, 0x3e, 0x4b, 0x7a, 0x00},   // 32 0c60 9657 Ã¥Â¦Â¨
    {0x0e, 0x7f, 0x07, 0x7d, 0x55, 0x7d, 0x07, 0x00},   // 32 0c61 9658 Ã¥Â¸Â½
    {0x62, 0x3e, 0x4a, 0x5b, 0x6a, 0x1a, 0x62, 0x00},   // 32 0c62 9659 Ã¥Â¿Ëœ
    {0x06, 0x7f, 0x02, 0x3e, 0x43, 0x42, 0x42, 0x00},   // 32 0c63 965a Ã¥Â¿â„¢
    {0x41, 0x3f, 0x55, 0x35, 0x5d, 0x77, 0x11, 0x00},   // 32 0c64 965b Ã¦Ë†Â¿
    {0x48, 0x5b, 0x2f, 0x7b, 0x2f, 0x5b, 0x48, 0x00},   // 32 0c65 965c Ã¦Å¡Â´
    {0x52, 0x5e, 0x5b, 0x7a, 0x57, 0x55, 0x5f, 0x00},   // 32 0c66 965d Ã¦Å“â€º
    {0x52, 0x52, 0x3f, 0x7a, 0x3f, 0x52, 0x52, 0x00},   // 32 0c67 965e Ã¦Å¸Â
    {0x1a, 0x7f, 0x14, 0x2e, 0x77, 0x2e, 0x14, 0x00},   // 32 0c68 965f Ã¦Â£â€™
    {0x07, 0x7d, 0x55, 0x55, 0x55, 0x7d, 0x07, 0x00},   // 32 0c69 9660 Ã¥â€ â€™
    {0x2a, 0x75, 0x28, 0x42, 0x3e, 0x4b, 0x7a, 0x00},   // 32 0c6a 9661 Ã§Â´Â¡
    {0x7f, 0x15, 0x7f, 0x42, 0x3e, 0x4b, 0x7a, 0x00},   // 32 0c6b 9662 Ã¨â€šÂª
    {0x7f, 0x15, 0x7f, 0x5a, 0x7f, 0x4a, 0x25, 0x00},   // 32 0c6c 9663 Ã¨â€ Â¨
    {0x6b, 0x6a, 0x52, 0x3f, 0x7a, 0x3f, 0x52, 0x00},   // 32 0c6d 9664 Ã¨Â¬â‚¬
    {0x2a, 0x56, 0x3d, 0x5e, 0x2b, 0x6a, 0x5e, 0x00},   // 32 0c6e 9665 Ã¨Â²Å’
    {0x46, 0x7e, 0x2d, 0x28, 0x2d, 0x7b, 0x47, 0x00},   // 32 0c6f 9666 Ã¨Â²Â¿
    {0x56, 0x7d, 0x36, 0x2e, 0x7d, 0x2c, 0x26, 0x00},   // 32 0c70 9667 Ã©â€°Â¾
    {0x7f, 0x25, 0x1b, 0x42, 0x3e, 0x4b, 0x7a, 0x00},   // 32 0c71 9668 Ã©ËœÂ²
    {0x1e, 0x12, 0x5e, 0x24, 0x1f, 0x24, 0x45, 0x00},   // 32 0c72 9669 Ã¥ÂÂ 
    {0x5a, 0x52, 0x3f, 0x5a, 0x5d, 0x17, 0x5d, 0x00},   // 32 0c73 966a Ã©Â Â¬
    {0x24, 0x14, 0x7f, 0x00, 0x7f, 0x48, 0x64, 0x00},   // 32 0c74 966b Ã¥Å’â€”
    {0x04, 0x7e, 0x4b, 0x5e, 0x3b, 0x5e, 0x4b, 0x00},   // 32 0c75 966c Ã¥Æ’â€¢
    {0x00, 0x00, 0x7f, 0x04, 0x08, 0x10, 0x00, 0x00},   // 32 0c76 966d Ã¥ÂÅ“
    {0x54, 0x47, 0x55, 0x67, 0x55, 0x47, 0x54, 0x00},   // 32 0c77 966e Ã¥Â¢Â¨
    {0x52, 0x7f, 0x4b, 0x5e, 0x3b, 0x5e, 0x4b, 0x00},   // 32 0c78 966f Ã¦â€™Â²
    {0x22, 0x1a, 0x7f, 0x0a, 0x7f, 0x08, 0x10, 0x00},   // 32 0c79 9670 Ã¦Å“Â´
    {0x17, 0x7f, 0x44, 0x5f, 0x22, 0x5e, 0x42, 0x00},   // 32 0c7a 9671 Ã§â€°Â§
    {0x7f, 0x55, 0x7f, 0x4e, 0x67, 0x5e, 0x54, 0x00},   // 32 0c7b 9672 Ã§ÂÂ¦
    {0x35, 0x7f, 0x08, 0x46, 0x5f, 0x56, 0x28, 0x00},   // 32 0c7c 9673 Ã§Â©â€ 
    {0x54, 0x76, 0x7d, 0x36, 0x7e, 0x42, 0x7e, 0x00},   // 32 0c7d 9674 Ã©â€¡Â¦
    {0x2c, 0x66, 0x77, 0x2c, 0x62, 0x1f, 0x7e, 0x00},   // 32 0c7e 9675 Ã¥â€¹Æ’
    {0x65, 0x10, 0x44, 0x5b, 0x29, 0x5f, 0x44, 0x00},   // 32 0c7f 9676 Ã¦Â²Â¡
    {0x49, 0x37, 0x1d, 0x6c, 0x6b, 0x64, 0x08, 0x00},   // 32 0c80 9677 Ã¦Â®â€ 
    {0x24, 0x3f, 0x1f, 0x65, 0x4d, 0x7d, 0x6f, 0x00},   // 32 0c81 9678 Ã¥Â â‚¬
    {0x0e, 0x7f, 0x54, 0x33, 0x1f, 0x73, 0x54, 0x00},   // 32 0c82 9679 Ã¥Â¹Å’
    {0x2a, 0x6a, 0x36, 0x3b, 0x76, 0x2a, 0x2a, 0x00},   // 32 0c83 967a Ã¥Â¥â€
    {0x22, 0x12, 0x2a, 0x7f, 0x2a, 0x12, 0x22, 0x00},   // 32 0c84 967b Ã¦Å“Â¬
    {0x15, 0x6f, 0x7f, 0x35, 0x7f, 0x35, 0x7f, 0x00},   // 32 0c85 967c Ã§Â¿Â»
    {0x40, 0x3f, 0x05, 0x19, 0x01, 0x7f, 0x40, 0x00},   // 32 0c86 967d Ã¥â€¡Â¡
    {0x44, 0x72, 0x55, 0x7c, 0x55, 0x7e, 0x44, 0x00},   // 32 0c87 967e Ã§â€ºâ€ 
    {0x40, 0x3e, 0x2a, 0x7e, 0x6b, 0x3e, 0x2a, 0x00},   // 33 0c88 9680 Ã¦â€˜Â©
    {0x40, 0x3e, 0x4a, 0x3e, 0x6b, 0x7e, 0x2a, 0x00},   // 33 0c89 9681 Ã§Â£Â¨
    {0x40, 0x3e, 0x4a, 0x3e, 0x3b, 0x7e, 0x4a, 0x00},   // 33 0c8a 9682 Ã©Â­â€
    {0x40, 0x3e, 0x2a, 0x7e, 0x2b, 0x7e, 0x2a, 0x00},   // 33 0c8b 9683 Ã©ÂºÂ»
    {0x24, 0x3f, 0x5f, 0x55, 0x7f, 0x55, 0x5f, 0x00},   // 33 0c8c 9684 Ã¥Å¸â€¹
    {0x5c, 0x37, 0x4c, 0x2a, 0x7f, 0x2a, 0x48, 0x00},   // 33 0c8d 9685 Ã¥Â¦Â¹
    {0x3e, 0x2a, 0x7e, 0x2a, 0x7f, 0x2a, 0x48, 0x00},   // 33 0c8e 9686 Ã¦ËœÂ§
    {0x1a, 0x7f, 0x44, 0x5f, 0x22, 0x5e, 0x42, 0x00},   // 33 0c8f 9687 Ã¦Å¾Å¡
    {0x0c, 0x3b, 0x2e, 0x3e, 0x6a, 0x7e, 0x2a, 0x00},   // 33 0c90 9688 Ã¦Â¯Å½
    {0x1e, 0x12, 0x5f, 0x55, 0x7f, 0x55, 0x5f, 0x00},   // 33 0c91 9689 Ã¥â€œÂ©
    {0x1a, 0x7f, 0x52, 0x1e, 0x1f, 0x1e, 0x52, 0x00},   // 33 0c92 968a Ã¦Â§â„¢
    {0x2a, 0x1a, 0x6f, 0x7e, 0x2f, 0x7a, 0x1a, 0x00},   // 33 0c93 968b Ã¥Â¹â€¢
    {0x7f, 0x15, 0x7f, 0x52, 0x5f, 0x3e, 0x53, 0x00},   // 33 0c94 968c Ã¨â€ Å“
    {0x1a, 0x7f, 0x46, 0x22, 0x1f, 0x7a, 0x46, 0x00},   // 33 0c95 968d Ã¦Å¾â€¢
    {0x42, 0x1d, 0x5f, 0x12, 0x7f, 0x2a, 0x7a, 0x00},   // 33 0c96 968e Ã©Â®Âª
    {0x1a, 0x7f, 0x4a, 0x79, 0x41, 0x7f, 0x49, 0x00},   // 33 0c97 968f Ã¦Å¸Â¾
    {0x5d, 0x1f, 0x5e, 0x37, 0x52, 0x77, 0x1e, 0x00},   // 33 0c98 9690 Ã©Â±â€™
    {0x1a, 0x7f, 0x44, 0x2b, 0x1e, 0x12, 0x7f, 0x00},   // 33 0c99 9691 Ã¦Â¡Â
    {0x22, 0x5a, 0x3e, 0x43, 0x7e, 0x0a, 0x32, 0x00},   // 33 0c9a 9692 Ã¤ÂºÂ¦
    {0x04, 0x7e, 0x45, 0x57, 0x3d, 0x57, 0x44, 0x00},   // 33 0c9b 9693 Ã¤Â¿Â£
    {0x40, 0x41, 0x2d, 0x11, 0x29, 0x47, 0x40, 0x00},   // 33 0c9c 9694 Ã¥ÂË†
    {0x52, 0x7f, 0x42, 0x2a, 0x7f, 0x2a, 0x42, 0x00},   // 33 0c9d 9695 Ã¦Å Â¹
    {0x42, 0x4a, 0x2a, 0x7f, 0x2a, 0x4a, 0x42, 0x00},   // 33 0c9e 9696 Ã¦Å“Â«
    {0x65, 0x10, 0x42, 0x2a, 0x7f, 0x2a, 0x42, 0x00},   // 33 0c9f 9697 Ã¦Â²Â«
    {0x49, 0x38, 0x44, 0x53, 0x6e, 0x66, 0x72, 0x00},   // 33 0ca0 9698 Ã¨Â¿â€ž
    {0x04, 0x7e, 0x11, 0x0f, 0x55, 0x4d, 0x17, 0x00},   // 33 0ca1 9699 Ã¤Â¾Â­
    {0x7a, 0x2a, 0x5f, 0x7a, 0x2f, 0x7a, 0x7a, 0x00},   // 33 0ca2 969a Ã§Â¹Â­
    {0x40, 0x3e, 0x6a, 0x7e, 0x6b, 0x7e, 0x6a, 0x00},   // 33 0ca3 969b Ã©ÂºÂ¿
    {0x41, 0x21, 0x1f, 0x05, 0x45, 0x7d, 0x01, 0x00},   // 33 0ca4 969c Ã¤Â¸â€¡
    {0x06, 0x7f, 0x4c, 0x5f, 0x2d, 0x5f, 0x4c, 0x00},   // 33 0ca5 969d Ã¦â€¦Â¢
    {0x75, 0x00, 0x7a, 0x2f, 0x3a, 0x2f, 0x7a, 0x00},   // 33 0ca6 969e Ã¦Âºâ‚¬
    {0x75, 0x00, 0x4c, 0x5f, 0x2d, 0x5f, 0x4c, 0x00},   // 33 0ca7 969f Ã¦Â¼Â«
    {0x42, 0x5a, 0x5f, 0x2e, 0x5f, 0x5a, 0x42, 0x00},   // 33 0ca8 96a0 Ã¨â€â€œ
    {0x1e, 0x12, 0x5e, 0x2a, 0x7f, 0x2a, 0x48, 0x00},   // 33 0ca9 96a1 Ã¥â€˜Â³
    {0x48, 0x4a, 0x2a, 0x7f, 0x2a, 0x4a, 0x48, 0x00},   // 33 0caa 96a2 Ã¦Å“Âª
    {0x4e, 0x3f, 0x6e, 0x5a, 0x7f, 0x5a, 0x68, 0x00},   // 33 0cab 96a3 Ã©Â­â€¦
    {0x3f, 0x49, 0x49, 0x49, 0x49, 0x4f, 0x60, 0x00},   // 33 0cac 96a4 Ã¥Â·Â³
    {0x24, 0x6b, 0x3e, 0x2c, 0x3b, 0x6e, 0x22, 0x00},   // 33 0cad 96a5 Ã§Â®â€¢
    {0x38, 0x3f, 0x3f, 0x15, 0x7f, 0x15, 0x1f, 0x00},   // 33 0cae 96a6 Ã¥Â²Â¬
    {0x16, 0x6a, 0x5e, 0x73, 0x56, 0x62, 0x16, 0x00},   // 33 0caf 96a7 Ã¥Â¯â€ 
    {0x56, 0x4a, 0x5e, 0x7b, 0x5e, 0x2a, 0x46, 0x00},   // 33 0cb0 96a8 Ã¨Å“Å“
    {0x75, 0x28, 0x1a, 0x4e, 0x3f, 0x4e, 0x1a, 0x00},   // 33 0cb1 96a9 Ã¦Â¹Å 
    {0x2a, 0x2a, 0x7f, 0x56, 0x3f, 0x4a, 0x4a, 0x00},   // 33 0cb2 96aa Ã¨â€œâ€˜
    {0x35, 0x7f, 0x64, 0x2a, 0x4d, 0x5e, 0x64, 0x00},   // 33 0cb3 96ab Ã§Â¨â€
    {0x7f, 0x15, 0x7f, 0x7a, 0x0a, 0x35, 0x55, 0x00},   // 33 0cb4 96ac Ã¨â€žË†
    {0x5c, 0x37, 0x2c, 0x46, 0x5f, 0x22, 0x14, 0x00},   // 33 0cb5 96ad Ã¥Â¦â„¢
    {0x35, 0x7e, 0x15, 0x2a, 0x2a, 0x7e, 0x55, 0x00},   // 33 0cb6 96ae Ã§Â²Â
    {0x40, 0x7f, 0x55, 0x1d, 0x35, 0x57, 0x50, 0x00},   // 33 0cb7 96af Ã¦Â°â€˜
    {0x7f, 0x55, 0x7f, 0x7f, 0x55, 0x3d, 0x57, 0x00},   // 33 0cb8 96b0 Ã§Å“Â 
    {0x29, 0x5d, 0x7b, 0x54, 0x3b, 0x56, 0x7a, 0x00},   // 33 0cb9 96b1 Ã¥â€¹â„¢
    {0x1a, 0x4e, 0x5b, 0x7e, 0x3b, 0x0e, 0x1a, 0x00},   // 33 0cba 96b2 Ã¥Â¤Â¢
    {0x6b, 0x3e, 0x6a, 0x3e, 0x6a, 0x3e, 0x6a, 0x00},   // 33 0cbb 96b3 Ã§â€žÂ¡
    {0x24, 0x34, 0x2e, 0x7d, 0x2c, 0x2a, 0x24, 0x00},   // 33 0cbc 96b4 Ã§â€°Å¸
    {0x28, 0x29, 0x19, 0x4b, 0x7d, 0x0b, 0x18, 0x00},   // 33 0cbd 96b5 Ã§Å¸â€º
    {0x56, 0x3a, 0x7f, 0x17, 0x5b, 0x2e, 0x76, 0x00},   // 33 0cbe 96b6 Ã©Å“Â§
    {0x75, 0x65, 0x3e, 0x45, 0x5e, 0x17, 0x76, 0x00},   // 33 0cbf 96b7 Ã©ÂµÂ¡
    {0x1a, 0x7f, 0x22, 0x4e, 0x7b, 0x0e, 0x22, 0x00},   // 33 0cc0 96b8 Ã¦Â¤â€¹
    {0x5c, 0x37, 0x2c, 0x09, 0x77, 0x2d, 0x7b, 0x00},   // 33 0cc1 96b9 Ã¥Â©Â¿
    {0x5c, 0x37, 0x2c, 0x7e, 0x5b, 0x3a, 0x5e, 0x00},   // 33 0cc2 96ba Ã¥Â¨Ëœ
    {0x53, 0x51, 0x1f, 0x1b, 0x1f, 0x51, 0x53, 0x00},   // 33 0cc3 96bb Ã¥â€ Â¥
    {0x20, 0x24, 0x13, 0x7d, 0x55, 0x53, 0x70, 0x00},   // 33 0cc4 96bc Ã¥ÂÂ
    {0x34, 0x34, 0x32, 0x05, 0x76, 0x14, 0x34, 0x00},   // 33 0cc5 96bd Ã¥â€˜Â½
    {0x1f, 0x15, 0x5f, 0x20, 0x1f, 0x55, 0x7f, 0x00},   // 33 0cc6 96be Ã¦ËœÅ½
    {0x47, 0x75, 0x57, 0x78, 0x57, 0x75, 0x4f, 0x00},   // 33 0cc7 96bf Ã§â€ºÅ¸
    {0x49, 0x38, 0x55, 0x4c, 0x7f, 0x4c, 0x55, 0x00},   // 33 0cc8 96c0 Ã¨Â¿Â·
    {0x56, 0x7d, 0x36, 0x14, 0x7b, 0x55, 0x73, 0x00},   // 33 0cc9 96c1 Ã©Å Ëœ
    {0x1e, 0x1e, 0x40, 0x1e, 0x57, 0x16, 0x70, 0x00},   // 33 0cca 96c2 Ã©Â³Â´
    {0x5c, 0x37, 0x2c, 0x45, 0x57, 0x7d, 0x55, 0x00},   // 33 0ccb 96c3 Ã¥Â§Âª
    {0x14, 0x13, 0x7f, 0x0a, 0x7f, 0x48, 0x64, 0x00},   // 33 0ccc 96c4 Ã§â€°Â
    {0x75, 0x3e, 0x56, 0x3e, 0x56, 0x3f, 0x52, 0x00},   // 33 0ccd 96c5 Ã¦Â»â€¦
    {0x42, 0x5e, 0x35, 0x1d, 0x77, 0x5c, 0x60, 0x00},   // 33 0cce 96c6 Ã¥â€¦Â
    {0x1a, 0x7f, 0x30, 0x1e, 0x7b, 0x1e, 0x30, 0x00},   // 33 0ccf 96c7 Ã¦Â£â€°
    {0x2a, 0x75, 0x30, 0x1e, 0x7b, 0x1e, 0x30, 0x00},   // 33 0cd0 96c8 Ã§Â¶Â¿
    {0x2a, 0x75, 0x28, 0x7d, 0x57, 0x7d, 0x7d, 0x00},   // 33 0cd1 96c9 Ã§Â·Â¬
    {0x7d, 0x45, 0x7d, 0x57, 0x7d, 0x45, 0x7d, 0x00},   // 33 0cd2 96ca Ã©ÂÂ¢
    {0x52, 0x2f, 0x5a, 0x7d, 0x57, 0x7d, 0x7d, 0x00},   // 33 0cd3 96cb Ã©ÂºÂº
    {0x52, 0x7f, 0x52, 0x5f, 0x36, 0x5f, 0x52, 0x00},   // 33 0cd4 96cc Ã¦â€˜Â¸
    {0x1a, 0x7f, 0x52, 0x5f, 0x36, 0x5f, 0x52, 0x00},   // 33 0cd5 96cd Ã¦Â¨Â¡
    {0x42, 0x3a, 0x0f, 0x4a, 0x5f, 0x2a, 0x5a, 0x00},   // 33 0cd6 96ce Ã¨Å’â€š
    {0x52, 0x5e, 0x7a, 0x5b, 0x3a, 0x5a, 0x52, 0x00},   // 33 0cd7 96cf Ã¥Â¦â€ž
    {0x44, 0x75, 0x55, 0x7d, 0x57, 0x75, 0x44, 0x00},   // 33 0cd8 96d0 Ã¥Â­Å¸
    {0x28, 0x2a, 0x2a, 0x7e, 0x55, 0x55, 0x54, 0x00},   // 33 0cd9 96d1 Ã¦Â¯â€º
    {0x55, 0x3e, 0x45, 0x74, 0x7d, 0x77, 0x44, 0x00},   // 33 0cda 96d2 Ã§Å’â€º
    {0x02, 0x7e, 0x5a, 0x5b, 0x5a, 0x7a, 0x02, 0x00},   // 33 0cdb 96d3 Ã§â€ºÂ²
    {0x2a, 0x7d, 0x7f, 0x0d, 0x39, 0x2d, 0x7f, 0x00},   // 33 0cdc 96d4 Ã§Â¶Â²
    {0x2a, 0x7f, 0x2a, 0x2a, 0x7e, 0x55, 0x54, 0x00},   // 33 0cdd 96d5 Ã¨â‚¬â€”
    {0x5a, 0x5a, 0x2f, 0x5a, 0x7f, 0x2a, 0x5a, 0x00},   // 33 0cde 96d6 Ã¨â€™â„¢
    {0x04, 0x7e, 0x6b, 0x62, 0x1a, 0x6f, 0x6a, 0x00},   // 33 0cdf 96d7 Ã¥â€žÂ²
    {0x22, 0x12, 0x0a, 0x7f, 0x0a, 0x12, 0x22, 0x00},   // 33 0ce0 96d8 Ã¦Å“Â¨
    {0x57, 0x1f, 0x57, 0x12, 0x4f, 0x12, 0x53, 0x00},   // 33 0ce1 96d9 Ã©Â»â„¢
    {0x00, 0x7f, 0x55, 0x55, 0x55, 0x55, 0x7f, 0x00},   // 33 0ce2 96da Ã§â€ºÂ®
    {0x4a, 0x5a, 0x56, 0x7f, 0x56, 0x5a, 0x4a, 0x00},   // 33 0ce3 96db Ã¦ÂÂ¢
    {0x24, 0x13, 0x4e, 0x22, 0x1e, 0x42, 0x7e, 0x00},   // 33 0ce4 96dc Ã¥â€¹Â¿
    {0x7a, 0x5d, 0x56, 0x3d, 0x14, 0x7d, 0x14, 0x00},   // 33 0ce5 96dd Ã©Â¤â€¦
    {0x42, 0x42, 0x22, 0x1f, 0x7a, 0x43, 0x62, 0x00},   // 33 0ce6 96de Ã¥Â°Â¤
    {0x41, 0x3f, 0x55, 0x55, 0x3d, 0x57, 0x51, 0x00},   // 33 0ce7 96df Ã¦Ë†Â»
    {0x35, 0x7e, 0x15, 0x49, 0x3f, 0x51, 0x7f, 0x00},   // 33 0ce8 96e0 Ã§Â±Â¾
    {0x42, 0x7f, 0x2a, 0x2f, 0x2a, 0x7f, 0x4a, 0x00},   // 33 0ce9 96e1 Ã¨Â²Â°
    {0x7f, 0x05, 0x77, 0x50, 0x77, 0x05, 0x7f, 0x00},   // 33 0cea 96e2 Ã¥â€¢Â
    {0x7f, 0x25, 0x77, 0x48, 0x67, 0x25, 0x7f, 0x00},   // 33 0ceb 96e3 Ã¦â€šÂ¶
    {0x2a, 0x75, 0x42, 0x2e, 0x13, 0x2e, 0x42, 0x00},   // 33 0cec 96e4 Ã§Â´â€¹
    {0x7f, 0x05, 0x07, 0x00, 0x07, 0x45, 0x7f, 0x00},   // 33 0ced 96e5 Ã©â€“â‚¬
    {0x48, 0x47, 0x2a, 0x1e, 0x12, 0x52, 0x7e, 0x00},   // 33 0cee 96e6 Ã¥Å’Â
    {0x08, 0x08, 0x3e, 0x48, 0x5f, 0x44, 0x6c, 0x00},   // 33 0cef 96e7 Ã¤Â¹Å¸
    {0x71, 0x00, 0x08, 0x6c, 0x6b, 0x64, 0x08, 0x00},   // 33 0cf0 96e8 Ã¥â€ Â¶
    {0x12, 0x7a, 0x06, 0x53, 0x5e, 0x2a, 0x5a, 0x00},   // 33 0cf1 96e9 Ã¥Â¤Å“
    {0x2a, 0x3a, 0x35, 0x74, 0x05, 0x7a, 0x2a, 0x00},   // 33 0cf2 96ea Ã§Ë†Âº
    {0x21, 0x3f, 0x2d, 0x7f, 0x11, 0x7f, 0x1b, 0x00},   // 33 0cf3 96eb Ã¨â‚¬Â¶
    {0x5f, 0x55, 0x7f, 0x5f, 0x49, 0x7d, 0x1b, 0x00},   // 33 0cf4 96ec Ã©â€¡Å½
    {0x5d, 0x77, 0x24, 0x5b, 0x7e, 0x0a, 0x32, 0x00},   // 33 0cf5 96ed Ã¥Â¼Â¥
    {0x4c, 0x4b, 0x2a, 0x1e, 0x2a, 0x4a, 0x48, 0x00},   // 33 0cf6 96ee Ã§Å¸Â¢
    {0x40, 0x3f, 0x01, 0x7d, 0x45, 0x5d, 0x61, 0x00},   // 33 0cf7 96ef Ã¥Å½â€ž
    {0x0a, 0x7d, 0x44, 0x5b, 0x29, 0x5f, 0x44, 0x00},   // 33 0cf8 96f0 Ã¥Â½Â¹
    {0x2a, 0x75, 0x28, 0x04, 0x0b, 0x52, 0x7e, 0x00},   // 33 0cf9 96f1 Ã§Â´â€ž
    {0x56, 0x5a, 0x3f, 0x76, 0x3f, 0x5a, 0x56, 0x00},   // 33 0cfa 96f2 Ã¨â€“Â¬
    {0x6a, 0x6b, 0x40, 0x3f, 0x05, 0x1d, 0x67, 0x00},   // 33 0cfb 96f3 Ã¨Â¨Â³
    {0x77, 0x7d, 0x57, 0x20, 0x75, 0x7f, 0x57, 0x00},   // 33 0cfc 96f4 Ã¨ÂºÂ
    {0x2e, 0x33, 0x2e, 0x7a, 0x2f, 0x7a, 0x08, 0x00},   // 33 0cfd 96f5 Ã©Ââ€“
    {0x1a, 0x7f, 0x5e, 0x3d, 0x00, 0x7f, 0x1f, 0x00},   // 33 0cfe 96f6 Ã¦Å¸Â³
    {0x56, 0x6a, 0x5f, 0x36, 0x5b, 0x26, 0x5e, 0x00},   // 33 0cff 96f7 Ã¨â€“Â®
    {0x56, 0x7d, 0x36, 0x79, 0x46, 0x7f, 0x76, 0x00},   // 33 0d00 96f8 Ã©â€˜â€œ
    {0x06, 0x7f, 0x04, 0x72, 0x75, 0x06, 0x74, 0x00},   // 33 0d01 96f9 Ã¦â€žâ€°
    {0x64, 0x3c, 0x5a, 0x5d, 0x66, 0x1c, 0x64, 0x00},   // 33 0d02 96fa Ã¦â€žË†
    {0x75, 0x00, 0x7e, 0x4a, 0x7f, 0x4a, 0x7e, 0x00},   // 33 0d03 96fb Ã¦Â²Â¹
    {0x54, 0x3e, 0x5a, 0x3a, 0x47, 0x5a, 0x6a, 0x00},   // 33 0d04 96fc Ã§â„¢â€™
    {0x6a, 0x6b, 0x04, 0x72, 0x75, 0x06, 0x74, 0x00},   // 34 0d05 9740 Ã¨Â«Â­
    {0x2d, 0x7f, 0x2d, 0x72, 0x75, 0x06, 0x74, 0x00},   // 34 0d06 9741 Ã¨Â¼Â¸
    {0x1e, 0x12, 0x1e, 0x7f, 0x4a, 0x7f, 0x4a, 0x00},   // 34 0d07 9742 Ã¥â€Â¯
    {0x04, 0x7e, 0x13, 0x7e, 0x4b, 0x4a, 0x7a, 0x00},   // 34 0d08 9743 Ã¤Â½â€˜
    {0x04, 0x7e, 0x59, 0x5f, 0x2f, 0x5f, 0x59, 0x00},   // 34 0d09 9744 Ã¥â€žÂª
    {0x50, 0x5d, 0x35, 0x1d, 0x17, 0x5d, 0x70, 0x00},   // 34 0d0a 9745 Ã¥â€¹â€¡
    {0x22, 0x52, 0x4f, 0x5a, 0x2a, 0x5a, 0x42, 0x00},   // 34 0d0b 9746 Ã¥Ââ€¹
    {0x26, 0x2a, 0x1e, 0x7b, 0x2a, 0x7a, 0x06, 0x00},   // 34 0d0c 9747 Ã¥Â®Â¥
    {0x7e, 0x5a, 0x55, 0x7f, 0x5a, 0x55, 0x7e, 0x00},   // 34 0d0d 9748 Ã¥Â¹Â½
    {0x64, 0x2e, 0x41, 0x4e, 0x6a, 0x05, 0x6b, 0x00},   // 34 0d0e 9749 Ã¦â€šÂ 
    {0x59, 0x59, 0x2f, 0x5f, 0x3f, 0x49, 0x59, 0x00},   // 34 0d0f 974a Ã¦â€ â€š
    {0x52, 0x7f, 0x24, 0x3f, 0x2d, 0x7f, 0x24, 0x00},   // 34 0d10 974b Ã¦Ââ€“
    {0x12, 0x0a, 0x7f, 0x2a, 0x2a, 0x7a, 0x02, 0x00},   // 34 0d11 974c Ã¦Å“â€°
    {0x1a, 0x7f, 0x7e, 0x4a, 0x7f, 0x4a, 0x7e, 0x00},   // 34 0d12 974d Ã¦Å¸Å¡
    {0x75, 0x00, 0x50, 0x5d, 0x3d, 0x57, 0x7d, 0x00},   // 34 0d13 974e Ã¦Â¹Â§
    {0x75, 0x00, 0x7d, 0x15, 0x7d, 0x17, 0x7d, 0x00},   // 34 0d14 974f Ã¦Â¶Å’
    {0x55, 0x3e, 0x7b, 0x5f, 0x4a, 0x5f, 0x7a, 0x00},   // 34 0d15 9750 Ã§Å’Â¶
    {0x7a, 0x5f, 0x4e, 0x7b, 0x44, 0x3f, 0x45, 0x00},   // 34 0d16 9751 Ã§Å’Â·
    {0x7e, 0x4a, 0x4a, 0x7f, 0x4a, 0x4a, 0x7e, 0x00},   // 34 0d17 9752 Ã§â€Â±
    {0x12, 0x7b, 0x16, 0x12, 0x7f, 0x4a, 0x7a, 0x00},   // 34 0d18 9753 Ã§Â¥Â
    {0x12, 0x7b, 0x36, 0x09, 0x64, 0x69, 0x12, 0x00},   // 34 0d19 9754 Ã¨Â£â€¢
    {0x6b, 0x62, 0x5a, 0x37, 0x1f, 0x37, 0x6a, 0x00},   // 34 0d1a 9755 Ã¨ÂªËœ
    {0x49, 0x38, 0x52, 0x6f, 0x5a, 0x77, 0x5e, 0x00},   // 34 0d1b 9756 Ã©ÂÅ 
    {0x3c, 0x57, 0x55, 0x5d, 0x57, 0x5c, 0x60, 0x00},   // 34 0d1c 9757 Ã©â€šâ€˜
    {0x54, 0x5d, 0x7f, 0x55, 0x7f, 0x25, 0x1b, 0x00},   // 34 0d1d 9758 Ã©Æ’Âµ
    {0x12, 0x6f, 0x52, 0x7f, 0x4a, 0x7f, 0x4a, 0x00},   // 34 0d1e 9759 Ã©â€ºâ€ž
    {0x79, 0x2f, 0x6f, 0x79, 0x4e, 0x7b, 0x6e, 0x00},   // 34 0d1f 975a Ã¨Å¾Â
    {0x00, 0x48, 0x44, 0x4b, 0x2a, 0x12, 0x0e, 0x00},   // 34 0d20 975b Ã¥Â¤â€¢
    {0x08, 0x09, 0x4b, 0x7d, 0x0b, 0x09, 0x18, 0x00},   // 34 0d21 975c Ã¤ÂºË†
    {0x54, 0x34, 0x56, 0x7d, 0x16, 0x34, 0x54, 0x00},   // 34 0d22 975d Ã¤Â½â„¢
    {0x10, 0x10, 0x1f, 0x5a, 0x7a, 0x12, 0x10, 0x00},   // 34 0d23 975e Ã¤Â¸Å½
    {0x0a, 0x67, 0x6a, 0x6b, 0x6a, 0x67, 0x0a, 0x00},   // 34 0d24 975f Ã¨Âªâ€°
    {0x5e, 0x55, 0x1a, 0x1f, 0x1a, 0x55, 0x5f, 0x00},   // 34 0d25 9760 Ã¨Â¼Â¿
    {0x08, 0x49, 0x7d, 0x1b, 0x5d, 0x17, 0x5d, 0x00},   // 34 0d26 9761 Ã©Â Â
    {0x04, 0x7e, 0x3f, 0x7a, 0x2e, 0x7f, 0x7a, 0x00},   // 34 0d27 9762 Ã¥â€šÂ­
    {0x44, 0x6c, 0x53, 0x28, 0x62, 0x1f, 0x7e, 0x00},   // 34 0d28 9763 Ã¥Â¹Â¼
    {0x44, 0x5c, 0x37, 0x2c, 0x4a, 0x3e, 0x49, 0x00},   // 34 0d29 9764 Ã¥Â¦â€“
    {0x26, 0x2a, 0x76, 0x6b, 0x76, 0x2a, 0x26, 0x00},   // 34 0d2a 9765 Ã¥Â®Â¹
    {0x40, 0x3e, 0x7a, 0x2e, 0x7f, 0x2e, 0x7a, 0x00},   // 34 0d2b 9766 Ã¥ÂºÂ¸
    {0x52, 0x7f, 0x24, 0x5f, 0x35, 0x57, 0x74, 0x00},   // 34 0d2c 9767 Ã¦ÂÅ¡
    {0x52, 0x7f, 0x68, 0x4a, 0x7e, 0x49, 0x6b, 0x00},   // 34 0d2d 9768 Ã¦ÂÂº
    {0x52, 0x7f, 0x5a, 0x36, 0x0b, 0x7e, 0x56, 0x00},   // 34 0d2e 9769 Ã¦â€œÂ
    {0x3e, 0x2a, 0x3e, 0x25, 0x77, 0x7d, 0x57, 0x00},   // 34 0d2f 976a Ã¦â€ºÅ“
    {0x1a, 0x7f, 0x24, 0x5f, 0x35, 0x57, 0x74, 0x00},   // 34 0d30 976b Ã¦Â¥Å 
    {0x1a, 0x7f, 0x5a, 0x2f, 0x7e, 0x2f, 0x5a, 0x00},   // 34 0d31 976c Ã¦Â§Ëœ
    {0x75, 0x00, 0x22, 0x2b, 0x7e, 0x2b, 0x22, 0x00},   // 34 0d32 976d Ã¦Â´â€¹
    {0x75, 0x00, 0x26, 0x16, 0x6b, 0x76, 0x26, 0x00},   // 34 0d33 976e Ã¦ÂºÂ¶
    {0x4c, 0x3f, 0x26, 0x16, 0x6b, 0x76, 0x26, 0x00},   // 34 0d34 976f Ã§â€ â€
    {0x40, 0x3f, 0x15, 0x7f, 0x15, 0x55, 0x7f, 0x00},   // 34 0d35 9770 Ã§â€Â¨
    {0x66, 0x2a, 0x6e, 0x3b, 0x6e, 0x2a, 0x66, 0x00},   // 34 0d36 9771 Ã§ÂªÂ¯
    {0x22, 0x2a, 0x2b, 0x7e, 0x2a, 0x2b, 0x22, 0x00},   // 34 0d37 9772 Ã§Â¾Å 
    {0x4a, 0x3c, 0x3f, 0x2a, 0x75, 0x7f, 0x57, 0x00},   // 34 0d38 9773 Ã¨â‚¬â‚¬
    {0x52, 0x5e, 0x33, 0x76, 0x37, 0x56, 0x52, 0x00},   // 34 0d39 9774 Ã¨â€˜â€°
    {0x26, 0x2a, 0x77, 0x6a, 0x77, 0x2a, 0x26, 0x00},   // 34 0d3a 9775 Ã¨â€œâ€°
    {0x51, 0x57, 0x75, 0x5f, 0x35, 0x57, 0x51, 0x00},   // 34 0d3b 9776 Ã¨Â¦Â
    {0x6a, 0x6b, 0x60, 0x4a, 0x7e, 0x49, 0x6b, 0x00},   // 34 0d3c 9777 Ã¨Â¬Â¡
    {0x77, 0x7d, 0x2b, 0x7c, 0x15, 0x7f, 0x7d, 0x00},   // 34 0d3d 9778 Ã¨Â¸Å 
    {0x49, 0x38, 0x6a, 0x4a, 0x7e, 0x49, 0x6b, 0x00},   // 34 0d3e 9779 Ã©ÂÂ¥
    {0x7f, 0x1b, 0x24, 0x5f, 0x35, 0x57, 0x74, 0x00},   // 34 0d3f 977a Ã©â„¢Â½
    {0x2a, 0x1a, 0x7b, 0x7e, 0x3a, 0x5b, 0x2a, 0x00},   // 34 0d40 977b Ã©Â¤Å 
    {0x64, 0x3d, 0x5a, 0x45, 0x53, 0x0e, 0x56, 0x00},   // 34 0d41 977c Ã¦â€¦Â¾
    {0x52, 0x7f, 0x3e, 0x11, 0x7e, 0x02, 0x1e, 0x00},   // 34 0d42 977d Ã¦Å â€˜
    {0x12, 0x69, 0x64, 0x69, 0x44, 0x3b, 0x46, 0x00},   // 34 0d43 977e Ã¦Â¬Â²
    {0x75, 0x00, 0x48, 0x4a, 0x3e, 0x49, 0x48, 0x00},   // 35 0d44 9780 Ã¦Â²Æ’
    {0x75, 0x00, 0x12, 0x69, 0x64, 0x69, 0x12, 0x00},   // 35 0d45 9781 Ã¦ÂµÂ´
    {0x49, 0x5b, 0x75, 0x5f, 0x7b, 0x55, 0x4f, 0x00},   // 35 0d46 9782 Ã§Â¿Å’
    {0x51, 0x5b, 0x15, 0x1f, 0x1b, 0x55, 0x57, 0x00},   // 35 0d47 9783 Ã§Â¿Â¼
    {0x75, 0x00, 0x46, 0x32, 0x47, 0x7e, 0x56, 0x00},   // 35 0d48 9784 Ã¦Â·â‚¬
    {0x2f, 0x75, 0x27, 0x7d, 0x57, 0x7d, 0x57, 0x00},   // 35 0d49 9785 Ã§Â¾â€¦
    {0x4e, 0x7b, 0x57, 0x1d, 0x77, 0x15, 0x57, 0x00},   // 35 0d4a 9786 Ã¨Å¾Âº
    {0x12, 0x7b, 0x57, 0x35, 0x7f, 0x35, 0x57, 0x00},   // 35 0d4b 9787 Ã¨Â£Â¸
    {0x52, 0x56, 0x32, 0x7f, 0x32, 0x56, 0x52, 0x00},   // 35 0d4c 9788 Ã¦ÂÂ¥
    {0x52, 0x56, 0x33, 0x7e, 0x33, 0x56, 0x52, 0x00},   // 35 0d4d 9789 Ã¨Å½Â±
    {0x42, 0x2e, 0x7f, 0x2e, 0x5d, 0x17, 0x5d, 0x00},   // 35 0d4e 978a Ã©Â Â¼
    {0x06, 0x72, 0x57, 0x77, 0x53, 0x76, 0x06, 0x00},   // 35 0d4f 978b Ã©â€ºÂ·
    {0x75, 0x00, 0x10, 0x6a, 0x65, 0x6b, 0x10, 0x00},   // 35 0d50 978c Ã¦Â´â€º
    {0x2a, 0x75, 0x10, 0x6a, 0x65, 0x6b, 0x10, 0x00},   // 35 0d51 978d Ã§ÂµÂ¡
    {0x56, 0x02, 0x2b, 0x6a, 0x57, 0x6e, 0x22, 0x00},   // 35 0d52 978e Ã¨ÂÂ½
    {0x7d, 0x6f, 0x7d, 0x0a, 0x65, 0x6b, 0x10, 0x00},   // 35 0d53 978f Ã©â€¦Âª
    {0x04, 0x76, 0x5e, 0x75, 0x7f, 0x40, 0x60, 0x00},   // 35 0d54 9790 Ã¤Â¹Â±
    {0x1e, 0x56, 0x3d, 0x00, 0x7f, 0x05, 0x1f, 0x00},   // 35 0d55 9791 Ã¥ÂÂµ
    {0x43, 0x3e, 0x5a, 0x7f, 0x3a, 0x7e, 0x43, 0x00},   // 35 0d56 9792 Ã¥ÂµÂ
    {0x1a, 0x7f, 0x7f, 0x2b, 0x7c, 0x2b, 0x7f, 0x00},   // 35 0d57 9793 Ã¦Â¬â€ž
    {0x75, 0x00, 0x4f, 0x69, 0x60, 0x6b, 0x4a, 0x00},   // 35 0d58 9794 Ã¦Â¿Â«
    {0x42, 0x5e, 0x77, 0x62, 0x6f, 0x4a, 0x4a, 0x00},   // 35 0d59 9795 Ã¨â€”Â
    {0x7e, 0x56, 0x37, 0x7a, 0x37, 0x56, 0x7e, 0x00},   // 35 0d5a 9796 Ã¨ËœÂ­
    {0x47, 0x47, 0x3d, 0x38, 0x7b, 0x46, 0x66, 0x00},   // 35 0d5b 9797 Ã¨Â¦Â§
    {0x24, 0x15, 0x7f, 0x15, 0x0e, 0x40, 0x7f, 0x00},   // 35 0d5c 9798 Ã¥Ë†Â©
    {0x42, 0x4e, 0x5a, 0x3f, 0x4a, 0x4e, 0x42, 0x00},   // 35 0d5d 9799 Ã¥ÂÂ
    {0x40, 0x3f, 0x2b, 0x77, 0x5f, 0x2b, 0x5b, 0x00},   // 35 0d5e 979a Ã¥Â±Â¥
    {0x2a, 0x2a, 0x26, 0x6f, 0x3e, 0x26, 0x2a, 0x00},   // 35 0d5f 979b Ã¦ÂÅ½
    {0x5a, 0x57, 0x3f, 0x7a, 0x37, 0x50, 0x5f, 0x00},   // 35 0d60 979c Ã¦Â¢Â¨
    {0x2a, 0x3e, 0x5f, 0x55, 0x7f, 0x55, 0x5f, 0x00},   // 35 0d61 979d Ã§Ââ€ 
    {0x2a, 0x3e, 0x72, 0x5e, 0x7b, 0x3e, 0x72, 0x00},   // 35 0d62 979e Ã§â€™Æ’
    {0x54, 0x3e, 0x2a, 0x7a, 0x27, 0x5a, 0x7a, 0x00},   // 35 0d63 979f Ã§â€”Â¢
    {0x52, 0x3e, 0x7a, 0x5f, 0x3a, 0x5e, 0x52, 0x00},   // 35 0d64 97a0 Ã¨Â£Â
    {0x12, 0x7b, 0x36, 0x5f, 0x55, 0x7f, 0x5f, 0x00},   // 35 0d65 97a1 Ã¨Â£Â¡
    {0x40, 0x5f, 0x55, 0x7f, 0x55, 0x5f, 0x40, 0x00},   // 35 0d66 97a2 Ã©â€¡Å’
    {0x72, 0x5e, 0x7b, 0x36, 0x7f, 0x7e, 0x4b, 0x00},   // 35 0d67 97a3 Ã©â€ºÂ¢
    {0x7f, 0x1b, 0x54, 0x4e, 0x67, 0x5e, 0x54, 0x00},   // 35 0d68 97a4 Ã©â„¢Â¸
    {0x0a, 0x7d, 0x2a, 0x2a, 0x7f, 0x2e, 0x24, 0x00},   // 35 0d69 97a5 Ã¥Â¾â€¹
    {0x22, 0x36, 0x2a, 0x77, 0x22, 0x36, 0x22, 0x00},   // 35 0d6a 97a6 Ã§Å½â€¡
    {0x42, 0x46, 0x7a, 0x43, 0x72, 0x4e, 0x42, 0x00},   // 35 0d6b 97a7 Ã§Â«â€¹
    {0x2a, 0x76, 0x2b, 0x2a, 0x7f, 0x3a, 0x22, 0x00},   // 35 0d6c 97a8 Ã¨â€˜Å½
    {0x52, 0x7f, 0x22, 0x4e, 0x7b, 0x0e, 0x22, 0x00},   // 35 0d6d 97a9 Ã¦Å½Â 
    {0x3e, 0x3e, 0x3e, 0x0a, 0x65, 0x6b, 0x10, 0x00},   // 35 0d6e 97aa Ã§â€¢Â¥
    {0x56, 0x6d, 0x74, 0x6b, 0x57, 0x00, 0x7f, 0x00},   // 35 0d6f 97ab Ã¥Å â€°
    {0x75, 0x00, 0x4a, 0x3e, 0x7b, 0x06, 0x6a, 0x00},   // 35 0d70 97ac Ã¦ÂµÂ
    {0x75, 0x00, 0x0e, 0x7a, 0x79, 0x77, 0x0f, 0x00},   // 35 0d71 97ad Ã¦ÂºÅ“
    {0x2a, 0x3e, 0x4a, 0x3e, 0x7b, 0x06, 0x6a, 0x00},   // 35 0d72 97ae Ã§Ââ€°
    {0x0e, 0x7a, 0x59, 0x74, 0x59, 0x77, 0x0f, 0x00},   // 35 0d73 97af Ã§â€¢â„¢
    {0x09, 0x37, 0x71, 0x2a, 0x6e, 0x0b, 0x6a, 0x00},   // 35 0d74 97b0 Ã§Â¡Â«
    {0x35, 0x7e, 0x43, 0x7e, 0x63, 0x5e, 0x42, 0x00},   // 35 0d75 97b1 Ã§Â²â€™
    {0x7f, 0x1b, 0x48, 0x5a, 0x75, 0x5b, 0x48, 0x00},   // 35 0d76 97b2 Ã©Å¡â€ 
    {0x08, 0x3a, 0x2e, 0x3b, 0x6e, 0x7a, 0x48, 0x00},   // 35 0d77 97b3 Ã§Â«Å“
    {0x0a, 0x7e, 0x2b, 0x7e, 0x0a, 0x77, 0x5d, 0x00},   // 35 0d78 97b4 Ã©Â¾Â
    {0x04, 0x7e, 0x01, 0x77, 0x5d, 0x55, 0x77, 0x00},   // 35 0d79 97b5 Ã¤Â¾Â¶
    {0x40, 0x3c, 0x64, 0x3c, 0x5f, 0x5a, 0x6a, 0x00},   // 35 0d7a 97b6 Ã¦â€¦Â®
    {0x62, 0x1f, 0x7a, 0x14, 0x7b, 0x26, 0x52, 0x00},   // 35 0d7b 97b7 Ã¦â€”â€¦
    {0x40, 0x3c, 0x24, 0x74, 0x3f, 0x3a, 0x6a, 0x00},   // 35 0d7c 97b8 Ã¨â„¢Å“
    {0x01, 0x01, 0x41, 0x7d, 0x05, 0x03, 0x01, 0x00},   // 35 0d7d 97b9 Ã¤Âºâ€ 
    {0x5a, 0x4e, 0x2a, 0x0b, 0x6a, 0x4e, 0x5a, 0x00},   // 35 0d7e 97ba Ã¤ÂºÂ®
    {0x04, 0x7e, 0x4b, 0x1e, 0x6b, 0x1e, 0x4a, 0x00},   // 35 0d7f 97bb Ã¥Æ’Å¡
    {0x7d, 0x35, 0x25, 0x3f, 0x25, 0x35, 0x7d, 0x00},   // 35 0d80 97bc Ã¤Â¸Â¡
    {0x71, 0x00, 0x28, 0x5a, 0x2f, 0x5a, 0x48, 0x00},   // 35 0d81 97bd Ã¥â€¡Å’
    {0x56, 0x0a, 0x3e, 0x6b, 0x3e, 0x0a, 0x56, 0x00},   // 35 0d82 97be Ã¥Â¯Â®
    {0x35, 0x7e, 0x25, 0x2a, 0x20, 0x7f, 0x10, 0x00},   // 35 0d83 97bf Ã¦â€“â„¢
    {0x55, 0x50, 0x39, 0x77, 0x39, 0x5f, 0x54, 0x00},   // 35 0d84 97c0 Ã¦Â¢Â
    {0x75, 0x00, 0x22, 0x4e, 0x7b, 0x0e, 0x22, 0x00},   // 35 0d85 97c1 Ã¦Â¶Â¼
    {0x55, 0x4a, 0x3d, 0x14, 0x7d, 0x16, 0x7d, 0x00},   // 35 0d86 97c2 Ã§Å’Å¸
    {0x54, 0x3e, 0x4a, 0x1e, 0x6b, 0x1e, 0x4a, 0x00},   // 35 0d87 97c3 Ã§â„¢â€š
    {0x7f, 0x55, 0x7f, 0x1e, 0x6b, 0x1e, 0x4a, 0x00},   // 35 0d88 97c4 Ã§Å¾Â­
    {0x35, 0x7f, 0x28, 0x5a, 0x2f, 0x5a, 0x48, 0x00},   // 35 0d89 97c5 Ã§Â¨Å“
    {0x35, 0x7e, 0x45, 0x5f, 0x7d, 0x5f, 0x44, 0x00},   // 35 0d8a 97c6 Ã§Â³Â§
    {0x40, 0x7e, 0x5a, 0x1b, 0x3a, 0x5e, 0x40, 0x00},   // 35 0d8b 97c7 Ã¨â€°Â¯
    {0x6b, 0x6a, 0x22, 0x4e, 0x7b, 0x0e, 0x22, 0x00},   // 35 0d8c 97c8 Ã¨Â«â€™
    {0x49, 0x38, 0x6a, 0x5e, 0x6b, 0x5e, 0x6a, 0x00},   // 35 0d8d 97c9 Ã©ÂÂ¼
    {0x44, 0x5f, 0x55, 0x7d, 0x55, 0x5f, 0x44, 0x00},   // 35 0d8e 97ca Ã©â€¡Â
    {0x7f, 0x1b, 0x28, 0x5a, 0x2f, 0x5a, 0x48, 0x00},   // 35 0d8f 97cb Ã©â„¢Âµ
    {0x16, 0x75, 0x36, 0x41, 0x1d, 0x17, 0x5d, 0x00},   // 35 0d90 97cc Ã©Â Ëœ
    {0x42, 0x22, 0x1a, 0x07, 0x02, 0x42, 0x7e, 0x00},   // 35 0d91 97cd Ã¥Å â€º
    {0x2a, 0x75, 0x54, 0x25, 0x7d, 0x27, 0x54, 0x00},   // 35 0d92 97ce Ã§Â·â€˜
    {0x04, 0x7e, 0x75, 0x32, 0x75, 0x36, 0x74, 0x00},   // 35 0d93 97cf Ã¥â‚¬Â«
    {0x40, 0x3f, 0x5f, 0x55, 0x7f, 0x55, 0x5f, 0x00},   // 35 0d94 97d0 Ã¥Å½Ëœ
    {0x22, 0x1a, 0x7f, 0x12, 0x0a, 0x7f, 0x12, 0x00},   // 35 0d95 97d1 Ã¦Å¾â€”
    {0x75, 0x22, 0x1a, 0x7f, 0x1a, 0x7f, 0x12, 0x00},   // 35 0d96 97d2 Ã¦Â·â€¹
    {0x4c, 0x3f, 0x55, 0x32, 0x27, 0x72, 0x25, 0x00},   // 35 0d97 97d3 Ã§â€¡Â
    {0x2a, 0x3e, 0x1a, 0x7f, 0x1a, 0x7f, 0x12, 0x00},   // 35 0d98 97d4 Ã§ÂÂ³
    {0x7f, 0x55, 0x77, 0x5d, 0x64, 0x6f, 0x6e, 0x00},   // 35 0d99 97d5 Ã¨â€¡Â¨
    {0x2d, 0x7f, 0x2d, 0x72, 0x35, 0x76, 0x74, 0x00},   // 35 0d9a 97d6 Ã¨Â¼Âª
    {0x7f, 0x25, 0x5b, 0x32, 0x27, 0x72, 0x25, 0x00},   // 35 0d9b 97d7 Ã©Å¡Â£
    {0x5d, 0x1f, 0x55, 0x32, 0x27, 0x72, 0x25, 0x00},   // 35 0d9c 97d8 Ã©Â±â€”
    {0x7e, 0x3b, 0x2e, 0x55, 0x32, 0x27, 0x75, 0x00},   // 35 0d9d 97d9 Ã©ÂºÅ¸
    {0x2a, 0x3e, 0x0e, 0x7a, 0x79, 0x77, 0x0f, 0x00},   // 35 0d9e 97da Ã§â€˜Â 
    {0x28, 0x57, 0x45, 0x67, 0x45, 0x57, 0x28, 0x00},   // 35 0d9f 97db Ã¥Â¡Â
    {0x75, 0x00, 0x21, 0x5f, 0x55, 0x3d, 0x57, 0x00},   // 35 0da0 97dc Ã¦Â¶â„¢
    {0x50, 0x17, 0x1d, 0x77, 0x15, 0x0f, 0x50, 0x00},   // 35 0da1 97dd Ã§Â´Â¯
    {0x55, 0x52, 0x3f, 0x52, 0x5d, 0x17, 0x5d, 0x00},   // 35 0da2 97de Ã©Â¡Å¾
    {0x14, 0x14, 0x12, 0x75, 0x16, 0x14, 0x34, 0x00},   // 35 0da3 97df Ã¤Â»Â¤
    {0x04, 0x7e, 0x15, 0x12, 0x75, 0x16, 0x34, 0x00},   // 35 0da4 97e0 Ã¤Â¼Â¶
    {0x04, 0x7e, 0x49, 0x37, 0x1d, 0x4e, 0x7f, 0x00},   // 35 0da5 97e1 Ã¤Â¾â€¹
    {0x71, 0x00, 0x14, 0x12, 0x75, 0x16, 0x34, 0x00},   // 35 0da6 97e2 Ã¥â€ Â·
    {0x7f, 0x65, 0x1d, 0x75, 0x62, 0x1f, 0x7e, 0x00},   // 35 0da7 97e3 Ã¥Å Â±
    {0x17, 0x72, 0x36, 0x43, 0x1a, 0x1e, 0x5b, 0x00},   // 35 0da8 97e4 Ã¥Â¶Âº
    {0x06, 0x7f, 0x14, 0x12, 0x75, 0x16, 0x34, 0x00},   // 35 0da9 97e5 Ã¦â‚¬Å“
    {0x2a, 0x3e, 0x14, 0x12, 0x75, 0x16, 0x34, 0x00},   // 35 0daa 97e6 Ã§Å½Â²
    {0x12, 0x7b, 0x16, 0x00, 0x7f, 0x40, 0x60, 0x00},   // 35 0dab 97e7 Ã§Â¤Â¼
    {0x12, 0x12, 0x1b, 0x76, 0x1b, 0x12, 0x32, 0x00},   // 35 0dac 97e8 Ã¨â€¹â€œ
    {0x56, 0x7d, 0x36, 0x12, 0x75, 0x16, 0x34, 0x00},   // 35 0dad 97e9 Ã©Ë†Â´
    {0x2a, 0x6f, 0x2a, 0x5a, 0x7f, 0x2e, 0x54, 0x00},   // 35 0dae 97ea Ã©Å¡Â·
    {0x16, 0x12, 0x1f, 0x77, 0x1b, 0x16, 0x36, 0x00},   // 35 0daf 97eb Ã©â€ºÂ¶
    {0x56, 0x62, 0x57, 0x77, 0x53, 0x66, 0x56, 0x00},   // 35 0db0 97ec Ã©Å“Å 
    {0x43, 0x3d, 0x77, 0x5c, 0x17, 0x7d, 0x57, 0x00},   // 35 0db1 97ed Ã©Âºâ€”
    {0x7e, 0x54, 0x6f, 0x7a, 0x16, 0x75, 0x36, 0x00},   // 35 0db2 97ee Ã©Â½Â¢
    {0x40, 0x3f, 0x75, 0x5f, 0x55, 0x5f, 0x75, 0x00},   // 35 0db3 97ef Ã¦Å¡Â¦
    {0x40, 0x3f, 0x45, 0x6f, 0x45, 0x7f, 0x55, 0x00},   // 35 0db4 97f0 Ã¦Â­Â´
    {0x49, 0x37, 0x1d, 0x01, 0x0e, 0x40, 0x7f, 0x00},   // 35 0db5 97f1 Ã¥Ë†â€”
    {0x54, 0x52, 0x38, 0x1f, 0x14, 0x52, 0x74, 0x00},   // 35 0db6 97f2 Ã¥Å Â£
    {0x49, 0x17, 0x4d, 0x01, 0x46, 0x10, 0x5f, 0x00},   // 35 0db7 97f3 Ã§Æ’Ë†
    {0x55, 0x3b, 0x77, 0x51, 0x36, 0x50, 0x5f, 0x00},   // 35 0db8 97f4 Ã¨Â£â€š
    {0x40, 0x3e, 0x52, 0x36, 0x7f, 0x3e, 0x5a, 0x00},   // 35 0db9 97f5 Ã¥Â»â€°
    {0x6a, 0x22, 0x4e, 0x43, 0x6e, 0x02, 0x6a, 0x00},   // 35 0dba 97f6 Ã¦Ââ€¹
    {0x06, 0x7f, 0x55, 0x32, 0x27, 0x72, 0x25, 0x00},   // 35 0dbb 97f7 Ã¦â€ Â
    {0x75, 0x00, 0x79, 0x52, 0x5e, 0x7f, 0x52, 0x00},   // 35 0dbc 97f8 Ã¦Â¼Â£
    {0x4c, 0x3f, 0x42, 0x2e, 0x7f, 0x2e, 0x42, 0x00},   // 35 0dbd 97f9 Ã§â€¦â€°
    {0x44, 0x3b, 0x56, 0x3c, 0x7f, 0x36, 0x5e, 0x00},   // 35 0dbe 97fa Ã§Â°Â¾
    {0x2a, 0x75, 0x42, 0x2e, 0x7f, 0x2e, 0x42, 0x00},   // 35 0dbf 97fb Ã§Â·Â´
    {0x21, 0x3f, 0x7f, 0x5a, 0x35, 0x7a, 0x35, 0x00},   // 35 0dc0 97fc Ã¨ÂÂ¯
    {0x52, 0x36, 0x43, 0x5a, 0x7f, 0x5a, 0x5a, 0x00},   // 36 0dc1 9840 Ã¨â€œÂ®
    {0x49, 0x38, 0x52, 0x5e, 0x7f, 0x5e, 0x52, 0x00},   // 36 0dc2 9841 Ã©â‚¬Â£
    {0x56, 0x7d, 0x56, 0x2e, 0x7f, 0x2e, 0x42, 0x00},   // 36 0dc3 9842 Ã©Å’Â¬
    {0x00, 0x70, 0x57, 0x5d, 0x55, 0x57, 0x70, 0x00},   // 36 0dc4 9843 Ã¥â€˜â€š
    {0x12, 0x6e, 0x7d, 0x6d, 0x7f, 0x6c, 0x10, 0x00},   // 36 0dc5 9844 Ã©Â­Â¯
    {0x1a, 0x7f, 0x12, 0x6e, 0x7d, 0x6f, 0x10, 0x00},   // 36 0dc6 9845 Ã¦Â«â€œ
    {0x4c, 0x3f, 0x44, 0x3d, 0x15, 0x15, 0x1d, 0x00},   // 36 0dc7 9846 Ã§â€šâ€°
    {0x5f, 0x15, 0x5f, 0x0a, 0x65, 0x6b, 0x10, 0x00},   // 36 0dc8 9847 Ã¨Â³â€š
    {0x77, 0x7d, 0x57, 0x0a, 0x65, 0x6b, 0x10, 0x00},   // 36 0dc9 9848 Ã¨Â·Â¯
    {0x5e, 0x6a, 0x5f, 0x37, 0x6b, 0x7e, 0x26, 0x00},   // 36 0dca 9849 Ã©Å“Â²
    {0x46, 0x4b, 0x2a, 0x1f, 0x4a, 0x7b, 0x06, 0x00},   // 36 0dcb 984a Ã¥Å Â´
    {0x54, 0x5e, 0x76, 0x5f, 0x36, 0x5e, 0x54, 0x00},   // 36 0dcc 984b Ã¥Â©Â
    {0x40, 0x3e, 0x7a, 0x5e, 0x23, 0x7e, 0x36, 0x00},   // 36 0dcd 984c Ã¥Â»Å 
    {0x10, 0x55, 0x3d, 0x17, 0x7d, 0x15, 0x10, 0x00},   // 36 0dce 984d Ã¥Â¼â€ž
    {0x7e, 0x4b, 0x2e, 0x40, 0x3f, 0x55, 0x7f, 0x00},   // 36 0dcf 984e Ã¦Å“â€”
    {0x1a, 0x7f, 0x55, 0x7a, 0x57, 0x32, 0x55, 0x00},   // 36 0dd0 984f Ã¦Â¥Â¼
    {0x1a, 0x7f, 0x3e, 0x2b, 0x0e, 0x7f, 0x1b, 0x00},   // 36 0dd1 9850 Ã¦Â¦â€
    {0x75, 0x00, 0x7e, 0x5a, 0x3b, 0x5e, 0x40, 0x00},   // 36 0dd2 9851 Ã¦ÂµÂª
    {0x75, 0x40, 0x3f, 0x6b, 0x7b, 0x2b, 0x6b, 0x00},   // 36 0dd3 9852 Ã¦Â¼Â
    {0x36, 0x2e, 0x2a, 0x7f, 0x2a, 0x2a, 0x26, 0x00},   // 36 0dd4 9853 Ã§â€°Â¢
    {0x55, 0x4a, 0x3d, 0x7e, 0x5a, 0x3b, 0x5e, 0x00},   // 36 0dd5 9854 Ã§â€¹Â¼
    {0x14, 0x13, 0x3e, 0x34, 0x7b, 0x56, 0x52, 0x00},   // 36 0dd6 9855 Ã§Â¯Â­
    {0x28, 0x1a, 0x0a, 0x7f, 0x5e, 0x5a, 0x49, 0x00},   // 36 0dd7 9856 Ã¨â‚¬Â
    {0x2a, 0x3e, 0x2b, 0x3e, 0x32, 0x7b, 0x2d, 0x00},   // 36 0dd8 9857 Ã¨ÂÂ¾
    {0x4e, 0x7b, 0x3d, 0x14, 0x7d, 0x16, 0x7d, 0x00},   // 36 0dd9 9858 Ã¨Ââ€¹
    {0x7e, 0x4b, 0x6e, 0x00, 0x7f, 0x25, 0x1b, 0x00},   // 36 0dda 9859 Ã©Æ’Å½
    {0x42, 0x22, 0x1a, 0x03, 0x1a, 0x22, 0x42, 0x00},   // 36 0ddb 985a Ã¥â€¦Â­
    {0x42, 0x3f, 0x76, 0x5c, 0x16, 0x7f, 0x56, 0x00},   // 36 0ddc 985b Ã©Âºâ€œ
    {0x12, 0x7b, 0x56, 0x25, 0x7d, 0x27, 0x54, 0x00},   // 36 0ddd 985c Ã§Â¦â€ž
    {0x7f, 0x15, 0x7f, 0x42, 0x3f, 0x42, 0x7e, 0x00},   // 36 0dde 985d Ã¨â€šâ€¹
    {0x56, 0x7d, 0x56, 0x25, 0x7d, 0x27, 0x54, 0x00},   // 36 0ddf 985e Ã©Å’Â²
    {0x6a, 0x6b, 0x74, 0x32, 0x75, 0x36, 0x74, 0x00},   // 36 0de0 985f Ã¨Â«â€“
    {0x0c, 0x7f, 0x5a, 0x77, 0x5f, 0x37, 0x5a, 0x00},   // 36 0de1 9860 Ã¥â‚¬Â­
    {0x24, 0x15, 0x7f, 0x15, 0x7e, 0x42, 0x7e, 0x00},   // 36 0de2 9861 Ã¥â€™Å’
    {0x6a, 0x6b, 0x04, 0x76, 0x5e, 0x75, 0x04, 0x00},   // 36 0de3 9862 Ã¨Â©Â±
    {0x45, 0x6d, 0x4b, 0x7f, 0x59, 0x5b, 0x45, 0x00},   // 36 0de4 9863 Ã¦Â­Âª
    {0x5f, 0x15, 0x5f, 0x12, 0x7f, 0x2a, 0x7a, 0x00},   // 36 0de5 9864 Ã¨Â³â€ž
    {0x7f, 0x15, 0x7f, 0x22, 0x77, 0x22, 0x76, 0x00},   // 36 0de6 9865 Ã¨â€žâ€¡
    {0x6a, 0x2e, 0x4e, 0x42, 0x6b, 0x06, 0x6b, 0x00},   // 36 0de7 9866 Ã¦Æ’â€˜
    {0x1a, 0x7f, 0x2a, 0x26, 0x73, 0x2e, 0x28, 0x00},   // 36 0de8 9867 Ã¦Å¾Â 
    {0x52, 0x0e, 0x5b, 0x1e, 0x5a, 0x17, 0x7a, 0x00},   // 36 0de9 9868 Ã©Â·Â²
    {0x41, 0x51, 0x4f, 0x55, 0x6d, 0x5d, 0x41, 0x00},   // 36 0dea 9869 Ã¤Âºâ„¢
    {0x41, 0x7f, 0x6b, 0x6b, 0x6b, 0x7f, 0x41, 0x00},   // 36 0deb 986a Ã¤ÂºËœ
    {0x42, 0x1d, 0x5f, 0x0b, 0x3f, 0x2c, 0x6b, 0x00},   // 36 0dec 986b Ã©Â°Â
    {0x6b, 0x62, 0x16, 0x1a, 0x7b, 0x56, 0x56, 0x00},   // 36 0ded 986c Ã¨Â©Â«
    {0x5a, 0x4a, 0x3f, 0x76, 0x3f, 0x4a, 0x5a, 0x00},   // 36 0dee 986d Ã¨â€”Â
    {0x42, 0x3e, 0x57, 0x3a, 0x4f, 0x3a, 0x5a, 0x00},   // 36 0def 986e Ã¨â€¢Â¨
    {0x1a, 0x7f, 0x56, 0x2a, 0x7b, 0x4a, 0x5e, 0x00},   // 36 0df0 986f Ã¦Â¤â‚¬
    {0x75, 0x00, 0x0a, 0x3e, 0x33, 0x3e, 0x6a, 0x00},   // 36 0df1 9870 Ã¦Â¹Â¾
    {0x09, 0x37, 0x31, 0x56, 0x2a, 0x7b, 0x5e, 0x00},   // 36 0df2 9871 Ã§Â¢â€”
    {0x7f, 0x15, 0x7f, 0x56, 0x2a, 0x7b, 0x5e, 0x00},   // 36 0df3 9872 Ã¨â€¦â€¢
    {0x12, 0x12, 0x12, 0x12, 0x0f, 0x32, 0x43, 0x00},   // 37 0df4 989f Ã¥Â¼Å’
    {0x01, 0x1d, 0x11, 0x1f, 0x15, 0x55, 0x71, 0x00},   // 37 0df5 98a0 Ã¤Â¸Â
    {0x49, 0x49, 0x45, 0x7f, 0x41, 0x45, 0x49, 0x00},   // 37 0df6 98a1 Ã¤Â¸â€¢
    {0x04, 0x04, 0x02, 0x7d, 0x02, 0x04, 0x04, 0x00},   // 37 0df7 98a2 Ã¤Â¸Âª
    {0x1e, 0x50, 0x3f, 0x00, 0x7f, 0x10, 0x1e, 0x00},   // 37 0df8 98a3 Ã¤Â¸Â±
    {0x00, 0x00, 0x02, 0x04, 0x18, 0x00, 0x00, 0x00},   // 37 0df9 98a4 Ã¤Â¸Â¶
    {0x12, 0x52, 0x3f, 0x16, 0x12, 0x7f, 0x12, 0x00},   // 37 0dfa 98a5 Ã¤Â¸Â¼
    {0x00, 0x40, 0x40, 0x20, 0x1f, 0x00, 0x00, 0x00},   // 37 0dfb 98a6 Ã¤Â¸Â¿
    {0x40, 0x43, 0x2c, 0x10, 0x2c, 0x43, 0x40, 0x00},   // 37 0dfc 98a7 Ã¤Â¹â€š
    {0x2c, 0x3e, 0x06, 0x7e, 0x05, 0x3d, 0x2c, 0x00},   // 37 0dfd 98a8 Ã¤Â¹â€“
    {0x54, 0x5e, 0x26, 0x7e, 0x25, 0x5d, 0x54, 0x00},   // 37 0dfe 98a9 Ã¤Â¹Ëœ
    {0x72, 0x55, 0x37, 0x7d, 0x02, 0x7f, 0x40, 0x00},   // 37 0dff 98aa Ã¤Âºâ€š
    {0x00, 0x00, 0x40, 0x7f, 0x00, 0x00, 0x00, 0x00},   // 37 0e00 98ab Ã¤Âºâ€¦
    {0x49, 0x7d, 0x2b, 0x5e, 0x7d, 0x2f, 0x50, 0x00},   // 37 0e01 98ac Ã¨Â±Â«
    {0x12, 0x16, 0x5a, 0x7f, 0x3a, 0x3e, 0x12, 0x00},   // 37 0e02 98ad Ã¤ÂºÅ 
    {0x6a, 0x5d, 0x6a, 0x09, 0x4b, 0x7d, 0x1b, 0x00},   // 37 0e03 98ae Ã¨Ë†â€™
    {0x22, 0x2a, 0x2a, 0x22, 0x0f, 0x32, 0x43, 0x00},   // 37 0e04 98af Ã¥Â¼Â
    {0x08, 0x09, 0x49, 0x7f, 0x09, 0x09, 0x08, 0x00},   // 37 0e05 98b0 Ã¤ÂºÅ½
    {0x5d, 0x55, 0x77, 0x41, 0x77, 0x55, 0x5d, 0x00},   // 37 0e06 98b1 Ã¤ÂºÅ¾
    {0x59, 0x59, 0x67, 0x7d, 0x6d, 0x55, 0x6d, 0x00},   // 37 0e07 98b2 Ã¤ÂºÅ¸
    {0x08, 0x08, 0x08, 0x0e, 0x08, 0x08, 0x08, 0x00},   // 37 0e08 98b3 Ã¤ÂºÂ 
    {0x42, 0x42, 0x3a, 0x0b, 0x7a, 0x42, 0x62, 0x00},   // 37 0e09 98b4 Ã¤ÂºÂ¢
    {0x42, 0x3e, 0x5a, 0x7b, 0x1a, 0x3e, 0x42, 0x00},   // 37 0e0a 98b5 Ã¤ÂºÂ°
    {0x1a, 0x2e, 0x2a, 0x7b, 0x5a, 0x4e, 0x5a, 0x00},   // 37 0e0b 98b6 Ã¤ÂºÂ³
    {0x42, 0x4e, 0x7e, 0x5b, 0x7e, 0x4e, 0x42, 0x00},   // 37 0e0c 98b7 Ã¤ÂºÂ¶
    {0x40, 0x30, 0x0f, 0x50, 0x20, 0x1f, 0x60, 0x00},   // 37 0e0d 98b8 Ã¤Â»Å½
    {0x04, 0x7e, 0x41, 0x3f, 0x01, 0x47, 0x7c, 0x00},   // 37 0e0e 98b9 Ã¤Â»Â
    {0x40, 0x3f, 0x41, 0x21, 0x1f, 0x21, 0x41, 0x00},   // 37 0e0f 98ba Ã¤Â»â€ž
    {0x04, 0x7e, 0x01, 0x00, 0x7f, 0x08, 0x10, 0x00},   // 37 0e10 98bb Ã¤Â»â€ 
    {0x04, 0x7e, 0x01, 0x42, 0x3f, 0x42, 0x7e, 0x00},   // 37 0e11 98bc Ã¤Â»â€š
    {0x04, 0x7e, 0x43, 0x2a, 0x1f, 0x22, 0x42, 0x00},   // 37 0e12 98bd Ã¤Â»â€”
    {0x04, 0x7e, 0x11, 0x4d, 0x3f, 0x41, 0x7f, 0x00},   // 37 0e13 98be Ã¤Â»Å¾
    {0x04, 0x7e, 0x01, 0x45, 0x3f, 0x51, 0x7f, 0x00},   // 37 0e14 98bf Ã¤Â»Â­
    {0x04, 0x7e, 0x09, 0x0a, 0x7e, 0x09, 0x08, 0x00},   // 37 0e15 98c0 Ã¤Â»Å¸
    {0x04, 0x7e, 0x45, 0x3a, 0x01, 0x7a, 0x04, 0x00},   // 37 0e16 98c1 Ã¤Â»Â·
    {0x04, 0x7e, 0x43, 0x3a, 0x0b, 0x7a, 0x42, 0x00},   // 37 0e17 98c2 Ã¤Â¼â€°
    {0x04, 0x7e, 0x4d, 0x2b, 0x1f, 0x2a, 0x48, 0x00},   // 37 0e18 98c3 Ã¤Â½Å¡
    {0x04, 0x7e, 0x05, 0x74, 0x5f, 0x74, 0x04, 0x00},   // 37 0e19 98c4 Ã¤Â¼Â°
    {0x0c, 0x7f, 0x5a, 0x3f, 0x16, 0x7f, 0x36, 0x00},   // 37 0e1a 98c5 Ã¤Â½â€º
    {0x04, 0x7e, 0x05, 0x1b, 0x1a, 0x42, 0x7e, 0x00},   // 37 0e1b 98c6 Ã¤Â½Â
    {0x04, 0x7e, 0x07, 0x7a, 0x53, 0x4a, 0x66, 0x00},   // 37 0e1c 98c7 Ã¤Â½â€”
    {0x04, 0x7e, 0x01, 0x06, 0x4a, 0x7b, 0x0e, 0x00},   // 37 0e1d 98c8 Ã¤Â½â€¡
    {0x04, 0x7e, 0x03, 0x6a, 0x6f, 0x6a, 0x02, 0x00},   // 37 0e1e 98c9 Ã¤Â½Â¶
    {0x04, 0x7e, 0x09, 0x4a, 0x55, 0x2b, 0x18, 0x00},   // 37 0e1f 98ca Ã¤Â¾Ë†
    {0x04, 0x7e, 0x4d, 0x2b, 0x7f, 0x2a, 0x48, 0x00},   // 37 0e20 98cb Ã¤Â¾Â
    {0x04, 0x7e, 0x17, 0x1a, 0x7b, 0x56, 0x56, 0x00},   // 37 0e21 98cc Ã¤Â¾Ëœ
    {0x0c, 0x7f, 0x4a, 0x3f, 0x00, 0x7f, 0x4a, 0x00},   // 37 0e22 98cd Ã¤Â½Â»
    {0x04, 0x7e, 0x7f, 0x35, 0x7d, 0x35, 0x7f, 0x00},   // 37 0e23 98ce Ã¤Â½Â©
    {0x04, 0x7e, 0x01, 0x7d, 0x57, 0x55, 0x7d, 0x00},   // 37 0e24 98cf Ã¤Â½Â°
    {0x04, 0x7e, 0x01, 0x12, 0x7f, 0x2a, 0x7a, 0x00},   // 37 0e25 98d0 Ã¤Â¾â€˜
    {0x0c, 0x7f, 0x22, 0x2b, 0x7e, 0x2b, 0x22, 0x00},   // 37 0e26 98d1 Ã¤Â½Â¯
    {0x52, 0x4e, 0x32, 0x7f, 0x32, 0x4e, 0x52, 0x00},   // 37 0e27 98d2 Ã¤Â¾â€ 
    {0x74, 0x34, 0x72, 0x35, 0x76, 0x34, 0x74, 0x00},   // 37 0e28 98d3 Ã¤Â¾â€“
    {0x04, 0x7e, 0x51, 0x6a, 0x7f, 0x6e, 0x54, 0x00},   // 37 0e29 98d4 Ã¥â€žËœ
    {0x04, 0x7e, 0x01, 0x5f, 0x35, 0x75, 0x5f, 0x00},   // 37 0e2a 98d5 Ã¤Â¿â€
    {0x04, 0x7e, 0x01, 0x56, 0x5d, 0x34, 0x56, 0x00},   // 37 0e2b 98d6 Ã¤Â¿Å¸
    {0x44, 0x33, 0x44, 0x7f, 0x55, 0x7f, 0x40, 0x00},   // 37 0e2c 98d7 Ã¤Â¿Å½
    {0x04, 0x7e, 0x23, 0x29, 0x6b, 0x39, 0x22, 0x00},   // 37 0e2d 98d8 Ã¤Â¿Ëœ
    {0x04, 0x7e, 0x5d, 0x36, 0x1d, 0x77, 0x5c, 0x00},   // 37 0e2e 98d9 Ã¤Â¿â€º
    {0x04, 0x7e, 0x7d, 0x15, 0x7d, 0x17, 0x7d, 0x00},   // 37 0e2f 98da Ã¤Â¿â€˜
    {0x04, 0x7e, 0x5f, 0x55, 0x7f, 0x55, 0x5f, 0x00},   // 37 0e30 98db Ã¤Â¿Å¡
    {0x04, 0x7e, 0x35, 0x7f, 0x15, 0x4e, 0x7f, 0x00},   // 37 0e31 98dc Ã¤Â¿Â
    {0x0c, 0x7f, 0x5a, 0x2b, 0x7e, 0x2b, 0x6e, 0x00},   // 37 0e32 98dd Ã¤Â¿Â¤
    {0x04, 0x7e, 0x23, 0x3e, 0x7f, 0x3e, 0x22, 0x00},   // 37 0e33 98de Ã¤Â¿Â¥
    {0x04, 0x7e, 0x13, 0x5a, 0x17, 0x7a, 0x12, 0x00},   // 37 0e34 98df Ã¥â‚¬Å¡
    {0x04, 0x7e, 0x41, 0x3f, 0x6b, 0x5f, 0x6b, 0x00},   // 37 0e35 98e0 Ã¥â‚¬Â¨
    {0x04, 0x7e, 0x3f, 0x65, 0x4d, 0x7d, 0x6f, 0x00},   // 37 0e36 98e1 Ã¥â‚¬â€
    {0x04, 0x7e, 0x5f, 0x35, 0x10, 0x75, 0x5f, 0x00},   // 37 0e37 98e2 Ã¥â‚¬Âª
    {0x04, 0x7e, 0x47, 0x56, 0x73, 0x56, 0x46, 0x00},   // 37 0e38 98e3 Ã¥â‚¬Â¥
    {0x04, 0x7e, 0x33, 0x2e, 0x73, 0x2e, 0x32, 0x00},   // 37 0e39 98e4 Ã¥â‚¬â€¦
    {0x04, 0x7e, 0x2b, 0x26, 0x73, 0x2e, 0x28, 0x00},   // 37 0e3a 98e5 Ã¤Â¼Å“
    {0x04, 0x7e, 0x29, 0x7f, 0x4a, 0x31, 0x4f, 0x00},   // 37 0e3b 98e6 Ã¤Â¿Â¶
    {0x0c, 0x7f, 0x7c, 0x57, 0x55, 0x57, 0x7c, 0x00},   // 37 0e3c 98e7 Ã¥â‚¬Â¡
    {0x04, 0x7e, 0x09, 0x7a, 0x3f, 0x7a, 0x08, 0x00},   // 37 0e3d 98e8 Ã¥â‚¬Â©
    {0x04, 0x7e, 0x21, 0x3c, 0x77, 0x3e, 0x22, 0x00},   // 37 0e3e 98e9 Ã¥â‚¬Â¬
    {0x04, 0x7e, 0x2f, 0x3a, 0x2f, 0x7a, 0x2e, 0x00},   // 37 0e3f 98ea Ã¤Â¿Â¾
    {0x04, 0x7e, 0x3f, 0x72, 0x0b, 0x52, 0x7a, 0x00},   // 37 0e40 98eb Ã¤Â¿Â¯
    {0x04, 0x7e, 0x7f, 0x07, 0x00, 0x47, 0x7f, 0x00},   // 37 0e41 98ec Ã¥â‚¬â€˜
    {0x04, 0x7e, 0x7d, 0x35, 0x7f, 0x35, 0x7d, 0x00},   // 37 0e42 98ed Ã¥â‚¬â€ 
    {0x04, 0x7e, 0x7f, 0x49, 0x6f, 0x57, 0x69, 0x00},   // 37 0e43 98ee Ã¥ÂÆ’
    {0x04, 0x7e, 0x7f, 0x2b, 0x58, 0x2d, 0x5f, 0x00},   // 37 0e44 98ef Ã¥Ââ€¡
    {0x04, 0x7c, 0x56, 0x5d, 0x56, 0x7c, 0x04, 0x00},   // 37 0e45 98f0 Ã¦Å“Æ’
    {0x04, 0x7e, 0x0f, 0x6a, 0x70, 0x6f, 0x0a, 0x00},   // 37 0e46 98f1 Ã¥Ââ€¢
    {0x04, 0x7e, 0x3b, 0x0e, 0x5b, 0x4e, 0x2a, 0x00},   // 37 0e47 98f2 Ã¥ÂÂ
    {0x04, 0x7e, 0x11, 0x3f, 0x2d, 0x4f, 0x78, 0x00},   // 37 0e48 98f3 Ã¥ÂË†
    {0x0c, 0x7f, 0x3a, 0x2f, 0x7a, 0x3f, 0x5e, 0x00},   // 37 0e49 98f4 Ã¥ÂÅ¡
    {0x04, 0x7e, 0x29, 0x1a, 0x6f, 0x7a, 0x69, 0x00},   // 37 0e4a 98f5 Ã¥Ââ€“
    {0x04, 0x7e, 0x65, 0x2b, 0x4e, 0x52, 0x6e, 0x00},   // 37 0e4b 98f6 Ã¥ÂÂ¬
    {0x04, 0x7e, 0x05, 0x73, 0x75, 0x26, 0x54, 0x00},   // 37 0e4c 98f7 Ã¥ÂÂ¸
    {0x04, 0x7e, 0x5f, 0x2a, 0x7f, 0x6a, 0x5e, 0x00},   // 37 0e4d 98f8 Ã¥â€šâ‚¬
    {0x0c, 0x7f, 0x56, 0x23, 0x56, 0x3f, 0x5e, 0x00},   // 37 0e4e 98f9 Ã¥â€šÅ¡
    {0x04, 0x7e, 0x13, 0x3e, 0x57, 0x7e, 0x13, 0x00},   // 37 0e4f 98fa Ã¥â€šâ€¦
    {0x04, 0x7e, 0x7f, 0x71, 0x47, 0x77, 0x71, 0x00},   // 37 0e50 98fb Ã¥â€šÂ´
    {0x0c, 0x7f, 0x4a, 0x3f, 0x6a, 0x3f, 0x5e, 0x00},   // 37 0e51 98fc Ã¥â€šÂ²
    {0x5c, 0x34, 0x5e, 0x05, 0x5e, 0x34, 0x5c, 0x00},   // 38 0e52 9940 Ã¥Æ’â€°
    {0x04, 0x7e, 0x15, 0x6f, 0x57, 0x4f, 0x15, 0x00},   // 38 0e53 9941 Ã¥Æ’Å 
    {0x04, 0x7e, 0x13, 0x3e, 0x5f, 0x76, 0x1a, 0x00},   // 38 0e54 9942 Ã¥â€šÂ³
    {0x04, 0x7e, 0x55, 0x7e, 0x5b, 0x3e, 0x54, 0x00},   // 38 0e55 9943 Ã¥Æ’â€š
    {0x04, 0x7e, 0x13, 0x7e, 0x57, 0x7e, 0x12, 0x00},   // 38 0e56 9944 Ã¥Æ’â€“
    {0x04, 0x7e, 0x53, 0x1d, 0x57, 0x1d, 0x72, 0x00},   // 38 0e57 9945 Ã¥Æ’Å¾
    {0x04, 0x7e, 0x5d, 0x3e, 0x17, 0x7e, 0x5c, 0x00},   // 38 0e58 9946 Ã¥Æ’Â¥
    {0x0c, 0x7f, 0x14, 0x6f, 0x76, 0x6f, 0x16, 0x00},   // 38 0e59 9947 Ã¥Æ’Â­
    {0x0c, 0x7f, 0x0a, 0x77, 0x5a, 0x77, 0x0a, 0x00},   // 38 0e5a 9948 Ã¥Æ’Â£
    {0x04, 0x7e, 0x4b, 0x5e, 0x7b, 0x5e, 0x4a, 0x00},   // 38 0e5b 9949 Ã¥Æ’Â®
    {0x04, 0x7e, 0x41, 0x3b, 0x3b, 0x3b, 0x41, 0x00},   // 38 0e5c 994a Ã¥Æ’Â¹
    {0x04, 0x7e, 0x01, 0x49, 0x7f, 0x7f, 0x49, 0x00},   // 38 0e5d 994b Ã¥Æ’Âµ
    {0x04, 0x7e, 0x5d, 0x36, 0x5d, 0x36, 0x5c, 0x00},   // 38 0e5e 994c Ã¥â€žâ€°
    {0x0c, 0x7f, 0x74, 0x1f, 0x2a, 0x1f, 0x7a, 0x00},   // 38 0e5f 994d Ã¥â€žÂ
    {0x0c, 0x7f, 0x36, 0x77, 0x56, 0x37, 0x56, 0x00},   // 38 0e60 994e Ã¥â€žâ€š
    {0x04, 0x7e, 0x4f, 0x69, 0x60, 0x6b, 0x4a, 0x00},   // 38 0e61 994f Ã¥â€žâ€“
    {0x04, 0x7e, 0x4b, 0x36, 0x2b, 0x76, 0x0a, 0x00},   // 38 0e62 9950 Ã¥â€žâ€¢
    {0x04, 0x7e, 0x35, 0x36, 0x5f, 0x76, 0x14, 0x00},   // 38 0e63 9951 Ã¥â€žâ€
    {0x0c, 0x7f, 0x1a, 0x4f, 0x5e, 0x3f, 0x1a, 0x00},   // 38 0e64 9952 Ã¥â€žÅ¡
    {0x04, 0x7e, 0x71, 0x77, 0x07, 0x77, 0x70, 0x00},   // 38 0e65 9953 Ã¥â€žÂ¡
    {0x04, 0x7e, 0x5b, 0x3e, 0x5b, 0x7e, 0x55, 0x00},   // 38 0e66 9954 Ã¥â€žÂº
    {0x04, 0x7e, 0x7f, 0x55, 0x1e, 0x7d, 0x57, 0x00},   // 38 0e67 9955 Ã¥â€žÂ·
    {0x04, 0x7e, 0x7f, 0x3f, 0x7a, 0x2f, 0x5b, 0x00},   // 38 0e68 9956 Ã¥â€žÂ¼
    {0x04, 0x7e, 0x57, 0x1a, 0x5f, 0x1a, 0x57, 0x00},   // 38 0e69 9957 Ã¥â€žÂ»
    {0x40, 0x20, 0x1f, 0x00, 0x7f, 0x40, 0x60, 0x00},   // 38 0e6a 9958 Ã¥â€žÂ¿
    {0x41, 0x21, 0x1f, 0x01, 0x7f, 0x41, 0x61, 0x00},   // 38 0e6b 9959 Ã¥â€¦â‚¬
    {0x40, 0x5e, 0x35, 0x10, 0x75, 0x5f, 0x60, 0x00},   // 38 0e6c 995a Ã¥â€¦â€™
    {0x44, 0x5e, 0x35, 0x14, 0x75, 0x5e, 0x64, 0x00},   // 38 0e6d 995b Ã¥â€¦Å’
    {0x42, 0x5e, 0x35, 0x7d, 0x57, 0x74, 0x5c, 0x00},   // 38 0e6e 995c Ã¥â€¦â€
    {0x42, 0x3a, 0x77, 0x5a, 0x3a, 0x77, 0x5a, 0x00},   // 38 0e6f 995d Ã¥â€¦Â¢
    {0x4a, 0x3e, 0x7b, 0x5e, 0x3e, 0x7b, 0x5e, 0x00},   // 38 0e70 995e Ã§Â«Â¸
    {0x7d, 0x1d, 0x25, 0x7f, 0x1d, 0x25, 0x7d, 0x00},   // 38 0e71 995f Ã¥â€¦Â©
    {0x74, 0x35, 0x73, 0x25, 0x56, 0x24, 0x54, 0x00},   // 38 0e72 9960 Ã¥â€¦Âª
    {0x04, 0x06, 0x1d, 0x14, 0x55, 0x72, 0x04, 0x00},   // 38 0e73 9961 Ã¥â€¦Â®
    {0x2a, 0x6a, 0x3f, 0x38, 0x3f, 0x6a, 0x2a, 0x00},   // 38 0e74 9962 Ã¥â€ â‚¬
    {0x7f, 0x01, 0x01, 0x01, 0x01, 0x41, 0x7f, 0x00},   // 38 0e75 9963 Ã¥â€ â€š
    {0x7f, 0x01, 0x3f, 0x2b, 0x2f, 0x41, 0x7f, 0x00},   // 38 0e76 9964 Ã¥â€ºËœ
    {0x48, 0x3f, 0x49, 0x7f, 0x3f, 0x49, 0x7f, 0x00},   // 38 0e77 9965 Ã¥â€ Å’
    {0x20, 0x7e, 0x2a, 0x3f, 0x2a, 0x7e, 0x20, 0x00},   // 38 0e78 9966 Ã¥â€ â€°
    {0x7f, 0x05, 0x3b, 0x29, 0x3f, 0x45, 0x7f, 0x00},   // 38 0e79 9967 Ã¥â€ Â
    {0x0e, 0x7a, 0x0a, 0x2f, 0x2a, 0x7a, 0x0e, 0x00},   // 38 0e7a 9968 Ã¥â€ â€˜
    {0x2a, 0x7a, 0x2f, 0x3a, 0x2f, 0x7a, 0x2a, 0x00},   // 38 0e7b 9969 Ã¥â€ â€œ
    {0x48, 0x5b, 0x35, 0x1d, 0x75, 0x5f, 0x60, 0x00},   // 38 0e7c 996a Ã¥â€ â€¢
    {0x0c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0c, 0x00},   // 38 0e7d 996b Ã¥â€ â€“
    {0x4b, 0x59, 0x37, 0x1f, 0x77, 0x5d, 0x63, 0x00},   // 38 0e7e 996c Ã¥â€ Â¤
    {0x53, 0x35, 0x75, 0x41, 0x6d, 0x57, 0x6b, 0x00},   // 38 0e7f 996d Ã¥â€ Â¦
    {0x2b, 0x29, 0x57, 0x4f, 0x3b, 0x11, 0x2b, 0x00},   // 38 0e80 996e Ã¥â€ Â¢
    {0x23, 0x5d, 0x1b, 0x59, 0x1f, 0x51, 0x73, 0x00},   // 38 0e81 996f Ã¥â€ Â©
    {0x53, 0x35, 0x7f, 0x7d, 0x3f, 0x75, 0x33, 0x00},   // 38 0e82 9970 Ã¥â€ Âª
    {0x00, 0x00, 0x61, 0x12, 0x08, 0x00, 0x00, 0x00},   // 38 0e83 9971 Ã¥â€ Â«
    {0x61, 0x12, 0x48, 0x4a, 0x3f, 0x4e, 0x48, 0x00},   // 38 0e84 9972 Ã¥â€ Â³
    {0x61, 0x12, 0x41, 0x59, 0x57, 0x75, 0x4d, 0x00},   // 38 0e85 9973 Ã¥â€ Â±
    {0x71, 0x00, 0x1e, 0x12, 0x7f, 0x12, 0x1e, 0x00},   // 38 0e86 9974 Ã¥â€ Â²
    {0x71, 0x00, 0x14, 0x4c, 0x7f, 0x14, 0x22, 0x00},   // 38 0e87 9975 Ã¥â€ Â°
    {0x71, 0x00, 0x4f, 0x39, 0x09, 0x79, 0x4f, 0x00},   // 38 0e88 9976 Ã¥â€ Âµ
    {0x71, 0x00, 0x49, 0x37, 0x1d, 0x4e, 0x7f, 0x00},   // 38 0e89 9977 Ã¥â€ Â½
    {0x71, 0x00, 0x7f, 0x75, 0x6f, 0x75, 0x7f, 0x00},   // 38 0e8a 9978 Ã¥â€¡â€¦
    {0x71, 0x00, 0x22, 0x4e, 0x7b, 0x0e, 0x22, 0x00},   // 38 0e8b 9979 Ã¥â€¡â€°
    {0x71, 0x00, 0x52, 0x1e, 0x7b, 0x1e, 0x52, 0x00},   // 38 0e8c 997a Ã¥â€¡â€º
    {0x40, 0x3f, 0x01, 0x01, 0x01, 0x7f, 0x40, 0x00},   // 38 0e8d 997b Ã¥â€¡Â 
    {0x40, 0x3c, 0x54, 0x2c, 0x5f, 0x7a, 0x4a, 0x00},   // 38 0e8e 997c Ã¨â„¢â€¢
    {0x40, 0x3f, 0x29, 0x7d, 0x29, 0x7f, 0x40, 0x00},   // 38 0e8f 997d Ã¥â€¡Â©
    {0x44, 0x4e, 0x35, 0x16, 0x7e, 0x55, 0x44, 0x00},   // 38 0e90 997e Ã¥â€¡Â­
    {0x40, 0x3f, 0x5d, 0x77, 0x5d, 0x7f, 0x40, 0x00},   // 39 0e91 9980 Ã¥â€¡Â°
    {0x7f, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7f, 0x00},   // 39 0e92 9981 Ã¥â€¡Âµ
    {0x7c, 0x79, 0x69, 0x7d, 0x57, 0x69, 0x7c, 0x00},   // 39 0e93 9982 Ã¥â€¡Â¾
    {0x41, 0x25, 0x19, 0x0f, 0x11, 0x51, 0x7f, 0x00},   // 39 0e94 9983 Ã¥Ë†â€ž
    {0x0a, 0x4a, 0x3e, 0x09, 0x0e, 0x40, 0x7f, 0x00},   // 39 0e95 9984 Ã¥Ë†â€¹
    {0x48, 0x2a, 0x1f, 0x2e, 0x0e, 0x40, 0x7f, 0x00},   // 39 0e96 9985 Ã¥Ë†â€
    {0x24, 0x53, 0x2e, 0x5e, 0x7e, 0x00, 0x7f, 0x00},   // 39 0e97 9986 Ã¥Ë†Å½
    {0x6a, 0x5f, 0x2a, 0x41, 0x3f, 0x41, 0x7f, 0x00},   // 39 0e98 9987 Ã¥Ë†Â§
    {0x08, 0x7f, 0x3f, 0x09, 0x7f, 0x0e, 0x7f, 0x00},   // 39 0e99 9988 Ã¥Ë†Âª
    {0x04, 0x76, 0x5e, 0x75, 0x0e, 0x40, 0x7f, 0x00},   // 39 0e9a 9989 Ã¥Ë†Â®
    {0x0a, 0x36, 0x3b, 0x36, 0x6a, 0x00, 0x7f, 0x00},   // 39 0e9b 998a Ã¥Ë†Â³
    {0x54, 0x35, 0x7a, 0x35, 0x5e, 0x00, 0x7f, 0x00},   // 39 0e9c 998b Ã¥Ë†Â¹
    {0x55, 0x3e, 0x7d, 0x45, 0x3f, 0x51, 0x7f, 0x00},   // 39 0e9d 998c Ã¥â€°Â
    {0x55, 0x5b, 0x75, 0x5b, 0x51, 0x0e, 0x7f, 0x00},   // 39 0e9e 998d Ã¥â€°â€ž
    {0x5a, 0x37, 0x5a, 0x40, 0x4e, 0x60, 0x7f, 0x00},   // 39 0e9f 998e Ã¥â€°â€¹
    {0x42, 0x2e, 0x7f, 0x2a, 0x4e, 0x00, 0x7f, 0x00},   // 39 0ea0 998f Ã¥â€°Å’
    {0x12, 0x5a, 0x17, 0x7a, 0x1e, 0x40, 0x7f, 0x00},   // 39 0ea1 9990 Ã¥â€°Å¾
    {0x27, 0x5d, 0x35, 0x77, 0x0e, 0x40, 0x7f, 0x00},   // 39 0ea2 9991 Ã¥â€°â€
    {0x52, 0x5e, 0x37, 0x1e, 0x12, 0x5f, 0x72, 0x00},   // 39 0ea3 9992 Ã¥â€°Âª
    {0x4b, 0x5a, 0x6b, 0x3a, 0x2f, 0x40, 0x7f, 0x00},   // 39 0ea4 9993 Ã¥â€°Â´
    {0x4a, 0x2f, 0x73, 0x2f, 0x4a, 0x00, 0x7f, 0x00},   // 39 0ea5 9994 Ã¥â€°Â©
    {0x12, 0x7b, 0x56, 0x7b, 0x1e, 0x40, 0x7f, 0x00},   // 39 0ea6 9995 Ã¥â€°Â³
    {0x52, 0x3d, 0x7e, 0x3d, 0x5e, 0x00, 0x7f, 0x00},   // 39 0ea7 9996 Ã¥â€°Â¿
    {0x4d, 0x1f, 0x7d, 0x1f, 0x4d, 0x00, 0x7f, 0x00},   // 39 0ea8 9997 Ã¥â€°Â½
    {0x5c, 0x36, 0x5d, 0x36, 0x5e, 0x00, 0x7f, 0x00},   // 39 0ea9 9998 Ã¥Å Â
    {0x5c, 0x36, 0x5d, 0x3e, 0x65, 0x1f, 0x7f, 0x00},   // 39 0eaa 9999 Ã¥Å â€
    {0x5c, 0x36, 0x5d, 0x3e, 0x69, 0x1f, 0x7f, 0x00},   // 39 0eab 999a Ã¥Å â€™
    {0x5c, 0x56, 0x3d, 0x5e, 0x65, 0x1f, 0x7f, 0x00},   // 39 0eac 999b Ã¥â€°Â±
    {0x54, 0x5f, 0x3b, 0x10, 0x16, 0x5b, 0x76, 0x00},   // 39 0ead 999c Ã¥Å Ë†
    {0x4a, 0x36, 0x2b, 0x76, 0x0e, 0x40, 0x7f, 0x00},   // 39 0eae 999d Ã¥Å â€˜
    {0x56, 0x3b, 0x56, 0x3f, 0x16, 0x7b, 0x16, 0x00},   // 39 0eaf 999e Ã¨Â¾Â¨
    {0x56, 0x3b, 0x56, 0x3e, 0x7e, 0x7b, 0x16, 0x00},   // 39 0eb0 999f Ã¨Â¾Â§
    {0x04, 0x1b, 0x5a, 0x7e, 0x62, 0x1f, 0x7e, 0x00},   // 39 0eb1 99a0 Ã¥Å Â¬
    {0x75, 0x53, 0x77, 0x42, 0x3f, 0x42, 0x7e, 0x00},   // 39 0eb2 99a1 Ã¥Å Â­
    {0x6a, 0x6f, 0x6a, 0x42, 0x3f, 0x42, 0x7e, 0x00},   // 39 0eb3 99a2 Ã¥Å Â¼
    {0x12, 0x55, 0x4c, 0x37, 0x5c, 0x75, 0x12, 0x00},   // 39 0eb4 99a3 Ã¥Å Âµ
    {0x55, 0x5b, 0x75, 0x5b, 0x62, 0x1f, 0x7e, 0x00},   // 39 0eb5 99a4 Ã¥â€¹Â
    {0x22, 0x4e, 0x7b, 0x0e, 0x62, 0x1f, 0x7e, 0x00},   // 39 0eb6 99a5 Ã¥â€¹Â
    {0x40, 0x7f, 0x57, 0x3f, 0x6b, 0x1f, 0x78, 0x00},   // 39 0eb7 99a6 Ã¥â€¹â€”
    {0x4d, 0x56, 0x35, 0x1c, 0x55, 0x76, 0x0d, 0x00},   // 39 0eb8 99a7 Ã¥â€¹Å¾
    {0x4a, 0x3a, 0x3f, 0x4a, 0x3f, 0x42, 0x7e, 0x00},   // 39 0eb9 99a8 Ã¥â€¹Â£
    {0x52, 0x3d, 0x7e, 0x3d, 0x62, 0x1f, 0x7e, 0x00},   // 39 0eba 99a9 Ã¥â€¹Â¦
    {0x7e, 0x2d, 0x2e, 0x54, 0x3b, 0x52, 0x72, 0x00},   // 39 0ebb 99aa Ã©Â£Â­
    {0x11, 0x4b, 0x55, 0x2b, 0x62, 0x1f, 0x7e, 0x00},   // 39 0ebc 99ab Ã¥â€¹Â 
    {0x52, 0x1f, 0x5f, 0x12, 0x62, 0x1f, 0x7e, 0x00},   // 39 0ebd 99ac Ã¥â€¹Â³
    {0x7f, 0x6d, 0x3f, 0x6d, 0x62, 0x1f, 0x7e, 0x00},   // 39 0ebe 99ad Ã¥â€¹Âµ
    {0x26, 0x7f, 0x7a, 0x57, 0x66, 0x1f, 0x7e, 0x00},   // 39 0ebf 99ae Ã¥â€¹Â¸
    {0x04, 0x03, 0x02, 0x02, 0x02, 0x42, 0x7e, 0x00},   // 39 0ec0 99af Ã¥â€¹Â¹
    {0x24, 0x13, 0x4e, 0x2a, 0x1e, 0x52, 0x7e, 0x00},   // 39 0ec1 99b0 Ã¥Å’â€ 
    {0x04, 0x3b, 0x36, 0x2a, 0x36, 0x42, 0x7e, 0x00},   // 39 0ec2 99b1 Ã¥Å’Ë†
    {0x04, 0x7f, 0x56, 0x7e, 0x56, 0x7e, 0x7e, 0x00},   // 39 0ec3 99b2 Ã§â€Â¸
    {0x04, 0x6b, 0x2a, 0x7e, 0x6a, 0x02, 0x7e, 0x00},   // 39 0ec4 99b3 Ã¥Å’Â
    {0x04, 0x6b, 0x7a, 0x7a, 0x6a, 0x02, 0x7e, 0x00},   // 39 0ec5 99b4 Ã¥Å’Â
    {0x0a, 0x36, 0x37, 0x6a, 0x04, 0x7b, 0x5e, 0x00},   // 39 0ec6 99b5 Ã¥Å’Â
    {0x08, 0x3f, 0x48, 0x44, 0x44, 0x42, 0x60, 0x00},   // 39 0ec7 99b6 Ã¥Å’â€¢
    {0x7f, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x00},   // 39 0ec8 99b7 Ã¥Å’Å¡
    {0x7f, 0x41, 0x5f, 0x55, 0x7f, 0x55, 0x5f, 0x00},   // 39 0ec9 99b8 Ã¥Å’Â£
    {0x7f, 0x6b, 0x45, 0x7f, 0x55, 0x7f, 0x55, 0x00},   // 39 0eca 99b9 Ã¥Å’Â¯
    {0x7f, 0x41, 0x65, 0x5f, 0x5f, 0x65, 0x41, 0x00},   // 39 0ecb 99ba Ã¥Å’Â±
    {0x7f, 0x41, 0x69, 0x5d, 0x6f, 0x5d, 0x69, 0x00},   // 39 0ecc 99bb Ã¥Å’Â³
    {0x01, 0x3f, 0x41, 0x41, 0x41, 0x41, 0x41, 0x00},   // 39 0ecd 99bc Ã¥Å’Â¸
    {0x7f, 0x41, 0x71, 0x77, 0x45, 0x77, 0x71, 0x00},   // 39 0ece 99bd Ã¥Ââ‚¬
    {0x2a, 0x2a, 0x26, 0x73, 0x2e, 0x28, 0x2c, 0x00},   // 39 0ecf 99be Ã¥Ââ€ 
    {0x48, 0x3f, 0x08, 0x7f, 0x08, 0x7f, 0x08, 0x00},   // 39 0ed0 99bf Ã¥Ââ€¦
    {0x04, 0x7f, 0x44, 0x7f, 0x44, 0x7f, 0x04, 0x00},   // 39 0ed1 99c0 Ã¤Â¸â€”
    {0x10, 0x52, 0x3a, 0x17, 0x12, 0x7a, 0x10, 0x00},   // 39 0ed2 99c1 Ã¥Ââ€°
    {0x79, 0x09, 0x09, 0x7f, 0x48, 0x48, 0x4f, 0x00},   // 39 0ed3 99c2 Ã¥ÂÂ
    {0x29, 0x20, 0x24, 0x7f, 0x2a, 0x2f, 0x2a, 0x00},   // 39 0ed4 99c3 Ã¥â€¡â€“
    {0x02, 0x02, 0x02, 0x7f, 0x0a, 0x12, 0x02, 0x00},   // 39 0ed5 99c4 Ã¥ÂÅ¾
    {0x00, 0x00, 0x7f, 0x01, 0x11, 0x1f, 0x00, 0x00},   // 39 0ed6 99c5 Ã¥ÂÂ©
    {0x40, 0x3e, 0x06, 0x7e, 0x4d, 0x5d, 0x64, 0x00},   // 39 0ed7 99c6 Ã¥ÂÂ®
    {0x48, 0x47, 0x2a, 0x1e, 0x7f, 0x01, 0x1f, 0x00},   // 39 0ed8 99c7 Ã¥Â¤Ëœ
    {0x12, 0x69, 0x64, 0x09, 0x7f, 0x01, 0x1f, 0x00},   // 39 0ed9 99c8 Ã¥ÂÂ»
    {0x2a, 0x19, 0x7c, 0x4b, 0x5c, 0x19, 0x2a, 0x00},   // 39 0eda 99c9 Ã¥ÂÂ·
    {0x40, 0x3f, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00},   // 39 0edb 99ca Ã¥Å½â€š
    {0x40, 0x3f, 0x45, 0x3f, 0x45, 0x69, 0x55, 0x00},   // 39 0edc 99cb Ã¥Å½â€“
    {0x40, 0x3f, 0x5f, 0x15, 0x5f, 0x01, 0x7d, 0x00},   // 39 0edd 99cc Ã¥Å½Â 
    {0x40, 0x3f, 0x41, 0x53, 0x2f, 0x5f, 0x43, 0x00},   // 39 0ede 99cd Ã¥Å½Â¦
    {0x40, 0x3f, 0x5b, 0x35, 0x4b, 0x3d, 0x4d, 0x00},   // 39 0edf 99ce Ã¥Å½Â¥
    {0x40, 0x3f, 0x55, 0x1f, 0x5f, 0x3d, 0x73, 0x00},   // 39 0ee0 99cf Ã¥Å½Â®
    {0x40, 0x3f, 0x7d, 0x3b, 0x7d, 0x27, 0x5d, 0x00},   // 39 0ee1 99d0 Ã¥Å½Â°
    {0x40, 0x60, 0x58, 0x47, 0x50, 0x20, 0x40, 0x00},   // 39 0ee2 99d1 Ã¥Å½Â¶
    {0x2c, 0x1a, 0x4f, 0x5a, 0x2d, 0x1a, 0x2c, 0x00},   // 39 0ee3 99d2 Ã¥ÂÆ’
    {0x54, 0x33, 0x5e, 0x7c, 0x3b, 0x56, 0x32, 0x00},   // 39 0ee4 99d3 Ã§Â°â€™
    {0x44, 0x4f, 0x5e, 0x2b, 0x5e, 0x4f, 0x4a, 0x00},   // 39 0ee5 99d4 Ã©â€ºâ„¢
    {0x4e, 0x4d, 0x58, 0x2f, 0x58, 0x4d, 0x4f, 0x00},   // 39 0ee6 99d5 Ã¥ÂÅ¸
    {0x4c, 0x4f, 0x5d, 0x2d, 0x5d, 0x4f, 0x4c, 0x00},   // 39 0ee7 99d6 Ã¦â€ºÂ¼
    {0x4a, 0x47, 0x5a, 0x2d, 0x5a, 0x47, 0x4a, 0x00},   // 39 0ee8 99d7 Ã§â€¡Â®
    {0x1e, 0x12, 0x1e, 0x01, 0x41, 0x7f, 0x01, 0x00},   // 39 0ee9 99d8 Ã¥ÂÂ®
    {0x1e, 0x12, 0x5e, 0x21, 0x1f, 0x41, 0x7f, 0x00},   // 39 0eea 99d9 Ã¥ÂÂ¨
    {0x1e, 0x1e, 0x40, 0x3f, 0x00, 0x3f, 0x40, 0x00},   // 39 0eeb 99da Ã¥ÂÂ­
    {0x1e, 0x12, 0x5e, 0x31, 0x0f, 0x30, 0x40, 0x00},   // 39 0eec 99db Ã¥ÂÂº
    {0x1e, 0x1e, 0x08, 0x49, 0x7f, 0x09, 0x08, 0x00},   // 39 0eed 99dc Ã¥ÂÂ
    {0x1e, 0x1e, 0x14, 0x13, 0x7f, 0x12, 0x10, 0x00},   // 39 0eee 99dd Ã¥ÂÂ½
    {0x1e, 0x1e, 0x28, 0x2f, 0x59, 0x7f, 0x09, 0x00},   // 39 0eef 99de Ã¥â€˜â‚¬
    {0x1e, 0x1e, 0x40, 0x3e, 0x0a, 0x79, 0x08, 0x00},   // 39 0ef0 99df Ã¥ÂÂ¬
    {0x1e, 0x1e, 0x42, 0x3a, 0x0b, 0x7a, 0x42, 0x00},   // 39 0ef1 99e0 Ã¥ÂÂ­
    {0x1e, 0x1e, 0x51, 0x7d, 0x0b, 0x7f, 0x40, 0x00},   // 39 0ef2 99e1 Ã¥ÂÂ¼
    {0x1e, 0x1e, 0x44, 0x3e, 0x05, 0x7c, 0x46, 0x00},   // 39 0ef3 99e2 Ã¥ÂÂ®
    {0x1e, 0x12, 0x7e, 0x15, 0x0f, 0x54, 0x7c, 0x00},   // 39 0ef4 99e3 Ã¥ÂÂ¶
    {0x1e, 0x1e, 0x44, 0x3b, 0x48, 0x7b, 0x04, 0x00},   // 39 0ef5 99e4 Ã¥ÂÂ©
    {0x12, 0x72, 0x76, 0x6b, 0x76, 0x72, 0x12, 0x00},   // 39 0ef6 99e5 Ã¥ÂÂ
    {0x1e, 0x12, 0x5e, 0x3f, 0x05, 0x1d, 0x67, 0x00},   // 39 0ef7 99e6 Ã¥â€˜Å½
    {0x1e, 0x1e, 0x28, 0x5d, 0x7d, 0x10, 0x28, 0x00},   // 39 0ef8 99e7 Ã¥â€™Â
    {0x1e, 0x1e, 0x01, 0x1d, 0x15, 0x5d, 0x7f, 0x00},   // 39 0ef9 99e8 Ã¥â€˜Âµ
    {0x0a, 0x7b, 0x55, 0x5b, 0x54, 0x73, 0x14, 0x00},   // 39 0efa 99e9 Ã¥â€™Å½
    {0x1e, 0x1e, 0x4a, 0x6e, 0x53, 0x2a, 0x42, 0x00},   // 39 0efb 99ea Ã¥â€˜Å¸
    {0x1e, 0x1e, 0x40, 0x3e, 0x42, 0x3e, 0x61, 0x00},   // 39 0efc 99eb Ã¥â€˜Â±
    {0x1e, 0x12, 0x1f, 0x15, 0x7f, 0x15, 0x1f, 0x00},   // 39 0efd 99ec Ã¥â€˜Â·
    {0x0e, 0x78, 0x5f, 0x5a, 0x50, 0x7f, 0x0a, 0x00},   // 39 0efe 99ed Ã¥â€˜Â°
    {0x47, 0x45, 0x3f, 0x08, 0x7f, 0x45, 0x67, 0x00},   // 39 0eff 99ee Ã¥â€™â€™
    {0x1e, 0x12, 0x3e, 0x2a, 0x7f, 0x2a, 0x3e, 0x00},   // 39 0f00 99ef Ã¥â€˜Â»
    {0x1e, 0x1e, 0x40, 0x7f, 0x55, 0x7f, 0x40, 0x00},   // 39 0f01 99f0 Ã¥â€™â‚¬
    {0x1e, 0x1e, 0x5c, 0x37, 0x4c, 0x31, 0x4f, 0x00},   // 39 0f02 99f1 Ã¥â€˜Â¶
    {0x1e, 0x1e, 0x76, 0x44, 0x7f, 0x44, 0x76, 0x00},   // 39 0f03 99f2 Ã¥â€™â€ž
    {0x1e, 0x12, 0x7e, 0x01, 0x0a, 0x52, 0x7f, 0x00},   // 39 0f04 99f3 Ã¥â€™Â
    {0x1e, 0x12, 0x1e, 0x04, 0x7b, 0x5a, 0x5e, 0x00},   // 39 0f05 99f4 Ã¥â€™â€ 
    {0x1e, 0x1e, 0x48, 0x5a, 0x7f, 0x5a, 0x48, 0x00},   // 39 0f06 99f5 Ã¥â€œâ€¡
    {0x0b, 0x0b, 0x3f, 0x2c, 0x2f, 0x6b, 0x0b, 0x00},   // 39 0f07 99f6 Ã¥â€™Â¢
    {0x40, 0x3e, 0x6a, 0x6a, 0x42, 0x3f, 0x52, 0x00},   // 39 0f08 99f7 Ã¥â€™Â¸
    {0x1e, 0x1e, 0x45, 0x57, 0x7d, 0x53, 0x45, 0x00},   // 39 0f09 99f8 Ã¥â€™Â¥
    {0x1e, 0x1e, 0x4a, 0x56, 0x23, 0x56, 0x4a, 0x00},   // 39 0f0a 99f9 Ã¥â€™Â¬
    {0x1e, 0x1e, 0x52, 0x1f, 0x12, 0x1f, 0x52, 0x00},   // 39 0f0b 99fa Ã¥â€œâ€ž
    {0x1e, 0x1e, 0x04, 0x72, 0x55, 0x76, 0x04, 0x00},   // 39 0f0c 99fb Ã¥â€œË†
    {0x09, 0x70, 0x54, 0x5b, 0x56, 0x7a, 0x06, 0x00},   // 39 0f0d 99fc Ã¥â€™Â¨
    {0x40, 0x3f, 0x19, 0x27, 0x50, 0x47, 0x57, 0x00},   // 3a 0f0e 9a40 Ã¥â€™Â«
    {0x1e, 0x12, 0x7d, 0x5f, 0x45, 0x5f, 0x7d, 0x00},   // 3a 0f0f 9a41 Ã¥â€œâ€š
    {0x1e, 0x1e, 0x16, 0x1a, 0x7b, 0x56, 0x56, 0x00},   // 3a 0f10 9a42 Ã¥â€™Â¤
    {0x1e, 0x1e, 0x28, 0x1a, 0x6f, 0x4a, 0x49, 0x00},   // 3a 0f11 9a43 Ã¥â€™Â¾
    {0x78, 0x0f, 0x79, 0x5f, 0x7b, 0x0f, 0x78, 0x00},   // 3a 0f12 9a44 Ã¥â€™Â¼
    {0x1e, 0x12, 0x1e, 0x7d, 0x00, 0x45, 0x7d, 0x00},   // 3a 0f13 9a45 Ã¥â€œËœ
    {0x09, 0x7f, 0x5d, 0x7f, 0x09, 0x7f, 0x09, 0x00},   // 3a 0f14 9a46 Ã¥â€œÂ¥
    {0x1e, 0x1e, 0x26, 0x7e, 0x25, 0x3f, 0x55, 0x00},   // 3a 0f15 9a47 Ã¥â€œÂ¦
    {0x1e, 0x1e, 0x48, 0x2d, 0x7a, 0x2d, 0x68, 0x00},   // 3a 0f16 9a48 Ã¥â€Â
    {0x1e, 0x1e, 0x14, 0x7d, 0x57, 0x7d, 0x10, 0x00},   // 3a 0f17 9a49 Ã¥â€â€
    {0x1e, 0x1e, 0x41, 0x57, 0x3f, 0x47, 0x41, 0x00},   // 3a 0f18 9a4a Ã¥â€œÂ½
    {0x1e, 0x1e, 0x28, 0x1a, 0x2f, 0x7a, 0x29, 0x00},   // 3a 0f19 9a4b Ã¥â€œÂ®
    {0x57, 0x55, 0x57, 0x38, 0x57, 0x5d, 0x57, 0x00},   // 3a 0f1a 9a4c Ã¥â€œÂ­
    {0x1e, 0x12, 0x7e, 0x2a, 0x7f, 0x2a, 0x7b, 0x00},   // 3a 0f1b 9a4d Ã¥â€œÂº
    {0x1e, 0x1e, 0x55, 0x3d, 0x17, 0x7d, 0x15, 0x00},   // 3a 0f1c 9a4e Ã¥â€œÂ¢
    {0x1e, 0x1e, 0x62, 0x1f, 0x7a, 0x29, 0x52, 0x00},   // 3a 0f1d 9a4f Ã¥â€Â¹
    {0x1e, 0x52, 0x3f, 0x41, 0x55, 0x7f, 0x55, 0x00},   // 3a 0f1e 9a50 Ã¥â€¢â‚¬
    {0x1e, 0x1e, 0x33, 0x3e, 0x2a, 0x7f, 0x1f, 0x00},   // 3a 0f1f 9a51 Ã¥â€¢Â£
    {0x1e, 0x1e, 0x46, 0x56, 0x73, 0x56, 0x46, 0x00},   // 3a 0f20 9a52 Ã¥â€¢Å’
    {0x08, 0x04, 0x7f, 0x5a, 0x5f, 0x7a, 0x0a, 0x00},   // 3a 0f21 9a53 Ã¥â€Â®
    {0x1e, 0x12, 0x5d, 0x2b, 0x5d, 0x2b, 0x5d, 0x00},   // 3a 0f22 9a54 Ã¥â€¢Å“
    {0x1e, 0x1e, 0x20, 0x3c, 0x77, 0x3e, 0x22, 0x00},   // 3a 0f23 9a55 Ã¥â€¢â€¦
    {0x1e, 0x1e, 0x55, 0x22, 0x19, 0x22, 0x55, 0x00},   // 3a 0f24 9a56 Ã¥â€¢â€“
    {0x1e, 0x1e, 0x70, 0x6a, 0x41, 0x6d, 0x7b, 0x00},   // 3a 0f25 9a57 Ã¥â€¢â€”
    {0x1e, 0x1e, 0x64, 0x2a, 0x4d, 0x5e, 0x64, 0x00},   // 3a 0f26 9a58 Ã¥â€Â¸
    {0x1e, 0x1e, 0x21, 0x5f, 0x55, 0x3d, 0x57, 0x00},   // 3a 0f27 9a59 Ã¥â€Â³
    {0x1e, 0x5e, 0x25, 0x7f, 0x15, 0x2e, 0x4e, 0x00},   // 3a 0f28 9a5a Ã¥â€¢Â
    {0x1e, 0x1e, 0x2c, 0x56, 0x7d, 0x27, 0x55, 0x00},   // 3a 0f29 9a5b Ã¥â€“â„¢
    {0x1e, 0x1e, 0x26, 0x6a, 0x57, 0x6e, 0x26, 0x00},   // 3a 0f2a 9a5c Ã¥â€“â‚¬
    {0x1e, 0x12, 0x1e, 0x6a, 0x65, 0x6b, 0x10, 0x00},   // 3a 0f2b 9a5d Ã¥â€™Â¯
    {0x1e, 0x52, 0x3e, 0x6a, 0x6a, 0x3f, 0x52, 0x00},   // 3a 0f2c 9a5e Ã¥â€“Å 
    {0x1e, 0x12, 0x1f, 0x7d, 0x2f, 0x7d, 0x0f, 0x00},   // 3a 0f2d 9a5f Ã¥â€“Å¸
    {0x1a, 0x6a, 0x7e, 0x6b, 0x7a, 0x6e, 0x1a, 0x00},   // 3a 0f2e 9a60 Ã¥â€¢Â»
    {0x1e, 0x1e, 0x35, 0x7f, 0x4c, 0x3f, 0x44, 0x00},   // 3a 0f2f 9a61 Ã¥â€¢Â¾
    {0x1e, 0x1e, 0x6b, 0x3a, 0x6b, 0x2a, 0x6b, 0x00},   // 3a 0f30 9a62 Ã¥â€“Ëœ
    {0x1e, 0x12, 0x7e, 0x2b, 0x0e, 0x7f, 0x1f, 0x00},   // 3a 0f31 9a63 Ã¥â€“Å¾
    {0x27, 0x3d, 0x37, 0x7c, 0x37, 0x3d, 0x27, 0x00},   // 3a 0f32 9a64 Ã¥â€“Â®
    {0x1e, 0x1e, 0x1a, 0x6e, 0x3b, 0x6e, 0x1a, 0x00},   // 3a 0f33 9a65 Ã¥â€¢Â¼
    {0x1e, 0x1e, 0x7a, 0x2a, 0x77, 0x2a, 0x7a, 0x00},   // 3a 0f34 9a66 Ã¥â€“Æ’
    {0x1e, 0x1e, 0x75, 0x33, 0x75, 0x26, 0x54, 0x00},   // 3a 0f35 9a67 Ã¥â€“Â©
    {0x1e, 0x52, 0x2e, 0x7f, 0x2a, 0x4e, 0x7f, 0x00},   // 3a 0f36 9a68 Ã¥â€“â€¡
    {0x1e, 0x1e, 0x5a, 0x2e, 0x0b, 0x6e, 0x5a, 0x00},   // 3a 0f37 9a69 Ã¥â€“Â¨
    {0x1e, 0x1e, 0x40, 0x1e, 0x5b, 0x1e, 0x70, 0x00},   // 3a 0f38 9a6a Ã¥â€”Å¡
    {0x1e, 0x1e, 0x50, 0x5e, 0x3b, 0x5e, 0x50, 0x00},   // 3a 0f39 9a6b Ã¥â€”â€¦
    {0x1e, 0x1e, 0x4a, 0x3b, 0x5e, 0x7b, 0x5a, 0x00},   // 3a 0f3a 9a6c Ã¥â€”Å¸
    {0x1e, 0x1e, 0x51, 0x5d, 0x2f, 0x5d, 0x41, 0x00},   // 3a 0f3b 9a6d Ã¥â€”â€ž
    {0x1e, 0x1e, 0x14, 0x6e, 0x7f, 0x76, 0x15, 0x00},   // 3a 0f3c 9a6e Ã¥â€”Å“
    {0x1e, 0x1e, 0x4b, 0x5a, 0x7f, 0x5a, 0x6b, 0x00},   // 3a 0f3d 9a6f Ã¥â€”Â¤
    {0x1e, 0x1e, 0x58, 0x13, 0x1e, 0x1e, 0x52, 0x00},   // 3a 0f3e 9a70 Ã¥â€”â€
    {0x1e, 0x12, 0x7f, 0x71, 0x47, 0x77, 0x71, 0x00},   // 3a 0f3f 9a71 Ã¥Ëœâ€
    {0x1e, 0x1e, 0x4a, 0x3f, 0x6a, 0x3f, 0x5e, 0x00},   // 3a 0f40 9a72 Ã¥â€”Â·
    {0x1e, 0x1e, 0x48, 0x3a, 0x3f, 0x3a, 0x48, 0x00},   // 3a 0f41 9a73 Ã¥Ëœâ€“
    {0x1e, 0x1e, 0x62, 0x1f, 0x7a, 0x3f, 0x56, 0x00},   // 3a 0f42 9a74 Ã¥â€”Â¾
    {0x1e, 0x52, 0x2e, 0x7f, 0x4e, 0x3b, 0x46, 0x00},   // 3a 0f43 9a75 Ã¥â€”Â½
    {0x5e, 0x3e, 0x3a, 0x7e, 0x3b, 0x7e, 0x3a, 0x00},   // 3a 0f44 9a76 Ã¥Ëœâ€º
    {0x1e, 0x1e, 0x65, 0x52, 0x5e, 0x7f, 0x52, 0x00},   // 3a 0f45 9a77 Ã¥â€”Â¹
    {0x1e, 0x1e, 0x5a, 0x6a, 0x5f, 0x6a, 0x5a, 0x00},   // 3a 0f46 9a78 Ã¥â„¢Å½
    {0x14, 0x77, 0x77, 0x1c, 0x77, 0x77, 0x14, 0x00},   // 3a 0f47 9a79 Ã¥â„¢Â
    {0x0d, 0x66, 0x6d, 0x7c, 0x6d, 0x66, 0x0d, 0x00},   // 3a 0f48 9a7a Ã§â€¡Å¸
    {0x1e, 0x1e, 0x4f, 0x3a, 0x38, 0x7f, 0x0a, 0x00},   // 3a 0f49 9a7b Ã¥ËœÂ´
    {0x1e, 0x12, 0x5f, 0x1a, 0x5f, 0x3e, 0x79, 0x00},   // 3a 0f4a 9a7c Ã¥ËœÂ¶
    {0x1e, 0x12, 0x2d, 0x7f, 0x3f, 0x15, 0x7f, 0x00},   // 3a 0f4b 9a7d Ã¥ËœÂ²
    {0x1e, 0x1e, 0x6b, 0x3e, 0x6a, 0x3e, 0x6a, 0x00},   // 3a 0f4c 9a7e Ã¥ËœÂ¸
    {0x1e, 0x1e, 0x6a, 0x3e, 0x5b, 0x5e, 0x6a, 0x00},   // 3b 0f4d 9a80 Ã¥â„¢Â«
    {0x1e, 0x1e, 0x52, 0x1f, 0x78, 0x1a, 0x57, 0x00},   // 3b 0f4e 9a81 Ã¥â„¢Â¤
    {0x1e, 0x5e, 0x38, 0x6a, 0x07, 0x6e, 0x74, 0x00},   // 3b 0f4f 9a82 Ã¥ËœÂ¯
    {0x1e, 0x1e, 0x6b, 0x5e, 0x78, 0x5b, 0x6e, 0x00},   // 3b 0f50 9a83 Ã¥â„¢Â¬
    {0x1e, 0x12, 0x5e, 0x37, 0x7d, 0x37, 0x5c, 0x00},   // 3b 0f51 9a84 Ã¥â„¢Âª
    {0x1e, 0x1e, 0x72, 0x1f, 0x56, 0x1f, 0x72, 0x00},   // 3b 0f52 9a85 Ã¥Å¡â€ 
    {0x1e, 0x12, 0x1e, 0x56, 0x7f, 0x1a, 0x16, 0x00},   // 3b 0f53 9a86 Ã¥Å¡â‚¬
    {0x1e, 0x1e, 0x38, 0x6e, 0x3b, 0x6e, 0x38, 0x00},   // 3b 0f54 9a87 Ã¥Å¡Å 
    {0x1e, 0x1e, 0x26, 0x55, 0x6a, 0x57, 0x7f, 0x00},   // 3b 0f55 9a88 Ã¥Å¡Â 
    {0x1e, 0x1e, 0x4c, 0x2e, 0x7f, 0x5e, 0x4c, 0x00},   // 3b 0f56 9a89 Ã¥Å¡â€
    {0x1e, 0x1e, 0x4c, 0x2e, 0x7f, 0x5e, 0x5c, 0x00},   // 3b 0f57 9a8a Ã¥Å¡Â
    {0x1e, 0x1e, 0x52, 0x1f, 0x56, 0x1f, 0x52, 0x00},   // 3b 0f58 9a8b Ã¥Å¡Â¥
    {0x7a, 0x15, 0x7f, 0x5b, 0x70, 0x1f, 0x77, 0x00},   // 3b 0f59 9a8c Ã¥Å¡Â®
    {0x1e, 0x1e, 0x57, 0x7b, 0x54, 0x33, 0x57, 0x00},   // 3b 0f5a 9a8d Ã¥Å¡Â¶
    {0x40, 0x3f, 0x2f, 0x7a, 0x53, 0x2b, 0x5a, 0x00},   // 3b 0f5b 9a8e Ã¥Å¡Â´
    {0x24, 0x67, 0x7f, 0x1c, 0x7f, 0x67, 0x24, 0x00},   // 3b 0f5c 9a8f Ã¥â€ºâ€š
    {0x1e, 0x12, 0x7e, 0x2d, 0x0f, 0x5d, 0x7e, 0x00},   // 3b 0f5d 9a90 Ã¥Å¡Â¼
    {0x1e, 0x12, 0x3e, 0x75, 0x27, 0x3f, 0x75, 0x00},   // 3b 0f5e 9a91 Ã¥â€ºÂ
    {0x1e, 0x5e, 0x36, 0x7b, 0x36, 0x7e, 0x55, 0x00},   // 3b 0f5f 9a92 Ã¥â€ºÆ’
    {0x1e, 0x12, 0x2d, 0x7f, 0x2e, 0x5f, 0x7e, 0x00},   // 3b 0f60 9a93 Ã¥â€ºâ‚¬
    {0x1e, 0x1e, 0x52, 0x7f, 0x5a, 0x37, 0x5a, 0x00},   // 3b 0f61 9a94 Ã¥â€ºË†
    {0x1e, 0x5f, 0x15, 0x5f, 0x02, 0x6d, 0x6e, 0x00},   // 3b 0f62 9a95 Ã¥â€ºÅ½
    {0x1e, 0x52, 0x3f, 0x5b, 0x7f, 0x3b, 0x77, 0x00},   // 3b 0f63 9a96 Ã¥â€ºâ€˜
    {0x1e, 0x1e, 0x0a, 0x7f, 0x5e, 0x6b, 0x7f, 0x00},   // 3b 0f64 9a97 Ã¥â€ºâ€œ
    {0x7f, 0x41, 0x41, 0x41, 0x41, 0x41, 0x7f, 0x00},   // 3b 0f65 9a98 Ã¥â€ºâ€”
    {0x7f, 0x49, 0x7d, 0x43, 0x7f, 0x65, 0x7f, 0x00},   // 3b 0f66 9a99 Ã¥â€ºÂ®
    {0x7f, 0x49, 0x4d, 0x7b, 0x4d, 0x59, 0x7f, 0x00},   // 3b 0f67 9a9a Ã¥â€ºÂ¹
    {0x7f, 0x45, 0x6b, 0x59, 0x7f, 0x4d, 0x7f, 0x00},   // 3b 0f68 9a9b Ã¥Å“â‚¬
    {0x7f, 0x55, 0x4f, 0x75, 0x75, 0x41, 0x7f, 0x00},   // 3b 0f69 9a9c Ã¥â€ºÂ¿
    {0x7f, 0x55, 0x7f, 0x77, 0x7b, 0x51, 0x7f, 0x00},   // 3b 0f6a 9a9d Ã¥Å“â€ž
    {0x7f, 0x55, 0x5d, 0x77, 0x5d, 0x55, 0x7f, 0x00},   // 3b 0f6b 9a9e Ã¥Å“â€°
    {0x7f, 0x55, 0x7f, 0x7d, 0x6f, 0x55, 0x7f, 0x00},   // 3b 0f6c 9a9f Ã¥Å“Ë†
    {0x7f, 0x6d, 0x6d, 0x45, 0x5f, 0x65, 0x7f, 0x00},   // 3b 0f6d 9aa0 Ã¥Å“â€¹
    {0x7f, 0x55, 0x5d, 0x57, 0x7f, 0x55, 0x7f, 0x00},   // 3b 0f6e 9aa1 Ã¥Å“Â
    {0x7f, 0x61, 0x5f, 0x5b, 0x5f, 0x61, 0x7f, 0x00},   // 3b 0f6f 9aa2 Ã¥Å“â€œ
    {0x7f, 0x55, 0x5d, 0x5f, 0x7d, 0x55, 0x7f, 0x00},   // 3b 0f70 9aa3 Ã¥Å“Ëœ
    {0x7f, 0x49, 0x7f, 0x6d, 0x7f, 0x49, 0x7f, 0x00},   // 3b 0f71 9aa4 Ã¥Å“â€“
    {0x1a, 0x76, 0x7a, 0x5f, 0x7a, 0x76, 0x1a, 0x00},   // 3b 0f72 9aa5 Ã¥â€”â€¡
    {0x7f, 0x55, 0x7f, 0x6f, 0x5f, 0x65, 0x7f, 0x00},   // 3b 0f73 9aa6 Ã¥Å“Å“
    {0x24, 0x3f, 0x54, 0x31, 0x0f, 0x30, 0x40, 0x00},   // 3b 0f74 9aa7 Ã¥Å“Â¦
    {0x24, 0x3f, 0x15, 0x01, 0x7f, 0x05, 0x09, 0x00},   // 3b 0f75 9aa8 Ã¥Å“Â·
    {0x24, 0x3f, 0x7c, 0x40, 0x7f, 0x40, 0x7c, 0x00},   // 3b 0f76 9aa9 Ã¥Å“Â¸
    {0x24, 0x3f, 0x54, 0x23, 0x1e, 0x22, 0x46, 0x00},   // 3b 0f77 9aaa Ã¥ÂÅ½
    {0x24, 0x3f, 0x54, 0x3e, 0x0a, 0x79, 0x08, 0x00},   // 3b 0f78 9aab Ã¥Å“Â»
    {0x24, 0x3f, 0x54, 0x7c, 0x40, 0x7f, 0x44, 0x00},   // 3b 0f79 9aac Ã¥Ââ‚¬
    {0x24, 0x3f, 0x11, 0x09, 0x7f, 0x09, 0x11, 0x00},   // 3b 0f7a 9aad Ã¥ÂÂ
    {0x24, 0x3f, 0x12, 0x7f, 0x4a, 0x7f, 0x02, 0x00},   // 3b 0f7b 9aae Ã¥ÂÂ©
    {0x54, 0x5e, 0x66, 0x7e, 0x65, 0x5d, 0x54, 0x00},   // 3b 0f7c 9aaf Ã¥Å¸â‚¬
    {0x44, 0x5e, 0x51, 0x7a, 0x53, 0x56, 0x4b, 0x00},   // 3b 0f7d 9ab0 Ã¥Å¾Ë†
    {0x24, 0x3f, 0x7e, 0x5a, 0x2f, 0x5a, 0x46, 0x00},   // 3b 0f7e 9ab1 Ã¥ÂÂ¡
    {0x24, 0x3f, 0x14, 0x7e, 0x09, 0x42, 0x7f, 0x00},   // 3b 0f7f 9ab2 Ã¥ÂÂ¿
    {0x24, 0x3f, 0x04, 0x7b, 0x5a, 0x42, 0x5e, 0x00},   // 3b 0f80 9ab3 Ã¥Å¾â€°
    {0x24, 0x3f, 0x4a, 0x56, 0x2b, 0x32, 0x4a, 0x00},   // 3b 0f81 9ab4 Ã¥Å¾â€œ
    {0x24, 0x3f, 0x14, 0x7f, 0x55, 0x35, 0x5f, 0x00},   // 3b 0f82 9ab5 Ã¥Å¾Â 
    {0x24, 0x3f, 0x0a, 0x7d, 0x00, 0x45, 0x7d, 0x00},   // 3b 0f83 9ab6 Ã¥Å¾Â³
    {0x24, 0x3f, 0x45, 0x57, 0x7d, 0x53, 0x45, 0x00},   // 3b 0f84 9ab7 Ã¥Å¾Â¤
    {0x24, 0x3f, 0x54, 0x3d, 0x14, 0x7d, 0x14, 0x00},   // 3b 0f85 9ab8 Ã¥Å¾Âª
    {0x24, 0x3f, 0x14, 0x08, 0x7f, 0x1a, 0x2a, 0x00},   // 3b 0f86 9ab9 Ã¥Å¾Â°
    {0x24, 0x3f, 0x54, 0x5e, 0x35, 0x54, 0x56, 0x00},   // 3b 0f87 9aba Ã¥Å¸Æ’
    {0x24, 0x3f, 0x42, 0x3e, 0x1d, 0x57, 0x7c, 0x00},   // 3b 0f88 9abb Ã¥Å¸â€ 
    {0x24, 0x3f, 0x7a, 0x2a, 0x7f, 0x2a, 0x7b, 0x00},   // 3b 0f89 9abc Ã¥Å¸â€
    {0x24, 0x3f, 0x0a, 0x29, 0x4b, 0x7d, 0x0a, 0x00},   // 3b 0f8a 9abd Ã¥Å¸â€™
    {0x24, 0x3f, 0x14, 0x2a, 0x4d, 0x7b, 0x08, 0x00},   // 3b 0f8b 9abe Ã¥Å¸â€œ
    {0x51, 0x5f, 0x5b, 0x71, 0x5b, 0x5f, 0x51, 0x00},   // 3b 0f8c 9abf Ã¥Â Å 
    {0x24, 0x3f, 0x12, 0x7b, 0x02, 0x7f, 0x52, 0x00},   // 3b 0f8d 9ac0 Ã¥Å¸â€“
    {0x24, 0x3f, 0x32, 0x2e, 0x73, 0x2e, 0x32, 0x00},   // 3b 0f8e 9ac1 Ã¥Å¸Â£
    {0x24, 0x7f, 0x3f, 0x55, 0x3f, 0x55, 0x7f, 0x00},   // 3b 0f8f 9ac2 Ã¥Â â€¹
    {0x24, 0x3f, 0x14, 0x5d, 0x5f, 0x7f, 0x5d, 0x00},   // 3b 0f90 9ac3 Ã¥Â â„¢
    {0x24, 0x3f, 0x14, 0x78, 0x0f, 0x69, 0x7f, 0x00},   // 3b 0f91 9ac4 Ã¥Â Â
    {0x24, 0x3f, 0x24, 0x5f, 0x3a, 0x5e, 0x72, 0x00},   // 3b 0f92 9ac5 Ã¥Â¡Â²
    {0x44, 0x5e, 0x55, 0x6f, 0x5d, 0x4f, 0x54, 0x00},   // 3b 0f93 9ac6 Ã¥Â Â¡
    {0x24, 0x3f, 0x54, 0x1e, 0x5b, 0x1e, 0x70, 0x00},   // 3b 0f94 9ac7 Ã¥Â¡Â¢
    {0x4d, 0x46, 0x55, 0x7c, 0x55, 0x46, 0x4d, 0x00},   // 3b 0f95 9ac8 Ã¥Â¡â€¹
    {0x55, 0x40, 0x4b, 0x7e, 0x5e, 0x5e, 0x4a, 0x00},   // 3b 0f96 9ac9 Ã¥Â¡Â°
    {0x4e, 0x59, 0x3a, 0x2e, 0x5b, 0x29, 0x5b, 0x00},   // 3b 0f97 9aca Ã¦Â¯â‚¬
    {0x24, 0x3f, 0x3e, 0x6a, 0x2f, 0x7a, 0x28, 0x00},   // 3b 0f98 9acb Ã¥Â¡â€™
    {0x24, 0x3f, 0x14, 0x77, 0x47, 0x7d, 0x57, 0x00},   // 3b 0f99 9acc Ã¥Â Â½
    {0x4a, 0x4e, 0x5f, 0x6a, 0x47, 0x5d, 0x45, 0x00},   // 3b 0f9a 9acd Ã¥Â¡Â¹
    {0x57, 0x5f, 0x57, 0x60, 0x55, 0x5f, 0x4d, 0x00},   // 3b 0f9b 9ace Ã¥Â¢â€¦
    {0x24, 0x3f, 0x7f, 0x03, 0x38, 0x3b, 0x7f, 0x00},   // 3b 0f9c 9acf Ã¥Â¢Â¹
    {0x24, 0x3f, 0x54, 0x3c, 0x44, 0x6f, 0x4a, 0x00},   // 3b 0f9d 9ad0 Ã¥Â¢Å¸
    {0x24, 0x3f, 0x1e, 0x3d, 0x54, 0x7d, 0x1e, 0x00},   // 3b 0f9e 9ad1 Ã¥Â¢Â«
    {0x24, 0x3f, 0x50, 0x5e, 0x3f, 0x56, 0x5e, 0x00},   // 3b 0f9f 9ad2 Ã¥Â¢Âº
    {0x24, 0x3f, 0x2a, 0x6e, 0x5f, 0x2a, 0x4e, 0x00},   // 3b 0fa0 9ad3 Ã¥Â£Å¾
    {0x24, 0x3f, 0x7a, 0x76, 0x5b, 0x76, 0x7a, 0x00},   // 3b 0fa1 9ad4 Ã¥Â¢Â»
    {0x24, 0x3f, 0x52, 0x37, 0x7e, 0x7f, 0x12, 0x00},   // 3b 0fa2 9ad5 Ã¥Â¢Â¸
    {0x5f, 0x4b, 0x40, 0x6a, 0x5f, 0x5a, 0x5a, 0x00},   // 3b 0fa3 9ad6 Ã¥Â¢Â®
    {0x56, 0x4a, 0x42, 0x6b, 0x5e, 0x5e, 0x56, 0x00},   // 3b 0fa4 9ad7 Ã¥Â£â€¦
    {0x50, 0x4f, 0x5b, 0x7b, 0x55, 0x4f, 0x55, 0x00},   // 3b 0fa5 9ad8 Ã¥Â£â€œ
    {0x56, 0x5b, 0x5f, 0x6a, 0x57, 0x49, 0x57, 0x00},   // 3b 0fa6 9ad9 Ã¥Â£â€˜
    {0x24, 0x3f, 0x54, 0x6a, 0x7f, 0x6e, 0x54, 0x00},   // 3b 0fa7 9ada Ã¥Â£â€”
    {0x24, 0x3f, 0x7e, 0x4a, 0x3f, 0x3e, 0x4a, 0x00},   // 3b 0fa8 9adb Ã¥Â£â„¢
    {0x58, 0x5f, 0x5d, 0x67, 0x5d, 0x5f, 0x58, 0x00},   // 3b 0fa9 9adc Ã¥Â£Ëœ
    {0x24, 0x3f, 0x1f, 0x45, 0x57, 0x67, 0x55, 0x00},   // 3b 0faa 9add Ã¥Â£Â¥
    {0x24, 0x3f, 0x4c, 0x6f, 0x55, 0x3f, 0x4c, 0x00},   // 3b 0fab 9ade Ã¥Â£Å“
    {0x24, 0x3f, 0x36, 0x7e, 0x5b, 0x3e, 0x56, 0x00},   // 3b 0fac 9adf Ã¥Â£Â¤
    {0x4a, 0x5e, 0x4b, 0x7e, 0x42, 0x5b, 0x55, 0x00},   // 3b 0fad 9ae0 Ã¥Â£Å¸
    {0x57, 0x34, 0x7f, 0x04, 0x44, 0x7f, 0x44, 0x00},   // 3b 0fae 9ae1 Ã¥Â£Â¯
    {0x5a, 0x6a, 0x7a, 0x4f, 0x7a, 0x6a, 0x5a, 0x00},   // 3b 0faf 9ae2 Ã¥Â£Âº
    {0x5a, 0x4a, 0x7a, 0x5f, 0x7a, 0x4a, 0x5a, 0x00},   // 3b 0fb0 9ae3 Ã¥Â£Â¹
    {0x24, 0x3f, 0x14, 0x09, 0x77, 0x2d, 0x7b, 0x00},   // 3b 0fb1 9ae4 Ã¥Â£Â»
    {0x5a, 0x6a, 0x7a, 0x5f, 0x7a, 0x6a, 0x5a, 0x00},   // 3b 0fb2 9ae5 Ã¥Â£Â¼
    {0x14, 0x76, 0x76, 0x1f, 0x56, 0x76, 0x14, 0x00},   // 3b 0fb3 9ae6 Ã¥Â£Â½
    {0x48, 0x44, 0x2b, 0x12, 0x2a, 0x46, 0x40, 0x00},   // 3b 0fb4 9ae7 Ã¥Â¤â€š
    {0x4a, 0x44, 0x2b, 0x12, 0x2a, 0x46, 0x40, 0x00},   // 3b 0fb5 9ae8 Ã¥Â¤Å 
    {0x42, 0x52, 0x5d, 0x2f, 0x5f, 0x4e, 0x40, 0x00},   // 3b 0fb6 9ae9 Ã¥Â¤Â
    {0x44, 0x54, 0x55, 0x2d, 0x2f, 0x1c, 0x04, 0x00},   // 3b 0fb7 9aea Ã¥Â¤â€º
    {0x4a, 0x56, 0x5f, 0x2a, 0x2e, 0x1f, 0x0a, 0x00},   // 3b 0fb8 9aeb Ã¦Â¢Â¦
    {0x48, 0x2b, 0x7f, 0x2b, 0x52, 0x2d, 0x1b, 0x00},   // 3b 0fb9 9aec Ã¥Â¤Â¥
    {0x48, 0x4a, 0x2a, 0x1f, 0x2a, 0x4e, 0x48, 0x00},   // 3b 0fba 9aed Ã¥Â¤Â¬
    {0x48, 0x4a, 0x2a, 0x1e, 0x29, 0x49, 0x48, 0x00},   // 3b 0fbb 9aee Ã¥Â¤Â­
    {0x2a, 0x2a, 0x26, 0x73, 0x26, 0x2a, 0x2a, 0x00},   // 3b 0fbc 9aef Ã¥Â¤Â²
    {0x0a, 0x0a, 0x36, 0x33, 0x36, 0x6a, 0x0a, 0x00},   // 3b 0fbd 9af0 Ã¥Â¤Â¸
    {0x52, 0x4e, 0x52, 0x3f, 0x52, 0x4e, 0x52, 0x00},   // 3b 0fbe 9af1 Ã¥Â¤Â¾
    {0x08, 0x7a, 0x5e, 0x7b, 0x0e, 0x7a, 0x08, 0x00},   // 3b 0fbf 9af2 Ã§Â«â€™
    {0x4a, 0x52, 0x5e, 0x33, 0x5e, 0x52, 0x4a, 0x00},   // 3b 0fc0 9af3 Ã¥Â¥â€¢
    {0x52, 0x5e, 0x5d, 0x35, 0x5f, 0x5c, 0x50, 0x00},   // 3b 0fc1 9af4 Ã¥Â¥Â
    {0x4a, 0x4a, 0x56, 0x7b, 0x56, 0x4a, 0x4a, 0x00},   // 3b 0fc2 9af5 Ã¥Â¥Å½
    {0x54, 0x53, 0x55, 0x3b, 0x51, 0x59, 0x52, 0x00},   // 3b 0fc3 9af6 Ã¥Â¥Å¡
    {0x4b, 0x56, 0x5f, 0x32, 0x5a, 0x5f, 0x4a, 0x00},   // 3b 0fc4 9af7 Ã¥Â¥Ëœ
    {0x4a, 0x5a, 0x36, 0x7b, 0x56, 0x7a, 0x1a, 0x00},   // 3b 0fc5 9af8 Ã¥Â¥Â¢
    {0x52, 0x5e, 0x5d, 0x34, 0x5d, 0x5e, 0x52, 0x00},   // 3b 0fc6 9af9 Ã¥Â¥Â 
    {0x50, 0x5e, 0x5e, 0x3f, 0x56, 0x5e, 0x50, 0x00},   // 3b 0fc7 9afa Ã¥Â¥Â§
    {0x5b, 0x56, 0x5f, 0x36, 0x5d, 0x5f, 0x54, 0x00},   // 3b 0fc8 9afb Ã¥Â¥Â¬
    {0x0a, 0x7a, 0x66, 0x7b, 0x5a, 0x66, 0x6a, 0x00},   // 3b 0fc9 9afc Ã¥Â¥Â©
    {0x44, 0x5c, 0x37, 0x2c, 0x09, 0x7f, 0x09, 0x00},   // 3c 0fca 9b40 Ã¥Â¥Â¸
    {0x44, 0x5c, 0x37, 0x2c, 0x0b, 0x52, 0x7e, 0x00},   // 3c 0fcb 9b41 Ã¥Â¦Â
    {0x57, 0x34, 0x7f, 0x44, 0x5c, 0x37, 0x4c, 0x00},   // 3c 0fcc 9b42 Ã¥Â¦Â
    {0x04, 0x7e, 0x01, 0x54, 0x7d, 0x35, 0x54, 0x00},   // 3c 0fcd 9b43 Ã¤Â½Å¾
    {0x04, 0x7e, 0x53, 0x7e, 0x5b, 0x3a, 0x52, 0x00},   // 3c 0fce 9b44 Ã¤Â¾Â«
    {0x5c, 0x37, 0x2c, 0x7f, 0x24, 0x7f, 0x44, 0x00},   // 3c 0fcf 9b45 Ã¥Â¦Â£
    {0x44, 0x5c, 0x37, 0x2c, 0x5f, 0x55, 0x5f, 0x00},   // 3c 0fd0 9b46 Ã¥Â¦Â²
    {0x5c, 0x37, 0x3c, 0x2f, 0x69, 0x7f, 0x28, 0x00},   // 3c 0fd1 9b47 Ã¥Â§â€ 
    {0x5f, 0x3c, 0x42, 0x5e, 0x3f, 0x56, 0x72, 0x00},   // 3c 0fd2 9b48 Ã¥Â§Â¨
    {0x52, 0x56, 0x77, 0x5e, 0x36, 0x57, 0x52, 0x00},   // 3c 0fd3 9b49 Ã¥Â§Å“
    {0x5f, 0x3c, 0x49, 0x3f, 0x09, 0x7f, 0x09, 0x00},   // 3c 0fd4 9b4a Ã¥Â¦Â
    {0x5f, 0x3c, 0x7e, 0x01, 0x4a, 0x7e, 0x49, 0x00},   // 3c 0fd5 9b4b Ã¥Â§â„¢
    {0x5f, 0x3c, 0x4a, 0x3f, 0x00, 0x7f, 0x4a, 0x00},   // 3c 0fd6 9b4c Ã¥Â§Å¡
    {0x5f, 0x3c, 0x26, 0x7e, 0x25, 0x3f, 0x55, 0x00},   // 3c 0fd7 9b4d Ã¥Â¨Â¥
    {0x44, 0x5c, 0x37, 0x7c, 0x2b, 0x2b, 0x78, 0x00},   // 3c 0fd8 9b4e Ã¥Â¨Å¸
    {0x55, 0x50, 0x7a, 0x58, 0x37, 0x54, 0x52, 0x00},   // 3c 0fd9 9b4f Ã¥Â¨â€˜
    {0x5f, 0x3c, 0x55, 0x3f, 0x55, 0x7f, 0x1b, 0x00},   // 3c 0fda 9b50 Ã¥Â¨Å“
    {0x44, 0x5c, 0x37, 0x2c, 0x3e, 0x2f, 0x6e, 0x00},   // 3c 0fdb 9b51 Ã¥Â¨â€°
    {0x5c, 0x37, 0x2c, 0x5f, 0x35, 0x5f, 0x7f, 0x00},   // 3c 0fdc 9b52 Ã¥Â¨Å¡
    {0x5f, 0x3c, 0x7f, 0x1b, 0x1d, 0x55, 0x7f, 0x00},   // 3c 0fdd 9b53 Ã¥Â©â‚¬
    {0x5f, 0x3c, 0x4a, 0x59, 0x7b, 0x59, 0x4a, 0x00},   // 3c 0fde 9b54 Ã¥Â©Â¬
    {0x5f, 0x3c, 0x56, 0x2a, 0x7b, 0x4a, 0x5e, 0x00},   // 3c 0fdf 9b55 Ã¥Â©â€°
    {0x5f, 0x3c, 0x21, 0x3f, 0x7f, 0x12, 0x2e, 0x00},   // 3c 0fe0 9b56 Ã¥Â¨Âµ
    {0x55, 0x57, 0x7f, 0x55, 0x3b, 0x55, 0x5b, 0x00},   // 3c 0fe1 9b57 Ã¥Â¨Â¶
    {0x5f, 0x3c, 0x2e, 0x3a, 0x2f, 0x7a, 0x2e, 0x00},   // 3c 0fe2 9b58 Ã¥Â©Â¢
    {0x4a, 0x56, 0x7f, 0x5a, 0x36, 0x5f, 0x4a, 0x00},   // 3c 0fe3 9b59 Ã¥Â©Âª
    {0x5c, 0x37, 0x4c, 0x3f, 0x05, 0x77, 0x77, 0x00},   // 3c 0fe4 9b5a Ã¥ÂªÅ¡
    {0x5c, 0x37, 0x2c, 0x4f, 0x6d, 0x6b, 0x4f, 0x00},   // 3c 0fe5 9b5b Ã¥ÂªÂ¼
    {0x5f, 0x3c, 0x2a, 0x7f, 0x3a, 0x7f, 0x2a, 0x00},   // 3c 0fe6 9b5c Ã¥ÂªÂ¾
    {0x5c, 0x37, 0x2c, 0x5d, 0x77, 0x5d, 0x77, 0x00},   // 3c 0fe7 9b5d Ã¥Â«â€¹
    {0x5f, 0x3c, 0x4e, 0x59, 0x2e, 0x59, 0x4f, 0x00},   // 3c 0fe8 9b5e Ã¥Â«â€š
    {0x5c, 0x37, 0x2c, 0x5f, 0x15, 0x5f, 0x75, 0x00},   // 3c 0fe9 9b5f Ã¥ÂªÂ½
    {0x5c, 0x37, 0x2c, 0x5d, 0x17, 0x57, 0x75, 0x00},   // 3c 0fea 9b60 Ã¥Â«Â£
    {0x5f, 0x3c, 0x7f, 0x71, 0x47, 0x77, 0x71, 0x00},   // 3c 0feb 9b61 Ã¥Â«â€”
    {0x5f, 0x3c, 0x35, 0x1e, 0x7b, 0x1e, 0x35, 0x00},   // 3c 0fec 9b62 Ã¥Â«Â¦
    {0x5f, 0x3c, 0x2e, 0x7f, 0x2a, 0x3f, 0x5e, 0x00},   // 3c 0fed 9b63 Ã¥Â«Â©
    {0x5f, 0x3c, 0x51, 0x17, 0x77, 0x17, 0x51, 0x00},   // 3c 0fee 9b64 Ã¥Â«â€“
    {0x5f, 0x3c, 0x7f, 0x23, 0x18, 0x3b, 0x7f, 0x00},   // 3c 0fef 9b65 Ã¥Â«Âº
    {0x5f, 0x3c, 0x7f, 0x2b, 0x7c, 0x2b, 0x7f, 0x00},   // 3c 0ff0 9b66 Ã¥Â«Â»
    {0x5f, 0x3c, 0x7a, 0x17, 0x5b, 0x17, 0x7a, 0x00},   // 3c 0ff1 9b67 Ã¥Â¬Å’
    {0x5f, 0x3c, 0x23, 0x3f, 0x7c, 0x3f, 0x23, 0x00},   // 3c 0ff2 9b68 Ã¥Â¬â€¹
    {0x54, 0x5f, 0x7b, 0x50, 0x36, 0x5b, 0x56, 0x00},   // 3c 0ff3 9b69 Ã¥Â¬â€“
    {0x57, 0x3f, 0x5c, 0x37, 0x4c, 0x3f, 0x77, 0x00},   // 3c 0ff4 9b6a Ã¥Â¬Â²
    {0x5f, 0x3c, 0x47, 0x3f, 0x76, 0x3f, 0x5c, 0x00},   // 3c 0ff5 9b6b Ã¥Â«Â
    {0x5f, 0x3c, 0x4e, 0x3a, 0x37, 0x3a, 0x46, 0x00},   // 3c 0ff6 9b6c Ã¥Â¬Âª
    {0x5f, 0x3c, 0x38, 0x6e, 0x3b, 0x6e, 0x38, 0x00},   // 3c 0ff7 9b6d Ã¥Â¬Â¶
    {0x5f, 0x3c, 0x2e, 0x7f, 0x5a, 0x19, 0x5b, 0x00},   // 3c 0ff8 9b6e Ã¥Â¬Â¾
    {0x5f, 0x3c, 0x36, 0x7e, 0x5b, 0x3e, 0x56, 0x00},   // 3c 0ff9 9b6f Ã¥Â­Æ’
    {0x5f, 0x3c, 0x55, 0x7e, 0x55, 0x3f, 0x54, 0x00},   // 3c 0ffa 9b70 Ã¥Â­â€¦
    {0x5f, 0x3c, 0x26, 0x73, 0x27, 0x73, 0x76, 0x00},   // 3c 0ffb 9b71 Ã¥Â­â‚¬
    {0x10, 0x11, 0x51, 0x7d, 0x0b, 0x09, 0x08, 0x00},   // 3c 0ffc 9b72 Ã¥Â­â€˜
    {0x28, 0x29, 0x27, 0x69, 0x3b, 0x2a, 0x26, 0x00},   // 3c 0ffd 9b73 Ã¥Â­â€¢
    {0x14, 0x13, 0x55, 0x77, 0x1d, 0x11, 0x12, 0x00},   // 3c 0ffe 9b74 Ã¥Â­Å¡
    {0x2c, 0x26, 0x2e, 0x6f, 0x3e, 0x26, 0x2c, 0x00},   // 3c 0fff 9b75 Ã¥Â­â€º
    {0x2a, 0x2e, 0x2b, 0x6e, 0x3b, 0x25, 0x2b, 0x00},   // 3c 1000 9b76 Ã¥Â­Â¥
    {0x51, 0x7d, 0x4b, 0x56, 0x2b, 0x32, 0x4a, 0x00},   // 3c 1001 9b77 Ã¥Â­Â©
    {0x22, 0x2e, 0x6b, 0x3e, 0x13, 0x7e, 0x40, 0x00},   // 3c 1002 9b78 Ã¥Â­Â°
    {0x22, 0x2a, 0x37, 0x72, 0x3a, 0x37, 0x22, 0x00},   // 3c 1003 9b79 Ã¥Â­Â³
    {0x5e, 0x3d, 0x7e, 0x21, 0x6b, 0x39, 0x22, 0x00},   // 3c 1004 9b7a Ã¥Â­Âµ
    {0x2c, 0x26, 0x2d, 0x6e, 0x3d, 0x27, 0x2c, 0x00},   // 3c 1005 9b7b Ã¥Â­Â¸
    {0x22, 0x32, 0x36, 0x6b, 0x36, 0x32, 0x22, 0x00},   // 3c 1006 9b7c Ã¦â€“Ë†
    {0x51, 0x7d, 0x0b, 0x66, 0x2b, 0x7f, 0x6e, 0x00},   // 3c 1007 9b7d Ã¥Â­Âº
    {0x18, 0x08, 0x08, 0x0c, 0x08, 0x08, 0x18, 0x00},   // 3c 1008 9b7e Ã¥Â®â‚¬
    {0x06, 0x3a, 0x52, 0x53, 0x4a, 0x4a, 0x66, 0x00},   // 3d 1009 9b80 Ã¥Â®Æ’
    {0x06, 0x7e, 0x56, 0x77, 0x5e, 0x42, 0x06, 0x00},   // 3d 100a 9b81 Ã¥Â®Â¦
    {0x46, 0x3e, 0x76, 0x57, 0x36, 0x52, 0x46, 0x00},   // 3d 100b 9b82 Ã¥Â®Â¸
    {0x4e, 0x5a, 0x36, 0x1f, 0x76, 0x5e, 0x66, 0x00},   // 3d 100c 9b83 Ã¥Â¯Æ’
    {0x56, 0x36, 0x56, 0x63, 0x5e, 0x6a, 0x46, 0x00},   // 3d 100d 9b84 Ã¥Â¯â€¡
    {0x26, 0x12, 0x7e, 0x5b, 0x7e, 0x5a, 0x56, 0x00},   // 3d 100e 9b85 Ã¥Â¯â€°
    {0x46, 0x2a, 0x4e, 0x7b, 0x5e, 0x4a, 0x46, 0x00},   // 3d 100f 9b86 Ã¥Â¯â€
    {0x56, 0x36, 0x7e, 0x2b, 0x7e, 0x2a, 0x46, 0x00},   // 3d 1010 9b87 Ã¥Â¯Â
    {0x56, 0x36, 0x7e, 0x2b, 0x7e, 0x7a, 0x26, 0x00},   // 3d 1011 9b88 Ã¥Â¯Â¤
    {0x46, 0x4a, 0x3e, 0x37, 0x3e, 0x4a, 0x46, 0x00},   // 3d 1012 9b89 Ã¥Â¯Â¦
    {0x56, 0x36, 0x7e, 0x03, 0x5a, 0x2a, 0x5e, 0x00},   // 3d 1013 9b8a Ã¥Â¯Â¢
    {0x56, 0x5a, 0x5e, 0x3b, 0x5e, 0x5a, 0x56, 0x00},   // 3d 1014 9b8b Ã¥Â¯Å¾
    {0x16, 0x12, 0x4e, 0x57, 0x2a, 0x16, 0x16, 0x00},   // 3d 1015 9b8c Ã¥Â¯Â¥
    {0x26, 0x5a, 0x16, 0x53, 0x1e, 0x52, 0x76, 0x00},   // 3d 1016 9b8d Ã¥Â¯Â«
    {0x26, 0x2a, 0x7e, 0x5f, 0x3e, 0x5a, 0x46, 0x00},   // 3d 1017 9b8e Ã¥Â¯Â°
    {0x56, 0x7e, 0x36, 0x33, 0x3e, 0x7a, 0x46, 0x00},   // 3d 1018 9b8f Ã¥Â¯Â¶
    {0x56, 0x7e, 0x36, 0x3b, 0x36, 0x7a, 0x46, 0x00},   // 3d 1019 9b90 Ã¥Â¯Â³
    {0x5a, 0x37, 0x5a, 0x40, 0x4a, 0x62, 0x7f, 0x00},   // 3d 101a 9b91 Ã¥Â°â€¦
    {0x57, 0x34, 0x7f, 0x08, 0x2a, 0x4d, 0x7b, 0x00},   // 3d 101b 9b92 Ã¥Â°â€¡
    {0x12, 0x12, 0x3e, 0x5f, 0x76, 0x1a, 0x12, 0x00},   // 3d 101c 9b93 Ã¥Â°Ë†
    {0x4b, 0x5e, 0x3b, 0x2e, 0x09, 0x52, 0x7f, 0x00},   // 3d 101d 9b94 Ã¥Â°Â
    {0x24, 0x1b, 0x42, 0x7e, 0x02, 0x0a, 0x32, 0x00},   // 3d 101e 9b95 Ã¥Â°â€œ
    {0x72, 0x5f, 0x72, 0x5f, 0x46, 0x2f, 0x14, 0x00},   // 3d 101f 9b96 Ã¥Â°Â 
    {0x42, 0x42, 0x22, 0x1f, 0x7a, 0x42, 0x62, 0x00},   // 3d 1020 9b97 Ã¥Â°Â¢
    {0x42, 0x3f, 0x7a, 0x43, 0x40, 0x6a, 0x55, 0x00},   // 3d 1021 9b98 Ã¥Â°Â¨
    {0x40, 0x3f, 0x05, 0x05, 0x05, 0x05, 0x07, 0x00},   // 3d 1022 9b99 Ã¥Â°Â¸
    {0x44, 0x55, 0x35, 0x1f, 0x15, 0x1f, 0x04, 0x00},   // 3d 1023 9b9a Ã¥Â°Â¹
    {0x40, 0x3f, 0x7d, 0x55, 0x05, 0x7d, 0x57, 0x00},   // 3d 1024 9b9b Ã¥Â±Â
    {0x40, 0x3f, 0x7b, 0x53, 0x7f, 0x53, 0x7b, 0x00},   // 3d 1025 9b9c Ã¥Â±â€ 
    {0x40, 0x3f, 0x53, 0x37, 0x7f, 0x33, 0x57, 0x00},   // 3d 1026 9b9d Ã¥Â±Å½
    {0x40, 0x3f, 0x43, 0x3f, 0x2b, 0x3f, 0x43, 0x00},   // 3d 1027 9b9e Ã¥Â±â€œ
    {0x40, 0x3f, 0x2b, 0x77, 0x5b, 0x2f, 0x5b, 0x00},   // 3d 1028 9b9f Ã¥Â±Â
    {0x40, 0x3f, 0x6b, 0x3f, 0x2b, 0x7f, 0x2b, 0x00},   // 3d 1029 9ba0 Ã¥Â±Â
    {0x40, 0x3f, 0x6b, 0x3b, 0x0f, 0x6f, 0x3b, 0x00},   // 3d 102a 9ba1 Ã¥Â­Â±
    {0x40, 0x3f, 0x57, 0x7b, 0x3f, 0x4b, 0x7f, 0x00},   // 3d 102b 9ba2 Ã¥Â±Â¬
    {0x5e, 0x50, 0x30, 0x1f, 0x10, 0x10, 0x1e, 0x00},   // 3d 102c 9ba3 Ã¥Â±Â®
    {0x38, 0x20, 0x3f, 0x20, 0x7f, 0x40, 0x60, 0x00},   // 3d 102d 9ba4 Ã¤Â¹Â¢
    {0x48, 0x4f, 0x2c, 0x1f, 0x0c, 0x4f, 0x78, 0x00},   // 3d 102e 9ba5 Ã¥Â±Â¶
    {0x38, 0x3f, 0x04, 0x23, 0x56, 0x4e, 0x62, 0x00},   // 3d 102f 9ba6 Ã¥Â±Â¹
    {0x43, 0x22, 0x5e, 0x53, 0x26, 0x5e, 0x43, 0x00},   // 3d 1030 9ba7 Ã¥Â²Å’
    {0x0b, 0x1a, 0x56, 0x53, 0x36, 0x1a, 0x0b, 0x00},   // 3d 1031 9ba8 Ã¥Â²â€˜
    {0x64, 0x52, 0x55, 0x6c, 0x55, 0x5e, 0x64, 0x00},   // 3d 1032 9ba9 Ã¥Â²â€
    {0x54, 0x57, 0x76, 0x5f, 0x36, 0x57, 0x54, 0x00},   // 3d 1033 9baa Ã¥Â¦â€º
    {0x38, 0x3f, 0x7e, 0x4a, 0x7f, 0x4a, 0x7e, 0x00},   // 3d 1034 9bab Ã¥Â²Â«
    {0x38, 0x3f, 0x38, 0x7e, 0x4a, 0x5e, 0x69, 0x00},   // 3d 1035 9bac Ã¥Â²Â»
    {0x38, 0x3f, 0x38, 0x7e, 0x4b, 0x4a, 0x7e, 0x00},   // 3d 1036 9bad Ã¥Â²Â¶
    {0x38, 0x3f, 0x15, 0x13, 0x7f, 0x13, 0x15, 0x00},   // 3d 1037 9bae Ã¥Â²Â¼
    {0x38, 0x3f, 0x38, 0x7f, 0x55, 0x3d, 0x57, 0x00},   // 3d 1038 9baf Ã¥Â²Â·
    {0x38, 0x3f, 0x54, 0x3e, 0x15, 0x7c, 0x16, 0x00},   // 3d 1039 9bb0 Ã¥Â³â€¦
    {0x38, 0x3f, 0x38, 0x70, 0x5f, 0x54, 0x74, 0x00},   // 3d 103a 9bb1 Ã¥Â²Â¾
    {0x13, 0x12, 0x6a, 0x6f, 0x6a, 0x12, 0x13, 0x00},   // 3d 103b 9bb2 Ã¥Â³â€¡
    {0x38, 0x3f, 0x28, 0x6a, 0x2f, 0x7a, 0x28, 0x00},   // 3d 103c 9bb3 Ã¥Â³â„¢
    {0x2b, 0x2e, 0x7e, 0x0b, 0x5e, 0x2a, 0x57, 0x00},   // 3d 103d 9bb4 Ã¥Â³Â©
    {0x38, 0x3f, 0x52, 0x4e, 0x3f, 0x4e, 0x52, 0x00},   // 3d 103e 9bb5 Ã¥Â³Â½
    {0x38, 0x3f, 0x41, 0x57, 0x3f, 0x47, 0x41, 0x00},   // 3d 103f 9bb6 Ã¥Â³Âº
    {0x38, 0x3f, 0x02, 0x7d, 0x2a, 0x7d, 0x02, 0x00},   // 3d 1040 9bb7 Ã¥Â³Â­
    {0x43, 0x1e, 0x56, 0x17, 0x56, 0x16, 0x73, 0x00},   // 3d 1041 9bb8 Ã¥Â¶Å’
    {0x38, 0x3f, 0x12, 0x69, 0x64, 0x69, 0x12, 0x00},   // 3d 1042 9bb9 Ã¥Â³Âª
    {0x2b, 0x3e, 0x2a, 0x7f, 0x2a, 0x3e, 0x2b, 0x00},   // 3d 1043 9bba Ã¥Â´â€¹
    {0x38, 0x3f, 0x40, 0x3f, 0x55, 0x7f, 0x55, 0x00},   // 3d 1044 9bbb Ã¥Â´â€¢
    {0x7f, 0x6a, 0x4e, 0x7b, 0x4e, 0x6a, 0x7f, 0x00},   // 3d 1045 9bbc Ã¥Â´â€”
    {0x0b, 0x7a, 0x5e, 0x7b, 0x0a, 0x7e, 0x0b, 0x00},   // 3d 1046 9bbd Ã¥ÂµÅ“
    {0x4b, 0x6a, 0x5a, 0x77, 0x5a, 0x6a, 0x4b, 0x00},   // 3d 1047 9bbe Ã¥Â´Å¸
    {0x38, 0x3f, 0x1f, 0x65, 0x4d, 0x7d, 0x6f, 0x00},   // 3d 1048 9bbf Ã¥Â´â€º
    {0x43, 0x7e, 0x5a, 0x0b, 0x7a, 0x5e, 0x53, 0x00},   // 3d 1049 9bc0 Ã¥Â´â€˜
    {0x13, 0x0a, 0x7e, 0x57, 0x7e, 0x56, 0x43, 0x00},   // 3d 104a 9bc1 Ã¥Â´â€
    {0x38, 0x3f, 0x2a, 0x29, 0x7b, 0x39, 0x12, 0x00},   // 3d 104b 9bc2 Ã¥Â´Â¢
    {0x38, 0x3f, 0x28, 0x5a, 0x2f, 0x5a, 0x48, 0x00},   // 3d 104c 9bc3 Ã¥Â´Å¡
    {0x0b, 0x7a, 0x36, 0x73, 0x36, 0x7a, 0x0b, 0x00},   // 3d 104d 9bc4 Ã¥Â´â„¢
    {0x38, 0x3f, 0x74, 0x32, 0x75, 0x36, 0x74, 0x00},   // 3d 104e 9bc5 Ã¥Â´Ëœ
    {0x13, 0x7a, 0x52, 0x7b, 0x4e, 0x3a, 0x5b, 0x00},   // 3d 104f 9bc6 Ã¥ÂµÅ’
    {0x1c, 0x74, 0x5f, 0x65, 0x5f, 0x74, 0x1c, 0x00},   // 3d 1050 9bc7 Ã¥Âµâ€™
    {0x38, 0x3f, 0x78, 0x4b, 0x7f, 0x2b, 0x78, 0x00},   // 3d 1051 9bc8 Ã¥ÂµÅ½
    {0x38, 0x3f, 0x40, 0x3f, 0x05, 0x77, 0x77, 0x00},   // 3d 1052 9bc9 Ã¥Âµâ€¹
    {0x43, 0x5a, 0x3a, 0x1f, 0x7a, 0x5a, 0x63, 0x00},   // 3d 1053 9bca Ã¥ÂµÂ¬
    {0x4b, 0x3a, 0x4a, 0x5f, 0x7a, 0x5a, 0x4b, 0x00},   // 3d 1054 9bcb Ã¥ÂµÂ³
    {0x38, 0x3f, 0x38, 0x5d, 0x77, 0x5d, 0x77, 0x00},   // 3d 1055 9bcc Ã¥ÂµÂ¶
    {0x38, 0x3f, 0x7f, 0x71, 0x47, 0x77, 0x71, 0x00},   // 3d 1056 9bcd Ã¥Â¶â€¡
    {0x2b, 0x3a, 0x7e, 0x2b, 0x1e, 0x76, 0x13, 0x00},   // 3d 1057 9bce Ã¥Â¶â€ž
    {0x38, 0x3f, 0x2a, 0x3e, 0x7b, 0x3e, 0x2a, 0x00},   // 3d 1058 9bcf Ã¥Â¶â€š
    {0x38, 0x3f, 0x5c, 0x3e, 0x17, 0x7e, 0x5c, 0x00},   // 3d 1059 9bd0 Ã¥Â¶Â¢
    {0x38, 0x3f, 0x45, 0x5b, 0x69, 0x5a, 0x45, 0x00},   // 3d 105a 9bd1 Ã¥Â¶Â
    {0x38, 0x3f, 0x2a, 0x7b, 0x2e, 0x3b, 0x5a, 0x00},   // 3d 105b 9bd2 Ã¥Â¶Â¬
    {0x38, 0x3f, 0x5c, 0x36, 0x5d, 0x36, 0x5c, 0x00},   // 3d 105c 9bd3 Ã¥Â¶Â®
    {0x57, 0x4a, 0x36, 0x6b, 0x6a, 0x3e, 0x4b, 0x00},   // 3d 105d 9bd4 Ã¥Â¶Â½
    {0x7f, 0x36, 0x52, 0x57, 0x6a, 0x56, 0x53, 0x00},   // 3d 105e 9bd5 Ã¥Â¶Â
    {0x5f, 0x3a, 0x5a, 0x77, 0x36, 0x5e, 0x57, 0x00},   // 3d 105f 9bd6 Ã¥Â¶Â·
    {0x38, 0x3f, 0x5e, 0x11, 0x16, 0x1d, 0x5f, 0x00},   // 3d 1060 9bd7 Ã¥Â¶Â¼
    {0x38, 0x3f, 0x52, 0x5e, 0x2d, 0x7f, 0x56, 0x00},   // 3d 1061 9bd8 Ã¥Â·â€°
    {0x5b, 0x76, 0x3e, 0x57, 0x3a, 0x7e, 0x5b, 0x00},   // 3d 1062 9bd9 Ã¥Â·Â
    {0x4f, 0x1a, 0x5a, 0x03, 0x5a, 0x1e, 0x5b, 0x00},   // 3d 1063 9bda Ã¥Â·â€œ
    {0x0a, 0x7d, 0x4a, 0x77, 0x57, 0x6a, 0x1d, 0x00},   // 3d 1064 9bdb Ã¥Â·â€™
    {0x43, 0x3e, 0x2e, 0x7b, 0x5e, 0x2e, 0x5b, 0x00},   // 3d 1065 9bdc Ã¥Â·â€“
    {0x08, 0x14, 0x6b, 0x14, 0x6b, 0x14, 0x63, 0x00},   // 3d 1066 9bdd Ã¥Â·â€º
    {0x50, 0x4d, 0x51, 0x7f, 0x51, 0x4d, 0x50, 0x00},   // 3d 1067 9bde Ã¥Â·Â«
    {0x3d, 0x49, 0x49, 0x49, 0x49, 0x4f, 0x60, 0x00},   // 3d 1068 9bdf Ã¥Â·Â²
    {0x40, 0x3e, 0x7e, 0x56, 0x5d, 0x55, 0x5c, 0x00},   // 3d 1069 9be0 Ã¥Â·Âµ
    {0x10, 0x7e, 0x36, 0x66, 0x2d, 0x75, 0x10, 0x00},   // 3d 106a 9be1 Ã¥Â¸â€¹
    {0x1a, 0x6a, 0x2f, 0x7f, 0x2f, 0x6f, 0x1a, 0x00},   // 3d 106b 9be2 Ã¥Â¸Å¡
    {0x0e, 0x7f, 0x4c, 0x2b, 0x1f, 0x2a, 0x48, 0x00},   // 3d 106c 9be3 Ã¥Â¸â„¢
    {0x0a, 0x3e, 0x1b, 0x76, 0x1b, 0x35, 0x0b, 0x00},   // 3d 106d 9be4 Ã¥Â¸â€˜
    {0x30, 0x1e, 0x1a, 0x7b, 0x1a, 0x1e, 0x30, 0x00},   // 3d 106e 9be5 Ã¥Â¸â€º
    {0x1a, 0x77, 0x3f, 0x7a, 0x37, 0x7f, 0x1a, 0x00},   // 3d 106f 9be6 Ã¥Â¸Â¶
    {0x0e, 0x7f, 0x04, 0x7f, 0x4a, 0x7f, 0x4a, 0x00},   // 3d 1070 9be7 Ã¥Â¸Â·
    {0x0e, 0x7f, 0x40, 0x3f, 0x5b, 0x77, 0x53, 0x00},   // 3d 1071 9be8 Ã¥Â¹â€ž
    {0x0e, 0x7f, 0x28, 0x3a, 0x2f, 0x7a, 0x2e, 0x00},   // 3d 1072 9be9 Ã¥Â¹Æ’
    {0x0e, 0x7f, 0x40, 0x3c, 0x37, 0x3e, 0x42, 0x00},   // 3d 1073 9bea Ã¥Â¹â‚¬
    {0x0e, 0x7f, 0x53, 0x1d, 0x15, 0x1d, 0x53, 0x00},   // 3d 1074 9beb Ã¥Â¹Å½
    {0x0e, 0x7f, 0x7f, 0x6d, 0x4f, 0x55, 0x7f, 0x00},   // 3d 1075 9bec Ã¥Â¹â€”
    {0x0e, 0x7f, 0x4c, 0x5f, 0x2d, 0x5f, 0x4c, 0x00},   // 3d 1076 9bed Ã¥Â¹â€
    {0x0e, 0x7f, 0x0a, 0x6f, 0x6e, 0x3f, 0x55, 0x00},   // 3d 1077 9bee Ã¥Â¹Å¸
    {0x0e, 0x7f, 0x4a, 0x5e, 0x7b, 0x5e, 0x4a, 0x00},   // 3d 1078 9bef Ã¥Â¹Â¢
    {0x02, 0x3d, 0x1e, 0x75, 0x1a, 0x35, 0x0b, 0x00},   // 3d 1079 9bf0 Ã¥Â¹Â¤
    {0x0a, 0x3f, 0x1a, 0x70, 0x16, 0x3a, 0x0f, 0x00},   // 3d 107a 9bf1 Ã¥Â¹â€¡
    {0x09, 0x7f, 0x09, 0x00, 0x09, 0x7f, 0x09, 0x00},   // 3d 107b 9bf2 Ã¥Â¹Âµ
    {0x10, 0x54, 0x3d, 0x14, 0x16, 0x7d, 0x14, 0x00},   // 3d 107c 9bf3 Ã¥Â¹Â¶
    {0x40, 0x44, 0x6c, 0x53, 0x48, 0x24, 0x40, 0x00},   // 3d 107d 9bf4 Ã¥Â¹Âº
    {0x40, 0x3e, 0x5a, 0x6e, 0x5b, 0x2e, 0x4a, 0x00},   // 3d 107e 9bf5 Ã©ÂºÂ¼
    {0x40, 0x3e, 0x02, 0x02, 0x03, 0x02, 0x02, 0x00},   // 3d 107f 9bf6 Ã¥Â¹Â¿
    {0x40, 0x3e, 0x2a, 0x2e, 0x7b, 0x2e, 0x2a, 0x00},   // 3d 1080 9bf7 Ã¥ÂºÂ 
    {0x40, 0x3e, 0x5e, 0x16, 0x5f, 0x02, 0x7a, 0x00},   // 3d 1081 9bf8 Ã¥Â»Â
    {0x40, 0x3e, 0x7e, 0x2a, 0x7f, 0x56, 0x7e, 0x00},   // 3d 1082 9bf9 Ã¥Â»â€š
    {0x40, 0x3e, 0x42, 0x52, 0x2f, 0x5e, 0x42, 0x00},   // 3d 1083 9bfa Ã¥Â»Ë†
    {0x40, 0x3e, 0x3a, 0x2e, 0x57, 0x3e, 0x56, 0x00},   // 3d 1084 9bfb Ã¥Â»Â
    {0x40, 0x3e, 0x3a, 0x2e, 0x5f, 0x36, 0x5e, 0x00},   // 3d 1085 9bfc Ã¥Â»Â
    {0x40, 0x3e, 0x16, 0x4a, 0x57, 0x2a, 0x16, 0x00},   // 3e 1086 9c40 Ã¥Â»â€“
    {0x40, 0x3e, 0x4a, 0x3e, 0x3b, 0x3e, 0x4a, 0x00},   // 3e 1087 9c41 Ã¥Â»Â£
    {0x40, 0x3e, 0x5e, 0x16, 0x5f, 0x3a, 0x76, 0x00},   // 3e 1088 9c42 Ã¥Â»Â
    {0x40, 0x3e, 0x56, 0x6e, 0x37, 0x4a, 0x7e, 0x00},   // 3e 1089 9c43 Ã¥Â»Å¡
    {0x40, 0x3e, 0x5a, 0x5e, 0x6f, 0x5e, 0x5a, 0x00},   // 3e 108a 9c44 Ã¥Â»â€º
    {0x40, 0x3e, 0x56, 0x2e, 0x5f, 0x2a, 0x56, 0x00},   // 3e 108b 9c45 Ã¥Â»Â¢
    {0x40, 0x3e, 0x6e, 0x3a, 0x6b, 0x3a, 0x6a, 0x00},   // 3e 108c 9c46 Ã¥Â»Â¡
    {0x40, 0x7e, 0x36, 0x7e, 0x2b, 0x76, 0x2e, 0x00},   // 3e 108d 9c47 Ã¥Â»Â¨
    {0x40, 0x3e, 0x52, 0x3e, 0x7b, 0x3e, 0x52, 0x00},   // 3e 108e 9c48 Ã¥Â»Â©
    {0x40, 0x7e, 0x3a, 0x4a, 0x7f, 0x76, 0x52, 0x00},   // 3e 108f 9c49 Ã¥Â»Â¬
    {0x40, 0x3e, 0x6a, 0x76, 0x4b, 0x7e, 0x56, 0x00},   // 3e 1090 9c4a Ã¥Â»Â±
    {0x40, 0x3e, 0x36, 0x7e, 0x2b, 0x5e, 0x6a, 0x00},   // 3e 1091 9c4b Ã¥Â»Â³
    {0x40, 0x3e, 0x3e, 0x7e, 0x2b, 0x5e, 0x6a, 0x00},   // 3e 1092 9c4c Ã¥Â»Â°
    {0x51, 0x25, 0x5b, 0x40, 0x40, 0x40, 0x40, 0x00},   // 3e 1093 9c4d Ã¥Â»Â´
    {0x55, 0x3b, 0x40, 0x7e, 0x6a, 0x7f, 0x7e, 0x00},   // 3e 1094 9c4e Ã¥Â»Â¸
    {0x08, 0x48, 0x3f, 0x08, 0x08, 0x7f, 0x08, 0x00},   // 3e 1095 9c4f Ã¥Â»Â¾
    {0x12, 0x5a, 0x3e, 0x1b, 0x76, 0x1a, 0x12, 0x00},   // 3e 1096 9c50 Ã¥Â¼Æ’
    {0x1b, 0x56, 0x3f, 0x12, 0x7a, 0x1f, 0x1a, 0x00},   // 3e 1097 9c51 Ã¥Â¼â€°
    {0x2c, 0x74, 0x2e, 0x25, 0x77, 0x3d, 0x24, 0x00},   // 3e 1098 9c52 Ã¥Â½Â
    {0x2c, 0x74, 0x2e, 0x25, 0x77, 0x2d, 0x34, 0x00},   // 3e 1099 9c53 Ã¥Â½Å“
    {0x04, 0x04, 0x04, 0x1f, 0x24, 0x45, 0x64, 0x00},   // 3e 109a 9c54 Ã¥Â¼â€¹
    {0x54, 0x35, 0x7a, 0x55, 0x74, 0x3f, 0x45, 0x00},   // 3e 109b 9c55 Ã¥Â¼â€˜
    {0x40, 0x41, 0x5d, 0x55, 0x55, 0x77, 0x40, 0x00},   // 3e 109c 9c56 Ã¥Â¼â€“
    {0x0a, 0x3e, 0x3b, 0x36, 0x3b, 0x25, 0x6b, 0x00},   // 3e 109d 9c57 Ã¥Â¼Â©
    {0x5d, 0x77, 0x21, 0x3f, 0x2d, 0x7f, 0x21, 0x00},   // 3e 109e 9c58 Ã¥Â¼Â­
    {0x5d, 0x77, 0x3f, 0x55, 0x3f, 0x55, 0x7f, 0x00},   // 3e 109f 9c59 Ã¥Â¼Â¸
    {0x5d, 0x77, 0x09, 0x2d, 0x49, 0x7f, 0x09, 0x00},   // 3e 10a0 9c5a Ã¥Â½Â
    {0x5d, 0x77, 0x23, 0x3f, 0x7c, 0x3f, 0x23, 0x00},   // 3e 10a1 9c5b Ã¥Â½Ë†
    {0x5d, 0x77, 0x7d, 0x2b, 0x7f, 0x2b, 0x7d, 0x00},   // 3e 10a2 9c5c Ã¥Â½Å’
    {0x0a, 0x3d, 0x2a, 0x2f, 0x2f, 0x2a, 0x6d, 0x00},   // 3e 10a3 9c5d Ã¥Â½Å½
    {0x0a, 0x32, 0x2e, 0x33, 0x3e, 0x22, 0x6a, 0x00},   // 3e 10a4 9c5e Ã¥Â¼Â¯
    {0x40, 0x58, 0x57, 0x52, 0x72, 0x4e, 0x40, 0x00},   // 3e 10a5 9c5f Ã¥Â½â€˜
    {0x54, 0x54, 0x2e, 0x5d, 0x77, 0x25, 0x54, 0x00},   // 3e 10a6 9c60 Ã¥Â½â€“
    {0x2a, 0x6f, 0x6a, 0x68, 0x6a, 0x7f, 0x2a, 0x00},   // 3e 10a7 9c61 Ã¥Â½â€”
    {0x4c, 0x54, 0x3e, 0x7d, 0x3f, 0x55, 0x4c, 0x00},   // 3e 10a8 9c62 Ã¥Â½â„¢
    {0x00, 0x54, 0x54, 0x4a, 0x2a, 0x25, 0x10, 0x00},   // 3e 10a9 9c63 Ã¥Â½Â¡
    {0x42, 0x5a, 0x6f, 0x5a, 0x00, 0x4a, 0x25, 0x00},   // 3e 10aa 9c64 Ã¥Â½Â­
    {0x00, 0x00, 0x14, 0x14, 0x7a, 0x05, 0x00, 0x00},   // 3e 10ab 9c65 Ã¥Â½Â³
    {0x0a, 0x7d, 0x42, 0x3e, 0x0b, 0x4a, 0x7a, 0x00},   // 3e 10ac 9c66 Ã¥Â½Â·
    {0x0a, 0x7d, 0x44, 0x53, 0x7f, 0x52, 0x42, 0x00},   // 3e 10ad 9c67 Ã¥Â¾Æ’
    {0x0a, 0x7d, 0x40, 0x7f, 0x55, 0x7f, 0x40, 0x00},   // 3e 10ae 9c68 Ã¥Â¾â€š
    {0x0a, 0x7d, 0x5a, 0x3f, 0x16, 0x7f, 0x36, 0x00},   // 3e 10af 9c69 Ã¥Â½Â¿
    {0x0a, 0x7d, 0x7f, 0x5d, 0x55, 0x5d, 0x7f, 0x00},   // 3e 10b0 9c6a Ã¥Â¾Å 
    {0x0a, 0x7d, 0x00, 0x7f, 0x55, 0x35, 0x5f, 0x00},   // 3e 10b1 9c6b Ã¥Â¾Ë†
    {0x0a, 0x7d, 0x00, 0x55, 0x5b, 0x75, 0x5b, 0x00},   // 3e 10b2 9c6c Ã¥Â¾â€˜
    {0x0a, 0x7d, 0x04, 0x7f, 0x56, 0x7e, 0x7e, 0x00},   // 3e 10b3 9c6d Ã¥Â¾â€¡
    {0x0a, 0x7d, 0x44, 0x33, 0x44, 0x7b, 0x54, 0x00},   // 3e 10b4 9c6e Ã¥Â¾Å¾
    {0x0a, 0x7d, 0x48, 0x2e, 0x48, 0x7f, 0x5a, 0x00},   // 3e 10b5 9c6f Ã¥Â¾â„¢
    {0x0a, 0x7d, 0x2a, 0x7f, 0x00, 0x7f, 0x2a, 0x00},   // 3e 10b6 9c70 Ã¥Â¾Ëœ
    {0x0a, 0x7d, 0x4a, 0x26, 0x7f, 0x26, 0x4a, 0x00},   // 3e 10b7 9c71 Ã¥Â¾Â 
    {0x0a, 0x7d, 0x50, 0x5e, 0x7b, 0x5e, 0x50, 0x00},   // 3e 10b8 9c72 Ã¥Â¾Â¨
    {0x0a, 0x7d, 0x10, 0x6a, 0x4d, 0x7b, 0x68, 0x00},   // 3e 10b9 9c73 Ã¥Â¾Â­
    {0x0a, 0x7d, 0x26, 0x5f, 0x76, 0x3f, 0x5e, 0x00},   // 3e 10ba 9c74 Ã¥Â¾Â¼
    {0x06, 0x7f, 0x02, 0x0a, 0x52, 0x7f, 0x02, 0x00},   // 3e 10bb 9c75 Ã¥Â¿â€“
    {0x06, 0x7f, 0x40, 0x3e, 0x0a, 0x79, 0x08, 0x00},   // 3e 10bc 9c76 Ã¥Â¿Â»
    {0x06, 0x7f, 0x14, 0x13, 0x7e, 0x12, 0x10, 0x00},   // 3e 10bd 9c77 Ã¥Â¿Â¤
    {0x06, 0x7f, 0x49, 0x7f, 0x49, 0x7f, 0x48, 0x00},   // 3e 10be 9c78 Ã¥Â¿Â¸
    {0x06, 0x7f, 0x46, 0x22, 0x1f, 0x7a, 0x46, 0x00},   // 3e 10bf 9c79 Ã¥Â¿Â±
    {0x54, 0x16, 0x6e, 0x06, 0x4d, 0x15, 0x54, 0x00},   // 3e 10c0 9c7a Ã¥Â¿Â
    {0x60, 0x3a, 0x52, 0x5f, 0x7e, 0x12, 0x60, 0x00},   // 3e 10c1 9c7b Ã¦â€šÂ³
    {0x64, 0x32, 0x55, 0x4c, 0x75, 0x1e, 0x64, 0x00},   // 3e 10c2 9c7c Ã¥Â¿Â¿
    {0x06, 0x7f, 0x08, 0x6c, 0x6b, 0x64, 0x08, 0x00},   // 3e 10c3 9c7d Ã¦â‚¬Â¡
    {0x06, 0x7f, 0x0a, 0x7e, 0x53, 0x7a, 0x52, 0x00},   // 3e 10c4 9c7e Ã¦ÂÂ 
    {0x06, 0x7f, 0x04, 0x74, 0x5f, 0x74, 0x04, 0x00},   // 3f 10c5 9c80 Ã¦â‚¬â„¢
    {0x06, 0x7f, 0x04, 0x1b, 0x1a, 0x42, 0x7e, 0x00},   // 3f 10c6 9c81 Ã¦â‚¬Â
    {0x06, 0x7f, 0x40, 0x3f, 0x05, 0x7d, 0x57, 0x00},   // 3f 10c7 9c82 Ã¦â‚¬Â©
    {0x64, 0x34, 0x43, 0x5e, 0x6a, 0x0a, 0x6a, 0x00},   // 3f 10c8 9c83 Ã¦â‚¬Å½
    {0x64, 0x2b, 0x4e, 0x5a, 0x6e, 0x12, 0x6e, 0x00},   // 3f 10c9 9c84 Ã¦â‚¬Â±
    {0x06, 0x7f, 0x40, 0x5f, 0x55, 0x5f, 0x40, 0x00},   // 3f 10ca 9c85 Ã¦â‚¬â€º
    {0x06, 0x7f, 0x02, 0x7e, 0x4b, 0x4a, 0x7e, 0x00},   // 3f 10cb 9c86 Ã¦â‚¬â€¢
    {0x06, 0x7f, 0x5a, 0x3f, 0x16, 0x7f, 0x36, 0x00},   // 3f 10cc 9c87 Ã¦â‚¬Â«
    {0x06, 0x7f, 0x15, 0x13, 0x7f, 0x13, 0x15, 0x00},   // 3f 10cd 9c88 Ã¦â‚¬Â¦
    {0x06, 0x7f, 0x48, 0x4e, 0x3b, 0x4e, 0x48, 0x00},   // 3f 10ce 9c89 Ã¦â‚¬Â
    {0x06, 0x7f, 0x28, 0x5d, 0x7d, 0x10, 0x28, 0x00},   // 3f 10cf 9c8a Ã¦â‚¬Âº
    {0x54, 0x36, 0x56, 0x5f, 0x76, 0x16, 0x54, 0x00},   // 3f 10d0 9c8b Ã¦ÂÅ¡
    {0x64, 0x3e, 0x45, 0x56, 0x5e, 0x15, 0x44, 0x00},   // 3f 10d1 9c8c Ã¦ÂÂ
    {0x06, 0x7f, 0x10, 0x6a, 0x65, 0x6b, 0x10, 0x00},   // 3f 10d2 9c8d Ã¦ÂÂª
    {0x64, 0x3e, 0x53, 0x4a, 0x5f, 0x0a, 0x52, 0x00},   // 3f 10d3 9c8e Ã¦ÂÂ·
    {0x06, 0x7f, 0x04, 0x37, 0x2a, 0x36, 0x7e, 0x00},   // 3f 10d4 9c8f Ã¦ÂÅ¸
    {0x06, 0x7f, 0x20, 0x62, 0x37, 0x62, 0x76, 0x00},   // 3f 10d5 9c90 Ã¦ÂÅ 
    {0x06, 0x7f, 0x51, 0x4f, 0x75, 0x5d, 0x41, 0x00},   // 3f 10d6 9c91 Ã¦Ââ€ 
    {0x06, 0x7f, 0x4a, 0x3c, 0x0f, 0x7c, 0x4a, 0x00},   // 3f 10d7 9c92 Ã¦ÂÂ
    {0x69, 0x20, 0x44, 0x4b, 0x66, 0x0a, 0x66, 0x00},   // 3f 10d8 9c93 Ã¦ÂÂ£
    {0x06, 0x7f, 0x28, 0x6a, 0x2f, 0x7a, 0x28, 0x00},   // 3f 10d9 9c94 Ã¦ÂÆ’
    {0x06, 0x7f, 0x40, 0x7e, 0x43, 0x7e, 0x7e, 0x00},   // 3f 10da 9c95 Ã¦ÂÂ¤
    {0x06, 0x7f, 0x04, 0x7f, 0x56, 0x7e, 0x7e, 0x00},   // 3f 10db 9c96 Ã¦Ââ€š
    {0x06, 0x7f, 0x04, 0x76, 0x5e, 0x75, 0x04, 0x00},   // 3f 10dc 9c97 Ã¦ÂÂ¬
    {0x06, 0x7f, 0x02, 0x7f, 0x35, 0x35, 0x7f, 0x00},   // 3f 10dd 9c98 Ã¦ÂÂ«
    {0x6a, 0x3a, 0x4b, 0x5e, 0x6a, 0x1b, 0x6a, 0x00},   // 3f 10de 9c99 Ã¦Ââ„¢
    {0x06, 0x7f, 0x02, 0x78, 0x2b, 0x2b, 0x78, 0x00},   // 3f 10df 9c9a Ã¦â€šÂ
    {0x06, 0x7f, 0x28, 0x2f, 0x7d, 0x2f, 0x28, 0x00},   // 3f 10e0 9c9b Ã¦â€šÂ
    {0x06, 0x7f, 0x50, 0x1f, 0x15, 0x1f, 0x50, 0x00},   // 3f 10e1 9c9c Ã¦Æ’Â§
    {0x06, 0x7f, 0x7f, 0x55, 0x7f, 0x55, 0x7f, 0x00},   // 3f 10e2 9c9d Ã¦â€šÆ’
    {0x06, 0x7f, 0x42, 0x2e, 0x7f, 0x2a, 0x4e, 0x00},   // 3f 10e3 9c9e Ã¦â€šÅ¡
    {0x06, 0x7f, 0x02, 0x7d, 0x2a, 0x7d, 0x02, 0x00},   // 3f 10e4 9c9f Ã¦â€šâ€ž
    {0x06, 0x7f, 0x2a, 0x57, 0x32, 0x5e, 0x4b, 0x00},   // 3f 10e5 9ca0 Ã¦â€šâ€º
    {0x06, 0x7f, 0x2c, 0x26, 0x6f, 0x3e, 0x2c, 0x00},   // 3f 10e6 9ca1 Ã¦â€šâ€“
    {0x06, 0x7f, 0x5c, 0x36, 0x1d, 0x77, 0x5c, 0x00},   // 3f 10e7 9ca2 Ã¦â€šâ€”
    {0x06, 0x7f, 0x3c, 0x57, 0x5d, 0x57, 0x5c, 0x00},   // 3f 10e8 9ca3 Ã¦â€šâ€™
    {0x06, 0x7f, 0x35, 0x7f, 0x15, 0x4e, 0x7f, 0x00},   // 3f 10e9 9ca4 Ã¦â€šÂ§
    {0x06, 0x7f, 0x12, 0x76, 0x6b, 0x76, 0x12, 0x00},   // 3f 10ea 9ca5 Ã¦â€šâ€¹
    {0x69, 0x3f, 0x4b, 0x59, 0x6b, 0x1f, 0x69, 0x00},   // 3f 10eb 9ca6 Ã¦Æ’Â¡
    {0x06, 0x7f, 0x2a, 0x27, 0x6f, 0x37, 0x2a, 0x00},   // 3f 10ec 9ca7 Ã¦â€šÂ¸
    {0x62, 0x3e, 0x5a, 0x5f, 0x6a, 0x1e, 0x62, 0x00},   // 3f 10ed 9ca8 Ã¦Æ’Â 
    {0x06, 0x7f, 0x16, 0x6d, 0x56, 0x4d, 0x16, 0x00},   // 3f 10ee 9ca9 Ã¦Æ’â€œ
    {0x06, 0x7f, 0x32, 0x2e, 0x73, 0x2e, 0x32, 0x00},   // 3f 10ef 9caa Ã¦â€šÂ´
    {0x06, 0x7f, 0x2a, 0x26, 0x73, 0x2e, 0x28, 0x00},   // 3f 10f0 9cab Ã¥Â¿Â°
    {0x06, 0x7f, 0x52, 0x7a, 0x5f, 0x3e, 0x52, 0x00},   // 3f 10f1 9cac Ã¦â€šÂ½
    {0x06, 0x7f, 0x7f, 0x35, 0x2f, 0x35, 0x7f, 0x00},   // 3f 10f2 9cad Ã¦Æ’â€ 
    {0x06, 0x7f, 0x10, 0x7f, 0x55, 0x35, 0x51, 0x00},   // 3f 10f3 9cae Ã¦â€šÂµ
    {0x06, 0x7f, 0x7f, 0x0d, 0x39, 0x2d, 0x7f, 0x00},   // 3f 10f4 9caf Ã¦Æ’Ëœ
    {0x06, 0x7f, 0x02, 0x4f, 0x6d, 0x6b, 0x4f, 0x00},   // 3f 10f5 9cb0 Ã¦â€¦Â
    {0x06, 0x7f, 0x0b, 0x3f, 0x2c, 0x2f, 0x6b, 0x00},   // 3f 10f6 9cb1 Ã¦â€žâ€¢
    {0x6a, 0x3d, 0x40, 0x55, 0x60, 0x15, 0x5d, 0x00},   // 3f 10f7 9cb2 Ã¦â€žâ€ 
    {0x06, 0x7f, 0x50, 0x5e, 0x7b, 0x5e, 0x50, 0x00},   // 3f 10f8 9cb3 Ã¦Æ’Â¶
    {0x6a, 0x2a, 0x47, 0x5b, 0x7b, 0x06, 0x6a, 0x00},   // 3f 10f9 9cb4 Ã¦Æ’Â·
    {0x06, 0x7f, 0x35, 0x7f, 0x4c, 0x3f, 0x44, 0x00},   // 3f 10fa 9cb5 Ã¦â€žâ‚¬
    {0x06, 0x7f, 0x6b, 0x3a, 0x6b, 0x2a, 0x6b, 0x00},   // 3f 10fb 9cb6 Ã¦Æ’Â´
    {0x06, 0x7f, 0x48, 0x57, 0x7d, 0x57, 0x44, 0x00},   // 3f 10fc 9cb7 Ã¦Æ’Âº
    {0x06, 0x7f, 0x46, 0x6a, 0x6b, 0x6a, 0x46, 0x00},   // 3f 10fd 9cb8 Ã¦â€žÆ’
    {0x06, 0x7f, 0x64, 0x2b, 0x4e, 0x52, 0x6e, 0x00},   // 3f 10fe 9cb9 Ã¦â€žÂ¡
    {0x06, 0x7f, 0x5f, 0x15, 0x5f, 0x0e, 0x7f, 0x00},   // 3f 10ff 9cba Ã¦Æ’Â»
    {0x06, 0x7f, 0x00, 0x7a, 0x6d, 0x5a, 0x7d, 0x00},   // 3f 1100 9cbb Ã¦Æ’Â±
    {0x6f, 0x2b, 0x47, 0x4b, 0x6a, 0x05, 0x6b, 0x00},   // 3f 1101 9cbc Ã¦â€žÂ
    {0x06, 0x7f, 0x44, 0x53, 0x2e, 0x5e, 0x42, 0x00},   // 3f 1102 9cbd Ã¦â€žÅ½
    {0x6e, 0x26, 0x4d, 0x40, 0x6b, 0x05, 0x6b, 0x00},   // 3f 1103 9cbe Ã¦â€¦â€¡
    {0x06, 0x7f, 0x5b, 0x2e, 0x7e, 0x2e, 0x7a, 0x00},   // 3f 1104 9cbf Ã¦â€žÂ¾
    {0x62, 0x2e, 0x47, 0x4e, 0x6b, 0x05, 0x6b, 0x00},   // 3f 1105 9cc0 Ã¦â€žÂ¨
    {0x06, 0x7f, 0x5e, 0x2a, 0x7f, 0x6a, 0x5e, 0x00},   // 3f 1106 9cc1 Ã¦â€žÂ§
    {0x06, 0x7f, 0x4a, 0x2b, 0x7e, 0x3f, 0x5a, 0x00},   // 3f 1107 9cc2 Ã¦â€¦Å 
    {0x50, 0x2f, 0x49, 0x57, 0x7f, 0x07, 0x69, 0x00},   // 3f 1108 9cc3 Ã¦â€žÂ¿
    {0x06, 0x7f, 0x58, 0x13, 0x1e, 0x1e, 0x52, 0x00},   // 3f 1109 9cc4 Ã¦â€žÂ¼
    {0x57, 0x2e, 0x47, 0x48, 0x67, 0x05, 0x6f, 0x00},   // 3f 110a 9cc5 Ã¦â€žÂ¬
    {0x06, 0x7f, 0x24, 0x1e, 0x6d, 0x62, 0x04, 0x00},   // 3f 110b 9cc6 Ã¦â€žÂ´
    {0x06, 0x7f, 0x12, 0x3e, 0x57, 0x7e, 0x13, 0x00},   // 3f 110c 9cc7 Ã¦â€žÂ½
    {0x55, 0x20, 0x5d, 0x4d, 0x5d, 0x0f, 0x5d, 0x00},   // 3f 110d 9cc8 Ã¦â€¦â€š
    {0x06, 0x7f, 0x51, 0x37, 0x7f, 0x37, 0x51, 0x00},   // 3f 110e 9cc9 Ã¦â€¦â€ž
    {0x06, 0x7f, 0x47, 0x57, 0x7b, 0x55, 0x4b, 0x00},   // 3f 110f 9cca Ã¦â€¦Â³
    {0x06, 0x7f, 0x3e, 0x52, 0x7f, 0x2e, 0x56, 0x00},   // 3f 1110 9ccb Ã¦â€¦Â·
    {0x06, 0x7f, 0x1a, 0x4f, 0x5a, 0x2d, 0x1a, 0x00},   // 3f 1111 9ccc Ã¦â€¦Ëœ
    {0x6a, 0x2e, 0x5f, 0x4a, 0x67, 0x1d, 0x45, 0x00},   // 3f 1112 9ccd Ã¦â€¦â„¢
    {0x06, 0x7f, 0x2d, 0x7f, 0x3e, 0x0a, 0x79, 0x00},   // 3f 1113 9cce Ã¦â€¦Å¡
    {0x6a, 0x3d, 0x52, 0x4d, 0x5e, 0x15, 0x52, 0x00},   // 3f 1114 9ccf Ã¦â€¦Â«
    {0x06, 0x7f, 0x09, 0x65, 0x6f, 0x75, 0x6f, 0x00},   // 3f 1115 9cd0 Ã¦â€¦Â´
    {0x06, 0x7f, 0x24, 0x5f, 0x3a, 0x5e, 0x72, 0x00},   // 3f 1116 9cd1 Ã¦â€¦Â¯
    {0x06, 0x7f, 0x75, 0x48, 0x7b, 0x6f, 0x7a, 0x00},   // 3f 1117 9cd2 Ã¦â€¦Â¥
    {0x06, 0x7f, 0x12, 0x3e, 0x5f, 0x76, 0x1a, 0x00},   // 3f 1118 9cd3 Ã¦â€¦Â±
    {0x06, 0x7f, 0x2d, 0x3f, 0x62, 0x1f, 0x7e, 0x00},   // 3f 1119 9cd4 Ã¦â€¦Å¸
    {0x5f, 0x35, 0x5f, 0x5d, 0x77, 0x1d, 0x55, 0x00},   // 3f 111a 9cd5 Ã¦â€¦Â
    {0x06, 0x7f, 0x51, 0x17, 0x77, 0x17, 0x51, 0x00},   // 3f 111b 9cd6 Ã¦â€¦â€œ
    {0x06, 0x7f, 0x3e, 0x7a, 0x2e, 0x7f, 0x7a, 0x00},   // 3f 111c 9cd7 Ã¦â€¦Âµ
    {0x6a, 0x3a, 0x5e, 0x5f, 0x7e, 0x1a, 0x6a, 0x00},   // 3f 111d 9cd8 Ã¦â€ â„¢
    {0x52, 0x2e, 0x5f, 0x4e, 0x52, 0x0f, 0x52, 0x00},   // 3f 111e 9cd9 Ã¦â€ â€“
    {0x66, 0x2e, 0x4d, 0x42, 0x6f, 0x0a, 0x6f, 0x00},   // 3f 111f 9cda Ã¦â€ â€¡
    {0x06, 0x7f, 0x44, 0x1f, 0x75, 0x1f, 0x44, 0x00},   // 3f 1120 9cdb Ã¦â€ Â¬
    {0x06, 0x7f, 0x44, 0x1f, 0x52, 0x1f, 0x52, 0x00},   // 3f 1121 9cdc Ã¦â€ â€
    {0x06, 0x7f, 0x23, 0x3f, 0x7c, 0x3f, 0x23, 0x00},   // 3f 1122 9cdd Ã¦â€ Å¡
    {0x64, 0x3f, 0x4a, 0x5f, 0x6a, 0x1f, 0x5a, 0x00},   // 3f 1123 9cde Ã¦â€ Å 
    {0x69, 0x20, 0x57, 0x45, 0x57, 0x05, 0x5d, 0x00},   // 3f 1124 9cdf Ã¦â€ â€˜
    {0x06, 0x7f, 0x7f, 0x5b, 0x2c, 0x5b, 0x7f, 0x00},   // 3f 1125 9ce0 Ã¦â€ Â«
    {0x06, 0x7f, 0x6b, 0x3e, 0x6a, 0x3e, 0x6a, 0x00},   // 3f 1126 9ce1 Ã¦â€ Â®
    {0x06, 0x7f, 0x2b, 0x3b, 0x6f, 0x3b, 0x2b, 0x00},   // 3f 1127 9ce2 Ã¦â€¡Å’
    {0x06, 0x7f, 0x50, 0x5e, 0x3f, 0x56, 0x5e, 0x00},   // 3f 1128 9ce3 Ã¦â€¡Å 
    {0x40, 0x3e, 0x5a, 0x26, 0x5b, 0x5e, 0x76, 0x00},   // 3f 1129 9ce4 Ã¦â€¡â€°
    {0x06, 0x7f, 0x2a, 0x6e, 0x5f, 0x2a, 0x4e, 0x00},   // 3f 112a 9ce5 Ã¦â€¡Â·
    {0x06, 0x7f, 0x42, 0x3d, 0x7f, 0x31, 0x7b, 0x00},   // 3f 112b 9ce6 Ã¦â€¡Ë†
    {0x52, 0x37, 0x5e, 0x57, 0x6a, 0x07, 0x6e, 0x00},   // 3f 112c 9ce7 Ã¦â€¡Æ’
    {0x06, 0x7f, 0x5c, 0x37, 0x7d, 0x37, 0x5c, 0x00},   // 3f 112d 9ce8 Ã¦â€¡â€ 
    {0x06, 0x7f, 0x3c, 0x2e, 0x75, 0x7f, 0x2c, 0x00},   // 3f 112e 9ce9 Ã¦â€ Âº
    {0x6a, 0x3f, 0x49, 0x5d, 0x6b, 0x1f, 0x6a, 0x00},   // 3f 112f 9cea Ã¦â€¡â€¹
    {0x37, 0x7d, 0x07, 0x7d, 0x57, 0x7d, 0x57, 0x00},   // 3f 1130 9ceb Ã§Â½Â¹
    {0x06, 0x7f, 0x52, 0x3e, 0x7b, 0x3e, 0x52, 0x00},   // 3f 1131 9cec Ã¦â€¡Â
    {0x06, 0x7f, 0x66, 0x2b, 0x7f, 0x2b, 0x66, 0x00},   // 3f 1132 9ced Ã¦â€¡Â¦
    {0x55, 0x20, 0x5a, 0x4f, 0x5a, 0x0f, 0x5a, 0x00},   // 3f 1133 9cee Ã¦â€¡Â£
    {0x06, 0x7f, 0x2e, 0x7f, 0x5a, 0x19, 0x5b, 0x00},   // 3f 1134 9cef Ã¦â€¡Â¶
    {0x06, 0x7f, 0x55, 0x7e, 0x55, 0x3f, 0x55, 0x00},   // 3f 1135 9cf0 Ã¦â€¡Âº
    {0x06, 0x7f, 0x54, 0x7f, 0x54, 0x3f, 0x55, 0x00},   // 3f 1136 9cf1 Ã¦â€¡Â´
    {0x5a, 0x77, 0x5a, 0x65, 0x2b, 0x46, 0x6a, 0x00},   // 3f 1137 9cf2 Ã¦â€¡Â¿
    {0x06, 0x7f, 0x26, 0x7f, 0x52, 0x7f, 0x56, 0x00},   // 3f 1138 9cf3 Ã¦â€¡Â½
    {0x06, 0x7f, 0x23, 0x7b, 0x50, 0x7b, 0x53, 0x00},   // 3f 1139 9cf4 Ã¦â€¡Â¼
    {0x06, 0x7f, 0x30, 0x75, 0x27, 0x3f, 0x75, 0x00},   // 3f 113a 9cf5 Ã¦â€¡Â¾
    {0x6a, 0x3d, 0x4a, 0x57, 0x57, 0x0a, 0x5d, 0x00},   // 3f 113b 9cf6 Ã¦Ë†â‚¬
    {0x02, 0x42, 0x42, 0x2f, 0x32, 0x4b, 0x62, 0x00},   // 3f 113c 9cf7 Ã¦Ë†Ë†
    {0x20, 0x3e, 0x12, 0x42, 0x5f, 0x22, 0x53, 0x00},   // 3f 113d 9cf8 Ã¦Ë†â€°
    {0x40, 0x3e, 0x0a, 0x52, 0x5f, 0x22, 0x53, 0x00},   // 3f 113e 9cf9 Ã¦Ë†Â
    {0x40, 0x3e, 0x0a, 0x4a, 0x5f, 0x22, 0x53, 0x00},   // 3f 113f 9cfa Ã¦Ë†Å’
    {0x12, 0x5a, 0x5a, 0x37, 0x36, 0x5b, 0x6c, 0x00},   // 3f 1140 9cfb Ã¦Ë†â€
    {0x11, 0x51, 0x5f, 0x3b, 0x3b, 0x5f, 0x69, 0x00},   // 3f 1141 9cfc Ã¦Ë†â€º  
    {0x19, 0x49, 0x5f, 0x3b, 0x3b, 0x4f, 0x59, 0x00},   // 40 1142 9d40 Ã¦Ë†Å¾
    {0x72, 0x5f, 0x72, 0x5f, 0x44, 0x3f, 0x55, 0x00},   // 40 1143 9d41 Ã¦Ë†Â¡
    {0x24, 0x76, 0x5f, 0x76, 0x5f, 0x24, 0x55, 0x00},   // 40 1144 9d42 Ã¦Ë†Âª
    {0x11, 0x4b, 0x55, 0x2b, 0x44, 0x3f, 0x55, 0x00},   // 40 1145 9d43 Ã¦Ë†Â®
    {0x23, 0x3f, 0x7c, 0x3f, 0x23, 0x3f, 0x55, 0x00},   // 40 1146 9d44 Ã¦Ë†Â°
    {0x7c, 0x5c, 0x6f, 0x5a, 0x44, 0x3f, 0x55, 0x00},   // 40 1147 9d45 Ã¦Ë†Â²
    {0x21, 0x7b, 0x71, 0x5b, 0x44, 0x3f, 0x55, 0x00},   // 40 1148 9d46 Ã¦Ë†Â³
    {0x41, 0x3f, 0x75, 0x35, 0x75, 0x37, 0x71, 0x00},   // 40 1149 9d47 Ã¦â€°Â
    {0x52, 0x7f, 0x0a, 0x00, 0x7f, 0x40, 0x60, 0x00},   // 40 114a 9d48 Ã¦â€°Å½
    {0x52, 0x7f, 0x08, 0x09, 0x7f, 0x09, 0x08, 0x00},   // 40 114b 9d49 Ã¦â€°Å¾
    {0x52, 0x7f, 0x0a, 0x7e, 0x42, 0x42, 0x7e, 0x00},   // 40 114c 9d4a Ã¦â€°Â£
    {0x52, 0x7f, 0x40, 0x42, 0x7e, 0x42, 0x40, 0x00},   // 40 114d 9d4b Ã¦â€°â€º
    {0x52, 0x7f, 0x47, 0x29, 0x13, 0x29, 0x47, 0x00},   // 40 114e 9d4c Ã¦â€°Â 
    {0x52, 0x7f, 0x0a, 0x45, 0x3f, 0x51, 0x7f, 0x00},   // 40 114f 9d4d Ã¦â€°Â¨
    {0x52, 0x7f, 0x4a, 0x3f, 0x7d, 0x45, 0x5d, 0x00},   // 40 1150 9d4e Ã¦â€°Â¼
    {0x52, 0x7f, 0x41, 0x49, 0x7f, 0x49, 0x41, 0x00},   // 40 1151 9d4f Ã¦Å â€š
    {0x52, 0x7f, 0x48, 0x4a, 0x3f, 0x4e, 0x48, 0x00},   // 40 1152 9d50 Ã¦Å â€°
    {0x52, 0x7f, 0x0a, 0x44, 0x5f, 0x24, 0x55, 0x00},   // 40 1153 9d51 Ã¦â€°Â¾
    {0x52, 0x7f, 0x09, 0x4b, 0x7d, 0x0b, 0x18, 0x00},   // 40 1154 9d52 Ã¦Å â€™
    {0x52, 0x7f, 0x3e, 0x02, 0x7e, 0x3d, 0x40, 0x00},   // 40 1155 9d53 Ã¦Å â€œ
    {0x52, 0x7f, 0x20, 0x2a, 0x20, 0x7f, 0x10, 0x00},   // 40 1156 9d54 Ã¦Å â€“
    {0x52, 0x7f, 0x4a, 0x22, 0x5f, 0x22, 0x5b, 0x00},   // 40 1157 9d55 Ã¦â€¹â€
    {0x52, 0x7f, 0x02, 0x02, 0x7f, 0x0a, 0x12, 0x00},   // 40 1158 9d56 Ã¦Å Æ’
    {0x52, 0x7f, 0x11, 0x09, 0x7f, 0x09, 0x11, 0x00},   // 40 1159 9d57 Ã¦Å â€
    {0x52, 0x7f, 0x74, 0x4b, 0x62, 0x1f, 0x7e, 0x00},   // 40 115a 9d58 Ã¦â€¹â€”
    {0x52, 0x7f, 0x02, 0x7f, 0x4a, 0x7f, 0x02, 0x00},   // 40 115b 9d59 Ã¦â€¹â€˜
    {0x52, 0x7f, 0x3e, 0x2a, 0x7f, 0x2a, 0x3e, 0x00},   // 40 115c 9d5a Ã¦Å Â»
    {0x2a, 0x3e, 0x7b, 0x76, 0x3b, 0x35, 0x2b, 0x00},   // 40 115d 9d5b Ã¦â€¹Â
    {0x24, 0x34, 0x7e, 0x7d, 0x3e, 0x34, 0x24, 0x00},   // 40 115e 9d5c Ã¦â€¹Â¿
    {0x52, 0x7f, 0x40, 0x3e, 0x1a, 0x79, 0x28, 0x00},   // 40 115f 9d5d Ã¦â€¹â€ 
    {0x52, 0x7f, 0x3c, 0x2e, 0x75, 0x7f, 0x2c, 0x00},   // 40 1160 9d5e Ã¦â€œâ€
    {0x52, 0x7f, 0x0a, 0x70, 0x5f, 0x54, 0x74, 0x00},   // 40 1161 9d5f Ã¦â€¹Ë†
    {0x56, 0x3e, 0x15, 0x21, 0x2b, 0x7f, 0x2b, 0x00},   // 40 1162 9d60 Ã¦â€¹Å“
    {0x52, 0x7f, 0x2a, 0x29, 0x7c, 0x29, 0x2a, 0x00},   // 40 1163 9d61 Ã¦â€¹Å’
    {0x52, 0x7f, 0x04, 0x7e, 0x09, 0x42, 0x7f, 0x00},   // 40 1164 9d62 Ã¦â€¹Å 
    {0x52, 0x7f, 0x5a, 0x3f, 0x16, 0x7f, 0x36, 0x00},   // 40 1165 9d63 Ã¦â€¹â€š
    {0x52, 0x7f, 0x38, 0x2f, 0x69, 0x7f, 0x28, 0x00},   // 40 1166 9d64 Ã¦â€¹â€¡
    {0x52, 0x7f, 0x42, 0x3f, 0x52, 0x4f, 0x5e, 0x00},   // 40 1167 9d65 Ã¦Å â€º
    {0x52, 0x7f, 0x42, 0x7e, 0x63, 0x5e, 0x42, 0x00},   // 40 1168 9d66 Ã¦â€¹â€°
    {0x52, 0x7f, 0x10, 0x6a, 0x65, 0x6b, 0x10, 0x00},   // 40 1169 9d67 Ã¦Å’Å’
    {0x52, 0x7f, 0x02, 0x6a, 0x6f, 0x6a, 0x02, 0x00},   // 40 116a 9d68 Ã¦â€¹Â®
    {0x52, 0x7f, 0x52, 0x1f, 0x12, 0x1f, 0x52, 0x00},   // 40 116b 9d69 Ã¦â€¹Â±
    {0x52, 0x7f, 0x29, 0x15, 0x7f, 0x15, 0x7f, 0x00},   // 40 116c 9d6a Ã¦Å’Â§
    {0x52, 0x7f, 0x48, 0x5a, 0x7f, 0x5a, 0x48, 0x00},   // 40 116d 9d6b Ã¦Å’â€š
    {0x2a, 0x3f, 0x76, 0x70, 0x39, 0x37, 0x2f, 0x00},   // 40 116e 9d6c Ã¦Å’Ë†
    {0x52, 0x7f, 0x54, 0x4d, 0x7d, 0x4b, 0x54, 0x00},   // 40 116f 9d6d Ã¦â€¹Â¯
    {0x52, 0x7f, 0x0a, 0x7e, 0x23, 0x76, 0x2e, 0x00},   // 40 1170 9d6e Ã¦â€¹Âµ
    {0x52, 0x7f, 0x0a, 0x78, 0x2b, 0x2b, 0x78, 0x00},   // 40 1171 9d6f Ã¦ÂÂ
    {0x52, 0x7f, 0x52, 0x4e, 0x3f, 0x4e, 0x52, 0x00},   // 40 1172 9d70 Ã¦Å’Â¾
    {0x52, 0x7f, 0x28, 0x2f, 0x7d, 0x2f, 0x28, 0x00},   // 40 1173 9d71 Ã¦ÂÂ
    {0x52, 0x7f, 0x4e, 0x59, 0x2e, 0x59, 0x4f, 0x00},   // 40 1174 9d72 Ã¦ÂÅ“
    {0x52, 0x7f, 0x47, 0x55, 0x7d, 0x55, 0x47, 0x00},   // 40 1175 9d73 Ã¦ÂÂ
    {0x52, 0x7f, 0x0a, 0x7e, 0x53, 0x2a, 0x5a, 0x00},   // 40 1176 9d74 Ã¦Å½â€“
    {0x52, 0x7f, 0x12, 0x5a, 0x17, 0x7a, 0x12, 0x00},   // 40 1177 9d75 Ã¦Å½Å½
    {0x52, 0x7f, 0x1e, 0x7d, 0x44, 0x3b, 0x46, 0x00},   // 40 1178 9d76 Ã¦Å½â‚¬
    {0x52, 0x7f, 0x21, 0x3f, 0x7f, 0x12, 0x2e, 0x00},   // 40 1179 9d77 Ã¦Å½Â«
    {0x52, 0x7f, 0x54, 0x5d, 0x77, 0x5d, 0x54, 0x00},   // 40 117a 9d78 Ã¦ÂÂ¶
    {0x24, 0x3b, 0x7f, 0x7a, 0x36, 0x30, 0x2f, 0x00},   // 40 117b 9d79 Ã¦Å½Â£
    {0x52, 0x7f, 0x64, 0x4b, 0x7e, 0x6a, 0x7e, 0x00},   // 40 117c 9d7a Ã¦Å½Â
    {0x52, 0x7f, 0x2a, 0x3c, 0x77, 0x3e, 0x22, 0x00},   // 40 117d 9d7b Ã¦Å½â€°
    {0x52, 0x7f, 0x46, 0x32, 0x47, 0x7e, 0x56, 0x00},   // 40 117e 9d7c Ã¦Å½Å¸
    {0x52, 0x7f, 0x34, 0x32, 0x05, 0x76, 0x34, 0x00},   // 40 117f 9d7d Ã¦Å½Âµ
    {0x52, 0x7f, 0x7f, 0x07, 0x00, 0x47, 0x7f, 0x00},   // 40 1180 9d7e Ã¦ÂÂ«
    {0x52, 0x7f, 0x21, 0x5f, 0x55, 0x3d, 0x57, 0x00},   // 41 1181 9d80 Ã¦ÂÂ©
    {0x52, 0x7f, 0x2c, 0x56, 0x7d, 0x27, 0x55, 0x00},   // 41 1182 9d81 Ã¦Å½Â¾
    {0x52, 0x7f, 0x0f, 0x6a, 0x70, 0x6f, 0x0a, 0x00},   // 41 1183 9d82 Ã¦ÂÂ©
    {0x52, 0x7f, 0x42, 0x2e, 0x7f, 0x2e, 0x4e, 0x00},   // 41 1184 9d83 Ã¦Ââ‚¬
    {0x52, 0x7f, 0x55, 0x5b, 0x39, 0x5a, 0x55, 0x00},   // 41 1185 9d84 Ã¦Ââ€ 
    {0x52, 0x7f, 0x6b, 0x3a, 0x6b, 0x2a, 0x6b, 0x00},   // 41 1186 9d85 Ã¦ÂÂ£
    {0x52, 0x7f, 0x5a, 0x37, 0x7f, 0x33, 0x56, 0x00},   // 41 1187 9d86 Ã¦Ââ€°
    {0x52, 0x7f, 0x74, 0x56, 0x7e, 0x55, 0x75, 0x00},   // 41 1188 9d87 Ã¦Ââ€™
    {0x52, 0x7f, 0x21, 0x3f, 0x2d, 0x7f, 0x1b, 0x00},   // 41 1189 9d88 Ã¦ÂÂ¶
    {0x52, 0x7f, 0x05, 0x73, 0x75, 0x26, 0x54, 0x00},   // 41 118a 9d89 Ã¦Ââ€ž
    {0x52, 0x7f, 0x10, 0x6a, 0x4d, 0x7b, 0x68, 0x00},   // 41 118b 9d8a Ã¦Ââ€“
    {0x16, 0x2a, 0x7e, 0x7b, 0x3e, 0x2a, 0x16, 0x00},   // 41 118c 9d8b Ã¦ÂÂ´
    {0x52, 0x7f, 0x2a, 0x7f, 0x3a, 0x7f, 0x2a, 0x00},   // 41 118d 9d8c Ã¦Ââ€ 
    {0x52, 0x7f, 0x4a, 0x3b, 0x5e, 0x7b, 0x5a, 0x00},   // 41 118e 9d8d Ã¦Ââ€œ
    {0x52, 0x7f, 0x0a, 0x5d, 0x77, 0x5d, 0x77, 0x00},   // 41 118f 9d8e Ã¦ÂÂ¦
    {0x52, 0x7f, 0x24, 0x1e, 0x6d, 0x62, 0x04, 0x00},   // 41 1190 9d8f Ã¦ÂÂ¶
    {0x52, 0x7f, 0x32, 0x75, 0x27, 0x3f, 0x75, 0x00},   // 41 1191 9d90 Ã¦â€Â
    {0x52, 0x7f, 0x0a, 0x5e, 0x77, 0x56, 0x70, 0x00},   // 41 1192 9d91 Ã¦Ââ€”
    {0x52, 0x7f, 0x48, 0x2f, 0x7d, 0x2f, 0x78, 0x00},   // 41 1193 9d92 Ã¦ÂÂ¨
    {0x52, 0x7f, 0x12, 0x3e, 0x57, 0x7e, 0x13, 0x00},   // 41 1194 9d93 Ã¦ÂÂ
    {0x52, 0x7f, 0x13, 0x7e, 0x4b, 0x7e, 0x4b, 0x00},   // 41 1195 9d94 Ã¦â€˜Â§
    {0x24, 0x2e, 0x7f, 0x7a, 0x37, 0x3e, 0x28, 0x00},   // 41 1196 9d95 Ã¦â€˜Â¯
    {0x52, 0x7f, 0x12, 0x3e, 0x5f, 0x76, 0x1a, 0x00},   // 41 1197 9d96 Ã¦â€˜Â¶
    {0x52, 0x7f, 0x11, 0x4b, 0x54, 0x29, 0x13, 0x00},   // 41 1198 9d97 Ã¦â€˜Å½
    {0x52, 0x7f, 0x4e, 0x35, 0x36, 0x75, 0x4f, 0x00},   // 41 1199 9d98 Ã¦â€Âª
    {0x52, 0x7f, 0x5f, 0x1a, 0x5f, 0x3e, 0x79, 0x00},   // 41 119a 9d99 Ã¦â€™â€¢
    {0x52, 0x7f, 0x5c, 0x3e, 0x17, 0x7e, 0x5c, 0x00},   // 41 119b 9d9a Ã¦â€™â€œ
    {0x52, 0x7f, 0x55, 0x3b, 0x59, 0x2a, 0x5d, 0x00},   // 41 119c 9d9b Ã¦â€™Â¥
    {0x52, 0x7f, 0x4a, 0x1e, 0x6b, 0x1e, 0x4a, 0x00},   // 41 119d 9d9c Ã¦â€™Â©
    {0x52, 0x7f, 0x4d, 0x56, 0x3d, 0x56, 0x7d, 0x00},   // 41 119e 9d9d Ã¦â€™Ë†
    {0x52, 0x7f, 0x6e, 0x2e, 0x42, 0x47, 0x6a, 0x00},   // 41 119f 9d9e Ã¦â€™Â¼
    {0x52, 0x7f, 0x7c, 0x2c, 0x57, 0x7a, 0x2a, 0x00},   // 41 11a0 9d9f Ã¦â€œÅ¡
    {0x52, 0x7f, 0x7a, 0x4e, 0x7d, 0x2e, 0x7a, 0x00},   // 41 11a1 9da0 Ã¦â€œâ€™
    {0x52, 0x7f, 0x4e, 0x7e, 0x5b, 0x7e, 0x4e, 0x00},   // 41 11a2 9da1 Ã¦â€œâ€¦
    {0x52, 0x7f, 0x2b, 0x3b, 0x6f, 0x3b, 0x2b, 0x00},   // 41 11a3 9da2 Ã¦â€œâ€¡
    {0x52, 0x7f, 0x69, 0x54, 0x5e, 0x77, 0x5e, 0x00},   // 41 11a4 9da3 Ã¦â€™Â»
    {0x24, 0x3f, 0x7b, 0x70, 0x36, 0x3b, 0x26, 0x00},   // 41 11a5 9da4 Ã¦â€œËœ
    {0x52, 0x7f, 0x76, 0x53, 0x77, 0x53, 0x76, 0x00},   // 41 11a6 9da5 Ã¦â€œâ€š
    {0x52, 0x7f, 0x7f, 0x2b, 0x74, 0x6f, 0x7f, 0x00},   // 41 11a7 9da6 Ã¦â€œÂ±
    {0x28, 0x1e, 0x69, 0x7e, 0x2d, 0x1f, 0x28, 0x00},   // 41 11a8 9da7 Ã¦â€œÂ§
    {0x28, 0x1e, 0x29, 0x7e, 0x2d, 0x1f, 0x28, 0x00},   // 41 11a9 9da8 Ã¨Ë†â€°
    {0x52, 0x7f, 0x4a, 0x36, 0x2b, 0x76, 0x0a, 0x00},   // 41 11aa 9da9 Ã¦â€œÂ 
    {0x52, 0x7f, 0x5a, 0x6e, 0x7f, 0x6e, 0x5a, 0x00},   // 41 11ab 9daa Ã¦â€œÂ¡
    {0x52, 0x7f, 0x08, 0x6c, 0x6b, 0x64, 0x08, 0x00},   // 41 11ac 9dab Ã¦Å Â¬
    {0x52, 0x7f, 0x34, 0x36, 0x5f, 0x76, 0x14, 0x00},   // 41 11ad 9dac Ã¦â€œÂ£
    {0x52, 0x7f, 0x4e, 0x3a, 0x37, 0x3a, 0x46, 0x00},   // 41 11ae 9dad Ã¦â€œÂ¯
    {0x52, 0x7f, 0x47, 0x3d, 0x38, 0x7f, 0x46, 0x00},   // 41 11af 9dae Ã¦â€Â¬
    {0x52, 0x7f, 0x7b, 0x2e, 0x78, 0x0b, 0x7e, 0x00},   // 41 11b0 9daf Ã¦â€œÂ¶
    {0x52, 0x7f, 0x3e, 0x4a, 0x3f, 0x3e, 0x4a, 0x00},   // 41 11b1 9db0 Ã¦â€œÂ´
    {0x52, 0x7f, 0x5a, 0x39, 0x5a, 0x7f, 0x1b, 0x00},   // 41 11b2 9db1 Ã¦â€œÂ²
    {0x52, 0x7f, 0x7b, 0x77, 0x03, 0x6f, 0x4b, 0x00},   // 41 11b3 9db2 Ã¦â€œÂº
    {0x2a, 0x1f, 0x6a, 0x7d, 0x2a, 0x1f, 0x2a, 0x00},   // 41 11b4 9db3 Ã¦â€â‚¬
    {0x52, 0x7f, 0x5a, 0x35, 0x7f, 0x3a, 0x55, 0x00},   // 41 11b5 9db4 Ã¦â€œÂ½
    {0x52, 0x7f, 0x36, 0x7e, 0x5b, 0x3e, 0x56, 0x00},   // 41 11b6 9db5 Ã¦â€Ëœ
    {0x52, 0x7f, 0x6b, 0x3e, 0x57, 0x3e, 0x77, 0x00},   // 41 11b7 9db6 Ã¦â€Å“
    {0x52, 0x7f, 0x4a, 0x37, 0x3a, 0x37, 0x4a, 0x00},   // 41 11b8 9db7 Ã¦â€â€¦
    {0x52, 0x7f, 0x5b, 0x3e, 0x5b, 0x7e, 0x55, 0x00},   // 41 11b9 9db8 Ã¦â€Â¤
    {0x2a, 0x3d, 0x6a, 0x77, 0x37, 0x2a, 0x3d, 0x00},   // 41 11ba 9db9 Ã¦â€Â£
    {0x52, 0x7f, 0x43, 0x5f, 0x2c, 0x5f, 0x4b, 0x00},   // 41 11bb 9dba Ã¦â€Â«
    {0x40, 0x48, 0x58, 0x2f, 0x5a, 0x42, 0x40, 0x00},   // 41 11bc 9dbb Ã¦â€Â´
    {0x48, 0x44, 0x2b, 0x12, 0x2e, 0x42, 0x40, 0x00},   // 41 11bd 9dbc Ã¦â€Âµ
    {0x01, 0x4f, 0x79, 0x44, 0x5f, 0x22, 0x5e, 0x00},   // 41 11be 9dbd Ã¦â€Â·
    {0x3e, 0x20, 0x7f, 0x44, 0x5f, 0x22, 0x5e, 0x00},   // 41 11bf 9dbe Ã¦â€Â¶
    {0x04, 0x7e, 0x3f, 0x44, 0x5f, 0x22, 0x5e, 0x00},   // 41 11c0 9dbf Ã¦â€Â¸
    {0x3e, 0x3e, 0x3e, 0x44, 0x5f, 0x22, 0x5e, 0x00},   // 41 11c1 9dc0 Ã§â€¢â€¹
    {0x4a, 0x56, 0x23, 0x56, 0x5c, 0x23, 0x5e, 0x00},   // 41 11c2 9dc1 Ã¦â€¢Ë†
    {0x4a, 0x3f, 0x6a, 0x44, 0x5f, 0x22, 0x5e, 0x00},   // 41 11c3 9dc2 Ã¦â€¢â€“
    {0x42, 0x2e, 0x7f, 0x2e, 0x5c, 0x23, 0x5e, 0x00},   // 41 11c4 9dc3 Ã¦â€¢â€¢
    {0x54, 0x16, 0x7d, 0x16, 0x58, 0x2f, 0x5a, 0x00},   // 41 11c5 9dc4 Ã¦â€¢Â
    {0x54, 0x16, 0x7d, 0x16, 0x5c, 0x23, 0x5e, 0x00},   // 41 11c6 9dc5 Ã¦â€¢Ëœ
    {0x7a, 0x09, 0x6f, 0x7a, 0x5c, 0x23, 0x5e, 0x00},   // 41 11c7 9dc6 Ã¦â€¢Å¾
    {0x7a, 0x29, 0x7f, 0x7a, 0x5c, 0x23, 0x5e, 0x00},   // 41 11c8 9dc7 Ã¦â€¢Â
    {0x72, 0x1e, 0x5b, 0x1e, 0x78, 0x2f, 0x5a, 0x00},   // 41 11c9 9dc8 Ã¦â€¢Â²
    {0x54, 0x7e, 0x5b, 0x36, 0x5c, 0x23, 0x5e, 0x00},   // 41 11ca 9dc9 Ã¦â€¢Â¸
    {0x5c, 0x36, 0x5d, 0x36, 0x5c, 0x23, 0x5e, 0x00},   // 41 11cb 9dca Ã¦â€“â€š
    {0x52, 0x7d, 0x36, 0x1d, 0x7a, 0x55, 0x5b, 0x00},   // 41 11cc 9dcb Ã¦â€“Æ’
    {0x52, 0x4d, 0x5a, 0x2f, 0x2f, 0x5a, 0x4d, 0x00},   // 41 11cd 9dcc Ã¨Â®Å 
    {0x42, 0x3d, 0x5f, 0x7c, 0x2a, 0x20, 0x7f, 0x00},   // 41 11ce 9dcd Ã¦â€“â€º
    {0x72, 0x5f, 0x72, 0x5f, 0x2a, 0x20, 0x7f, 0x00},   // 41 11cf 9dce Ã¦â€“Å¸
    {0x09, 0x37, 0x31, 0x40, 0x3e, 0x0a, 0x79, 0x00},   // 41 11d0 9dcf Ã¦â€“Â«
    {0x7f, 0x6a, 0x5d, 0x6a, 0x5d, 0x3e, 0x79, 0x00},   // 41 11d1 9dd0 Ã¦â€“Â·
    {0x62, 0x1f, 0x7a, 0x24, 0x7b, 0x2a, 0x7a, 0x00},   // 41 11d2 9dd1 Ã¦â€”Æ’
    {0x62, 0x1f, 0x7a, 0x0c, 0x3b, 0x7e, 0x3a, 0x00},   // 41 11d3 9dd2 Ã¦â€”â€ 
    {0x5a, 0x4a, 0x3e, 0x2b, 0x2a, 0x6e, 0x1a, 0x00},   // 41 11d4 9dd3 Ã¦â€”Â
    {0x62, 0x1f, 0x7a, 0x04, 0x2b, 0x7e, 0x56, 0x00},   // 41 11d5 9dd4 Ã¦â€”â€ž
    {0x62, 0x1f, 0x7a, 0x24, 0x5b, 0x7a, 0x52, 0x00},   // 41 11d6 9dd5 Ã¦â€”Å’
    {0x62, 0x1f, 0x7a, 0x04, 0x63, 0x0e, 0x6a, 0x00},   // 41 11d7 9dd6 Ã¦â€”â€™
    {0x62, 0x1f, 0x7a, 0x14, 0x6f, 0x7e, 0x16, 0x00},   // 41 11d8 9dd7 Ã¦â€”â€º
    {0x62, 0x1f, 0x7a, 0x15, 0x6f, 0x7f, 0x15, 0x00},   // 41 11d9 9dd8 Ã¦â€”â„¢
    {0x48, 0x49, 0x29, 0x1f, 0x79, 0x49, 0x68, 0x00},   // 41 11da 9dd9 Ã¦â€”Â 
    {0x4d, 0x49, 0x29, 0x1f, 0x79, 0x49, 0x68, 0x00},   // 41 11db 9dda Ã¦â€”Â¡
    {0x28, 0x2f, 0x2d, 0x7d, 0x2d, 0x2f, 0x28, 0x00},   // 41 11dc 9ddb Ã¦â€”Â±
    {0x48, 0x4f, 0x2d, 0x7d, 0x2d, 0x4f, 0x48, 0x00},   // 41 11dd 9ddc Ã¦ÂÂ²
    {0x44, 0x57, 0x55, 0x3d, 0x55, 0x57, 0x44, 0x00},   // 41 11de 9ddd Ã¦ËœÅ 
    {0x40, 0x38, 0x4f, 0x4d, 0x3d, 0x4f, 0x48, 0x00},   // 41 11df 9dde Ã¦ËœÆ’
    {0x48, 0x4f, 0x5d, 0x2d, 0x5d, 0x4f, 0x48, 0x00},   // 41 11e0 9ddf Ã¦â€”Â»
    {0x0a, 0x7a, 0x76, 0x7f, 0x76, 0x7a, 0x0a, 0x00},   // 41 11e1 9de0 Ã¦ÂÂ³
    {0x3e, 0x2a, 0x7e, 0x3f, 0x05, 0x7d, 0x57, 0x00},   // 41 11e2 9de1 Ã¦ËœÂµ
    {0x28, 0x5d, 0x7d, 0x28, 0x5f, 0x55, 0x5f, 0x00},   // 41 11e3 9de2 Ã¦ËœÂ¶
    {0x38, 0x6f, 0x35, 0x05, 0x7d, 0x0f, 0x38, 0x00},   // 41 11e4 9de3 Ã¦ËœÂ´
    {0x24, 0x57, 0x3d, 0x55, 0x35, 0x57, 0x74, 0x00},   // 41 11e5 9de4 Ã¦ËœÅ“
    {0x4c, 0x57, 0x75, 0x5d, 0x35, 0x57, 0x4c, 0x00},   // 41 11e6 9de5 Ã¦â„¢Â
    {0x3e, 0x2a, 0x3e, 0x4a, 0x3c, 0x7f, 0x4a, 0x00},   // 41 11e7 9de6 Ã¦â„¢â€ž
    {0x09, 0x7f, 0x5d, 0x59, 0x5f, 0x7d, 0x09, 0x00},   // 41 11e8 9de7 Ã¦â„¢â€°
    {0x54, 0x5b, 0x3f, 0x03, 0x7f, 0x4b, 0x54, 0x00},   // 41 11e9 9de8 Ã¦â„¢Â
    {0x3e, 0x2a, 0x7e, 0x2d, 0x7a, 0x2d, 0x68, 0x00},   // 41 11ea 9de9 Ã¦â„¢Å¾
    {0x50, 0x7a, 0x5a, 0x5f, 0x5a, 0x7e, 0x54, 0x00},   // 41 11eb 9dea Ã¦â„¢Â
    {0x3e, 0x2a, 0x3e, 0x14, 0x7d, 0x57, 0x7d, 0x00},   // 41 11ec 9deb Ã¦â„¢Â¤
    {0x3e, 0x2a, 0x3e, 0x0c, 0x6b, 0x7f, 0x6a, 0x00},   // 41 11ed 9dec Ã¦â„¢Â§
    {0x40, 0x3c, 0x77, 0x5d, 0x3d, 0x5f, 0x54, 0x00},   // 41 11ee 9ded Ã¦â„¢Â¨
    {0x40, 0x3c, 0x57, 0x35, 0x45, 0x3f, 0x54, 0x00},   // 41 11ef 9dee Ã¦â„¢Å¸
    {0x0a, 0x7f, 0x70, 0x7e, 0x76, 0x7d, 0x04, 0x00},   // 41 11f0 9def Ã¦â„¢Â¢
    {0x3e, 0x2a, 0x3e, 0x1a, 0x7f, 0x0e, 0x79, 0x00},   // 41 11f1 9df0 Ã¦â„¢Â°
    {0x28, 0x6f, 0x3d, 0x05, 0x7d, 0x2f, 0x28, 0x00},   // 41 11f2 9df1 Ã¦Å¡Æ’
    {0x2c, 0x27, 0x3d, 0x7d, 0x3d, 0x27, 0x2c, 0x00},   // 41 11f3 9df2 Ã¦Å¡Ë†
    {0x3e, 0x2a, 0x5e, 0x57, 0x3a, 0x57, 0x5a, 0x00},   // 41 11f4 9df3 Ã¦Å¡Å½
    {0x3e, 0x2a, 0x3e, 0x27, 0x3d, 0x7f, 0x27, 0x00},   // 41 11f5 9df4 Ã¦Å¡â€°
    {0x3e, 0x2a, 0x3e, 0x46, 0x6a, 0x6b, 0x46, 0x00},   // 41 11f6 9df5 Ã¦Å¡â€ž
    {0x3e, 0x2a, 0x3e, 0x24, 0x5f, 0x35, 0x77, 0x00},   // 41 11f7 9df6 Ã¦Å¡Ëœ
    {0x3e, 0x2a, 0x3e, 0x53, 0x1d, 0x1d, 0x53, 0x00},   // 41 11f8 9df7 Ã¦Å¡Â
    {0x4e, 0x7f, 0x56, 0x59, 0x57, 0x7f, 0x49, 0x00},   // 41 11f9 9df8 Ã¦â€ºÂ
    {0x55, 0x30, 0x53, 0x7f, 0x6b, 0x7f, 0x6b, 0x00},   // 41 11fa 9df9 Ã¦Å¡Â¹
    {0x3e, 0x2a, 0x5e, 0x3e, 0x17, 0x7e, 0x5c, 0x00},   // 41 11fb 9dfa Ã¦â€ºâ€°
    {0x3e, 0x3e, 0x2e, 0x7b, 0x56, 0x3f, 0x5e, 0x00},   // 41 11fc 9dfb Ã¦Å¡Â¾
    {0x02, 0x7d, 0x56, 0x5d, 0x5a, 0x75, 0x0b, 0x00},   // 41 11fd 9dfc Ã¦Å¡Â¼
    {0x3e, 0x2a, 0x3e, 0x3f, 0x7e, 0x3f, 0x2a, 0x00},   // 42 11fe 9e40 Ã¦â€ºâ€ž
    {0x3e, 0x2a, 0x5e, 0x1e, 0x6b, 0x1e, 0x4a, 0x00},   // 42 11ff 9e41 Ã¦Å¡Â¸
    {0x3e, 0x2a, 0x5d, 0x2f, 0x55, 0x37, 0x4d, 0x00},   // 42 1200 9e42 Ã¦â€ºâ€“
    {0x3e, 0x2a, 0x3e, 0x5f, 0x7a, 0x2f, 0x5a, 0x00},   // 42 1201 9e43 Ã¦â€ºÅ¡
    {0x3e, 0x2a, 0x7e, 0x4a, 0x3f, 0x3e, 0x4a, 0x00},   // 42 1202 9e44 Ã¦â€ºÂ 
    {0x3e, 0x2a, 0x7e, 0x3e, 0x62, 0x5b, 0x62, 0x00},   // 42 1203 9e45 Ã¦ËœÂ¿
    {0x3e, 0x2a, 0x3e, 0x5b, 0x6e, 0x3b, 0x5a, 0x00},   // 42 1204 9e46 Ã¦â€ºÂ¦
    {0x54, 0x3f, 0x7d, 0x55, 0x3d, 0x5f, 0x54, 0x00},   // 42 1205 9e47 Ã¦â€ºÂ©
    {0x00, 0x7f, 0x49, 0x49, 0x49, 0x41, 0x7f, 0x00},   // 42 1206 9e48 Ã¦â€ºÂ°
    {0x4e, 0x4a, 0x4f, 0x5a, 0x2e, 0x51, 0x40, 0x00},   // 42 1207 9e49 Ã¦â€ºÂµ
    {0x10, 0x77, 0x6d, 0x5d, 0x6d, 0x0f, 0x78, 0x00},   // 42 1208 9e4a Ã¦â€ºÂ·
    {0x7f, 0x15, 0x7f, 0x76, 0x44, 0x7f, 0x76, 0x00},   // 42 1209 9e4b Ã¦Å“Â
    {0x7f, 0x15, 0x7f, 0x7e, 0x5a, 0x3b, 0x5e, 0x00},   // 42 120a 9e4c Ã¦Å“â€“
    {0x28, 0x1a, 0x4f, 0x3a, 0x7f, 0x1a, 0x28, 0x00},   // 42 120b 9e4d Ã¦Å“Å¾
    {0x7f, 0x15, 0x7e, 0x5f, 0x7a, 0x2f, 0x5a, 0x00},   // 42 120c 9e4e Ã¦Å“Â¦
    {0x7f, 0x15, 0x7e, 0x2b, 0x7e, 0x77, 0x5d, 0x00},   // 42 120d 9e4f Ã¦Å“Â§
    {0x26, 0x3a, 0x77, 0x3f, 0x43, 0x36, 0x76, 0x00},   // 42 120e 9e50 Ã©Å“Â¸
    {0x42, 0x3a, 0x02, 0x7f, 0x02, 0x7b, 0x42, 0x00},   // 42 120f 9e51 Ã¦Å“Â®
    {0x42, 0x4e, 0x26, 0x7f, 0x26, 0x4e, 0x42, 0x00},   // 42 1210 9e52 Ã¦Å“Â¿
    {0x54, 0x55, 0x33, 0x79, 0x33, 0x52, 0x56, 0x00},   // 42 1211 9e53 Ã¦Å“Â¶
    {0x1a, 0x7f, 0x4a, 0x31, 0x0f, 0x30, 0x40, 0x00},   // 42 1212 9e54 Ã¦ÂÂ
    {0x1a, 0x7f, 0x0a, 0x42, 0x3f, 0x42, 0x7e, 0x00},   // 42 1213 9e55 Ã¦Å“Â¸
    {0x1a, 0x7f, 0x0a, 0x41, 0x3f, 0x41, 0x7f, 0x00},   // 42 1214 9e56 Ã¦Å“Â·
    {0x1a, 0x7f, 0x08, 0x09, 0x7f, 0x09, 0x08, 0x00},   // 42 1215 9e57 Ã¦Ââ€ 
    {0x1a, 0x7f, 0x0a, 0x79, 0x49, 0x49, 0x6f, 0x00},   // 42 1216 9e58 Ã¦ÂÅ¾
    {0x1a, 0x7f, 0x40, 0x42, 0x7e, 0x42, 0x40, 0x00},   // 42 1217 9e59 Ã¦ÂÂ 
    {0x1a, 0x7f, 0x0a, 0x04, 0x0f, 0x34, 0x45, 0x00},   // 42 1218 9e5a Ã¦Ââ„¢
    {0x1a, 0x7f, 0x7c, 0x40, 0x7f, 0x40, 0x7c, 0x00},   // 42 1219 9e5b Ã¦ÂÂ£
    {0x1a, 0x7f, 0x0a, 0x41, 0x3f, 0x45, 0x7d, 0x00},   // 42 121a 9e5c Ã¦ÂÂ¤
    {0x1a, 0x7f, 0x41, 0x49, 0x7f, 0x49, 0x41, 0x00},   // 42 121b 9e5d Ã¦Å¾â€°
    {0x52, 0x12, 0x4a, 0x1f, 0x4a, 0x12, 0x52, 0x00},   // 42 121c 9e5e Ã¦ÂÂ°
    {0x2a, 0x2a, 0x56, 0x6f, 0x4e, 0x56, 0x2a, 0x00},   // 42 121d 9e5f Ã¦Å¾Â©
    {0x1a, 0x7f, 0x09, 0x4b, 0x7d, 0x0b, 0x18, 0x00},   // 42 121e 9e60 Ã¦ÂÂ¼
    {0x1a, 0x7f, 0x08, 0x46, 0x5f, 0x22, 0x14, 0x00},   // 42 121f 9e61 Ã¦ÂÂª
    {0x1a, 0x7f, 0x44, 0x3b, 0x48, 0x7b, 0x04, 0x00},   // 42 1220 9e62 Ã¦Å¾Å’
    {0x1a, 0x7f, 0x0a, 0x42, 0x3e, 0x4b, 0x7a, 0x00},   // 42 1221 9e63 Ã¦Å¾â€¹
    {0x1a, 0x7f, 0x0a, 0x41, 0x3d, 0x15, 0x1d, 0x00},   // 42 1222 9e64 Ã¦Å¾Â¦
    {0x1a, 0x7f, 0x4a, 0x3e, 0x09, 0x7f, 0x08, 0x00},   // 42 1223 9e65 Ã¦Å¾Â¡
    {0x1a, 0x7f, 0x49, 0x3f, 0x09, 0x7f, 0x09, 0x00},   // 42 1224 9e66 Ã¦Å¾â€¦
    {0x1a, 0x7f, 0x62, 0x1f, 0x7e, 0x42, 0x7e, 0x00},   // 42 1225 9e67 Ã¦Å¾Â·
    {0x1a, 0x7f, 0x0a, 0x1d, 0x15, 0x5d, 0x7f, 0x00},   // 42 1226 9e68 Ã¦Å¸Â¯
    {0x1a, 0x7f, 0x0a, 0x57, 0x35, 0x55, 0x77, 0x00},   // 42 1227 9e69 Ã¦Å¾Â´
    {0x42, 0x5e, 0x3e, 0x7f, 0x3e, 0x5e, 0x42, 0x00},   // 42 1228 9e6a Ã¦Å¸Â¬
    {0x1a, 0x7f, 0x4f, 0x29, 0x09, 0x29, 0x4f, 0x00},   // 42 1229 9e6b Ã¦Å¾Â³
    {0x1a, 0x7f, 0x0a, 0x7f, 0x65, 0x53, 0x6f, 0x00},   // 42 122a 9e6c Ã¦Å¸Â©
    {0x1a, 0x7f, 0x0a, 0x04, 0x1b, 0x5a, 0x7e, 0x00},   // 42 122b 9e6d Ã¦Å¾Â¸
    {0x1a, 0x7f, 0x40, 0x7f, 0x55, 0x7f, 0x40, 0x00},   // 42 122c 9e6e Ã¦Å¸Â¤
    {0x1a, 0x7f, 0x0a, 0x04, 0x7f, 0x2a, 0x2a, 0x00},   // 42 122d 9e6f Ã¦Å¸Å¾
    {0x1a, 0x7f, 0x40, 0x3e, 0x1a, 0x79, 0x28, 0x00},   // 42 122e 9e70 Ã¦Å¸Â
    {0x1a, 0x7f, 0x40, 0x7e, 0x4a, 0x5e, 0x69, 0x00},   // 42 122f 9e71 Ã¦Å¸Â¢
    {0x1a, 0x7f, 0x76, 0x44, 0x7f, 0x44, 0x76, 0x00},   // 42 1230 9e72 Ã¦Å¸Â®
    {0x1a, 0x7f, 0x0a, 0x04, 0x7b, 0x5a, 0x5e, 0x00},   // 42 1231 9e73 Ã¦Å¾Â¹
    {0x1a, 0x7f, 0x04, 0x7e, 0x09, 0x42, 0x7f, 0x00},   // 42 1232 9e74 Ã¦Å¸Å½
    {0x1a, 0x7f, 0x42, 0x7e, 0x63, 0x5e, 0x42, 0x00},   // 42 1233 9e75 Ã¦Å¸â€ 
    {0x1a, 0x7f, 0x40, 0x3e, 0x42, 0x3e, 0x61, 0x00},   // 42 1234 9e76 Ã¦Å¸Â§
    {0x1a, 0x7f, 0x1c, 0x76, 0x5d, 0x76, 0x1c, 0x00},   // 42 1235 9e77 Ã¦ÂªÅ“
    {0x55, 0x5f, 0x35, 0x78, 0x35, 0x5f, 0x55, 0x00},   // 42 1236 9e78 Ã¦Â Å¾
    {0x1a, 0x7f, 0x7f, 0x41, 0x6b, 0x7f, 0x6b, 0x00},   // 42 1237 9e79 Ã¦Â¡â€ 
    {0x1a, 0x7f, 0x29, 0x15, 0x7f, 0x15, 0x7f, 0x00},   // 42 1238 9e7a Ã¦Â Â©
    {0x4a, 0x5b, 0x35, 0x7b, 0x34, 0x5f, 0x46, 0x00},   // 42 1239 9e7b Ã¦Â¡â‚¬
    {0x1a, 0x7f, 0x0a, 0x36, 0x3b, 0x36, 0x6a, 0x00},   // 42 123a 9e7c Ã¦Â¡Â
    {0x1a, 0x7f, 0x28, 0x1a, 0x3f, 0x2a, 0x69, 0x00},   // 42 123b 9e7d Ã¦Â Â²
    {0x1a, 0x7f, 0x45, 0x57, 0x7d, 0x53, 0x45, 0x00},   // 42 123c 9e7e Ã¦Â¡Å½
    {0x1a, 0x7f, 0x4a, 0x3e, 0x7b, 0x06, 0x6a, 0x00},   // 43 123d 9e80 Ã¦Â¢Â³
    {0x1a, 0x7f, 0x0a, 0x7e, 0x23, 0x76, 0x2e, 0x00},   // 43 123e 9e81 Ã¦Â Â«
    {0x1a, 0x7f, 0x34, 0x2e, 0x7d, 0x2c, 0x26, 0x00},   // 43 123f 9e82 Ã¦Â¡â„¢
    {0x1a, 0x7f, 0x45, 0x54, 0x57, 0x54, 0x7d, 0x00},   // 43 1240 9e83 Ã¦Â¡Â£
    {0x1a, 0x7f, 0x42, 0x3e, 0x1d, 0x57, 0x7c, 0x00},   // 43 1241 9e84 Ã¦Â¡Â·
    {0x1a, 0x7f, 0x28, 0x2f, 0x7d, 0x2f, 0x28, 0x00},   // 43 1242 9e85 Ã¦Â¡Â¿
    {0x50, 0x56, 0x36, 0x7f, 0x36, 0x54, 0x5c, 0x00},   // 43 1243 9e86 Ã¦Â¢Å¸
    {0x1a, 0x7f, 0x0c, 0x6b, 0x7f, 0x6a, 0x08, 0x00},   // 43 1244 9e87 Ã¦Â¢Â
    {0x1a, 0x7f, 0x2a, 0x57, 0x32, 0x5e, 0x4b, 0x00},   // 43 1245 9e88 Ã¦Â¢Â­
    {0x1a, 0x7f, 0x40, 0x3e, 0x7e, 0x56, 0x5d, 0x00},   // 43 1246 9e89 Ã¦Â¢â€
    {0x04, 0x7e, 0x5f, 0x3a, 0x75, 0x3b, 0x50, 0x00},   // 43 1247 9e8a Ã¦Â¢Â
    {0x1a, 0x7f, 0x55, 0x3f, 0x55, 0x7f, 0x1b, 0x00},   // 43 1248 9e8b Ã¦Â¢â€º
    {0x1a, 0x7f, 0x55, 0x3b, 0x6a, 0x7e, 0x69, 0x00},   // 43 1249 9e8c Ã¦Â¢Æ’
    {0x1a, 0x7f, 0x34, 0x36, 0x5f, 0x76, 0x14, 0x00},   // 43 124a 9e8d Ã¦ÂªÂ®
    {0x1a, 0x7f, 0x50, 0x1e, 0x16, 0x1d, 0x54, 0x00},   // 43 124b 9e8e Ã¦Â¢Â¹
    {0x1a, 0x7f, 0x22, 0x29, 0x6b, 0x39, 0x22, 0x00},   // 43 124c 9e8f Ã¦Â¡Â´
    {0x4a, 0x46, 0x3f, 0x2a, 0x0e, 0x7f, 0x4a, 0x00},   // 43 124d 9e90 Ã¦Â¢Âµ
    {0x1a, 0x7f, 0x0a, 0x77, 0x5d, 0x55, 0x77, 0x00},   // 43 124e 9e91 Ã¦Â¢Â 
    {0x1a, 0x16, 0x1f, 0x7a, 0x36, 0x5f, 0x1a, 0x00},   // 43 124f 9e92 Ã¦Â¢Âº
    {0x1a, 0x7f, 0x5d, 0x77, 0x41, 0x77, 0x5d, 0x00},   // 43 1250 9e93 Ã¦Â¤Â
    {0x1a, 0x7f, 0x10, 0x16, 0x7f, 0x56, 0x50, 0x00},   // 43 1251 9e94 Ã¦Â¢Â
    {0x1a, 0x7f, 0x0a, 0x55, 0x3f, 0x75, 0x6f, 0x00},   // 43 1252 9e95 Ã¦Â¡Â¾
    {0x1a, 0x7f, 0x22, 0x2e, 0x6b, 0x3e, 0x22, 0x00},   // 43 1253 9e96 Ã¦Â¤Â
    {0x48, 0x5a, 0x2f, 0x7a, 0x2f, 0x5a, 0x48, 0x00},   // 43 1254 9e97 Ã¦Â£Å 
    {0x1a, 0x7f, 0x04, 0x57, 0x3a, 0x56, 0x7e, 0x00},   // 43 1255 9e98 Ã¦Â¤Ë†
    {0x5a, 0x2a, 0x7f, 0x5a, 0x2a, 0x7f, 0x5a, 0x00},   // 43 1256 9e99 Ã¦Â£Ëœ
    {0x1a, 0x7f, 0x41, 0x6b, 0x7f, 0x6b, 0x7f, 0x00},   // 43 1257 9e9a Ã¦Â¤Â¢
    {0x1a, 0x7f, 0x56, 0x2d, 0x36, 0x6d, 0x16, 0x00},   // 43 1258 9e9b Ã¦Â¤Â¦
    {0x1a, 0x7f, 0x7f, 0x35, 0x29, 0x35, 0x7f, 0x00},   // 43 1259 9e9c Ã¦Â£Â¡
    {0x1a, 0x7f, 0x46, 0x56, 0x73, 0x56, 0x46, 0x00},   // 43 125a 9e9d Ã¦Â¤Å’
    {0x1a, 0x7f, 0x7f, 0x55, 0x05, 0x7d, 0x57, 0x00},   // 43 125b 9e9e Ã¦Â£Â
    {0x1a, 0x7f, 0x0a, 0x7f, 0x75, 0x6f, 0x15, 0x00},   // 43 125c 9e9f Ã¦Â£â€
    {0x1a, 0x7f, 0x0a, 0x52, 0x5b, 0x36, 0x5b, 0x00},   // 43 125d 9ea0 Ã¦Â£Â§
    {0x1a, 0x7f, 0x56, 0x1a, 0x7b, 0x1a, 0x56, 0x00},   // 43 125e 9ea1 Ã¦Â£â€¢
    {0x1a, 0x7f, 0x2f, 0x5d, 0x2a, 0x5d, 0x4f, 0x00},   // 43 125f 9ea2 Ã¦Â¤Â¶
    {0x1a, 0x7f, 0x28, 0x7f, 0x4a, 0x31, 0x4f, 0x00},   // 43 1260 9ea3 Ã¦Â¤â€™
    {0x1a, 0x7f, 0x4a, 0x5e, 0x2b, 0x3e, 0x4a, 0x00},   // 43 1261 9ea4 Ã¦Â¤â€ž
    {0x52, 0x56, 0x2a, 0x7f, 0x2a, 0x56, 0x52, 0x00},   // 43 1262 9ea5 Ã¦Â£â€”
    {0x1a, 0x7f, 0x5a, 0x2a, 0x7f, 0x2e, 0x54, 0x00},   // 43 1263 9ea6 Ã¦Â£Â£
    {0x1a, 0x7f, 0x4b, 0x3f, 0x4a, 0x3e, 0x3e, 0x00},   // 43 1264 9ea7 Ã¦Â¤Â¥
    {0x1a, 0x7f, 0x20, 0x3c, 0x77, 0x3e, 0x22, 0x00},   // 43 1265 9ea8 Ã¦Â£Â¹
    {0x56, 0x53, 0x3e, 0x7b, 0x3e, 0x53, 0x56, 0x00},   // 43 1266 9ea9 Ã¦Â£Â 
    {0x1a, 0x7f, 0x64, 0x2a, 0x4d, 0x5e, 0x64, 0x00},   // 43 1267 9eaa Ã¦Â£Â¯
    {0x1a, 0x7f, 0x3e, 0x72, 0x0b, 0x52, 0x7a, 0x00},   // 43 1268 9eab Ã¦Â¤Â¨
    {0x1a, 0x7f, 0x5a, 0x7f, 0x42, 0x7f, 0x5a, 0x00},   // 43 1269 9eac Ã¦Â¤Âª
    {0x1a, 0x7f, 0x7f, 0x07, 0x00, 0x47, 0x7f, 0x00},   // 43 126a 9ead Ã¦Â¤Å¡
    {0x1a, 0x7f, 0x10, 0x5e, 0x1f, 0x1a, 0x5f, 0x00},   // 43 126b 9eae Ã¦Â¤Â£
    {0x1a, 0x7f, 0x2d, 0x3b, 0x29, 0x4e, 0x7f, 0x00},   // 43 126c 9eaf Ã¦Â¤Â¡
    {0x1a, 0x7f, 0x74, 0x32, 0x75, 0x36, 0x74, 0x00},   // 43 126d 9eb0 Ã¦Â£â€ 
    {0x1a, 0x7f, 0x49, 0x77, 0x75, 0x7b, 0x4e, 0x00},   // 43 126e 9eb1 Ã¦Â¥Â¹
    {0x1a, 0x7f, 0x0f, 0x6a, 0x70, 0x6f, 0x0a, 0x00},   // 43 126f 9eb2 Ã¦Â¥Â·
    {0x1a, 0x7f, 0x3a, 0x2f, 0x7a, 0x3f, 0x7f, 0x00},   // 43 1270 9eb3 Ã¦Â¥Å“
    {0x1a, 0x7f, 0x35, 0x7f, 0x4c, 0x3f, 0x44, 0x00},   // 43 1271 9eb4 Ã¦Â¥Â¸
    {0x1a, 0x7f, 0x24, 0x3f, 0x2d, 0x7f, 0x24, 0x00},   // 43 1272 9eb5 Ã¦Â¥Â«
    {0x1a, 0x7f, 0x56, 0x5f, 0x36, 0x53, 0x57, 0x00},   // 43 1273 9eb6 Ã¦Â¥â€
    {0x1a, 0x7f, 0x50, 0x3e, 0x7b, 0x2e, 0x50, 0x00},   // 43 1274 9eb7 Ã¦Â¥Â¾
    {0x1a, 0x7f, 0x28, 0x1a, 0x6f, 0x7a, 0x69, 0x00},   // 43 1275 9eb8 Ã¦Â¥Â®
    {0x1a, 0x7f, 0x72, 0x5f, 0x72, 0x5f, 0x52, 0x00},   // 43 1276 9eb9 Ã¦Â¤Â¹
    {0x1a, 0x7f, 0x1a, 0x6e, 0x3b, 0x6e, 0x1a, 0x00},   // 43 1277 9eba Ã¦Â¥Â´
    {0x1a, 0x7f, 0x2c, 0x56, 0x7d, 0x27, 0x55, 0x00},   // 43 1278 9ebb Ã¦Â¤Â½
    {0x1a, 0x7f, 0x29, 0x7d, 0x1b, 0x7f, 0x1a, 0x00},   // 43 1279 9ebc Ã¦Â¥â„¢
    {0x1a, 0x7f, 0x21, 0x3f, 0x2d, 0x7f, 0x1b, 0x00},   // 43 127a 9ebd Ã¦Â¤Â°
    {0x1a, 0x7f, 0x05, 0x73, 0x75, 0x26, 0x54, 0x00},   // 43 127b 9ebe Ã¦Â¥Â¡
    {0x1a, 0x7f, 0x02, 0x4b, 0x3b, 0x2f, 0x6b, 0x00},   // 43 127c 9ebf Ã¦Â¥Å¾
    {0x1a, 0x7f, 0x42, 0x2e, 0x7f, 0x2e, 0x4e, 0x00},   // 43 127d 9ec0 Ã¦Â¥Â
    {0x1a, 0x7f, 0x56, 0x5a, 0x77, 0x4a, 0x56, 0x00},   // 43 127e 9ec1 Ã¦Â¦Â
    {0x1a, 0x7f, 0x5f, 0x32, 0x77, 0x36, 0x57, 0x00},   // 43 127f 9ec2 Ã¦Â¥Âª
    {0x1a, 0x7f, 0x0a, 0x4f, 0x6d, 0x6b, 0x4f, 0x00},   // 43 1280 9ec3 Ã¦Â¦Â²
    {0x4d, 0x56, 0x35, 0x7c, 0x35, 0x56, 0x4d, 0x00},   // 43 1281 9ec4 Ã¦Â¦Â®
    {0x1a, 0x7f, 0x5e, 0x2a, 0x7f, 0x6a, 0x5e, 0x00},   // 43 1282 9ec5 Ã¦Â§Â
    {0x1a, 0x7f, 0x4b, 0x5a, 0x6b, 0x5a, 0x4b, 0x00},   // 43 1283 9ec6 Ã¦Â¦Â¿
    {0x1a, 0x7f, 0x72, 0x1e, 0x5b, 0x1e, 0x72, 0x00},   // 43 1284 9ec7 Ã¦Â§Â
    {0x1a, 0x7f, 0x44, 0x3d, 0x2f, 0x3d, 0x44, 0x00},   // 43 1285 9ec8 Ã¦Â§â€œ
    {0x1a, 0x7f, 0x0c, 0x77, 0x35, 0x77, 0x0c, 0x00},   // 43 1286 9ec9 Ã¦Â¦Â¾
    {0x1a, 0x7f, 0x4a, 0x3b, 0x5e, 0x7b, 0x5a, 0x00},   // 43 1287 9eca Ã¦Â§Å½
    {0x36, 0x5a, 0x3e, 0x7b, 0x3e, 0x5a, 0x36, 0x00},   // 43 1288 9ecb Ã¥Â¯Â¨
    {0x57, 0x5e, 0x37, 0x78, 0x37, 0x55, 0x5f, 0x00},   // 43 1289 9ecc Ã¦Â§Å 
    {0x1a, 0x7f, 0x0a, 0x5e, 0x77, 0x56, 0x70, 0x00},   // 43 128a 9ecd Ã¦Â§Â
    {0x1a, 0x7f, 0x48, 0x2f, 0x7d, 0x2f, 0x78, 0x00},   // 43 128b 9ece Ã¦Â¦Â»
    {0x5c, 0x57, 0x3f, 0x74, 0x3b, 0x55, 0x5b, 0x00},   // 43 128c 9ecf Ã¦Â§Æ’
    {0x1a, 0x7f, 0x55, 0x7f, 0x41, 0x7f, 0x55, 0x00},   // 43 128d 9ed0 Ã¦Â¦Â§
    {0x1a, 0x7f, 0x51, 0x47, 0x37, 0x47, 0x51, 0x00},   // 43 128e 9ed1 Ã¦Â¨Â®
    {0x1a, 0x7f, 0x12, 0x3e, 0x57, 0x7e, 0x13, 0x00},   // 43 128f 9ed2 Ã¦Â¦â€˜
    {0x1a, 0x7f, 0x53, 0x1d, 0x15, 0x1d, 0x53, 0x00},   // 43 1290 9ed3 Ã¦Â¦Â 
    {0x1a, 0x7f, 0x1a, 0x4e, 0x3b, 0x6e, 0x1a, 0x00},   // 43 1291 9ed4 Ã¦Â¦Å“
    {0x1a, 0x7f, 0x26, 0x16, 0x6b, 0x76, 0x26, 0x00},   // 43 1292 9ed5 Ã¦Â¦â€¢
    {0x1a, 0x7f, 0x0e, 0x7a, 0x79, 0x77, 0x0f, 0x00},   // 43 1293 9ed6 Ã¦Â¦Â´
    {0x1a, 0x7f, 0x0a, 0x3e, 0x3b, 0x7e, 0x4a, 0x00},   // 43 1294 9ed7 Ã¦Â§Å¾
    {0x1a, 0x7f, 0x2e, 0x7b, 0x2e, 0x7f, 0x1b, 0x00},   // 43 1295 9ed8 Ã¦Â§Â¨
    {0x5a, 0x55, 0x3e, 0x7b, 0x3e, 0x5a, 0x55, 0x00},   // 43 1296 9ed9 Ã¦Â¨â€š
    {0x1a, 0x7f, 0x11, 0x4b, 0x54, 0x29, 0x13, 0x00},   // 43 1297 9eda Ã¦Â¨â€º
    {0x1a, 0x7f, 0x5a, 0x5f, 0x7a, 0x5f, 0x5a, 0x00},   // 43 1298 9edb Ã¦Â§Â¿
    {0x1a, 0x7f, 0x26, 0x7f, 0x52, 0x7f, 0x56, 0x00},   // 43 1299 9edc Ã¦Â¬Å 
    {0x1a, 0x7f, 0x28, 0x2e, 0x77, 0x2e, 0x28, 0x00},   // 43 129a 9edd Ã¦Â§Â¹
    {0x1a, 0x7f, 0x42, 0x3d, 0x7f, 0x2a, 0x7f, 0x00},   // 43 129b 9ede Ã¦Â§Â²
    {0x5a, 0x5e, 0x3f, 0x7a, 0x37, 0x5d, 0x55, 0x00},   // 43 129c 9edf Ã¦Â§Â§
    {0x1a, 0x7f, 0x0a, 0x7d, 0x22, 0x79, 0x52, 0x00},   // 43 129d 9ee0 Ã¦Â¨â€¦
    {0x1a, 0x7f, 0x2a, 0x7e, 0x57, 0x3e, 0x4a, 0x00},   // 43 129e 9ee1 Ã¦Â¦Â±
    {0x1a, 0x7f, 0x7f, 0x71, 0x47, 0x77, 0x71, 0x00},   // 43 129f 9ee2 Ã¦Â¨Å¾
    {0x1a, 0x7f, 0x22, 0x7e, 0x2a, 0x3f, 0x52, 0x00},   // 43 12a0 9ee3 Ã¦Â§Â­
    {0x1a, 0x7f, 0x52, 0x3d, 0x7e, 0x3d, 0x50, 0x00},   // 43 12a1 9ee4 Ã¦Â¨â€
    {0x1a, 0x7f, 0x12, 0x3e, 0x5f, 0x76, 0x1a, 0x00},   // 43 12a2 9ee5 Ã¦Â§Â«
    {0x4a, 0x5f, 0x5a, 0x35, 0x5a, 0x5f, 0x4a, 0x00},   // 43 12a3 9ee6 Ã¦Â¨Å 
    {0x1a, 0x7f, 0x16, 0x6a, 0x77, 0x5a, 0x66, 0x00},   // 43 12a4 9ee7 Ã¦Â¨â€™
    {0x1a, 0x7f, 0x56, 0x5a, 0x77, 0x5a, 0x66, 0x00},   // 43 12a5 9ee8 Ã¦Â«Â
    {0x1a, 0x7f, 0x52, 0x37, 0x7e, 0x27, 0x52, 0x00},   // 43 12a6 9ee9 Ã¦Â¨Â£
    {0x1a, 0x7f, 0x54, 0x7e, 0x5b, 0x3e, 0x54, 0x00},   // 43 12a7 9eea Ã¦Â¨â€œ
    {0x1a, 0x7f, 0x3d, 0x27, 0x7d, 0x3f, 0x5e, 0x00},   // 43 12a8 9eeb Ã¦Â©â€ž
    {0x1a, 0x7f, 0x42, 0x3f, 0x3d, 0x3f, 0x42, 0x00},   // 43 12a9 9eec Ã¦Â¨Å’
    {0x1a, 0x7f, 0x12, 0x7e, 0x57, 0x7e, 0x12, 0x00},   // 43 12aa 9eed Ã¦Â©Â²
    {0x1a, 0x7f, 0x24, 0x3f, 0x7d, 0x2f, 0x5c, 0x00},   // 43 12ab 9eee Ã¦Â¨Â¶
    {0x1a, 0x7f, 0x78, 0x7f, 0x05, 0x7f, 0x78, 0x00},   // 43 12ac 9eef Ã¦Â©Â¸
    {0x1a, 0x7f, 0x70, 0x5a, 0x07, 0x7b, 0x5a, 0x00},   // 43 12ad 9ef0 Ã¦Â©â€¡
    {0x1a, 0x7f, 0x25, 0x1b, 0x7e, 0x3b, 0x7a, 0x00},   // 43 12ae 9ef1 Ã¦Â©Â¢
    {0x1a, 0x7f, 0x45, 0x5b, 0x69, 0x5a, 0x45, 0x00},   // 43 12af 9ef2 Ã¦Â©â„¢
    {0x1a, 0x7f, 0x4a, 0x5e, 0x7b, 0x5e, 0x4a, 0x00},   // 43 12b0 9ef3 Ã¦Â©Â¦
    {0x1a, 0x7f, 0x5c, 0x3e, 0x17, 0x7e, 0x5c, 0x00},   // 43 12b1 9ef4 Ã¦Â©Ë†
    {0x1a, 0x7f, 0x4b, 0x5e, 0x3b, 0x5e, 0x4b, 0x00},   // 43 12b2 9ef5 Ã¦Â¨Â¸
    {0x1a, 0x7f, 0x0a, 0x5e, 0x17, 0x56, 0x70, 0x00},   // 43 12b3 9ef6 Ã¦Â¨Â¢
    {0x1a, 0x7f, 0x3c, 0x2e, 0x75, 0x7f, 0x2c, 0x00},   // 43 12b4 9ef7 Ã¦ÂªÂ
    {0x1a, 0x7f, 0x6a, 0x3e, 0x5b, 0x5e, 0x6a, 0x00},   // 43 12b5 9ef8 Ã¦ÂªÂ
    {0x5a, 0x57, 0x36, 0x7f, 0x3a, 0x55, 0x5b, 0x00},   // 43 12b6 9ef9 Ã¦ÂªÂ 
    {0x1a, 0x7f, 0x26, 0x5f, 0x76, 0x3f, 0x5e, 0x00},   // 43 12b7 9efa Ã¦Âªâ€ž
    {0x1a, 0x7f, 0x5c, 0x36, 0x5d, 0x36, 0x5c, 0x00},   // 43 12b8 9efb Ã¦ÂªÂ¢
    {0x1a, 0x7f, 0x7a, 0x76, 0x5b, 0x76, 0x7a, 0x00},   // 43 12b9 9efc Ã¦ÂªÂ£
    {0x54, 0x5f, 0x3b, 0x70, 0x36, 0x5b, 0x56, 0x00},   // 44 12ba 9f40 Ã¦Âªâ€”
    {0x4a, 0x5e, 0x37, 0x72, 0x3f, 0x5a, 0x4e, 0x00},   // 44 12bb 9f41 Ã¨Ëœâ€”
    {0x1a, 0x7f, 0x4f, 0x69, 0x60, 0x6b, 0x4a, 0x00},   // 44 12bc 9f42 Ã¦ÂªÂ»
    {0x1a, 0x7f, 0x7f, 0x65, 0x5f, 0x5f, 0x65, 0x00},   // 44 12bd 9f43 Ã¦Â«Æ’
    {0x1a, 0x7f, 0x21, 0x7b, 0x50, 0x79, 0x53, 0x00},   // 44 12be 9f44 Ã¦Â«â€š
    {0x1a, 0x7f, 0x16, 0x5e, 0x7f, 0x1a, 0x16, 0x00},   // 44 12bf 9f45 Ã¦ÂªÂ¸
    {0x1a, 0x7f, 0x4e, 0x3a, 0x37, 0x3a, 0x46, 0x00},   // 44 12c0 9f46 Ã¦ÂªÂ³
    {0x1a, 0x7f, 0x2a, 0x5f, 0x7a, 0x2f, 0x5a, 0x00},   // 44 12c1 9f47 Ã¦ÂªÂ¬
    {0x1a, 0x7f, 0x2a, 0x75, 0x56, 0x2d, 0x77, 0x00},   // 44 12c2 9f48 Ã¦Â«Å¾
    {0x1a, 0x7f, 0x70, 0x77, 0x07, 0x77, 0x70, 0x00},   // 44 12c3 9f49 Ã¦Â«â€˜
    {0x1a, 0x7f, 0x5a, 0x35, 0x7f, 0x3a, 0x55, 0x00},   // 44 12c4 9f4a Ã¦Â«Å¸
    {0x1a, 0x7f, 0x55, 0x36, 0x79, 0x36, 0x55, 0x00},   // 44 12c5 9f4b Ã¦ÂªÂª
    {0x1a, 0x7f, 0x7f, 0x73, 0x5c, 0x57, 0x7f, 0x00},   // 44 12c6 9f4c Ã¦Â«Å¡
    {0x1a, 0x7f, 0x3f, 0x6f, 0x45, 0x6f, 0x45, 0x00},   // 44 12c7 9f4d Ã¦Â«Âª
    {0x1a, 0x7f, 0x57, 0x7b, 0x54, 0x33, 0x57, 0x00},   // 44 12c8 9f4e Ã¦Â«Â»
    {0x1a, 0x7f, 0x2e, 0x79, 0x7e, 0x3d, 0x2f, 0x00},   // 44 12c9 9f4f Ã¦Â¬â€¦
    {0x42, 0x5e, 0x37, 0x72, 0x3f, 0x5a, 0x4e, 0x00},   // 44 12ca 9f50 Ã¨Ëœâ€“
    {0x1a, 0x7f, 0x66, 0x03, 0x6f, 0x03, 0x66, 0x00},   // 44 12cb 9f51 Ã¦Â«Âº
    {0x5a, 0x55, 0x3a, 0x77, 0x37, 0x5a, 0x55, 0x00},   // 44 12cc 9f52 Ã¦Â¬â€™
    {0x1a, 0x7f, 0x47, 0x3d, 0x38, 0x7f, 0x46, 0x00},   // 44 12cd 9f53 Ã¦Â¬â€“
    {0x1a, 0x7f, 0x5e, 0x5d, 0x0e, 0x57, 0x2a, 0x00},   // 44 12ce 9f54 Ã©Â¬Â±
    {0x1a, 0x7f, 0x77, 0x7a, 0x57, 0x3f, 0x5f, 0x00},   // 44 12cf 9f55 Ã¦Â¬Å¸
    {0x56, 0x5d, 0x34, 0x56, 0x44, 0x3b, 0x46, 0x00},   // 44 12d0 9f56 Ã¦Â¬Â¸
    {0x48, 0x2d, 0x7a, 0x2d, 0x64, 0x3b, 0x46, 0x00},   // 44 12d1 9f57 Ã¦Â¬Â·
    {0x55, 0x40, 0x74, 0x7b, 0x56, 0x7a, 0x46, 0x00},   // 44 12d2 9f58 Ã§â€ºÅ“
    {0x12, 0x5a, 0x17, 0x7a, 0x44, 0x3b, 0x46, 0x00},   // 44 12d3 9f59 Ã¦Â¬Â¹
    {0x7e, 0x2d, 0x2e, 0x44, 0x43, 0x3e, 0x46, 0x00},   // 44 12d4 9f5a Ã©Â£Â®
    {0x30, 0x2f, 0x4d, 0x7f, 0x44, 0x3b, 0x46, 0x00},   // 44 12d5 9f5b Ã¦Â­â€¡
    {0x74, 0x56, 0x7e, 0x75, 0x44, 0x3b, 0x46, 0x00},   // 44 12d6 9f5c Ã¦Â­Æ’
    {0x4a, 0x2b, 0x7e, 0x3f, 0x44, 0x3b, 0x46, 0x00},   // 44 12d7 9f5d Ã¦Â­â€°
    {0x7f, 0x71, 0x47, 0x77, 0x74, 0x3b, 0x46, 0x00},   // 44 12d8 9f5e Ã¦Â­Â
    {0x2c, 0x7a, 0x2d, 0x7a, 0x44, 0x3b, 0x46, 0x00},   // 44 12d9 9f5f Ã¦Â­â„¢
    {0x7c, 0x44, 0x7f, 0x2a, 0x44, 0x3b, 0x46, 0x00},   // 44 12da 9f60 Ã¦Â­â€
    {0x5c, 0x36, 0x5d, 0x36, 0x5c, 0x3b, 0x46, 0x00},   // 44 12db 9f61 Ã¦Â­â€º
    {0x5e, 0x11, 0x1e, 0x5f, 0x44, 0x3b, 0x46, 0x00},   // 44 12dc 9f62 Ã¦Â­Å¸
    {0x26, 0x7f, 0x52, 0x7f, 0x56, 0x3b, 0x46, 0x00},   // 44 12dd 9f63 Ã¦Â­Â¡
    {0x6e, 0x7b, 0x5c, 0x18, 0x6d, 0x3f, 0x7a, 0x00},   // 44 12de 9f64 Ã¦Â­Â¸
    {0x01, 0x49, 0x49, 0x37, 0x15, 0x0d, 0x01, 0x00},   // 44 12df 9f65 Ã¦Â­Â¹
    {0x49, 0x37, 0x1d, 0x44, 0x5b, 0x2d, 0x5b, 0x00},   // 44 12e0 9f66 Ã¦Â­Â¿
    {0x49, 0x37, 0x5d, 0x4a, 0x3e, 0x49, 0x48, 0x00},   // 44 12e1 9f67 Ã¦Â®â‚¬
    {0x49, 0x37, 0x1d, 0x42, 0x55, 0x2a, 0x14, 0x00},   // 44 12e2 9f68 Ã¦Â®â€ž
    {0x49, 0x37, 0x5d, 0x4e, 0x3b, 0x4e, 0x48, 0x00},   // 44 12e3 9f69 Ã¦Â®Æ’
    {0x49, 0x37, 0x1d, 0x22, 0x6b, 0x39, 0x22, 0x00},   // 44 12e4 9f6a Ã¦Â®Â
    {0x49, 0x37, 0x1d, 0x52, 0x5b, 0x36, 0x5b, 0x00},   // 44 12e5 9f6b Ã¦Â®Ëœ
    {0x49, 0x37, 0x1d, 0x0e, 0x6b, 0x6e, 0x0a, 0x00},   // 44 12e6 9f6c Ã¦Â®â€¢
    {0x49, 0x37, 0x1d, 0x5c, 0x17, 0x17, 0x5c, 0x00},   // 44 12e7 9f6d Ã¦Â®Å¾
    {0x49, 0x37, 0x1d, 0x23, 0x5e, 0x3e, 0x72, 0x00},   // 44 12e8 9f6e Ã¦Â®Â¤
    {0x49, 0x37, 0x1d, 0x5a, 0x6a, 0x6f, 0x5a, 0x00},   // 44 12e9 9f6f Ã¦Â®Âª
    {0x49, 0x37, 0x1d, 0x23, 0x3f, 0x7c, 0x23, 0x00},   // 44 12ea 9f70 Ã¦Â®Â«
    {0x49, 0x37, 0x5f, 0x3a, 0x37, 0x3a, 0x46, 0x00},   // 44 12eb 9f71 Ã¦Â®Â¯
    {0x49, 0x37, 0x5d, 0x7e, 0x55, 0x3f, 0x55, 0x00},   // 44 12ec 9f72 Ã¦Â®Â²
    {0x49, 0x37, 0x5d, 0x7f, 0x54, 0x3f, 0x55, 0x00},   // 44 12ed 9f73 Ã¦Â®Â±
    {0x44, 0x4c, 0x5b, 0x29, 0x5f, 0x44, 0x46, 0x00},   // 44 12ee 9f74 Ã¦Â®Â³
    {0x7e, 0x2e, 0x6d, 0x00, 0x5b, 0x29, 0x5b, 0x00},   // 44 12ef 9f75 Ã¦Â®Â·
    {0x5a, 0x37, 0x76, 0x5a, 0x5b, 0x29, 0x5b, 0x00},   // 44 12f0 9f76 Ã¦Â®Â¼
    {0x7f, 0x71, 0x47, 0x77, 0x5b, 0x29, 0x5b, 0x00},   // 44 12f1 9f77 Ã¦Â¯â€ 
    {0x08, 0x3f, 0x29, 0x3f, 0x69, 0x7f, 0x28, 0x00},   // 44 12f2 9f78 Ã¦Â¯â€¹
    {0x33, 0x2e, 0x7e, 0x12, 0x6e, 0x0b, 0x6a, 0x00},   // 44 12f3 9f79 Ã¦Â¯â€œ
    {0x24, 0x2a, 0x28, 0x7f, 0x54, 0x52, 0x64, 0x00},   // 44 12f4 9f7a Ã¦Â¯Å¸
    {0x2a, 0x7e, 0x55, 0x6a, 0x52, 0x7f, 0x6a, 0x00},   // 44 12f5 9f7b Ã¦Â¯Â¬
    {0x1a, 0x2e, 0x3a, 0x7b, 0x7a, 0x6e, 0x5a, 0x00},   // 44 12f6 9f7c Ã¦Â¯Â«
    {0x24, 0x74, 0x55, 0x0f, 0x2b, 0x7a, 0x52, 0x00},   // 44 12f7 9f7d Ã¦Â¯Â³
    {0x2a, 0x7e, 0x55, 0x6a, 0x68, 0x57, 0x6a, 0x00},   // 44 12f8 9f7e Ã¦Â¯Â¯
    {0x40, 0x3e, 0x2a, 0x2e, 0x7b, 0x5e, 0x4a, 0x00},   // 45 12f9 9f80 Ã©ÂºÂ¾
    {0x4e, 0x7e, 0x7b, 0x4e, 0x2a, 0x7e, 0x55, 0x00},   // 45 12fa 9f81 Ã¦Â°Ë†
    {0x1e, 0x23, 0x32, 0x7f, 0x55, 0x3d, 0x57, 0x00},   // 45 12fb 9f82 Ã¦Â°â€œ
    {0x04, 0x0b, 0x0e, 0x0e, 0x0e, 0x3a, 0x42, 0x00},   // 45 12fc 9f83 Ã¦Â°â€
    {0x14, 0x4b, 0x2e, 0x6e, 0x1e, 0x3a, 0x42, 0x00},   // 45 12fd 9f84 Ã¦Â°â€º
    {0x0c, 0x7b, 0x6e, 0x5e, 0x7e, 0x3a, 0x42, 0x00},   // 45 12fe 9f85 Ã¦Â°Â¤
    {0x54, 0x2b, 0x7e, 0x2e, 0x5e, 0x3a, 0x42, 0x00},   // 45 12ff 9f86 Ã¦Â°Â£
    {0x54, 0x35, 0x45, 0x7f, 0x15, 0x25, 0x54, 0x00},   // 45 1300 9f87 Ã¦Â±Å¾
    {0x75, 0x00, 0x7c, 0x40, 0x7f, 0x40, 0x7c, 0x00},   // 45 1301 9f88 Ã¦Â±â€¢
    {0x65, 0x10, 0x40, 0x44, 0x7f, 0x44, 0x40, 0x00},   // 45 1302 9f89 Ã¦Â±Â¢
    {0x65, 0x10, 0x41, 0x49, 0x7f, 0x49, 0x41, 0x00},   // 45 1303 9f8a Ã¦Â±Âª
    {0x65, 0x10, 0x40, 0x3e, 0x0a, 0x79, 0x08, 0x00},   // 45 1304 9f8b Ã¦Â²â€š
    {0x65, 0x10, 0x41, 0x59, 0x57, 0x75, 0x4d, 0x00},   // 45 1305 9f8c Ã¦Â²Â
    {0x65, 0x10, 0x40, 0x7c, 0x40, 0x7f, 0x44, 0x00},   // 45 1306 9f8d Ã¦Â²Å¡
    {0x75, 0x20, 0x18, 0x7d, 0x42, 0x68, 0x10, 0x00},   // 45 1307 9f8e Ã¦Â²Â
    {0x75, 0x00, 0x3a, 0x0a, 0x7f, 0x0a, 0x3a, 0x00},   // 45 1308 9f8f Ã¦Â²â€º
    {0x65, 0x10, 0x44, 0x3b, 0x48, 0x7b, 0x04, 0x00},   // 45 1309 9f90 Ã¦Â±Â¾
    {0x75, 0x00, 0x7f, 0x49, 0x49, 0x49, 0x7f, 0x00},   // 45 130a 9f91 Ã¦Â±Â¨
    {0x75, 0x40, 0x3f, 0x45, 0x5d, 0x25, 0x5d, 0x00},   // 45 130b 9f92 Ã¦Â±Â³
    {0x65, 0x10, 0x44, 0x5b, 0x29, 0x5d, 0x47, 0x00},   // 45 130c 9f93 Ã¦Â²â€™
    {0x75, 0x00, 0x22, 0x1a, 0x7f, 0x1a, 0x22, 0x00},   // 45 130d 9f94 Ã¦Â²Â
    {0x75, 0x00, 0x7f, 0x44, 0x5f, 0x54, 0x5f, 0x00},   // 45 130e 9f95 Ã¦Â³â€ž
    {0x75, 0x00, 0x48, 0x4e, 0x3b, 0x4e, 0x48, 0x00},   // 45 130f 9f96 Ã¦Â³Â±
    {0x75, 0x00, 0x5d, 0x77, 0x70, 0x4f, 0x60, 0x00},   // 45 1310 9f97 Ã¦Â³â€œ
    {0x65, 0x10, 0x04, 0x74, 0x5f, 0x74, 0x04, 0x00},   // 45 1311 9f98 Ã¦Â²Â½
    {0x75, 0x00, 0x7f, 0x4f, 0x41, 0x4f, 0x7f, 0x00},   // 45 1312 9f99 Ã¦Â³â€”
    {0x75, 0x00, 0x7f, 0x51, 0x4d, 0x51, 0x7f, 0x00},   // 45 1313 9f9a Ã¦Â³â€¦
    {0x65, 0x10, 0x40, 0x3e, 0x1a, 0x79, 0x28, 0x00},   // 45 1314 9f9b Ã¦Â³Â
    {0x65, 0x10, 0x40, 0x7f, 0x55, 0x7f, 0x40, 0x00},   // 45 1315 9f9c Ã¦Â²Â®
    {0x65, 0x10, 0x06, 0x7a, 0x53, 0x4a, 0x66, 0x00},   // 45 1316 9f9d Ã¦Â²Â±
    {0x75, 0x00, 0x70, 0x50, 0x5f, 0x54, 0x74, 0x00},   // 45 1317 9f9e Ã¦Â²Â¾
    {0x75, 0x00, 0x7f, 0x49, 0x7f, 0x49, 0x7f, 0x00},   // 45 1318 9f9f Ã¦Â²Âº
    {0x75, 0x40, 0x35, 0x25, 0x57, 0x4d, 0x40, 0x00},   // 45 1319 9fa0 Ã¦Â³â€º
    {0x75, 0x00, 0x7f, 0x55, 0x1d, 0x37, 0x50, 0x00},   // 45 131a 9fa1 Ã¦Â³Â¯
    {0x75, 0x00, 0x15, 0x13, 0x7f, 0x13, 0x15, 0x00},   // 45 131b 9fa2 Ã¦Â³â„¢
    {0x75, 0x00, 0x7f, 0x55, 0x55, 0x55, 0x7f, 0x00},   // 45 131c 9fa3 Ã¦Â³Âª
    {0x75, 0x02, 0x5e, 0x56, 0x3f, 0x56, 0x72, 0x00},   // 45 131d 9fa4 Ã¦Â´Å¸
    {0x0a, 0x7d, 0x00, 0x65, 0x10, 0x45, 0x7d, 0x00},   // 45 131e 9fa5 Ã¨Â¡Â
    {0x65, 0x10, 0x04, 0x37, 0x2a, 0x36, 0x7e, 0x00},   // 45 131f 9fa6 Ã¦Â´Â¶
    {0x75, 0x40, 0x7e, 0x43, 0x7e, 0x42, 0x7e, 0x00},   // 45 1320 9fa7 Ã¦Â´Â«
    {0x65, 0x10, 0x04, 0x72, 0x55, 0x76, 0x04, 0x00},   // 45 1321 9fa8 Ã¦Â´Â½
    {0x75, 0x00, 0x4a, 0x3c, 0x0f, 0x7c, 0x4a, 0x00},   // 45 1322 9fa9 Ã¦Â´Â¸
    {0x75, 0x00, 0x4c, 0x2b, 0x7f, 0x2a, 0x48, 0x00},   // 45 1323 9faa Ã¦Â´â„¢
    {0x65, 0x10, 0x04, 0x7f, 0x56, 0x7e, 0x7e, 0x00},   // 45 1324 9fab Ã¦Â´Âµ
    {0x75, 0x5c, 0x37, 0x2c, 0x7e, 0x42, 0x7e, 0x00},   // 45 1325 9fac Ã¦Â´Â³
    {0x75, 0x00, 0x7d, 0x5f, 0x45, 0x5f, 0x7d, 0x00},   // 45 1326 9fad Ã¦Â´â€™
    {0x75, 0x00, 0x49, 0x37, 0x1d, 0x4e, 0x7f, 0x00},   // 45 1327 9fae Ã¦Â´Å’
    {0x75, 0x00, 0x56, 0x3a, 0x1b, 0x7a, 0x56, 0x00},   // 45 1328 9faf Ã¦ÂµÂ£
    {0x75, 0x00, 0x78, 0x2b, 0x2b, 0x2b, 0x78, 0x00},   // 45 1329 9fb0 Ã¦Â¶â€œ
    {0x75, 0x48, 0x2e, 0x5a, 0x6f, 0x5a, 0x6e, 0x00},   // 45 132a 9fb1 Ã¦ÂµÂ¤
    {0x75, 0x00, 0x2a, 0x57, 0x32, 0x5e, 0x4b, 0x00},   // 45 132b 9fb2 Ã¦ÂµÅ¡
    {0x75, 0x00, 0x52, 0x4e, 0x3f, 0x4e, 0x52, 0x00},   // 45 132c 9fb3 Ã¦ÂµÂ¹
    {0x75, 0x00, 0x52, 0x7f, 0x3e, 0x0a, 0x79, 0x00},   // 45 132d 9fb4 Ã¦Âµâ„¢
    {0x75, 0x00, 0x55, 0x3b, 0x52, 0x5e, 0x55, 0x00},   // 45 132e 9fb5 Ã¦Â¶Å½
    {0x75, 0x00, 0x5a, 0x2b, 0x7e, 0x2b, 0x6e, 0x00},   // 45 132f 9fb6 Ã¦Â¶â€¢
    {0x75, 0x00, 0x34, 0x36, 0x5f, 0x76, 0x14, 0x00},   // 45 1330 9fb7 Ã¦Â¿Â¤
    {0x65, 0x10, 0x47, 0x55, 0x7d, 0x55, 0x47, 0x00},   // 45 1331 9fb8 Ã¦Â¶â€¦
    {0x75, 0x00, 0x0a, 0x36, 0x3b, 0x76, 0x4a, 0x00},   // 45 1332 9fb9 Ã¦Â·Â¹
    {0x75, 0x00, 0x55, 0x3c, 0x55, 0x0e, 0x7f, 0x00},   // 45 1333 9fba Ã¦Â¸â€¢
    {0x75, 0x40, 0x3f, 0x2a, 0x7f, 0x2a, 0x7f, 0x00},   // 45 1334 9fbb Ã¦Â¸Å 
    {0x75, 0x00, 0x7d, 0x5b, 0x7f, 0x59, 0x7d, 0x00},   // 45 1335 9fbc Ã¦Â¶Âµ
    {0x75, 0x00, 0x52, 0x1f, 0x1a, 0x1f, 0x52, 0x00},   // 45 1336 9fbd Ã¦Â·â€¡
    {0x75, 0x00, 0x54, 0x76, 0x7d, 0x76, 0x54, 0x00},   // 45 1337 9fbe Ã¦Â·Â¦
    {0x75, 0x00, 0x7f, 0x75, 0x6f, 0x75, 0x7f, 0x00},   // 45 1338 9fbf Ã¦Â¶Â¸
    {0x75, 0x28, 0x18, 0x7d, 0x2a, 0x7d, 0x08, 0x00},   // 45 1339 9fc0 Ã¦Â·â€ 
    {0x75, 0x00, 0x32, 0x2e, 0x73, 0x2e, 0x32, 0x00},   // 45 133a 9fc1 Ã¦Â·Â¬
    {0x75, 0x1a, 0x7f, 0x0a, 0x63, 0x58, 0x63, 0x00},   // 45 133b 9fc2 Ã¦Â·Å¾
    {0x75, 0x00, 0x7a, 0x09, 0x6e, 0x69, 0x7a, 0x00},   // 45 133c 9fc3 Ã¦Â·Å’
    {0x75, 0x00, 0x2a, 0x29, 0x7b, 0x39, 0x12, 0x00},   // 45 133d 9fc4 Ã¦Â·Â¨
    {0x75, 0x00, 0x52, 0x7a, 0x5f, 0x3e, 0x52, 0x00},   // 45 133e 9fc5 Ã¦Â·â€™
    {0x75, 0x00, 0x1a, 0x7f, 0x3e, 0x0a, 0x79, 0x00},   // 45 133f 9fc6 Ã¦Â·â€¦
    {0x75, 0x00, 0x12, 0x5a, 0x5b, 0x36, 0x5b, 0x00},   // 45 1340 9fc7 Ã¦Â·Âº
    {0x75, 0x00, 0x56, 0x1a, 0x7b, 0x1a, 0x56, 0x00},   // 45 1341 9fc8 Ã¦Â·â„¢
    {0x75, 0x00, 0x62, 0x1f, 0x7a, 0x29, 0x52, 0x00},   // 45 1342 9fc9 Ã¦Â·Â¤
    {0x75, 0x00, 0x54, 0x4e, 0x67, 0x5e, 0x54, 0x00},   // 45 1343 9fca Ã¦Â·â€¢
    {0x75, 0x00, 0x74, 0x32, 0x75, 0x36, 0x74, 0x00},   // 45 1344 9fcb Ã¦Â·Âª
    {0x65, 0x10, 0x04, 0x7f, 0x4a, 0x7f, 0x4a, 0x00},   // 45 1345 9fcc Ã¦Â·Â®
    {0x75, 0x00, 0x0f, 0x7d, 0x2f, 0x7d, 0x0f, 0x00},   // 45 1346 9fcd Ã¦Â¸Â­
    {0x75, 0x00, 0x5d, 0x5f, 0x75, 0x5f, 0x5d, 0x00},   // 45 1347 9fce Ã¦Â¹Â®
    {0x75, 0x00, 0x0a, 0x6f, 0x6a, 0x0f, 0x7a, 0x00},   // 45 1348 9fcf Ã¦Â¸Â®
    {0x75, 0x00, 0x52, 0x5d, 0x3d, 0x5f, 0x50, 0x00},   // 45 1349 9fd0 Ã¦Â¸â„¢
    {0x65, 0x10, 0x42, 0x29, 0x5b, 0x29, 0x5a, 0x00},   // 45 134a 9fd1 Ã¦Â¹Â²
    {0x75, 0x00, 0x50, 0x5e, 0x7b, 0x5e, 0x50, 0x00},   // 45 134b 9fd2 Ã¦Â¹Å¸
    {0x75, 0x00, 0x27, 0x3d, 0x7f, 0x3d, 0x27, 0x00},   // 45 134c 9fd3 Ã¦Â¸Â¾
    {0x75, 0x00, 0x4a, 0x76, 0x7f, 0x76, 0x4a, 0x00},   // 45 134d 9fd4 Ã¦Â¸Â£
    {0x75, 0x00, 0x35, 0x7f, 0x4c, 0x3f, 0x44, 0x00},   // 45 134e 9fd5 Ã¦Â¹Â«
    {0x75, 0x02, 0x5f, 0x32, 0x77, 0x36, 0x57, 0x00},   // 45 134f 9fd6 Ã¦Â¸Â«
    {0x75, 0x00, 0x50, 0x3e, 0x7b, 0x2e, 0x50, 0x00},   // 45 1350 9fd7 Ã¦Â¹Â¶
    {0x75, 0x00, 0x6b, 0x3a, 0x6b, 0x2a, 0x6b, 0x00},   // 45 1351 9fd8 Ã¦Â¹Â
    {0x75, 0x18, 0x0a, 0x5e, 0x7b, 0x1e, 0x1a, 0x00},   // 45 1352 9fd9 Ã¦Â¸Å¸
    {0x75, 0x00, 0x4a, 0x3e, 0x15, 0x7f, 0x15, 0x00},   // 45 1353 9fda Ã¦Â¹Æ’
    {0x75, 0x00, 0x7f, 0x55, 0x7f, 0x46, 0x2f, 0x00},   // 45 1354 9fdb Ã¦Â¸Âº
    {0x75, 0x00, 0x7d, 0x7d, 0x57, 0x7d, 0x7d, 0x00},   // 45 1355 9fdc Ã¦Â¹Å½
    {0x75, 0x0c, 0x26, 0x77, 0x2e, 0x1f, 0x7e, 0x00},   // 45 1356 9fdd Ã¦Â¸Â¤
    {0x75, 0x00, 0x7a, 0x3f, 0x7a, 0x3f, 0x7a, 0x00},   // 45 1357 9fde Ã¦Â»Â¿
    {0x75, 0x00, 0x75, 0x33, 0x75, 0x26, 0x54, 0x00},   // 45 1358 9fdf Ã¦Â¸Â
    {0x75, 0x62, 0x1f, 0x7a, 0x27, 0x76, 0x2e, 0x00},   // 45 1359 9fe0 Ã¦Â¸Â¸
    {0x75, 0x42, 0x2e, 0x7f, 0x2a, 0x4e, 0x7f, 0x00},   // 45 135a 9fe1 Ã¦Âºâ€š
    {0x75, 0x00, 0x52, 0x55, 0x3b, 0x51, 0x52, 0x00},   // 45 135b 9fe2 Ã¦ÂºÂª
    {0x75, 0x00, 0x54, 0x7e, 0x77, 0x6e, 0x54, 0x00},   // 45 135c 9fe3 Ã¦ÂºËœ
    {0x75, 0x00, 0x54, 0x33, 0x1f, 0x73, 0x54, 0x00},   // 45 135d 9fe4 Ã¦Â»â€°
    {0x75, 0x00, 0x7f, 0x6b, 0x77, 0x5b, 0x7f, 0x00},   // 45 135e 9fe5 Ã¦ÂºÂ·
    {0x75, 0x26, 0x2a, 0x3a, 0x6f, 0x3a, 0x2e, 0x00},   // 45 135f 9fe6 Ã¦Â»â€œ
    {0x75, 0x08, 0x17, 0x3d, 0x57, 0x7f, 0x15, 0x00},   // 45 1360 9fe7 Ã¦ÂºÂ½
    {0x75, 0x02, 0x2f, 0x1a, 0x4f, 0x3f, 0x7f, 0x00},   // 45 1361 9fe8 Ã¦ÂºÂ¯
    {0x75, 0x00, 0x24, 0x1e, 0x6d, 0x62, 0x04, 0x00},   // 45 1362 9fe9 Ã¦Â»â€ž
    {0x75, 0x00, 0x4e, 0x59, 0x2e, 0x59, 0x4f, 0x00},   // 45 1363 9fea Ã¦ÂºÂ²
    {0x75, 0x00, 0x72, 0x69, 0x43, 0x69, 0x7a, 0x00},   // 45 1364 9feb Ã¦Â»â€
    {0x7f, 0x15, 0x7f, 0x2d, 0x76, 0x2d, 0x56, 0x00},   // 45 1365 9fec Ã¦Â»â€¢
    {0x75, 0x40, 0x3e, 0x12, 0x77, 0x5e, 0x6a, 0x00},   // 45 1366 9fed Ã¦ÂºÂ
    {0x75, 0x00, 0x12, 0x3e, 0x57, 0x7e, 0x13, 0x00},   // 45 1367 9fee Ã¦ÂºÂ¥
    {0x75, 0x00, 0x1a, 0x4e, 0x3b, 0x6e, 0x1a, 0x00},   // 45 1368 9fef Ã¦Â»â€š
    {0x75, 0x00, 0x53, 0x1d, 0x15, 0x1d, 0x53, 0x00},   // 45 1369 9ff0 Ã¦ÂºÅ¸
    {0x57, 0x3a, 0x7a, 0x29, 0x5d, 0x17, 0x5d, 0x00},   // 45 136a 9ff1 Ã¦Â½Â
    {0x75, 0x00, 0x7f, 0x2e, 0x49, 0x3f, 0x4f, 0x00},   // 45 136b 9ff2 Ã¦Â¼â€˜
    {0x75, 0x00, 0x26, 0x7f, 0x52, 0x7f, 0x56, 0x00},   // 45 136c 9ff3 Ã§ÂÅ’
    {0x75, 0x40, 0x3f, 0x7b, 0x5f, 0x5f, 0x5b, 0x00},   // 45 136d 9ff4 Ã¦Â»Â¬
    {0x75, 0x02, 0x6b, 0x6a, 0x17, 0x7e, 0x12, 0x00},   // 45 136e 9ff5 Ã¦Â»Â¸
    {0x75, 0x02, 0x2a, 0x7e, 0x5b, 0x26, 0x4a, 0x00},   // 45 136f 9ff6 Ã¦Â»Â¾
    {0x4b, 0x56, 0x3f, 0x74, 0x26, 0x5d, 0x47, 0x00},   // 45 1370 9ff7 Ã¦Â¼Â¿
    {0x75, 0x00, 0x1a, 0x4f, 0x5a, 0x2d, 0x1a, 0x00},   // 45 1371 9ff8 Ã¦Â»Â²
    {0x75, 0x42, 0x2e, 0x7f, 0x4e, 0x3b, 0x46, 0x00},   // 45 1372 9ff9 Ã¦Â¼Â±
    {0x75, 0x00, 0x3a, 0x17, 0x7a, 0x17, 0x3a, 0x00},   // 45 1373 9ffa Ã¦Â»Â¯
    {0x75, 0x00, 0x5d, 0x77, 0x70, 0x3f, 0x55, 0x00},   // 45 1374 9ffb Ã¦Â¼Â²
    {0x75, 0x0c, 0x7f, 0x3e, 0x2b, 0x76, 0x2a, 0x00},   // 45 1375 9ffc Ã¦Â»Å’
    {0x75, 0x00, 0x52, 0x37, 0x7e, 0x27, 0x52, 0x00},   // 46 1376 e040 Ã¦Â¼Â¾
    {0x75, 0x00, 0x72, 0x5e, 0x7b, 0x3e, 0x72, 0x00},   // 46 1377 e041 Ã¦Â¼â€œ
    {0x75, 0x00, 0x7c, 0x6c, 0x57, 0x6e, 0x7a, 0x00},   // 46 1378 e042 Ã¦Â»Â·
    {0x75, 0x00, 0x5c, 0x3e, 0x17, 0x7e, 0x5c, 0x00},   // 46 1379 e043 Ã¦Â¾â€ 
    {0x75, 0x40, 0x3f, 0x53, 0x3b, 0x57, 0x33, 0x00},   // 46 137a e044 Ã¦Â½Âº
    {0x75, 0x00, 0x0a, 0x77, 0x3a, 0x77, 0x0a, 0x00},   // 46 137b e045 Ã¦Â½Â¸
    {0x75, 0x48, 0x78, 0x5e, 0x08, 0x7f, 0x5a, 0x00},   // 46 137c e046 Ã¦Â¾Â
    {0x75, 0x40, 0x7d, 0x53, 0x05, 0x7b, 0x57, 0x00},   // 46 137d e047 Ã¦Â¾â‚¬
    {0x75, 0x00, 0x14, 0x3d, 0x57, 0x7f, 0x1a, 0x00},   // 46 137e e048 Ã¦Â½Â¯
    {0x75, 0x00, 0x14, 0x6f, 0x76, 0x6f, 0x16, 0x00},   // 46 137f e049 Ã¦Â½â€º
    {0x75, 0x00, 0x17, 0x6e, 0x77, 0x6e, 0x16, 0x00},   // 46 1380 e04a Ã¦Â¿Â³
    {0x75, 0x00, 0x21, 0x3b, 0x6b, 0x3b, 0x21, 0x00},   // 46 1381 e04b Ã¦Â½Â­
    {0x75, 0x00, 0x56, 0x77, 0x56, 0x3f, 0x5e, 0x00},   // 46 1382 e04c Ã¦Â¾â€š
    {0x75, 0x00, 0x4a, 0x5e, 0x7b, 0x5e, 0x4a, 0x00},   // 46 1383 e04d Ã¦Â½Â¼
    {0x75, 0x00, 0x15, 0x6f, 0x7d, 0x6f, 0x15, 0x00},   // 46 1384 e04e Ã¦Â½Ëœ
    {0x75, 0x00, 0x5a, 0x6f, 0x5a, 0x4a, 0x25, 0x00},   // 46 1385 e04f Ã¦Â¾Å½
    {0x75, 0x00, 0x7d, 0x5f, 0x71, 0x5f, 0x7d, 0x00},   // 46 1386 e050 Ã¦Â¾â€˜
    {0x75, 0x3e, 0x52, 0x36, 0x7f, 0x3e, 0x5a, 0x00},   // 46 1387 e051 Ã¦Â¿â€š
    {0x75, 0x00, 0x4a, 0x1e, 0x6b, 0x1e, 0x4a, 0x00},   // 46 1388 e052 Ã¦Â½Â¦
    {0x75, 0x00, 0x50, 0x5e, 0x3f, 0x56, 0x5e, 0x00},   // 46 1389 e053 Ã¦Â¾Â³
    {0x75, 0x00, 0x2d, 0x7f, 0x2a, 0x79, 0x2a, 0x00},   // 46 138a e054 Ã¦Â¾Â£
    {0x75, 0x00, 0x5c, 0x37, 0x7d, 0x37, 0x5c, 0x00},   // 46 138b e055 Ã¦Â¾Â¡
    {0x75, 0x00, 0x2b, 0x3b, 0x6f, 0x3b, 0x2b, 0x00},   // 46 138c e056 Ã¦Â¾Â¤
    {0x75, 0x00, 0x7c, 0x2e, 0x75, 0x7f, 0x2c, 0x00},   // 46 138d e057 Ã¦Â¾Â¹
    {0x75, 0x00, 0x4a, 0x3e, 0x2b, 0x3e, 0x4a, 0x00},   // 46 138e e058 Ã¦Â¿â€ 
    {0x75, 0x00, 0x16, 0x1b, 0x77, 0x1b, 0x36, 0x00},   // 46 138f e059 Ã¦Â¾Âª
    {0x75, 0x00, 0x4a, 0x36, 0x2b, 0x76, 0x0a, 0x00},   // 46 1390 e05a Ã¦Â¿Å¸
    {0x75, 0x00, 0x5b, 0x17, 0x43, 0x1b, 0x57, 0x00},   // 46 1391 e05b Ã¦Â¿â€¢
    {0x75, 0x00, 0x2c, 0x14, 0x6f, 0x76, 0x2e, 0x00},   // 46 1392 e05c Ã¦Â¿Â¬
    {0x75, 0x00, 0x7d, 0x2b, 0x7f, 0x2b, 0x7d, 0x00},   // 46 1393 e05d Ã¦Â¿â€
    {0x75, 0x00, 0x16, 0x5e, 0x7f, 0x1a, 0x16, 0x00},   // 46 1394 e05e Ã¦Â¿Ëœ
    {0x75, 0x00, 0x4e, 0x3a, 0x37, 0x3a, 0x46, 0x00},   // 46 1395 e05f Ã¦Â¿Â±
    {0x75, 0x0c, 0x7f, 0x5e, 0x3b, 0x5e, 0x4b, 0x00},   // 46 1396 e060 Ã¦Â¿Â®
    {0x75, 0x18, 0x2a, 0x5f, 0x7a, 0x2f, 0x5a, 0x00},   // 46 1397 e061 Ã¦Â¿â€º
    {0x75, 0x00, 0x26, 0x5a, 0x17, 0x5e, 0x76, 0x00},   // 46 1398 e062 Ã§â‚¬â€°
    {0x75, 0x00, 0x56, 0x3a, 0x77, 0x7a, 0x36, 0x00},   // 46 1399 e063 Ã§â‚¬â€¹
    {0x75, 0x00, 0x5f, 0x1f, 0x5a, 0x37, 0x5a, 0x00},   // 46 139a e064 Ã¦Â¿Âº
    {0x75, 0x00, 0x5b, 0x2f, 0x7b, 0x2f, 0x5b, 0x00},   // 46 139b e065 Ã§â‚¬â€˜
    {0x75, 0x28, 0x1a, 0x7b, 0x3e, 0x5b, 0x2a, 0x00},   // 46 139c e066 Ã§â‚¬Â
    {0x75, 0x00, 0x26, 0x55, 0x6a, 0x57, 0x7f, 0x00},   // 46 139d e067 Ã§â‚¬Â
    {0x75, 0x40, 0x3c, 0x64, 0x3f, 0x5a, 0x6a, 0x00},   // 46 139e e068 Ã¦Â¿Â¾
    {0x75, 0x42, 0x3e, 0x5a, 0x2b, 0x7a, 0x4a, 0x00},   // 46 139f e069 Ã§â‚¬â€º
    {0x75, 0x00, 0x2d, 0x7f, 0x2a, 0x19, 0x7a, 0x00},   // 46 13a0 e06a Ã§â‚¬Å¡
    {0x75, 0x00, 0x55, 0x3e, 0x1a, 0x6f, 0x6a, 0x00},   // 46 13a1 e06b Ã¦Â½Â´
    {0x75, 0x40, 0x3f, 0x6f, 0x45, 0x6f, 0x45, 0x00},   // 46 13a2 e06c Ã§â‚¬Â
    {0x75, 0x40, 0x3c, 0x44, 0x6f, 0x6a, 0x4a, 0x00},   // 46 13a3 e06d Ã§â‚¬Ëœ
    {0x75, 0x48, 0x3a, 0x6f, 0x06, 0x6f, 0x7a, 0x00},   // 46 13a4 e06e Ã§â‚¬Å¸
    {0x75, 0x00, 0x5d, 0x77, 0x7d, 0x2b, 0x7d, 0x00},   // 46 13a5 e06f Ã§â‚¬Â°
    {0x75, 0x00, 0x7f, 0x2b, 0x7c, 0x2b, 0x7f, 0x00},   // 46 13a6 e070 Ã§â‚¬Â¾
    {0x75, 0x3c, 0x56, 0x3d, 0x56, 0x3f, 0x5e, 0x00},   // 46 13a7 e071 Ã§â‚¬Â²
    {0x75, 0x20, 0x7f, 0x55, 0x1e, 0x7d, 0x57, 0x00},   // 46 13a8 e072 Ã§Ââ€˜
    {0x75, 0x00, 0x0a, 0x3d, 0x2f, 0x2a, 0x6d, 0x00},   // 46 13a9 e073 Ã§ÂÂ£
    {0x48, 0x5a, 0x2a, 0x15, 0x25, 0x53, 0x40, 0x00},   // 46 13aa e074 Ã§â€šâ„¢
    {0x4c, 0x3f, 0x24, 0x46, 0x5f, 0x22, 0x14, 0x00},   // 46 13ab e075 Ã§â€šâ€™
    {0x4c, 0x3f, 0x7f, 0x1d, 0x15, 0x5d, 0x7f, 0x00},   // 46 13ac e076 Ã§â€šÂ¯
    {0x4c, 0x3f, 0x7f, 0x3b, 0x29, 0x3b, 0x7f, 0x00},   // 46 13ad e077 Ã§Æ’Â±
    {0x4c, 0x3f, 0x24, 0x7f, 0x55, 0x55, 0x5d, 0x00},   // 46 13ae e078 Ã§â€šÂ¬
    {0x4c, 0x3f, 0x24, 0x03, 0x7e, 0x2a, 0x2a, 0x00},   // 46 13af e079 Ã§â€šÂ¸
    {0x4c, 0x3f, 0x7d, 0x15, 0x0f, 0x55, 0x7d, 0x00},   // 46 13b0 e07a Ã§â€šÂ³
    {0x4c, 0x3f, 0x24, 0x04, 0x7b, 0x5a, 0x5e, 0x00},   // 46 13b1 e07b Ã§â€šÂ®
    {0x4c, 0x3f, 0x7f, 0x55, 0x4f, 0x55, 0x7f, 0x00},   // 46 13b2 e07c Ã§Æ’Å¸
    {0x44, 0x1e, 0x53, 0x0a, 0x5f, 0x0a, 0x52, 0x00},   // 46 13b3 e07d Ã§Æ’â€¹
    {0x54, 0x2d, 0x61, 0x3d, 0x63, 0x29, 0x54, 0x00},   // 46 13b4 e07e Ã§Æ’Â
    {0x4c, 0x3f, 0x10, 0x6a, 0x65, 0x6b, 0x10, 0x00},   // 47 13b5 e080 Ã§Æ’â„¢
    {0x49, 0x1d, 0x59, 0x1f, 0x5b, 0x1b, 0x79, 0x00},   // 47 13b6 e081 Ã§â€žâ€°
    {0x4c, 0x3f, 0x2c, 0x2a, 0x75, 0x2b, 0x28, 0x00},   // 47 13b7 e082 Ã§Æ’Â½
    {0x4c, 0x3f, 0x7f, 0x55, 0x05, 0x7d, 0x57, 0x00},   // 47 13b8 e083 Ã§â€žÅ“
    {0x4c, 0x3f, 0x0a, 0x6e, 0x6b, 0x6e, 0x0a, 0x00},   // 47 13b9 e084 Ã§â€žâ„¢
    {0x4c, 0x3f, 0x52, 0x5d, 0x3d, 0x5f, 0x50, 0x00},   // 47 13ba e085 Ã§â€¦Â¥
    {0x5f, 0x11, 0x5b, 0x15, 0x40, 0x1f, 0x57, 0x00},   // 47 13bb e086 Ã§â€¦â€¢
    {0x50, 0x0f, 0x5f, 0x1f, 0x40, 0x1f, 0x57, 0x00},   // 47 13bc e087 Ã§â€ Ë†
    {0x5f, 0x15, 0x5f, 0x04, 0x5b, 0x1a, 0x5e, 0x00},   // 47 13bd e088 Ã§â€¦Â¦
    {0x0d, 0x26, 0x2d, 0x7c, 0x2d, 0x3e, 0x4d, 0x00},   // 47 13be e089 Ã§â€¦Â¢
    {0x4c, 0x3f, 0x50, 0x5e, 0x7b, 0x5e, 0x50, 0x00},   // 47 13bf e08a Ã§â€¦Å’
    {0x4c, 0x3f, 0x42, 0x29, 0x5b, 0x29, 0x5a, 0x00},   // 47 13c0 e08b Ã§â€¦â€“
    {0x4c, 0x3f, 0x24, 0x5f, 0x35, 0x57, 0x74, 0x00},   // 47 13c1 e08c Ã§â€¦Â¬
    {0x52, 0x1e, 0x5f, 0x1f, 0x5f, 0x1e, 0x52, 0x00},   // 47 13c2 e08d Ã§â€ Â
    {0x4c, 0x3f, 0x52, 0x1f, 0x5f, 0x1f, 0x52, 0x00},   // 47 13c3 e08e Ã§â€¡Â»
    {0x4c, 0x3f, 0x60, 0x2e, 0x4f, 0x4e, 0x60, 0x00},   // 47 13c4 e08f Ã§â€ â€ž
    {0x4c, 0x3f, 0x44, 0x3d, 0x3f, 0x3d, 0x44, 0x00},   // 47 13c5 e090 Ã§â€ â€¢
    {0x48, 0x57, 0x2f, 0x13, 0x26, 0x5a, 0x4f, 0x00},   // 47 13c6 e091 Ã§â€ Â¨
    {0x54, 0x0e, 0x5f, 0x06, 0x54, 0x0b, 0x56, 0x00},   // 47 13c7 e092 Ã§â€ Â¬
    {0x4c, 0x3f, 0x7f, 0x23, 0x18, 0x3b, 0x7f, 0x00},   // 47 13c8 e093 Ã§â€¡â€”
    {0x4a, 0x3a, 0x6e, 0x2f, 0x6e, 0x3a, 0x4a, 0x00},   // 47 13c9 e094 Ã§â€ Â¹
    {0x4c, 0x3f, 0x4a, 0x6f, 0x6e, 0x3f, 0x55, 0x00},   // 47 13ca e095 Ã§â€ Â¾
    {0x4c, 0x3f, 0x5c, 0x3e, 0x17, 0x7e, 0x5c, 0x00},   // 47 13cb e096 Ã§â€¡â€™
    {0x4c, 0x3f, 0x2e, 0x7b, 0x56, 0x3f, 0x5e, 0x00},   // 47 13cc e097 Ã§â€¡â€°
    {0x4c, 0x3f, 0x15, 0x6f, 0x7d, 0x6f, 0x15, 0x00},   // 47 13cd e098 Ã§â€¡â€
    {0x4c, 0x3f, 0x4a, 0x1e, 0x6b, 0x1e, 0x4a, 0x00},   // 47 13ce e099 Ã§â€¡Å½
    {0x4c, 0x3f, 0x50, 0x5e, 0x3f, 0x56, 0x5e, 0x00},   // 47 13cf e09a Ã§â€¡Â 
    {0x4c, 0x3f, 0x56, 0x7d, 0x57, 0x29, 0x5b, 0x00},   // 47 13d0 e09b Ã§â€¡Â¬
    {0x4c, 0x3f, 0x65, 0x52, 0x6d, 0x7d, 0x56, 0x00},   // 47 13d1 e09c Ã§â€¡Â§
    {0x4c, 0x3f, 0x69, 0x54, 0x5e, 0x77, 0x5e, 0x00},   // 47 13d2 e09d Ã§â€¡Âµ
    {0x4c, 0x3f, 0x54, 0x6a, 0x7f, 0x6e, 0x54, 0x00},   // 47 13d3 e09e Ã§â€¡Â¼
    {0x45, 0x5b, 0x2d, 0x10, 0x25, 0x5b, 0x4d, 0x00},   // 47 13d4 e09f Ã§â€¡Â¹
    {0x4c, 0x3f, 0x21, 0x7b, 0x50, 0x79, 0x53, 0x00},   // 47 13d5 e0a0 Ã§â€¡Â¿
    {0x4c, 0x3f, 0x5a, 0x35, 0x7f, 0x3a, 0x55, 0x00},   // 47 13d6 e0a1 Ã§Ë†Â
    {0x4c, 0x3f, 0x3c, 0x44, 0x6f, 0x6a, 0x4a, 0x00},   // 47 13d7 e0a2 Ã§Ë†Â
    {0x4c, 0x3f, 0x7f, 0x2b, 0x7c, 0x2b, 0x7f, 0x00},   // 47 13d8 e0a3 Ã§Ë†â€º
    {0x2c, 0x16, 0x5d, 0x36, 0x5d, 0x17, 0x2c, 0x00},   // 47 13d9 e0a4 Ã§Ë†Â¨
    {0x14, 0x13, 0x55, 0x7f, 0x35, 0x3d, 0x12, 0x00},   // 47 13da e0a5 Ã§Ë†Â­
    {0x40, 0x3e, 0x7e, 0x3d, 0x40, 0x5e, 0x56, 0x00},   // 47 13db e0a6 Ã§Ë†Â¬
    {0x44, 0x2b, 0x5d, 0x5f, 0x2d, 0x5d, 0x4a, 0x00},   // 47 13dc e0a7 Ã§Ë†Â°
    {0x44, 0x23, 0x5d, 0x17, 0x55, 0x1d, 0x72, 0x00},   // 47 13dd e0a8 Ã§Ë†Â²
    {0x40, 0x45, 0x5d, 0x22, 0x5a, 0x45, 0x40, 0x00},   // 47 13de e0a9 Ã§Ë†Â»
    {0x55, 0x22, 0x55, 0x7f, 0x55, 0x7f, 0x40, 0x00},   // 47 13df e0aa Ã§Ë†Â¼
    {0x00, 0x50, 0x37, 0x14, 0x14, 0x7f, 0x00, 0x00},   // 47 13e0 e0ab Ã§Ë†Â¿
    {0x57, 0x34, 0x7f, 0x1a, 0x7f, 0x1a, 0x22, 0x00},   // 47 13e1 e0ac Ã§â€°â‚¬
    {0x57, 0x34, 0x7f, 0x76, 0x5b, 0x76, 0x7a, 0x00},   // 47 13e2 e0ad Ã§â€°â€ 
    {0x7f, 0x14, 0x77, 0x12, 0x5b, 0x36, 0x5b, 0x00},   // 47 13e3 e0ae Ã§â€°â€¹
    {0x7f, 0x14, 0x77, 0x4e, 0x3e, 0x3b, 0x4e, 0x00},   // 47 13e4 e0af Ã§â€°Ëœ
    {0x17, 0x7f, 0x12, 0x7e, 0x4a, 0x5e, 0x69, 0x00},   // 47 13e5 e0b0 Ã§â€°Â´
    {0x17, 0x7f, 0x14, 0x7d, 0x57, 0x7d, 0x10, 0x00},   // 47 13e6 e0b1 Ã§â€°Â¾
    {0x2a, 0x27, 0x3f, 0x76, 0x3b, 0x36, 0x2e, 0x00},   // 47 13e7 e0b2 Ã§Å â€š
    {0x2a, 0x27, 0x3f, 0x7a, 0x37, 0x30, 0x2f, 0x00},   // 47 13e8 e0b3 Ã§Å Â
    {0x24, 0x3f, 0x76, 0x27, 0x3e, 0x76, 0x24, 0x00},   // 47 13e9 e0b4 Ã§Å â€¡
    {0x17, 0x7f, 0x72, 0x1e, 0x5b, 0x1e, 0x72, 0x00},   // 47 13ea e0b5 Ã§Å â€™
    {0x2d, 0x26, 0x3d, 0x7c, 0x35, 0x36, 0x2d, 0x00},   // 47 13eb e0b6 Ã§Å â€“
    {0x17, 0x7f, 0x4e, 0x3e, 0x3b, 0x3e, 0x4e, 0x00},   // 47 13ec e0b7 Ã§Å Â¢
    {0x17, 0x7f, 0x0a, 0x5b, 0x6e, 0x3b, 0x5a, 0x00},   // 47 13ed e0b8 Ã§Å Â§
    {0x55, 0x4a, 0x3d, 0x42, 0x3f, 0x7a, 0x43, 0x00},   // 47 13ee e0b9 Ã§Å Â¹
    {0x55, 0x4a, 0x3d, 0x22, 0x52, 0x7f, 0x0a, 0x00},   // 47 13ef e0ba Ã§Å Â²
    {0x55, 0x3e, 0x49, 0x7f, 0x49, 0x7f, 0x48, 0x00},   // 47 13f0 e0bb Ã§â€¹Æ’
    {0x55, 0x4a, 0x3d, 0x12, 0x7f, 0x12, 0x1e, 0x00},   // 47 13f1 e0bc Ã§â€¹â€ 
    {0x55, 0x3e, 0x4d, 0x20, 0x1f, 0x28, 0x44, 0x00},   // 47 13f2 e0bd Ã§â€¹â€ž
    {0x55, 0x3e, 0x1f, 0x15, 0x7f, 0x15, 0x1f, 0x00},   // 47 13f3 e0be Ã§â€¹Å½
    {0x55, 0x3e, 0x5a, 0x3f, 0x16, 0x7f, 0x36, 0x00},   // 47 13f4 e0bf Ã§â€¹â€™
    {0x55, 0x3e, 0x11, 0x6a, 0x65, 0x6b, 0x10, 0x00},   // 47 13f5 e0c0 Ã§â€¹Â¢
    {0x55, 0x4a, 0x3d, 0x7f, 0x55, 0x35, 0x5f, 0x00},   // 47 13f6 e0c1 Ã§â€¹Â 
    {0x55, 0x3e, 0x4a, 0x56, 0x23, 0x56, 0x4a, 0x00},   // 47 13f7 e0c2 Ã§â€¹Â¡
    {0x55, 0x3e, 0x52, 0x4e, 0x3f, 0x4e, 0x52, 0x00},   // 47 13f8 e0c3 Ã§â€¹Â¹
    {0x55, 0x4a, 0x3d, 0x78, 0x2b, 0x2b, 0x78, 0x00},   // 47 13f9 e0c4 Ã§â€¹Â·
    {0x04, 0x7e, 0x5f, 0x5a, 0x35, 0x5b, 0x50, 0x00},   // 47 13fa e0c5 Ã¥â‚¬Â
    {0x55, 0x3e, 0x12, 0x5a, 0x17, 0x7a, 0x12, 0x00},   // 47 13fb e0c6 Ã§Å’â€”
    {0x55, 0x3e, 0x5e, 0x35, 0x10, 0x75, 0x5f, 0x00},   // 47 13fc e0c7 Ã§Å’Å 
    {0x55, 0x3e, 0x09, 0x7a, 0x3f, 0x7a, 0x08, 0x00},   // 47 13fd e0c8 Ã§Å’Å“
    {0x55, 0x4a, 0x3d, 0x7c, 0x57, 0x57, 0x7c, 0x00},   // 47 13fe e0c9 Ã§Å’â€“
    {0x55, 0x3e, 0x32, 0x2e, 0x73, 0x2e, 0x32, 0x00},   // 47 13ff e0ca Ã§Å’Â
    {0x55, 0x3e, 0x7f, 0x54, 0x5d, 0x37, 0x54, 0x00},   // 47 1400 e0cb Ã§Å’Â´
    {0x55, 0x3e, 0x6b, 0x3a, 0x6b, 0x2a, 0x6b, 0x00},   // 47 1401 e0cc Ã§Å’Â¯
    {0x55, 0x4a, 0x3d, 0x48, 0x57, 0x7d, 0x57, 0x00},   // 47 1402 e0cd Ã§Å’Â©
    {0x55, 0x4a, 0x3d, 0x77, 0x55, 0x37, 0x57, 0x00},   // 47 1403 e0ce Ã§Å’Â¥
    {0x55, 0x3e, 0x0c, 0x77, 0x35, 0x77, 0x0c, 0x00},   // 47 1404 e0cf Ã§Å’Â¾
    {0x5b, 0x56, 0x5f, 0x34, 0x56, 0x5d, 0x57, 0x00},   // 47 1405 e0d0 Ã§ÂÅ½
    {0x55, 0x3e, 0x52, 0x5f, 0x36, 0x5f, 0x52, 0x00},   // 47 1406 e0d1 Ã§ÂÂ
    {0x57, 0x1f, 0x57, 0x24, 0x1f, 0x24, 0x45, 0x00},   // 47 1407 e0d2 Ã©Â»Ëœ
    {0x55, 0x3e, 0x5b, 0x35, 0x4b, 0x3d, 0x4d, 0x00},   // 47 1408 e0d3 Ã§Ââ€”
    {0x55, 0x3e, 0x1d, 0x76, 0x5d, 0x76, 0x1c, 0x00},   // 47 1409 e0d4 Ã§ÂÂª
    {0x55, 0x3e, 0x4b, 0x75, 0x77, 0x25, 0x7f, 0x00},   // 47 140a e0d5 Ã§ÂÂ¨
    {0x55, 0x3e, 0x16, 0x5e, 0x7f, 0x1a, 0x16, 0x00},   // 47 140b e0d6 Ã§ÂÂ°
    {0x13, 0x7f, 0x5f, 0x7f, 0x44, 0x3f, 0x45, 0x00},   // 47 140c e0d7 Ã§ÂÂ¸
    {0x55, 0x3e, 0x41, 0x3e, 0x75, 0x2e, 0x7d, 0x00},   // 47 140d e0d8 Ã§ÂÂµ
    {0x7c, 0x74, 0x3f, 0x6a, 0x44, 0x3f, 0x45, 0x00},   // 47 140e e0d9 Ã§ÂÂ»
    {0x55, 0x3e, 0x2e, 0x7f, 0x5a, 0x19, 0x5b, 0x00},   // 47 140f e0da Ã§ÂÂº
    {0x2a, 0x3e, 0x62, 0x1f, 0x7e, 0x42, 0x7e, 0x00},   // 47 1410 e0db Ã§ÂË†
    {0x2a, 0x3e, 0x7e, 0x01, 0x04, 0x3f, 0x45, 0x00},   // 47 1411 e0dc Ã§Å½Â³
    {0x2a, 0x3e, 0x24, 0x5b, 0x7e, 0x0a, 0x32, 0x00},   // 47 1412 e0dd Ã§ÂÅ½
    {0x2a, 0x3e, 0x7e, 0x5a, 0x2f, 0x5a, 0x46, 0x00},   // 47 1413 e0de Ã§Å½Â»
    {0x2a, 0x3e, 0x2a, 0x7e, 0x4b, 0x4a, 0x7e, 0x00},   // 47 1414 e0df Ã§Ââ‚¬
    {0x2a, 0x3e, 0x21, 0x3f, 0x2d, 0x7f, 0x21, 0x00},   // 47 1415 e0e0 Ã§ÂÂ¥
    {0x2a, 0x3e, 0x7f, 0x35, 0x7d, 0x35, 0x7f, 0x00},   // 47 1416 e0e1 Ã§ÂÂ®
    {0x2a, 0x3e, 0x10, 0x6a, 0x65, 0x6b, 0x10, 0x00},   // 47 1417 e0e2 Ã§ÂÅ¾
    {0x2a, 0x3e, 0x7d, 0x5f, 0x71, 0x5f, 0x7d, 0x00},   // 47 1418 e0e3 Ã§â€™Â¢
    {0x2a, 0x3e, 0x2a, 0x7e, 0x5b, 0x3a, 0x5e, 0x00},   // 47 1419 e0e4 Ã§Ââ€¦
    {0x2a, 0x3e, 0x7e, 0x4b, 0x2e, 0x7f, 0x1b, 0x00},   // 47 141a e0e5 Ã§â€˜Â¯
    {0x2a, 0x3e, 0x7c, 0x44, 0x2f, 0x6a, 0x4a, 0x00},   // 47 141b e0e6 Ã§ÂÂ¥
    {0x2a, 0x3e, 0x14, 0x7d, 0x57, 0x7d, 0x10, 0x00},   // 47 141c e0e7 Ã§ÂÂ¸
    {0x2a, 0x3e, 0x2a, 0x7f, 0x00, 0x7f, 0x2a, 0x00},   // 47 141d e0e8 Ã§ÂÂ²
    {0x2a, 0x3e, 0x75, 0x00, 0x6a, 0x5f, 0x4a, 0x00},   // 47 141e e0e9 Ã§ÂÂº
    {0x2a, 0x3e, 0x7f, 0x2b, 0x58, 0x2d, 0x5f, 0x00},   // 47 141f e0ea Ã§â€˜â€¢
    {0x2a, 0x3e, 0x27, 0x3d, 0x7f, 0x3d, 0x27, 0x00},   // 47 1420 e0eb Ã§ÂÂ¿
    {0x55, 0x47, 0x3d, 0x50, 0x4d, 0x47, 0x55, 0x00},   // 47 1421 e0ec Ã§â€˜Å¸
    {0x2a, 0x3e, 0x2a, 0x7a, 0x6d, 0x5a, 0x7d, 0x00},   // 47 1422 e0ed Ã§â€˜â„¢
    {0x2a, 0x3e, 0x07, 0x79, 0x55, 0x7d, 0x07, 0x00},   // 47 1423 e0ee Ã§â€˜Â
    {0x2a, 0x3e, 0x05, 0x73, 0x75, 0x26, 0x54, 0x00},   // 47 1424 e0ef Ã§â€˜Å“
    {0x4d, 0x56, 0x55, 0x7c, 0x55, 0x76, 0x4d, 0x00},   // 47 1425 e0f0 Ã§â€˜Â©
    {0x2a, 0x3e, 0x5e, 0x2b, 0x7e, 0x6a, 0x5e, 0x00},   // 47 1426 e0f1 Ã§â€˜Â°
    {0x2a, 0x3e, 0x42, 0x39, 0x2e, 0x39, 0x42, 0x00},   // 47 1427 e0f2 Ã§â€˜Â£
    {0x2a, 0x3e, 0x5f, 0x15, 0x5f, 0x15, 0x71, 0x00},   // 47 1428 e0f3 Ã§â€˜Âª
    {0x2a, 0x3e, 0x68, 0x4a, 0x7e, 0x49, 0x6b, 0x00},   // 47 1429 e0f4 Ã§â€˜Â¶
    {0x2a, 0x3e, 0x5a, 0x5f, 0x7a, 0x5f, 0x5a, 0x00},   // 47 142a e0f5 Ã§â€˜Â¾
    {0x2a, 0x3e, 0x2a, 0x3e, 0x7b, 0x3e, 0x2a, 0x00},   // 47 142b e0f6 Ã§â€™â€¹
    {0x2a, 0x3e, 0x4b, 0x5e, 0x3b, 0x5e, 0x4b, 0x00},   // 47 142c e0f7 Ã§â€™Å¾
    {0x54, 0x5f, 0x7b, 0x70, 0x76, 0x7b, 0x56, 0x00},   // 47 142d e0f8 Ã§â€™Â§
    {0x2a, 0x3e, 0x2a, 0x52, 0x5d, 0x2f, 0x5e, 0x00},   // 47 142e e0f9 Ã§â€œÅ 
    {0x2a, 0x3e, 0x7e, 0x2b, 0x7e, 0x77, 0x5d, 0x00},   // 47 142f e0fa Ã§â€œÂ
    {0x2a, 0x3e, 0x57, 0x7b, 0x54, 0x33, 0x57, 0x00},   // 47 1430 e0fb Ã§â€œâ€
    {0x2a, 0x3e, 0x49, 0x58, 0x2d, 0x3a, 0x49, 0x00},   // 47 1431 e0fc Ã§ÂÂ±
    {0x0a, 0x37, 0x6a, 0x3e, 0x62, 0x1e, 0x61, 0x00},   // 48 1432 e140 Ã§â€œÂ 
    {0x56, 0x3b, 0x7e, 0x7f, 0x16, 0x7b, 0x16, 0x00},   // 48 1433 e141 Ã§â€œÂ£
    {0x41, 0x7f, 0x3d, 0x41, 0x44, 0x7f, 0x44, 0x00},   // 48 1434 e142 Ã§â€œÂ§
    {0x41, 0x7f, 0x3d, 0x41, 0x4a, 0x7e, 0x49, 0x00},   // 48 1435 e143 Ã§â€œÂ©
    {0x4a, 0x4a, 0x7d, 0x58, 0x19, 0x7a, 0x4a, 0x00},   // 48 1436 e144 Ã§â€œÂ®
    {0x41, 0x3f, 0x7d, 0x5a, 0x52, 0x7f, 0x6a, 0x00},   // 48 1437 e145 Ã§â€œÂ²
    {0x41, 0x7f, 0x3d, 0x41, 0x6a, 0x59, 0x7a, 0x00},   // 48 1438 e146 Ã§â€œÂ°
    {0x41, 0x7f, 0x3d, 0x41, 0x4a, 0x7e, 0x65, 0x00},   // 48 1439 e147 Ã§â€œÂ±
    {0x41, 0x7f, 0x3d, 0x40, 0x7d, 0x6b, 0x7d, 0x00},   // 48 143a e148 Ã§â€œÂ¸
    {0x59, 0x50, 0x74, 0x5b, 0x16, 0x7a, 0x56, 0x00},   // 48 143b e149 Ã§â€œÂ·
    {0x5d, 0x7f, 0x5d, 0x41, 0x7f, 0x3d, 0x41, 0x00},   // 48 143c e14a Ã§â€â€ž
    {0x5a, 0x56, 0x7e, 0x55, 0x1a, 0x77, 0x5a, 0x00},   // 48 143d e14b Ã§â€Æ’
    {0x41, 0x7f, 0x3d, 0x50, 0x6f, 0x7d, 0x6d, 0x00},   // 48 143e e14c Ã§â€â€¦
    {0x7f, 0x71, 0x47, 0x77, 0x7f, 0x3d, 0x41, 0x00},   // 48 143f e14d Ã§â€Å’
    {0x52, 0x1f, 0x7e, 0x41, 0x7f, 0x3d, 0x41, 0x00},   // 48 1440 e14e Ã§â€Å½
    {0x5a, 0x4e, 0x7b, 0x5e, 0x1b, 0x7e, 0x5a, 0x00},   // 48 1441 e14f Ã§â€Â
    {0x5a, 0x56, 0x72, 0x5f, 0x1e, 0x7e, 0x5a, 0x00},   // 48 1442 e150 Ã§â€â€¢
    {0x54, 0x5f, 0x7b, 0x50, 0x16, 0x7b, 0x56, 0x00},   // 48 1443 e151 Ã§â€â€œ
    {0x16, 0x7b, 0x56, 0x57, 0x56, 0x7b, 0x16, 0x00},   // 48 1444 e152 Ã§â€Å¾
    {0x5d, 0x3f, 0x4d, 0x64, 0x6b, 0x7f, 0x6a, 0x00},   // 48 1445 e153 Ã§â€Â¦
    {0x00, 0x7d, 0x15, 0x7d, 0x15, 0x57, 0x7d, 0x00},   // 48 1446 e154 Ã§â€Â¬
    {0x10, 0x1f, 0x55, 0x7f, 0x15, 0x1f, 0x10, 0x00},   // 48 1447 e155 Ã§â€Â¼
    {0x00, 0x7d, 0x54, 0x7d, 0x54, 0x56, 0x7d, 0x00},   // 48 1448 e156 Ã§â€¢â€ž
    {0x3e, 0x3e, 0x7e, 0x3a, 0x01, 0x7a, 0x04, 0x00},   // 48 1449 e157 Ã§â€¢Â
    {0x3e, 0x3e, 0x7e, 0x3f, 0x12, 0x7f, 0x12, 0x00},   // 48 144a e158 Ã§â€¢Å 
    {0x3e, 0x3e, 0x7e, 0x2a, 0x1f, 0x2a, 0x48, 0x00},   // 48 144b e159 Ã§â€¢â€°
    {0x3e, 0x3e, 0x3e, 0x42, 0x55, 0x2a, 0x14, 0x00},   // 48 144c e15a Ã§â€¢â€º
    {0x7a, 0x7a, 0x7b, 0x7a, 0x70, 0x4f, 0x60, 0x00},   // 48 144d e15b Ã§â€¢â€ 
    {0x14, 0x0e, 0x77, 0x76, 0x55, 0x7e, 0x14, 0x00},   // 48 144e e15c Ã§â€¢Å¡
    {0x3e, 0x3e, 0x3e, 0x7a, 0x4f, 0x32, 0x4a, 0x00},   // 48 144f e15d Ã§â€¢Â©
    {0x3e, 0x3e, 0x3e, 0x6a, 0x2f, 0x7a, 0x28, 0x00},   // 48 1450 e15e Ã§â€¢Â¤
    {0x20, 0x27, 0x6d, 0x57, 0x6d, 0x27, 0x20, 0x00},   // 48 1451 e15f Ã§â€¢Â§
    {0x50, 0x7a, 0x5a, 0x7f, 0x5a, 0x7e, 0x54, 0x00},   // 48 1452 e160 Ã§â€¢Â«
    {0x3e, 0x3e, 0x3e, 0x56, 0x7d, 0x16, 0x54, 0x00},   // 48 1453 e161 Ã§â€¢Â­
    {0x3e, 0x3e, 0x3e, 0x5a, 0x17, 0x7a, 0x12, 0x00},   // 48 1454 e162 Ã§â€¢Â¸
    {0x06, 0x73, 0x5e, 0x7b, 0x5e, 0x73, 0x06, 0x00},   // 48 1455 e163 Ã§â€¢Â¶
    {0x51, 0x7d, 0x37, 0x49, 0x7f, 0x7f, 0x49, 0x00},   // 48 1456 e164 Ã§â€“â€ 
    {0x3e, 0x3e, 0x3e, 0x36, 0x5f, 0x76, 0x14, 0x00},   // 48 1457 e165 Ã§â€“â€¡
    {0x3e, 0x3e, 0x3e, 0x5e, 0x17, 0x7e, 0x14, 0x00},   // 48 1458 e166 Ã§â€¢Â´
    {0x5c, 0x4c, 0x7f, 0x5b, 0x7f, 0x4c, 0x5c, 0x00},   // 48 1459 e167 Ã§â€“Å 
    {0x5c, 0x6c, 0x5f, 0x6b, 0x5f, 0x4c, 0x5c, 0x00},   // 48 145a e168 Ã§â€“â€°
    {0x5a, 0x4c, 0x7b, 0x5b, 0x7b, 0x4c, 0x5a, 0x00},   // 48 145b e169 Ã§â€“â€š
    {0x54, 0x3e, 0x0a, 0x4a, 0x7b, 0x0a, 0x0a, 0x00},   // 48 145c e16a Ã§â€“â€
    {0x54, 0x3e, 0x42, 0x4a, 0x27, 0x5e, 0x42, 0x00},   // 48 145d e16b Ã§â€“Å¡
    {0x54, 0x3e, 0x72, 0x42, 0x7b, 0x42, 0x72, 0x00},   // 48 145e e16c Ã§â€“Â
    {0x54, 0x3e, 0x52, 0x3a, 0x07, 0x7a, 0x12, 0x00},   // 48 145f e16d Ã§â€“Â¥
    {0x54, 0x3e, 0x4a, 0x4a, 0x3f, 0x7a, 0x4a, 0x00},   // 48 1460 e16e Ã§â€“Â£
    {0x54, 0x3e, 0x4a, 0x3e, 0x7b, 0x4a, 0x7a, 0x00},   // 48 1461 e16f Ã§â€”â€š
    {0x54, 0x3e, 0x0a, 0x7e, 0x4b, 0x7e, 0x0a, 0x00},   // 48 1462 e170 Ã§â€“Â³
    {0x54, 0x3e, 0x4a, 0x5a, 0x6f, 0x4a, 0x6a, 0x00},   // 48 1463 e171 Ã§â€”Æ’
    {0x54, 0x3e, 0x72, 0x7e, 0x2b, 0x7e, 0x4a, 0x00},   // 48 1464 e172 Ã§â€“Âµ
    {0x54, 0x3e, 0x42, 0x7e, 0x57, 0x7e, 0x42, 0x00},   // 48 1465 e173 Ã§â€“Â½
    {0x54, 0x3e, 0x42, 0x5e, 0x57, 0x5e, 0x42, 0x00},   // 48 1466 e174 Ã§â€“Â¸
    {0x54, 0x3e, 0x22, 0x2a, 0x57, 0x1e, 0x22, 0x00},   // 48 1467 e175 Ã§â€“Â¼
    {0x54, 0x3e, 0x12, 0x0e, 0x7b, 0x5a, 0x5a, 0x00},   // 48 1468 e176 Ã§â€“Â±
    {0x54, 0x3e, 0x46, 0x5e, 0x3f, 0x56, 0x72, 0x00},   // 48 1469 e177 Ã§â€”Â
    {0x54, 0x3e, 0x52, 0x5a, 0x77, 0x5a, 0x52, 0x00},   // 48 146a e178 Ã§â€”Å 
    {0x54, 0x3e, 0x2a, 0x2e, 0x7b, 0x2e, 0x2a, 0x00},   // 48 146b e179 Ã§â€”â€™
    {0x54, 0x3e, 0x52, 0x5a, 0x77, 0x5a, 0x56, 0x00},   // 48 146c e17a Ã§â€”â„¢
    {0x54, 0x3e, 0x62, 0x36, 0x5f, 0x56, 0x62, 0x00},   // 48 146d e17b Ã§â€”Â£
    {0x54, 0x3e, 0x22, 0x16, 0x6f, 0x7e, 0x16, 0x00},   // 48 146e e17c Ã§â€”Å¾
    {0x54, 0x3e, 0x7e, 0x36, 0x1b, 0x5a, 0x7e, 0x00},   // 48 146f e17d Ã§â€”Â¾
    {0x54, 0x3e, 0x5a, 0x76, 0x5f, 0x36, 0x5a, 0x00},   // 48 1470 e17e Ã§â€”Â¿
    {0x54, 0x3e, 0x7e, 0x6a, 0x5f, 0x6a, 0x7e, 0x00},   // 49 1471 e180 Ã§â€”Â¼
    {0x54, 0x3e, 0x36, 0x2e, 0x77, 0x2e, 0x36, 0x00},   // 49 1472 e181 Ã§ËœÂ
    {0x54, 0x3e, 0x56, 0x52, 0x2f, 0x52, 0x56, 0x00},   // 49 1473 e182 Ã§â€”Â°
    {0x54, 0x3e, 0x02, 0x2e, 0x3f, 0x7a, 0x2e, 0x00},   // 49 1474 e183 Ã§â€”Âº
    {0x54, 0x3e, 0x3a, 0x7e, 0x3b, 0x7e, 0x3a, 0x00},   // 49 1475 e184 Ã§â€”Â²
    {0x54, 0x3e, 0x2a, 0x7e, 0x2b, 0x7e, 0x2a, 0x00},   // 49 1476 e185 Ã§â€”Â³
    {0x54, 0x7e, 0x3e, 0x5a, 0x7b, 0x3e, 0x42, 0x00},   // 49 1477 e186 Ã§Ëœâ€¹
    {0x54, 0x3e, 0x52, 0x3e, 0x5b, 0x3e, 0x72, 0x00},   // 49 1478 e187 Ã§ËœÂ
    {0x54, 0x3e, 0x12, 0x7a, 0x77, 0x2a, 0x52, 0x00},   // 49 1479 e188 Ã§Ëœâ€°
    {0x54, 0x3e, 0x42, 0x7e, 0x7b, 0x76, 0x5e, 0x00},   // 49 147a e189 Ã§ËœÅ¸
    {0x54, 0x3e, 0x42, 0x3a, 0x2f, 0x76, 0x52, 0x00},   // 49 147b e18a Ã§ËœÂ§
    {0x54, 0x3e, 0x16, 0x76, 0x2b, 0x76, 0x16, 0x00},   // 49 147c e18b Ã§ËœÂ 
    {0x54, 0x3e, 0x52, 0x3a, 0x77, 0x6a, 0x12, 0x00},   // 49 147d e18c Ã§ËœÂ¡
    {0x54, 0x3e, 0x7a, 0x7e, 0x5b, 0x2a, 0x5a, 0x00},   // 49 147e e18d Ã§ËœÂ¢
    {0x54, 0x3e, 0x1a, 0x76, 0x73, 0x6e, 0x1e, 0x00},   // 49 147f e18e Ã§ËœÂ¤
    {0x54, 0x3e, 0x2a, 0x3e, 0x7b, 0x3e, 0x2a, 0x00},   // 49 1480 e18f Ã§ËœÂ´
    {0x54, 0x3e, 0x52, 0x1e, 0x7f, 0x1e, 0x52, 0x00},   // 49 1481 e190 Ã§ËœÂ°
    {0x54, 0x3e, 0x5a, 0x7e, 0x5f, 0x3e, 0x5a, 0x00},   // 49 1482 e191 Ã§ËœÂ»
    {0x54, 0x3e, 0x7e, 0x46, 0x33, 0x76, 0x7e, 0x00},   // 49 1483 e192 Ã§â„¢â€¡
    {0x54, 0x3e, 0x56, 0x2e, 0x5f, 0x2a, 0x56, 0x00},   // 49 1484 e193 Ã§â„¢Ë†
    {0x54, 0x3e, 0x36, 0x5a, 0x37, 0x7a, 0x36, 0x00},   // 49 1485 e194 Ã§â„¢â€ 
    {0x54, 0x3e, 0x5e, 0x16, 0x5b, 0x2a, 0x5a, 0x00},   // 49 1486 e195 Ã§â„¢Å“
    {0x54, 0x3e, 0x6a, 0x3e, 0x7b, 0x7e, 0x6a, 0x00},   // 49 1487 e196 Ã§â„¢Ëœ
    {0x54, 0x3e, 0x5e, 0x3a, 0x5b, 0x36, 0x5e, 0x00},   // 49 1488 e197 Ã§â„¢Â¡
    {0x54, 0x3e, 0x2a, 0x7e, 0x3b, 0x5e, 0x2a, 0x00},   // 49 1489 e198 Ã§â„¢Â¢
    {0x54, 0x3e, 0x2a, 0x76, 0x7f, 0x56, 0x4a, 0x00},   // 49 148a e199 Ã§â„¢Â¨
    {0x54, 0x3e, 0x7e, 0x2e, 0x43, 0x1a, 0x5e, 0x00},   // 49 148b e19a Ã§â„¢Â©
    {0x54, 0x3e, 0x36, 0x7e, 0x4b, 0x1e, 0x5a, 0x00},   // 49 148c e19b Ã§â„¢Âª
    {0x54, 0x3e, 0x42, 0x3e, 0x4f, 0x66, 0x4e, 0x00},   // 49 148d e19c Ã§â„¢Â§
    {0x54, 0x3e, 0x5a, 0x5e, 0x2b, 0x72, 0x2a, 0x00},   // 49 148e e19d Ã§â„¢Â¬
    {0x54, 0x3e, 0x6a, 0x76, 0x4b, 0x7e, 0x56, 0x00},   // 49 148f e19e Ã§â„¢Â°
    {0x54, 0x3e, 0x5e, 0x1a, 0x43, 0x1e, 0x5e, 0x00},   // 49 1490 e19f Ã§â„¢Â²
    {0x14, 0x0a, 0x06, 0x02, 0x04, 0x0a, 0x14, 0x00},   // 49 1491 e1a0 Ã§â„¢Â¶
    {0x4a, 0x55, 0x5b, 0x39, 0x5a, 0x55, 0x4a, 0x00},   // 49 1492 e1a1 Ã§â„¢Â¸
    {0x0a, 0x55, 0x6b, 0x01, 0x5a, 0x2d, 0x5a, 0x00},   // 49 1493 e1a2 Ã§â„¢Â¼
    {0x00, 0x3e, 0x5a, 0x5b, 0x4a, 0x4e, 0x60, 0x00},   // 49 1494 e1a3 Ã§Å¡â‚¬
    {0x40, 0x5e, 0x3a, 0x1b, 0x7a, 0x5e, 0x60, 0x00},   // 49 1495 e1a4 Ã§Å¡Æ’
    {0x3e, 0x2b, 0x3e, 0x7f, 0x5d, 0x25, 0x5d, 0x00},   // 49 1496 e1a5 Ã§Å¡Ë†
    {0x28, 0x1e, 0x2a, 0x7b, 0x2a, 0x1e, 0x28, 0x00},   // 49 1497 e1a6 Ã§Å¡â€¹
    {0x3e, 0x2b, 0x5e, 0x56, 0x23, 0x56, 0x4a, 0x00},   // 49 1498 e1a7 Ã§Å¡Å½
    {0x3e, 0x2b, 0x3e, 0x56, 0x3a, 0x7b, 0x56, 0x00},   // 49 1499 e1a8 Ã§Å¡â€“
    {0x3e, 0x2b, 0x3e, 0x0c, 0x6b, 0x6f, 0x6a, 0x00},   // 49 149a e1a9 Ã§Å¡â€œ
    {0x0a, 0x66, 0x6f, 0x7a, 0x67, 0x6d, 0x05, 0x00},   // 49 149b e1aa Ã§Å¡â„¢
    {0x3e, 0x2b, 0x3e, 0x4b, 0x5a, 0x6b, 0x5b, 0x00},   // 49 149c e1ab Ã§Å¡Å¡
    {0x7e, 0x2f, 0x5a, 0x04, 0x7b, 0x5a, 0x5e, 0x00},   // 49 149d e1ac Ã§Å¡Â°
    {0x4a, 0x27, 0x52, 0x37, 0x7e, 0x2f, 0x5a, 0x00},   // 49 149e e1ad Ã§Å¡Â´
    {0x27, 0x3d, 0x7f, 0x27, 0x7e, 0x2f, 0x5a, 0x00},   // 49 149f e1ae Ã§Å¡Â¸
    {0x7e, 0x2f, 0x5a, 0x27, 0x3d, 0x7f, 0x27, 0x00},   // 49 14a0 e1af Ã§Å¡Â¹
    {0x24, 0x5b, 0x36, 0x7e, 0x5a, 0x2f, 0x5e, 0x00},   // 49 14a1 e1b0 Ã§Å¡Âº
    {0x44, 0x75, 0x5d, 0x7f, 0x55, 0x75, 0x44, 0x00},   // 49 14a2 e1b1 Ã§â€ºâ€š
    {0x54, 0x76, 0x7e, 0x77, 0x76, 0x6e, 0x54, 0x00},   // 49 14a3 e1b2 Ã§â€ºÂ
    {0x4a, 0x7a, 0x5b, 0x7e, 0x5a, 0x7b, 0x4a, 0x00},   // 49 14a4 e1b3 Ã§â€ºâ€“
    {0x44, 0x74, 0x5e, 0x7d, 0x5e, 0x74, 0x44, 0x00},   // 49 14a5 e1b4 Ã§â€ºâ€™
    {0x4a, 0x6a, 0x76, 0x77, 0x6a, 0x6b, 0x54, 0x00},   // 49 14a6 e1b5 Ã§â€ºÅ¾
    {0x50, 0x6a, 0x7a, 0x6f, 0x7a, 0x6e, 0x54, 0x00},   // 49 14a7 e1b6 Ã§â€ºÂ¡
    {0x5e, 0x75, 0x6a, 0x7f, 0x6a, 0x75, 0x5f, 0x00},   // 49 14a8 e1b7 Ã§â€ºÂ¥
    {0x40, 0x3c, 0x44, 0x74, 0x7f, 0x7a, 0x4a, 0x00},   // 49 14a9 e1b8 Ã§â€ºÂ§
    {0x55, 0x60, 0x74, 0x6f, 0x75, 0x6f, 0x5c, 0x00},   // 49 14aa e1b9 Ã§â€ºÂª
    {0x56, 0x62, 0x73, 0x6e, 0x7b, 0x6e, 0x5a, 0x00},   // 49 14ab e1ba Ã¨ËœÂ¯
    {0x7f, 0x55, 0x7f, 0x04, 0x1e, 0x55, 0x76, 0x00},   // 49 14ac e1bb Ã§â€ºÂ»
    {0x7f, 0x55, 0x7f, 0x46, 0x3f, 0x72, 0x46, 0x00},   // 49 14ad e1bc Ã§Å“Ë†
    {0x7f, 0x55, 0x7f, 0x46, 0x5f, 0x22, 0x14, 0x00},   // 49 14ae e1bd Ã§Å“â€¡
    {0x7f, 0x55, 0x7f, 0x1c, 0x11, 0x5f, 0x7d, 0x00},   // 49 14af e1be Ã§Å“â€ž
    {0x7f, 0x55, 0x7f, 0x4a, 0x6e, 0x53, 0x6a, 0x00},   // 49 14b0 e1bf Ã§Å“Â©
    {0x7f, 0x55, 0x7f, 0x3f, 0x05, 0x7d, 0x57, 0x00},   // 49 14b1 e1c0 Ã§Å“Â¤
    {0x58, 0x53, 0x1e, 0x1e, 0x1e, 0x52, 0x50, 0x00},   // 49 14b2 e1c1 Ã§Å“Å¾
    {0x0e, 0x78, 0x7f, 0x7a, 0x70, 0x7f, 0x0a, 0x00},   // 49 14b3 e1c2 Ã§Å“Â¥
    {0x7f, 0x55, 0x7f, 0x7f, 0x24, 0x7f, 0x44, 0x00},   // 49 14b4 e1c3 Ã§Å“Â¦
    {0x7f, 0x55, 0x7f, 0x2a, 0x7f, 0x2a, 0x48, 0x00},   // 49 14b5 e1c4 Ã§Å“â€º
    {0x2a, 0x19, 0x6c, 0x6b, 0x6c, 0x19, 0x2a, 0x00},   // 49 14b6 e1c5 Ã§Å“Â·
    {0x7f, 0x55, 0x7f, 0x36, 0x2d, 0x7c, 0x2e, 0x00},   // 49 14b7 e1c6 Ã§Å“Â¸
    {0x7f, 0x55, 0x7f, 0x5a, 0x2b, 0x7e, 0x6f, 0x00},   // 49 14b8 e1c7 Ã§Ââ€¡
    {0x7f, 0x55, 0x7f, 0x3f, 0x55, 0x7f, 0x55, 0x00},   // 49 14b9 e1c8 Ã§ÂÅ¡
    {0x7f, 0x55, 0x7f, 0x5e, 0x35, 0x72, 0x5e, 0x00},   // 49 14ba e1c9 Ã§ÂÂ¨
    {0x7f, 0x55, 0x7f, 0x4a, 0x2a, 0x7f, 0x56, 0x00},   // 49 14bb e1ca Ã§ÂÂ«
    {0x7f, 0x55, 0x7f, 0x08, 0x7a, 0x3f, 0x7a, 0x00},   // 49 14bc e1cb Ã§Ââ€º
    {0x7f, 0x55, 0x7f, 0x2e, 0x3f, 0x7a, 0x2e, 0x00},   // 49 14bd e1cc Ã§ÂÂ¥
    {0x2c, 0x14, 0x7c, 0x77, 0x7e, 0x16, 0x2c, 0x00},   // 49 14be e1cd Ã§ÂÂ¿
    {0x28, 0x2e, 0x3a, 0x6f, 0x3a, 0x2e, 0x28, 0x00},   // 49 14bf e1ce Ã§ÂÂ¾
    {0x7f, 0x55, 0x7f, 0x28, 0x1a, 0x6f, 0x6a, 0x00},   // 49 14c0 e1cf Ã§ÂÂ¹
    {0x7f, 0x55, 0x7f, 0x26, 0x6a, 0x7f, 0x6e, 0x00},   // 49 14c1 e1d0 Ã§Å¾Å½
    {0x7f, 0x55, 0x7f, 0x58, 0x1f, 0x1e, 0x52, 0x00},   // 49 14c2 e1d1 Ã§Å¾â€¹
    {0x7f, 0x55, 0x7f, 0x53, 0x1d, 0x1d, 0x53, 0x00},   // 49 14c3 e1d2 Ã§Å¾â€˜
    {0x7f, 0x55, 0x7f, 0x5e, 0x7b, 0x5e, 0x55, 0x00},   // 49 14c4 e1d3 Ã§Å¾Â 
    {0x7f, 0x55, 0x7f, 0x7a, 0x3f, 0x7a, 0x7f, 0x00},   // 49 14c5 e1d4 Ã§Å¾Å¾
    {0x7f, 0x55, 0x7f, 0x27, 0x7d, 0x3f, 0x5e, 0x00},   // 49 14c6 e1d5 Ã§Å¾Â°
    {0x7f, 0x55, 0x7f, 0x4e, 0x3a, 0x3f, 0x4e, 0x00},   // 49 14c7 e1d6 Ã§Å¾Â¶
    {0x7f, 0x55, 0x7f, 0x2f, 0x55, 0x37, 0x4d, 0x00},   // 49 14c8 e1d7 Ã§Å¾Â¹
    {0x20, 0x13, 0x7f, 0x58, 0x7f, 0x5b, 0x48, 0x00},   // 49 14c9 e1d8 Ã§Å¾Â¿
    {0x7f, 0x55, 0x7f, 0x36, 0x5d, 0x36, 0x5c, 0x00},   // 49 14ca e1d9 Ã§Å¾Â¼
    {0x1a, 0x77, 0x6a, 0x60, 0x76, 0x6b, 0x16, 0x00},   // 49 14cb e1da Ã§Å¾Â½
    {0x7f, 0x55, 0x7f, 0x3e, 0x6d, 0x77, 0x2c, 0x00},   // 49 14cc e1db Ã§Å¾Â»
    {0x7f, 0x55, 0x7f, 0x5f, 0x7a, 0x2f, 0x5a, 0x00},   // 49 14cd e1dc Ã§Å¸â€¡
    {0x48, 0x47, 0x5f, 0x2c, 0x5f, 0x4b, 0x48, 0x00},   // 49 14ce e1dd Ã§Å¸Â
    {0x70, 0x7a, 0x52, 0x1f, 0x7e, 0x72, 0x50, 0x00},   // 49 14cf e1de Ã§Å¸â€”
    {0x7f, 0x55, 0x7f, 0x5b, 0x7f, 0x3b, 0x77, 0x00},   // 49 14d0 e1df Ã§Å¸Å¡
    {0x29, 0x5d, 0x7b, 0x12, 0x55, 0x36, 0x14, 0x00},   // 49 14d1 e1e0 Ã§Å¸Å“
    {0x44, 0x54, 0x5e, 0x35, 0x54, 0x52, 0x44, 0x00},   // 49 14d2 e1e1 Ã§Å¸Â£
    {0x4b, 0x3e, 0x5a, 0x77, 0x5f, 0x37, 0x5a, 0x00},   // 49 14d3 e1e2 Ã§Å¸Â®
    {0x09, 0x37, 0x71, 0x42, 0x7e, 0x42, 0x40, 0x00},   // 49 14d4 e1e3 Ã§Å¸Â¼
    {0x09, 0x37, 0x31, 0x1e, 0x54, 0x3f, 0x7f, 0x00},   // 49 14d5 e1e4 Ã§Â Å’
    {0x09, 0x37, 0x31, 0x7f, 0x24, 0x7f, 0x44, 0x00},   // 49 14d6 e1e5 Ã§Â â€™
    {0x09, 0x37, 0x71, 0x3e, 0x4a, 0x1f, 0x5e, 0x00},   // 49 14d7 e1e6 Ã§Â¤Â¦
    {0x09, 0x37, 0x31, 0x40, 0x7f, 0x55, 0x7f, 0x00},   // 49 14d8 e1e7 Ã§Â Â 
    {0x09, 0x37, 0x71, 0x3f, 0x6d, 0x3f, 0x6d, 0x00},   // 49 14d9 e1e8 Ã§Â¤Âª
    {0x09, 0x37, 0x31, 0x48, 0x5a, 0x7f, 0x5a, 0x00},   // 49 14da e1e9 Ã§Â¡â€¦
    {0x09, 0x37, 0x32, 0x2e, 0x73, 0x2e, 0x32, 0x00},   // 49 14db e1ea Ã§Â¢Å½
    {0x09, 0x37, 0x32, 0x7b, 0x02, 0x7f, 0x52, 0x00},   // 49 14dc e1eb Ã§Â¡Â´
    {0x55, 0x30, 0x78, 0x56, 0x5a, 0x77, 0x1a, 0x00},   // 49 14dd e1ec Ã§Â¢â€ 
    {0x09, 0x77, 0x3f, 0x55, 0x3f, 0x55, 0x7f, 0x00},   // 49 14de e1ed Ã§Â¡Â¼
    {0x09, 0x37, 0x31, 0x0a, 0x6e, 0x6b, 0x6e, 0x00},   // 49 14df e1ee Ã§Â¢Å¡
    {0x09, 0x37, 0x74, 0x26, 0x7d, 0x27, 0x55, 0x00},   // 49 14e0 e1ef Ã§Â¢Å’
    {0x09, 0x37, 0x31, 0x3f, 0x2d, 0x4f, 0x78, 0x00},   // 49 14e1 e1f0 Ã§Â¢Â£
    {0x09, 0x37, 0x31, 0x40, 0x3c, 0x3f, 0x42, 0x00},   // 49 14e2 e1f1 Ã§Â¢Âµ
    {0x09, 0x37, 0x72, 0x5f, 0x72, 0x5f, 0x52, 0x00},   // 49 14e3 e1f2 Ã§Â¢Âª
    {0x09, 0x37, 0x31, 0x7a, 0x6d, 0x5a, 0x7d, 0x00},   // 49 14e4 e1f3 Ã§Â¢Â¯
    {0x09, 0x37, 0x31, 0x4b, 0x5a, 0x6b, 0x5b, 0x00},   // 49 14e5 e1f4 Ã§Â£â€˜
    {0x09, 0x37, 0x31, 0x0c, 0x77, 0x35, 0x7f, 0x00},   // 49 14e6 e1f5 Ã§Â£â€ 
    {0x09, 0x37, 0x31, 0x2a, 0x5b, 0x7e, 0x5b, 0x00},   // 49 14e7 e1f6 Ã§Â£â€¹
    {0x09, 0x37, 0x51, 0x3a, 0x75, 0x36, 0x5f, 0x00},   // 49 14e8 e1f7 Ã§Â£â€
    {0x09, 0x37, 0x3f, 0x75, 0x5d, 0x3d, 0x57, 0x00},   // 49 14e9 e1f8 Ã§Â¢Â¾
    {0x09, 0x37, 0x31, 0x5f, 0x15, 0x5f, 0x75, 0x00},   // 49 14ea e1f9 Ã§Â¢Â¼
    {0x09, 0x37, 0x3a, 0x4e, 0x3b, 0x6e, 0x1a, 0x00},   // 49 14eb e1fa Ã§Â£â€¦
    {0x50, 0x35, 0x73, 0x5f, 0x3b, 0x7f, 0x71, 0x00},   // 49 14ec e1fb Ã§Â£Å 
    {0x5a, 0x36, 0x77, 0x52, 0x5b, 0x75, 0x1b, 0x00},   // 49 14ed e1fc Ã§Â£Â¬
    {0x09, 0x37, 0x31, 0x4a, 0x3a, 0x3f, 0x4a, 0x00},   // 4a 14ee e240 Ã§Â£Â§
    {0x09, 0x37, 0x31, 0x12, 0x3e, 0x5f, 0x7a, 0x00},   // 4a 14ef e241 Ã§Â£Å¡
    {0x09, 0x37, 0x3d, 0x5e, 0x37, 0x7e, 0x5c, 0x00},   // 4a 14f0 e242 Ã§Â£Â½
    {0x09, 0x37, 0x35, 0x5b, 0x69, 0x5a, 0x45, 0x00},   // 4a 14f1 e243 Ã§Â£Â´
    {0x09, 0x37, 0x31, 0x5e, 0x3f, 0x56, 0x5e, 0x00},   // 4a 14f2 e244 Ã§Â¤â€¡
    {0x09, 0x37, 0x31, 0x2a, 0x7b, 0x2e, 0x5b, 0x00},   // 4a 14f3 e245 Ã§Â¤â€™
    {0x09, 0x37, 0x75, 0x5e, 0x7b, 0x5e, 0x75, 0x00},   // 4a 14f4 e246 Ã§Â¤â€˜
    {0x09, 0x37, 0x57, 0x3a, 0x5a, 0x3d, 0x57, 0x00},   // 4a 14f5 e247 Ã§Â¤â„¢
    {0x2a, 0x5f, 0x3a, 0x75, 0x7a, 0x1f, 0x2a, 0x00},   // 4a 14f6 e248 Ã§Â¤Â¬
    {0x09, 0x37, 0x5a, 0x35, 0x7f, 0x3a, 0x55, 0x00},   // 4a 14f7 e249 Ã§Â¤Â«
    {0x35, 0x7d, 0x35, 0x7f, 0x49, 0x49, 0x6f, 0x00},   // 4a 14f8 e24a Ã§Â¥â‚¬
    {0x35, 0x7d, 0x35, 0x00, 0x35, 0x35, 0x7f, 0x00},   // 4a 14f9 e24b Ã§Â¥Â 
    {0x35, 0x7d, 0x35, 0x7e, 0x4a, 0x5e, 0x69, 0x00},   // 4a 14fa e24c Ã§Â¥â€”
    {0x4c, 0x3b, 0x5a, 0x7f, 0x1a, 0x3b, 0x4c, 0x00},   // 4a 14fb e24d Ã§Â¥Å¸
    {0x35, 0x7d, 0x35, 0x04, 0x7f, 0x2a, 0x2a, 0x00},   // 4a 14fc e24e Ã§Â¥Å¡
    {0x35, 0x7d, 0x58, 0x3d, 0x52, 0x48, 0x56, 0x00},   // 4a 14fd e24f Ã§Â¥â€¢
    {0x35, 0x7d, 0x55, 0x22, 0x5f, 0x22, 0x5b, 0x00},   // 4a 14fe e250 Ã§Â¥â€œ
    {0x35, 0x7d, 0x52, 0x1f, 0x1a, 0x1f, 0x52, 0x00},   // 4a 14ff e251 Ã§Â¥Âº
    {0x35, 0x7d, 0x54, 0x26, 0x7d, 0x27, 0x55, 0x00},   // 4a 1500 e252 Ã§Â¥Â¿
    {0x35, 0x7d, 0x56, 0x5f, 0x36, 0x53, 0x57, 0x00},   // 4a 1501 e253 Ã§Â¦Å 
    {0x35, 0x7d, 0x54, 0x53, 0x2b, 0x5f, 0x44, 0x00},   // 4a 1502 e254 Ã§Â¦Â
    {0x35, 0x7d, 0x12, 0x7e, 0x57, 0x7e, 0x12, 0x00},   // 4a 1503 e255 Ã§Â¦Â§
    {0x4a, 0x36, 0x2e, 0x6b, 0x2e, 0x76, 0x0a, 0x00},   // 4a 1504 e256 Ã©Â½â€¹
    {0x35, 0x7d, 0x23, 0x3f, 0x7c, 0x3f, 0x23, 0x00},   // 4a 1505 e257 Ã§Â¦Âª
    {0x35, 0x7d, 0x5e, 0x77, 0x56, 0x77, 0x5e, 0x00},   // 4a 1506 e258 Ã§Â¦Â®
    {0x35, 0x7d, 0x36, 0x7e, 0x5b, 0x3e, 0x56, 0x00},   // 4a 1507 e259 Ã§Â¦Â³
    {0x72, 0x1e, 0x56, 0x7e, 0x35, 0x5d, 0x70, 0x00},   // 4a 1508 e25a Ã§Â¦Â¹
    {0x70, 0x1f, 0x55, 0x7f, 0x35, 0x5f, 0x70, 0x00},   // 4a 1509 e25b Ã§Â¦Âº
    {0x42, 0x56, 0x37, 0x7f, 0x3f, 0x5e, 0x4a, 0x00},   // 4a 150a e25c Ã§Â§â€°
    {0x35, 0x7f, 0x15, 0x7f, 0x24, 0x7f, 0x44, 0x00},   // 4a 150b e25d Ã§Â§â€¢
    {0x35, 0x7f, 0x48, 0x4e, 0x3b, 0x4e, 0x48, 0x00},   // 4a 150c e25e Ã§Â§Â§
    {0x35, 0x7f, 0x15, 0x7f, 0x55, 0x55, 0x5d, 0x00},   // 4a 150d e25f Ã§Â§Â¬
    {0x35, 0x7f, 0x55, 0x22, 0x5f, 0x22, 0x5b, 0x00},   // 4a 150e e260 Ã§Â§Â¡
    {0x35, 0x7f, 0x42, 0x2a, 0x7f, 0x2a, 0x42, 0x00},   // 4a 150f e261 Ã§Â§Â£
    {0x35, 0x7f, 0x28, 0x2f, 0x7d, 0x2f, 0x28, 0x00},   // 4a 1510 e262 Ã§Â¨Ë†
    {0x35, 0x7f, 0x02, 0x7d, 0x2a, 0x7d, 0x02, 0x00},   // 4a 1511 e263 Ã§Â¨Â
    {0x35, 0x7f, 0x52, 0x1f, 0x1a, 0x1f, 0x52, 0x00},   // 4a 1512 e264 Ã§Â¨Ëœ
    {0x35, 0x7f, 0x7a, 0x42, 0x5f, 0x5a, 0x42, 0x00},   // 4a 1513 e265 Ã§Â¨â„¢
    {0x35, 0x7f, 0x7f, 0x35, 0x2f, 0x35, 0x7f, 0x00},   // 4a 1514 e266 Ã§Â¨Â 
    {0x52, 0x5e, 0x3e, 0x7b, 0x3e, 0x5e, 0x52, 0x00},   // 4a 1515 e267 Ã§Â¨Å¸
    {0x52, 0x3e, 0x5e, 0x7b, 0x1e, 0x3e, 0x52, 0x00},   // 4a 1516 e268 Ã§Â¦â‚¬
    {0x35, 0x7f, 0x22, 0x79, 0x3f, 0x79, 0x22, 0x00},   // 4a 1517 e269 Ã§Â¨Â±
    {0x35, 0x7f, 0x72, 0x69, 0x43, 0x69, 0x7a, 0x00},   // 4a 1518 e26a Ã§Â¨Â»
    {0x5a, 0x4a, 0x3e, 0x77, 0x3e, 0x4a, 0x5a, 0x00},   // 4a 1519 e26b Ã§Â¨Â¾
    {0x35, 0x7f, 0x54, 0x53, 0x2b, 0x5f, 0x44, 0x00},   // 4a 151a e26c Ã§Â¨Â·
    {0x35, 0x7f, 0x26, 0x16, 0x6b, 0x76, 0x26, 0x00},   // 4a 151b e26d Ã§Â©Æ’
    {0x35, 0x7f, 0x62, 0x2e, 0x4f, 0x46, 0x6a, 0x00},   // 4a 151c e26e Ã§Â©â€”
    {0x35, 0x7f, 0x3f, 0x2b, 0x33, 0x7f, 0x2b, 0x00},   // 4a 151d e26f Ã§Â©â€°
    {0x35, 0x7f, 0x7a, 0x76, 0x5b, 0x76, 0x7a, 0x00},   // 4a 151e e270 Ã§Â©Â¡
    {0x35, 0x7f, 0x48, 0x3e, 0x48, 0x3f, 0x5a, 0x00},   // 4a 151f e271 Ã§Â©Â¢
    {0x35, 0x7f, 0x62, 0x35, 0x5f, 0x5d, 0x6a, 0x00},   // 4a 1520 e272 Ã§Â©Â©
    {0x35, 0x7f, 0x2a, 0x7e, 0x45, 0x7f, 0x5c, 0x00},   // 4a 1521 e273 Ã©Â¾Â
    {0x35, 0x7f, 0x36, 0x7e, 0x5b, 0x3e, 0x56, 0x00},   // 4a 1522 e274 Ã§Â©Â°
    {0x06, 0x3a, 0x36, 0x33, 0x3e, 0x3a, 0x66, 0x00},   // 4a 1523 e275 Ã§Â©Â¹
    {0x26, 0x3a, 0x76, 0x33, 0x3e, 0x7a, 0x36, 0x00},   // 4a 1524 e276 Ã§Â©Â½
    {0x46, 0x6a, 0x56, 0x03, 0x56, 0x3a, 0x76, 0x00},   // 4a 1525 e277 Ã§ÂªË†
    {0x06, 0x7a, 0x6e, 0x5f, 0x7a, 0x7e, 0x06, 0x00},   // 4a 1526 e278 Ã§Âªâ€”
    {0x56, 0x5a, 0x3e, 0x07, 0x7a, 0x4e, 0x56, 0x00},   // 4a 1527 e279 Ã§Âªâ€¢
    {0x56, 0x52, 0x36, 0x7f, 0x5a, 0x76, 0x16, 0x00},   // 4a 1528 e27a Ã§ÂªËœ
    {0x26, 0x32, 0x6e, 0x7f, 0x6a, 0x2e, 0x26, 0x00},   // 4a 1529 e27b Ã§Âªâ€“
    {0x66, 0x3a, 0x6e, 0x6f, 0x7a, 0x3e, 0x66, 0x00},   // 4a 152a e27c Ã§ÂªÂ©
    {0x06, 0x3a, 0x76, 0x4b, 0x7e, 0x7a, 0x46, 0x00},   // 4a 152b e27d Ã§Â«Ë†
    {0x26, 0x2a, 0x7e, 0x57, 0x7a, 0x56, 0x66, 0x00},   // 4a 152c e27e Ã§ÂªÂ°
    {0x56, 0x5a, 0x7e, 0x57, 0x3e, 0x5a, 0x56, 0x00},   // 4b 152d e280 Ã§ÂªÂ¶
    {0x56, 0x3a, 0x7e, 0x07, 0x52, 0x2e, 0x5e, 0x00},   // 4b 152e e281 Ã§Â«â€¦
    {0x46, 0x7a, 0x16, 0x73, 0x56, 0x3e, 0x46, 0x00},   // 4b 152f e282 Ã§Â«â€ž
    {0x7e, 0x3a, 0x56, 0x57, 0x6a, 0x5e, 0x56, 0x00},   // 4b 1530 e283 Ã§ÂªÂ¿
    {0x55, 0x30, 0x66, 0x56, 0x6b, 0x76, 0x56, 0x00},   // 4b 1531 e284 Ã©â€šÆ’
    {0x46, 0x5a, 0x3e, 0x3f, 0x3a, 0x7e, 0x46, 0x00},   // 4b 1532 e285 Ã§Â«â€¡
    {0x56, 0x3a, 0x7e, 0x27, 0x72, 0x3e, 0x76, 0x00},   // 4b 1533 e286 Ã§Â«Å 
    {0x2e, 0x33, 0x2e, 0x04, 0x7f, 0x04, 0x04, 0x00},   // 4b 1534 e287 Ã§Â«Â
    {0x2e, 0x33, 0x2e, 0x0a, 0x7e, 0x09, 0x08, 0x00},   // 4b 1535 e288 Ã§Â«Â
    {0x2e, 0x33, 0x4e, 0x3b, 0x48, 0x7b, 0x04, 0x00},   // 4b 1536 e289 Ã§Â«â€¢
    {0x2e, 0x33, 0x2e, 0x2a, 0x7e, 0x55, 0x55, 0x00},   // 4b 1537 e28a Ã§Â«â€œ
    {0x2e, 0x33, 0x2e, 0x70, 0x5f, 0x54, 0x74, 0x00},   // 4b 1538 e28b Ã§Â«â„¢
    {0x2e, 0x33, 0x2e, 0x06, 0x4a, 0x7b, 0x0e, 0x00},   // 4b 1539 e28c Ã§Â«Å¡
    {0x2e, 0x33, 0x2e, 0x42, 0x7e, 0x63, 0x5e, 0x00},   // 4b 153a e28d Ã§Â«Â
    {0x2e, 0x33, 0x2e, 0x7d, 0x57, 0x55, 0x7d, 0x00},   // 4b 153b e28e Ã§Â«Â¡
    {0x2e, 0x33, 0x2e, 0x56, 0x5d, 0x34, 0x56, 0x00},   // 4b 153c e28f Ã§Â«Â¢
    {0x2e, 0x33, 0x4e, 0x2e, 0x7f, 0x2a, 0x4e, 0x00},   // 4b 153d e290 Ã§Â«Â¦
    {0x2e, 0x33, 0x1e, 0x37, 0x2d, 0x4f, 0x78, 0x00},   // 4b 153e e291 Ã§Â«Â­
    {0x2e, 0x33, 0x4e, 0x3f, 0x5d, 0x7d, 0x5d, 0x00},   // 4b 153f e292 Ã§Â«Â°
    {0x44, 0x53, 0x3e, 0x54, 0x13, 0x76, 0x42, 0x00},   // 4b 1540 e293 Ã§Â¬â€š
    {0x24, 0x5b, 0x3e, 0x4c, 0x3b, 0x4e, 0x7a, 0x00},   // 4b 1541 e294 Ã§Â¬Â
    {0x44, 0x3b, 0x0e, 0x7c, 0x07, 0x36, 0x42, 0x00},   // 4b 1542 e295 Ã§Â¬Å 
    {0x04, 0x3f, 0x56, 0x5c, 0x57, 0x5e, 0x62, 0x00},   // 4b 1543 e296 Ã§Â¬â€ 
    {0x54, 0x3b, 0x56, 0x74, 0x73, 0x56, 0x72, 0x00},   // 4b 1544 e297 Ã§Â¬Â³
    {0x04, 0x63, 0x66, 0x7c, 0x6b, 0x6e, 0x02, 0x00},   // 4b 1545 e298 Ã§Â¬Ëœ
    {0x54, 0x4b, 0x5e, 0x7c, 0x5b, 0x5e, 0x4a, 0x00},   // 4b 1546 e299 Ã§Â¬â„¢
    {0x14, 0x73, 0x5e, 0x54, 0x53, 0x76, 0x12, 0x00},   // 4b 1547 e29a Ã§Â¬Å¾
    {0x54, 0x03, 0x3e, 0x4c, 0x4b, 0x5e, 0x62, 0x00},   // 4b 1548 e29b Ã§Â¬Âµ
    {0x2c, 0x1b, 0x2e, 0x7c, 0x2b, 0x1e, 0x2a, 0x00},   // 4b 1549 e29c Ã§Â¬Â¨
    {0x44, 0x53, 0x5e, 0x34, 0x53, 0x56, 0x42, 0x00},   // 4b 154a e29d Ã§Â¬Â¶
    {0x04, 0x7b, 0x4e, 0x5c, 0x7b, 0x5e, 0x4a, 0x00},   // 4b 154b e29e Ã§Â­Â
    {0x04, 0x7b, 0x4e, 0x5c, 0x7b, 0x5e, 0x6a, 0x00},   // 4b 154c e29f Ã§Â­Âº
    {0x24, 0x6b, 0x3e, 0x2c, 0x7b, 0x2e, 0x22, 0x00},   // 4b 154d e2a0 Ã§Â¬â€ž
    {0x14, 0x0b, 0x7e, 0x54, 0x7f, 0x06, 0x7e, 0x00},   // 4b 154e e2a1 Ã§Â­Â
    {0x54, 0x53, 0x36, 0x1c, 0x17, 0x1e, 0x0a, 0x00},   // 4b 154f e2a2 Ã§Â¬â€¹
    {0x54, 0x57, 0x5e, 0x74, 0x5b, 0x56, 0x52, 0x00},   // 4b 1550 e2a3 Ã§Â­Å’
    {0x54, 0x5b, 0x36, 0x1c, 0x77, 0x56, 0x52, 0x00},   // 4b 1551 e2a4 Ã§Â­â€¦
    {0x54, 0x2b, 0x46, 0x74, 0x63, 0x7e, 0x6a, 0x00},   // 4b 1552 e2a5 Ã§Â­Âµ
    {0x04, 0x63, 0x6e, 0x7c, 0x6f, 0x66, 0x02, 0x00},   // 4b 1553 e2a6 Ã§Â­Â¥
    {0x54, 0x4b, 0x56, 0x3c, 0x57, 0x4e, 0x52, 0x00},   // 4b 1554 e2a7 Ã§Â­Â´
    {0x44, 0x43, 0x3e, 0x3c, 0x7b, 0x46, 0x62, 0x00},   // 4b 1555 e2a8 Ã§Â­Â§
    {0x14, 0x7b, 0x06, 0x14, 0x7b, 0x2e, 0x2a, 0x00},   // 4b 1556 e2a9 Ã§Â­Â°
    {0x14, 0x7b, 0x3e, 0x04, 0x53, 0x2e, 0x5a, 0x00},   // 4b 1557 e2aa Ã§Â­Â±
    {0x44, 0x3b, 0x56, 0x34, 0x47, 0x3e, 0x56, 0x00},   // 4b 1558 e2ab Ã§Â­Â¬
    {0x54, 0x4b, 0x56, 0x7c, 0x57, 0x4e, 0x52, 0x00},   // 4b 1559 e2ac Ã§Â­Â®
    {0x54, 0x7b, 0x16, 0x7c, 0x53, 0x7e, 0x12, 0x00},   // 4b 155a e2ad Ã§Â®Â
    {0x7c, 0x6b, 0x5e, 0x7c, 0x5b, 0x6e, 0x7a, 0x00},   // 4b 155b e2ae Ã§Â®Ëœ
    {0x44, 0x73, 0x5e, 0x0c, 0x7f, 0x5e, 0x52, 0x00},   // 4b 155c e2af Ã§Â®Å¸
    {0x54, 0x7b, 0x06, 0x7c, 0x5f, 0x7e, 0x5a, 0x00},   // 4b 155d e2b0 Ã§Â®Â
    {0x4c, 0x57, 0x6e, 0x64, 0x7f, 0x56, 0x4e, 0x00},   // 4b 155e e2b1 Ã§Â®Å“
    {0x24, 0x13, 0x6e, 0x74, 0x1b, 0x46, 0x7a, 0x00},   // 4b 155f e2b2 Ã§Â®Å¡
    {0x14, 0x53, 0x56, 0x3c, 0x3b, 0x56, 0x6a, 0x00},   // 4b 1560 e2b3 Ã§Â®â€¹
    {0x1c, 0x6b, 0x2e, 0x7c, 0x2f, 0x6e, 0x1a, 0x00},   // 4b 1561 e2b4 Ã§Â®â€™
    {0x14, 0x1b, 0x56, 0x7c, 0x37, 0x3a, 0x12, 0x00},   // 4b 1562 e2b5 Ã§Â®Â
    {0x14, 0x1b, 0x56, 0x74, 0x3f, 0x36, 0x12, 0x00},   // 4b 1563 e2b6 Ã§Â­Â
    {0x44, 0x3b, 0x7e, 0x04, 0x7b, 0x2e, 0x5a, 0x00},   // 4b 1564 e2b7 Ã§Â®â„¢
    {0x04, 0x7b, 0x5e, 0x6c, 0x5b, 0x6e, 0x4a, 0x00},   // 4b 1565 e2b8 Ã§Â¯â€¹
    {0x44, 0x53, 0x5e, 0x74, 0x5f, 0x52, 0x42, 0x00},   // 4b 1566 e2b9 Ã§Â¯Â
    {0x14, 0x7b, 0x06, 0x54, 0x37, 0x5e, 0x52, 0x00},   // 4b 1567 e2ba Ã§Â¯Å’
    {0x14, 0x7b, 0x56, 0x7c, 0x5b, 0x36, 0x52, 0x00},   // 4b 1568 e2bb Ã§Â¯Â
    {0x44, 0x3b, 0x6e, 0x6c, 0x4b, 0x3e, 0x5a, 0x00},   // 4b 1569 e2bc Ã§Â®Â´
    {0x54, 0x53, 0x3e, 0x54, 0x7f, 0x36, 0x52, 0x00},   // 4b 156a e2bd Ã§Â¯â€ 
    {0x2c, 0x7b, 0x3e, 0x3c, 0x3b, 0x7e, 0x2a, 0x00},   // 4b 156b e2be Ã§Â¯Â
    {0x04, 0x7b, 0x6e, 0x34, 0x17, 0x7e, 0x36, 0x00},   // 4b 156c e2bf Ã§Â¯Â©
    {0x2c, 0x2b, 0x7e, 0x54, 0x3f, 0x4a, 0x4a, 0x00},   // 4b 156d e2c0 Ã§Â°â€˜
    {0x2c, 0x2b, 0x7e, 0x5c, 0x3f, 0x4a, 0x4a, 0x00},   // 4b 156e e2c1 Ã§Â°â€
    {0x44, 0x7f, 0x5a, 0x14, 0x7b, 0x5e, 0x52, 0x00},   // 4b 156f e2c2 Ã§Â¯Â¦
    {0x54, 0x5f, 0x36, 0x7c, 0x37, 0x5e, 0x56, 0x00},   // 4b 1570 e2c3 Ã§Â¯Â¥
    {0x14, 0x7f, 0x36, 0x7c, 0x13, 0x6e, 0x5a, 0x00},   // 4b 1571 e2c4 Ã§Â±Â 
    {0x4c, 0x7b, 0x3e, 0x3c, 0x3f, 0x7a, 0x4a, 0x00},   // 4b 1572 e2c5 Ã§Â°â‚¬
    {0x4c, 0x3b, 0x6e, 0x04, 0x5b, 0x36, 0x52, 0x00},   // 4b 1573 e2c6 Ã§Â°â€¡
    {0x44, 0x3b, 0x6e, 0x7c, 0x03, 0x56, 0x2a, 0x00},   // 4b 1574 e2c7 Ã§Â°â€œ
    {0x14, 0x33, 0x3e, 0x7c, 0x3f, 0x32, 0x12, 0x00},   // 4b 1575 e2c8 Ã§Â¯Â³
    {0x54, 0x33, 0x46, 0x54, 0x5b, 0x7e, 0x52, 0x00},   // 4b 1576 e2c9 Ã§Â¯Â·
    {0x54, 0x5b, 0x36, 0x74, 0x3b, 0x56, 0x5e, 0x00},   // 4b 1577 e2ca Ã§Â°â€”
    {0x54, 0x5b, 0x7e, 0x5c, 0x3f, 0x5a, 0x52, 0x00},   // 4b 1578 e2cb Ã§Â°Â
    {0x54, 0x1b, 0x52, 0x1e, 0x57, 0x16, 0x72, 0x00},   // 4b 1579 e2cc Ã§Â¯Â¶
    {0x54, 0x7f, 0x36, 0x3c, 0x37, 0x7e, 0x52, 0x00},   // 4b 157a e2cd Ã§Â°Â£
    {0x4c, 0x7b, 0x2e, 0x3c, 0x2b, 0x7e, 0x4a, 0x00},   // 4b 157b e2ce Ã§Â°Â§
    {0x14, 0x6b, 0x7e, 0x74, 0x6f, 0x7e, 0x12, 0x00},   // 4b 157c e2cf Ã§Â°Âª
    {0x24, 0x2f, 0x3e, 0x6c, 0x3f, 0x2e, 0x22, 0x00},   // 4b 157d e2d0 Ã§Â°Å¸
    {0x44, 0x3f, 0x2e, 0x74, 0x77, 0x7e, 0x2a, 0x00},   // 4b 157e e2d1 Ã§Â°Â·
    {0x44, 0x3b, 0x6e, 0x04, 0x6f, 0x2e, 0x7a, 0x00},   // 4b 157f e2d2 Ã§Â°Â«
    {0x4c, 0x3b, 0x36, 0x44, 0x37, 0x3a, 0x4a, 0x00},   // 4b 1580 e2d3 Ã§Â°Â½
    {0x14, 0x77, 0x7e, 0x1c, 0x5f, 0x76, 0x12, 0x00},   // 4b 1581 e2d4 Ã§Â±Å’
    {0x44, 0x5b, 0x7e, 0x64, 0x6b, 0x4e, 0x4a, 0x00},   // 4b 1582 e2d5 Ã§Â±Æ’
    {0x54, 0x7b, 0x5e, 0x3c, 0x53, 0x2e, 0x5a, 0x00},   // 4b 1583 e2d6 Ã§Â±â€
    {0x4c, 0x3b, 0x6e, 0x54, 0x3f, 0x3e, 0x52, 0x00},   // 4b 1584 e2d7 Ã§Â±Â
    {0x54, 0x7b, 0x06, 0x1c, 0x77, 0x6a, 0x1a, 0x00},   // 4b 1585 e2d8 Ã§Â±â‚¬
    {0x7c, 0x2b, 0x7e, 0x34, 0x7b, 0x2e, 0x52, 0x00},   // 4b 1586 e2d9 Ã§Â±Â
    {0x7c, 0x2b, 0x7e, 0x2c, 0x7b, 0x3e, 0x5a, 0x00},   // 4b 1587 e2da Ã§Â±Ëœ
    {0x44, 0x2f, 0x7e, 0x2c, 0x5b, 0x1e, 0x5a, 0x00},   // 4b 1588 e2db Ã§Â±Å¸
    {0x54, 0x7b, 0x76, 0x3c, 0x5b, 0x36, 0x52, 0x00},   // 4b 1589 e2dc Ã§Â±Â¤
    {0x54, 0x7b, 0x7e, 0x34, 0x5b, 0x36, 0x52, 0x00},   // 4b 158a e2dd Ã§Â±â€“
    {0x14, 0x73, 0x3e, 0x74, 0x3b, 0x76, 0x12, 0x00},   // 4b 158b e2de Ã§Â±Â¥
    {0x74, 0x5f, 0x76, 0x2c, 0x7f, 0x7e, 0x52, 0x00},   // 4b 158c e2df Ã§Â±Â¬
    {0x35, 0x7e, 0x15, 0x04, 0x7f, 0x04, 0x04, 0x00},   // 4b 158d e2e0 Ã§Â±Âµ
    {0x35, 0x7e, 0x15, 0x7f, 0x24, 0x7f, 0x44, 0x00},   // 4b 158e e2e1 Ã§Â²Æ’
    {0x35, 0x7e, 0x15, 0x40, 0x3d, 0x15, 0x1d, 0x00},   // 4b 158f e2e2 Ã§Â²Â
    {0x10, 0x1e, 0x3a, 0x3f, 0x36, 0x7e, 0x10, 0x00},   // 4b 1590 e2e3 Ã§Â²Â¤
    {0x35, 0x7e, 0x05, 0x72, 0x55, 0x76, 0x04, 0x00},   // 4b 1591 e2e4 Ã§Â²Â­
    {0x59, 0x50, 0x34, 0x7b, 0x36, 0x5a, 0x56, 0x00},   // 4b 1592 e2e5 Ã§Â²Â¢
    {0x35, 0x7e, 0x7d, 0x07, 0x7d, 0x05, 0x7d, 0x00},   // 4b 1593 e2e6 Ã§Â²Â«
    {0x35, 0x7e, 0x15, 0x7f, 0x35, 0x35, 0x7f, 0x00},   // 4b 1594 e2e7 Ã§Â²Â¡
    {0x35, 0x7e, 0x15, 0x7d, 0x57, 0x55, 0x7d, 0x00},   // 4b 1595 e2e8 Ã§Â²Â¨
    {0x35, 0x7e, 0x41, 0x57, 0x3f, 0x47, 0x41, 0x00},   // 4b 1596 e2e9 Ã§Â²Â³
    {0x54, 0x5c, 0x3b, 0x76, 0x3b, 0x55, 0x5b, 0x00},   // 4b 1597 e2ea Ã§Â²Â²
    {0x55, 0x50, 0x39, 0x77, 0x39, 0x5f, 0x54, 0x00},   // 4b 1598 e2eb Ã§Â²Â±
    {0x35, 0x7e, 0x15, 0x7e, 0x5a, 0x3b, 0x5e, 0x00},   // 4b 1599 e2ec Ã§Â²Â®
    {0x35, 0x7e, 0x32, 0x2e, 0x73, 0x2e, 0x32, 0x00},   // 4b 159a e2ed Ã§Â²Â¹
    {0x35, 0x7e, 0x56, 0x1a, 0x7b, 0x1a, 0x56, 0x00},   // 4b 159b e2ee Ã§Â²Â½
    {0x35, 0x7e, 0x12, 0x7b, 0x02, 0x7f, 0x52, 0x00},   // 4b 159c e2ef Ã§Â³â‚¬
    {0x35, 0x7e, 0x5a, 0x37, 0x7f, 0x33, 0x56, 0x00},   // 4b 159d e2f0 Ã§Â³â€¦
    {0x35, 0x7e, 0x72, 0x5f, 0x72, 0x5f, 0x52, 0x00},   // 4b 159e e2f1 Ã§Â³â€š
    {0x35, 0x7e, 0x26, 0x5a, 0x7b, 0x2a, 0x56, 0x00},   // 4b 159f e2f2 Ã§Â³Ëœ
    {0x35, 0x7e, 0x3a, 0x0f, 0x6a, 0x2f, 0x6a, 0x00},   // 4b 15a0 e2f3 Ã§Â³â€™
    {0x40, 0x3e, 0x56, 0x3e, 0x77, 0x3e, 0x56, 0x00},   // 4b 15a1 e2f4 Ã§Â³Å“
    {0x35, 0x7e, 0x52, 0x5f, 0x36, 0x5f, 0x52, 0x00},   // 4b 15a2 e2f5 Ã§Â³Â¢
    {0x6d, 0x3f, 0x2a, 0x6f, 0x2a, 0x3d, 0x6f, 0x00},   // 4b 15a3 e2f6 Ã©Â¬Â»
    {0x35, 0x7e, 0x66, 0x2b, 0x7f, 0x2b, 0x66, 0x00},   // 4b 15a4 e2f7 Ã§Â³Â¯
    {0x35, 0x7e, 0x55, 0x3f, 0x6d, 0x3f, 0x6d, 0x00},   // 4b 15a5 e2f8 Ã§Â³Â²
    {0x34, 0x7b, 0x14, 0x21, 0x7b, 0x71, 0x5b, 0x00},   // 4b 15a6 e2f9 Ã§Â³Â´
    {0x37, 0x7e, 0x17, 0x21, 0x7b, 0x71, 0x5b, 0x00},   // 4b 15a7 e2fa Ã§Â³Â¶
    {0x2a, 0x75, 0x28, 0x00, 0x7f, 0x40, 0x60, 0x00},   // 4b 15a8 e2fb Ã§Â³Âº
    {0x2a, 0x75, 0x08, 0x49, 0x7f, 0x09, 0x08, 0x00},   // 4b 15a9 e2fc Ã§Â´â€ 
    {0x2a, 0x75, 0x22, 0x0a, 0x52, 0x7f, 0x02, 0x00},   // 4c 15aa e340 Ã§Â´â€š
    {0x2a, 0x75, 0x44, 0x65, 0x5d, 0x25, 0x44, 0x00},   // 4c 15ab e341 Ã§Â´Å“
    {0x2a, 0x75, 0x28, 0x7f, 0x24, 0x7f, 0x44, 0x00},   // 4c 15ac e342 Ã§Â´â€¢
    {0x52, 0x12, 0x36, 0x6b, 0x36, 0x12, 0x52, 0x00},   // 4c 15ad e343 Ã§Â´Å 
    {0x2a, 0x75, 0x7f, 0x1d, 0x15, 0x5d, 0x7f, 0x00},   // 4c 15ae e344 Ã§Âµâ€¦
    {0x2a, 0x75, 0x48, 0x3e, 0x62, 0x5b, 0x62, 0x00},   // 4c 15af e345 Ã§Âµâ€¹
    {0x4a, 0x16, 0x1f, 0x76, 0x1f, 0x18, 0x4c, 0x00},   // 4c 15b0 e346 Ã§Â´Â®
    {0x2a, 0x75, 0x7f, 0x44, 0x5f, 0x54, 0x5f, 0x00},   // 4c 15b1 e347 Ã§Â´Â²
    {0x2a, 0x75, 0x08, 0x6c, 0x6b, 0x64, 0x08, 0x00},   // 4c 15b2 e348 Ã§Â´Â¿
    {0x2a, 0x75, 0x28, 0x06, 0x4a, 0x7b, 0x0e, 0x00},   // 4c 15b3 e349 Ã§Â´Âµ
    {0x2a, 0x75, 0x2a, 0x29, 0x7c, 0x29, 0x2a, 0x00},   // 4c 15b4 e34a Ã§Âµâ€ 
    {0x2a, 0x75, 0x28, 0x2a, 0x35, 0x7b, 0x28, 0x00},   // 4c 15b5 e34b Ã§ÂµÂ³
    {0x2a, 0x75, 0x4a, 0x3c, 0x0f, 0x7c, 0x4a, 0x00},   // 4c 15b6 e34c Ã§Âµâ€“
    {0x2a, 0x75, 0x0a, 0x7d, 0x00, 0x45, 0x7d, 0x00},   // 4c 15b7 e34d Ã§ÂµÅ½
    {0x2a, 0x75, 0x28, 0x00, 0x2a, 0x75, 0x28, 0x00},   // 4c 15b8 e34e Ã§ÂµÂ²
    {0x2a, 0x75, 0x0a, 0x3e, 0x4a, 0x3f, 0x52, 0x00},   // 4c 15b9 e34f Ã§ÂµÂ¨
    {0x4a, 0x1e, 0x1b, 0x76, 0x1f, 0x19, 0x4f, 0x00},   // 4c 15ba e350 Ã§ÂµÂ®
    {0x2a, 0x75, 0x2e, 0x4a, 0x5f, 0x2e, 0x50, 0x00},   // 4c 15bb e351 Ã§ÂµÂ
    {0x2a, 0x75, 0x54, 0x3d, 0x14, 0x7d, 0x14, 0x00},   // 4c 15bc e352 Ã§ÂµÂ£
    {0x2a, 0x75, 0x28, 0x55, 0x5b, 0x75, 0x5b, 0x00},   // 4c 15bd e353 Ã§Â¶â€œ
    {0x2a, 0x75, 0x5a, 0x37, 0x1f, 0x37, 0x6a, 0x00},   // 4c 15be e354 Ã§Â¶â€°
    {0x04, 0x7e, 0x5f, 0x1a, 0x75, 0x1b, 0x50, 0x00},   // 4c 15bf e355 Ã§Âµâ€º
    {0x2a, 0x75, 0x52, 0x71, 0x5b, 0x31, 0x52, 0x00},   // 4c 15c0 e356 Ã§Â¶Â
    {0x2a, 0x75, 0x28, 0x77, 0x5d, 0x55, 0x77, 0x00},   // 4c 15c1 e357 Ã§ÂµÂ½
    {0x2a, 0x75, 0x69, 0x2b, 0x45, 0x4b, 0x6f, 0x00},   // 4c 15c2 e358 Ã§Â¶â€º
    {0x2a, 0x75, 0x12, 0x5a, 0x17, 0x7a, 0x12, 0x00},   // 4c 15c3 e359 Ã§Â¶Âº
    {0x49, 0x17, 0x15, 0x77, 0x1a, 0x15, 0x4b, 0x00},   // 4c 15c4 e35a Ã§Â¶Â®
    {0x2a, 0x75, 0x16, 0x6d, 0x56, 0x4d, 0x16, 0x00},   // 4c 15c5 e35b Ã§Â¶Â£
    {0x2a, 0x75, 0x52, 0x31, 0x7b, 0x31, 0x52, 0x00},   // 4c 15c6 e35c Ã§Â¶Âµ
    {0x2a, 0x75, 0x28, 0x7a, 0x5d, 0x7a, 0x7d, 0x00},   // 4c 15c7 e35d Ã§Â·â€¡
    {0x2a, 0x75, 0x28, 0x3c, 0x77, 0x3e, 0x22, 0x00},   // 4c 15c8 e35e Ã§Â¶Â½
    {0x2a, 0x75, 0x28, 0x52, 0x5b, 0x36, 0x5b, 0x00},   // 4c 15c9 e35f Ã§Â¶Â«
    {0x2a, 0x75, 0x68, 0x2e, 0x4f, 0x4e, 0x6e, 0x00},   // 4c 15ca e360 Ã§Â¸Â½
    {0x2a, 0x75, 0x7f, 0x35, 0x2f, 0x35, 0x7f, 0x00},   // 4c 15cb e361 Ã§Â¶Â¢
    {0x2a, 0x75, 0x64, 0x4b, 0x7e, 0x6a, 0x7e, 0x00},   // 4c 15cc e362 Ã§Â¶Â¯
    {0x70, 0x1e, 0x7b, 0x5e, 0x15, 0x7b, 0x51, 0x00},   // 4c 15cd e363 Ã§Â·Å“
    {0x2a, 0x75, 0x24, 0x72, 0x35, 0x76, 0x74, 0x00},   // 4c 15ce e364 Ã§Â¶Â¸
    {0x2a, 0x75, 0x29, 0x5f, 0x55, 0x3d, 0x57, 0x00},   // 4c 15cf e365 Ã§Â¶Å¸
    {0x2a, 0x75, 0x26, 0x7a, 0x5b, 0x5a, 0x76, 0x00},   // 4c 15d0 e366 Ã§Â¶Â°
    {0x2a, 0x75, 0x3e, 0x6a, 0x6a, 0x3f, 0x52, 0x00},   // 4c 15d1 e367 Ã§Â·Ëœ
    {0x2a, 0x75, 0x24, 0x3f, 0x2d, 0x7f, 0x24, 0x00},   // 4c 15d2 e368 Ã§Â·Â
    {0x2a, 0x75, 0x5f, 0x32, 0x77, 0x36, 0x57, 0x00},   // 4c 15d3 e369 Ã§Â·Â¤
    {0x2a, 0x75, 0x7e, 0x15, 0x5b, 0x29, 0x5b, 0x00},   // 4c 15d4 e36a Ã§Â·Å¾
    {0x2a, 0x75, 0x2d, 0x3b, 0x69, 0x3f, 0x5e, 0x00},   // 4c 15d5 e36b Ã§Â·Â»
    {0x2a, 0x75, 0x7f, 0x55, 0x7f, 0x46, 0x2f, 0x00},   // 4c 15d6 e36c Ã§Â·Â²
    {0x2a, 0x75, 0x28, 0x1f, 0x75, 0x6d, 0x77, 0x00},   // 4c 15d7 e36d Ã§Â·Â¡
    {0x2a, 0x75, 0x7e, 0x2e, 0x56, 0x3f, 0x52, 0x00},   // 4c 15d8 e36e Ã§Â¸â€¦
    {0x2a, 0x75, 0x52, 0x6d, 0x64, 0x6d, 0x52, 0x00},   // 4c 15d9 e36f Ã§Â¸Å 
    {0x5e, 0x17, 0x77, 0x50, 0x15, 0x7b, 0x51, 0x00},   // 4c 15da e370 Ã§Â¸Â£
    {0x2a, 0x75, 0x2e, 0x3a, 0x6f, 0x3a, 0x2e, 0x00},   // 4c 15db e371 Ã§Â¸Â¡
    {0x2a, 0x75, 0x4a, 0x3b, 0x5e, 0x7b, 0x5a, 0x00},   // 4c 15dc e372 Ã§Â¸â€™
    {0x2a, 0x75, 0x0a, 0x7d, 0x22, 0x79, 0x52, 0x00},   // 4c 15dd e373 Ã§Â¸Â±
    {0x2a, 0x75, 0x18, 0x37, 0x5f, 0x7b, 0x15, 0x00},   // 4c 15de e374 Ã§Â¸Å¸
    {0x2a, 0x75, 0x0f, 0x7d, 0x59, 0x7f, 0x0d, 0x00},   // 4c 15df e375 Ã§Â¸â€°
    {0x2a, 0x75, 0x28, 0x75, 0x40, 0x7e, 0x77, 0x00},   // 4c 15e0 e376 Ã§Â¸â€¹
    {0x7f, 0x15, 0x7f, 0x1d, 0x76, 0x0d, 0x56, 0x00},   // 4c 15e1 e377 Ã§Â¸Â¢
    {0x2a, 0x75, 0x11, 0x4b, 0x54, 0x29, 0x13, 0x00},   // 4c 15e2 e378 Ã§Â¹â€ 
    {0x2a, 0x75, 0x5d, 0x77, 0x5b, 0x7d, 0x5b, 0x00},   // 4c 15e3 e379 Ã§Â¹Â¦
    {0x40, 0x3e, 0x56, 0x1e, 0x77, 0x0e, 0x56, 0x00},   // 4c 15e4 e37a Ã§Â¸Â»
    {0x2a, 0x75, 0x4c, 0x5f, 0x2d, 0x5f, 0x4c, 0x00},   // 4c 15e5 e37b Ã§Â¸Âµ
    {0x2a, 0x75, 0x51, 0x17, 0x77, 0x17, 0x51, 0x00},   // 4c 15e6 e37c Ã§Â¸Â¹
    {0x2a, 0x75, 0x3b, 0x7a, 0x43, 0x3a, 0x7b, 0x00},   // 4c 15e7 e37d Ã§Â¹Æ’
    {0x2a, 0x75, 0x54, 0x7e, 0x5b, 0x3e, 0x54, 0x00},   // 4c 15e8 e37e Ã§Â¸Â·
    {0x2a, 0x75, 0x57, 0x1d, 0x77, 0x15, 0x57, 0x00},   // 4d 15e9 e380 Ã§Â¸Â²
    {0x2a, 0x75, 0x28, 0x75, 0x5e, 0x7f, 0x52, 0x00},   // 4d 15ea e381 Ã§Â¸Âº
    {0x2a, 0x75, 0x56, 0x73, 0x57, 0x33, 0x56, 0x00},   // 4d 15eb e382 Ã§Â¹Â§
    {0x2a, 0x75, 0x7f, 0x23, 0x18, 0x3b, 0x7f, 0x00},   // 4d 15ec e383 Ã§Â¹Â
    {0x2a, 0x75, 0x0a, 0x7f, 0x7e, 0x23, 0x5e, 0x00},   // 4d 15ed e384 Ã§Â¹â€“
    {0x2a, 0x75, 0x5c, 0x3e, 0x17, 0x7e, 0x5c, 0x00},   // 4d 15ee e385 Ã§Â¹Å¾
    {0x2a, 0x75, 0x15, 0x6f, 0x7d, 0x6f, 0x15, 0x00},   // 4d 15ef e386 Ã§Â¹â„¢
    {0x2a, 0x75, 0x4a, 0x1e, 0x6b, 0x1e, 0x4a, 0x00},   // 4d 15f0 e387 Ã§Â¹Å¡
    {0x2a, 0x75, 0x2b, 0x3b, 0x6f, 0x3b, 0x2b, 0x00},   // 4d 15f1 e388 Ã§Â¹Â¹
    {0x2a, 0x75, 0x1c, 0x76, 0x5d, 0x76, 0x1c, 0x00},   // 4d 15f2 e389 Ã§Â¹Âª
    {0x2a, 0x75, 0x1b, 0x7f, 0x41, 0x7f, 0x5b, 0x00},   // 4d 15f3 e38a Ã§Â¹Â©
    {0x2a, 0x75, 0x7f, 0x6a, 0x5d, 0x6a, 0x5d, 0x00},   // 4d 15f4 e38b Ã§Â¹Â¼
    {0x2a, 0x75, 0x66, 0x2b, 0x7f, 0x2b, 0x66, 0x00},   // 4d 15f5 e38c Ã§Â¹Â»
    {0x2a, 0x75, 0x4a, 0x36, 0x2b, 0x76, 0x0a, 0x00},   // 4d 15f6 e38d Ã§ÂºÆ’
    {0x2a, 0x75, 0x52, 0x36, 0x2b, 0x76, 0x12, 0x00},   // 4d 15f7 e38e Ã§Â·â€¢
    {0x2a, 0x75, 0x4e, 0x3a, 0x37, 0x3a, 0x46, 0x00},   // 4d 15f8 e38f Ã§Â¹Â½
    {0x56, 0x3b, 0x2e, 0x75, 0x2e, 0x7b, 0x16, 0x00},   // 4d 15f9 e390 Ã¨Â¾Â®
    {0x2a, 0x75, 0x4f, 0x69, 0x60, 0x6b, 0x4a, 0x00},   // 4d 15fa e391 Ã§Â¹Â¿
    {0x2a, 0x75, 0x2a, 0x6f, 0x6a, 0x1f, 0x5d, 0x00},   // 4d 15fb e392 Ã§ÂºË†
    {0x2a, 0x75, 0x4a, 0x37, 0x3a, 0x37, 0x4a, 0x00},   // 4d 15fc e393 Ã§Âºâ€°
    {0x2a, 0x75, 0x4e, 0x3e, 0x3b, 0x3e, 0x4e, 0x00},   // 4d 15fd e394 Ã§ÂºÅ’
    {0x2a, 0x75, 0x3f, 0x45, 0x57, 0x67, 0x55, 0x00},   // 4d 15fe e395 Ã§Âºâ€™
    {0x2a, 0x75, 0x56, 0x23, 0x56, 0x1f, 0x5d, 0x00},   // 4d 15ff e396 Ã§ÂºÂ
    {0x2a, 0x75, 0x57, 0x7b, 0x54, 0x33, 0x57, 0x00},   // 4d 1600 e397 Ã§Âºâ€œ
    {0x2a, 0x75, 0x28, 0x52, 0x2d, 0x7f, 0x56, 0x00},   // 4d 1601 e398 Ã§Âºâ€
    {0x2a, 0x75, 0x55, 0x7e, 0x55, 0x3f, 0x55, 0x00},   // 4d 1602 e399 Ã§Âºâ€“
    {0x2a, 0x75, 0x54, 0x7f, 0x54, 0x3f, 0x55, 0x00},   // 4d 1603 e39a Ã§ÂºÅ½
    {0x34, 0x7e, 0x3e, 0x4f, 0x3e, 0x6e, 0x34, 0x00},   // 4d 1604 e39b Ã§Âºâ€º
    {0x2a, 0x75, 0x47, 0x3d, 0x38, 0x7f, 0x46, 0x00},   // 4d 1605 e39c Ã§ÂºÅ“
    {0x6c, 0x4b, 0x7e, 0x6a, 0x42, 0x7e, 0x42, 0x00},   // 4d 1606 e39d Ã§Â¼Â¸
    {0x6c, 0x4b, 0x7e, 0x6a, 0x4a, 0x3f, 0x4e, 0x00},   // 4d 1607 e39e Ã§Â¼Âº
    {0x6b, 0x7e, 0x6a, 0x3c, 0x54, 0x7f, 0x1a, 0x00},   // 4d 1608 e39f Ã§Â½â€¦
    {0x14, 0x73, 0x5b, 0x7c, 0x5b, 0x7b, 0x14, 0x00},   // 4d 1609 e3a0 Ã§Â½Å’
    {0x1c, 0x7c, 0x5f, 0x7b, 0x5f, 0x7c, 0x1c, 0x00},   // 4d 160a e3a1 Ã§Â½Â
    {0x6b, 0x7e, 0x4a, 0x6c, 0x57, 0x3f, 0x4c, 0x00},   // 4d 160b e3a2 Ã§Â½Å½
    {0x6b, 0x7e, 0x26, 0x7f, 0x52, 0x7f, 0x56, 0x00},   // 4d 160c e3a3 Ã§Â½Â
    {0x7f, 0x25, 0x1f, 0x29, 0x1f, 0x21, 0x7f, 0x00},   // 4d 160d e3a4 Ã§Â½â€˜
    {0x23, 0x25, 0x2b, 0x79, 0x2f, 0x25, 0x23, 0x00},   // 4d 160e e3a5 Ã§Â½â€¢
    {0x7f, 0x15, 0x77, 0x5d, 0x57, 0x15, 0x7f, 0x00},   // 4d 160f e3a6 Ã§Â½â€
    {0x57, 0x55, 0x37, 0x75, 0x17, 0x35, 0x57, 0x00},   // 4d 1610 e3a7 Ã§Â½Ëœ
    {0x17, 0x75, 0x57, 0x5d, 0x57, 0x75, 0x17, 0x00},   // 4d 1611 e3a8 Ã§Â½Å¸
    {0x47, 0x7d, 0x57, 0x15, 0x37, 0x5d, 0x57, 0x00},   // 4d 1612 e3a9 Ã§Â½Â 
    {0x17, 0x0d, 0x37, 0x3d, 0x77, 0x4d, 0x57, 0x00},   // 4d 1613 e3aa Ã§Â½Â¨
    {0x27, 0x3d, 0x2f, 0x6d, 0x3f, 0x2d, 0x27, 0x00},   // 4d 1614 e3ab Ã§Â½Â©
    {0x57, 0x35, 0x7f, 0x55, 0x37, 0x7d, 0x57, 0x00},   // 4d 1615 e3ac Ã§Â½Â§
    {0x6f, 0x6d, 0x17, 0x35, 0x57, 0x7d, 0x17, 0x00},   // 4d 1616 e3ad Ã§Â½Â¸
    {0x2f, 0x75, 0x27, 0x7d, 0x2f, 0x2d, 0x7f, 0x00},   // 4d 1617 e3ae Ã§Â¾â€š
    {0x47, 0x1d, 0x4f, 0x1d, 0x47, 0x1d, 0x57, 0x00},   // 4d 1618 e3af Ã§Â¾â€ 
    {0x57, 0x35, 0x7f, 0x7d, 0x3f, 0x75, 0x37, 0x00},   // 4d 1619 e3b0 Ã§Â¾Æ’
    {0x2f, 0x75, 0x2f, 0x45, 0x1f, 0x5d, 0x77, 0x00},   // 4d 161a e3b1 Ã§Â¾Ë†
    {0x2f, 0x75, 0x2f, 0x55, 0x1f, 0x7d, 0x17, 0x00},   // 4d 161b e3b2 Ã§Â¾â€¡
    {0x52, 0x56, 0x37, 0x1e, 0x76, 0x57, 0x52, 0x00},   // 4d 161c e3b3 Ã§Â¾Å’
    {0x52, 0x16, 0x57, 0x1e, 0x56, 0x17, 0x52, 0x00},   // 4d 161d e3b4 Ã§Â¾â€
    {0x4a, 0x3a, 0x5b, 0x7e, 0x5a, 0x7b, 0x4a, 0x00},   // 4d 161e e3b5 Ã§Â¾Å¾
    {0x55, 0x3e, 0x15, 0x7e, 0x4a, 0x5e, 0x69, 0x00},   // 4d 161f e3b6 Ã§Â¾Â
    {0x55, 0x3e, 0x15, 0x12, 0x75, 0x16, 0x34, 0x00},   // 4d 1620 e3b7 Ã§Â¾Å¡
    {0x2a, 0x2a, 0x37, 0x7f, 0x3b, 0x2f, 0x22, 0x00},   // 4d 1621 e3b8 Ã§Â¾Â£
    {0x55, 0x3e, 0x15, 0x3f, 0x2d, 0x4f, 0x78, 0x00},   // 4d 1622 e3b9 Ã§Â¾Â¯
    {0x0a, 0x5a, 0x7b, 0x2e, 0x7a, 0x2b, 0x5a, 0x00},   // 4d 1623 e3ba Ã§Â¾Â²
    {0x4a, 0x56, 0x7f, 0x36, 0x7e, 0x57, 0x4a, 0x00},   // 4d 1624 e3bb Ã§Â¾Â¹
    {0x4a, 0x56, 0x5f, 0x36, 0x5e, 0x57, 0x4a, 0x00},   // 4d 1625 e3bc Ã§Â¾Â®
    {0x55, 0x3e, 0x15, 0x4e, 0x7e, 0x7b, 0x4e, 0x00},   // 4d 1626 e3bd Ã§Â¾Â¶
    {0x42, 0x3e, 0x7a, 0x6b, 0x3a, 0x7a, 0x72, 0x00},   // 4d 1627 e3be Ã§Â¾Â¸
    {0x6a, 0x6e, 0x07, 0x7e, 0x06, 0x6f, 0x6a, 0x00},   // 4d 1628 e3bf Ã¨Â­Â±
    {0x5a, 0x2f, 0x5a, 0x55, 0x7f, 0x55, 0x7f, 0x00},   // 4d 1629 e3c0 Ã§Â¿â€¦
    {0x21, 0x35, 0x37, 0x6c, 0x25, 0x3d, 0x33, 0x00},   // 4d 162a e3c1 Ã§Â¿â€ 
    {0x2e, 0x33, 0x2e, 0x15, 0x7f, 0x15, 0x7f, 0x00},   // 4d 162b e3c2 Ã§Â¿Å 
    {0x54, 0x34, 0x7e, 0x0d, 0x5e, 0x34, 0x74, 0x00},   // 4d 162c e3c3 Ã§Â¿â€¢
    {0x55, 0x3e, 0x29, 0x15, 0x7f, 0x15, 0x7f, 0x00},   // 4d 162d e3c4 Ã§Â¿â€
    {0x2a, 0x5a, 0x2f, 0x78, 0x5f, 0x2a, 0x7a, 0x00},   // 4d 162e e3c5 Ã§Â¿Â¡
    {0x52, 0x3e, 0x77, 0x0e, 0x52, 0x3f, 0x72, 0x00},   // 4d 162f e3c6 Ã§Â¿Â¦
    {0x7d, 0x35, 0x70, 0x15, 0x7f, 0x15, 0x7f, 0x00},   // 4d 1630 e3c7 Ã§Â¿Â©
    {0x5f, 0x37, 0x7d, 0x15, 0x5b, 0x35, 0x7b, 0x00},   // 4d 1631 e3c8 Ã§Â¿Â³
    {0x5e, 0x37, 0x7e, 0x55, 0x7f, 0x55, 0x7f, 0x00},   // 4d 1632 e3c9 Ã§Â¿Â¹
    {0x15, 0x6f, 0x7f, 0x35, 0x7f, 0x3b, 0x54, 0x00},   // 4d 1633 e3ca Ã©Â£Å“
    {0x14, 0x0e, 0x66, 0x7f, 0x76, 0x75, 0x14, 0x00},   // 4d 1634 e3cb Ã¨â‚¬â€ 
    {0x28, 0x2a, 0x36, 0x7f, 0x5a, 0x59, 0x48, 0x00},   // 4d 1635 e3cc Ã¨â‚¬â€ž
    {0x48, 0x5a, 0x56, 0x7f, 0x5a, 0x59, 0x48, 0x00},   // 4d 1636 e3cd Ã¨â‚¬â€¹
    {0x52, 0x56, 0x36, 0x7f, 0x36, 0x55, 0x50, 0x00},   // 4d 1637 e3ce Ã¨â‚¬â€™
    {0x2a, 0x7f, 0x29, 0x44, 0x65, 0x5d, 0x65, 0x00},   // 4d 1638 e3cf Ã¨â‚¬Ëœ
    {0x2a, 0x7f, 0x29, 0x7f, 0x49, 0x4f, 0x6f, 0x00},   // 4d 1639 e3d0 Ã¨â‚¬â„¢
    {0x2a, 0x7f, 0x29, 0x7f, 0x55, 0x57, 0x70, 0x00},   // 4d 163a e3d1 Ã¨â‚¬Å“
    {0x2a, 0x7f, 0x3f, 0x2a, 0x7e, 0x1f, 0x7c, 0x00},   // 4d 163b e3d2 Ã¨â‚¬Â¡
    {0x2a, 0x7f, 0x18, 0x37, 0x5f, 0x7b, 0x15, 0x00},   // 4d 163c e3d3 Ã¨â‚¬Â¨
    {0x21, 0x3f, 0x2d, 0x7f, 0x4c, 0x3f, 0x44, 0x00},   // 4d 163d e3d4 Ã¨â‚¬Â¿
    {0x21, 0x3f, 0x7f, 0x7c, 0x40, 0x7f, 0x44, 0x00},   // 4d 163e e3d5 Ã¨â‚¬Â»
    {0x21, 0x3f, 0x7f, 0x5e, 0x31, 0x7e, 0x1e, 0x00},   // 4d 163f e3d6 Ã¨ÂÅ 
    {0x21, 0x3f, 0x7f, 0x12, 0x75, 0x16, 0x34, 0x00},   // 4d 1640 e3d7 Ã¨Ââ€ 
    {0x21, 0x3f, 0x7f, 0x04, 0x76, 0x5e, 0x75, 0x00},   // 4d 1641 e3d8 Ã¨Ââ€™
    {0x21, 0x3f, 0x7f, 0x08, 0x3e, 0x2f, 0x6e, 0x00},   // 4d 1642 e3d9 Ã¨ÂËœ
    {0x45, 0x57, 0x2f, 0x75, 0x2b, 0x55, 0x4b, 0x00},   // 4d 1643 e3da Ã¨ÂÅ¡
    {0x24, 0x2b, 0x36, 0x2a, 0x2e, 0x7a, 0x2e, 0x00},   // 4d 1644 e3db Ã¨ÂÅ¸
    {0x21, 0x3f, 0x7f, 0x46, 0x2a, 0x7b, 0x56, 0x00},   // 4d 1645 e3dc Ã¨ÂÂ¢
    {0x21, 0x3f, 0x7f, 0x52, 0x3d, 0x7a, 0x15, 0x00},   // 4d 1646 e3dd Ã¨ÂÂ¨
    {0x2a, 0x2d, 0x3a, 0x29, 0x2e, 0x7d, 0x2a, 0x00},   // 4d 1647 e3de Ã¨ÂÂ³
    {0x2a, 0x26, 0x37, 0x32, 0x3b, 0x75, 0x2b, 0x00},   // 4d 1648 e3df Ã¨ÂÂ²
    {0x21, 0x3f, 0x7f, 0x6e, 0x2f, 0x4e, 0x6e, 0x00},   // 4d 1649 e3e0 Ã¨ÂÂ°
    {0x2d, 0x3d, 0x7f, 0x07, 0x2f, 0x3f, 0x7d, 0x00},   // 4d 164a e3e1 Ã¨ÂÂ¶
    {0x21, 0x3f, 0x7f, 0x16, 0x5e, 0x7b, 0x16, 0x00},   // 4d 164b e3e2 Ã¨ÂÂ¹
    {0x29, 0x3f, 0x7f, 0x6a, 0x2e, 0x4f, 0x6e, 0x00},   // 4d 164c e3e3 Ã¨ÂÂ½
    {0x28, 0x2a, 0x2a, 0x7f, 0x2a, 0x2e, 0x24, 0x00},   // 4d 164d e3e4 Ã¨ÂÂ¿
    {0x57, 0x3a, 0x5a, 0x28, 0x2a, 0x7f, 0x24, 0x00},   // 4d 164e e3e5 Ã¨â€šâ€ž
    {0x50, 0x7f, 0x55, 0x75, 0x2a, 0x7f, 0x24, 0x00},   // 4d 164f e3e6 Ã¨â€šâ€ 
    {0x48, 0x3a, 0x6e, 0x07, 0x6e, 0x2e, 0x74, 0x00},   // 4d 1650 e3e7 Ã¨â€šâ€¦
    {0x7f, 0x15, 0x7f, 0x40, 0x42, 0x7e, 0x42, 0x00},   // 4d 1651 e3e8 Ã¨â€šâ€º
    {0x02, 0x7e, 0x2a, 0x2b, 0x2a, 0x7a, 0x02, 0x00},   // 4d 1652 e3e9 Ã¨â€šâ€œ
    {0x7f, 0x15, 0x7f, 0x40, 0x44, 0x7f, 0x44, 0x00},   // 4d 1653 e3ea Ã¨â€šÅ¡
    {0x7f, 0x15, 0x7f, 0x7c, 0x15, 0x4f, 0x7c, 0x00},   // 4d 1654 e3eb Ã¨â€šÂ­
    {0x07, 0x79, 0x2d, 0x2d, 0x2d, 0x79, 0x07, 0x00},   // 4d 1655 e3ec Ã¥â€ Â
    {0x7f, 0x15, 0x7f, 0x42, 0x3f, 0x7a, 0x43, 0x00},   // 4d 1656 e3ed Ã¨â€šÂ¬
    {0x7f, 0x15, 0x7f, 0x1f, 0x15, 0x7f, 0x1f, 0x00},   // 4d 1657 e3ee Ã¨Æ’â€º
    {0x09, 0x75, 0x29, 0x2f, 0x2b, 0x79, 0x0b, 0x00},   // 4d 1658 e3ef Ã¨Æ’Â¥
    {0x7f, 0x15, 0x7f, 0x04, 0x7f, 0x2a, 0x2a, 0x00},   // 4d 1659 e3f0 Ã¨Æ’â„¢
    {0x7f, 0x15, 0x7f, 0x7e, 0x4a, 0x5e, 0x69, 0x00},   // 4d 165a e3f1 Ã¨Æ’Â
    {0x0e, 0x7a, 0x2a, 0x2f, 0x2a, 0x7a, 0x0e, 0x00},   // 4d 165b e3f2 Ã¨Æ’â€ž
    {0x7f, 0x15, 0x7f, 0x49, 0x45, 0x7f, 0x49, 0x00},   // 4d 165c e3f3 Ã¨Æ’Å¡
    {0x7f, 0x15, 0x7f, 0x29, 0x7c, 0x29, 0x2a, 0x00},   // 4d 165d e3f4 Ã¨Æ’â€“
    {0x7f, 0x15, 0x7f, 0x28, 0x5d, 0x7d, 0x28, 0x00},   // 4d 165e e3f5 Ã¨â€žâ€°
    {0x7f, 0x15, 0x7f, 0x0a, 0x36, 0x37, 0x6a, 0x00},   // 4d 165f e3f6 Ã¨Æ’Â¯
    {0x7f, 0x15, 0x7f, 0x4a, 0x3c, 0x7f, 0x4a, 0x00},   // 4d 1660 e3f7 Ã¨Æ’Â±
    {0x7f, 0x15, 0x7f, 0x55, 0x5b, 0x75, 0x5b, 0x00},   // 4d 1661 e3f8 Ã¨â€žâ€º
    {0x04, 0x7e, 0x3f, 0x7a, 0x2d, 0x7b, 0x08, 0x00},   // 4d 1662 e3f9 Ã¨â€žÂ©
    {0x08, 0x77, 0x3f, 0x3b, 0x37, 0x7b, 0x09, 0x00},   // 4d 1663 e3fa Ã¨â€žÂ£
    {0x7f, 0x15, 0x7f, 0x7a, 0x7f, 0x2a, 0x7b, 0x00},   // 4d 1664 e3fb Ã¨â€žÂ¯
    {0x7f, 0x15, 0x7f, 0x12, 0x7e, 0x2b, 0x5a, 0x00},   // 4d 1665 e3fc Ã¨â€¦â€¹
    {0x7f, 0x25, 0x1b, 0x76, 0x3b, 0x7e, 0x0a, 0x00},   // 4e 1666 e440 Ã©Å¡â€¹
    {0x7f, 0x15, 0x7f, 0x5e, 0x1f, 0x1a, 0x5f, 0x00},   // 4e 1667 e441 Ã¨â€¦â€ 
    {0x7f, 0x15, 0x7f, 0x2e, 0x3f, 0x7a, 0x2e, 0x00},   // 4e 1668 e442 Ã¨â€žÂ¾
    {0x7f, 0x15, 0x7f, 0x2a, 0x7f, 0x7f, 0x2a, 0x00},   // 4e 1669 e443 Ã¨â€¦â€œ
    {0x7f, 0x15, 0x7f, 0x3e, 0x7a, 0x13, 0x7a, 0x00},   // 4e 166a e444 Ã¨â€¦â€˜
    {0x7f, 0x15, 0x7f, 0x54, 0x3d, 0x14, 0x7d, 0x00},   // 4e 166b e445 Ã¨Æ’Â¼
    {0x7f, 0x15, 0x7f, 0x49, 0x37, 0x4a, 0x5f, 0x00},   // 4e 166c e446 Ã¨â€¦Â±
    {0x7f, 0x15, 0x7f, 0x6f, 0x2d, 0x4f, 0x6f, 0x00},   // 4e 166d e447 Ã¨â€¦Â®
    {0x7f, 0x15, 0x7f, 0x48, 0x57, 0x7d, 0x57, 0x00},   // 4e 166e e448 Ã¨â€¦Â¥
    {0x7f, 0x15, 0x7f, 0x7a, 0x6d, 0x5a, 0x7d, 0x00},   // 4e 166f e449 Ã¨â€¦Â¦
    {0x7f, 0x15, 0x7f, 0x5e, 0x55, 0x3e, 0x5e, 0x00},   // 4e 1670 e44a Ã¨â€¦Â´
    {0x7f, 0x15, 0x7f, 0x4f, 0x6d, 0x6b, 0x4f, 0x00},   // 4e 1671 e44b Ã¨â€ Æ’
    {0x7f, 0x15, 0x7f, 0x79, 0x2f, 0x6f, 0x79, 0x00},   // 4e 1672 e44c Ã¨â€ Ë†
    {0x7f, 0x15, 0x7f, 0x3e, 0x57, 0x7e, 0x13, 0x00},   // 4e 1673 e44d Ã¨â€ Å 
    {0x7f, 0x15, 0x7f, 0x4e, 0x3b, 0x6e, 0x1a, 0x00},   // 4e 1674 e44e Ã¨â€ â‚¬
    {0x0a, 0x77, 0x3e, 0x34, 0x3f, 0x76, 0x0a, 0x00},   // 4e 1675 e44f Ã¨â€ â€š
    {0x7f, 0x15, 0x7f, 0x11, 0x4b, 0x55, 0x2b, 0x00},   // 4e 1676 e450 Ã¨â€ Â 
    {0x7f, 0x15, 0x7f, 0x6d, 0x4f, 0x55, 0x7f, 0x00},   // 4e 1677 e451 Ã¨â€ â€¢
    {0x7f, 0x15, 0x7f, 0x06, 0x53, 0x77, 0x26, 0x00},   // 4e 1678 e452 Ã¨â€ Â¤
    {0x7f, 0x15, 0x7f, 0x56, 0x5a, 0x77, 0x56, 0x00},   // 4e 1679 e453 Ã¨â€ Â£
    {0x7f, 0x15, 0x7f, 0x56, 0x5a, 0x6b, 0x56, 0x00},   // 4e 167a e454 Ã¨â€¦Å¸
    {0x7f, 0x15, 0x7f, 0x24, 0x5f, 0x3e, 0x72, 0x00},   // 4e 167b e455 Ã¨â€ â€œ
    {0x7f, 0x15, 0x7f, 0x36, 0x42, 0x3f, 0x52, 0x00},   // 4e 167c e456 Ã¨â€ Â©
    {0x7f, 0x15, 0x7f, 0x15, 0x6f, 0x7f, 0x15, 0x00},   // 4e 167d e457 Ã¨â€ Â°
    {0x7f, 0x15, 0x7f, 0x2f, 0x72, 0x2f, 0x32, 0x00},   // 4e 167e e458 Ã¨â€ Âµ
    {0x7f, 0x15, 0x7f, 0x16, 0x7d, 0x76, 0x1c, 0x00},   // 4e 167f e459 Ã¨â€ Â¾
    {0x7f, 0x15, 0x7f, 0x65, 0x4a, 0x7f, 0x7a, 0x00},   // 4e 1680 e45a Ã¨â€ Â¸
    {0x7f, 0x15, 0x7f, 0x3e, 0x75, 0x7f, 0x2c, 0x00},   // 4e 1681 e45b Ã¨â€ Â½
    {0x08, 0x77, 0x3b, 0x37, 0x3b, 0x75, 0x0b, 0x00},   // 4e 1682 e45c Ã¨â€¡â‚¬
    {0x04, 0x7f, 0x3b, 0x30, 0x36, 0x7b, 0x06, 0x00},   // 4e 1683 e45d Ã¨â€¡â€š
    {0x40, 0x3e, 0x0e, 0x72, 0x3f, 0x3e, 0x7a, 0x00},   // 4e 1684 e45e Ã¨â€ Âº
    {0x7f, 0x15, 0x7f, 0x36, 0x5d, 0x36, 0x5c, 0x00},   // 4e 1685 e45f Ã¨â€¡â€°
    {0x7f, 0x15, 0x7f, 0x36, 0x2b, 0x76, 0x0a, 0x00},   // 4e 1686 e460 Ã¨â€¡Â
    {0x7f, 0x15, 0x7f, 0x66, 0x2b, 0x7f, 0x6e, 0x00},   // 4e 1687 e461 Ã¨â€¡â€˜
    {0x7f, 0x15, 0x7f, 0x52, 0x1f, 0x56, 0x5f, 0x00},   // 4e 1688 e462 Ã¨â€¡â„¢
    {0x7f, 0x15, 0x7f, 0x72, 0x5d, 0x2e, 0x7d, 0x00},   // 4e 1689 e463 Ã¨â€¡Ëœ
    {0x7f, 0x15, 0x7f, 0x32, 0x2f, 0x4e, 0x7b, 0x00},   // 4e 168a e464 Ã¨â€¡Ë†
    {0x7f, 0x15, 0x7f, 0x44, 0x6f, 0x6a, 0x4a, 0x00},   // 4e 168b e465 Ã¨â€¡Å¡
    {0x7f, 0x15, 0x7f, 0x6f, 0x7a, 0x3f, 0x4a, 0x00},   // 4e 168c e466 Ã¨â€¡Å¸
    {0x7a, 0x1d, 0x5a, 0x37, 0x57, 0x1a, 0x7d, 0x00},   // 4e 168d e467 Ã¨â€¡Â 
    {0x36, 0x54, 0x3e, 0x7a, 0x4a, 0x3f, 0x52, 0x00},   // 4e 168e e468 Ã¨â€¡Â§
    {0x5a, 0x6a, 0x7e, 0x6f, 0x5e, 0x6a, 0x5a, 0x00},   // 4e 168f e469 Ã¨â€¡Âº
    {0x55, 0x7b, 0x5d, 0x2a, 0x7f, 0x2e, 0x5a, 0x00},   // 4e 1690 e46a Ã¨â€¡Â»
    {0x5e, 0x55, 0x20, 0x1f, 0x20, 0x55, 0x5f, 0x00},   // 4e 1691 e46b Ã¨â€¡Â¾
    {0x20, 0x6e, 0x3d, 0x28, 0x7d, 0x2f, 0x20, 0x00},   // 4e 1692 e46c Ã¨Ë†Â
    {0x28, 0x1a, 0x6e, 0x5f, 0x4e, 0x7a, 0x28, 0x00},   // 4e 1693 e46d Ã¨Ë†â€š
    {0x50, 0x5e, 0x35, 0x1c, 0x15, 0x5f, 0x70, 0x00},   // 4e 1694 e46e Ã¨Ë†â€¦
    {0x5e, 0x55, 0x1b, 0x12, 0x1e, 0x55, 0x5f, 0x00},   // 4e 1695 e46f Ã¨Ë†â€¡
    {0x0a, 0x66, 0x7f, 0x56, 0x7f, 0x76, 0x12, 0x00},   // 4e 1696 e470 Ã¨Ë†Å 
    {0x14, 0x74, 0x56, 0x5d, 0x56, 0x74, 0x14, 0x00},   // 4e 1697 e471 Ã¨Ë†Â
    {0x76, 0x5e, 0x75, 0x7e, 0x4a, 0x3e, 0x49, 0x00},   // 4e 1698 e472 Ã¨Ë†Â
    {0x6a, 0x5d, 0x7a, 0x2a, 0x7f, 0x2a, 0x7b, 0x00},   // 4e 1699 e473 Ã¨Ë†â€“
    {0x7e, 0x13, 0x7e, 0x63, 0x58, 0x23, 0x44, 0x00},   // 4e 169a e474 Ã¨Ë†Â©
    {0x7e, 0x13, 0x7e, 0x42, 0x3e, 0x4b, 0x7a, 0x00},   // 4e 169b e475 Ã¨Ë†Â«
    {0x7e, 0x13, 0x7e, 0x1d, 0x15, 0x5d, 0x7f, 0x00},   // 4e 169c e476 Ã¨Ë†Â¸
    {0x7e, 0x13, 0x7e, 0x4a, 0x7f, 0x4a, 0x7e, 0x00},   // 4e 169d e477 Ã¨Ë†Â³
    {0x7e, 0x13, 0x7e, 0x21, 0x6b, 0x39, 0x22, 0x00},   // 4e 169e e478 Ã¨â€°â‚¬
    {0x7e, 0x13, 0x7e, 0x24, 0x1e, 0x6d, 0x62, 0x00},   // 4e 169f e479 Ã¨â€°â„¢
    {0x7e, 0x13, 0x7e, 0x4e, 0x59, 0x2e, 0x5e, 0x00},   // 4e 16a0 e47a Ã¨â€°Ëœ
    {0x7e, 0x13, 0x7e, 0x06, 0x53, 0x77, 0x26, 0x00},   // 4e 16a1 e47b Ã¨â€°Â
    {0x7e, 0x13, 0x7e, 0x7f, 0x5a, 0x7f, 0x1a, 0x00},   // 4e 16a2 e47c Ã¨â€°Å¡
    {0x7e, 0x13, 0x7e, 0x5e, 0x7b, 0x5e, 0x4a, 0x00},   // 4e 16a3 e47d Ã¨â€°Å¸
    {0x7e, 0x13, 0x7e, 0x7b, 0x2e, 0x3b, 0x5a, 0x00},   // 4e 16a4 e47e Ã¨â€°Â¤
    {0x7e, 0x13, 0x7e, 0x76, 0x5b, 0x76, 0x7a, 0x00},   // 4f 16a5 e480 Ã¨â€°Â¢
    {0x7e, 0x13, 0x7e, 0x5f, 0x7a, 0x2f, 0x5a, 0x00},   // 4f 16a6 e481 Ã¨â€°Â¨
    {0x7e, 0x13, 0x7e, 0x12, 0x7d, 0x6f, 0x10, 0x00},   // 4f 16a7 e482 Ã¨â€°Âª
    {0x7e, 0x13, 0x7e, 0x44, 0x6f, 0x6a, 0x4a, 0x00},   // 4f 16a8 e483 Ã¨â€°Â«
    {0x7e, 0x13, 0x7e, 0x41, 0x3d, 0x15, 0x1d, 0x00},   // 4f 16a9 e484 Ã¨Ë†Â®
    {0x5b, 0x3e, 0x5b, 0x7f, 0x55, 0x35, 0x5f, 0x00},   // 4f 16aa e485 Ã¨â€°Â±
    {0x4f, 0x76, 0x77, 0x2f, 0x7a, 0x5d, 0x5b, 0x00},   // 4f 16ab e486 Ã¨â€°Â·
    {0x1e, 0x50, 0x3f, 0x1e, 0x10, 0x7f, 0x1e, 0x00},   // 4f 16ac e487 Ã¨â€°Â¸
    {0x42, 0x42, 0x57, 0x22, 0x57, 0x42, 0x42, 0x00},   // 4f 16ad e488 Ã¨â€°Â¾
    {0x12, 0x0a, 0x1f, 0x2a, 0x0f, 0x4a, 0x7a, 0x00},   // 4f 16ae e489 Ã¨Å Â
    {0x0a, 0x3a, 0x4b, 0x4e, 0x4b, 0x4a, 0x4a, 0x00},   // 4f 16af e48a Ã¨Å â€™
    {0x52, 0x56, 0x37, 0x16, 0x77, 0x56, 0x52, 0x00},   // 4f 16b0 e48b Ã¨Å Â«
    {0x4a, 0x46, 0x5b, 0x2a, 0x5b, 0x4e, 0x4a, 0x00},   // 4f 16b1 e48c Ã¨Å Å¸
    {0x24, 0x5b, 0x7e, 0x36, 0x12, 0x5a, 0x7e, 0x00},   // 4f 16b2 e48d Ã¨Å Â»
    {0x12, 0x4a, 0x57, 0x32, 0x57, 0x7a, 0x12, 0x00},   // 4f 16b3 e48e Ã¨Å Â¬
    {0x22, 0x1e, 0x53, 0x46, 0x2b, 0x3e, 0x42, 0x00},   // 4f 16b4 e48f Ã¨â€¹Â¡
    {0x02, 0x7e, 0x57, 0x56, 0x57, 0x5e, 0x46, 0x00},   // 4f 16b5 e490 Ã¨â€¹Â£
    {0x12, 0x0a, 0x6f, 0x6a, 0x0f, 0x4a, 0x7a, 0x00},   // 4f 16b6 e491 Ã¨â€¹Å¸
    {0x22, 0x7e, 0x2b, 0x3e, 0x2b, 0x7e, 0x22, 0x00},   // 4f 16b7 e492 Ã¨â€¹â€™
    {0x42, 0x7e, 0x57, 0x56, 0x57, 0x7e, 0x42, 0x00},   // 4f 16b8 e493 Ã¨â€¹Â´
    {0x22, 0x2a, 0x2b, 0x56, 0x1f, 0x22, 0x22, 0x00},   // 4f 16b9 e494 Ã¨â€¹Â³
    {0x0a, 0x3a, 0x2f, 0x3e, 0x6b, 0x7e, 0x2a, 0x00},   // 4f 16ba e495 Ã¨â€¹Âº
    {0x0a, 0x36, 0x2f, 0x3e, 0x6b, 0x7e, 0x2a, 0x00},   // 4f 16bb e496 Ã¨Å½â€œ
    {0x56, 0x02, 0x3f, 0x46, 0x57, 0x5e, 0x62, 0x00},   // 4f 16bc e497 Ã¨Å’Æ’
    {0x12, 0x7a, 0x07, 0x2a, 0x4b, 0x7e, 0x0a, 0x00},   // 4f 16bd e498 Ã¨â€¹Â»
    {0x22, 0x2a, 0x27, 0x7e, 0x27, 0x2a, 0x22, 0x00},   // 4f 16be e499 Ã¨â€¹Â¹
    {0x0a, 0x06, 0x7f, 0x56, 0x5f, 0x42, 0x5e, 0x00},   // 4f 16bf e49a Ã¨â€¹Å¾
    {0x3a, 0x6a, 0x37, 0x02, 0x7f, 0x06, 0x3e, 0x00},   // 4f 16c0 e49b Ã¨Å’â€ 
    {0x02, 0x7e, 0x57, 0x56, 0x57, 0x7e, 0x02, 0x00},   // 4f 16c1 e49c Ã¨â€¹Å“
    {0x4a, 0x5a, 0x3b, 0x7e, 0x3b, 0x5a, 0x4a, 0x00},   // 4f 16c2 e49d Ã¨Å’â€°
    {0x4a, 0x4a, 0x7b, 0x4e, 0x6b, 0x5a, 0x4a, 0x00},   // 4f 16c3 e49e Ã¨â€¹â„¢
    {0x7e, 0x42, 0x6b, 0x5e, 0x6b, 0x42, 0x7e, 0x00},   // 4f 16c4 e49f Ã¨Å’Âµ
    {0x7e, 0x46, 0x7f, 0x6e, 0x7f, 0x46, 0x7e, 0x00},   // 4f 16c5 e4a0 Ã¨Å’Â´
    {0x22, 0x2a, 0x6b, 0x56, 0x6f, 0x22, 0x22, 0x00},   // 4f 16c6 e4a1 Ã¨Å’â€“
    {0x6a, 0x56, 0x63, 0x02, 0x6b, 0x56, 0x62, 0x00},   // 4f 16c7 e4a2 Ã¨Å’Â²
    {0x52, 0x5a, 0x37, 0x7e, 0x37, 0x56, 0x52, 0x00},   // 4f 16c8 e4a3 Ã¨Å’Â±
    {0x0a, 0x06, 0x7f, 0x56, 0x7f, 0x06, 0x7e, 0x00},   // 4f 16c9 e4a4 Ã¨Ââ‚¬
    {0x4a, 0x5a, 0x2f, 0x5a, 0x7b, 0x4a, 0x7a, 0x00},   // 4f 16ca e4a5 Ã¨Å’Â¹
    {0x12, 0x7a, 0x17, 0x52, 0x77, 0x1e, 0x12, 0x00},   // 4f 16cb e4a6 Ã¨ÂÂ
    {0x12, 0x12, 0x6b, 0x6e, 0x6b, 0x12, 0x12, 0x00},   // 4f 16cc e4a7 Ã¨Ââ€¦
    {0x12, 0x7a, 0x07, 0x4a, 0x3f, 0x4a, 0x4a, 0x00},   // 4f 16cd e4a8 Ã¨Å’Â¯
    {0x56, 0x02, 0x0b, 0x7a, 0x4f, 0x4a, 0x4a, 0x00},   // 4f 16ce e4a9 Ã¨Å’Â«
    {0x22, 0x2a, 0x2b, 0x76, 0x57, 0x5e, 0x72, 0x00},   // 4f 16cf e4aa Ã¨Å’â€”
    {0x52, 0x36, 0x5f, 0x76, 0x37, 0x5e, 0x72, 0x00},   // 4f 16d0 e4ab Ã¨Å’Ëœ
    {0x12, 0x7a, 0x07, 0x4a, 0x7b, 0x6e, 0x5a, 0x00},   // 4f 16d1 e4ac Ã¨Å½â€¦
    {0x56, 0x2e, 0x43, 0x76, 0x67, 0x7e, 0x6a, 0x00},   // 4f 16d2 e4ad Ã¨Å½Å¡
    {0x2a, 0x2e, 0x7f, 0x0a, 0x5f, 0x2a, 0x56, 0x00},   // 4f 16d3 e4ae Ã¨Å½Âª
    {0x0a, 0x6a, 0x67, 0x6a, 0x7b, 0x66, 0x0a, 0x00},   // 4f 16d4 e4af Ã¨Å½Å¸
    {0x52, 0x4e, 0x53, 0x3e, 0x53, 0x4e, 0x52, 0x00},   // 4f 16d5 e4b0 Ã¨Å½Â¢
    {0x5a, 0x56, 0x53, 0x7a, 0x57, 0x5a, 0x56, 0x00},   // 4f 16d6 e4b1 Ã¨Å½â€“
    {0x52, 0x5a, 0x53, 0x3e, 0x57, 0x5e, 0x52, 0x00},   // 4f 16d7 e4b2 Ã¨Å’Â£
    {0x56, 0x02, 0x13, 0x4e, 0x5f, 0x26, 0x0a, 0x00},   // 4f 16d8 e4b3 Ã¨Å½Å½
    {0x42, 0x7e, 0x57, 0x3e, 0x6b, 0x1e, 0x7a, 0x00},   // 4f 16d9 e4b4 Ã¨Å½â€¡
    {0x5a, 0x32, 0x7f, 0x12, 0x53, 0x7a, 0x52, 0x00},   // 4f 16da e4b5 Ã¨Å½Å 
    {0x4a, 0x3a, 0x57, 0x7e, 0x17, 0x3a, 0x4a, 0x00},   // 4f 16db e4b6 Ã¨ÂÂ¼
    {0x42, 0x5e, 0x37, 0x1e, 0x77, 0x5e, 0x62, 0x00},   // 4f 16dc e4b7 Ã¨Å½Âµ
    {0x42, 0x5e, 0x77, 0x56, 0x77, 0x5e, 0x42, 0x00},   // 4f 16dd e4b8 Ã¨ÂÂ³
    {0x62, 0x36, 0x57, 0x4e, 0x57, 0x1e, 0x62, 0x00},   // 4f 16de e4b9 Ã¨ÂÂµ
    {0x4a, 0x5a, 0x37, 0x1e, 0x37, 0x6a, 0x0a, 0x00},   // 4f 16df e4ba Ã¨Å½Â 
    {0x52, 0x36, 0x7f, 0x36, 0x1b, 0x42, 0x7a, 0x00},   // 4f 16e0 e4bb Ã¨Å½â€°
    {0x42, 0x7e, 0x57, 0x16, 0x37, 0x5e, 0x42, 0x00},   // 4f 16e1 e4bc Ã¨Å½Â¨
    {0x0a, 0x3a, 0x37, 0x3a, 0x77, 0x7a, 0x4a, 0x00},   // 4f 16e2 e4bd Ã¨ÂÂ´
    {0x5a, 0x4a, 0x7b, 0x5e, 0x7b, 0x4a, 0x5a, 0x00},   // 4f 16e3 e4be Ã¨Ââ€œ
    {0x52, 0x5e, 0x57, 0x7e, 0x57, 0x5e, 0x52, 0x00},   // 4f 16e4 e4bf Ã¨ÂÂ«
    {0x42, 0x7e, 0x5b, 0x0a, 0x7b, 0x5e, 0x52, 0x00},   // 4f 16e5 e4c0 Ã¨ÂÅ½
    {0x52, 0x12, 0x7f, 0x16, 0x5b, 0x2a, 0x5a, 0x00},   // 4f 16e6 e4c1 Ã¨ÂÂ½
    {0x32, 0x2e, 0x33, 0x62, 0x33, 0x2e, 0x32, 0x00},   // 4f 16e7 e4c2 Ã¨ÂÆ’
    {0x2a, 0x7e, 0x2b, 0x66, 0x53, 0x46, 0x6a, 0x00},   // 4f 16e8 e4c3 Ã¨ÂËœ
    {0x52, 0x5a, 0x7b, 0x5e, 0x3b, 0x5e, 0x52, 0x00},   // 4f 16e9 e4c4 Ã¨Ââ€¹
    {0x0a, 0x7a, 0x2f, 0x3e, 0x2f, 0x7a, 0x0a, 0x00},   // 4f 16ea e4c5 Ã¨ÂÂ
    {0x1a, 0x6a, 0x2f, 0x7e, 0x2f, 0x6e, 0x1a, 0x00},   // 4f 16eb e4c6 Ã¨ÂÂ·
    {0x12, 0x52, 0x7f, 0x56, 0x37, 0x56, 0x52, 0x00},   // 4f 16ec e4c7 Ã¨Ââ€¡
    {0x56, 0x02, 0x43, 0x3a, 0x5b, 0x2e, 0x5a, 0x00},   // 4f 16ed e4c8 Ã¨ÂÂ 
    {0x2a, 0x6a, 0x3f, 0x02, 0x7f, 0x2a, 0x2a, 0x00},   // 4f 16ee e4c9 Ã¨ÂÂ²
    {0x56, 0x02, 0x37, 0x2e, 0x7f, 0x2e, 0x36, 0x00},   // 4f 16ef e4ca Ã¨ÂÂ
    {0x56, 0x02, 0x0b, 0x76, 0x5f, 0x46, 0x5e, 0x00},   // 4f 16f0 e4cb Ã¨ÂÂ¢
    {0x42, 0x3e, 0x57, 0x7e, 0x3f, 0x56, 0x7e, 0x00},   // 4f 16f1 e4cc Ã¨ÂÂ 
    {0x2a, 0x6a, 0x37, 0x22, 0x77, 0x2a, 0x2a, 0x00},   // 4f 16f2 e4cd Ã¨Å½Â½
    {0x5a, 0x56, 0x43, 0x3e, 0x43, 0x56, 0x5e, 0x00},   // 4f 16f3 e4ce Ã¨ÂÂ¸
    {0x56, 0x02, 0x2b, 0x5e, 0x2f, 0x5e, 0x4a, 0x00},   // 4f 16f4 e4cf Ã¨â€â€ 
    {0x2a, 0x1a, 0x7f, 0x2a, 0x1b, 0x7e, 0x2a, 0x00},   // 4f 16f5 e4d0 Ã¨ÂÂ»
    {0x7e, 0x2a, 0x2f, 0x02, 0x5b, 0x2e, 0x5e, 0x00},   // 4f 16f6 e4d1 Ã¨â€˜Â­
    {0x2a, 0x7a, 0x17, 0x22, 0x2b, 0x7e, 0x22, 0x00},   // 4f 16f7 e4d2 Ã¨ÂÂª
    {0x12, 0x16, 0x3f, 0x3a, 0x3f, 0x76, 0x12, 0x00},   // 4f 16f8 e4d3 Ã¨ÂÂ¼
    {0x12, 0x1a, 0x3f, 0x36, 0x3f, 0x7a, 0x12, 0x00},   // 4f 16f9 e4d4 Ã¨â€¢Å¡
    {0x56, 0x36, 0x77, 0x52, 0x6b, 0x7e, 0x46, 0x00},   // 4f 16fa e4d5 Ã¨â€™â€ž
    {0x26, 0x3a, 0x2b, 0x7e, 0x2b, 0x3a, 0x26, 0x00},   // 4f 16fb e4d6 Ã¨â€˜Â·
    {0x6a, 0x5e, 0x6b, 0x42, 0x3f, 0x56, 0x7e, 0x00},   // 4f 16fc e4d7 Ã¨â€˜Â«
    {0x2a, 0x56, 0x7f, 0x36, 0x13, 0x5a, 0x7e, 0x00},   // 4f 16fd e4d8 Ã¨â€™Â­
    {0x22, 0x7e, 0x17, 0x4a, 0x5f, 0x2e, 0x5a, 0x00},   // 4f 16fe e4d9 Ã¨â€˜Â®
    {0x1a, 0x6a, 0x2f, 0x7a, 0x2b, 0x6e, 0x1a, 0x00},   // 4f 16ff e4da Ã¨â€™â€š
    {0x7a, 0x56, 0x7b, 0x02, 0x7f, 0x4e, 0x6e, 0x00},   // 4f 1700 e4db Ã¨â€˜Â©
    {0x0a, 0x7e, 0x53, 0x3e, 0x7b, 0x3e, 0x52, 0x00},   // 4f 1701 e4dc Ã¨â€˜â€ 
    {0x72, 0x1e, 0x5b, 0x7e, 0x3b, 0x5e, 0x72, 0x00},   // 4f 1702 e4dd Ã¨ÂÂ¬
    {0x2a, 0x76, 0x23, 0x12, 0x2f, 0x4a, 0x7a, 0x00},   // 4f 1703 e4de Ã¨â€˜Â¯
    {0x4a, 0x3e, 0x6b, 0x12, 0x7f, 0x4a, 0x5a, 0x00},   // 4f 1704 e4df Ã¨â€˜Â¹
    {0x72, 0x1e, 0x73, 0x5e, 0x77, 0x1e, 0x72, 0x00},   // 4f 1705 e4e0 Ã¨ÂÂµ
    {0x5a, 0x3a, 0x77, 0x12, 0x57, 0x3a, 0x7a, 0x00},   // 4f 1706 e4e1 Ã¨â€œÅ 
    {0x52, 0x76, 0x6f, 0x76, 0x6f, 0x76, 0x52, 0x00},   // 4f 1707 e4e2 Ã¨â€˜Â¢
    {0x42, 0x36, 0x7f, 0x16, 0x7f, 0x2e, 0x42, 0x00},   // 4f 1708 e4e3 Ã¨â€™Â¹
    {0x72, 0x16, 0x7f, 0x56, 0x7f, 0x16, 0x72, 0x00},   // 4f 1709 e4e4 Ã¨â€™Â¿
    {0x5a, 0x6e, 0x5b, 0x0a, 0x37, 0x36, 0x7e, 0x00},   // 4f 170a e4e5 Ã¨â€™Å¸
    {0x42, 0x3e, 0x4b, 0x56, 0x7b, 0x56, 0x4a, 0x00},   // 4f 170b e4e6 Ã¨â€œâ„¢
    {0x12, 0x16, 0x6f, 0x7e, 0x77, 0x72, 0x12, 0x00},   // 4f 170c e4e7 Ã¨â€œÂ
    {0x5a, 0x2a, 0x6f, 0x02, 0x5b, 0x2a, 0x6e, 0x00},   // 4f 170d e4e8 Ã¨â€™Â»
    {0x12, 0x7a, 0x3f, 0x12, 0x4f, 0x56, 0x2a, 0x00},   // 4f 170e e4e9 Ã¨â€œÅ¡
    {0x22, 0x1e, 0x37, 0x1e, 0x5f, 0x76, 0x1a, 0x00},   // 4f 170f e4ea Ã¨â€œÂ
    {0x4a, 0x5a, 0x2f, 0x7e, 0x2f, 0x5a, 0x4a, 0x00},   // 4f 1710 e4eb Ã¨â€œÂ
    {0x42, 0x3e, 0x6b, 0x2e, 0x7b, 0x2e, 0x6a, 0x00},   // 4f 1711 e4ec Ã¨â€œâ€ 
    {0x42, 0x7e, 0x5b, 0x16, 0x7b, 0x5e, 0x52, 0x00},   // 4f 1712 e4ed Ã¨â€œâ€“
    {0x5a, 0x4a, 0x3f, 0x2a, 0x2b, 0x6e, 0x1a, 0x00},   // 4f 1713 e4ee Ã¨â€™Â¡
    {0x52, 0x2e, 0x57, 0x72, 0x17, 0x2a, 0x56, 0x00},   // 4f 1714 e4ef Ã¨â€Â¡
    {0x16, 0x7a, 0x03, 0x6a, 0x7b, 0x6a, 0x6e, 0x00},   // 4f 1715 e4f0 Ã¨â€œÂ¿
    {0x12, 0x12, 0x3f, 0x5e, 0x77, 0x1a, 0x12, 0x00},   // 4f 1716 e4f1 Ã¨â€œÂ´
    {0x42, 0x3e, 0x4b, 0x1e, 0x5b, 0x1e, 0x4a, 0x00},   // 4f 1717 e4f2 Ã¨â€â€”
    {0x2a, 0x1a, 0x4f, 0x5a, 0x2b, 0x16, 0x2a, 0x00},   // 4f 1718 e4f3 Ã¨â€Ëœ
    {0x66, 0x76, 0x4f, 0x3a, 0x6b, 0x2e, 0x6a, 0x00},   // 4f 1719 e4f4 Ã¨â€Â¬
    {0x4a, 0x3e, 0x6b, 0x12, 0x5f, 0x3a, 0x5a, 0x00},   // 4f 171a e4f5 Ã¨â€Å¸
    {0x1a, 0x76, 0x3f, 0x7a, 0x37, 0x7e, 0x1a, 0x00},   // 4f 171b e4f6 Ã¨â€â€¢
    {0x0a, 0x66, 0x7f, 0x76, 0x7f, 0x06, 0x7e, 0x00},   // 4f 171c e4f7 Ã¨â€â€
    {0x12, 0x16, 0x4f, 0x5a, 0x2f, 0x16, 0x12, 0x00},   // 4f 171d e4f8 Ã¨â€œÂ¼
    {0x5a, 0x2a, 0x7f, 0x5a, 0x2b, 0x7e, 0x5a, 0x00},   // 4f 171e e4f9 Ã¨â€¢â‚¬
    {0x5a, 0x6e, 0x5b, 0x3e, 0x2b, 0x7e, 0x3a, 0x00},   // 4f 171f e4fa Ã¨â€¢Â£
    {0x5a, 0x5e, 0x3f, 0x16, 0x7f, 0x5e, 0x5a, 0x00},   // 4f 1720 e4fb Ã¨â€¢Ëœ
    {0x22, 0x2e, 0x3b, 0x6e, 0x3b, 0x2e, 0x22, 0x00},   // 4f 1721 e4fc Ã¨â€¢Ë† 
    {0x2a, 0x3a, 0x6b, 0x26, 0x7f, 0x6e, 0x3a, 0x00},   // 50 1722 e540 Ã¨â€¢Â
    {0x5a, 0x4e, 0x37, 0x7a, 0x2b, 0x56, 0x5a, 0x00},   // 50 1723 e541 Ã¨Ëœâ€š
    {0x6a, 0x4e, 0x7b, 0x6e, 0x4f, 0x7e, 0x5a, 0x00},   // 50 1724 e542 Ã¨â€¢â€¹
    {0x56, 0x4a, 0x37, 0x7a, 0x57, 0x76, 0x7a, 0x00},   // 50 1725 e543 Ã¨â€¢â€¢
    {0x56, 0x02, 0x5f, 0x7a, 0x77, 0x7a, 0x5e, 0x00},   // 50 1726 e544 Ã¨â€“â‚¬
    {0x56, 0x2e, 0x57, 0x7e, 0x43, 0x7e, 0x56, 0x00},   // 50 1727 e545 Ã¨â€“Â¤
    {0x0a, 0x7e, 0x57, 0x5e, 0x57, 0x7e, 0x0a, 0x00},   // 50 1728 e546 Ã¨â€“Ë†
    {0x42, 0x56, 0x7f, 0x7e, 0x7f, 0x56, 0x42, 0x00},   // 50 1729 e547 Ã¨â€“â€˜
    {0x4a, 0x16, 0x5f, 0x02, 0x1b, 0x42, 0x7e, 0x00},   // 50 172a e548 Ã¨â€“Å 
    {0x5a, 0x6e, 0x3b, 0x1e, 0x7b, 0x5e, 0x5a, 0x00},   // 50 172b e549 Ã¨â€“Â¨
    {0x4a, 0x3a, 0x6f, 0x06, 0x6f, 0x2e, 0x7a, 0x00},   // 50 172c e54a Ã¨â€¢Â­
    {0x1a, 0x76, 0x7b, 0x5e, 0x7b, 0x76, 0x1a, 0x00},   // 50 172d e54b Ã¨â€“â€
    {0x7e, 0x6e, 0x6f, 0x3a, 0x6f, 0x3a, 0x2a, 0x00},   // 50 172e e54c Ã¨â€“â€º
    {0x56, 0x7e, 0x5f, 0x3e, 0x5b, 0x26, 0x5e, 0x00},   // 50 172f e54d Ã¨â€”Âª
    {0x2a, 0x76, 0x53, 0x36, 0x57, 0x3e, 0x5e, 0x00},   // 50 1730 e54e Ã¨â€“â€¡
    {0x12, 0x7e, 0x6f, 0x2a, 0x3b, 0x6e, 0x3a, 0x00},   // 50 1731 e54f Ã¨â€“Å“
    {0x12, 0x56, 0x7f, 0x32, 0x47, 0x1e, 0x5e, 0x00},   // 50 1732 e550 Ã¨â€¢Â·
    {0x0a, 0x76, 0x5f, 0x7e, 0x57, 0x7e, 0x0a, 0x00},   // 50 1733 e551 Ã¨â€¢Â¾
    {0x2a, 0x7a, 0x17, 0x2a, 0x5f, 0x2e, 0x5a, 0x00},   // 50 1734 e552 Ã¨â€“Â
    {0x2a, 0x7e, 0x2b, 0x16, 0x7f, 0x7e, 0x16, 0x00},   // 50 1735 e553 Ã¨â€”â€°
    {0x4a, 0x36, 0x2f, 0x2a, 0x2f, 0x76, 0x0a, 0x00},   // 50 1736 e554 Ã¨â€“Âº
    {0x5a, 0x72, 0x3b, 0x7a, 0x5b, 0x3e, 0x4a, 0x00},   // 50 1737 e555 Ã¨â€”Â
    {0x5a, 0x6a, 0x7f, 0x6e, 0x5f, 0x6a, 0x5a, 0x00},   // 50 1738 e556 Ã¨â€“Â¹
    {0x2a, 0x5a, 0x77, 0x42, 0x3b, 0x6e, 0x5a, 0x00},   // 50 1739 e557 Ã¨â€”Â
    {0x2a, 0x7e, 0x2b, 0x72, 0x5f, 0x3e, 0x72, 0x00},   // 50 173a e558 Ã¨â€”â€¢
    {0x52, 0x5a, 0x7f, 0x5a, 0x57, 0x3e, 0x5a, 0x00},   // 50 173b e559 Ã¨â€”Â
    {0x5a, 0x56, 0x3f, 0x76, 0x3f, 0x5a, 0x56, 0x00},   // 50 173c e55a Ã¨â€”Â¥
    {0x2a, 0x66, 0x3f, 0x6a, 0x37, 0x6a, 0x2e, 0x00},   // 50 173d e55b Ã¨â€”Å“
    {0x6a, 0x6e, 0x23, 0x7e, 0x57, 0x1e, 0x72, 0x00},   // 50 173e e55c Ã¨â€”Â¹
    {0x2a, 0x76, 0x23, 0x5e, 0x7b, 0x76, 0x5e, 0x00},   // 50 173f e55d Ã¨ËœÅ 
    {0x2a, 0x7a, 0x47, 0x3a, 0x77, 0x3e, 0x42, 0x00},   // 50 1740 e55e Ã¨Ëœâ€œ
    {0x1a, 0x52, 0x5f, 0x2a, 0x47, 0x1e, 0x5e, 0x00},   // 50 1741 e55f Ã¨Ëœâ€¹
    {0x42, 0x2e, 0x7f, 0x2e, 0x47, 0x1a, 0x5e, 0x00},   // 50 1742 e560 Ã¨â€”Â¾
    {0x7e, 0x26, 0x7b, 0x52, 0x7b, 0x56, 0x7e, 0x00},   // 50 1743 e561 Ã¨â€”Âº
    {0x42, 0x3a, 0x4b, 0x6a, 0x7f, 0x76, 0x52, 0x00},   // 50 1744 e562 Ã¨Ëœâ€ 
    {0x16, 0x7e, 0x37, 0x7e, 0x17, 0x6e, 0x5a, 0x00},   // 50 1745 e563 Ã¨ËœÂ¢
    {0x4a, 0x36, 0x7f, 0x2a, 0x2f, 0x7a, 0x2e, 0x00},   // 50 1746 e564 Ã¨ËœÅ¡
    {0x2a, 0x76, 0x23, 0x5a, 0x5f, 0x2e, 0x5a, 0x00},   // 50 1747 e565 Ã¨ËœÂ°
    {0x2e, 0x76, 0x27, 0x7e, 0x57, 0x7e, 0x56, 0x00},   // 50 1748 e566 Ã¨ËœÂ¿
    {0x40, 0x3c, 0x14, 0x7f, 0x56, 0x56, 0x6c, 0x00},   // 50 1749 e567 Ã¨â„¢Â
    {0x40, 0x3e, 0x6e, 0x2e, 0x7e, 0x2d, 0x6d, 0x00},   // 50 174a e568 Ã¤Â¹â€¢
    {0x40, 0x3c, 0x44, 0x5c, 0x2f, 0x5a, 0x4a, 0x00},   // 50 174b e569 Ã¨â„¢â€
    {0x5b, 0x6b, 0x3c, 0x44, 0x2f, 0x6a, 0x4a, 0x00},   // 50 174c e56a Ã¨â„¢Å¸
    {0x7c, 0x74, 0x7f, 0x5a, 0x05, 0x5f, 0x75, 0x00},   // 50 174d e56b Ã¨â„¢Â§
    {0x5d, 0x55, 0x7f, 0x55, 0x5d, 0x3f, 0x40, 0x00},   // 50 174e e56c Ã¨â„¢Â±
    {0x4e, 0x7b, 0x2e, 0x5d, 0x77, 0x00, 0x7f, 0x00},   // 50 174f e56d Ã¨Å¡â€œ
    {0x4e, 0x7b, 0x4e, 0x63, 0x58, 0x23, 0x44, 0x00},   // 50 1750 e56e Ã¨Å¡Â£
    {0x44, 0x5f, 0x56, 0x7f, 0x56, 0x3f, 0x44, 0x00},   // 50 1751 e56f Ã¨Å¡Â©
    {0x4e, 0x7b, 0x2e, 0x2a, 0x20, 0x7f, 0x10, 0x00},   // 50 1752 e570 Ã¨Å¡Âª
    {0x4e, 0x7b, 0x7e, 0x15, 0x0f, 0x54, 0x7c, 0x00},   // 50 1753 e571 Ã¨Å¡â€¹
    {0x4e, 0x7b, 0x4e, 0x22, 0x2a, 0x7f, 0x2a, 0x00},   // 50 1754 e572 Ã¨Å¡Å’
    {0x4e, 0x7b, 0x2e, 0x02, 0x7f, 0x4a, 0x7f, 0x00},   // 50 1755 e573 Ã¨Å¡Â¶
    {0x4e, 0x7b, 0x4e, 0x7e, 0x4a, 0x79, 0x48, 0x00},   // 50 1756 e574 Ã¨Å¡Â¯
    {0x4e, 0x7b, 0x2e, 0x04, 0x74, 0x5f, 0x74, 0x00},   // 50 1757 e575 Ã¨â€ºâ€ž
    {0x4e, 0x7b, 0x4e, 0x7f, 0x55, 0x7f, 0x40, 0x00},   // 50 1758 e576 Ã¨â€ºâ€ 
    {0x4e, 0x7b, 0x2e, 0x7e, 0x4a, 0x7f, 0x7e, 0x00},   // 50 1759 e577 Ã¨Å¡Â°
    {0x4e, 0x7b, 0x2e, 0x12, 0x75, 0x16, 0x34, 0x00},   // 50 175a e578 Ã¨â€ºâ€°
    {0x4e, 0x7b, 0x4e, 0x3f, 0x6d, 0x3f, 0x6d, 0x00},   // 50 175b e579 Ã¨Â Â£
    {0x4e, 0x7b, 0x2e, 0x04, 0x7b, 0x5a, 0x5e, 0x00},   // 50 175c e57a Ã¨Å¡Â«
    {0x4e, 0x7b, 0x2e, 0x7f, 0x5d, 0x55, 0x7f, 0x00},   // 50 175d e57b Ã¨â€ºâ€
    {0x4e, 0x7b, 0x2e, 0x04, 0x76, 0x5e, 0x75, 0x00},   // 50 175e e57c Ã¨â€ºÅ¾
    {0x45, 0x47, 0x5d, 0x7c, 0x5b, 0x27, 0x44, 0x00},   // 50 175f e57d Ã¨â€ºÂ©
    {0x54, 0x4e, 0x5f, 0x7e, 0x5f, 0x2e, 0x54, 0x00},   // 50 1760 e57e Ã¨â€ºÂ¬
    {0x4e, 0x7b, 0x4e, 0x56, 0x23, 0x56, 0x4a, 0x00},   // 51 1761 e580 Ã¨â€ºÅ¸
    {0x4e, 0x7b, 0x4c, 0x2b, 0x7f, 0x2a, 0x48, 0x00},   // 51 1762 e581 Ã¨â€ºâ€º
    {0x4e, 0x7b, 0x2e, 0x1a, 0x6f, 0x4a, 0x49, 0x00},   // 51 1763 e582 Ã¨â€ºÂ¯
    {0x4e, 0x7f, 0x55, 0x3b, 0x52, 0x5e, 0x55, 0x00},   // 51 1764 e583 Ã¨Å“â€™
    {0x4e, 0x7b, 0x2e, 0x5f, 0x35, 0x75, 0x5f, 0x00},   // 51 1765 e584 Ã¨Å“â€ 
    {0x4e, 0x7b, 0x2e, 0x56, 0x34, 0x5f, 0x53, 0x00},   // 51 1766 e585 Ã¨Å“Ë†
    {0x4b, 0x45, 0x5f, 0x7d, 0x5f, 0x25, 0x7f, 0x00},   // 51 1767 e586 Ã¨Å“â‚¬
    {0x48, 0x47, 0x7f, 0x7b, 0x77, 0x2b, 0x49, 0x00},   // 51 1768 e587 Ã¨Å“Æ’
    {0x4e, 0x7b, 0x2e, 0x5d, 0x34, 0x75, 0x5e, 0x00},   // 51 1769 e588 Ã¨â€ºÂ»
    {0x55, 0x5b, 0x70, 0x7a, 0x72, 0x3e, 0x55, 0x00},   // 51 176a e589 Ã¨Å“â€˜
    {0x4e, 0x7b, 0x2e, 0x21, 0x6b, 0x39, 0x22, 0x00},   // 51 176b e58a Ã¨Å“â€°
    {0x4e, 0x7b, 0x56, 0x16, 0x7d, 0x16, 0x54, 0x00},   // 51 176c e58b Ã¨Å“Â
    {0x4e, 0x7b, 0x2e, 0x7d, 0x15, 0x7f, 0x7d, 0x00},   // 51 176d e58c Ã¨â€ºÂ¹
    {0x4e, 0x7b, 0x35, 0x7f, 0x15, 0x4e, 0x7f, 0x00},   // 51 176e e58d Ã¨Å“Å 
    {0x4e, 0x7b, 0x4e, 0x27, 0x5d, 0x35, 0x77, 0x00},   // 51 176f e58e Ã¨Å“Â´
    {0x4e, 0x7b, 0x56, 0x2a, 0x7b, 0x4a, 0x5e, 0x00},   // 51 1770 e58f Ã¨Å“Â¿
    {0x4e, 0x7b, 0x16, 0x6d, 0x56, 0x4d, 0x16, 0x00},   // 51 1771 e590 Ã¨Å“Â·
    {0x4e, 0x7b, 0x2e, 0x08, 0x7a, 0x3f, 0x7a, 0x00},   // 51 1772 e591 Ã¨Å“Â»
    {0x4e, 0x7f, 0x1a, 0x7f, 0x3e, 0x0a, 0x79, 0x00},   // 51 1773 e592 Ã¨Å“Â¥
    {0x4e, 0x7b, 0x7f, 0x35, 0x2f, 0x35, 0x7f, 0x00},   // 51 1774 e593 Ã¨Å“Â©
    {0x4a, 0x5a, 0x7f, 0x70, 0x7f, 0x2a, 0x4a, 0x00},   // 51 1775 e594 Ã¨Å“Å¡
    {0x4e, 0x7b, 0x2e, 0x71, 0x57, 0x77, 0x71, 0x00},   // 51 1776 e595 Ã¨ÂÂ 
    {0x4e, 0x7b, 0x0f, 0x7d, 0x2f, 0x7d, 0x0f, 0x00},   // 51 1777 e596 Ã¨ÂÅ¸
    {0x4e, 0x7b, 0x2e, 0x78, 0x0f, 0x69, 0x7f, 0x00},   // 51 1778 e597 Ã¨ÂÂ¸
    {0x4e, 0x7b, 0x35, 0x7f, 0x25, 0x2a, 0x7f, 0x00},   // 51 1779 e598 Ã¨ÂÅ’
    {0x4e, 0x7b, 0x2e, 0x3f, 0x2d, 0x4f, 0x78, 0x00},   // 51 177a e599 Ã¨ÂÅ½
    {0x4e, 0x7f, 0x3a, 0x2f, 0x7a, 0x3f, 0x7f, 0x00},   // 51 177b e59a Ã¨ÂÂ´
    {0x4e, 0x7b, 0x2e, 0x50, 0x5e, 0x7b, 0x5e, 0x00},   // 51 177c e59b Ã¨Ââ€”
    {0x44, 0x75, 0x3d, 0x47, 0x75, 0x37, 0x48, 0x00},   // 51 177d e59c Ã¨ÂÂ¨
    {0x4e, 0x7b, 0x4e, 0x53, 0x2e, 0x5e, 0x42, 0x00},   // 51 177e e59d Ã¨ÂÂ®
    {0x4e, 0x7b, 0x2f, 0x1f, 0x75, 0x37, 0x71, 0x00},   // 51 177f e59e Ã¨Ââ„¢
    {0x4e, 0x7f, 0x05, 0x73, 0x75, 0x26, 0x54, 0x00},   // 51 1780 e59f Ã¨Ââ€œ
    {0x4e, 0x7f, 0x62, 0x1f, 0x7a, 0x77, 0x2e, 0x00},   // 51 1781 e5a0 Ã¨ÂÂ£
    {0x4e, 0x7b, 0x26, 0x5f, 0x35, 0x57, 0x74, 0x00},   // 51 1782 e5a1 Ã¨ÂÂª
    {0x4e, 0x7f, 0x1b, 0x7f, 0x41, 0x7f, 0x5b, 0x00},   // 51 1783 e5a2 Ã¨Â â€¦
    {0x4d, 0x46, 0x5d, 0x7c, 0x5d, 0x26, 0x4d, 0x00},   // 51 1784 e5a3 Ã¨Å¾Â¢
    {0x4e, 0x7b, 0x2e, 0x53, 0x1d, 0x1d, 0x53, 0x00},   // 51 1785 e5a4 Ã¨Å¾Å¸
    {0x4e, 0x7b, 0x3e, 0x2b, 0x0e, 0x7f, 0x1b, 0x00},   // 51 1786 e5a5 Ã¨Å¾â€š
    {0x54, 0x4e, 0x7f, 0x74, 0x7a, 0x25, 0x4b, 0x00},   // 51 1787 e5a6 Ã¨Å¾Â¯
    {0x4e, 0x7f, 0x55, 0x2f, 0x5d, 0x4f, 0x55, 0x00},   // 51 1788 e5a7 Ã¨Å¸â€¹
    {0x48, 0x7a, 0x36, 0x4d, 0x77, 0x38, 0x48, 0x00},   // 51 1789 e5a8 Ã¨Å¾Â½
    {0x4e, 0x7f, 0x36, 0x2a, 0x77, 0x2a, 0x36, 0x00},   // 51 178a e5a9 Ã¨Å¸â‚¬
    {0x4e, 0x7b, 0x35, 0x1e, 0x7b, 0x1e, 0x35, 0x00},   // 51 178b e5aa Ã¨Å¸Â
    {0x5b, 0x7d, 0x5b, 0x7e, 0x4b, 0x7e, 0x4b, 0x00},   // 51 178c e5ab Ã©â€ºâ€“
    {0x4a, 0x47, 0x7f, 0x76, 0x7a, 0x25, 0x4b, 0x00},   // 51 178d e5ac Ã¨Å¾Â«
    {0x44, 0x4e, 0x7f, 0x7a, 0x77, 0x2e, 0x48, 0x00},   // 51 178e e5ad Ã¨Å¸â€ž
    {0x4e, 0x7b, 0x55, 0x5e, 0x7b, 0x5e, 0x55, 0x00},   // 51 178f e5ae Ã¨Å¾Â³
    {0x2a, 0x5a, 0x5f, 0x7e, 0x5f, 0x3a, 0x52, 0x00},   // 51 1790 e5af Ã¨Å¸â€¡
    {0x4e, 0x7f, 0x52, 0x5f, 0x36, 0x5f, 0x52, 0x00},   // 51 1791 e5b0 Ã¨Å¸â€ 
    {0x4e, 0x7b, 0x54, 0x7e, 0x5b, 0x3e, 0x54, 0x00},   // 51 1792 e5b1 Ã¨Å¾Â»
    {0x4e, 0x7b, 0x5c, 0x3e, 0x17, 0x7e, 0x5c, 0x00},   // 51 1793 e5b2 Ã¨Å¸Â¯
    {0x48, 0x7e, 0x3e, 0x4f, 0x7e, 0x36, 0x48, 0x00},   // 51 1794 e5b3 Ã¨Å¸Â²
    {0x4e, 0x7f, 0x15, 0x6f, 0x7d, 0x6f, 0x15, 0x00},   // 51 1795 e5b4 Ã¨Å¸Â 
    {0x4e, 0x7f, 0x42, 0x3d, 0x7f, 0x31, 0x7b, 0x00},   // 51 1796 e5b5 Ã¨Â Â
    {0x4e, 0x7f, 0x37, 0x2d, 0x5f, 0x3b, 0x46, 0x00},   // 51 1797 e5b6 Ã¨Â Â
    {0x4e, 0x7b, 0x3c, 0x2e, 0x75, 0x7f, 0x2c, 0x00},   // 51 1798 e5b7 Ã¨Å¸Â¾
    {0x4e, 0x7b, 0x45, 0x57, 0x7f, 0x55, 0x47, 0x00},   // 51 1799 e5b8 Ã¨Å¸Â¶
    {0x4e, 0x7b, 0x75, 0x5e, 0x7b, 0x5e, 0x75, 0x00},   // 51 179a e5b9 Ã¨Å¸Â·
    {0x4e, 0x7f, 0x2a, 0x67, 0x3a, 0x77, 0x2a, 0x00},   // 51 179b e5ba Ã¨Â Å½
    {0x4e, 0x7f, 0x2a, 0x77, 0x22, 0x77, 0x2a, 0x00},   // 51 179c e5bb Ã¨Å¸â€™
    {0x4e, 0x7b, 0x4d, 0x36, 0x7d, 0x36, 0x4d, 0x00},   // 51 179d e5bc Ã¨Â â€˜
    {0x4e, 0x7f, 0x42, 0x5f, 0x2e, 0x5f, 0x4a, 0x00},   // 51 179e e5bd Ã¨Â â€“
    {0x4e, 0x7f, 0x66, 0x2b, 0x7f, 0x2b, 0x66, 0x00},   // 51 179f e5be Ã¨Â â€¢
    {0x4a, 0x76, 0x33, 0x4f, 0x7f, 0x36, 0x4a, 0x00},   // 51 17a0 e5bf Ã¨Â Â¢
    {0x4a, 0x7a, 0x36, 0x4b, 0x7f, 0x37, 0x4a, 0x00},   // 51 17a1 e5c0 Ã¨Â Â¡
    {0x50, 0x7e, 0x6e, 0x77, 0x7e, 0x6e, 0x54, 0x00},   // 51 17a2 e5c1 Ã¨Â Â±
    {0x45, 0x73, 0x3f, 0x4d, 0x7b, 0x37, 0x45, 0x00},   // 51 17a3 e5c2 Ã¨Â Â¶
    {0x4a, 0x76, 0x3a, 0x5f, 0x7a, 0x36, 0x4a, 0x00},   // 51 17a4 e5c3 Ã¨Â Â¹
    {0x4a, 0x76, 0x3e, 0x4f, 0x7e, 0x36, 0x4a, 0x00},   // 51 17a5 e5c4 Ã¨Â Â§
    {0x4a, 0x5d, 0x7a, 0x77, 0x77, 0x2a, 0x5d, 0x00},   // 51 17a6 e5c5 Ã¨Â Â»
    {0x40, 0x7e, 0x3f, 0x49, 0x7f, 0x49, 0x7f, 0x00},   // 51 17a7 e5c6 Ã¨Â¡â€ž
    {0x40, 0x7e, 0x3f, 0x45, 0x3f, 0x51, 0x7f, 0x00},   // 51 17a8 e5c7 Ã¨Â¡â€š
    {0x0a, 0x7d, 0x2a, 0x37, 0x2a, 0x45, 0x7d, 0x00},   // 51 17a9 e5c8 Ã¨Â¡â€™
    {0x0a, 0x7d, 0x00, 0x6d, 0x6f, 0x05, 0x7d, 0x00},   // 51 17aa e5c9 Ã¨Â¡â„¢
    {0x0a, 0x7d, 0x3a, 0x77, 0x3e, 0x45, 0x7d, 0x00},   // 51 17ab e5ca Ã¨Â¡Å¾
    {0x0a, 0x7d, 0x23, 0x7b, 0x70, 0x5b, 0x7d, 0x00},   // 51 17ac e5cb Ã¨Â¡Â¢
    {0x12, 0x7b, 0x36, 0x00, 0x4a, 0x4a, 0x25, 0x00},   // 51 17ad e5cc Ã¨Â¡Â«
    {0x44, 0x3e, 0x76, 0x57, 0x36, 0x5e, 0x44, 0x00},   // 51 17ae e5cd Ã¨Â¢Â
    {0x54, 0x34, 0x76, 0x55, 0x3e, 0x54, 0x54, 0x00},   // 51 17af e5ce Ã¨Â¡Â¾
    {0x2a, 0x26, 0x7a, 0x5b, 0x3a, 0x46, 0x4a, 0x00},   // 51 17b0 e5cf Ã¨Â¢Å¾
    {0x12, 0x7b, 0x36, 0x7f, 0x49, 0x49, 0x7f, 0x00},   // 51 17b1 e5d0 Ã¨Â¡Âµ
    {0x12, 0x7b, 0x36, 0x08, 0x4a, 0x7e, 0x49, 0x00},   // 51 17b2 e5d1 Ã¨Â¡Â½
    {0x12, 0x7b, 0x7e, 0x01, 0x4a, 0x7e, 0x49, 0x00},   // 51 17b3 e5d2 Ã¨Â¢Âµ
    {0x12, 0x7b, 0x36, 0x7c, 0x15, 0x4f, 0x7c, 0x00},   // 51 17b4 e5d3 Ã¨Â¡Â²
    {0x12, 0x7b, 0x36, 0x48, 0x4a, 0x3f, 0x4e, 0x00},   // 51 17b5 e5d4 Ã¨Â¢â€š
    {0x12, 0x7b, 0x36, 0x42, 0x55, 0x2a, 0x14, 0x00},   // 51 17b6 e5d5 Ã¨Â¢â€”
    {0x12, 0x7b, 0x36, 0x40, 0x5f, 0x55, 0x5f, 0x00},   // 51 17b7 e5d6 Ã¨Â¢â€™
    {0x12, 0x7b, 0x36, 0x24, 0x5b, 0x7e, 0x32, 0x00},   // 51 17b8 e5d7 Ã¨Â¢Â®
    {0x12, 0x7b, 0x36, 0x7e, 0x4b, 0x4a, 0x7e, 0x00},   // 51 17b9 e5d8 Ã¨Â¢â„¢
    {0x12, 0x7b, 0x36, 0x29, 0x7c, 0x29, 0x2a, 0x00},   // 51 17ba e5d9 Ã¨Â¢Â¢
    {0x12, 0x7b, 0x36, 0x04, 0x7b, 0x5a, 0x5e, 0x00},   // 51 17bb e5da Ã¨Â¢Â
    {0x52, 0x36, 0x6e, 0x5f, 0x2e, 0x4a, 0x5a, 0x00},   // 51 17bc e5db Ã¨Â¢Â¤
    {0x54, 0x3c, 0x77, 0x5f, 0x35, 0x5f, 0x54, 0x00},   // 51 17bd e5dc Ã¨Â¢Â°
    {0x12, 0x7b, 0x36, 0x48, 0x5a, 0x7f, 0x5a, 0x00},   // 51 17be e5dd Ã¨Â¢Â¿
    {0x12, 0x7b, 0x7e, 0x01, 0x44, 0x3f, 0x45, 0x00},   // 51 17bf e5de Ã¨Â¢Â±
    {0x12, 0x7b, 0x36, 0x08, 0x7f, 0x1a, 0x2a, 0x00},   // 51 17c0 e5df Ã¨Â£Æ’
    {0x12, 0x7b, 0x36, 0x7d, 0x00, 0x45, 0x7d, 0x00},   // 51 17c1 e5e0 Ã¨Â£â€ž
    {0x7a, 0x36, 0x1e, 0x7b, 0x76, 0x1a, 0x7a, 0x00},   // 51 17c2 e5e1 Ã¨Â£â€
    {0x5a, 0x36, 0x7a, 0x5f, 0x36, 0x5b, 0x52, 0x00},   // 51 17c3 e5e2 Ã¨Â£Ëœ
    {0x12, 0x7b, 0x36, 0x55, 0x3f, 0x75, 0x6f, 0x00},   // 51 17c4 e5e3 Ã¨Â£â„¢
    {0x5b, 0x36, 0x7f, 0x52, 0x3a, 0x5f, 0x5a, 0x00},   // 51 17c5 e5e4 Ã¨Â£Â
    {0x52, 0x2a, 0x7e, 0x5f, 0x2e, 0x4a, 0x52, 0x00},   // 51 17c6 e5e5 Ã¨Â£Â¹
    {0x12, 0x7b, 0x36, 0x3f, 0x2a, 0x7f, 0x08, 0x00},   // 51 17c7 e5e6 Ã¨Â¤â€š
    {0x12, 0x7b, 0x36, 0x27, 0x5d, 0x35, 0x77, 0x00},   // 51 17c8 e5e7 Ã¨Â£Â¼
    {0x56, 0x36, 0x7f, 0x50, 0x3f, 0x56, 0x56, 0x00},   // 51 17c9 e5e8 Ã¨Â£Â´
    {0x12, 0x7b, 0x36, 0x2e, 0x3f, 0x7a, 0x2e, 0x00},   // 51 17ca e5e9 Ã¨Â£Â¨
    {0x12, 0x7b, 0x36, 0x7d, 0x35, 0x7f, 0x7d, 0x00},   // 51 17cb e5ea Ã¨Â£Â²
    {0x12, 0x7b, 0x36, 0x5a, 0x7f, 0x3e, 0x52, 0x00},   // 51 17cc e5eb Ã¨Â¤â€ž
    {0x12, 0x7b, 0x36, 0x27, 0x3d, 0x7f, 0x27, 0x00},   // 51 17cd e5ec Ã¨Â¤Å’
    {0x12, 0x7b, 0x36, 0x21, 0x7f, 0x35, 0x77, 0x00},   // 51 17ce e5ed Ã¨Â¤Å 
    {0x12, 0x7b, 0x7e, 0x37, 0x7d, 0x37, 0x50, 0x00},   // 51 17cf e5ee Ã¨Â¤â€œ
    {0x2a, 0x36, 0x72, 0x4f, 0x1a, 0x2e, 0x52, 0x00},   // 51 17d0 e5ef Ã¨Â¥Æ’
    {0x12, 0x7b, 0x36, 0x4f, 0x6d, 0x6b, 0x4f, 0x00},   // 51 17d1 e5f0 Ã¨Â¤Å¾
    {0x12, 0x7b, 0x3e, 0x37, 0x5f, 0x7b, 0x15, 0x00},   // 51 17d2 e5f1 Ã¨Â¤Â¥
    {0x12, 0x7b, 0x36, 0x65, 0x50, 0x4f, 0x57, 0x00},   // 51 17d3 e5f2 Ã¨Â¤Âª
    {0x12, 0x7b, 0x3f, 0x5d, 0x25, 0x6f, 0x4b, 0x00},   // 51 17d4 e5f3 Ã¨Â¤Â«
    {0x12, 0x7b, 0x36, 0x5d, 0x77, 0x7e, 0x5d, 0x00},   // 51 17d5 e5f4 Ã¨Â¥Â
    {0x52, 0x36, 0x7e, 0x5b, 0x3e, 0x56, 0x52, 0x00},   // 51 17d6 e5f5 Ã¨Â¥â€ž
    {0x56, 0x3e, 0x7e, 0x57, 0x2e, 0x5e, 0x52, 0x00},   // 51 17d7 e5f6 Ã¨Â¤Â»
    {0x12, 0x7b, 0x36, 0x05, 0x6f, 0x75, 0x6f, 0x00},   // 51 17d8 e5f7 Ã¨Â¤Â¶
    {0x12, 0x7b, 0x56, 0x7e, 0x5b, 0x3e, 0x54, 0x00},   // 51 17d9 e5f8 Ã¨Â¤Â¸
    {0x12, 0x7b, 0x36, 0x23, 0x3f, 0x7c, 0x23, 0x00},   // 51 17da e5f9 Ã¨Â¥Å’
    {0x12, 0x7b, 0x36, 0x2d, 0x2d, 0x7e, 0x2d, 0x00},   // 51 17db e5fa Ã¨Â¤Â
    {0x12, 0x7b, 0x77, 0x5e, 0x7b, 0x5e, 0x75, 0x00},   // 51 17dc e5fb Ã¨Â¥Â 
    {0x54, 0x3f, 0x7b, 0x50, 0x36, 0x5b, 0x56, 0x00},   // 51 17dd e5fc Ã¨Â¥Å¾
    {0x12, 0x7b, 0x76, 0x2b, 0x7f, 0x2b, 0x66, 0x00},   // 52 17de e640 Ã¨Â¥Â¦
    {0x12, 0x7b, 0x36, 0x4f, 0x60, 0x6b, 0x4a, 0x00},   // 52 17df e641 Ã¨Â¥Â¤
    {0x12, 0x7b, 0x36, 0x6f, 0x6a, 0x1f, 0x5d, 0x00},   // 52 17e0 e642 Ã¨Â¥Â­
    {0x12, 0x7b, 0x36, 0x7a, 0x4f, 0x3e, 0x5b, 0x00},   // 52 17e1 e643 Ã¨Â¥Âª
    {0x12, 0x7b, 0x36, 0x7b, 0x56, 0x3f, 0x5f, 0x00},   // 52 17e2 e644 Ã¨Â¥Â¯
    {0x12, 0x7b, 0x7f, 0x2b, 0x7c, 0x2b, 0x7f, 0x00},   // 52 17e3 e645 Ã¨Â¥Â´
    {0x12, 0x7b, 0x2e, 0x79, 0x7e, 0x3d, 0x2f, 0x00},   // 52 17e4 e646 Ã¨Â¥Â·
    {0x7a, 0x0a, 0x3e, 0x2a, 0x3e, 0x0a, 0x7a, 0x00},   // 52 17e5 e647 Ã¨Â¥Â¾
    {0x21, 0x27, 0x3b, 0x6f, 0x3b, 0x27, 0x21, 0x00},   // 52 17e6 e648 Ã¨Â¦Æ’
    {0x59, 0x3f, 0x7b, 0x17, 0x5b, 0x2f, 0x59, 0x00},   // 52 17e7 e649 Ã¨Â¦Ë†
    {0x29, 0x77, 0x2b, 0x47, 0x1b, 0x5f, 0x69, 0x00},   // 52 17e8 e64a Ã¨Â¦Å 
    {0x44, 0x43, 0x3d, 0x17, 0x75, 0x5d, 0x62, 0x00},   // 52 17e9 e64b Ã¨Â¦â€œ
    {0x70, 0x5f, 0x74, 0x5f, 0x35, 0x75, 0x5f, 0x00},   // 52 17ea e64c Ã¨Â¦Ëœ
    {0x51, 0x4d, 0x3f, 0x2d, 0x5f, 0x35, 0x5f, 0x00},   // 52 17eb e64d Ã¨Â¦Â¡
    {0x28, 0x1a, 0x6f, 0x6a, 0x5f, 0x35, 0x5f, 0x00},   // 52 17ec e64e Ã¨Â¦Â©
    {0x75, 0x73, 0x25, 0x56, 0x3f, 0x75, 0x5f, 0x00},   // 52 17ed e64f Ã¨Â¦Â¦
    {0x4b, 0x5a, 0x6b, 0x5a, 0x3f, 0x75, 0x5f, 0x00},   // 52 17ee e650 Ã¨Â¦Â¬
    {0x2a, 0x7f, 0x3a, 0x7f, 0x5f, 0x35, 0x5f, 0x00},   // 52 17ef e651 Ã¨Â¦Â¯
    {0x5a, 0x5f, 0x7a, 0x5f, 0x5f, 0x35, 0x5f, 0x00},   // 52 17f0 e652 Ã¨Â¦Â²
    {0x4c, 0x46, 0x3d, 0x2e, 0x7d, 0x47, 0x6c, 0x00},   // 52 17f1 e653 Ã¨Â¦Âº
    {0x47, 0x47, 0x3d, 0x38, 0x7f, 0x46, 0x66, 0x00},   // 52 17f2 e654 Ã¨Â¦Â½
    {0x4e, 0x3e, 0x3b, 0x4e, 0x3f, 0x75, 0x5f, 0x00},   // 52 17f3 e655 Ã¨Â¦Â¿
    {0x26, 0x7f, 0x7a, 0x57, 0x3f, 0x75, 0x5f, 0x00},   // 52 17f4 e656 Ã¨Â§â‚¬
    {0x42, 0x3d, 0x7f, 0x3e, 0x42, 0x3e, 0x61, 0x00},   // 52 17f5 e657 Ã¨Â§Å¡
    {0x4e, 0x38, 0x2f, 0x3a, 0x28, 0x7f, 0x0a, 0x00},   // 52 17f6 e658 Ã¨Â§Å“
    {0x42, 0x3d, 0x7f, 0x7e, 0x4a, 0x5e, 0x69, 0x00},   // 52 17f7 e659 Ã¨Â§Â
    {0x42, 0x3d, 0x7f, 0x22, 0x2b, 0x7e, 0x2b, 0x00},   // 52 17f8 e65a Ã¨Â§Â§
    {0x42, 0x3d, 0x7f, 0x24, 0x5f, 0x3e, 0x72, 0x00},   // 52 17f9 e65b Ã¨Â§Â´
    {0x42, 0x3d, 0x7f, 0x4b, 0x75, 0x37, 0x7f, 0x00},   // 52 17fa e65c Ã¨Â§Â¸
    {0x6a, 0x6b, 0x6a, 0x00, 0x7f, 0x08, 0x10, 0x00},   // 52 17fb e65d Ã¨Â¨Æ’
    {0x6a, 0x6b, 0x04, 0x23, 0x56, 0x4e, 0x62, 0x00},   // 52 17fc e65e Ã¨Â¨â€“
    {0x6a, 0x63, 0x08, 0x09, 0x7f, 0x09, 0x08, 0x00},   // 52 17fd e65f Ã¨Â¨Â
    {0x6a, 0x6b, 0x40, 0x42, 0x7e, 0x42, 0x40, 0x00},   // 52 17fe e660 Ã¨Â¨Å’
    {0x6a, 0x6b, 0x04, 0x7e, 0x01, 0x7f, 0x44, 0x00},   // 52 17ff e661 Ã¨Â¨â€º
    {0x6a, 0x63, 0x28, 0x2f, 0x59, 0x7f, 0x09, 0x00},   // 52 1800 e662 Ã¨Â¨Â
    {0x6a, 0x6b, 0x7c, 0x15, 0x0f, 0x54, 0x7c, 0x00},   // 52 1801 e663 Ã¨Â¨Â¥
    {0x6a, 0x6b, 0x02, 0x1d, 0x15, 0x5d, 0x7f, 0x00},   // 52 1802 e664 Ã¨Â¨Â¶
    {0x6a, 0x6b, 0x04, 0x74, 0x5f, 0x74, 0x04, 0x00},   // 52 1803 e665 Ã¨Â©Â
    {0x6a, 0x6b, 0x40, 0x7f, 0x55, 0x7f, 0x40, 0x00},   // 52 1804 e666 Ã¨Â©â€º
    {0x6a, 0x63, 0x08, 0x6c, 0x6b, 0x64, 0x08, 0x00},   // 52 1805 e667 Ã¨Â©â€™
    {0x6a, 0x6b, 0x00, 0x7e, 0x4a, 0x5e, 0x69, 0x00},   // 52 1806 e668 Ã¨Â©â€ 
    {0x17, 0x75, 0x5f, 0x5d, 0x5f, 0x75, 0x17, 0x00},   // 52 1807 e669 Ã¨Â©Ë†
    {0x6b, 0x62, 0x0a, 0x57, 0x42, 0x3a, 0x52, 0x00},   // 52 1808 e66a Ã¨Â©Â¼
    {0x6a, 0x6b, 0x42, 0x3e, 0x7d, 0x4f, 0x5c, 0x00},   // 52 1809 e66b Ã¨Â©Â­
    {0x6a, 0x6b, 0x40, 0x3e, 0x0a, 0x6a, 0x69, 0x00},   // 52 180a e66c Ã¨Â©Â¬
    {0x6a, 0x6b, 0x04, 0x7f, 0x56, 0x7e, 0x7e, 0x00},   // 52 180b e66d Ã¨Â©Â¢
    {0x6a, 0x63, 0x4c, 0x2b, 0x7f, 0x2a, 0x48, 0x00},   // 52 180c e66e Ã¨Âªâ€¦
    {0x6b, 0x62, 0x4a, 0x3f, 0x00, 0x7f, 0x4a, 0x00},   // 52 180d e66f Ã¨Âªâ€š
    {0x6b, 0x6a, 0x52, 0x36, 0x7f, 0x36, 0x55, 0x00},   // 52 180e e670 Ã¨Âªâ€ž
    {0x6a, 0x6b, 0x14, 0x33, 0x2e, 0x7e, 0x12, 0x00},   // 52 180f e671 Ã¨ÂªÂ¨
    {0x6b, 0x62, 0x0a, 0x3e, 0x4a, 0x3f, 0x52, 0x00},   // 52 1810 e672 Ã¨ÂªÂ¡
    {0x6b, 0x62, 0x55, 0x3e, 0x49, 0x7f, 0x49, 0x00},   // 52 1811 e673 Ã¨Âªâ€˜
    {0x6a, 0x63, 0x0c, 0x6b, 0x7f, 0x6a, 0x08, 0x00},   // 52 1812 e674 Ã¨ÂªÂ¥
    {0x6b, 0x62, 0x7d, 0x15, 0x7d, 0x17, 0x7d, 0x00},   // 52 1813 e675 Ã¨ÂªÂ¦
    {0x6a, 0x6b, 0x02, 0x7d, 0x2a, 0x7d, 0x02, 0x00},   // 52 1814 e676 Ã¨ÂªÅ¡
    {0x6b, 0x6a, 0x51, 0x4d, 0x7f, 0x4d, 0x51, 0x00},   // 52 1815 e677 Ã¨ÂªÂ£
    {0x6b, 0x6a, 0x22, 0x2e, 0x6b, 0x3e, 0x22, 0x00},   // 52 1816 e678 Ã¨Â«â€ž
    {0x6a, 0x6b, 0x12, 0x55, 0x7f, 0x3d, 0x12, 0x00},   // 52 1817 e679 Ã¨Â«Â
    {0x6a, 0x6b, 0x00, 0x7a, 0x41, 0x6d, 0x7b, 0x00},   // 52 1818 e67a Ã¨Â«â€š
    {0x6b, 0x6a, 0x46, 0x32, 0x47, 0x7e, 0x56, 0x00},   // 52 1819 e67b Ã¨Â«Å¡
    {0x6b, 0x6a, 0x42, 0x2e, 0x7f, 0x2e, 0x4e, 0x00},   // 52 181a e67c Ã¨Â«Â«
    {0x6b, 0x62, 0x0a, 0x6e, 0x6b, 0x6e, 0x0a, 0x00},   // 52 181b e67d Ã¨Â«Â³
    {0x6b, 0x62, 0x0f, 0x6a, 0x70, 0x6f, 0x0a, 0x00},   // 52 181c e67e Ã¨Â«Â§
    {0x6b, 0x62, 0x0b, 0x3f, 0x2c, 0x2f, 0x6b, 0x00},   // 53 181d e680 Ã¨Â«Â¤
    {0x6a, 0x63, 0x28, 0x3a, 0x2f, 0x7a, 0x2e, 0x00},   // 53 181e e681 Ã¨Â«Â±
    {0x6a, 0x6b, 0x42, 0x3c, 0x74, 0x5f, 0x5a, 0x00},   // 53 181f e682 Ã¨Â¬â€
    {0x6a, 0x6b, 0x00, 0x46, 0x6a, 0x6b, 0x46, 0x00},   // 53 1820 e683 Ã¨Â«Â 
    {0x6b, 0x6a, 0x27, 0x3d, 0x7f, 0x3d, 0x27, 0x00},   // 53 1821 e684 Ã¨Â«Â¢
    {0x6b, 0x62, 0x3f, 0x4d, 0x7f, 0x2d, 0x7f, 0x00},   // 53 1822 e685 Ã¨Â«Â·
    {0x6b, 0x6a, 0x41, 0x3f, 0x75, 0x37, 0x71, 0x00},   // 53 1823 e686 Ã¨Â«Å¾
    {0x6a, 0x63, 0x5e, 0x55, 0x3e, 0x52, 0x5e, 0x00},   // 53 1824 e687 Ã¨Â«â€º
    {0x6a, 0x6b, 0x02, 0x2d, 0x49, 0x7f, 0x09, 0x00},   // 53 1825 e688 Ã¨Â¬Å’
    {0x16, 0x6a, 0x7e, 0x7b, 0x7e, 0x6a, 0x16, 0x00},   // 53 1826 e689 Ã¨Â¬â€¡
    {0x6a, 0x6b, 0x52, 0x6d, 0x64, 0x6d, 0x52, 0x00},   // 53 1827 e68a Ã¨Â¬Å¡
    {0x6a, 0x6b, 0x42, 0x6d, 0x6c, 0x79, 0x42, 0x00},   // 53 1828 e68b Ã¨Â«Â¡
    {0x6a, 0x6b, 0x54, 0x53, 0x2b, 0x5f, 0x44, 0x00},   // 53 1829 e68c Ã¨Â¬â€“
    {0x6a, 0x6b, 0x54, 0x6e, 0x79, 0x74, 0x5a, 0x00},   // 53 182a e68d Ã¨Â¬Â
    {0x6b, 0x62, 0x1a, 0x4e, 0x3b, 0x6e, 0x1a, 0x00},   // 53 182b e68e Ã¨Â¬â€”
    {0x6a, 0x6b, 0x10, 0x6a, 0x4d, 0x7b, 0x68, 0x00},   // 53 182c e68f Ã¨Â¬Â 
    {0x6b, 0x62, 0x7f, 0x71, 0x47, 0x77, 0x71, 0x00},   // 53 182d e690 Ã¨Â¬Â³
    {0x37, 0x7e, 0x37, 0x6c, 0x6b, 0x02, 0x7e, 0x00},   // 53 182e e691 Ã©Å¾Â«
    {0x1a, 0x76, 0x57, 0x52, 0x5b, 0x75, 0x1b, 0x00},   // 53 182f e692 Ã¨Â¬Â¦
    {0x6b, 0x62, 0x7a, 0x6e, 0x5b, 0x6e, 0x7a, 0x00},   // 53 1830 e693 Ã¨Â¬Â«
    {0x6a, 0x63, 0x4c, 0x5f, 0x2d, 0x5f, 0x4c, 0x00},   // 53 1831 e694 Ã¨Â¬Â¾
    {0x6a, 0x6b, 0x52, 0x5f, 0x36, 0x5f, 0x52, 0x00},   // 53 1832 e695 Ã¨Â¬Â¨
    {0x6b, 0x62, 0x2a, 0x3f, 0x7e, 0x3f, 0x2a, 0x00},   // 53 1833 e696 Ã¨Â­Â
    {0x6b, 0x6a, 0x52, 0x1d, 0x57, 0x1d, 0x72, 0x00},   // 53 1834 e697 Ã¨Â­Å’
    {0x6a, 0x63, 0x4a, 0x3d, 0x48, 0x3a, 0x55, 0x00},   // 53 1835 e698 Ã¨Â­Â
    {0x6a, 0x63, 0x7a, 0x37, 0x5f, 0x33, 0x76, 0x00},   // 53 1836 e699 Ã¨Â­Å½
    {0x6b, 0x6a, 0x45, 0x5b, 0x69, 0x5a, 0x45, 0x00},   // 53 1837 e69a Ã¨Â­â€°
    {0x6a, 0x63, 0x14, 0x6f, 0x76, 0x6f, 0x16, 0x00},   // 53 1838 e69b Ã¨Â­â€“
    {0x6b, 0x62, 0x0a, 0x77, 0x5a, 0x77, 0x0a, 0x00},   // 53 1839 e69c Ã¨Â­â€º
    {0x6b, 0x6a, 0x21, 0x3b, 0x6b, 0x3b, 0x21, 0x00},   // 53 183a e69d Ã¨Â­Å¡
    {0x6a, 0x63, 0x3c, 0x2e, 0x75, 0x7f, 0x2c, 0x00},   // 53 183b e69e Ã¨Â­Â«
    {0x6a, 0x63, 0x5c, 0x37, 0x7d, 0x37, 0x5c, 0x00},   // 53 183c e69f Ã¨Â­Å¸
    {0x04, 0x6f, 0x6b, 0x68, 0x6e, 0x6b, 0x06, 0x00},   // 53 183d e6a0 Ã¨Â­Â¬
    {0x6b, 0x62, 0x2b, 0x3b, 0x6f, 0x3b, 0x2b, 0x00},   // 53 183e e6a1 Ã¨Â­Â¯
    {0x6b, 0x62, 0x75, 0x4e, 0x7a, 0x7f, 0x6e, 0x00},   // 53 183f e6a2 Ã¨Â­Â´
    {0x28, 0x1e, 0x69, 0x6e, 0x6d, 0x1f, 0x28, 0x00},   // 53 1840 e6a3 Ã¨Â­Â½
    {0x6b, 0x62, 0x4e, 0x3e, 0x3b, 0x3e, 0x4e, 0x00},   // 53 1841 e6a4 Ã¨Â®â‚¬
    {0x6b, 0x6a, 0x52, 0x1f, 0x56, 0x1f, 0x52, 0x00},   // 53 1842 e6a5 Ã¨Â®Å’
    {0x04, 0x7f, 0x7e, 0x6b, 0x6a, 0x7e, 0x55, 0x00},   // 53 1843 e6a6 Ã¨Â®Å½
    {0x6a, 0x6b, 0x52, 0x5e, 0x2d, 0x7f, 0x56, 0x00},   // 53 1844 e6a7 Ã¨Â®â€™
    {0x6b, 0x6a, 0x36, 0x7e, 0x5b, 0x3e, 0x56, 0x00},   // 53 1845 e6a8 Ã¨Â®â€œ
    {0x6a, 0x6b, 0x54, 0x7f, 0x54, 0x3f, 0x55, 0x00},   // 53 1846 e6a9 Ã¨Â®â€“
    {0x6b, 0x6a, 0x26, 0x7f, 0x52, 0x7f, 0x56, 0x00},   // 53 1847 e6aa Ã¨Â®â„¢
    {0x6b, 0x62, 0x4b, 0x36, 0x3b, 0x36, 0x4a, 0x00},   // 53 1848 e6ab Ã¨Â®Å¡
    {0x12, 0x69, 0x64, 0x69, 0x2f, 0x59, 0x7f, 0x00},   // 53 1849 e6ac Ã¨Â°Âº
    {0x26, 0x6a, 0x7f, 0x6e, 0x09, 0x64, 0x69, 0x00},   // 53 184a e6ad Ã¨Â±Â
    {0x52, 0x5b, 0x35, 0x5a, 0x09, 0x64, 0x69, 0x00},   // 53 184b e6ae Ã¨Â°Â¿
    {0x44, 0x5f, 0x76, 0x57, 0x76, 0x5f, 0x44, 0x00},   // 53 184c e6af Ã¨Â±Ë†
    {0x2d, 0x35, 0x2d, 0x56, 0x2a, 0x7b, 0x5e, 0x00},   // 53 184d e6b0 Ã¨Â±Å’
    {0x4f, 0x5f, 0x7d, 0x58, 0x7d, 0x5b, 0x4d, 0x00},   // 53 184e e6b1 Ã¨Â±Å½
    {0x47, 0x5e, 0x77, 0x56, 0x77, 0x5e, 0x47, 0x00},   // 53 184f e6b2 Ã¨Â±Â
    {0x29, 0x29, 0x57, 0x4d, 0x39, 0x15, 0x21, 0x00},   // 53 1850 e6b3 Ã¨Â±â€¢
    {0x52, 0x59, 0x2c, 0x5f, 0x7c, 0x29, 0x52, 0x00},   // 53 1851 e6b4 Ã¨Â±Â¢
    {0x55, 0x4b, 0x3d, 0x1a, 0x6f, 0x7a, 0x69, 0x00},   // 53 1852 e6b5 Ã¨Â±Â¬
    {0x04, 0x56, 0x56, 0x2e, 0x55, 0x3a, 0x00, 0x00},   // 53 1853 e6b6 Ã¨Â±Â¸
    {0x2a, 0x56, 0x3d, 0x22, 0x52, 0x7f, 0x0a, 0x00},   // 53 1854 e6b7 Ã¨Â±Âº
    {0x2a, 0x56, 0x3d, 0x75, 0x53, 0x59, 0x7f, 0x00},   // 53 1855 e6b8 Ã¨Â²â€š
    {0x2a, 0x56, 0x3d, 0x0a, 0x65, 0x6b, 0x10, 0x00},   // 53 1856 e6b9 Ã¨Â²â€°
    {0x2a, 0x56, 0x3d, 0x7f, 0x1a, 0x7f, 0x12, 0x00},   // 53 1857 e6ba Ã¨Â²â€¦
    {0x2a, 0x56, 0x3d, 0x7d, 0x57, 0x55, 0x7d, 0x00},   // 53 1858 e6bb Ã¨Â²Å 
    {0x2a, 0x56, 0x3d, 0x5f, 0x55, 0x7f, 0x5f, 0x00},   // 53 1859 e6bc Ã¨Â²Â
    {0x2a, 0x56, 0x3d, 0x5e, 0x35, 0x72, 0x5e, 0x00},   // 53 185a e6bd Ã¨Â²Å½
    {0x2a, 0x56, 0x3d, 0x7e, 0x5b, 0x76, 0x5e, 0x00},   // 53 185b e6be Ã¨Â²â€
    {0x2a, 0x56, 0x3d, 0x7f, 0x24, 0x7f, 0x44, 0x00},   // 53 185c e6bf Ã¨Â±Â¼
    {0x2a, 0x56, 0x3d, 0x5f, 0x36, 0x5f, 0x52, 0x00},   // 53 185d e6c0 Ã¨Â²Ëœ
    {0x5f, 0x15, 0x5f, 0x04, 0x5f, 0x24, 0x55, 0x00},   // 53 185e e6c1 Ã¦Ë†Â
    {0x40, 0x3e, 0x46, 0x3e, 0x2e, 0x3d, 0x45, 0x00},   // 53 185f e6c2 Ã¨Â²Â­
    {0x44, 0x74, 0x36, 0x35, 0x3e, 0x74, 0x44, 0x00},   // 53 1860 e6c3 Ã¨Â²Âª
    {0x5f, 0x15, 0x5f, 0x08, 0x6c, 0x6b, 0x6c, 0x00},   // 53 1861 e6c4 Ã¨Â²Â½
    {0x4e, 0x78, 0x2f, 0x2a, 0x28, 0x7f, 0x4a, 0x00},   // 53 1862 e6c5 Ã¨Â²Â²
    {0x42, 0x36, 0x36, 0x42, 0x0f, 0x32, 0x43, 0x00},   // 53 1863 e6c6 Ã¨Â²Â³
    {0x44, 0x3d, 0x3d, 0x44, 0x0f, 0x34, 0x45, 0x00},   // 53 1864 e6c7 Ã¨Â²Â®
    {0x5f, 0x15, 0x5f, 0x34, 0x25, 0x57, 0x4d, 0x00},   // 53 1865 e6c8 Ã¨Â²Â¶
    {0x41, 0x7f, 0x2d, 0x2f, 0x2d, 0x7f, 0x41, 0x00},   // 53 1866 e6c9 Ã¨Â³Ë†
    {0x4a, 0x7e, 0x2a, 0x2f, 0x2a, 0x7e, 0x4a, 0x00},   // 53 1867 e6ca Ã¨Â³Â
    {0x5f, 0x15, 0x5f, 0x12, 0x5b, 0x36, 0x5b, 0x00},   // 53 1868 e6cb Ã¨Â³Â¤
    {0x42, 0x7e, 0x2a, 0x2f, 0x2a, 0x7e, 0x42, 0x00},   // 53 1869 e6cc Ã¨Â³Â£
    {0x4a, 0x76, 0x3a, 0x37, 0x3a, 0x76, 0x4a, 0x00},   // 53 186a e6cd Ã¨Â³Å¡
    {0x56, 0x7a, 0x2e, 0x2b, 0x2e, 0x7a, 0x56, 0x00},   // 53 186b e6ce Ã¨Â³Â½
    {0x5f, 0x15, 0x5f, 0x2b, 0x7e, 0x3f, 0x5a, 0x00},   // 53 186c e6cf Ã¨Â³Âº
    {0x5f, 0x15, 0x5f, 0x3e, 0x57, 0x7e, 0x13, 0x00},   // 53 186d e6d0 Ã¨Â³Â»
    {0x44, 0x4e, 0x3f, 0x3a, 0x37, 0x7e, 0x48, 0x00},   // 53 186e e6d1 Ã¨Â´â€ž
    {0x54, 0x4e, 0x3f, 0x34, 0x3a, 0x75, 0x4b, 0x00},   // 53 186f e6d2 Ã¨Â´â€¦
    {0x4a, 0x77, 0x3f, 0x3a, 0x37, 0x7f, 0x4a, 0x00},   // 53 1870 e6d3 Ã¨Â´Å 
    {0x56, 0x4b, 0x36, 0x3d, 0x35, 0x7e, 0x55, 0x00},   // 53 1871 e6d4 Ã¨Â´â€¡
    {0x42, 0x3e, 0x7a, 0x3b, 0x4a, 0x7a, 0x72, 0x00},   // 53 1872 e6d5 Ã¨Â´Â
    {0x5f, 0x15, 0x5f, 0x3e, 0x75, 0x7f, 0x2c, 0x00},   // 53 1873 e6d6 Ã¨Â´Â
    {0x5f, 0x15, 0x5f, 0x6a, 0x7f, 0x6e, 0x54, 0x00},   // 53 1874 e6d7 Ã¨Â´Â
    {0x4a, 0x36, 0x7e, 0x3b, 0x7e, 0x76, 0x0a, 0x00},   // 53 1875 e6d8 Ã©Â½Å½
    {0x5f, 0x1f, 0x6c, 0x3e, 0x5a, 0x3f, 0x52, 0x00},   // 53 1876 e6d9 Ã¨Â´â€œ
    {0x5f, 0x15, 0x5f, 0x3e, 0x4a, 0x7f, 0x4a, 0x00},   // 53 1877 e6da Ã¨Â³Â
    {0x40, 0x34, 0x33, 0x43, 0x33, 0x34, 0x40, 0x00},   // 53 1878 e6db Ã¨Â´â€
    {0x5f, 0x15, 0x5f, 0x3e, 0x3b, 0x3e, 0x4e, 0x00},   // 53 1879 e6dc Ã¨Â´â€“
    {0x58, 0x3a, 0x7f, 0x2a, 0x7f, 0x2b, 0x5b, 0x00},   // 53 187a e6dd Ã¨ÂµÂ§
    {0x58, 0x3a, 0x7f, 0x2a, 0x1a, 0x6f, 0x6a, 0x00},   // 53 187b e6de Ã¨ÂµÂ­
    {0x44, 0x26, 0x4e, 0x67, 0x56, 0x4e, 0x44, 0x00},   // 53 187c e6df Ã¨ÂµÂ±
    {0x6a, 0x3f, 0x4a, 0x5f, 0x50, 0x7f, 0x48, 0x00},   // 53 187d e6e0 Ã¨ÂµÂ³
    {0x6a, 0x3f, 0x44, 0x6a, 0x65, 0x52, 0x44, 0x00},   // 53 187e e6e1 Ã¨Â¶Â
    {0x6a, 0x3f, 0x4a, 0x7d, 0x56, 0x7d, 0x42, 0x00},   // 53 187f e6e2 Ã¨Â¶â„¢
    {0x77, 0x7d, 0x57, 0x5a, 0x2f, 0x5a, 0x42, 0x00},   // 53 1880 e6e3 Ã¨Â·â€š
    {0x77, 0x7d, 0x57, 0x7c, 0x40, 0x7f, 0x48, 0x00},   // 53 1881 e6e4 Ã¨Â¶Â¾
    {0x77, 0x7d, 0x4f, 0x2a, 0x1f, 0x2a, 0x48, 0x00},   // 53 1882 e6e5 Ã¨Â¶Âº
    {0x77, 0x7d, 0x66, 0x1f, 0x7e, 0x42, 0x7e, 0x00},   // 53 1883 e6e6 Ã¨Â·Â
    {0x77, 0x7d, 0x2b, 0x7f, 0x3f, 0x09, 0x7f, 0x00},   // 53 1884 e6e7 Ã¨Â·Å¡
    {0x77, 0x7d, 0x57, 0x11, 0x7f, 0x49, 0x79, 0x00},   // 53 1885 e6e8 Ã¨Â·â€“
    {0x77, 0x7d, 0x4e, 0x2b, 0x1f, 0x2a, 0x48, 0x00},   // 53 1886 e6e9 Ã¨Â·Å’
    {0x77, 0x7d, 0x57, 0x3e, 0x5a, 0x2f, 0x5e, 0x00},   // 53 1887 e6ea Ã¨Â·â€º
    {0x77, 0x7d, 0x57, 0x22, 0x5f, 0x22, 0x5b, 0x00},   // 53 1888 e6eb Ã¨Â·â€¹
    {0x77, 0x7d, 0x57, 0x3e, 0x7d, 0x4f, 0x5c, 0x00},   // 53 1889 e6ec Ã¨Â·Âª
    {0x45, 0x27, 0x5d, 0x7c, 0x5b, 0x47, 0x44, 0x00},   // 53 188a e6ed Ã¨Â·Â«
    {0x77, 0x7d, 0x2b, 0x7f, 0x55, 0x35, 0x5f, 0x00},   // 53 188b e6ee Ã¨Â·Å¸
    {0x77, 0x7d, 0x57, 0x4c, 0x3b, 0x7f, 0x4a, 0x00},   // 53 188c e6ef Ã¨Â·Â£
    {0x77, 0x7d, 0x57, 0x3f, 0x35, 0x47, 0x7c, 0x00},   // 53 188d e6f0 Ã¨Â·Â¼
    {0x77, 0x7d, 0x4f, 0x2e, 0x7f, 0x2a, 0x4e, 0x00},   // 53 188e e6f1 Ã¨Â¸Ë†
    {0x77, 0x7d, 0x57, 0x7e, 0x5a, 0x3b, 0x5e, 0x00},   // 53 188f e6f2 Ã¨Â¸â€°
    {0x77, 0x7d, 0x57, 0x28, 0x4a, 0x7f, 0x5a, 0x00},   // 53 1890 e6f3 Ã¨Â·Â¿
    {0x77, 0x7f, 0x57, 0x35, 0x7f, 0x35, 0x57, 0x00},   // 53 1891 e6f4 Ã¨Â¸Â
    {0x77, 0x7d, 0x57, 0x3f, 0x6b, 0x5f, 0x6b, 0x00},   // 53 1892 e6f5 Ã¨Â¸Å¾
    {0x77, 0x7d, 0x57, 0x12, 0x5b, 0x36, 0x5b, 0x00},   // 53 1893 e6f6 Ã¨Â¸Â
    {0x77, 0x7d, 0x4b, 0x3e, 0x4a, 0x3e, 0x3e, 0x00},   // 53 1894 e6f7 Ã¨Â¸Å¸
    {0x77, 0x7d, 0x5a, 0x37, 0x7f, 0x33, 0x56, 0x00},   // 53 1895 e6f8 Ã¨Â¹â€š
    {0x77, 0x7d, 0x47, 0x5e, 0x7e, 0x5d, 0x44, 0x00},   // 53 1896 e6f9 Ã¨Â¸Âµ
    {0x77, 0x7d, 0x2b, 0x73, 0x75, 0x26, 0x54, 0x00},   // 53 1897 e6fa Ã¨Â¸Â°
    {0x77, 0x7d, 0x2b, 0x50, 0x3d, 0x5f, 0x7d, 0x00},   // 53 1898 e6fb Ã¨Â¸Â´
    {0x77, 0x7d, 0x2b, 0x52, 0x5b, 0x35, 0x5a, 0x00},   // 53 1899 e6fc Ã¨Â¹Å 
    {0x56, 0x2a, 0x5e, 0x7b, 0x5e, 0x4a, 0x56, 0x00},   // 54 189a e740 Ã¨Â¹â€¡
    {0x77, 0x7d, 0x4a, 0x3b, 0x5e, 0x7b, 0x5a, 0x00},   // 54 189b e741 Ã¨Â¹â€°
    {0x77, 0x7d, 0x57, 0x24, 0x1e, 0x6d, 0x62, 0x00},   // 54 189c e742 Ã¨Â¹Å’
    {0x77, 0x7d, 0x57, 0x7d, 0x2a, 0x7d, 0x15, 0x00},   // 54 189d e743 Ã¨Â¹Â
    {0x77, 0x7d, 0x72, 0x69, 0x43, 0x69, 0x7a, 0x00},   // 54 189e e744 Ã¨Â¹Ë†
    {0x50, 0x2e, 0x5a, 0x7e, 0x5a, 0x4f, 0x52, 0x00},   // 54 189f e745 Ã¨Â¹â„¢
    {0x77, 0x7d, 0x57, 0x7d, 0x22, 0x79, 0x52, 0x00},   // 54 18a0 e746 Ã¨Â¹Â¤
    {0x77, 0x7d, 0x5f, 0x0e, 0x5b, 0x1e, 0x4a, 0x00},   // 54 18a1 e747 Ã¨Â¹Â 
    {0x77, 0x7d, 0x57, 0x1a, 0x7b, 0x1a, 0x56, 0x00},   // 54 18a2 e748 Ã¨Â¸Âª
    {0x77, 0x7d, 0x7a, 0x3f, 0x7a, 0x3f, 0x7a, 0x00},   // 54 18a3 e749 Ã¨Â¹Â£
    {0x77, 0x7d, 0x2b, 0x3f, 0x6b, 0x3f, 0x2b, 0x00},   // 54 18a4 e74a Ã¨Â¹â€¢
    {0x77, 0x7d, 0x5f, 0x35, 0x4b, 0x3d, 0x4d, 0x00},   // 54 18a5 e74b Ã¨Â¹Â¶
    {0x77, 0x7d, 0x1f, 0x37, 0x52, 0x77, 0x1e, 0x00},   // 54 18a6 e74c Ã¨Â¹Â²
    {0x77, 0x7d, 0x4b, 0x5e, 0x3b, 0x5e, 0x4b, 0x00},   // 54 18a7 e74d Ã¨Â¹Â¼
    {0x77, 0x7f, 0x5c, 0x37, 0x7d, 0x37, 0x5c, 0x00},   // 54 18a8 e74e Ã¨ÂºÂ
    {0x77, 0x7d, 0x52, 0x37, 0x7e, 0x7f, 0x12, 0x00},   // 54 18a9 e74f Ã¨Âºâ€¡
    {0x77, 0x7f, 0x4b, 0x75, 0x77, 0x25, 0x7f, 0x00},   // 54 18aa e750 Ã¨Âºâ€¦
    {0x44, 0x2f, 0x5b, 0x78, 0x5e, 0x5b, 0x46, 0x00},   // 54 18ab e751 Ã¨Âºâ€ž
    {0x77, 0x7d, 0x4b, 0x36, 0x2b, 0x76, 0x0a, 0x00},   // 54 18ac e752 Ã¨Âºâ€¹
    {0x77, 0x7d, 0x37, 0x36, 0x5f, 0x76, 0x14, 0x00},   // 54 18ad e753 Ã¨ÂºÅ 
    {0x77, 0x7d, 0x46, 0x3d, 0x38, 0x3e, 0x45, 0x00},   // 54 18ae e754 Ã¨Âºâ€œ
    {0x77, 0x7d, 0x5a, 0x39, 0x5a, 0x7f, 0x1b, 0x00},   // 54 18af e755 Ã¨Âºâ€˜
    {0x77, 0x7d, 0x3e, 0x5a, 0x6f, 0x5e, 0x5a, 0x00},   // 54 18b0 e756 Ã¨Âºâ€
    {0x77, 0x7d, 0x7f, 0x13, 0x3c, 0x3b, 0x7f, 0x00},   // 54 18b1 e757 Ã¨Âºâ„¢
    {0x77, 0x7d, 0x7e, 0x17, 0x3a, 0x37, 0x7e, 0x00},   // 54 18b2 e758 Ã¨ÂºÂª
    {0x77, 0x7d, 0x37, 0x75, 0x27, 0x3f, 0x75, 0x00},   // 54 18b3 e759 Ã¨ÂºÂ¡
    {0x50, 0x5e, 0x2b, 0x7e, 0x1d, 0x55, 0x77, 0x00},   // 54 18b4 e75a Ã¨ÂºÂ¬
    {0x5e, 0x2b, 0x7e, 0x12, 0x2a, 0x7f, 0x12, 0x00},   // 54 18b5 e75b Ã¨ÂºÂ°
    {0x50, 0x5e, 0x2b, 0x7e, 0x57, 0x76, 0x5f, 0x00},   // 54 18b6 e75c Ã¨Â»â€ 
    {0x5e, 0x2b, 0x7e, 0x35, 0x7b, 0x35, 0x56, 0x00},   // 54 18b7 e75d Ã¨ÂºÂ±
    {0x50, 0x5e, 0x2b, 0x7e, 0x57, 0x3e, 0x57, 0x00},   // 54 18b8 e75e Ã¨ÂºÂ¾
    {0x5e, 0x2b, 0x7e, 0x3f, 0x79, 0x7f, 0x55, 0x00},   // 54 18b9 e75f Ã¨Â»â€¦
    {0x5e, 0x2b, 0x7e, 0x7e, 0x2e, 0x4f, 0x6a, 0x00},   // 54 18ba e760 Ã¨Â»Ë†
    {0x2d, 0x7f, 0x2d, 0x00, 0x7f, 0x40, 0x60, 0x00},   // 54 18bb e761 Ã¨Â»â€¹
    {0x2d, 0x7f, 0x2d, 0x3f, 0x7d, 0x45, 0x5d, 0x00},   // 54 18bc e762 Ã¨Â»â€º
    {0x4a, 0x5e, 0x2a, 0x0f, 0x2a, 0x5e, 0x4a, 0x00},   // 54 18bd e763 Ã¨Â»Â£
    {0x2d, 0x7f, 0x4c, 0x2b, 0x1f, 0x2a, 0x48, 0x00},   // 54 18be e764 Ã¨Â»Â¼
    {0x2d, 0x7f, 0x2d, 0x1d, 0x15, 0x5d, 0x7f, 0x00},   // 54 18bf e765 Ã¨Â»Â»
    {0x2d, 0x7f, 0x2d, 0x42, 0x55, 0x2a, 0x14, 0x00},   // 54 18c0 e766 Ã¨Â»Â«
    {0x2d, 0x7f, 0x2d, 0x54, 0x74, 0x3f, 0x45, 0x00},   // 54 18c1 e767 Ã¨Â»Â¾
    {0x2d, 0x7f, 0x45, 0x57, 0x7d, 0x53, 0x45, 0x00},   // 54 18c2 e768 Ã¨Â¼Å 
    {0x2d, 0x7f, 0x2d, 0x0a, 0x65, 0x6b, 0x10, 0x00},   // 54 18c3 e769 Ã¨Â¼â€¦
    {0x2d, 0x7f, 0x2d, 0x55, 0x5b, 0x75, 0x5b, 0x00},   // 54 18c4 e76a Ã¨Â¼â€¢
    {0x2d, 0x7f, 0x21, 0x3f, 0x6d, 0x7f, 0x41, 0x00},   // 54 18c5 e76b Ã¨Â¼â€™
    {0x2d, 0x7f, 0x21, 0x3f, 0x7f, 0x12, 0x2e, 0x00},   // 54 18c6 e76c Ã¨Â¼â„¢
    {0x2d, 0x7f, 0x5c, 0x36, 0x1d, 0x77, 0x5c, 0x00},   // 54 18c7 e76d Ã¨Â¼â€œ
    {0x2d, 0x7f, 0x2d, 0x7a, 0x5d, 0x7a, 0x7d, 0x00},   // 54 18c8 e76e Ã¨Â¼Å“
    {0x2d, 0x7f, 0x5d, 0x2b, 0x5d, 0x2b, 0x5d, 0x00},   // 54 18c9 e76f Ã¨Â¼Å¸
    {0x2d, 0x7f, 0x7d, 0x35, 0x7f, 0x35, 0x7d, 0x00},   // 54 18ca e770 Ã¨Â¼â€º
    {0x2d, 0x7f, 0x7d, 0x35, 0x3f, 0x35, 0x7d, 0x00},   // 54 18cb e771 Ã¨Â¼Å’
    {0x2a, 0x37, 0x3a, 0x70, 0x3a, 0x37, 0x2a, 0x00},   // 54 18cc e772 Ã¨Â¼Â¦
    {0x2d, 0x7f, 0x1a, 0x4e, 0x3f, 0x4e, 0x1a, 0x00},   // 54 18cd e773 Ã¨Â¼Â³
    {0x2d, 0x7f, 0x2d, 0x71, 0x57, 0x77, 0x71, 0x00},   // 54 18ce e774 Ã¨Â¼Â»
    {0x2d, 0x7f, 0x4d, 0x53, 0x2e, 0x5e, 0x42, 0x00},   // 54 18cf e775 Ã¨Â¼Â¹
    {0x2d, 0x7f, 0x2d, 0x7e, 0x57, 0x36, 0x5c, 0x00},   // 54 18d0 e776 Ã¨Â½â€¦
    {0x2a, 0x3e, 0x7f, 0x2e, 0x5b, 0x29, 0x5b, 0x00},   // 54 18d1 e777 Ã¨Â½â€š
    {0x2d, 0x7f, 0x3f, 0x75, 0x5d, 0x3d, 0x57, 0x00},   // 54 18d2 e778 Ã¨Â¼Â¾
    {0x2d, 0x7f, 0x2d, 0x06, 0x53, 0x77, 0x26, 0x00},   // 54 18d3 e779 Ã¨Â½Å’
    {0x2d, 0x7f, 0x12, 0x3e, 0x5f, 0x76, 0x1a, 0x00},   // 54 18d4 e77a Ã¨Â½â€°
    {0x2d, 0x7f, 0x7e, 0x5a, 0x1f, 0x7e, 0x5a, 0x00},   // 54 18d5 e77b Ã¨Â½â€ 
    {0x2d, 0x7f, 0x7a, 0x17, 0x5b, 0x17, 0x7a, 0x00},   // 54 18d6 e77c Ã¨Â½Å½
    {0x2d, 0x7f, 0x6e, 0x2e, 0x42, 0x47, 0x6a, 0x00},   // 54 18d7 e77d Ã¨Â½â€”
    {0x2d, 0x7f, 0x66, 0x2b, 0x7f, 0x2b, 0x66, 0x00},   // 54 18d8 e77e Ã¨Â½Å“
    {0x2d, 0x7f, 0x5a, 0x35, 0x7f, 0x3a, 0x55, 0x00},   // 55 18d9 e780 Ã¨Â½Â¢
    {0x2d, 0x7f, 0x3f, 0x6f, 0x45, 0x6f, 0x45, 0x00},   // 55 18da e781 Ã¨Â½Â£
    {0x2d, 0x7f, 0x3d, 0x44, 0x6f, 0x6a, 0x4a, 0x00},   // 55 18db e782 Ã¨Â½Â¤
    {0x12, 0x36, 0x3e, 0x77, 0x3e, 0x36, 0x12, 0x00},   // 55 18dc e783 Ã¨Â¾Å“
    {0x10, 0x7f, 0x77, 0x2a, 0x2e, 0x7b, 0x2e, 0x00},   // 55 18dd e784 Ã¨Â¾Å¸
    {0x56, 0x3b, 0x5e, 0x2e, 0x7f, 0x2a, 0x4e, 0x00},   // 55 18de e785 Ã¨Â¾Â£
    {0x72, 0x55, 0x37, 0x7d, 0x2e, 0x7b, 0x2e, 0x00},   // 55 18df e786 Ã¨Â¾Â­
    {0x56, 0x3f, 0x6a, 0x6b, 0x2e, 0x7b, 0x2e, 0x00},   // 55 18e0 e787 Ã¨Â¾Â¯
    {0x55, 0x30, 0x44, 0x44, 0x44, 0x44, 0x44, 0x00},   // 55 18e1 e788 Ã¨Â¾Â·
    {0x55, 0x30, 0x4e, 0x4a, 0x7f, 0x4a, 0x4e, 0x00},   // 55 18e2 e789 Ã¨Â¿Å¡
    {0x55, 0x30, 0x7f, 0x4d, 0x4d, 0x61, 0x7f, 0x00},   // 55 18e3 e78a Ã¨Â¿Â¥
    {0x55, 0x30, 0x45, 0x7d, 0x6b, 0x69, 0x7f, 0x00},   // 55 18e4 e78b Ã¨Â¿Â¢
    {0x55, 0x30, 0x7e, 0x6a, 0x7f, 0x6a, 0x7e, 0x00},   // 55 18e5 e78c Ã¨Â¿Âª
    {0x55, 0x30, 0x64, 0x5b, 0x4e, 0x7f, 0x44, 0x00},   // 55 18e6 e78d Ã¨Â¿Â¯
    {0x55, 0x30, 0x45, 0x7f, 0x57, 0x6d, 0x7f, 0x00},   // 55 18e7 e78e Ã©â€šâ€¡
    {0x55, 0x30, 0x7f, 0x5d, 0x55, 0x5d, 0x7f, 0x00},   // 55 18e8 e78f Ã¨Â¿Â´
    {0x55, 0x30, 0x60, 0x5e, 0x4a, 0x6a, 0x69, 0x00},   // 55 18e9 e790 Ã©â‚¬â€¦
    {0x55, 0x30, 0x6a, 0x5e, 0x63, 0x7e, 0x4a, 0x00},   // 55 18ea e791 Ã¨Â¿Â¹
    {0x55, 0x30, 0x7d, 0x6f, 0x65, 0x6f, 0x7d, 0x00},   // 55 18eb e792 Ã¨Â¿Âº
    {0x55, 0x30, 0x6a, 0x52, 0x7f, 0x52, 0x6b, 0x00},   // 55 18ec e793 Ã©â‚¬â€˜
    {0x55, 0x30, 0x40, 0x6d, 0x6b, 0x7d, 0x6b, 0x00},   // 55 18ed e794 Ã©â‚¬â€¢
    {0x55, 0x30, 0x4a, 0x67, 0x72, 0x5e, 0x6b, 0x00},   // 55 18ee e795 Ã©â‚¬Â¡
    {0x55, 0x30, 0x42, 0x7d, 0x56, 0x7d, 0x42, 0x00},   // 55 18ef e796 Ã©â‚¬Â
    {0x55, 0x30, 0x44, 0x6f, 0x7d, 0x6f, 0x44, 0x00},   // 55 18f0 e797 Ã©â‚¬Å¾
    {0x55, 0x30, 0x6b, 0x5e, 0x65, 0x5f, 0x64, 0x00},   // 55 18f1 e798 Ã©â‚¬â€“
    {0x55, 0x30, 0x42, 0x7a, 0x7f, 0x5a, 0x7b, 0x00},   // 55 18f2 e799 Ã©â‚¬â€¹
    {0x55, 0x30, 0x52, 0x49, 0x74, 0x79, 0x52, 0x00},   // 55 18f3 e79a Ã©â‚¬Â§
    {0x55, 0x30, 0x6a, 0x77, 0x7f, 0x57, 0x6a, 0x00},   // 55 18f4 e79b Ã©â‚¬Â¶
    {0x55, 0x30, 0x54, 0x6e, 0x77, 0x6e, 0x6c, 0x00},   // 55 18f5 e79c Ã©â‚¬Âµ
    {0x55, 0x30, 0x54, 0x5e, 0x77, 0x5e, 0x54, 0x00},   // 55 18f6 e79d Ã©â‚¬Â¹
    {0x55, 0x30, 0x54, 0x7d, 0x54, 0x7d, 0x54, 0x00},   // 55 18f7 e79e Ã¨Â¿Â¸
    {0x55, 0x30, 0x48, 0x5f, 0x55, 0x67, 0x7c, 0x00},   // 55 18f8 e79f Ã©ÂÂ
    {0x55, 0x30, 0x7f, 0x4b, 0x6c, 0x55, 0x6f, 0x00},   // 55 18f9 e7a0 Ã©ÂÂ
    {0x55, 0x30, 0x48, 0x6e, 0x7b, 0x6e, 0x48, 0x00},   // 55 18fa e7a1 Ã©Ââ€˜
    {0x55, 0x30, 0x7a, 0x5d, 0x4d, 0x5d, 0x7a, 0x00},   // 55 18fb e7a2 Ã©Ââ€™
    {0x55, 0x30, 0x7d, 0x6f, 0x65, 0x6f, 0x7d, 0x00},   // 55 18fc e7a3 Ã©â‚¬Å½
    {0x55, 0x30, 0x60, 0x5c, 0x5f, 0x5e, 0x62, 0x00},   // 55 18fd e7a4 Ã©Ââ€°
    {0x55, 0x30, 0x45, 0x73, 0x75, 0x66, 0x54, 0x00},   // 55 18fe e7a5 Ã©â‚¬Â¾
    {0x55, 0x30, 0x7a, 0x5a, 0x6f, 0x5a, 0x7a, 0x00},   // 55 18ff e7a6 Ã©Ââ€“
    {0x55, 0x30, 0x6a, 0x7f, 0x7a, 0x7f, 0x6a, 0x00},   // 55 1900 e7a7 Ã©ÂËœ
    {0x55, 0x30, 0x5f, 0x6d, 0x55, 0x7f, 0x6b, 0x00},   // 55 1901 e7a8 Ã©ÂÅ¾
    {0x55, 0x30, 0x56, 0x6f, 0x7c, 0x53, 0x6e, 0x00},   // 55 1902 e7a9 Ã©ÂÂ¨
    {0x55, 0x30, 0x7f, 0x55, 0x7f, 0x7b, 0x55, 0x00},   // 55 1903 e7aa Ã©ÂÂ¯
    {0x55, 0x30, 0x6c, 0x5e, 0x4f, 0x7e, 0x6c, 0x00},   // 55 1904 e7ab Ã©ÂÂ¶
    {0x7f, 0x25, 0x1b, 0x65, 0x4a, 0x7f, 0x7a, 0x00},   // 55 1905 e7ac Ã©Å¡Â¨
    {0x55, 0x30, 0x7f, 0x57, 0x5b, 0x7f, 0x57, 0x00},   // 55 1906 e7ad Ã©ÂÂ²
    {0x55, 0x30, 0x62, 0x5d, 0x7f, 0x51, 0x7b, 0x00},   // 55 1907 e7ae Ã©â€šâ€š
    {0x55, 0x30, 0x5c, 0x6c, 0x7f, 0x5a, 0x6a, 0x00},   // 55 1908 e7af Ã©ÂÂ½
    {0x55, 0x30, 0x7a, 0x6f, 0x7a, 0x5f, 0x7a, 0x00},   // 55 1909 e7b0 Ã©â€šÂ
    {0x55, 0x30, 0x56, 0x6f, 0x7e, 0x53, 0x6e, 0x00},   // 55 190a e7b1 Ã©â€šâ‚¬
    {0x55, 0x30, 0x58, 0x6e, 0x5d, 0x7e, 0x58, 0x00},   // 55 190b e7b2 Ã©â€šÅ 
    {0x55, 0x30, 0x58, 0x6e, 0x5d, 0x6e, 0x58, 0x00},   // 55 190c e7b3 Ã©â€šâ€°
    {0x55, 0x30, 0x57, 0x7b, 0x53, 0x7f, 0x6b, 0x00},   // 55 190d e7b4 Ã©â€šÂ
    {0x1a, 0x7f, 0x52, 0x1a, 0x7f, 0x25, 0x1b, 0x00},   // 55 190e e7b5 Ã©â€šÂ¨
    {0x02, 0x7f, 0x4a, 0x7f, 0x02, 0x7f, 0x1b, 0x00},   // 55 190f e7b6 Ã©â€šÂ¯
    {0x40, 0x7e, 0x4a, 0x39, 0x28, 0x7f, 0x1b, 0x00},   // 55 1910 e7b7 Ã©â€šÂ±
    {0x09, 0x77, 0x59, 0x7f, 0x00, 0x7f, 0x1b, 0x00},   // 55 1911 e7b8 Ã©â€šÂµ
    {0x44, 0x57, 0x7d, 0x37, 0x24, 0x7f, 0x1b, 0x00},   // 55 1912 e7b9 Ã©Æ’Â¢
    {0x12, 0x69, 0x64, 0x09, 0x7f, 0x25, 0x1b, 0x00},   // 55 1913 e7ba Ã©Æ’Â¤
    {0x41, 0x3f, 0x7d, 0x55, 0x5d, 0x57, 0x5d, 0x00},   // 55 1914 e7bb Ã¦â€°Ë†
    {0x22, 0x29, 0x6b, 0x39, 0x22, 0x7f, 0x1b, 0x00},   // 55 1915 e7bc Ã©Æ’â€º
    {0x0b, 0x3f, 0x6c, 0x0b, 0x7f, 0x25, 0x1b, 0x00},   // 55 1916 e7bd Ã©â€žâ€š
    {0x24, 0x5b, 0x36, 0x36, 0x7f, 0x25, 0x1b, 0x00},   // 55 1917 e7be Ã©â€žâ€™
    {0x08, 0x7b, 0x7d, 0x7b, 0x08, 0x7f, 0x1b, 0x00},   // 55 1918 e7bf Ã©â€žâ„¢
    {0x23, 0x3f, 0x7c, 0x23, 0x7f, 0x25, 0x1b, 0x00},   // 55 1919 e7c0 Ã©â€žÂ²
    {0x55, 0x32, 0x27, 0x72, 0x25, 0x7f, 0x1b, 0x00},   // 55 191a e7c1 Ã©â€žÂ°
    {0x7d, 0x6f, 0x7d, 0x01, 0x41, 0x7f, 0x01, 0x00},   // 55 191b e7c2 Ã©â€¦Å 
    {0x7d, 0x6f, 0x7d, 0x46, 0x3f, 0x72, 0x46, 0x00},   // 55 191c e7c3 Ã©â€¦â€“
    {0x7d, 0x6f, 0x7d, 0x40, 0x5b, 0x29, 0x5b, 0x00},   // 55 191d e7c4 Ã©â€¦Ëœ
    {0x7d, 0x6f, 0x7d, 0x02, 0x7f, 0x4a, 0x7f, 0x00},   // 55 191e e7c5 Ã©â€¦Â£
    {0x7d, 0x6f, 0x7d, 0x24, 0x15, 0x7f, 0x25, 0x00},   // 55 191f e7c6 Ã©â€¦Â¥
    {0x7d, 0x6f, 0x7d, 0x14, 0x7b, 0x55, 0x73, 0x00},   // 55 1920 e7c7 Ã©â€¦Â©
    {0x7d, 0x6f, 0x7d, 0x08, 0x7a, 0x2d, 0x78, 0x00},   // 55 1921 e7c8 Ã©â€¦Â³
    {0x7d, 0x6f, 0x7d, 0x08, 0x5b, 0x7d, 0x57, 0x00},   // 55 1922 e7c9 Ã©â€¦Â²
    {0x7d, 0x6f, 0x7d, 0x0a, 0x7f, 0x5a, 0x7f, 0x00},   // 55 1923 e7ca Ã©â€ â€¹
    {0x7d, 0x6f, 0x7d, 0x2e, 0x73, 0x2e, 0x32, 0x00},   // 55 1924 e7cb Ã©â€ â€°
    {0x7d, 0x6f, 0x7d, 0x1a, 0x7f, 0x1a, 0x7f, 0x00},   // 55 1925 e7cc Ã©â€ â€š
    {0x7d, 0x6f, 0x7d, 0x4a, 0x67, 0x7a, 0x5a, 0x00},   // 55 1926 e7cd Ã©â€ Â¢
    {0x1f, 0x77, 0x7d, 0x55, 0x7b, 0x75, 0x1b, 0x00},   // 55 1927 e7ce Ã©â€ Â«
    {0x7d, 0x6f, 0x7d, 0x52, 0x6e, 0x7b, 0x5a, 0x00},   // 55 1928 e7cf Ã©â€ Â¯
    {0x7d, 0x6f, 0x7d, 0x11, 0x4b, 0x55, 0x2b, 0x00},   // 55 1929 e7d0 Ã©â€ Âª
    {0x7d, 0x6f, 0x7d, 0x2c, 0x57, 0x7a, 0x2a, 0x00},   // 55 192a e7d1 Ã©â€ Âµ
    {0x7d, 0x6f, 0x7d, 0x5e, 0x77, 0x76, 0x5f, 0x00},   // 55 192b e7d2 Ã©â€ Â´
    {0x7d, 0x6f, 0x7d, 0x52, 0x1f, 0x5f, 0x52, 0x00},   // 55 192c e7d3 Ã©â€ Âº
    {0x7d, 0x7f, 0x36, 0x7e, 0x5b, 0x3e, 0x56, 0x00},   // 55 192d e7d4 Ã©â€¡â‚¬
    {0x44, 0x3e, 0x55, 0x36, 0x75, 0x3f, 0x44, 0x00},   // 55 192e e7d5 Ã©â€¡Â
    {0x55, 0x31, 0x7f, 0x35, 0x7c, 0x7f, 0x7c, 0x00},   // 55 192f e7d6 Ã©â€¡â€°
    {0x55, 0x31, 0x7f, 0x2b, 0x3b, 0x6f, 0x3b, 0x00},   // 55 1930 e7d7 Ã©â€¡â€¹
    {0x44, 0x3e, 0x5f, 0x7e, 0x7a, 0x75, 0x5b, 0x00},   // 55 1931 e7d8 Ã©â€¡Â
    {0x56, 0x7d, 0x36, 0x41, 0x3f, 0x41, 0x7f, 0x00},   // 55 1932 e7d9 Ã©â€¡â€“
    {0x56, 0x7d, 0x56, 0x3f, 0x00, 0x3f, 0x40, 0x00},   // 55 1933 e7da Ã©â€¡Å¸
    {0x48, 0x6a, 0x59, 0x74, 0x59, 0x6a, 0x48, 0x00},   // 55 1934 e7db Ã©â€¡Â¡
    {0x56, 0x7d, 0x36, 0x42, 0x3f, 0x42, 0x7e, 0x00},   // 55 1935 e7dc Ã©â€¡â€º
    {0x56, 0x7d, 0x36, 0x45, 0x3f, 0x51, 0x7f, 0x00},   // 55 1936 e7dd Ã©â€¡Â¼
    {0x56, 0x7d, 0x57, 0x29, 0x13, 0x29, 0x47, 0x00},   // 55 1937 e7de Ã©â€¡Âµ
    {0x56, 0x7d, 0x36, 0x7e, 0x44, 0x5f, 0x6c, 0x00},   // 55 1938 e7df Ã©â€¡Â¶
    {0x56, 0x7d, 0x36, 0x04, 0x2b, 0x52, 0x7e, 0x00},   // 55 1939 e7e0 Ã©Ë†Å¾
    {0x56, 0x7d, 0x36, 0x40, 0x3e, 0x0a, 0x79, 0x00},   // 55 193a e7e1 Ã©â€¡Â¿
    {0x56, 0x7d, 0x2a, 0x46, 0x5f, 0x22, 0x14, 0x00},   // 55 193b e7e2 Ã©Ë†â€
    {0x56, 0x7d, 0x56, 0x3f, 0x05, 0x1d, 0x67, 0x00},   // 55 193c e7e3 Ã©Ë†Â¬
    {0x56, 0x7d, 0x4b, 0x7f, 0x49, 0x7f, 0x48, 0x00},   // 55 193d e7e4 Ã©Ë†â€¢
    {0x56, 0x7d, 0x56, 0x3f, 0x5d, 0x25, 0x5d, 0x00},   // 55 193e e7e5 Ã©Ë†â€˜
    {0x56, 0x7d, 0x36, 0x7e, 0x42, 0x3f, 0x52, 0x00},   // 55 193f e7e6 Ã©â€°Å¾
    {0x56, 0x7d, 0x36, 0x7f, 0x4a, 0x7f, 0x02, 0x00},   // 55 1940 e7e7 Ã©â€°â€”
    {0x56, 0x7d, 0x36, 0x7f, 0x55, 0x55, 0x5d, 0x00},   // 55 1941 e7e8 Ã©â€°â€¦
    {0x56, 0x7d, 0x36, 0x4a, 0x6e, 0x53, 0x6a, 0x00},   // 55 1942 e7e9 Ã©â€°â€°
    {0x56, 0x7d, 0x36, 0x04, 0x1b, 0x5a, 0x7e, 0x00},   // 55 1943 e7ea Ã©â€°Â¤
    {0x56, 0x7d, 0x36, 0x06, 0x7a, 0x53, 0x56, 0x00},   // 55 1944 e7eb Ã©â€°Ë†
    {0x56, 0x7d, 0x36, 0x5e, 0x3f, 0x56, 0x72, 0x00},   // 55 1945 e7ec Ã©Å â€¢
    {0x56, 0x7d, 0x36, 0x7f, 0x49, 0x7f, 0x7f, 0x00},   // 55 1946 e7ed Ã©Ë†Â¿
    {0x56, 0x7d, 0x36, 0x04, 0x7b, 0x5a, 0x5e, 0x00},   // 55 1947 e7ee Ã©â€°â€¹
    {0x56, 0x7d, 0x36, 0x11, 0x7f, 0x49, 0x79, 0x00},   // 55 1948 e7ef Ã©â€°Â
    {0x0a, 0x7d, 0x56, 0x7d, 0x36, 0x45, 0x7d, 0x00},   // 55 1949 e7f0 Ã©Å Å“
    {0x56, 0x7d, 0x4e, 0x2b, 0x7f, 0x2a, 0x48, 0x00},   // 55 194a e7f1 Ã©Å â€“
    {0x56, 0x7d, 0x36, 0x45, 0x57, 0x7d, 0x56, 0x00},   // 55 194b e7f2 Ã©Å â€œ
    {0x56, 0x7d, 0x36, 0x04, 0x76, 0x5e, 0x75, 0x00},   // 55 194c e7f3 Ã©Å â€º
    {0x56, 0x7d, 0x5e, 0x3d, 0x00, 0x7f, 0x1f, 0x00},   // 55 194d e7f4 Ã©â€°Å¡
    {0x56, 0x7d, 0x56, 0x4e, 0x3f, 0x4e, 0x52, 0x00},   // 55 194e e7f5 Ã©â€¹Â
    {0x56, 0x7d, 0x5a, 0x37, 0x1f, 0x37, 0x6a, 0x00},   // 55 194f e7f6 Ã©Å Â¹
    {0x56, 0x7d, 0x36, 0x7d, 0x2a, 0x7d, 0x02, 0x00},   // 55 1950 e7f7 Ã©Å Â·
    {0x56, 0x7d, 0x36, 0x7b, 0x4e, 0x4b, 0x4a, 0x00},   // 55 1951 e7f8 Ã©â€¹Â©
    {0x56, 0x7d, 0x5f, 0x77, 0x41, 0x77, 0x5d, 0x00},   // 55 1952 e7f9 Ã©Å’Â
    {0x56, 0x7d, 0x56, 0x2a, 0x7b, 0x4a, 0x5e, 0x00},   // 55 1953 e7fa Ã©â€¹Âº
    {0x56, 0x7d, 0x26, 0x4e, 0x7b, 0x0e, 0x22, 0x00},   // 55 1954 e7fb Ã©Ââ€ž
    {0x56, 0x7d, 0x7f, 0x75, 0x6f, 0x75, 0x7f, 0x00},   // 55 1955 e7fc Ã©Å’Â®
    {0x56, 0x7d, 0x36, 0x7a, 0x5d, 0x7a, 0x7d, 0x00},   // 56 1956 e840 Ã©Å’â„¢
    {0x56, 0x7d, 0x36, 0x52, 0x5b, 0x36, 0x5b, 0x00},   // 56 1957 e841 Ã©Å’Â¢
    {0x56, 0x7d, 0x16, 0x55, 0x7f, 0x3d, 0x12, 0x00},   // 56 1958 e842 Ã©Å’Å¡
    {0x56, 0x7d, 0x5f, 0x2b, 0x5d, 0x2b, 0x5d, 0x00},   // 56 1959 e843 Ã©Å’Â£
    {0x56, 0x7d, 0x36, 0x4a, 0x3b, 0x2e, 0x6b, 0x00},   // 56 195a e844 Ã©Å’Âº
    {0x56, 0x7d, 0x36, 0x7b, 0x02, 0x7f, 0x52, 0x00},   // 56 195b e845 Ã©Å’Âµ
    {0x56, 0x7d, 0x36, 0x75, 0x65, 0x3e, 0x45, 0x00},   // 56 195c e846 Ã©Å’Â»
    {0x56, 0x7d, 0x7f, 0x2b, 0x58, 0x2d, 0x5f, 0x00},   // 56 195d e847 Ã©ÂÅ“
    {0x56, 0x7d, 0x56, 0x5e, 0x7b, 0x5e, 0x50, 0x00},   // 56 195e e848 Ã©ÂÂ 
    {0x56, 0x7d, 0x3e, 0x6a, 0x6a, 0x3f, 0x52, 0x00},   // 56 195f e849 Ã©ÂÂ¼
    {0x56, 0x7d, 0x37, 0x73, 0x75, 0x26, 0x54, 0x00},   // 56 1960 e84a Ã©ÂÂ®
    {0x56, 0x7d, 0x72, 0x5f, 0x72, 0x5f, 0x52, 0x00},   // 56 1961 e84b Ã©Ââ€“
    {0x56, 0x7d, 0x52, 0x6d, 0x64, 0x6d, 0x52, 0x00},   // 56 1962 e84c Ã©Å½Â°
    {0x56, 0x7d, 0x76, 0x1e, 0x5b, 0x1e, 0x72, 0x00},   // 56 1963 e84d Ã©Å½Â¬
    {0x56, 0x7d, 0x36, 0x58, 0x1f, 0x1e, 0x52, 0x00},   // 56 1964 e84e Ã©Å½Â­
    {0x56, 0x7d, 0x26, 0x16, 0x6b, 0x76, 0x26, 0x00},   // 56 1965 e84f Ã©Å½â€
    {0x56, 0x7d, 0x36, 0x75, 0x6a, 0x59, 0x6a, 0x00},   // 56 1966 e850 Ã©Å½Â¹
    {0x10, 0x4e, 0x6a, 0x5e, 0x7f, 0x5e, 0x6a, 0x00},   // 56 1967 e851 Ã©Ââ€“
    {0x56, 0x7d, 0x47, 0x57, 0x7b, 0x55, 0x4b, 0x00},   // 56 1968 e852 Ã©Ââ€”
    {0x5a, 0x7e, 0x5f, 0x7a, 0x57, 0x7d, 0x55, 0x00},   // 56 1969 e853 Ã©ÂÂ¨
    {0x56, 0x7d, 0x36, 0x76, 0x0b, 0x7a, 0x6e, 0x00},   // 56 196a e854 Ã©ÂÂ¥
    {0x56, 0x7d, 0x36, 0x7f, 0x2a, 0x4d, 0x7b, 0x00},   // 56 196b e855 Ã©ÂËœ
    {0x56, 0x7d, 0x62, 0x1f, 0x7a, 0x3f, 0x56, 0x00},   // 56 196c e856 Ã©ÂÆ’
    {0x56, 0x7d, 0x4e, 0x5f, 0x2d, 0x5f, 0x4c, 0x00},   // 56 196d e857 Ã©ÂÂ
    {0x56, 0x7d, 0x36, 0x11, 0x4b, 0x55, 0x2b, 0x00},   // 56 196e e858 Ã©ÂÂ
    {0x56, 0x7d, 0x36, 0x65, 0x52, 0x7f, 0x5e, 0x00},   // 56 196f e859 Ã©ÂË†
    {0x56, 0x7d, 0x56, 0x7e, 0x5b, 0x3e, 0x54, 0x00},   // 56 1970 e85a Ã©ÂÂ¤
    {0x56, 0x7d, 0x36, 0x6d, 0x2f, 0x4f, 0x6d, 0x00},   // 56 1971 e85b Ã©ÂÅ¡
    {0x56, 0x7d, 0x27, 0x3b, 0x6b, 0x3b, 0x21, 0x00},   // 56 1972 e85c Ã©Ââ€
    {0x56, 0x7d, 0x2e, 0x7b, 0x56, 0x3f, 0x5e, 0x00},   // 56 1973 e85d Ã©Ââ€œ
    {0x56, 0x7d, 0x5e, 0x3e, 0x17, 0x7e, 0x5c, 0x00},   // 56 1974 e85e Ã©ÂÆ’
    {0x56, 0x7d, 0x36, 0x15, 0x6f, 0x7f, 0x15, 0x00},   // 56 1975 e85f Ã©Ââ€¡
    {0x56, 0x7d, 0x4a, 0x1e, 0x6b, 0x1e, 0x4a, 0x00},   // 56 1976 e860 Ã©ÂÂ
    {0x56, 0x7d, 0x37, 0x7d, 0x57, 0x35, 0x5f, 0x00},   // 56 1977 e861 Ã©ÂÂ¶
    {0x56, 0x7d, 0x76, 0x1f, 0x2a, 0x1f, 0x7a, 0x00},   // 56 1978 e862 Ã©ÂÂ«
    {0x56, 0x7d, 0x5e, 0x77, 0x5e, 0x3f, 0x55, 0x00},   // 56 1979 e863 Ã©ÂÂµ
    {0x56, 0x7d, 0x5e, 0x6f, 0x5e, 0x3f, 0x55, 0x00},   // 56 197a e864 Ã©ÂÂ¡
    {0x56, 0x7d, 0x77, 0x5e, 0x7b, 0x5e, 0x75, 0x00},   // 56 197b e865 Ã©ÂÂº
    {0x56, 0x7d, 0x2f, 0x5d, 0x2a, 0x5d, 0x4f, 0x00},   // 56 197c e866 Ã©â€˜Â
    {0x57, 0x77, 0x5d, 0x78, 0x5f, 0x76, 0x56, 0x00},   // 56 197d e867 Ã©â€˜â€™
    {0x56, 0x7d, 0x36, 0x36, 0x5f, 0x76, 0x14, 0x00},   // 56 197e e868 Ã©â€˜â€ž
    {0x56, 0x7d, 0x3e, 0x4a, 0x3f, 0x3e, 0x4a, 0x00},   // 56 197f e869 Ã©â€˜â€º
    {0x56, 0x7d, 0x5a, 0x35, 0x7f, 0x3a, 0x55, 0x00},   // 56 1980 e86a Ã©â€˜Â 
    {0x56, 0x7d, 0x3e, 0x64, 0x3f, 0x5a, 0x6a, 0x00},   // 56 1981 e86b Ã©â€˜Â¢
    {0x56, 0x7d, 0x56, 0x3e, 0x75, 0x2e, 0x7d, 0x00},   // 56 1982 e86c Ã©â€˜Å¾
    {0x56, 0x7d, 0x3e, 0x44, 0x6f, 0x6a, 0x4a, 0x00},   // 56 1983 e86d Ã©â€˜Âª
    {0x56, 0x7d, 0x36, 0x41, 0x3d, 0x15, 0x1d, 0x00},   // 56 1984 e86e Ã©Ë†Â©
    {0x56, 0x7d, 0x76, 0x3e, 0x7d, 0x3e, 0x74, 0x00},   // 56 1985 e86f Ã©â€˜Â°
    {0x56, 0x7d, 0x26, 0x7f, 0x52, 0x7f, 0x56, 0x00},   // 56 1986 e870 Ã©â€˜Âµ
    {0x56, 0x7d, 0x36, 0x75, 0x27, 0x3f, 0x75, 0x00},   // 56 1987 e871 Ã©â€˜Â·
    {0x56, 0x7d, 0x4b, 0x36, 0x3b, 0x36, 0x4a, 0x00},   // 56 1988 e872 Ã©â€˜Â½
    {0x56, 0x7d, 0x4a, 0x37, 0x3a, 0x37, 0x4a, 0x00},   // 56 1989 e873 Ã©â€˜Å¡
    {0x56, 0x7d, 0x2f, 0x75, 0x27, 0x7d, 0x57, 0x00},   // 56 198a e874 Ã©â€˜Â¼
    {0x5a, 0x7d, 0x5a, 0x77, 0x57, 0x7a, 0x5d, 0x00},   // 56 198b e875 Ã©â€˜Â¾
    {0x56, 0x7d, 0x57, 0x5f, 0x2c, 0x5f, 0x4b, 0x00},   // 56 198c e876 Ã©â€™Â
    {0x55, 0x7e, 0x5f, 0x7e, 0x5b, 0x75, 0x5b, 0x00},   // 56 198d e877 Ã©â€˜Â¿
    {0x7f, 0x05, 0x17, 0x10, 0x17, 0x45, 0x7f, 0x00},   // 56 198e e878 Ã©â€“â€š
    {0x7f, 0x05, 0x0f, 0x78, 0x2f, 0x05, 0x7f, 0x00},   // 56 198f e879 Ã©â€“â€¡
    {0x7f, 0x35, 0x27, 0x38, 0x27, 0x35, 0x7f, 0x00},   // 56 1990 e87a Ã©â€“Å 
    {0x7f, 0x4b, 0x5b, 0x2c, 0x5b, 0x4b, 0x7f, 0x00},   // 56 1991 e87b Ã©â€“â€
    {0x7f, 0x55, 0x37, 0x78, 0x27, 0x55, 0x7f, 0x00},   // 56 1992 e87c Ã©â€“â€“
    {0x7f, 0x05, 0x37, 0x70, 0x37, 0x05, 0x7f, 0x00},   // 56 1993 e87d Ã©â€“Ëœ
    {0x7f, 0x0b, 0x3b, 0x7c, 0x1b, 0x3b, 0x7f, 0x00},   // 56 1994 e87e Ã©â€“â„¢
    {0x7f, 0x05, 0x57, 0x7c, 0x57, 0x25, 0x7f, 0x00},   // 57 1995 e880 Ã©â€“Â 
    {0x7f, 0x53, 0x7b, 0x7c, 0x7b, 0x53, 0x7f, 0x00},   // 57 1996 e881 Ã©â€“Â¨
    {0x7f, 0x6b, 0x3f, 0x28, 0x3f, 0x6b, 0x7f, 0x00},   // 57 1997 e882 Ã©â€“Â§
    {0x7f, 0x73, 0x5f, 0x54, 0x7f, 0x03, 0x7f, 0x00},   // 57 1998 e883 Ã©â€“Â­
    {0x7f, 0x4b, 0x3f, 0x68, 0x57, 0x2b, 0x7f, 0x00},   // 57 1999 e884 Ã©â€“Â¼
    {0x7f, 0x03, 0x6b, 0x54, 0x5f, 0x73, 0x7f, 0x00},   // 57 199a e885 Ã©â€“Â»
    {0x7f, 0x2b, 0x1b, 0x3c, 0x7b, 0x5b, 0x7f, 0x00},   // 57 199b e886 Ã©â€“Â¹
    {0x7f, 0x5b, 0x5b, 0x08, 0x3f, 0x4b, 0x7f, 0x00},   // 57 199c e887 Ã©â€“Â¾
    {0x7f, 0x57, 0x0b, 0x6c, 0x5f, 0x6b, 0x7f, 0x00},   // 57 199d e888 Ã©â€”Å 
    {0x75, 0x7f, 0x0b, 0x6c, 0x5f, 0x6b, 0x7f, 0x00},   // 57 199e e889 Ã¦Â¿Â¶
    {0x7f, 0x53, 0x5f, 0x34, 0x5f, 0x53, 0x7f, 0x00},   // 57 199f e88a Ã©â€”Æ’
    {0x7f, 0x53, 0x3b, 0x7c, 0x7b, 0x17, 0x7f, 0x00},   // 57 19a0 e88b Ã©â€”Â
    {0x7f, 0x4b, 0x3b, 0x7c, 0x3b, 0x4b, 0x7f, 0x00},   // 57 19a1 e88c Ã©â€”Å’
    {0x7f, 0x57, 0x3b, 0x4c, 0x3b, 0x5b, 0x7f, 0x00},   // 57 19a2 e88d Ã©â€”â€¢
    {0x7f, 0x03, 0x5b, 0x7c, 0x6f, 0x5b, 0x7f, 0x00},   // 57 19a3 e88e Ã©â€”â€
    {0x7f, 0x43, 0x1f, 0x5c, 0x17, 0x73, 0x7f, 0x00},   // 57 19a4 e88f Ã©â€”â€“
    {0x7f, 0x5b, 0x37, 0x10, 0x7b, 0x37, 0x7f, 0x00},   // 57 19a5 e890 Ã©â€”Å“
    {0x7f, 0x27, 0x3f, 0x78, 0x3f, 0x27, 0x7f, 0x00},   // 57 19a6 e891 Ã©â€”Â¡
    {0x7f, 0x57, 0x33, 0x58, 0x7f, 0x5b, 0x7f, 0x00},   // 57 19a7 e892 Ã©â€”Â¥
    {0x7f, 0x7f, 0x6f, 0x38, 0x6f, 0x3b, 0x7f, 0x00},   // 57 19a8 e893 Ã©â€”Â¢
    {0x7f, 0x1b, 0x08, 0x0a, 0x7e, 0x09, 0x08, 0x00},   // 57 19a9 e894 Ã©ËœÂ¡
    {0x7f, 0x1b, 0x40, 0x3f, 0x7d, 0x45, 0x5d, 0x00},   // 57 19aa e895 Ã©ËœÂ¨
    {0x7f, 0x1b, 0x44, 0x3d, 0x05, 0x7d, 0x44, 0x00},   // 57 19ab e896 Ã©ËœÂ®
    {0x7f, 0x25, 0x5b, 0x7c, 0x40, 0x7f, 0x44, 0x00},   // 57 19ac e897 Ã©ËœÂ¯
    {0x7f, 0x1b, 0x40, 0x3e, 0x5a, 0x2f, 0x5e, 0x00},   // 57 19ad e898 Ã©â„¢â€š
    {0x7f, 0x25, 0x1b, 0x7d, 0x57, 0x55, 0x7d, 0x00},   // 57 19ae e899 Ã©â„¢Å’
    {0x7f, 0x25, 0x1b, 0x12, 0x7f, 0x2a, 0x7a, 0x00},   // 57 19af e89a Ã©â„¢Â
    {0x7f, 0x25, 0x1b, 0x7c, 0x55, 0x4f, 0x5d, 0x00},   // 57 19b0 e89b Ã©â„¢â€¹
    {0x7f, 0x25, 0x1b, 0x7a, 0x41, 0x6d, 0x7b, 0x00},   // 57 19b1 e89c Ã©â„¢Â·
    {0x7f, 0x1b, 0x52, 0x4e, 0x3f, 0x4e, 0x52, 0x00},   // 57 19b2 e89d Ã©â„¢Å“
    {0x7f, 0x1b, 0x56, 0x4e, 0x65, 0x5f, 0x44, 0x00},   // 57 19b3 e89e Ã©â„¢Å¾
    {0x7f, 0x1b, 0x52, 0x4e, 0x3f, 0x4e, 0x52, 0x00},   // 57 19b4 e89f Ã©â„¢Â
    {0x7f, 0x25, 0x1b, 0x4e, 0x58, 0x2f, 0x1a, 0x00},   // 57 19b5 e8a0 Ã©â„¢Å¸
    {0x7f, 0x1b, 0x34, 0x5e, 0x17, 0x7e, 0x14, 0x00},   // 57 19b6 e8a1 Ã©â„¢Â¦
    {0x7f, 0x1b, 0x54, 0x5d, 0x77, 0x5d, 0x54, 0x00},   // 57 19b7 e8a2 Ã©â„¢Â²
    {0x7f, 0x1b, 0x21, 0x3f, 0x7f, 0x12, 0x2e, 0x00},   // 57 19b8 e8a3 Ã©â„¢Â¬
    {0x7f, 0x1b, 0x50, 0x5e, 0x7b, 0x5e, 0x50, 0x00},   // 57 19b9 e8a4 Ã©Å¡Â
    {0x7f, 0x1b, 0x52, 0x6d, 0x64, 0x6d, 0x52, 0x00},   // 57 19ba e8a5 Ã©Å¡Ëœ
    {0x7f, 0x25, 0x1b, 0x5c, 0x17, 0x17, 0x5c, 0x00},   // 57 19bb e8a6 Ã©Å¡â€¢
    {0x7f, 0x1b, 0x5e, 0x2a, 0x7f, 0x6a, 0x5e, 0x00},   // 57 19bc e8a7 Ã©Å¡â€”
    {0x7f, 0x1b, 0x5c, 0x36, 0x5d, 0x36, 0x5c, 0x00},   // 57 19bd e8a8 Ã©Å¡Âª
    {0x7f, 0x1b, 0x75, 0x52, 0x6d, 0x7d, 0x56, 0x00},   // 57 19be e8a9 Ã©Å¡Â§
    {0x7f, 0x1b, 0x62, 0x35, 0x5f, 0x5d, 0x6a, 0x00},   // 57 19bf e8aa Ã©Å¡Â±
    {0x7f, 0x25, 0x1b, 0x45, 0x1c, 0x5b, 0x69, 0x00},   // 57 19c0 e8ab Ã©Å¡Â²
    {0x7f, 0x1b, 0x58, 0x17, 0x43, 0x1b, 0x54, 0x00},   // 57 19c1 e8ac Ã©Å¡Â°
    {0x7f, 0x1b, 0x7e, 0x2b, 0x7e, 0x77, 0x5d, 0x00},   // 57 19c2 e8ad Ã©Å¡Â´
    {0x48, 0x5a, 0x2a, 0x7f, 0x2a, 0x5e, 0x44, 0x00},   // 57 19c3 e8ae Ã©Å¡Â¶
    {0x4a, 0x16, 0x7f, 0x2a, 0x7f, 0x2e, 0x54, 0x00},   // 57 19c4 e8af Ã©Å¡Â¸
    {0x08, 0x04, 0x7f, 0x4a, 0x7f, 0x4a, 0x42, 0x00},   // 57 19c5 e8b0 Ã©Å¡Â¹
    {0x40, 0x7f, 0x55, 0x3f, 0x7f, 0x7e, 0x4b, 0x00},   // 57 19c6 e8b1 Ã©â€ºÅ½
    {0x74, 0x12, 0x3f, 0x2a, 0x3f, 0x5a, 0x7a, 0x00},   // 57 19c7 e8b2 Ã©â€ºâ€¹
    {0x44, 0x2b, 0x1e, 0x2a, 0x7f, 0x7e, 0x4b, 0x00},   // 57 19c8 e8b3 Ã©â€ºâ€°
    {0x5a, 0x36, 0x12, 0x7f, 0x4a, 0x7e, 0x4a, 0x00},   // 57 19c9 e8b4 Ã©â€ºÂ
    {0x12, 0x7b, 0x56, 0x3f, 0x7a, 0x3f, 0x5a, 0x00},   // 57 19ca e8b5 Ã¨Â¥Â
    {0x5a, 0x36, 0x7b, 0x36, 0x7f, 0x7e, 0x4b, 0x00},   // 57 19cb e8b6 Ã©â€ºÅ“
    {0x26, 0x12, 0x7f, 0x57, 0x7b, 0x56, 0x56, 0x00},   // 57 19cc e8b7 Ã©Å“Â
    {0x7f, 0x35, 0x2f, 0x35, 0x7f, 0x7e, 0x4b, 0x00},   // 57 19cd e8b8 Ã©â€ºâ€¢
    {0x16, 0x12, 0x6f, 0x6f, 0x6b, 0x4e, 0x5e, 0x00},   // 57 19ce e8b9 Ã©â€ºÂ¹
    {0x16, 0x0a, 0x7f, 0x2f, 0x7b, 0x0e, 0x16, 0x00},   // 57 19cf e8ba Ã©Å“â€ž
    {0x56, 0x2a, 0x47, 0x57, 0x5b, 0x7e, 0x56, 0x00},   // 57 19d0 e8bb Ã©Å“â€ 
    {0x56, 0x0a, 0x6f, 0x2f, 0x7b, 0x2e, 0x6e, 0x00},   // 57 19d1 e8bc Ã©Å“Ë†
    {0x46, 0x5a, 0x37, 0x17, 0x7b, 0x5e, 0x46, 0x00},   // 57 19d2 e8bd Ã©Å“â€œ
    {0x56, 0x52, 0x7f, 0x57, 0x3b, 0x56, 0x56, 0x00},   // 57 19d3 e8be Ã©Å“Å½
    {0x56, 0x02, 0x67, 0x67, 0x7b, 0x76, 0x16, 0x00},   // 57 19d4 e8bf Ã©Å“â€˜
    {0x36, 0x72, 0x3f, 0x07, 0x7b, 0x36, 0x36, 0x00},   // 57 19d5 e8c0 Ã©Å“Â
    {0x56, 0x32, 0x7f, 0x57, 0x33, 0x7e, 0x56, 0x00},   // 57 19d6 e8c1 Ã©Å“â€“
    {0x56, 0x5a, 0x5f, 0x3f, 0x5b, 0x5e, 0x56, 0x00},   // 57 19d7 e8c2 Ã©Å“â„¢
    {0x06, 0x1a, 0x77, 0x73, 0x6f, 0x1e, 0x06, 0x00},   // 57 19d8 e8c3 Ã©Å“Â¤
    {0x56, 0x02, 0x5f, 0x5f, 0x7b, 0x56, 0x56, 0x00},   // 57 19d9 e8c4 Ã©Å“Âª
    {0x16, 0x7a, 0x37, 0x7f, 0x53, 0x2e, 0x5e, 0x00},   // 57 19da e8c5 Ã©Å“Â°
    {0x26, 0x7a, 0x7f, 0x2f, 0x3b, 0x6e, 0x3e, 0x00},   // 57 19db e8c6 Ã©Å“Â¹
    {0x2e, 0x5a, 0x3f, 0x2f, 0x7b, 0x1e, 0x2e, 0x00},   // 57 19dc e8c7 Ã©Å“Â½
    {0x56, 0x6a, 0x37, 0x07, 0x5b, 0x7e, 0x5e, 0x00},   // 57 19dd e8c8 Ã©Å“Â¾
    {0x6e, 0x6a, 0x07, 0x67, 0x5b, 0x1e, 0x76, 0x00},   // 57 19de e8c9 Ã©Ââ€ž
    {0x56, 0x73, 0x57, 0x65, 0x52, 0x7f, 0x56, 0x00},   // 57 19df e8ca Ã©Ââ€ 
    {0x5e, 0x7a, 0x5f, 0x7f, 0x5b, 0x7e, 0x5e, 0x00},   // 57 19e0 e8cb Ã©ÂË†
    {0x46, 0x3a, 0x5f, 0x7f, 0x6b, 0x5e, 0x5e, 0x00},   // 57 19e1 e8cc Ã©Ââ€š
    {0x56, 0x73, 0x57, 0x2f, 0x55, 0x37, 0x4d, 0x00},   // 57 19e2 e8cd Ã©Ââ€°
    {0x7a, 0x3f, 0x7a, 0x29, 0x7b, 0x39, 0x12, 0x00},   // 57 19e3 e8ce Ã©ÂÅ“
    {0x24, 0x7f, 0x36, 0x17, 0x76, 0x3e, 0x24, 0x00},   // 57 19e4 e8cf Ã©ÂÂ 
    {0x7d, 0x7d, 0x57, 0x7d, 0x04, 0x7b, 0x5e, 0x00},   // 57 19e5 e8d0 Ã©ÂÂ¤
    {0x7d, 0x7d, 0x57, 0x7d, 0x5f, 0x35, 0x5f, 0x00},   // 57 19e6 e8d1 Ã©ÂÂ¦
    {0x18, 0x77, 0x7f, 0x5d, 0x7b, 0x77, 0x1b, 0x00},   // 57 19e7 e8d2 Ã©ÂÂ¨
    {0x37, 0x7e, 0x37, 0x42, 0x3f, 0x42, 0x7e, 0x00},   // 57 19e8 e8d3 Ã¥â€¹â€™
    {0x37, 0x7e, 0x57, 0x29, 0x13, 0x29, 0x47, 0x00},   // 57 19e9 e8d4 Ã©ÂÂ«
    {0x37, 0x7e, 0x37, 0x45, 0x3f, 0x51, 0x7f, 0x00},   // 57 19ea e8d5 Ã©ÂÂ±
    {0x37, 0x7e, 0x37, 0x7c, 0x15, 0x4f, 0x7c, 0x00},   // 57 19eb e8d6 Ã©ÂÂ¹
    {0x37, 0x7e, 0x37, 0x4e, 0x3b, 0x4e, 0x48, 0x00},   // 57 19ec e8d7 Ã©Å¾â€¦
    {0x37, 0x7e, 0x37, 0x40, 0x5f, 0x55, 0x5f, 0x00},   // 57 19ed e8d8 Ã©ÂÂ¼
    {0x37, 0x7e, 0x37, 0x3e, 0x5a, 0x2f, 0x5e, 0x00},   // 57 19ee e8d9 Ã©Å¾Â
    {0x37, 0x7e, 0x37, 0x2a, 0x7f, 0x2a, 0x42, 0x00},   // 57 19ef e8da Ã©ÂÂº
    {0x37, 0x7e, 0x37, 0x7d, 0x15, 0x4f, 0x7d, 0x00},   // 57 19f0 e8db Ã©Å¾â€ 
    {0x37, 0x7e, 0x37, 0x48, 0x5a, 0x7f, 0x5a, 0x00},   // 57 19f1 e8dc Ã©Å¾â€¹
    {0x25, 0x2f, 0x3d, 0x7c, 0x3b, 0x2f, 0x24, 0x00},   // 57 19f2 e8dd Ã©Å¾Â
    {0x37, 0x7e, 0x37, 0x08, 0x7f, 0x1a, 0x2a, 0x00},   // 57 19f3 e8de Ã©Å¾Â
    {0x37, 0x7e, 0x3b, 0x76, 0x5f, 0x74, 0x0a, 0x00},   // 57 19f4 e8df Ã©Å¾Å“
    {0x37, 0x7e, 0x37, 0x3f, 0x2d, 0x4f, 0x78, 0x00},   // 57 19f5 e8e0 Ã©Å¾Â¨
    {0x37, 0x7e, 0x37, 0x7f, 0x4c, 0x3f, 0x44, 0x00},   // 57 19f6 e8e1 Ã©Å¾Â¦
    {0x37, 0x7e, 0x5b, 0x37, 0x7f, 0x33, 0x56, 0x00},   // 57 19f7 e8e2 Ã©Å¾Â£
    {0x37, 0x7e, 0x37, 0x12, 0x7b, 0x56, 0x7b, 0x00},   // 57 19f8 e8e3 Ã©Å¾Â³
    {0x37, 0x7e, 0x37, 0x7a, 0x0f, 0x6a, 0x6f, 0x00},   // 57 19f9 e8e4 Ã©Å¾Â´
    {0x37, 0x7e, 0x37, 0x75, 0x5e, 0x77, 0x5e, 0x00},   // 57 19fa e8e5 Ã©Å¸Æ’
    {0x37, 0x7e, 0x77, 0x49, 0x77, 0x6f, 0x49, 0x00},   // 57 19fb e8e6 Ã©Å¸â€ 
    {0x37, 0x7e, 0x37, 0x7a, 0x4f, 0x3e, 0x5b, 0x00},   // 57 19fc e8e7 Ã©Å¸Ë†
    {0x28, 0x3a, 0x2e, 0x2b, 0x7a, 0x2e, 0x28, 0x00},   // 57 19fd e8e8 Ã©Å¸â€¹
    {0x2a, 0x77, 0x2e, 0x79, 0x43, 0x69, 0x7a, 0x00},   // 57 19fe e8e9 Ã©Å¸Å“
    {0x54, 0x54, 0x7f, 0x40, 0x7f, 0x54, 0x54, 0x00},   // 57 19ff e8ea Ã©Å¸Â­
    {0x4a, 0x36, 0x5e, 0x7b, 0x5e, 0x76, 0x0a, 0x00},   // 57 1a00 e8eb Ã©Â½Â
    {0x4a, 0x56, 0x7e, 0x4b, 0x7e, 0x56, 0x4a, 0x00},   // 57 1a01 e8ec Ã©Å¸Â²
    {0x48, 0x4a, 0x3e, 0x3b, 0x7e, 0x4a, 0x68, 0x00},   // 57 1a02 e8ed Ã§Â«Å¸
    {0x0a, 0x6e, 0x6b, 0x0e, 0x75, 0x53, 0x77, 0x00},   // 57 1a03 e8ee Ã©Å¸Â¶
    {0x0a, 0x6e, 0x6b, 0x0e, 0x2b, 0x52, 0x7e, 0x00},   // 57 1a04 e8ef Ã©Å¸Âµ
    {0x42, 0x3a, 0x0b, 0x7a, 0x5d, 0x17, 0x5d, 0x00},   // 57 1a05 e8f0 Ã©Â Â
    {0x44, 0x63, 0x58, 0x23, 0x5d, 0x17, 0x5d, 0x00},   // 57 1a06 e8f1 Ã©Â Å’
    {0x55, 0x5b, 0x75, 0x5b, 0x5d, 0x17, 0x5d, 0x00},   // 57 1a07 e8f2 Ã©Â Â¸
    {0x7f, 0x5d, 0x77, 0x5d, 0x41, 0x1f, 0x5d, 0x00},   // 57 1a08 e8f3 Ã©Â Â¤
    {0x02, 0x6a, 0x6f, 0x6a, 0x5d, 0x17, 0x5d, 0x00},   // 57 1a09 e8f4 Ã©Â Â¡
    {0x04, 0x76, 0x5d, 0x72, 0x5d, 0x17, 0x5d, 0x00},   // 57 1a0a e8f5 Ã©Â Â·
    {0x4a, 0x37, 0x1f, 0x76, 0x5d, 0x17, 0x5d, 0x00},   // 57 1a0b e8f6 Ã©Â Â½
    {0x57, 0x35, 0x7f, 0x37, 0x5d, 0x17, 0x5d, 0x00},   // 57 1a0c e8f7 Ã©Â¡â€ 
    {0x7a, 0x0e, 0x5f, 0x2a, 0x5d, 0x17, 0x5d, 0x00},   // 57 1a0d e8f8 Ã©Â¡Â
    {0x6f, 0x2d, 0x4f, 0x6f, 0x5d, 0x17, 0x5d, 0x00},   // 57 1a0e e8f9 Ã©Â¡â€¹
    {0x4e, 0x7e, 0x7b, 0x2e, 0x5d, 0x17, 0x5d, 0x00},   // 57 1a0f e8fa Ã©Â¡Â«
    {0x6b, 0x37, 0x6b, 0x37, 0x5d, 0x17, 0x5d, 0x00},   // 57 1a10 e8fb Ã©Â¡Â¯
    {0x26, 0x2c, 0x3f, 0x76, 0x39, 0x23, 0x2b, 0x00},   // 57 1a11 e8fc Ã©Â¡Â°
    {0x7c, 0x44, 0x6f, 0x6a, 0x5d, 0x17, 0x5d, 0x00},   // 58 1a12 e940 Ã©Â¡Â±
    {0x26, 0x7f, 0x52, 0x7f, 0x5d, 0x17, 0x5d, 0x00},   // 58 1a13 e941 Ã©Â¡Â´
    {0x35, 0x77, 0x3f, 0x75, 0x5d, 0x17, 0x5d, 0x00},   // 58 1a14 e942 Ã©Â¡Â³
    {0x41, 0x3d, 0x55, 0x77, 0x6f, 0x3d, 0x41, 0x00},   // 58 1a15 e943 Ã©Â¢Âª
    {0x2e, 0x33, 0x7f, 0x4d, 0x7f, 0x2d, 0x7f, 0x00},   // 58 1a16 e944 Ã©Â¢Â¯
    {0x7f, 0x4d, 0x3f, 0x7f, 0x46, 0x5d, 0x5c, 0x00},   // 58 1a17 e945 Ã©Â¢Â±
    {0x7f, 0x4d, 0x3f, 0x7f, 0x54, 0x47, 0x57, 0x00},   // 58 1a18 e946 Ã©Â¢Â¶
    {0x51, 0x17, 0x77, 0x3f, 0x4d, 0x3f, 0x7f, 0x00},   // 58 1a19 e947 Ã©Â£â€ž
    {0x7f, 0x4d, 0x3f, 0x7f, 0x51, 0x77, 0x57, 0x00},   // 58 1a1a e948 Ã©Â£Æ’
    {0x5a, 0x37, 0x7a, 0x3f, 0x4d, 0x3f, 0x7f, 0x00},   // 58 1a1b e949 Ã©Â£â€ 
    {0x7e, 0x2d, 0x2e, 0x12, 0x7f, 0x52, 0x5a, 0x00},   // 58 1a1c e94a Ã©Â£Â©
    {0x7e, 0x2d, 0x4a, 0x4a, 0x3e, 0x49, 0x48, 0x00},   // 58 1a1d e94b Ã©Â£Â«
    {0x7e, 0x2d, 0x4a, 0x56, 0x23, 0x56, 0x4a, 0x00},   // 58 1a1e e94c Ã©Â¤Æ’
    {0x7e, 0x2d, 0x2e, 0x7e, 0x3b, 0x2a, 0x7e, 0x00},   // 58 1a1f e94d Ã©Â¤â€°
    {0x7e, 0x2d, 0x52, 0x71, 0x5b, 0x31, 0x52, 0x00},   // 58 1a20 e94e Ã©Â¤â€™
    {0x7e, 0x2d, 0x2e, 0x7a, 0x7f, 0x2a, 0x7b, 0x00},   // 58 1a21 e94f Ã©Â¤â€
    {0x7e, 0x2d, 0x2e, 0x54, 0x16, 0x7d, 0x56, 0x00},   // 58 1a22 e950 Ã©Â¤Ëœ
    {0x7e, 0x2d, 0x2e, 0x7a, 0x41, 0x6d, 0x7b, 0x00},   // 58 1a23 e951 Ã©Â¤Â¡
    {0x7e, 0x2d, 0x4a, 0x3b, 0x2e, 0x6b, 0x0a, 0x00},   // 58 1a24 e952 Ã©Â¤Â
    {0x7e, 0x2d, 0x2e, 0x52, 0x5b, 0x36, 0x5b, 0x00},   // 58 1a25 e953 Ã©Â¤Å¾
    {0x7e, 0x2d, 0x2e, 0x55, 0x44, 0x3b, 0x55, 0x00},   // 58 1a26 e954 Ã©Â¤Â¤
    {0x7e, 0x2d, 0x56, 0x3d, 0x16, 0x7d, 0x14, 0x00},   // 58 1a27 e955 Ã©Â¤Â 
    {0x7e, 0x2d, 0x3a, 0x2f, 0x7a, 0x3f, 0x7f, 0x00},   // 58 1a28 e956 Ã©Â¤Â¬
    {0x15, 0x57, 0x7b, 0x5d, 0x2a, 0x55, 0x52, 0x00},   // 58 1a29 e957 Ã©Â¤Â®
    {0x7e, 0x2d, 0x5e, 0x2a, 0x7f, 0x6a, 0x5e, 0x00},   // 58 1a2a e958 Ã©Â¤Â½
    {0x7e, 0x2d, 0x0e, 0x7a, 0x79, 0x77, 0x0f, 0x00},   // 58 1a2b e959 Ã©Â¤Â¾
    {0x7e, 0x2d, 0x2e, 0x4f, 0x6d, 0x6b, 0x4f, 0x00},   // 58 1a2c e95a Ã©Â¥â€š
    {0x7e, 0x2d, 0x5a, 0x5f, 0x7a, 0x5f, 0x5a, 0x00},   // 58 1a2d e95b Ã©Â¥â€°
    {0x7e, 0x2d, 0x4e, 0x5f, 0x2d, 0x5f, 0x4c, 0x00},   // 58 1a2e e95c Ã©Â¥â€¦
    {0x7e, 0x2d, 0x2e, 0x5a, 0x6a, 0x6f, 0x5a, 0x00},   // 58 1a2f e95d Ã©Â¥Â
    {0x7e, 0x2d, 0x4e, 0x3a, 0x3f, 0x3a, 0x4e, 0x00},   // 58 1a30 e95e Ã©Â¥â€¹
    {0x7e, 0x2d, 0x4a, 0x3d, 0x48, 0x3a, 0x55, 0x00},   // 58 1a31 e95f Ã©Â¥â€˜
    {0x7e, 0x2d, 0x5e, 0x3e, 0x17, 0x7e, 0x5c, 0x00},   // 58 1a32 e960 Ã©Â¥â€™
    {0x7e, 0x2d, 0x4f, 0x1b, 0x10, 0x1f, 0x4b, 0x00},   // 58 1a33 e961 Ã©Â¥Å’
    {0x14, 0x57, 0x7f, 0x58, 0x2e, 0x5f, 0x55, 0x00},   // 58 1a34 e962 Ã©Â¥â€¢
    {0x42, 0x3f, 0x7e, 0x42, 0x7b, 0x56, 0x7b, 0x00},   // 58 1a35 e963 Ã©Â¦â€”
    {0x7b, 0x56, 0x7b, 0x5a, 0x42, 0x3f, 0x52, 0x00},   // 58 1a36 e964 Ã©Â¦Ëœ
    {0x14, 0x6d, 0x7f, 0x6d, 0x57, 0x2e, 0x5a, 0x00},   // 58 1a37 e965 Ã©Â¦Â¥
    {0x5f, 0x1f, 0x75, 0x40, 0x4d, 0x31, 0x4f, 0x00},   // 58 1a38 e966 Ã©Â¦Â­
    {0x71, 0x00, 0x5f, 0x15, 0x5f, 0x15, 0x71, 0x00},   // 58 1a39 e967 Ã©Â¦Â®
    {0x5f, 0x1f, 0x75, 0x42, 0x4e, 0x33, 0x4e, 0x00},   // 58 1a3a e968 Ã©Â¦Â¼
    {0x5f, 0x1f, 0x75, 0x7f, 0x51, 0x4f, 0x7f, 0x00},   // 58 1a3b e969 Ã©Â§Å¸
    {0x5f, 0x1f, 0x75, 0x4e, 0x5a, 0x3f, 0x4e, 0x00},   // 58 1a3c e96a Ã©Â§â€º
    {0x5f, 0x1f, 0x75, 0x06, 0x7a, 0x53, 0x56, 0x00},   // 58 1a3d e96b Ã©Â§Â
    {0x5f, 0x1f, 0x75, 0x08, 0x6c, 0x6b, 0x6c, 0x00},   // 58 1a3e e96c Ã©Â§Ëœ
    {0x52, 0x0e, 0x5b, 0x16, 0x5b, 0x15, 0x7b, 0x00},   // 58 1a3f e96d Ã©Â§â€˜
    {0x5f, 0x1f, 0x75, 0x4a, 0x56, 0x2b, 0x52, 0x00},   // 58 1a40 e96e Ã©Â§Â­
    {0x5f, 0x1f, 0x75, 0x4a, 0x56, 0x23, 0x56, 0x00},   // 58 1a41 e96f Ã©Â§Â®
    {0x5f, 0x1f, 0x75, 0x0a, 0x65, 0x6b, 0x10, 0x00},   // 58 1a42 e970 Ã©Â§Â±
    {0x5f, 0x1f, 0x75, 0x4c, 0x3f, 0x0c, 0x7f, 0x00},   // 58 1a43 e971 Ã©Â§Â²
    {0x5f, 0x1f, 0x75, 0x28, 0x2f, 0x7d, 0x2f, 0x00},   // 58 1a44 e972 Ã©Â§Â»
    {0x5f, 0x1f, 0x75, 0x58, 0x5d, 0x2f, 0x5a, 0x00},   // 58 1a45 e973 Ã©Â§Â¸
    {0x5f, 0x1f, 0x75, 0x08, 0x3e, 0x2f, 0x6e, 0x00},   // 58 1a46 e974 Ã©Â¨Â
    {0x5f, 0x1f, 0x75, 0x52, 0x1f, 0x1a, 0x5f, 0x00},   // 58 1a47 e975 Ã©Â¨Â
    {0x5f, 0x1f, 0x75, 0x7f, 0x4a, 0x7f, 0x4a, 0x00},   // 58 1a48 e976 Ã©Â¨â€¦
    {0x5f, 0x1f, 0x75, 0x54, 0x3d, 0x14, 0x7d, 0x00},   // 58 1a49 e977 Ã©Â§Â¢
    {0x5f, 0x1f, 0x75, 0x21, 0x7f, 0x35, 0x77, 0x00},   // 58 1a4a e978 Ã©Â¨â„¢
    {0x56, 0x0a, 0x5e, 0x1b, 0x5e, 0x1a, 0x76, 0x00},   // 58 1a4b e979 Ã©Â¨Â«
    {0x5f, 0x1f, 0x75, 0x48, 0x7b, 0x75, 0x5b, 0x00},   // 58 1a4c e97a Ã©Â¨Â·
    {0x5f, 0x1f, 0x75, 0x7f, 0x47, 0x77, 0x71, 0x00},   // 58 1a4d e97b Ã©Â©â€¦
    {0x5f, 0x1f, 0x7b, 0x4f, 0x5a, 0x2d, 0x1a, 0x00},   // 58 1a4e e97c Ã©Â©â€š
    {0x4a, 0x06, 0x5f, 0x16, 0x5f, 0x16, 0x7a, 0x00},   // 58 1a4f e97d Ã©Â©â‚¬
    {0x5f, 0x1f, 0x75, 0x17, 0x77, 0x17, 0x51, 0x00},   // 58 1a50 e97e Ã©Â©Æ’
    {0x5f, 0x1f, 0x77, 0x1d, 0x77, 0x15, 0x57, 0x00},   // 59 1a51 e980 Ã©Â¨Â¾
    {0x5f, 0x1f, 0x7a, 0x17, 0x5b, 0x17, 0x7a, 0x00},   // 59 1a52 e981 Ã©Â©â€¢
    {0x5f, 0x1f, 0x7d, 0x5e, 0x37, 0x7e, 0x5c, 0x00},   // 59 1a53 e982 Ã©Â©Â
    {0x5f, 0x1f, 0x75, 0x2b, 0x3b, 0x6f, 0x3b, 0x00},   // 59 1a54 e983 Ã©Â©â€º
    {0x5f, 0x1f, 0x7d, 0x36, 0x5d, 0x36, 0x5c, 0x00},   // 59 1a55 e984 Ã©Â©â€”
    {0x5f, 0x1f, 0x75, 0x2b, 0x7f, 0x25, 0x4b, 0x00},   // 59 1a56 e985 Ã©Â©Å¸
    {0x5f, 0x1f, 0x7d, 0x44, 0x6f, 0x6a, 0x4a, 0x00},   // 59 1a57 e986 Ã©Â©Â¢
    {0x5f, 0x1f, 0x75, 0x5a, 0x3f, 0x3f, 0x5a, 0x00},   // 59 1a58 e987 Ã©Â©Â¥
    {0x5f, 0x1f, 0x77, 0x7e, 0x5b, 0x3e, 0x56, 0x00},   // 59 1a59 e988 Ã©Â©Â¤
    {0x5f, 0x1f, 0x77, 0x7f, 0x52, 0x7f, 0x56, 0x00},   // 59 1a5a e989 Ã©Â©Â©
    {0x48, 0x77, 0x3d, 0x77, 0x7d, 0x35, 0x6c, 0x00},   // 59 1a5b e98a Ã©Â©Â«
    {0x5f, 0x1f, 0x7f, 0x55, 0x1e, 0x7d, 0x57, 0x00},   // 59 1a5c e98b Ã©Â©Âª
    {0x0c, 0x77, 0x35, 0x7f, 0x09, 0x7f, 0x09, 0x00},   // 59 1a5d e98c Ã©ÂªÂ­
    {0x0c, 0x77, 0x35, 0x7f, 0x5b, 0x29, 0x5b, 0x00},   // 59 1a5e e98d Ã©ÂªÂ°
    {0x0c, 0x77, 0x35, 0x7f, 0x0a, 0x65, 0x6b, 0x00},   // 59 1a5f e98e Ã©ÂªÂ¼
    {0x0c, 0x77, 0x7f, 0x2e, 0x3f, 0x7a, 0x2e, 0x00},   // 59 1a60 e98f Ã©Â«â‚¬
    {0x0c, 0x77, 0x7f, 0x7e, 0x5b, 0x3e, 0x54, 0x00},   // 59 1a61 e990 Ã©Â«Â
    {0x0c, 0x77, 0x7f, 0x4b, 0x75, 0x37, 0x7f, 0x00},   // 59 1a62 e991 Ã©Â«â€˜
    {0x0c, 0x77, 0x7f, 0x65, 0x4a, 0x7f, 0x7a, 0x00},   // 59 1a63 e992 Ã©Â«â€œ
    {0x0c, 0x77, 0x7f, 0x5e, 0x77, 0x76, 0x5f, 0x00},   // 59 1a64 e993 Ã©Â«â€
    {0x72, 0x3f, 0x7e, 0x37, 0x7d, 0x37, 0x5c, 0x00},   // 59 1a65 e994 Ã©Â«Å¾
    {0x50, 0x7f, 0x55, 0x35, 0x50, 0x4a, 0x25, 0x00},   // 59 1a66 e995 Ã©Â«Å¸
    {0x24, 0x2f, 0x7d, 0x5d, 0x70, 0x7a, 0x55, 0x00},   // 59 1a67 e996 Ã©Â«Â¢
    {0x14, 0x5f, 0x5d, 0x3d, 0x30, 0x7a, 0x15, 0x00},   // 59 1a68 e997 Ã©Â«Â£
    {0x24, 0x2f, 0x3d, 0x7d, 0x50, 0x5a, 0x55, 0x00},   // 59 1a69 e998 Ã©Â«Â¦
    {0x24, 0x7f, 0x2d, 0x3d, 0x28, 0x7a, 0x25, 0x00},   // 59 1a6a e999 Ã©Â«Â¯
    {0x24, 0x2f, 0x1d, 0x6d, 0x68, 0x6a, 0x1d, 0x00},   // 59 1a6b e99a Ã©Â«Â«
    {0x44, 0x4f, 0x2d, 0x5d, 0x28, 0x5a, 0x4d, 0x00},   // 59 1a6c e99b Ã©Â«Â®
    {0x44, 0x5f, 0x3d, 0x2d, 0x7c, 0x2a, 0x65, 0x00},   // 59 1a6d e99c Ã©Â«Â´
    {0x14, 0x17, 0x6d, 0x6d, 0x68, 0x4a, 0x5d, 0x00},   // 59 1a6e e99d Ã©Â«Â±
    {0x74, 0x57, 0x7d, 0x55, 0x70, 0x5a, 0x75, 0x00},   // 59 1a6f e99e Ã©Â«Â·
    {0x04, 0x6f, 0x6d, 0x7d, 0x68, 0x6a, 0x05, 0x00},   // 59 1a70 e99f Ã©Â«Â»
    {0x54, 0x3f, 0x7d, 0x3d, 0x68, 0x52, 0x69, 0x00},   // 59 1a71 e9a0 Ã©Â¬â€ 
    {0x44, 0x5f, 0x5d, 0x2d, 0x5c, 0x5a, 0x45, 0x00},   // 59 1a72 e9a1 Ã©Â¬Ëœ
    {0x54, 0x2f, 0x05, 0x4d, 0x38, 0x3a, 0x4d, 0x00},   // 59 1a73 e9a2 Ã©Â¬Å¡
    {0x54, 0x37, 0x7d, 0x5d, 0x38, 0x5a, 0x55, 0x00},   // 59 1a74 e9a3 Ã©Â¬Å¸
    {0x4c, 0x57, 0x3d, 0x3d, 0x3c, 0x76, 0x4d, 0x00},   // 59 1a75 e9a4 Ã©Â¬Â¢
    {0x44, 0x7f, 0x5d, 0x3d, 0x58, 0x3a, 0x45, 0x00},   // 59 1a76 e9a5 Ã©Â¬Â£
    {0x7f, 0x07, 0x05, 0x00, 0x05, 0x47, 0x7f, 0x00},   // 59 1a77 e9a6 Ã©Â¬Â¥
    {0x7f, 0x0b, 0x39, 0x7c, 0x19, 0x3b, 0x7f, 0x00},   // 59 1a78 e9a7 Ã©Â¬Â§
    {0x7f, 0x6b, 0x3d, 0x28, 0x3d, 0x6b, 0x7f, 0x00},   // 59 1a79 e9a8 Ã©Â¬Â¨
    {0x7f, 0x5b, 0x35, 0x70, 0x5d, 0x03, 0x7f, 0x00},   // 59 1a7a e9a9 Ã©Â¬Â©
    {0x7f, 0x5b, 0x69, 0x58, 0x11, 0x7b, 0x7f, 0x00},   // 59 1a7b e9aa Ã©Â¬Âª
    {0x7f, 0x0b, 0x39, 0x74, 0x7d, 0x43, 0x7f, 0x00},   // 59 1a7c e9ab Ã©Â¬Â®
    {0x0f, 0x3d, 0x5a, 0x5d, 0x5a, 0x4d, 0x6f, 0x00},   // 59 1a7d e9ac Ã©Â¬Â¯
    {0x79, 0x2f, 0x1d, 0x6d, 0x3d, 0x2f, 0x79, 0x00},   // 59 1a7e e9ad Ã©Â¬Â²
    {0x3e, 0x2b, 0x3e, 0x5e, 0x3f, 0x7a, 0x5e, 0x00},   // 59 1a7f e9ae Ã©Â­â€ž
    {0x4e, 0x3f, 0x7e, 0x52, 0x6f, 0x52, 0x6b, 0x00},   // 59 1a80 e9af Ã©Â­Æ’
    {0x5a, 0x77, 0x3f, 0x56, 0x3f, 0x7a, 0x5e, 0x00},   // 59 1a81 e9b0 Ã©Â­Â
    {0x4e, 0x3f, 0x7e, 0x7f, 0x5b, 0x55, 0x7f, 0x00},   // 59 1a82 e9b1 Ã©Â­Â
    {0x4e, 0x3f, 0x7e, 0x7d, 0x65, 0x5f, 0x7d, 0x00},   // 59 1a83 e9b2 Ã©Â­Å½
    {0x4e, 0x3f, 0x7e, 0x72, 0x5e, 0x7f, 0x72, 0x00},   // 59 1a84 e9b3 Ã©Â­â€˜
    {0x50, 0x4f, 0x3f, 0x2d, 0x7b, 0x77, 0x4b, 0x00},   // 59 1a85 e9b4 Ã©Â­Ëœ
    {0x42, 0x1d, 0x5f, 0x42, 0x3e, 0x4b, 0x7a, 0x00},   // 59 1a86 e9b5 Ã©Â­Â´
    {0x42, 0x1d, 0x5f, 0x04, 0x7f, 0x2a, 0x2a, 0x00},   // 59 1a87 e9b6 Ã©Â®â€œ
    {0x42, 0x1d, 0x5f, 0x15, 0x13, 0x7f, 0x15, 0x00},   // 59 1a88 e9b7 Ã©Â®Æ’
    {0x42, 0x1d, 0x5f, 0x04, 0x7b, 0x5a, 0x5e, 0x00},   // 59 1a89 e9b8 Ã©Â®â€˜
    {0x42, 0x1d, 0x5f, 0x11, 0x7f, 0x49, 0x79, 0x00},   // 59 1a8a e9b9 Ã©Â®â€“
    {0x42, 0x1d, 0x5f, 0x0a, 0x55, 0x4b, 0x08, 0x00},   // 59 1a8b e9ba Ã©Â®â€”
    {0x42, 0x1d, 0x5f, 0x5a, 0x2f, 0x3a, 0x4e, 0x00},   // 59 1a8c e9bb Ã©Â®Å¸
    {0x42, 0x1d, 0x5f, 0x3e, 0x7d, 0x4f, 0x5c, 0x00},   // 59 1a8d e9bc Ã©Â®Â 
    {0x42, 0x1d, 0x5f, 0x00, 0x6f, 0x6a, 0x6d, 0x00},   // 59 1a8e e9bd Ã©Â®Â¨
    {0x42, 0x1d, 0x5f, 0x7f, 0x1a, 0x7f, 0x1a, 0x00},   // 59 1a8f e9be Ã©Â®Â´
    {0x42, 0x1d, 0x5f, 0x15, 0x7b, 0x11, 0x59, 0x00},   // 59 1a90 e9bf Ã©Â¯â‚¬
    {0x55, 0x30, 0x7a, 0x38, 0x77, 0x34, 0x42, 0x00},   // 59 1a91 e9c0 Ã©Â¯Å 
    {0x42, 0x1d, 0x5f, 0x7d, 0x2a, 0x7d, 0x02, 0x00},   // 59 1a92 e9c1 Ã©Â®Â¹
    {0x42, 0x1d, 0x5f, 0x7a, 0x7f, 0x2a, 0x7b, 0x00},   // 59 1a93 e9c2 Ã©Â¯â€ 
    {0x42, 0x1d, 0x5f, 0x35, 0x7f, 0x0e, 0x7f, 0x00},   // 59 1a94 e9c3 Ã©Â¯Â
    {0x42, 0x1d, 0x5f, 0x2d, 0x7a, 0x2d, 0x68, 0x00},   // 59 1a95 e9c4 Ã©Â¯â€˜
    {0x42, 0x1d, 0x5f, 0x7c, 0x15, 0x7f, 0x7d, 0x00},   // 59 1a96 e9c5 Ã©Â¯â€™
    {0x42, 0x1d, 0x5f, 0x27, 0x5d, 0x35, 0x77, 0x00},   // 59 1a97 e9c6 Ã©Â¯Â£
    {0x42, 0x1d, 0x5f, 0x5e, 0x35, 0x72, 0x5e, 0x00},   // 59 1a98 e9c7 Ã©Â¯Â¢
    {0x42, 0x1d, 0x7f, 0x55, 0x05, 0x7d, 0x57, 0x00},   // 59 1a99 e9c8 Ã©Â¯Â¤
    {0x42, 0x1d, 0x5f, 0x7a, 0x5d, 0x7a, 0x7d, 0x00},   // 59 1a9a e9c9 Ã©Â¯â€
    {0x5d, 0x1f, 0x6a, 0x3f, 0x00, 0x7f, 0x2a, 0x00},   // 59 1a9b e9ca Ã©Â¯Â¡
    {0x5d, 0x1f, 0x5a, 0x4f, 0x5a, 0x2d, 0x1a, 0x00},   // 59 1a9c e9cb Ã©Â°Âº
    {0x5d, 0x1f, 0x62, 0x1f, 0x7a, 0x29, 0x52, 0x00},   // 59 1a9d e9cc Ã©Â¯Â²
    {0x42, 0x1d, 0x5f, 0x7c, 0x24, 0x6f, 0x4a, 0x00},   // 59 1a9e e9cd Ã©Â¯Â±
    {0x42, 0x1d, 0x5f, 0x2a, 0x4d, 0x5e, 0x64, 0x00},   // 59 1a9f e9ce Ã©Â¯Â°
    {0x42, 0x1d, 0x7f, 0x2b, 0x58, 0x2d, 0x5f, 0x00},   // 59 1aa0 e9cf Ã©Â°â€¢
    {0x42, 0x1d, 0x7f, 0x6a, 0x6a, 0x3f, 0x52, 0x00},   // 59 1aa1 e9d0 Ã©Â°â€
    {0x42, 0x1d, 0x5f, 0x50, 0x5e, 0x7b, 0x5e, 0x00},   // 59 1aa2 e9d1 Ã©Â°â€°
    {0x42, 0x1d, 0x5f, 0x2d, 0x4f, 0x4d, 0x6f, 0x00},   // 59 1aa3 e9d2 Ã©Â°â€œ
    {0x42, 0x1d, 0x5f, 0x76, 0x7d, 0x7d, 0x76, 0x00},   // 59 1aa4 e9d3 Ã©Â°Å’
    {0x42, 0x1d, 0x5f, 0x1a, 0x6f, 0x7e, 0x2a, 0x00},   // 59 1aa5 e9d4 Ã©Â°â€ 
    {0x42, 0x1d, 0x5f, 0x32, 0x77, 0x36, 0x57, 0x00},   // 59 1aa6 e9d5 Ã©Â°Ë†
    {0x42, 0x1d, 0x5f, 0x53, 0x2e, 0x5e, 0x42, 0x00},   // 59 1aa7 e9d6 Ã©Â°â€™
    {0x42, 0x1d, 0x5f, 0x2e, 0x7f, 0x2e, 0x4e, 0x00},   // 59 1aa8 e9d7 Ã©Â°Å 
    {0x42, 0x1d, 0x7f, 0x2e, 0x56, 0x3f, 0x52, 0x00},   // 59 1aa9 e9d8 Ã©Â°â€ž
    {0x42, 0x1d, 0x5f, 0x4f, 0x6d, 0x6b, 0x4f, 0x00},   // 59 1aaa e9d9 Ã©Â°Â®
    {0x42, 0x1d, 0x5f, 0x77, 0x75, 0x75, 0x47, 0x00},   // 59 1aab e9da Ã©Â°â€º
    {0x42, 0x1d, 0x5f, 0x2b, 0x77, 0x2b, 0x53, 0x00},   // 59 1aac e9db Ã©Â°Â¥
    {0x42, 0x1d, 0x7f, 0x36, 0x3d, 0x7f, 0x3d, 0x00},   // 59 1aad e9dc Ã©Â°Â¤
    {0x42, 0x1d, 0x5f, 0x0e, 0x69, 0x66, 0x0e, 0x00},   // 59 1aae e9dd Ã©Â°Â¡
    {0x5d, 0x1f, 0x35, 0x7d, 0x3e, 0x6b, 0x3e, 0x00},   // 59 1aaf e9de Ã©Â°Â°
    {0x5d, 0x1f, 0x3e, 0x52, 0x7e, 0x2f, 0x56, 0x00},   // 59 1ab0 e9df Ã©Â±â€¡
    {0x54, 0x3e, 0x7f, 0x34, 0x7a, 0x35, 0x4b, 0x00},   // 59 1ab1 e9e0 Ã©Â°Â²
    {0x42, 0x1d, 0x5f, 0x2a, 0x3e, 0x7b, 0x2e, 0x00},   // 59 1ab2 e9e1 Ã©Â±â€ 
    {0x42, 0x1d, 0x5f, 0x11, 0x77, 0x17, 0x51, 0x00},   // 59 1ab3 e9e2 Ã©Â°Â¾
    {0x5d, 0x1f, 0x52, 0x7e, 0x57, 0x7e, 0x12, 0x00},   // 59 1ab4 e9e3 Ã©Â±Å¡
    {0x42, 0x1d, 0x5f, 0x76, 0x5d, 0x76, 0x1c, 0x00},   // 59 1ab5 e9e4 Ã©Â±Â 
    {0x42, 0x1d, 0x5f, 0x5e, 0x77, 0x76, 0x5f, 0x00},   // 59 1ab6 e9e5 Ã©Â±Â§
    {0x5d, 0x1f, 0x2a, 0x7b, 0x3e, 0x5b, 0x2a, 0x00},   // 59 1ab7 e9e6 Ã©Â±Â¶
    {0x42, 0x1d, 0x7f, 0x44, 0x6f, 0x6a, 0x4a, 0x00},   // 59 1ab8 e9e7 Ã©Â±Â¸
    {0x50, 0x4e, 0x3e, 0x2f, 0x3e, 0x68, 0x58, 0x00},   // 59 1ab9 e9e8 Ã©Â³Â§
    {0x40, 0x46, 0x36, 0x17, 0x76, 0x44, 0x6c, 0x00},   // 59 1aba e9e9 Ã©Â³Â¬
    {0x32, 0x0e, 0x50, 0x1e, 0x57, 0x16, 0x70, 0x00},   // 59 1abb e9ea Ã©Â³Â°
    {0x2f, 0x59, 0x7f, 0x09, 0x5e, 0x17, 0x76, 0x00},   // 59 1abc e9eb Ã©Â´â€°
    {0x40, 0x3f, 0x7d, 0x03, 0x5d, 0x1f, 0x71, 0x00},   // 59 1abd e9ec Ã©Â´Ë†
    {0x40, 0x3f, 0x41, 0x1d, 0x5f, 0x1d, 0x71, 0x00},   // 59 1abe e9ed Ã©Â³Â«
    {0x5e, 0x17, 0x76, 0x48, 0x4a, 0x3f, 0x4e, 0x00},   // 59 1abf e9ee Ã©Â´Æ’
    {0x46, 0x3f, 0x72, 0x46, 0x1e, 0x57, 0x76, 0x00},   // 59 1ac0 e9ef Ã©Â´â€ 
    {0x46, 0x3a, 0x03, 0x3a, 0x5e, 0x17, 0x76, 0x00},   // 59 1ac1 e9f0 Ã©Â´Âª
    {0x54, 0x0e, 0x5e, 0x1f, 0x56, 0x1e, 0x74, 0x00},   // 59 1ac2 e9f1 Ã©Â´Â¦
    {0x4d, 0x06, 0x5d, 0x1c, 0x5d, 0x16, 0x7d, 0x00},   // 59 1ac3 e9f2 Ã©Â¶Â¯
    {0x3a, 0x2f, 0x3a, 0x5e, 0x17, 0x56, 0x70, 0x00},   // 59 1ac4 e9f3 Ã©Â´Â£
    {0x7e, 0x4a, 0x5e, 0x29, 0x5e, 0x17, 0x76, 0x00},   // 59 1ac5 e9f4 Ã©Â´Å¸
    {0x49, 0x5d, 0x3b, 0x2d, 0x5e, 0x17, 0x76, 0x00},   // 59 1ac6 e9f5 Ã©Âµâ€ž
    {0x5e, 0x17, 0x70, 0x06, 0x7a, 0x53, 0x56, 0x00},   // 59 1ac7 e9f6 Ã©Â´â€¢
    {0x16, 0x75, 0x36, 0x00, 0x5e, 0x17, 0x76, 0x00},   // 59 1ac8 e9f7 Ã©Â´â€™
    {0x4a, 0x56, 0x23, 0x56, 0x5e, 0x17, 0x76, 0x00},   // 59 1ac9 e9f8 Ã©ÂµÂ
    {0x76, 0x55, 0x76, 0x00, 0x5e, 0x17, 0x76, 0x00},   // 59 1aca e9f9 Ã©Â´Â¿
    {0x36, 0x2d, 0x7c, 0x2e, 0x5e, 0x17, 0x76, 0x00},   // 59 1acb e9fa Ã©Â´Â¾
    {0x0a, 0x7d, 0x5e, 0x17, 0x70, 0x05, 0x7d, 0x00},   // 59 1acc e9fb Ã©Âµâ€ 
    {0x21, 0x3f, 0x2d, 0x7f, 0x5e, 0x17, 0x76, 0x00},   // 59 1acd e9fc Ã©ÂµË†
    {0x26, 0x7e, 0x25, 0x7f, 0x5e, 0x17, 0x76, 0x00},   // 5a 1ace ea40 Ã©ÂµÂ
    {0x4a, 0x0f, 0x5f, 0x1a, 0x5b, 0x16, 0x7b, 0x00},   // 5a 1acf ea41 Ã©ÂµÅ¾
    {0x42, 0x3d, 0x5f, 0x7c, 0x5e, 0x17, 0x76, 0x00},   // 5a 1ad0 ea42 Ã©ÂµÂ¤
    {0x78, 0x2b, 0x2b, 0x78, 0x5e, 0x17, 0x76, 0x00},   // 5a 1ad1 ea43 Ã©Âµâ€˜
    {0x51, 0x4d, 0x3f, 0x2d, 0x5e, 0x17, 0x76, 0x00},   // 5a 1ad2 ea44 Ã©ÂµÂ
    {0x5f, 0x15, 0x5f, 0x00, 0x5e, 0x17, 0x76, 0x00},   // 5a 1ad3 ea45 Ã©Âµâ„¢
    {0x0a, 0x7f, 0x5a, 0x7f, 0x5e, 0x17, 0x76, 0x00},   // 5a 1ad4 ea46 Ã©ÂµÂ²
    {0x22, 0x2e, 0x7b, 0x1e, 0x5e, 0x17, 0x76, 0x00},   // 5a 1ad5 ea47 Ã©Â¶â€°
    {0x42, 0x2e, 0x7f, 0x2e, 0x5e, 0x17, 0x76, 0x00},   // 5a 1ad6 ea48 Ã©Â¶â€¡
    {0x4e, 0x2e, 0x7f, 0x2e, 0x5e, 0x17, 0x76, 0x00},   // 5a 1ad7 ea49 Ã©Â¶Â«
    {0x2e, 0x3f, 0x7a, 0x2e, 0x5e, 0x17, 0x76, 0x00},   // 5a 1ad8 ea4a Ã©ÂµÂ¯
    {0x12, 0x7e, 0x2b, 0x5a, 0x1e, 0x57, 0x76, 0x00},   // 5a 1ad9 ea4b Ã©ÂµÂº
    {0x0b, 0x3f, 0x6c, 0x0b, 0x5e, 0x17, 0x76, 0x00},   // 5a 1ada ea4c Ã©Â¶Å¡
    {0x27, 0x3d, 0x7f, 0x27, 0x5e, 0x17, 0x76, 0x00},   // 5a 1adb ea4d Ã©Â¶Â¤
    {0x4a, 0x07, 0x5f, 0x1d, 0x5a, 0x15, 0x7b, 0x00},   // 5a 1adc ea4e Ã©Â¶Â©
    {0x5a, 0x2d, 0x78, 0x29, 0x7a, 0x1f, 0x76, 0x00},   // 5a 1add ea4f Ã©Â¶Â²
    {0x52, 0x55, 0x3b, 0x51, 0x1e, 0x57, 0x76, 0x00},   // 5a 1ade ea50 Ã©Â·â€ž
    {0x52, 0x6d, 0x6d, 0x52, 0x1e, 0x57, 0x76, 0x00},   // 5a 1adf ea51 Ã©Â·Â
    {0x0c, 0x77, 0x35, 0x77, 0x5e, 0x17, 0x76, 0x00},   // 5a 1ae0 ea52 Ã©Â¶Â»
    {0x5d, 0x77, 0x5d, 0x77, 0x5e, 0x17, 0x76, 0x00},   // 5a 1ae1 ea53 Ã©Â¶Â¸
    {0x15, 0x7d, 0x2a, 0x7d, 0x5e, 0x17, 0x76, 0x00},   // 5a 1ae2 ea54 Ã©Â¶Âº
    {0x58, 0x1f, 0x1e, 0x52, 0x1e, 0x57, 0x76, 0x00},   // 5a 1ae3 ea55 Ã©Â·â€ 
    {0x52, 0x1e, 0x1f, 0x52, 0x1e, 0x57, 0x76, 0x00},   // 5a 1ae4 ea56 Ã©Â·Â
    {0x6a, 0x4d, 0x7b, 0x68, 0x5e, 0x17, 0x76, 0x00},   // 5a 1ae5 ea57 Ã©Â·â€š
    {0x44, 0x0e, 0x5f, 0x1a, 0x57, 0x1e, 0x78, 0x00},   // 5a 1ae6 ea58 Ã©Â·â„¢
    {0x7e, 0x4a, 0x1f, 0x5a, 0x5e, 0x17, 0x76, 0x00},   // 5a 1ae7 ea59 Ã©Â·â€œ
    {0x7a, 0x37, 0x5f, 0x73, 0x5e, 0x17, 0x76, 0x00},   // 5a 1ae8 ea5a Ã©Â·Â¸
    {0x44, 0x1f, 0x5e, 0x13, 0x5e, 0x17, 0x76, 0x00},   // 5a 1ae9 ea5b Ã©Â·Â¦
    {0x15, 0x6f, 0x7d, 0x6f, 0x5e, 0x17, 0x76, 0x00},   // 5a 1aea ea5c Ã©Â·Â­
    {0x4a, 0x1e, 0x6b, 0x1e, 0x5e, 0x17, 0x76, 0x00},   // 5a 1aeb ea5d Ã©Â·Â¯
    {0x4c, 0x06, 0x5d, 0x1e, 0x5d, 0x17, 0x7c, 0x00},   // 5a 1aec ea5e Ã©Â·Â½
    {0x57, 0x7b, 0x54, 0x33, 0x5f, 0x16, 0x77, 0x00},   // 5a 1aed ea5f Ã©Â¸Å¡
    {0x26, 0x7f, 0x52, 0x7f, 0x5e, 0x17, 0x76, 0x00},   // 5a 1aee ea60 Ã©Â¸â€º
    {0x4a, 0x1d, 0x5a, 0x17, 0x57, 0x1a, 0x7d, 0x00},   // 5a 1aef ea61 Ã©Â¸Å¾
    {0x00, 0x7c, 0x54, 0x6f, 0x56, 0x6e, 0x7a, 0x00},   // 5a 1af0 ea62 Ã©Â¹Âµ
    {0x7c, 0x47, 0x7a, 0x7e, 0x6a, 0x3f, 0x52, 0x00},   // 5a 1af1 ea63 Ã©Â¹Â¹
    {0x4f, 0x7f, 0x59, 0x74, 0x5f, 0x7e, 0x4e, 0x00},   // 5a 1af2 ea64 Ã©Â¹Â½
    {0x42, 0x3e, 0x75, 0x5d, 0x17, 0x7c, 0x54, 0x00},   // 5a 1af3 ea65 Ã©ÂºÂ
    {0x40, 0x3e, 0x5a, 0x76, 0x67, 0x7e, 0x52, 0x00},   // 5a 1af4 ea66 Ã©ÂºË†
    {0x48, 0x56, 0x3e, 0x7a, 0x3f, 0x5e, 0x4a, 0x00},   // 5a 1af5 ea67 Ã©Âºâ€¹
    {0x48, 0x76, 0x2e, 0x3a, 0x3f, 0x7e, 0x4a, 0x00},   // 5a 1af6 ea68 Ã©ÂºÅ’
    {0x7e, 0x3b, 0x2e, 0x52, 0x1f, 0x1a, 0x5f, 0x00},   // 5a 1af7 ea69 Ã©Âºâ€™
    {0x08, 0x76, 0x7e, 0x7a, 0x5f, 0x7e, 0x0a, 0x00},   // 5a 1af8 ea6a Ã©Âºâ€¢
    {0x48, 0x46, 0x36, 0x2a, 0x2f, 0x7e, 0x4a, 0x00},   // 5a 1af9 ea6b Ã©Âºâ€˜
    {0x48, 0x36, 0x5e, 0x7a, 0x2f, 0x4e, 0x7a, 0x00},   // 5a 1afa ea6c Ã©ÂºÂ
    {0x0a, 0x56, 0x2a, 0x57, 0x3a, 0x56, 0x0a, 0x00},   // 5a 1afb ea6d Ã©ÂºÂ¥
    {0x2a, 0x56, 0x2f, 0x5a, 0x6a, 0x5f, 0x6a, 0x00},   // 5a 1afc ea6e Ã©ÂºÂ©
    {0x52, 0x2f, 0x5a, 0x40, 0x6a, 0x5f, 0x6a, 0x00},   // 5a 1afd ea6f Ã©ÂºÂ¸
    {0x2a, 0x56, 0x2f, 0x5a, 0x4d, 0x6f, 0x7d, 0x00},   // 5a 1afe ea70 Ã©ÂºÂª
    {0x2a, 0x56, 0x2f, 0x5a, 0x44, 0x7b, 0x5e, 0x00},   // 5a 1aff ea71 Ã©ÂºÂ­
    {0x40, 0x3e, 0x6a, 0x3e, 0x0b, 0x7e, 0x2a, 0x00},   // 5a 1b00 ea72 Ã©ÂÂ¡
    {0x4c, 0x56, 0x3d, 0x36, 0x3d, 0x57, 0x4c, 0x00},   // 5a 1b01 ea73 Ã©Â»Å’
    {0x2a, 0x67, 0x3f, 0x6a, 0x37, 0x6a, 0x2e, 0x00},   // 5a 1b02 ea74 Ã©Â»Å½
    {0x5a, 0x37, 0x7f, 0x3a, 0x70, 0x5f, 0x74, 0x00},   // 5a 1b03 ea75 Ã©Â»Â
    {0x5a, 0x37, 0x7f, 0x3a, 0x7e, 0x3f, 0x72, 0x00},   // 5a 1b04 ea76 Ã©Â»Â
    {0x57, 0x1f, 0x57, 0x12, 0x55, 0x36, 0x14, 0x00},   // 5a 1b05 ea77 Ã©Â»â€
    {0x57, 0x1f, 0x57, 0x76, 0x44, 0x7f, 0x76, 0x00},   // 5a 1b06 ea78 Ã©Â»Å“
    {0x57, 0x1f, 0x57, 0x70, 0x5f, 0x54, 0x74, 0x00},   // 5a 1b07 ea79 Ã©Â»Å¾
    {0x57, 0x1f, 0x74, 0x4b, 0x62, 0x1f, 0x7e, 0x00},   // 5a 1b08 ea7a Ã©Â»Â
    {0x57, 0x1f, 0x57, 0x02, 0x6a, 0x6f, 0x6a, 0x00},   // 5a 1b09 ea7b Ã©Â»Â 
    {0x57, 0x1f, 0x57, 0x22, 0x4e, 0x7b, 0x2e, 0x00},   // 5a 1b0a ea7c Ã©Â»Â¥
    {0x56, 0x1b, 0x5e, 0x17, 0x5e, 0x1b, 0x56, 0x00},   // 5a 1b0b ea7d Ã©Â»Â¨
    {0x57, 0x1f, 0x57, 0x0e, 0x6b, 0x6e, 0x0a, 0x00},   // 5a 1b0c ea7e Ã©Â»Â¯
    {0x0a, 0x7d, 0x56, 0x1f, 0x56, 0x3f, 0x5e, 0x00},   // 5b 1b0d ea80 Ã©Â»Â´
    {0x68, 0x27, 0x7f, 0x3d, 0x7b, 0x27, 0x6b, 0x00},   // 5b 1b0e ea81 Ã©Â»Â¶
    {0x57, 0x1f, 0x57, 0x3e, 0x3b, 0x3e, 0x4e, 0x00},   // 5b 1b0f ea82 Ã©Â»Â·
    {0x0b, 0x76, 0x33, 0x7e, 0x33, 0x76, 0x0b, 0x00},   // 5b 1b10 ea83 Ã©Â»Â¹
    {0x75, 0x3e, 0x75, 0x22, 0x5f, 0x22, 0x5b, 0x00},   // 5b 1b11 ea84 Ã©Â»Â»
    {0x75, 0x3e, 0x75, 0x7a, 0x7f, 0x2a, 0x7b, 0x00},   // 5b 1b12 ea85 Ã©Â»Â¼
    {0x18, 0x1b, 0x7f, 0x41, 0x7f, 0x5b, 0x58, 0x00},   // 5b 1b13 ea86 Ã©Â»Â½
    {0x14, 0x3e, 0x7f, 0x4c, 0x7a, 0x7d, 0x4b, 0x00},   // 5b 1b14 ea87 Ã©Â¼â€¡
    {0x02, 0x3d, 0x7e, 0x4d, 0x7a, 0x75, 0x4b, 0x00},   // 5b 1b15 ea88 Ã©Â¼Ë†
    {0x5a, 0x77, 0x2a, 0x7e, 0x5a, 0x2f, 0x5e, 0x00},   // 5b 1b16 ea89 Ã§Å¡Â·
    {0x2a, 0x2f, 0x3e, 0x5a, 0x16, 0x2f, 0x2a, 0x00},   // 5b 1b17 ea8a Ã©Â¼â€¢
    {0x40, 0x3d, 0x14, 0x7d, 0x16, 0x7d, 0x40, 0x00},   // 5b 1b18 ea8b Ã©Â¼Â¡
    {0x7e, 0x59, 0x2a, 0x7e, 0x5e, 0x5f, 0x5e, 0x00},   // 5b 1b19 ea8c Ã©Â¼Â¬
    {0x38, 0x6e, 0x3b, 0x7e, 0x09, 0x7f, 0x09, 0x00},   // 5b 1b1a ea8d Ã©Â¼Â¾
    {0x4a, 0x36, 0x2e, 0x2b, 0x2e, 0x76, 0x0a, 0x00},   // 5b 1b1b ea8e Ã©Â½Å 
    {0x04, 0x7e, 0x54, 0x6f, 0x56, 0x6e, 0x7a, 0x00},   // 5b 1b1c ea8f Ã©Â½â€™
    {0x7e, 0x6c, 0x57, 0x7a, 0x7f, 0x48, 0x64, 0x00},   // 5b 1b1d ea90 Ã©Â½â€
    {0x7e, 0x6c, 0x57, 0x7a, 0x04, 0x5b, 0x7e, 0x00},   // 5b 1b1e ea91 Ã©Â½Â£
    {0x7e, 0x6c, 0x57, 0x7a, 0x7f, 0x55, 0x7f, 0x00},   // 5b 1b1f ea92 Ã©Â½Å¸
    {0x7e, 0x6c, 0x57, 0x7a, 0x75, 0x53, 0x77, 0x00},   // 5b 1b20 ea93 Ã©Â½Â 
    {0x7e, 0x6c, 0x57, 0x7a, 0x16, 0x75, 0x36, 0x00},   // 5b 1b21 ea94 Ã©Â½Â¡
    {0x7e, 0x6c, 0x57, 0x7a, 0x7f, 0x35, 0x5f, 0x00},   // 5b 1b22 ea95 Ã©Â½Â¦
    {0x0a, 0x7f, 0x6e, 0x58, 0x6d, 0x5b, 0x7f, 0x00},   // 5b 1b23 ea96 Ã©Â½Â§
    {0x7e, 0x6c, 0x57, 0x7a, 0x05, 0x6f, 0x6d, 0x00},   // 5b 1b24 ea97 Ã©Â½Â¬
    {0x7e, 0x6c, 0x57, 0x7a, 0x27, 0x7d, 0x57, 0x00},   // 5b 1b25 ea98 Ã©Â½Âª
    {0x7c, 0x57, 0x6a, 0x7f, 0x5b, 0x77, 0x53, 0x00},   // 5b 1b26 ea99 Ã©Â½Â·
    {0x7e, 0x6c, 0x57, 0x7a, 0x7e, 0x3f, 0x71, 0x00},   // 5b 1b27 ea9a Ã©Â½Â²
    {0x7e, 0x54, 0x6f, 0x7a, 0x0f, 0x3c, 0x6b, 0x00},   // 5b 1b28 ea9b Ã©Â½Â¶
    {0x2a, 0x7a, 0x2e, 0x7d, 0x2e, 0x76, 0x5a, 0x00},   // 5b 1b29 ea9c Ã©Â¾â€¢
    {0x2a, 0x3e, 0x7d, 0x45, 0x7f, 0x7c, 0x58, 0x00},   // 5b 1b2a ea9d Ã©Â¾Å“
    {0x1c, 0x74, 0x3e, 0x75, 0x3e, 0x74, 0x1c, 0x00},   // 5b 1b2b ea9e Ã©Â¾Â 
    {0x54, 0x5e, 0x3e, 0x17, 0x7e, 0x5e, 0x54, 0x00},   // 5b 1b2c ea9f Ã¥Â Â¯
    {0x1a, 0x7f, 0x58, 0x13, 0x1e, 0x1e, 0x52, 0x00},   // 5b 1b2d eaa0 Ã¦Â§â€¡
    {0x55, 0x30, 0x50, 0x6a, 0x4d, 0x7b, 0x68, 0x00},   // 5b 1b2e eaa1 Ã©Ââ„¢
    {0x2a, 0x3e, 0x12, 0x6a, 0x4d, 0x7b, 0x68, 0x00},   // 5b 1b2f eaa2 Ã§â€˜Â¤
    {0x71, 0x00, 0x52, 0x3e, 0x7b, 0x3e, 0x52, 0x00},   // 5b 1b30 eaa3 Ã¥â€¡Å“
    {0x5f, 0x15, 0x5b, 0x15, 0x40, 0x1f, 0x57, 0x00},   // 5b 1b31 eaa4 Ã§â€ â„¢
};
