/*
 Demo of Embedded Artists LPCXpresso baseboard ethernet and OLED display facilities.

 Uses HTTP client to obtain the current time and displays the day, date and time on the OLED display.
 
 Based on RTCsetwithHTTPClient by nucho.

 NOTE: The LCPXpresso board does not provide the data/command signal to the mbed.
 To provide this signal please connect a jumper wire from PIO2_7 of baseboard mbed socket
 (empty 2nd hole below mbed pin 21) to  to PIO2_5 (on J6 right side ninth hole from bottom). 
 
 All jumpers on the board can be left in the default locations. 
 
*/
#include <stdio.h>
#include <string.h>
#include "mbed.h"
#include "HTTPClient.h"
#include "spioled.h"

//#include "EAOLED.h"

#define PAGE_SIZE 77
#define countof(x) ( sizeof(x) / sizeof(x[0]) )

HTTPClient http;
SPIOLED oled(p21, p22, p23, p5, p6, p7);//CS,  RES,  DC,  mosi, miso(No Connect), sclk

bool kstate = false;
unsigned int kbuf;
unsigned char x_locale = 0;
unsigned char y_locale = 0;


unsigned int findface(unsigned short c) {
    unsigned int p = 0;
    int i, sum;
    for (sum = i = 0; i < countof(font8table); i++) {
        if (font8table[i].start <= c && c <= font8table[i].end) {
            p = (sum + c - font8table[i].start);
            break;
        }
        sum += font8table[i].end - font8table[i].start + 1;
    }
    return p;
}

void drawc(unsigned char c) {
    if (kstate) { // 2nd byte of shift-jis
        kstate = false;
        unsigned int p = findface(kbuf << 8 | c);
        oled.PutChar( x_locale , y_locale ,p);
        //   printf("%x %x\r\n",( kbuf << 8 | c),p); //for debug
        x_locale += X_Witch;
        if (x_locale + (X_Witch - 1) >= Dis_X_MAX) {
            x_locale = 0;
            y_locale += Y_Witch;
            if (y_locale >= Dis_Y_MAX)y_locale=0;
        }

    } else if ((0x81 <= c && c <= 0x9f) || (0xe0 <= c && c <= 0xfc)) { // 1st byte of shift-jis
        kstate = true;
        kbuf = c;
    } else {
        oled.PutChar_ABC( x_locale , y_locale ,c);
        x_locale += 6;
        if (x_locale + (X_Witch - 1) >= Dis_X_MAX) {
            x_locale = 0;
            y_locale += Y_Witch;
            if (y_locale >= Dis_Y_MAX)y_locale=0;
        }
    }

}

void draws(unsigned char x, unsigned char y, char *s) {
    unsigned char c;
    x_locale = x;
    y_locale = y;
    while ((c = *s++) != '\0')drawc(c);
}

int main(void) {
    char s[256];
    //printf("\r\n----------- starting ---------\r\n");
/*
    oled.cls();
    oled.locate(0,1);
    oled.printf(" mbed clock\n");
    oled.locate(0,3);
    oled.printf(" connect\n");
    oled.locate(0,5);
    oled.printf(" ethernet\n");
    oled.locate(0,7);
    oled.printf(" to start..\n");
*/
    oled.Full_Screen(0xffff);
    char result[PAGE_SIZE+1];
      char buf[40];
      char day[12];
      char dmy[12];
      char hms[12];
      
    char *e;

    time_t seconds;
    printf("getting Data\r\n");
    http.get("http://ntp-a1.nict.go.jp/cgi-bin/ntp", result,PAGE_SIZE);
    result[PAGE_SIZE]='\0';
    
    int start_body=strstr(result,"<BODY>")-result+7;
    int end_body = strstr(result,"</BODY>")-result-1;
    strncpy(buf, result+start_body, end_body-start_body);
    buf[end_body-start_body]='\0';
    printf("got data\r\n"); 
    seconds = strtoul(buf,&e,10)-2208988800UL;
    seconds += 32400;// JST to BST - change this to suit your local time
    set_time(seconds);

  //  oled.cls();

    while (1) {

       
        seconds = time(NULL);
        strftime(day,sizeof(day),"%A", localtime(&seconds));
        strftime(dmy,sizeof(dmy),"%d/%m/%Y", localtime(&seconds));
        strftime(hms,sizeof(hms),"%H:%M:%S", localtime(&seconds));
        

       
        oled.ChangeFontColor(0);    
        //printf("%s %s %s\r\n", hms,day,dmy);
        sprintf(s,"%s %s %s", hms,day,dmy);
        draws(1,16,s);
        //printf("%s %s %s\r\n", hms,day,dmy);
/*        oled.locate((12-strlen(day))/2,1);
        oled.printf("%s", day);
        oled.locate((12-strlen(hms))/2,4);
        oled.printf("%s", hms);
        oled.locate((12-strlen(dmy))/2,7);
        oled.printf("%s", dmy);
*/

  //      draws(1,0,"%s",day);
  

        wait_ms(1000);
        
        
        
        
    }
}

