// ALO-095BWNN-J9 test program
// See also "http://www.aitendo.co.jp/product/2099"


#ifndef __SPIOLED_H__
#define __SPIOLED_H__

#include "mbed.h"
#include "small_font.h"

class SPIOLED {
private:    
    DigitalOut  CS,  RES,  DC;
    SPI spi; // mosi, miso, sclk

    #define Dis_X_MAX 96-1      // Max X axial direction in screen
    #define Dis_Y_MAX 64-1      // Max Y axial direction in screen
    #define X_Witch 8           // character's width
    #define Y_Witch 8           // character's height

    unsigned int Char_Color; //character's color
    unsigned int BGround_Color;

  
    
    void Init(void){
        spi.format(8,0); // nazo
        spi.frequency(20000000); // modify later
        
        // reset
        wait_ms(200);
         RES = 0;       //Reset active
        wait_ms(200);
         RES = 1;
        
        
        // initialize sequence
         RegWrite(0xae);    //OLED display OFF
        
        //Row Address
         RegWrite(0x75);    /* Set Row Address */
         RegWrite(0x00);    /* Start = 0 */
         RegWrite(0x3f);    /* End = 63 */
         RegWrite(0x15);    /* Set Column Address */
         RegWrite(0x00);    /* Start = 0 */
         RegWrite(0x5F);    /* End = 96 */
        
        //Contrast
         RegWrite(0xa0);    //Set remap & data format 0111 0000
         RegWrite(0x74);
         RegWrite(0xa1);    //set display star row RAM
         RegWrite(0x00);
         RegWrite(0xa2);    //set dispaly offset
         RegWrite(0x00);
         RegWrite(0xa4);    //Set Display Mode
         RegWrite(0xa8);    //Set Multiplex Ratio
         RegWrite(0x3f);
         RegWrite(0xad);    //Set Master Configuration
         RegWrite(0x8f);    //(External VCC Supply Selected)
         RegWrite(0xB0);    //Set Power Saving Mode
         RegWrite(0x1a);
         RegWrite(0xB1);    //Set Phase 1 & 2 Period Adjustment
         RegWrite(0x74);
         RegWrite(0xb3);     //Set Display Clock Divide Ratio / Oscillator Frequency
         RegWrite(0xd0);
         RegWrite(0x8A);    //Set Second Pre-charge Speed of Color A
         RegWrite(0x81);
         RegWrite(0x8B);    //Set Second Pre-charge Speed of Color B
         RegWrite(0x82);
         RegWrite(0x8C);    //Set Second Pre-charge Speed of Color C
         RegWrite(0x83);
         RegWrite(0xBB);    //Set Pre-charge Level
         RegWrite(0x3e);
         RegWrite(0xBE);    //Set VCOMH
         RegWrite(0x3e);
         RegWrite(0x87);    //Set Master Current Control
         RegWrite(0x0f);
         RegWrite(0x81);    //Set Contrast Control for Color &#129;gA&#129;h
         RegWrite(0x80);
         RegWrite(0x82);    //Set Contrast Control for Color &#129;gB&#129;h
         RegWrite(0x80);
         RegWrite(0x83);    //Set Contrast Control for Color &#129;gC&#129;h
         RegWrite(0x80);
         RegWrite(0xaf);    //display ON
        
    }
public:
    // constructor
    SPIOLED(PinName cs_pin, PinName rst_pin, PinName a0_pin, PinName mosi_pin, PinName miso_pin, PinName sclk_pin)
    : CS(cs_pin), RES(rst_pin), DC(a0_pin), spi(mosi_pin, miso_pin, sclk_pin) {
        
        Init();
    }
    
    
    
    
    void  RegWrite(unsigned char Command)
    {
         DC = 0;    // Command
         CS = 0;    // CS active(toggle OLED)
        spi.write(Command);
         CS = 1;
    }



    void  DataWrite(unsigned char c){
         DC = 1;    // DATA
         CS = 0;    // CS active(toggle OLED)
        spi.write(c);
         CS = 1;
    }

    void  DataWrite_to(unsigned int Dat)
    {
         DataWrite((unsigned char)((Dat >> 8)& 0x00ff));
         DataWrite((unsigned char)(Dat & 0x00ff));
    }




    void Draw_Dot(unsigned char x,unsigned char y,unsigned int Color)
    {
         RegWrite(0x15);
         RegWrite(x);
         RegWrite(x);
         RegWrite(0x75);
         RegWrite(y);
         RegWrite(y);
         DataWrite_to(Color);
         DataWrite_to(Color);
    }

    void Full_Screen(unsigned int Dot)
    {
        unsigned char i,j;
        BGround_Color = Dot;
        for(i=0;i<=64;i++)
        {
            for(j=0;j<96;j++)
            {
                Draw_Dot(j,i,Dot);
                // DataWrite_to(Dot);
            }
        }
    }

    void ChangeFontColor(unsigned int color)
    {
        Char_Color = color;
    }

    void PutChar(unsigned char x,unsigned char y,unsigned int a)
    {
        int i,j;
        unsigned char Temp=0;        
        j = 0;
        i = 0;
        //if(a < 32)a=32;   
        for(i=0; i<X_Witch; i++)
        {    
            Temp = FontLookup[a][i];
            for(j=Y_Witch;j!=0;j--){
                if((Temp & 0x80)==0x80){
                    Draw_Dot(x+i,y+j,Char_Color);
                }else{
                    Draw_Dot(x+i,y+j,BGround_Color);
                }
                Temp = Temp << 1;
            }
        }
        
        
    }

void PutChar_ABC(unsigned char x,unsigned char y,unsigned int a)
    {
        int i,j;
        unsigned char Temp=0;        
        j = 0;
        i = 0;   
        for(i=0; i<5; i++)
        {    
            if(a < 32)a=32;
            Temp = FontLookup_ABC[a-32][i];
            for(j=Y_Witch;j!=0;j--){
                if((Temp & 0x80)==0x80){
                    Draw_Dot(x+i,y+j,Char_Color);
                }else{
                    Draw_Dot(x+i,y+j,BGround_Color);
                }
                Temp = Temp << 1;
            }
        }
        
        
    }



};


#endif