#include "mbed.h"
#include "MSCFileSystem.h"
#include "SDHCFileSystem.h"
#include "i2s_irq_test.h"
#include "lpc17xx_i2s.h"
#include "lpc17xx_clkpwr.h"
#include "aic23b_comm.h"
#include "string"


DigitalOut led1(LED1); 
DigitalOut led2(LED2);
DigitalOut led3(LED3); 
Serial pc(USBTX, USBRX); // tx, rx       
I2C AIC23B(p9,p10);     //sda,scl
SDFileSystem sd(p11, p12, p13, p14, "sd");//p5,6,7,8
MSCFileSystem msc("msc"); // Mount flash drive under the name "msc"


FILE    *infp,*outfp;
Ticker  tick;
// a FIFO for the DAC
#define RAM_LENGTH 8192//8192
#define RAM_LIMIT (RAM_LENGTH - 1) 
volatile static signed short DAC_fifo[RAM_LENGTH];
volatile long int DAC_diff;


int aic23b_send(int addr,char ctrl_address,char ctrl_data){
    int flag;
    char cmd[2];
    cmd[0]=ctrl_address;
    cmd[1]=ctrl_data;
    flag = AIC23B.write(addr, cmd, 2);
    pc.printf("ADDR=0x%x, CTRL_ADD=0x%x, CTRL_DATA=0x%x, RESP=0x%x\r\n",(addr&0x7f),cmd[0],cmd[1],flag);
    return (flag);
}

void aic23b_init(void){
    int flag=0;
    printf("*************************\r\nReset TLV320AIC23B\r\n*************************\r\n");
    AIC23B.frequency(150000);   
    flag = aic23b_send(AIC23B_ADDRESS,RESET_REFGISTER,RESET);
    wait(0.1);
    flag += aic23b_send(AIC23B_ADDRESS,POWER_DOWN_CONTROL,0);
    wait(0.1);
    flag += aic23b_send(AIC23B_ADDRESS,POWER_DOWN_CONTROL,1);
    wait(0.1);
    flag += aic23b_send(AIC23B_ADDRESS,DIGITAL_AUDIO_INTERFACE_FORMAT,(MASTER_MODE|INPUT_DATA_16_BIT_LENGTH|I2S_FORMAT));
    wait(0.1);
    flag += aic23b_send(AIC23B_ADDRESS,SAMPLE_RATE_CONTROL,((0x06<<2)|0x01/*(SR_USB_44_1_KHZ_MODE| BOSR_USB_44_1_KHZ_MODE| USE_USB_CLOCK_44_1_KHZ_MODE)*/));
    wait(0.1);
    flag += aic23b_send(AIC23B_ADDRESS,ANALOG_AUDIO_PATH_CONTROL,0x10);
    wait(0.1);
    flag += aic23b_send(AIC23B_ADDRESS,DIGITAL_AUDIO_PATH_CONTROL,0);
    wait(0.1);
    flag += aic23b_send(AIC23B_ADDRESS,DIGITAL_INTERFACE_ACTIVATION,DIGITAL_INTERFACE_ACTIVE);
    wait(0.1);
    flag += aic23b_send(AIC23B_ADDRESS,LEFT_CHANNEL_HEADPHONE_VOLUME_CONTROL,LHV_VOLUME_DEFAULT);
    wait(0.1);
    flag += aic23b_send(AIC23B_ADDRESS,RIGHT_CHANNEL_HEADPHONE_VOLUME_CONTROL,RHV_VOLUME_DEFAULT);
 
    if(!flag) printf("*************************\r\nReset OK\r\n*************************\r\n");
    else printf("*************************\r\nReset FAILED\r\n*************************\r\n");
}


void dac_out(void)
{
  
 volatile static unsigned short DAC_rptr;
volatile static unsigned long dataLR;
    if (DAC_diff > 18) {
            led2 = 0;
            short llp;        
            for(llp=0;llp < 9;llp++){
                if(I2S_GetLevel(LPC_I2S, I2S_TX_MODE)==TXFIFO_FULL)break;
                dataLR = (0xffff0000 & (DAC_fifo[DAC_rptr++]<<16))|(0x0000ffff & DAC_fifo[DAC_rptr++]);
                I2S_Send(LPC_I2S,dataLR);
                DAC_rptr &= RAM_LIMIT;
                DAC_diff -= 2;
            }
       
   }else led2 = 1;
   
}

void decode(void){
    volatile static unsigned short DAC_wptr=0;
    volatile static long int decode_buff;
    volatile long diff=0,diff2=0;
    while(1){
        
        volatile short buffLR;
        
        if((buffLR = 0xff & fgetc(infp))==EOF)break;
        buffLR |= 0xff00 & (fgetc(infp) << 8);
        diff = buffLR;
        DAC_fifo[DAC_wptr++]=(signed short)diff;      
        DAC_wptr &= RAM_LIMIT;
       // DAC_diff++;
        
        while (DAC_diff > RAM_LIMIT){
            led1 = 1;
        }   //wait
        led1=0;

        if((buffLR = 0xff & fgetc(infp))==EOF)break;
        buffLR |= 0xff00 & (fgetc(infp) << 8);
        diff = buffLR;
        DAC_fifo[DAC_wptr++]=(signed short)diff;      
        DAC_wptr &= RAM_LIMIT;
        DAC_diff+=2;
       
      

        
        while (DAC_diff > RAM_LIMIT){
            led1 = 1;
        }   //wait
        led1=0;

    
         
    }
}

  
int main() {

    mbed_i2s_init();    //DAC:44100Hz sampling ,16bit ,Stereo ,MCLK Disable, TLV320AIC23B=Master
    aic23b_init();

    
    
    pc.printf("CCLKCFG= %d \r\n",LPC_SC->CCLKCFG);
    pc.printf("I2S Send start.\r\n");
    led2=1;
 
    //infp = NULL;
    //
    while(1){      
        if ( NULL == (infp = fopen( "/sd/test.wav", "r" )) ) {
            printf( "\r\nError: The message file cannot be accessed\r\n" );
            return -1;
        }
        fseek(infp, 0L, SEEK_SET);
        tick.attach_us(&dac_out, 250); //set 32kHz/8(word FIFO) sampling data
        decode();
    
        fclose( infp );
        infp = NULL;    
        tick.detach();


        
    }
}


 