#ifndef I2S_IRQ_TEST_H_
#define I2S_IRQ_TEST_H_


#include "lpc_types.h"
#include "lpc17xx_i2s.h"
#include "lpc17xx_libcfg.h"
#include "lpc17xx_pinsel.h"
#include "debug_frmwrk.h"
//#include "i2s_irq_test.h"


/************************** PRIVATE DEFINITIONS *************************/
/** Max buffer length */
#define BUFFER_SIZE         0x400
/** I2S Buffer Source Address is AHBRAM1_BASE that used for USB RAM purpose, but
 * it is not used in this example, so this memory section can be used for general purpose
 * memory
 */
#define I2S_BUFFER_SRC      LPC_AHBRAM1_BASE //0x20080000
/** I2S Buffer Destination Address is (AHBRAM1_BASE + 0x100UL) that used for USB RAM purpose, but
 * it is not used in this example, so this memory section can be used for general purpose
 * memory
 */
#define I2S_BUFFER_DST      (I2S_BUFFER_SRC+0x1000UL) //0x20081000

#define RXFIFO_EMPTY        0
#define TXFIFO_FULL         8

extern "C" void I2S_IRQHandler(void);
//extern void Buffer_Init(void);
//extern Bool Buffer_Verify(void);
//extern void print_menu(void);
extern int c_entry(void);
extern void mbed_i2s_init(void);


extern volatile uint8_t  I2STXDone;
extern volatile uint8_t  I2SRXDone;

extern volatile uint32_t *I2STXBuffer;
extern volatile uint32_t *I2SRXBuffer;

extern volatile uint32_t I2SReadLength;
extern volatile uint32_t I2SWriteLength;

extern uint8_t tx_depth_irq;
extern uint8_t rx_depth_irq;
extern uint8_t dummy;


#endif