#include <stdio.h>
#include <string.h>
#include "device_depend.h"

#define bc_str_length 2048 // from 32 to 1024

BusInOut ledport(LED1, LED2, LED3, LED4);
Serial pc(USBTX, USBRX); // tx, rx
LocalFileSystem local("local");
FILE* ReadFile;
Ticker tick;

volatile static unsigned long msTicks;                            /* counts 1ms timeTicks */
char bc_str[bc_str_length];
int last_bc_num = 0;

void hardware_init(void){
	setup_systick();
	ledport.output();
}

void uart_print(char *str){
	pc.printf(str);
	return;
}

void uart_init(int baud_rate){
	
}

int uart_read(void){
	return pc.getc();
}

int time_millis(void){
	return msTicks;
}

void port_write(int port, int bit, int value){
	if((bit < 0)||(bit > 3))return;
	int i = ledport;
	if(value)
		i |= (1 << bit);
	else
		i &= ~(1 << bit);
	
	ledport = i; 
	return;
}

void bytecode_read_init(void){

	if(NULL == (ReadFile = fopen ("/local/Test.cla","rb"))){ uart_print(" ERROR:Can't read class File.\r\n"); while(1); }
	fseek(ReadFile, 0, SEEK_SET);
	// I don't know why, but fseek does not work right. So I use fgetc instead.
	//fgets(bc_str, bc_str_length, ReadFile);
	printf("loading...");
	for(int i = 0; i < bc_str_length; i++) bc_str[i] = fgetc(ReadFile);
	printf("end\r\n");
	//last_bc_num = bc_str_length;
}

char* bytecode_read(int bc_num, int length){
	
	if((last_bc_num <= bc_num)&&(bc_num < last_bc_num + bc_str_length)&&(length <= bc_str_length)){ // exists data in buffer
		return &bc_str[bc_num - last_bc_num];
	}else
	{
		fseek(ReadFile, bc_num, SEEK_SET);
		for(int i = 0; i < bc_str_length; i++)
		{
			bc_str[i] = fgetc(ReadFile);
		}
		last_bc_num = bc_num;
	}
	return bc_str;
}

/*----------------------------------------------------------------------------
  SysTick_Handler
 *----------------------------------------------------------------------------*/
void SysTickCount(void) {
  msTicks++;                        /* increment counter necessary in Delay() */
}

void setup_systick (void) {
	msTicks = 0;
	tick.attach_us(&SysTickCount, 1000); //set 32kHz/8(word FIFO) sampling data	}
}

