#include "mbed.h"

//extern void aic23b_init(void);
//extern int aic23b_send(int addr,char ctrl_address,char ctrl_data);

// Register map of TLV320AIC23B. See "TLV320AIC23B Data Manual" section 3.1.3
// I2C ADDRESS(MODE=0,CS=0)=0011010b 
#define AIC23B_ADDRESS  (52)
///////////////////////////////////////////////////////////////////////
// Control Address Bits 
#define LEFT_LINE_INPUT_CHANNEL_VOLUME_CONTROL      (0x00 << 1)
#define RIGHT_LINE_INPUT_CHANNEL_VOLUME_CONTROL     (0x01 << 1)
#define LEFT_CHANNEL_HEADPHONE_VOLUME_CONTROL       ((0x02 << 1)|1)
#define RIGHT_CHANNEL_HEADPHONE_VOLUME_CONTROL      ((0x03 << 1)|1)
#define ANALOG_AUDIO_PATH_CONTROL                   (0x04 << 1)
#define DIGITAL_AUDIO_PATH_CONTROL                  (0x05 << 1)
#define POWER_DOWN_CONTROL                          (0x06 << 1)
#define DIGITAL_AUDIO_INTERFACE_FORMAT              (0x07 << 1)
#define SAMPLE_RATE_CONTROL                         (0x08 << 1)
#define DIGITAL_INTERFACE_ACTIVATION                (0x09 << 1)
#define RESET_REFGISTER                             (0x0F << 1)
///////////////////////////////////////////////////////////////////////
// Control Data Bits
// LEFT_LINE_INPUT_CHANNEL_VOLUME_CONTROL(Address:0x00)
// (bit7)LIM:   Left line input mute 0=Normal 1=Muted
// (bit6)X:     Reserved
// (bit5)X:     Reserved
// (bit4)LIV4:
// (bit3)LIV3:
// (bit2)LIV2:
// (bit1)LIV1:
// (bit0)LIV0:  Left line input volume control(10111=0dB default)
#define LIM_MUTE_DISABLED   (0<<7)
#define LIV_VOLUME_DEFAULT  (0x17<<0)
// ----------------------------------------------------------------------
// RIGHT_LINE_INPUT_CHANNEL_VOLUME_CONTROL(Address:0x01)
// (bit7)RIM:   Right line input mute 0=Normal 1=Muted
// (bit6)X:     Reserved
// (bit5)X:     Reserved
// (bit4)RIV4:
// (bit3)RIV3:
// (bit2)RIV2:
// (bit1)RIV1:
// (bit0)RIV0:  Right line input volume control(10111=0dB default)
#define RIM_MUTE_DISABLED   (0<<7)
#define RIV_VOLUME_DEFAULT  (0x17<<0)
// ----------------------------------------------------------------------
// LEFT_CHANNEL_HEADPHONE_VOLUME_CONTROL(Address:0x02)
// (bit7)LZC:   Left-channel Zero-cross detect 0=Off 1=On
// (bit6)LHV6:
// (bit5)LHV5:
// (bit4)LHV4:
// (bit3)LHV3:
// (bit2)LHV2:
// (bit1)LHV1:
// (bit0)LHV0:  Left headphone volume control(1111001=0dB default,0110000=-73dB Mute)
#define LZC_ZERO_CROSS_DETECT_ON    (1<<7)
#define LHV_VOLUME_DEFAULT          100//(0x79<<0)
// ----------------------------------------------------------------------
// RIGHT_CHANNEL_HEADPHONE_VOLUME_CONTROL(Address:0x03)
// (bit7)RZC:   Right-channel Zero-cross detect 0=Off 1=On
// (bit6)RHV6:
// (bit5)RHV5:
// (bit4)RHV4:
// (bit3)RHV3:
// (bit2)RHV2:
// (bit1)RHV1:
// (bit0)RHV0:  Right headphone volume control(1111001=0dB default,0110000=-73dB Mute)
#define RZC_ZERO_CROSS_DETECT_ON    (1<<7)
#define RHV_VOLUME_DEFAULT          100//(0x79<<0)
// ----------------------------------------------------------------------
// ANALOG_AUDIO_PATH_CONTROL(Address:0x04)
// (bit7)STA1:   
// (bit6)STA0:
// (bit5)STE:   (See "TLV320AIC23B DATA MANUAL" pp.3-3)
// (bit4)DAC:   DAC select              0=DAC off   1=DAC on
// (bit3)BYP:   Bypass                  0=Disabled  1=Enabled
// (bit2)INSEL: Input select for ADC    0=Line,     1=Microphone  
// (bit1)MICM:  Microphone mute         0=Normal,   1=Muted
// (bit0)MICB:  Microphone boost        0=dB,       1=20dB
// ----------------------------------------------------------------------
// DIGITAL_AUDIO_PATH_CONTROL(Address:0x05)
// (bit7)X:         Reserved   
// (bit6)X:         Reserved
// (bit5)X:         Reserved
// (bit4)X:         Reserved
// (bit3)DACM:      DAC soft mute           0=Disabled  1=Enabled
// (bit2)DEEMP1:    
// (bit1)DEEMP0:    De-enphasis control     0=Normal,   1=Muted
// (bit0)ADCHP:     ADC high-pass filter    0=dB,       1=20dB
#define DAC_MUTE_DISABLED       (0<<3)
#define DE_EMPHASIS_DISABLED    (0x0 << 0)
#define DE_EMPHASIS_32_KHZ      (0x1 << 0)
#define DE_EMPHASIS_44_1_KHZ    (0x2 << 0)
#define DE_EMPHASIS_48_KHZ      (0x3 << 0)
// ----------------------------------------------------------------------
// POWER_DOWN_CONTROL(Address:0x06)
// (bit7)OFF:   Device power        0=On,   1=Off  
// (bit6)CLK:   Clock               0=On,   1=Off
// (bit5)OSC:   Oscillator          0=On,   1=Off
// (bit4)OUT:   Outputs             0=On,   1=Off
// (bit3)DAC:   DAC                 0=On,   1=Off
// (bit2)ADC:   ADC                 0=On,   1=Off
// (bit1)MIC:   Microphone input    0=On,   1=Off
// (bit0)LINE:  Line input          0=On,   1=Off
#define DEVICE_POWER_ON     (0<<7)
#define CLOCK_ON            (0<<6)
#define OSCILLATOR_ON       (0<<5)
#define OUTPUTS_ON          (0<<4)
#define DAC_ON              (0<<3)
#define ADC_ON              (0<<2)
#define MICROPHONE_INPUT_ON (0<<1)
#define LINE_INPUT_ON       (0<<0)
// ----------------------------------------------------------------------
// DIGITAL_AUDUIO_INTERFACE_FORMAT(Address:0x07)
// (bit7)X:         Reserved
// (bit6)MS:        Master/Slave mode       0=Slave,    1=Master
// (bit5)LRSWAP:    DAC left/right swap     0=Disabled, 1=Enabled
// (bit4)LRP:       0=R-ch ON,LRCLKIN high, 1=R-ch ON,LRCLKIN low
// (bit3)IWL1:
// (bit2)IWL0:      Input bit length        00=16bit,   01=20bit,   10=24bit,   11=32bit
// (bit1)FOR1:
// (bit0)FOR0:      Data format             11=DSP,     10=I2S,     01=MSB first left algn.,   00=MSB right algn.
#define MASTER_MODE                 (1<<6)
#define INPUT_DATA_16_BIT_LENGTH    (0x00<<2)
#define INPUT_DATA_20_BIT_LENGTH    (0x01<<2)
#define INPUT_DATA_24_BIT_LENGTH    (0x02<<2)
#define INPUT_DATA_32_BIT_LENGTH    (0x03<<2)
#define DSP_FORMAT                  (0x03<<0)
#define I2S_FORMAT                  (0x02<<0)
#define MSB_FIRST_LEFT_ALIGN        (0x01<<0)
#define MSB_FIRST_RIGHT_ALIGN       (0x00<<0)
// ----------------------------------------------------------------------
// SAMPLE_RATE_CONTROL(Address:0x08)
// (bit7)CLKOUT:    Clock output divider    0=MCLK, 1=MCLK/2
// (bit6)CLKIN:     Clock input divider     0=MCLK, 1=MCLK/2
// (bit5)SR3:
// (bit4)SR2:
// (bit3)SR1:
// (bit2)SR0:       (See "TLV320AIC23B DATA MANUAL" section 3.3.2.1 and 3.3.2.2)
// (bit1)BOSR:
// (bit0)USB/Normal:    Clock mode select   0=Normal,   1=USB
#define SR_USB_44_1_KHZ_MODE         (0x08<<2)
#define BOSR_USB_44_1_KHZ_MODE       (0x01<<1)
#define USE_USB_CLOCK_44_1_KHZ_MODE  (0x01<<0)
// ----------------------------------------------------------------------
// DIGITAL_INTERFACE_ACTIVATION(Address:0x09)
// (bit7)RES:
// (bit6)RES:
// (bit5)X:         Reserved
// (bit4)X:         Reserved
// (bit3)X:         Reserved
// (bit2)X:         Reserved
// (bit1)X:         Reserved
// (bit0)ACT:       Activate interface      0=Inactive, 1=Active
#define DIGITAL_INTERFACE_ACTIVE   (0x01<<0)
// ----------------------------------------------------------------------
// RESET_REGISTER(Address:0x0F)
// (bit7)RES:
// (bit6)RES:
// (bit5)RES:
// (bit4)RES:
// (bit3)RES:
// (bit2)RES:
// (bit1)RES:
// (bit0)RES:       Write 00000000 to this register triggers reset
#define RESET  (0x00<<0)
