/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "LPG_Config.h"
#include "stats_report.h"
#include "LPG_FlashIAP.h"
#include "LPG_ATCmd_Processing.h"
#include "LPG_LTEPin_Controller.h"

DigitalOut  Led_1(LED_1);
DigitalOut  Led_2(LED_2);
DigitalOut  Led_3(LED_3);

InterruptIn BTN_Test(BTN);

RawSerial ATCmdPort(UART_TX,UART_RX);
RawSerial DebugPort(D_UART_TX,D_UART_RX);

#define SLEEP_TIME                  500 // (msec)
#define PRINT_AFTER_N_LOOPS         20

bool flag_BTN = false;
char buf;
void BTN_Change_R()
{
    flag_BTN = true;
}


void BTN_Change_F()
{
    
}

void CallBackFunc() 
{
    while(ATCmdPort.readable()){
        DebugPort.putc(ATCmdPort.getc());
        /*ATCmdPort.putc(ATCmdPort.getc());*/ 
        
    }
}

void Initialize()
{
    ATCmdPort.baud(AT_UART_BR);
    DebugPort.baud(D_UART_BR);
    BTN_Test.rise(&BTN_Change_R);
    BTN_Test.fall(&BTN_Change_F);
    ATCmdPort.attach(&CallBackFunc,Serial::RxIrq);
    Led_1.write(0);    
    Led_2.write(0);
    Led_3.write(0);
    LPG_LTEPinControl_LTEPowerOn();
}



// main() runs in its own thread in the OS
int main()
{
    SystemReport sys_state( SLEEP_TIME * PRINT_AFTER_N_LOOPS /* Loop delay time in ms */);
    Initialize();
    int count = 0;
    int index  = 0;
    char buMat[100] = {0};
    
    //LPG_FlashIAP_InitIAP();
    while (true) {
        char* buf;
        if(index==0) buf = "TEST_0";
        else if(index==1) buf = "TEST_1";
        else if(index==2) buf = "TEST_2";
        else if(index==3) buf = "TEST_3";
        else if(index==4) buf = "TEST_4";
        else index = -1;
        DebugPort.puts(buf);
        DebugPort.puts("\r\n");
        LPG_FlashIAP_InitIAP();
        LPG_FlashIAP_WriteToFlash(&buf[0],0x0807C000,DebugPort);
        LPG_FlashIAP_DeInitIAP();
        // Blink LED and wait 0.5 seconds
        Led_1 = !Led_1;
        Led_2 = !Led_2;
        Led_3 = !Led_3;
        wait_ms(2000);
        //ATCmdPort.puts("ATI\r\n");
        //LPG_FlashIAP_WriteToFlash(&buf[0],0x0807C000,DebugPort);
        /*LPG_FlashIAP_ReadFromFlash(&buMat[0],0x0800BF00);
        DebugPort.puts(buMat);
        DebugPort.puts("\r\n");*/
        index++;
        if ((0 == count) || (PRINT_AFTER_N_LOOPS == count)) {
            // Following the main thread wait, report on the current system status
            sys_state.report_state();
            count = 0;
        }
        ++count;
    }
}
