
#include "mbed.h"
#include "LPG_Config.h"

typedef enum                /*枚举类型：接收的状态*/
{
    e_SUCCESS_REC = 0,      /*成功*/
    e_TIME_OUT,             /*超时*/
    e_NO_REC                /*未收到*/
}teATStatus;

typedef struct              /*定义的数据结构,用数据结构来完成AT指令的发送、应答、超时、状态、重发*/
{
    char* st_ATSendStr;     /*向NB-IOT发送字符串（AT命令）*/
    char *st_ATRecStr;      /*NB-IOT返回给MCU的字符串*/
    uint16_t st_TimeOut;    /*设置超时*/
    teATStatus st_ATStatus; /*接收状态*/
    uint8_t st_RtyNum;      /*重发次数*/
}tsATCmds;

typedef enum{
  e_ATCFUN0,  
  e_ATCFUN1,
  e_ATGATT1
}teATCmdNum;

void LPG_ATCmd_Processing_WriteCommand(const char* command, RawSerial TransPort, RawSerial DebugPort);
void LPG_ATCmd_Processing_WriteCommand(const char* command, RawSerial TransPort);
void LPG_ATCmd_Processing_Receive();




