#include "LPG_FlashIAP.h"

FlashIAP flash;

void LPG_FlashIAP_InitIAP()
{
    flash.init();
}

void LPG_FlashIAP_DeInitIAP()
{
    flash.deinit();
}

void LPG_FlashIAP_WriteToFlash(char* buffer, uint32_t addr,RawSerial DebugPort)
{
    /* 目前erase成功，但寫入不會在同一位址上會連續 */
    int sector = flash.get_sector_size(addr);
    int eraseResult = flash.erase(addr,sector);
    //DebugPort.printf("eraseResult : %s\r\n",((eraseResult==0)?"Sucess":"Fail"));
    DebugPort.puts("eraseResult:");
    DebugPort.puts(((eraseResult==0)?"Sucess":"Fail"));
    DebugPort.puts("\r\n");
    int programResult = flash.program(buffer,addr,sizeof(char)*7);
    //DebugPort.printf("programResult : %s\r\n",((programResult==0)?"Sucess":"Fail"));
    DebugPort.puts("programResult:");
    DebugPort.puts(((programResult==0)?"Sucess":"Fail"));
    DebugPort.puts("\r\n");
    //flash.deinit();
}

void LPG_FlashIAP_ReadFromFlash(char* buffer,uint32_t addr)
{
    flash.read(buffer,addr,sizeof(uint32_t));
}