#include <jsonlite.h>
#include "M2XStreamClient.h"

#include "mbed.h"
#include "cc3000.h"

#define DEBUG 1
#if DEBUG
  #define dprintf printf
#else
  #define dprintf(...)
#endif

char feedId[] = "<feed id>"; // Feed you want to post to
char m2xKey[] = "<m2x api key>"; // Your M2X access key
char streamName[] = "<stream name>"; // Stream you want to post to

char SSID[] = "your_ssid";
char KEY[] = "your_key";
//Adafruit CC3000 shield on Arduino pin definitions.
cc3000 net(D3, D5, D10, SPI(D11, D12, D13), SSID, KEY, WPA2, false);
Serial pc(USBTX, USBRX);

Client client;
M2XStreamClient m2xClient(&client, m2xKey);

typedef struct scanResults {
  unsigned long numNetworksFound;
  unsigned long results;
  unsigned isValid:1;
  unsigned rssi:7;
  unsigned securityMode:2;
  unsigned ssidLength:6;
  unsigned short frameTime;
  unsigned char ssid_name[32];
  unsigned char bssid[6];
} scanResults;

/** return RSSI in dBm for given ssid if found.  returns 0 on failure */
int8_t getRSSI(char *ssid, int len) {
  int ret;
  scanResults sr;
  int apCounter;
  
  //TODO request a scan
  
  if ((ret = net._wlan.ioctl_get_scan_results(2000, (unsigned char *)&sr)) != 0) {
    printf("get scan results failed ret=%d\r\n", ret);
    return 0;
  }
  apCounter = sr.numNetworksFound;
  dprintf("APs found: %d\r\n", apCounter);

  do {
    if (sr.isValid) {
      if (DEBUG) {
        char ssidbuf[32];
        memcpy(ssidbuf, sr.ssid_name, sr.ssidLength);
        ssidbuf[sr.ssidLength] = 0;
        dprintf("ssid=%s rssi=%3d\r\n", ssidbuf, sr.rssi);
      }
      if (memcmp(ssid, sr.ssid_name, len) == 0) {
        return sr.rssi - 128;
      }
    }
    if (--apCounter> 0) {
      if ((ret = net._wlan.ioctl_get_scan_results(2000, (unsigned char *)&sr)) != 0) {
        printf("get scan results failed ret=%d\r\n", ret);
        return 0;
      }
    }
  } while (apCounter > 0);
  dprintf("End of AP list.\r\n");
  return 0;
}

void on_data_point_found(const char* at, const char* value, int index, void* context) {
  //TODO value is wrong. check m2x library
  printf("Found a data point, index: %d\r\n", index);
  printf("At: %s Value: %s\r\n", at, value);
}

int main() {
  pc.baud(115200);
  
  if (DEBUG) {
    // allow time to get a serial console
    for (int i=10; i>=0; i--) {
      wait(0.5);
      dprintf("Starting in %d\r\n", i);
    }
  }

  printf("net.init...\r\n");
  net.init();
  printf("net.init done\r\n");
  if (net.connect() == -1) {
    printf("Failed to connect. Please verify connection details and try again.\r\n");
  } else {
    printf("net.connect done. IP address: %s \r\n", net.getIPAddress());
  }

  int rssi;
  int i = 0;
  
  while (++i < 10) {
  
    // read RSSI
    rssi = getRSSI(SSID, sizeof(SSID) - 1);
    if (rssi == 0) {
        printf("Failed to get RSSI\r\n");
        delay(30000);
        continue;
    }

    // post RSSI
    dprintf("Posting rssi=%d\r\n", rssi);
    int response = m2xClient.post(feedId, streamName, rssi);
    printf("Post response code: %d\r\n", response);
    if (response == -1) while (true) ;
    
    // read RSSI
    dprintf("Reading rssi\r\n");
    response = m2xClient.fetchValues(feedId, streamName, on_data_point_found, NULL, NULL, NULL, "5");
    printf("Fetch response code: %d\r\n", response);
    if (response == -1) while (true) ;

    // wait 30 secs and then loop
    delay(30000);
  }
  dprintf("Exiting\r\n");
  net.disconnect();
}