#include "mbed.h"
#include "WiflyInterface.h"
#include "C12832_lcd.h"
#include "nsdl_support.h"
#include "dbg.h"
#include "rtos.h"
// Include various resources
//#include "temperature.h"
#include "light.h"
//#include "gps.h"
//#include "relay.h"

static C12832_LCD lcd;
Serial pc(USBTX, USBRX); // tx, rx

// ****************************************************************************
// Configuration section

// WiFi configuration (edit this)
#define WIFI_SSID               "WIFITest"
#define WIFI_SECURITY           WPA    // NONE, WEP_128 or WPA
#define WIFI_PASSWORD           "54510000"
             
/* Define this to enable DHCP, otherwise manual address configuration is used */
#define DHCP

/* Manual IP configurations, if DHCP not defined */
#define IP      "10.45.0.206"
#define MASK    "255.255.255.0"
#define GW      "10.45.0.1"

// NSP configuration
/* Change this IP address to that of your NanoService Platform installation */
//static const char* NSP_ADDRESS = "208.111.39.209";
static const char* NSP_ADDRESS = "23.97.178.38"; /* demo NSP, web interface at http://nanoservice-demo.mbed.org*/ 
static const int NSP_PORT = 5683;
char endpoint_name[32] = "mbed-";
uint8_t ep_type[] = {"mbed_device"};
uint8_t lifetime_ptr[] = {"1200"};

// ****************************************************************************
// WiFi initialization

static WiflyInterface wifly(D1, D0, D3, D2, "WIFITest", "54510000", NONE);

static void wifi_init()
{
    char mbed_uid[33]; // for creating unique name for the board
    char macbytes[6];
 
    /* Initialize network */
#ifdef DHCP
    NSDL_DEBUG("DHCP in use\r\n");
    wifly.init();
#else
    wifly.init(IP, MASK, GW);
#endif
    lcd.printf("wifly.init done\r\n");
    
    if(wifly.connect() == 0)
        lcd.printf("Connect OK\n\r");
 
    mbed_mac_address(macbytes);
    sprintf(mbed_uid,"%02x%02x%02x%02x%02x%02x", macbytes[0], macbytes[1], macbytes[2], macbytes[3], macbytes[4], macbytes[5]); 
    strncat(endpoint_name, mbed_uid, 12);
 
 
    lcd.printf("IP Address:%s ", wifly.getIPAddress());
    lcd.cls();
    lcd.locate(0,0);
}

// ****************************************************************************
// NSP initialization

UDPSocket server;
Endpoint nsp;

static void nsp_init()
{
    server.init();
    server.bind(NSP_PORT);

    nsp.set_address(NSP_ADDRESS, NSP_PORT);
    
    NSDL_DEBUG("name: %s", endpoint_name);
    NSDL_DEBUG("NSP=%s - port %d\n", NSP_ADDRESS, NSP_PORT);

    lcd.locate(0,22);
    lcd.printf("EP name:%s\n", endpoint_name);
}

// ****************************************************************************
// Resource creation

static int create_resources()
{
    sn_nsdl_resource_info_s *resource_ptr = NULL;
    sn_nsdl_ep_parameters_s *endpoint_ptr = NULL;
    
    NSDL_DEBUG("Creating resources");

    /* Create resources */
    resource_ptr = (sn_nsdl_resource_info_s*)nsdl_alloc(sizeof(sn_nsdl_resource_info_s));
    if(!resource_ptr)
        return 0;
    memset(resource_ptr, 0, sizeof(sn_nsdl_resource_info_s));

    resource_ptr->resource_parameters_ptr = (sn_nsdl_resource_parameters_s*)nsdl_alloc(sizeof(sn_nsdl_resource_parameters_s));
    if(!resource_ptr->resource_parameters_ptr)
    {
        nsdl_free(resource_ptr);
        return 0;
    }
    memset(resource_ptr->resource_parameters_ptr, 0, sizeof(sn_nsdl_resource_parameters_s));

    // Static resources
    nsdl_create_static_resource(resource_ptr, sizeof("dev/mfg")-1, (uint8_t*) "dev/mfg", 0, 0,  (uint8_t*) "Sensinode", sizeof("Sensinode")-1);
    nsdl_create_static_resource(resource_ptr, sizeof("dev/mdl")-1, (uint8_t*) "dev/mdl", 0, 0,  (uint8_t*) "NSDL-C mbed device", sizeof("NSDL-C mbed device")-1);

    // Dynamic resources
    //create_temperature_resource(resource_ptr);
    create_light_resource(resource_ptr);
    //create_gps_resource(resource_ptr);
    //create_relay_resource(resource_ptr);

        /* Register with NSP */
    endpoint_ptr = nsdl_init_register_endpoint(endpoint_ptr, (uint8_t*)endpoint_name, ep_type, lifetime_ptr);
    if(sn_nsdl_register_endpoint(endpoint_ptr) != 0)
        pc.printf("NSP registering failed\r\n");
    else
        pc.printf("NSP registering OK\r\n");
    nsdl_clean_register_endpoint(&endpoint_ptr);

    nsdl_free(resource_ptr->resource_parameters_ptr);
    nsdl_free(resource_ptr);
    return 1;
}

// ****************************************************************************
// Program entry point

int main()
{
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("mbed NanoService demo\r\n");
    NSDL_DEBUG("mbed NanoService Example App 0.1\n");
    
    // Initialize Ethernet interface first
    wifi_init();
    
    // Initialize NSP node
    nsp_init();
    
    // Initialize NSDL stack
    nsdl_init();
    
    // Create NSDL resources
    create_resources();
    
    // Run the NSDL event loop (never returns)
    nsdl_event_loop();
}