// Light resource implementation

#include "mbed.h"
#include "nsdl_support.h"
#include "light.h"

//#define LIGHT_RES_ID    "lt/0/dim"
#define LIGHT_RES_ID    "11100/0/5900"

extern Serial pc;
char leds[] = {"1111"}; //YGBR

DigitalOut grn(LED1);
DigitalOut red(LED2);
DigitalOut blu(LED3);
DigitalOut yel(LED4);

void set_leds(char *leds)
{
int leds_int ;

    sscanf(leds, "%x", &leds_int);
    
    grn = ~leds_int & 1;
    red = ~leds_int >> 4 & 1;
    blu = ~leds_int >> 8 & 1;
    yel = ~leds_int >> 12 & 1;
}


/* Only GET and PUT method allowed */
static uint8_t light_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;

    //pc.printf("LED Strip callback\r\n");

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

        coap_res_ptr->payload_len = strlen(leds);
        coap_res_ptr->payload_ptr = (uint8_t*)leds;
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    }
    else if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_PUT)
    {
        //pc.printf("PUT: %d bytes\r\n", received_coap_ptr->payload_len);
        if(received_coap_ptr->payload_len == 4)
        {
            memcpy(leds, (char *)received_coap_ptr->payload_ptr, received_coap_ptr->payload_len);

            leds[received_coap_ptr->payload_len] = '\0';
            pc.printf("PUT: %s\r\n",leds);

            //call LED strup update function here
            set_leds(leds);

            coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CHANGED);
            sn_nsdl_send_coap_message(address, coap_res_ptr);
        }
    }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    return 0;
}

int create_light_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    nsdl_create_dynamic_resource(resource_ptr, sizeof(LIGHT_RES_ID)-1, (uint8_t*)LIGHT_RES_ID, 0, 0, 0, &light_resource_cb, (SN_GRS_GET_ALLOWED | SN_GRS_PUT_ALLOWED));
    return 0;
}