#include<mbed.h>
#include<string.h>
#include<math.h>
#include<stdlib.h>
#include "mbed.h"
#include "ble/BLE.h"
#include "Servo.h"
#include "GattCallbackParamTypes.h"

#define BLE_UUID_TXRX_SERVICE            0x0000 /**< The UUID of the Nordic UART Service. */
#define BLE_UUID_TX_CHARACTERISTIC       0x0002 /**< The UUID of the TX Characteristic. */
#define BLE_UUIDS_RX_CHARACTERISTIC      0x0003 /**< The UUID of the RX Characteristic. */

#define TXRX_BUF_LEN                     20

#define DIGITAL_OUT_PIN                  P0_20  //D7
#define DIGITAL_IN_PIN                   P0_29  //A4
#define PWM_PIN                          P0_19  //D6
#define SERVO_PIN                        P0_22  //D10
#define ANALOG_IN_PIN                    P0_1   //A5

BLE             ble;
DigitalOut      LED(DIGITAL_OUT_PIN);
DigitalIn       BUTTON(DIGITAL_IN_PIN);
//PwmOut          PWM(PWM_PIN);
AnalogIn        ANALOG(ANALOG_IN_PIN);
Servo           MYSERVO(SERVO_PIN);

SPI             spi_master(P0_6,P0_5,P0_7); //mosi miso sclk 
DigitalOut      cs(P0_4);

Serial pc(P0_23,P0_25);

static uint8_t analog_enabled = 0;
static uint8_t old_state = 0;

uint16_t x_a,y_a,z_a;
bool flag = 0;


// The Nordic UART Service
static const uint8_t uart_base_uuid[] = {0x71, 0x3D, 0, 0, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_tx_uuid[]   = {0x71, 0x3D, 0, 3, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_rx_uuid[]   = {0x71, 0x3D, 0, 2, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_base_uuid_rev[] = {0x1E, 0x94, 0x8D, 0xF1, 0x48, 0x31, 0x94, 0xBA, 0x75, 0x4C, 0x3E, 0x50, 0, 0, 0x3D, 0x71};


uint8_t txPayload[TXRX_BUF_LEN] = {0,};
uint8_t rxPayload[TXRX_BUF_LEN] = {0,};

//static uint8_t rx_buf[TXRX_BUF_LEN];
//static uint8_t rx_len=0;


GattCharacteristic  txCharacteristic (uart_tx_uuid, txPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
                                      
GattCharacteristic  rxCharacteristic (uart_rx_uuid, rxPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
                                      
GattCharacteristic *uartChars[] = {&txCharacteristic, &rxCharacteristic};

GattService         uartService(uart_base_uuid, uartChars, sizeof(uartChars) / sizeof(GattCharacteristic *));



void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    pc.printf("Disconnected \r\n");
    pc.printf("Restart advertising \r\n");
    ble.startAdvertising();
}

void WrittenHandler(const GattWriteCallbackParams *Handler)
{   
    uint8_t buf[TXRX_BUF_LEN];
    uint16_t bytesRead, index;
    if (Handler->handle == txCharacteristic.getValueAttribute().getHandle()) 
    {
        ble.readCharacteristicValue(txCharacteristic.getValueAttribute().getHandle(), buf, &bytesRead);
        memset(txPayload, 0, TXRX_BUF_LEN);
        memcpy(txPayload, buf, TXRX_BUF_LEN);       
        
        for(index=0; index<bytesRead; index++)
            pc.putc(buf[index]);
            
        if(buf[0]==0xA0){
            if(buf[1]==0x01)
            {
                analog_enabled=1;
            }
            else
                analog_enabled=0;
        }    
        
     }
}

 
   
uint8_t LIS3DH_SPI_RD(uint8_t addr)
{
    uint8_t  temp;
    cs = 0;
    wait_us(10);
    spi_master.write(addr);      
    temp=spi_master.write(0xff);
    wait_us(10);
    cs = 1;
    return temp;
}

void LIS3DH_SPI_WR(uint8_t addr,uint8_t wrdata)
{  
    cs = 0;
    wait_us(10);
    spi_master.write(addr);
    spi_master.write(wrdata);
    wait_us(10);
    cs = 1;
}

void SPI_LIS3DH_Init()
{
   spi_master.format(8,3);
   spi_master.frequency(100000);
   wait_ms(5);
   LIS3DH_SPI_WR(0x24,0x80);
   wait_ms(5);
   LIS3DH_SPI_WR(0x20,0x17);
   LIS3DH_SPI_WR(0x23,0x80);
}

void get_val(void)
{
    uint8_t Dx_L=1,Dy_L=1,Dz_L=1;
    uint8_t Dx_H=1,Dy_H=1,Dz_H=1;
    if(LIS3DH_SPI_RD(0x0f|0x80)==0x33)
    {
         printf("check device ok!\r\n");
         flag=1;
         Dx_H=LIS3DH_SPI_RD(0x29|0x80);   
         Dx_L=LIS3DH_SPI_RD(0x28|0x80);
         Dy_H=LIS3DH_SPI_RD(0x2b|0x80);
         Dy_L=LIS3DH_SPI_RD(0x2A|0x80);
         Dz_H=LIS3DH_SPI_RD(0x2d|0x80);
         Dz_L=LIS3DH_SPI_RD(0x2C|0x80);  
    }
    else
    { 
        printf("check device err!\r\n");
        wait(1);
    }
    x_a=Dx_H<<8|Dx_L/16;
    y_a=Dy_H<<8|Dy_L/16;
    z_a=Dz_H<<8|Dz_L/16;
}

void m_status_check_handle(void)
{   
    uint8_t buf[3];
    LED=1;
    if (analog_enabled)  // if analog reading enabled
    {
        // Read and send out
        get_val();
        if (flag)
        {   
            if (abs(x_a)>1000)
                LED=0;
            buf[0] = (0x0A);
            buf[1] = (x_a >> 8);
            buf[2] = (x_a);
            ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), buf, 3); 
            wait_us(100);
            
            buf[0] = (0x0B);
            buf[1] = (y_a >> 8);
            buf[2] = (y_a);
            ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), buf, 3); 
            wait_us(100);
            
            buf[0] = (0x0C);
            buf[1] = (z_a >> 8);
            buf[2] = (z_a);
            ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), buf, 3); 
            wait_us(100);
            
            flag=0;
            wait_us(100);    
        }
       
    }
}
 


int main(void)
{
    uint8_t buf[3];
        
    SPI_LIS3DH_Init();
  
    Ticker ticker;
    ticker.attach_us(m_status_check_handle, 200000);
    
    ble.init();
    ble.onDisconnection(disconnectionCallback);
    ble.onDataWritten(WrittenHandler);  
    
    pc.baud(9600);
    pc.printf("SimpleChat Init \r\n");

    // setup advertising 
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                    (const uint8_t *)"MolCom", sizeof("MolCom") - 1);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                    (const uint8_t *)uart_base_uuid_rev, sizeof(uart_base_uuid));
    // 100ms; in multiples of 0.625ms. 
    ble.setAdvertisingInterval(160);

    ble.addService(uartService);
    
    ble.startAdvertising(); 
    
    pc.printf("Advertising Start \r\n");
    
    while(1)
    {
        ble.waitForEvent(); 
    }
}
