#include "mbed.h"
#include "MobileLCD.h"
MobileLCD lcd(p5, p6, p7, p8, p9);
Serial pc(USBTX, USBRX); // tx, rx

// ********************************************************************************
// * Startup variables
// ********************************************************************************
//Ball speed
int speedh;
int speedv;

//Ball position
int ballx = 5;
int bally = 65;

//Score
int scorel;
int scorer;

//Paddle size
const int paddle = 30;

//Win level
const int winner = 3;

//Paddle position
int lefty = 53;
int righty = 50;

//Joystick position & input variables
AnalogIn inl(p20);
AnalogIn inr(p19);
float joystickl;
float joystickr;

// Number of players
int players = 0;

// Loop until winner declared
int playing = 1;

const int ballcolour = 0xFFFFFF;

// ********************************************************************************

// ********************************************************************************
// * Display score, wait & wipe
// ********************************************************************************
void displayScore( int left, int right ) {
    lcd.locate ( 3, 2 ) ;
    lcd.printf( "%i       %i ",left,right );
    //Check if we have a winner
    if ( left == winner) {
        lcd.locate( 3,4 );
        lcd.printf( "Left won!" );
        playing = 0;
        lcd.fill(0, 0, 5, 130, 0x0000FF);    //left
        lcd.fill(126, 0, 4, 130, 0x000FFF); //right
        wait(2);
    }
    if ( right == winner) {
        lcd.locate( 3,4 );
        lcd.printf( "Right won!" );
        playing = 0;
        lcd.fill(0, 0, 5, 130, 0x0000FF);    //left
        lcd.fill(126, 0, 4, 130, 0x000FFF); //right
        wait(2);
    }
    wait( 2 );
    lcd.fill(13, 0, 110, 25, 0x0000FF);
}
// ********************************************************************************


// ********************************************************************************
// * Setup screen to start
// ********************************************************************************
void startup( void ) {
    //speed
    speedh = 1;
    speedv = -1;

    //Score
    scorel = 0;
    scorer = 0;

    // *** Screen ***
    lcd.background(0x0000FF);
    lcd.cls();
    lcd.fill(1, lefty, 4, paddle, 0x00FF00);    //left
    lcd.fill(126, righty, 4, paddle, 0x00FF00); //right
    lcd.fill(ballx, bally, 4, 4, ballcolour); //ball
    displayScore(scorel,scorer);


    // *** Calibrate analog in ***
    // * Start game at higheest voltage level for both inpout pins

}
// ********************************************************************************


// ********************************************************************************
//  Move the Ball
// ********************************************************************************
void moveBall ( void ) {

    int retVal =0;

    //Remove ball from screen
    lcd.fill( ballx,bally,4,4,0x0000FF );

    // Normal x movement
    if ( (ballx + speedh > 4) && (ballx + speedh < 122)) {
        ballx = ballx + speedh;

    } else {
        //Bounce off right paddle
        if (ballx+speedh >= 122) {
            if ( (bally>righty)&&(bally<righty+paddle) ) {
                ballx=122;
                speedh=speedh*(-1);
                ballx=ballx+speedh;
            } else {
                //Left scores
                scorel = scorel + 1;
                displayScore( scorel,scorer );
                //Ball speed
                speedh = -1;
                speedv = +1;

                //Ball position
                ballx = 122;
                bally = righty+(paddle/2);
            }
        }
        //Bounce off left paddle
        if (ballx+speedh <=4) {

            if ( (bally>lefty)&&(bally<lefty+paddle) ) {
                ballx=4;
                speedh=speedh*(-1);
                ballx=ballx+speedh;
            } else { //Right scores
                scorer = scorer + 1;
                displayScore( scorel,scorer );
                //Ball speed
                speedh = 1;
                speedv = -1;

                //Ball position
                ballx = 5;
                bally = lefty+(paddle/2);
            }
        }
    } //else


    // Normal y movement
    if ( (bally + speedv > 0) && (bally + speedv < 126)) {
        bally = bally + speedv;

    } else {
        // Bounce bottom
        if ( bally + speedv >= 126 ) {
            bally = 125;
            speedv = speedv*(-1);
            bally = bally + speedv;
        }
        // Bounce top
        if (bally + speedv <= 0 ) {
            bally = 0;
            speedv = speedv*(-1);
            bally = bally + speedv;

        }
    } // else

    // Draw ball if it is to be moved
    if ( retVal == 0 ) {
        lcd.fill(ballx, bally, 4, 4, ballcolour); //ball
    }

}

// ********************************************************************************
//  Move the Paddles
// ********************************************************************************

void movePaddles( void ) {

    //*** Left ***

    lcd.fill(1, lefty, 4, paddle, 0x0000FF);    //Clear paddle
    //Read paddle if 2 player
    if ( players == 2 ) {
        joystickl = inl.read();
        joystickl = joystickl * 100;
        joystickl = 53 - joystickl;
        lefty = joystickl*(130/47);
    } else {
        if ( lefty>bally ) {
            lefty--;
        }
        if ( lefty<bally ) {
            lefty++;
        }
    }
    //Auto move paddle if 1 player


    if ( lefty <0 ) {
        lefty = 0;
    }
    if ( lefty > (130-paddle) ) {
        lefty=130-paddle;
    }

    lcd.fill(1, lefty, 4, paddle, 0x00FF00);    //Draw paddle

    //*** Right ***
    lcd.fill(126, righty, 4, paddle, 0x0000FF);    //Clear paddle
    joystickr = inr.read();
    joystickr = joystickr * 100;
    joystickr = 53 - joystickr;
    righty = joystickr*(130/47);
    if ( righty <0 ) {
        righty = 0;
    }
    if ( righty > (130-paddle) ) {
        righty=130-paddle;
    }
    lcd.fill(126, righty, 4, paddle, 0x00FF00);     //Draw paddle
}
// ********************************************************************************

// ********************************************************************************
//  Main menu
// ********************************************************************************
void menu( void ) {
    //Read right joystick level, change will start game
    joystickr = inr.read();
    joystickr = joystickr * 100;
    joystickr = 53 - joystickr;
    float startr = joystickr*(130/47);

    //Display menu options, control with left joystick
    lcd.background(0x0000FF);
    lcd.cls();
    lcd.locate( 5,3 );
    lcd.printf( "mPong" );
    lcd.locate( 1,12 );
    lcd.printf( "(left=choose;");
    lcd.locate( 1,13 );
    lcd.printf( " right=start)" );
    int choose = 1;
    while ( choose==1 ) {

        //*** Left ***
        joystickl = inl.read();
        joystickl = joystickl * 100;
        joystickl = 53 - joystickl;
        lefty = joystickl*(130/47);

        if ( lefty < 44 ) {
            lcd.background( 0x550000 );
            lcd.locate (1,6);
            lcd.printf( "Single Player");
            lcd.background( 0x0000FF );
            lcd.locate (1,7);
            lcd.printf( "Double Player");
            players = 1;
        } else {
            lcd.background(  0x0000FF );
            lcd.locate (1,6);
            lcd.printf( "Single Player");
            lcd.background( 0x550000 );
            lcd.locate (1,7);
            lcd.printf( "Double Player");
            players = 2;
        }
        wait(0.1);

        //Read right joystick level, change will start game
        joystickr = inr.read();
        joystickr = joystickr * 100;
        joystickr = 53 - joystickr;
        joystickr = joystickr*(130/47);

        if ( (startr - joystickr) > 10 || (startr - joystickr ) < -10 ) {
            // Start game
            choose = 0;
            //Nice screen clear
            for ( choose=0; choose <65; choose++ ) {
                lcd.fill(65-choose, 0, 1, 130, 0x0000FF);
                lcd.fill(65+choose, 0, 1, 130, 0x0000FF);
                wait(0.02);
                playing=1;
            }
        }

    }
}
// ********************************************************************************
int main() {
    while ( 1 ) {

        menu();
        startup();

        // Main Loop
        while (playing == 1) {
            moveBall();
            movePaddles();
            wait(0.02);
        } // while playing

    } // while 1
}
