#include "Led_Lcd.h"
#include "LCD_DISCO_F429ZI.h"

LCD_DISCO_F429ZI lcd;

LedLcd::LedLcd(unsigned char ucColumnPosition){
    lcd.Clear(LCD_COLOR_BLACK);
    ucColumnIndex = (80 * ucColumnPosition);
}

void LedLcd::On(unsigned char ucLedIndex){
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.FillRect(ucColumnIndex, 0, 80, 320);
    unsigned char ucRectangleCounter;
    for (ucRectangleCounter = 0; ucRectangleCounter < 4; ucRectangleCounter++){
        lcd.SetTextColor(LCD_COLOR_BLUE);
        lcd.FillRect((1+ucColumnIndex), (1+80*ucRectangleCounter), 78, 78);
    }

    lcd.SetTextColor(LCD_COLOR_YELLOW);
    
    if((ucLedIndex == 0) || (ucLedIndex == 1) || (ucLedIndex == 2) || (ucLedIndex == 3)){
        lcd.FillRect((ucColumnIndex+1), (1+80*ucLedIndex), 78, 78);
    }
    else {
    }
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetFont(&Font24);
    lcd.DisplayStringAt(ucColumnIndex, 0, (uint8_t *)"0", LEFT_MODE);
    lcd.DisplayStringAt(ucColumnIndex, 80, (uint8_t *)"1", LEFT_MODE);
    lcd.DisplayStringAt(ucColumnIndex, 160, (uint8_t *)"2", LEFT_MODE);
    lcd.DisplayStringAt(ucColumnIndex, 240, (uint8_t *)"3", LEFT_MODE);
    
}
