#include "Keyboard_Ts.h"
#include "TS_DISCO_F429ZI.h"

TS_DISCO_F429ZI ts;

KeyboardTs::KeyboardTs(unsigned char ucColumnPosition){
    ts.Init(240, 320);
    ucColumnIndex = ucColumnPosition;
}

enum State KeyboardTs::eRead(void){
    TS_StateTypeDef TS_State;
    ts.GetState(&TS_State);
    uint16_t x, y;
    x = TS_State.X;
    y = TS_State.Y;
    if(TS_State.TouchDetected){
        if ((x > (ucColumnIndex*80)) && (x < ((ucColumnIndex+1)*80))){
            if((y < 80) && (y > 0)){
                return BUTTON_0;
            }
            else if((y > 80) && (y < 160)){
                return BUTTON_1;
            }
            else if((y > 160) && (y < 240)){
                return BUTTON_2;
            }
            else if(y > 240){
                return BUTTON_3;
            }
            else {
                return RELASED;
            }
        }
        else {
            return RELASED;
        }
    }
    else{
        return RELASED;
    }
}
