/* Moving the rectangle previewed on the OLED display
 * by using potentiometers POT1 and POT2
 * 
 * November, 2021.
 */
#include "mbed.h"
#include "Adafruit_GFX.h"
#include "Adafruit_GFX_Config.h"
#include "Adafruit_SSD1306.h"
 
// I2C bus pins:
#define D_SDA                                                              PB_14 
#define D_SCL                                                              PB_13     
// I2C address, 60d or 0x3c:
#define I2C_REAL_ADD                                                        0x3c
#define I2C_ADDRESS                                            I2C_REAL_ADD << 1 
// Set OLED width and heigth [pixel]:
#define OLED_WIDTH_PX                                                        128
#define OLED_HEIGHT_PX                                                        64
// I2C frequency:
#define I2C_FREQUENCY                                                     400000
// Multipliers of POT1 and POT2 for OLED rectangle position:
#define WIDTH_SCALER                                                         128
#define HEIGHT_SCALER                                                         64
// Initial rectangle position:
#define INITIAL_X_POSITION                                     OLED_WIDTH_PX / 2
#define INITIAL_Y_POSITION                                    OLED_HEIGHT_PX / 2
// Refresh rate:
#define REFRESH_RATE_MS                                                        5
// Half of the potentiometer return value: 
#define HALF_INTERVAL                                                       0.5f
// x and y max values
#define XMAX                                                                 127
#define YMAX                                                                  63
#define XMIN                                                                   0
#define YMIN                                                                   0   
 
// Initialize potentiometers' pins:
AnalogIn POT1(PA_0);
AnalogIn POT2(PA_1);
 
// Initialize I2C:
I2C i2c(D_SDA,D_SCL);
 
// Initialize OLED display:
Adafruit_SSD1306_I2c myOled(i2c,PB_5,I2C_ADDRESS,OLED_HEIGHT_PX,OLED_WIDTH_PX);

void screenSaver(){
    int x = 7, y = 12, r = 5, xk = 1, yk = 1, dx = 4, dy = 3;
    
    while(true){
        myOled.drawRect(0, 0, OLED_WIDTH_PX - 1, OLED_HEIGHT_PX - 1, WHITE);
        
        if((x - r) <= XMIN) xk = 1;
        if((x + r) >= XMAX) xk = -1;
        
        if((y - r) <= YMIN) yk = 1;
        if((y + r) >= YMAX) yk = -1;
        
        y += dy * yk;
        x += dx * xk;      
        
        myOled.fillCircle(x, y, r, WHITE);
        
        myOled.display();
        
        wait_ms(REFRESH_RATE_MS);
        myOled.clearDisplay();
    }     
}

void bounce(){
     int x = 7, y = 12, r = 5, xk = 1, yk = 1, dx = 4, dy = 3, g = 3;
     
    while(true){
        myOled.drawRect(0, 0, OLED_WIDTH_PX - 1, OLED_HEIGHT_PX - 1, WHITE);
        
        if((x - r) <= XMIN) xk = 1;
        if((x + r) >= XMAX) xk = -1;
        
        if((y + r) <= YMAX){
            dy += g;
            y += dy;
        } else {
            dy = -dy;
            y = 2 * YMAX - y;
        }
        
        y += dy * yk;
        x += dx * xk;      
        
        myOled.fillCircle(x, y, r, WHITE);
        
        myOled.display();
        
        wait_ms(REFRESH_RATE_MS);
        myOled.clearDisplay();
    }
}
 
int main() {
  
//    Initialize OLED:
    myOled.begin();
    myOled.setTextCursor(0, 0);    
    i2c.frequency(I2C_FREQUENCY);
    
    //screenSaver();
    bounce();
}