#include "mb_pins.h"
#include "mbed.h"
#include "platform/mbed_thread.h"
#include "MQTTClientMbedOs.h"

#include "Adafruit_GFX.h"
#include "Adafruit_GFX_Config.h"
#include "Adafruit_SSD1306.h"

/* macro definitions */

#define SMALL_WAIT_MS                                                         10

//I2C
#define I2C_ADDRESS                                                         0x3c
#define I2C_ADD_MBED                                            I2C_ADDRESS << 1

//OLED DIMENSIONS
#define OLED_HEIGHT_PX                                                        64
#define OLED_WIDTH_PX                                                        128

// I2C frequency
#define I2C_FREQUENCY                                                     400000

InterruptIn sw1(MB_SW1);
AnalogIn pot1(MB_POT1);

/* function declarations */

TCPSocket socket;
MQTTClient client(&socket);
MQTT::Message message;
WiFiInterface *wifi;

I2C i2c_obj(MB_OLED_SDA, MB_OLED_SCL);
Adafruit_SSD1306_I2c myOLED(i2c_obj, PB_5, I2C_ADD_MBED, OLED_HEIGHT_PX, OLED_WIDTH_PX);

char* topic_sub = "subpim";
char* topic_pub = "pubpim";
const char* hostname = "broker.hivemq.com";
int port = 1883;
int button_pressed = 0;
int send_data = 0;
/* function definition */

void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    //printf("Browser message: %.*s \n", message.payloadlen, (char*)message.payload);
    
    myOLED.clearDisplay();
    myOLED.setTextCursor(0, 0);
    myOLED.printf("%.*s", message.payloadlen, (char*)message.payload);
    myOLED.display();
    
    /*if(((char*)message.payload[0] == 's') && ((char*)message.payload[1] == 't') &&
       ((char*)message.payload[2] == 'a') && ((char*)message.payload[3] == 'r') &&
       ((char*)message.payload[4] == 't')){
        send_data = 1;
    }*/
}

void ISR_sw1()
{
    button_pressed = 1;
}

/* main function */

int main()
{
    myOLED.begin();
    sw1.fall(&ISR_sw1); // sw1 interrupt
    
    wifi = WiFiInterface::get_default_instance(); //init wifi

    int ret = wifi->connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    if(ret != 0){
        //myOLED.printf("Greska u povezivanju");
        //myOLED.display();
        return -1;
    }
    myOLED.printf("Success\n");
    myOLED.display();
    wait(2);
    
    socket.open(wifi);
    socket.connect(hostname,port);
    
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = "Dzeki macor";

    client.connect(data);
    client.subscribe(topic_sub, MQTT::QOS0, messageArrived);    
    
    i2c_obj.frequency(I2C_FREQUENCY); 
     
    myOLED.clearDisplay();
    myOLED.display();
    
    
    while(1) {
        thread_sleep_for(SMALL_WAIT_MS);
        
        if(button_pressed){
            button_pressed = 0;
            char buf[100];
            sprintf(buf, "V(POT1) = %1.2f \r\n", pot1*(3.3f));
            
            myOLED.clearDisplay();
            myOLED.setTextCursor(0, 0);
            //myOLED.printf("%.*s", buf.payloadlen, (char*)buf.payload);
            myOLED.display();
            
            message.qos = MQTT::QOS0;
            message.retained = false;
            message.dup = false;
            message.payload = (void*)buf;
            message.payloadlen = strlen(buf) + 1;
            client.publish(topic_pub, message);
        }
        
        client.yield(1000);
    }
}
