//bonus pitanje:
//U vecem delu opsega se ne cuje razlika, jedino pred kraj (~99%),
//jacina zvuka se smanjuje do 0.

//include statements
#include "mbed.h"

//global variables
PwmOut buzzer(PA_11);
InterruptIn sw1(PC_9);
AnalogIn pot1(PA_0);
AnalogIn pot2(PA_1);

DigitalOut A(PA_10), B(PA_9), C(PA_8), D(PB_10), E(PB_5), F(PB_4), G(PB_3);
DigitalOut sel1(PB_6), sel2(PC_7);

char hex_number[10] = {0xC0, 0xF9, 0xA4, 0xB0, 0x99, 0x92, 0x82, 0xF8, 0x80, 0x90};
DigitalOut display[7] = {A, B, C, D, E, F, G};

char volume = 0;

//directive
#define PERIOD_US0 5000.f
#define PERIOD_US1 50.f
#define SCALAR 4950.f

#define REFRESH_RATE_MS 6

//functions
void ISR_sw1(void){
    volume = pot1.read() * 100;
}

void hexToDisplay(char sel1_val, char sel2_val, char hex){    
    sel1.write(sel1_val);
    sel2.write(sel2_val);
    
    for(int i = 6; i >= 0; i--)
        display[i] = (1<<i) & hex;
}

void currNumToDisplay(char num){
    char dec = num / 10;
    char dig = num % 10;
    
    if(dec){
        hexToDisplay(0, 1, hex_number[dec]);
        wait_ms(REFRESH_RATE_MS);
    }
    hexToDisplay(1, 0, hex_number[dig]);
    wait_ms(REFRESH_RATE_MS);
    
    
    hexToDisplay(1, 1, 0);
}

//main function
int main(){
    volume = pot1.read() * 100;
    
    sw1.fall(&ISR_sw1);
    
    while(true){
            buzzer.period_us(PERIOD_US0 - SCALAR * pot2.read());
            buzzer.write(pot1.read());
            
            currNumToDisplay(volume);
            
            wait_ms(10);
    }
}