//librrary import section
#include "mbed.h"

//macro definition section
#define REFRESH_RATE_MS 20
#define BTN_DELAY_MS 40

//global variable section
DigitalIn btn_up(PC_8);
DigitalIn btn_down(PC_9);

DigitalOut A(PA_10);
DigitalOut B(PA_9);
DigitalOut C(PA_8);
DigitalOut D(PB_10);
DigitalOut E(PB_5);
DigitalOut F(PB_4);
DigitalOut G(PB_3);

DigitalOut sel_1(PB_6);
DigitalOut sel_2(PC_7);

//arrays
char hex_number[10] = {0xC0, 0xF9, 0xA4, 0xB0, 0x99, 0x92, 0x82, 0xF8, 0x80, 0x90};
DigitalOut display[7] = {A, B, C, D, E, F, G};

//function declaration section
void hexToDisplay2(char hex){
    sel_1.write(1);
    sel_2.write(0);
    
    for(int i = 6; i >= 0; i--)
        display[i] = (1<<i) & hex;
}

void hexToDisplay1(char hex){    
    sel_1.write(0);
    sel_2.write(1);
    
    for(int i = 6; i >= 0; i--)
        display[i] = (1<<i) & hex;
}

void clearDisplay(){
    sel_1.write(1);
    sel_2.write(1);    
}

void currNumToDisplay(char num){
    char dec = num / 10;
    char dig = num % 10;
    
    if(dec){
        hexToDisplay1(hex_number[dec]);
        wait_ms(REFRESH_RATE_MS);
        
        hexToDisplay2(hex_number[dig]);
        wait_ms(REFRESH_RATE_MS);
    } else {
        hexToDisplay2(hex_number[dig]);
        wait_ms(REFRESH_RATE_MS);
    }
    
    clearDisplay();
}

//main function
int main(){
    char current_number = 0;

    while(true){
        currNumToDisplay(current_number);
        
        if(!btn_up){
            if(current_number == 0) current_number = 15;
            else    current_number = (current_number - 1) % 16;    
        }
        
        
        if(!btn_down) current_number = (current_number + 1) % 16;
        //wait_ms(BTN_DELAY_MS);
    }
}

//function definition section