#include "mbed.h"
#include "QEI.h"

QEI encoder1(p25, p26, NC, 1200, QEI::X4_ENCODING);
QEI encoder2(p23, p24, NC, 1200, QEI::X4_ENCODING);
DigitalIn trigger(p21);
AnalogIn force1(p20);
AnalogIn force2(p19);
AnalogIn current1(p18);
AnalogIn current2(p17);

LocalFileSystem local("local");
FILE *fp = fopen("/local/OUT.csv", "w");

int main() {
    fprintf(fp, "encoder 1, encoder 2, force 1, force 2, average force, current 1, current 2\n");
    while (trigger.read() == 0) {
        //do nothing
    }
    while (trigger.read() == 1) {
        float c1 = current1.read();
        float c2 = current2.read();
        float f1 = force1.read();
        float f2 = force2.read();
        float e1 = encoder1.getPulses()*2*3.14/1200.0;
        float e2 = encoder2.getPulses()*2*3.14/1200.0;
        
        fprintf(fp, "%f, %f, %f, %f, %f, %f, %f\n", e1, e2, f1, f2, (f1+f2)/2.0, c1, c2);
    }
    fclose(fp);
}
