#ifndef MENU_H
#define MENU_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Front.h"

/** Menu class
 * @author Luke Cartwright, University of Leeds
 * @brief manages all menu selection and movement
 * @date May 2020
*/

class Menu
{
public://-----------------------------------------------------------------------
    //methods
    /**constructor */
    Menu();

    /**destructor */
    ~Menu();

    /**runs main menu code
    * @manages all main menu code and runs continually once called
    */
    void mainmenu(N5110 &lcd, Gamepad &pad);

    //sub menus
    /** Waveform submenu function
    * @Runs Waveform submenu code
    */
    void subwaveforms(N5110 &lcd, Gamepad &pad);
    
    /** Instructions submenu function
    * @Runs Instruction submenu code
    */
    void subinstructions(N5110 &lcd, Gamepad &pad);
    
    /** Settings submenu function
    * @Runs Settings submenu code
    */
    void subsettings(N5110 &lcd, Gamepad &pad);
    
    /** Credits submenu function
    * @Runs Credits submenu code
    */
    void subcredits(N5110 &lcd, Gamepad &pad);
    
    /** Scrolling function
    * @Function controlling scrolling in menus
    * @checks doesnt exceed bounds
    * @returns int value of menu item selected
    */
    int scroll(N5110 &lcd, Gamepad &pad, int submenu, int menusize);
    
    /** Volume adjust function
    * @Runs Volume adjustment code
    */
    void volumerun(N5110 &lcd, Gamepad &pad);
    
    /** Backlight adjust function
    * @toggles Backlight
    */
    void backlightrun(N5110 &lcd, Gamepad &pad);
    
    /** Contrast adjust function
    * @Runs Contrast adjustment code
    */
    void contrastrun(N5110 &lcd, Gamepad &pad);
    
    /** Screen Mode adjust function
    * @toggles inverse/normal mode
    */
    void inverse_mode(N5110 &lcd, Gamepad &pad);
    
private: //---------------------------------------------------------------------
    //Global Variables
    int g_selecty; //variable to manage select box y coordinate

    //variables
    int menuflag; //flag to keep in menu loop
    int submenu; //submenu selected var
    int menusize; //size of each menu
    float contrast; //contrast float
    enum d; //direction
    int s; //current direction as int
    int s_1; //previous direction as int
    bool toggle; //Variable used for Backlight toggle 

    //Methods
    
    /** Prints Main Menu to LCD */
    void printmainmenu(N5110 &lcd);
    
    /** Prints Waveforms Submenu to LCD */
    void printsubwaveforms(N5110 &lcd);
    
    /** Prints Settings Submenu to LCD */
    void printsubsettings(N5110 &lcd);
    
    /** Prints Contrast adjust screen to LCD */
    void printcontrast(N5110 &lcd, float contrast);
    
    /**Function checks for joystick movement
    * @returns intiger value of scroll direction
    */
    int scroll_check(Gamepad &pad);
};

#endif