#ifndef LUTS_DEBUG_H
#define LUTS_DEBUG_H

/** Spaceship Test
@brief Checks LUT values are correct
@author Luke Cartwright, University of Leeds
@date May 2020
@return true if debug is passed
*/

// Objects
LUTs luts;

/**debugs sine wave
* @takes input wavetable number and expected
* @returns true sin table value
*/ 
bool sin_debug(int i, int expected_sin) {
    luts.sin_wavetable();
    if (sin_wavtable[i]==expected_sin) {
        return (1);
    } else {
        printf("expected-%i__real-%u \n",expected_sin,sin_wavtable[i]);
        return(0);
    }
}

/**debugs tri wave
* @takes input Pulsewidth, wavetable number and expected
* @returns true tri table value
*/ 
bool tri_debug(int pulsewidth,int i, int expected_tri)
{
    luts.tri_wavetable(pulsewidth);

    if (tri_wavtable[i]==expected_tri) {
        return (1);
    } else {
        printf("expected-%i__real-%u \n",expected_tri,tri_wavtable[i]);
        return(0);
    }
}

/**debugs sqr wave
* @takes input Pulsewidth, wavetable number and expected
* @returns true sqr table value
*/
bool pulse_debug(int pulsewidth,int i, int expected_pulse)
{
    luts.pulse_wavetable(pulsewidth);

    if (pulse_wavtable[i]==expected_pulse) {
        return (1);
    } else {
        printf("expected-%i__real-%u \n",expected_pulse,pulse_wavtable[i]);
        return(0);
    }
}

#endif