#include "mbed.h"
#include "LUTs.h"

LUTs::LUTs()
{
}
LUTs::~LUTs()
{
}
volatile uint16_t sin_wavtable[1024];
volatile uint16_t tri_wavtable[1024];
volatile uint16_t pulse_wavtable[1024];

void LUTs::initial_wavetables()
{
    sin_wavetable();
    tri_wavetable(50);
    pulse_wavetable(50);
}

void LUTs::sin_wavetable()
{
    //printf("Generating sin Wavetable \n");
    for (int i=0; i<1024; i++) { //Size of table
        sin_d= 65535*(0.5*sin(2.0*PI*(i/1024.0))+0.5); //Genrate Value
        rem= fmod(sin_d,1); //calculates remainder for rounding
        //printf("preround= %g -", sin_d); //DEBUG
        if (rem>=0.5) {
            sin_d=ceil(sin_d); //round UP
        } else {
            sin_d= floor(sin_d-rem); //round DOWN
        }
        // printf("Postround= %g -",sin_d); //DEBUG
        sin_u=((uint16_t)sin_d); //Value converted to unsigned
        //printf("sin_u= %u \n", sin_u);
        sin_wavtable[i]=sin_u;//Sets in Global Variable
        //sin_wavtable[i]=get_sin(i);
    }
    #ifdef SLOW_TIME
    for (int i=0; i<1024; i=i+128) {
    printf("sin_wav[%d]= %u \n", i, sin_wavtable); //prints Key values
    } 
    #endif
}

void LUTs::tri_wavetable(int pulsewidth)
{
    //printf("Generating Tri-wavetable\n");
    tri_wavtable[0]=0; //sets 0 value
    rise_t=(pulsewidth*1024/100); //Calculates rise samples
    rise_tu=(uint16_t)rise_t;
    fall_tu=1024-rise_tu; //Calculates fall samples
    dif=65536/rise_t; //Calculates Rise Dif
    dif_u=(uint16_t)dif; //converts to uint
    
    #ifdef SLOW_TIME //Prints Values in SLOW_TIME case
    printf("PRINTING TRI WAVETABLE Values\n");
    printf("PW= %d \n",pulsewidth);
    printf("Rise Samples= %u\n", rise_tu);
    printf("Fall Samples= %u\n", fall_tu);
    printf("UP sample dif= %u\n", dif_u);
    #endif   
    for (int i=1; i<=rise_tu; i++) { //Generates Rise Points
        tri_wavtable[i]=tri_wavtable[i-1]+dif_u;
    }
    dif=65536/fall_tu; //Calcualtes Fall Diff
    dif_u=(uint16_t)dif;
    
    #ifdef SLOW_TIME
    printf("down sample dif= %u\n", dif_u);
    #endif  
    for (int i=rise_tu; i<1024; i++) { //Generates Fall Points
        tri_wavtable[i]=65535-((i-rise_tu)*dif_u);
    }
    #ifdef SLOW_TIME
    tri_wav_results();//Prints Key Results
    #endif
}


void LUTs::pulse_wavetable(int pulsewidth)
{
    //printf("Generating Pulse-wavetable\n");
    up_t=(pulsewidth*1024/100); //Samples Up
    up_tu=(uint16_t)up_t;
    for (int i=0; i<=up_tu; i++) { //Until Down
        pulse_wavtable[i]=58981; //Headroom to normalise Volume
        //printf("up itt = %d\n",i);
    }

    for (int i=up_tu+1; i<1024; i++) { //Until Over
        pulse_wavtable[i]=6553; //HEadroom Included
        //printf("down itt = %d\n",i);
    }
}

void LUTs::tri_wav_results() { //Prints Results
    printf("TRI_WAV_RESULTS:\n");
    printf("i,out\n");
    for (i=0; i<=1024; i=i+64) {
        printf("%d, %u\n",i,tri_wavtable[i]);
        }
    }