#include "mbed.h"
#include "Envelope.h"
//Global var.
volatile int silent_flag; //used to trigger note off

//constructor/destructor
Envelope::Envelope()
{
}
Envelope::~Envelope()
{
}
//PUBLIC------------------------------------------------------------------------
uint16_t Envelope::env_in(int a, int d, int s, int r, int in, bool init)
{
    if(init==true) { //initial value set
        //printf("INITIATING ENVELOPE\n");
        av=a*a*52;// max 63700 = 4 seconds (ish)
        dv=d*d*52;// max 63700 = 4 seconds
        sv=s*s*53;// max 64925 =  Max Volume (ish)
        rv=r*r*52;// max 63700 = 4 seconds
        samples=0; //initialise sample counter
        a_vec=a_vector_calc(av); //initialise a value for a dif
        d_vec=d_vector_calc(dv,sv); //initialise a value for d dif
        at=0;//initialises
#ifdef SLOW_TIME //SLOW_TIME print variables
        printf("INITIATING ENVELOPE\n");
        printf("a=%d,av= %d,a vector= %d\n",a,av,a_vec);
        printf("d=%d,dv= %d,d vector= %d\n",d,dv,d_vec);
        printf("s=%d,sv= %d\n",s,sv);
#endif
    }
    if (samples<=av) { //Attack transient
        at=at+a_vec; //itterates multiplier
        out=(in*at/63980)+32767;
        //printf("ATTACK");
    } else if(samples>av && samples<=av+dv) { //Decay Transient
        at=at-d_vec; //iterates multiplier
        out=(in*at/63980)+32767;
        //printf("DECAY");
    } else if (samples>av+dv) { //Sustain
        out=(in*sv/65520)+32767;
    }
 #ifdef SLOW_TIME //SLOW_TIME print statements
    printf("FILTER:\nIN= %d,\nOUT (+offs) = %d\n",in,out);
    printf("MULTIPLIER = %d\n",at);
    printf("SAMPLE_%d\n",samples);
#endif
    samples=samples++; //itterates samples
    return (out);
}

uint16_t Envelope::release(int s, int r, int in, bool init)
{
    if (init==true) { //Initial Value Set
        sv=s*s*53;// max 64925 =  Max Volume (ish)
        rv=r*r*52;// max 63700 = 4 seconds
        r_vec=r_vector_calc(sv,rv);
        at=sv; //Initial Value
        samples_r=0;
        silent_flag=0;
        return(0);
    } else if (samples_r<=rv) { //upto end of decay transient
        at=at-r_vec; //itterates Multiplier
        out=(in*at/63980)+32767;
    }
    if(samples_r>rv) { //past note end
        silent_flag=1; //Triggers Note off
    }
    samples_r++; //itterates samples
    return(out);
}
//PRIVATE:----------------------------------------------------------------------
int Envelope::a_vector_calc(int av)
{
    a_vec=64925/av;
    return(a_vec);
}

int Envelope::d_vector_calc(int dv, int sv)
{
    d_vec=(64925-sv)/dv;
    return(d_vec);
}
int Envelope::r_vector_calc(int sv,int rv)
{
    return(sv/rv);
}