#ifndef DEBUG_H
#define DEBUG_H

#include "LUTs_debug.h"

/** Debug
@brief Runs debug codes
@author Luke Cartwright, University of Leeds
@date May 2020
*/

bool run_sin_debug()
{
    int passed=0;
    if(sin_debug(0, 32768))passed++;
    if(sin_debug(512, 32768))passed++;
    if(sin_debug(256, 65535))passed++;

    if (passed==3) {
        printf("Sin debug PASS\n");
        return (1);
    } else {
        printf("Sin debug FAIL\n");
        printf("tests passed = %d", passed);
        return (0);
    }
}

bool run_tri_debug()
{
    int passed=0;
    if(tri_debug(50,0,0))passed++;
    if(tri_debug(50,511, 65408))passed++;
    if(tri_debug(100,0,0))passed++;
    if(tri_debug(1,11,65471))passed++;

    if (passed==4) {
        printf("Tri debug PASS\n");
        return (1);
    } else {
        printf("Tri debug FAIL\n");
        printf("tests passed = %d\n", passed);
        return (0);
    }
}

bool run_pulse_debug()
{
    int passed=0;
    if(pulse_debug(50,0,58981))passed++;
    if(pulse_debug(50,512,58981))passed++;
    if(pulse_debug(50,513,6553))passed++;
    if(pulse_debug(1,10,58981))passed++;

    if (passed==4) {
        printf("Pulse debug PASS\n");
        return (1);
    } else {
        printf("Pulse debug FAIL\n");
        printf("tests passed = %d\n", passed);
        return (0);
    }
}


void run_LUTs_debug ()
{
    int masterpass=0;
    if(run_sin_debug())masterpass++;
    if(run_tri_debug())masterpass++;
    if(run_pulse_debug())masterpass++;
    if(masterpass==3) {
        printf("DEBUG PASSED\n");
    } else {
        printf("DEBUG FAIL master tests passed = %d\n",masterpass);
    }
}

#endif