#ifndef SOUND_H
#define SOUND_H

#include "mbed.h"

/**Sound class
 * @author Luke Cartwright, University of Leeds
 * @brief fetches data from wavetables and
 * @itterates through to next samples
 * @date May 2020
*/

class Sound
{
public: //----------------------------------------------------------------------
/**Constructor */
Sound();
   
/** Destructor */ 
~Sound();
    
//Variables
int waveform; //waveform number select
int frequency; //frequency of note
    
//Methods

/** Main sound function
* @Takes in waveform type and frequency.
* @ Outputs Unsigned int of wavetable value.
* @ (Self itterates)
*/
 uint16_t sound_main(bool initial, int waveform, int frequency); //runs main sound function
 
 /**Iterator function.
* @Itterates through wavetable values.
* @Outputs Next i value for sound_main function.
*/
uint16_t wavetable_itt(uint16_t i, int frequency); //itterates wavetable

private: //---------------------------------------------------------------------
//Variables
uint16_t i; //itterator as an uint
double i_d; //itterator as a double
};
#endif