#include "Sound.h"

//Global Variables
volatile extern uint16_t sin_wavtable[1024];
volatile extern uint16_t tri_wavtable[1024];
volatile extern uint16_t pulse_wavtable[1024];


Sound::Sound()
{
}

Sound::~Sound()
{
}

//PUBLIC:-----------------------------------------------------------------------


uint16_t Sound::sound_main(bool initial, int waveform, int frequency)
{
    if (initial==true) { //initiialises
        i=0;
        return(i);
    }
    i=wavetable_itt(i,frequency);//itterates i value
    
    if (waveform==1) { //sin values
        #ifdef SLOW_TIME
        printf("SIN_wavtable[%u]\n",i);
        #endif
        return (sin_wavtable[i]);
    }
        if (waveform==2) { //tri
        #ifdef SLOW_TIME
        printf("TRI_wavtable[%u]\n",i);
        #endif
        return (tri_wavtable[i]);
    }
        if (waveform==3) { //pulse
        #ifdef SLOW_TIME
        printf("SQR_wavtable[%u]\n",i);
        #endif
        return (pulse_wavtable[i]);
    }
    return(0);
}

//PRIVATE:----------------------------------------------------------------------

uint16_t Sound::wavetable_itt(uint16_t i, int frequency)
{
    i_d = i + ((1024*frequency)/ 10000); //i+((samples*f)*Ts)
    i=ceil(i_d); //rounds to int
    
    if (i>=1024) { //Sorts Overlap
        i=i-1024;
    }
    return(i);
}