#include "mbed.h"
#include "Menu.h"

//objects
Front front;

//constructor/destructor
Menu::Menu()
{
}
Menu::~Menu()
{
}

// PUBLIC methods---------------------------------------------------------------
void Menu::mainmenu(N5110 &lcd, Gamepad &pad) //main menu
{
    g_selecty=10; //POSITION OF SELECT BOX
    submenu=menuflag=1; //Variables Init
    menusize=4;
    printmainmenu(lcd); //prints menu to display
    pad.reset_buttons();//elimnates Prev Button Press
    while (menuflag==1) {
        s=scroll(lcd, pad, submenu, menusize); //Performs Scroll
        if (s==1) {
            printmainmenu(lcd);
            submenu++; //Increase Menu Selected
            wait_ms(200);
        }   else if (s==-1) {
            printmainmenu(lcd);
            submenu--; //Decrease menu Selected
            wait_ms(200);
        }
        if ( pad.A_pressed())  { //selects
            //printf("SubMenu %d selected\n", submenu);
            wait_ms(200); //debounce
            menuflag=0;//exits
        }
    }
    switch (submenu) {
        case 1:
            subwaveforms(lcd,pad);
        case 2:
            subinstructions(lcd,pad);
        case 3:
            subsettings(lcd,pad);
        case 4:
            subcredits(lcd,pad);
    }
}

void Menu::subwaveforms(N5110 &lcd, Gamepad &pad) //waveforms sub
{
    while (1) {
        g_selecty=10; //initialises Global var
        submenu=menuflag=1; //initialises Variables
        menusize=3;
        //printf("Waveforms menu \n"); //Debug
        printsubwaveforms(lcd); //Prints Screen
        pad.reset_buttons();
        while (menuflag==1) { //looped
            s=scroll(lcd,pad,submenu,menusize);
            if (s==1) {
                printsubwaveforms(lcd); //Prints Waveform sub
                submenu++; //increases selected sub
                wait_ms(200); //debounce
            }  else if (s==-1) {
                printsubwaveforms(lcd);
                submenu--;
                wait_ms(200);
            }
            if (pad.A_pressed())  { //Select
                //printf("Submenu: %d selected\n", submenu); //debug
                wait_ms(200); //debounce
                menuflag=0; //sets flag
            }
            if (pad.B_pressed())  { //go back menu
                //printf("Main Menu selected\n"); //debug
                submenu=0;
                wait_ms(200); //debounce
                menuflag=0; //sets flag
            }
        }
        if(submenu==0) { //allows main selected
            mainmenu(lcd,pad);
            break;
        }
        if(submenu>=1) { //allows waveform selected
            front.frontrun(lcd,pad,submenu);
        }
        mainmenu(lcd,pad);
        break;
    }
}

void Menu::subinstructions(N5110 &lcd, Gamepad &pad) //instruction sub
{
    menuflag=1; //sets flag
    //printf("Instructions menu \n");
    lcd.clear(); //LCD setup
    lcd.printString("Instructions:",2,0);
    lcd.printString("See attached",3,1);
    lcd.printString("User Manual",3,2);
    pad.reset_buttons();
    lcd.refresh();
    while (menuflag==1) {
        if (pad.B_pressed())  { //returns to main menu
            // printf("B pressed\n");
            //printf("Main Menu selected\n");
            submenu=0;
            wait_ms(200); //debounce
            menuflag=0; //sets flag
        }
    }
    if(submenu==0) { //allows main menu select
        mainmenu(lcd,pad);
    }
}

void Menu::subsettings(N5110 &lcd, Gamepad &pad)
{
    g_selecty=10; //Global Var initial value
    submenu=menuflag=1; //initialises Variables
    menusize=4;
    //printf("Settings menu \n");
    printsubsettings(lcd); //prints to LCD
    pad.reset_buttons(); //Stops Buttons from prev menu
    while (menuflag==1) { //looped
        s=scroll(lcd,pad,submenu,menusize);
        if (s==1) {
            printsubsettings(lcd);
            submenu++;
            wait_ms(200);
        } else if (s==-1) {
            printsubsettings(lcd);
            submenu--;
            wait_ms(200);
        }
        if (pad.A_pressed())  { //select menu
            //printf("Submenu: %d selected\n", submenu); //debug
            wait_ms(200); //debounce
            menuflag=0; //sets flag
        }
        if (pad.B_pressed())  { //go back menu
            //printf("Main Menu selected\n"); //debug
            submenu=0;
            wait_ms(200); //debounce
            menuflag=0; //sets flag
        }
    }
    switch (submenu) { //submenu select
        case 0:  mainmenu(lcd,pad); //returns to main
        case 1:  volumerun(lcd,pad);
        case 2:  backlightrun(lcd,pad);
        case 3:  contrastrun(lcd,pad);
        case 4:  inverse_mode(lcd,pad);
    }
}

void Menu::subcredits(N5110 &lcd, Gamepad &pad) //credits sub menu
{
    //printf("Credits \n");
    lcd.clear();
    lcd.printString("Credits",22,0); //prints credits to screen
    lcd.printString("Coded,Produced",0,1);
    lcd.printString("+ Built by",10,2);
    lcd.printString("Luke",30,3);
    lcd.printString("Cartwright",13,4);
    lcd.refresh(); //refresh buffer
    menuflag=1; //sets flag
    pad.reset_buttons();
    while (menuflag==1) {
        if (pad.B_pressed())  { //go back menu
            //printf("Main Menu selected\n");
            submenu=0;
            wait_ms(200); //debounce
            menuflag=0; //sets flag
        }
    }
    if(submenu==0) { //back to main
        mainmenu(lcd,pad);
    }
}

int Menu::scroll(N5110 &lcd, Gamepad &pad, int submenu, int menusize)   //checks srolling
{
    int d=scroll_check(pad);
    if(d != 0) {
        if (d==1)  { //N scrolls up
            //printf("N \n"); //debug
            submenu--;
            g_selecty=g_selecty-8; //line size=8
            if (submenu<=0) { //stops overflow
                submenu++;
                g_selecty = g_selecty+8; //moves select box
                return(0);
            }
            //printf("SubMenu= %d\n", submenu); //debug
            return(-1);
        }
        if (d==5)  { //S scrolls down
            //printf("S \n");
            submenu++;
            g_selecty=g_selecty+8; //movews select box
            if (submenu >menusize) { //stops overflow
                submenu--;
                g_selecty = g_selecty-8;
                return(0);
            }
            //printf("SubMenu= %d\n", submenu); //debug
            return(1);
        }
        wait_ms(200); //debounce
    }
    return(0);
}

void Menu::volumerun(N5110 &lcd, Gamepad &pad)
{
    //printf("Volume Settings \n");
    menuflag=1; //sets flag
    lcd.clear(); //Sets Up LCD
    lcd.printString("Volume:",3,0);
    lcd.printString("Use screw",3,1);
    lcd.printString("potentiometer",3,2);
    lcd.printString("on rear",3,3);
    lcd.refresh();
    pad.reset_buttons();
    while (menuflag==1) {
        if (pad.B_pressed())  {
            // printf("B pressed\n");
            printf("Main Menu selected\n");
            submenu=0;
            wait_ms(200); //debounce
            menuflag=0; //sets flag
        }
    }
    if(submenu==0) { //allows main menu select
        subsettings(lcd,pad);
    }
}

void Menu::backlightrun(N5110 &lcd, Gamepad &pad)
{
    lcd.clear(); //sets up LCD
    lcd.printString("Backlight:",3,0);
    lcd.printString("Press A to",3,1);
    lcd.printString("toggle",3,2);
    lcd.refresh();
    menuflag=1;
    toggle=true;
    while (menuflag==1) {
        if (pad.A_pressed()) {
            if (toggle==true) {
                lcd.backLightOn();
                toggle=false;
            } else if (toggle==false) {
                lcd.backLightOff();
                toggle=true;
            }
            wait_ms(500);//debounce
        }
        if (pad.B_pressed()) {
            menuflag=0; //alows loop exit
        }
    }
    wait_ms(500);//debounce
    pad.reset_buttons();
    subsettings(lcd,pad); //launches setting menu
}

void Menu::contrastrun(N5110 &lcd, Gamepad &pad)
{
    menuflag=1; //sets flag
    //printf("Contrast Settings \n");
    contrast=0.5; //initialises
    pad.reset_buttons();
    printcontrast(lcd,contrast);
    while (menuflag==1) { //looped
        s=scroll(lcd,pad,10,20);
        if (s!=s_1) {
            //printf("S= %d",s);
            if (s==1) {
                contrast=contrast+0.05f;
                lcd.setContrast(contrast);
                //printf("CONTRAST UP\n");
            } else if (s==-1) {
                contrast=contrast-0.05f;
                lcd.setContrast(contrast);
                //printf("CONTRAST DOWN\n");
            }
            printcontrast(lcd,contrast);
            wait_ms(200);
        }
        if (pad.B_pressed())  { //go back menu
            //printf("Settings Menu selected\n"); //debug
            lcd.clear();
            lcd.printString("Contrast Set",3,3);
            lcd.refresh();
            wait_ms(900); //debounce + display
            menuflag=0; //sets flag
        }
        s=s_1;
    }
    subsettings(lcd,pad);
}

void Menu::inverse_mode(N5110 &lcd, Gamepad &pad)
{
    lcd.clear(); //Sets up LCD
    lcd.printString("Inverse Mode:",3,0);
    lcd.printString("Press A to",3,1);
    lcd.printString("toggle",3,2);
    lcd.refresh();
    menuflag=1;// initial value
    toggle=true;
    while (menuflag==1) {
        if (pad.A_pressed()) {
            if (toggle==true) {
                lcd.normalMode();
                toggle=false;
            } else if (toggle==false) {
                lcd.inverseMode();
                toggle=true;
            }
            wait_ms(500);//debounce
        }
        if (pad.B_pressed()) {
            menuflag=0;//allows loop exit
        }
    }
    wait_ms(500);//debounce
    pad.reset_buttons();
    subsettings(lcd,pad);//launches setting submenu
}

//Private Methods--------------------------------------------------------------
void Menu::printmainmenu(N5110 &lcd)   //prints main menu
{
    //printf("Printing Main Menu \n");
    lcd.clear(); //clears current buffer
    lcd.drawRect(78,g_selecty,5,5,FILL_BLACK); //prints select box at y value
    lcd.printString("MAIN MENU",3,0); //title print
    //SUBMENU TITLES
    lcd.printString("Waveforms",3,1);
    lcd.printString("Instructions",3,2);
    lcd.printString("Settings",3,3);
    lcd.printString("Credits",3,4);
    lcd.refresh(); //updates display
}

void Menu::printsubwaveforms(N5110 &lcd)   //prints subwaveforms menu
{
    //printf("Printing Waveforms menu\n");
    lcd.clear(); //clears current buffer
    lcd.drawRect(78,g_selecty,5,5,FILL_BLACK); //prints select box at y value
    lcd.printString("WAVEFORMS:",3,0); //title print
    //SUBMENU TITLES
    lcd.printString("Sine",3,1);
    lcd.printString("Triangle",3,2);
    lcd.printString("Square",3,3);
    lcd.refresh(); //updates display
}

void Menu::printsubsettings(N5110 &lcd)   //prints settings menu
{
    //printf("Printing Settings menu\n");
    lcd.clear();
    lcd.drawRect(78,g_selecty,5,5,FILL_BLACK); //prints select box at y value
    lcd.printString("Settings:",3,0); //title print
    //SUBMENU TITLES
    lcd.printString("Volume",3,1);
    lcd.printString("Backlight",3,2);
    lcd.printString("Contrast",3,3);
    lcd.printString("Inverse Mode",3,4);
    lcd.refresh(); //updates display
}

void Menu::printcontrast(N5110 &lcd, float contrast)   //prints contrast edit screen
{
    lcd.clear();
    lcd.printString("Contrast:",3,0);//title print
    lcd.printString("VISIBILITY",12,3);
    lcd.refresh();
}

int Menu::scroll_check (Gamepad &pad)
{
    return(pad.get_direction()); //checks for stick
}