#ifndef FILTER_H
#define FILTER_H

#include "mbed.h"

/** Filter class
 * @author Luke Cartwright, University of Leeds
 * @brief Filters Synth Signal
 * @date May 2020
*/
class Filter
{
public://-----------------------------------------------------------------------
//Methods
    /** Constructor */
    Filter();

    /** Destructor */
    ~Filter();

    /**Runs Main Filter
    * @outptus adjusted value due to filter
    * @accept input filter type
    */
    int filter_run(int input, int filter_type, bool init);

    /**Implements Low Pass Filter Algorithm
    */
    int LPF (int input,bool init);

    /**Implements High Pass Filter Algorithm
    */
    int HPF (int input,bool init);

    /**Implements Band Pass Filter Algorithm
    * @uses LPF and HPF function
    */
    int BPF (int input,bool init);

private://----------------------------------------------------------------------
    int x; //input value
    int y_1; //previous y value
    int y; //output value
};


#endif