#include "mbed.h"
#include "Filter.h"

//constructor/destructor
Filter::Filter()
{
}
Filter::~Filter()
{
}


int Filter::filter_run(int input, int filter_type, bool init)
{
    if (filter_type==0){ //none
        y=input;
        }
    if (filter_type==1){ //LPF
        y=LPF(input,init);
        }
    if (filter_type==2){ //HPF
        y=HPF(input,init);
        }
    if (filter_type==3){ //BPF
        y=BPF(input,init);
        }
return(y); //Output
}

int Filter::LPF(int input,bool init)
{
    if (init==true) { //initial Value set
     x=0;
     y_1=0;
     y=0;
    }
    else {
        x = input;
        y = y_1 + 0.05*(x-y_1); //LPF algorithm
        y_1=y; 
        }
    return(y);
}

int Filter::HPF(int input,bool init)
{
    if (init==true) { //initial Value Set
     x=0;
     y_1=0;
     y=0;
    }
    else {
        x = input;
        y = (y_1 - 0.95*(x - y_1))/2.9; //HPF Algorithm
        y_1=y;
        }
    return(y);
}

int Filter::BPF(int input,bool init)
{
    if (init==true) { //initialise
     y=0;
    }
    else {
    y=HPF(input,false); //HPF
    y=LPF(y,false); //LPF
        }
    return(y);
}