/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

/*
#include "mbed.h"
#include "SDFileSystem.h"

Serial pc(USBTX, USBRX);
SDFileSystem sd(D11, D12, D13, D10, "sd"); // MOSI, MISO, SCK, CS
FILE *fp;

AnalogIn   ain(A0);
Ticker casovac;             //timer s prerusenim
Ticker casovac2;             //timer s prerusenim
float perioda=0.001;        // 4khz
volatile int poc=0;

void init_sd()
{
    wait(2);
    pc.printf("Initializing\r\n");
    
    fp = fopen("/sd/hello.txt", "r");
    if (fp != NULL) {
        fclose(fp);
        remove("/sd/hello.txt");
        pc.printf("Remove an existing file with the same name\r\n");
    }
    
    fp = fopen("/sd/hello.txt", "w");
    if (fp == NULL) {
        pc.printf("Unable to write the file\r\n");
    }
    fclose(fp);
}

void fun(void) {
    __disable_irq();    // Disable Interrupts
 //   pc.printf("%3.8f\r\n", ((ain.read()*2)-1));
 //   pc.printf("blabla\r\n");
    fp = fopen("/sd/hello.txt", "a");
//    pc.printf("otvoreny\r\n");
    fprintf(fp, "%3.4f\r\n", ain.read());
//    pc.printf("zapisany\r\n");
    fclose(fp);
//    pc.printf("zatvoreny\r\n");
    poc++;
    __enable_irq();     // Enable Interrupts   
}

void pocitadlo(void){
    poc++;
//    pc.printf("Hodnota pocitadla: %d\r\n", poc );
}

int main() {
    pc.baud(921600);
    __disable_irq();    // Disable Interrupts
    init_sd();
    casovac.attach(&fun, perioda);
//    casovac2.attach(&pocitadlo, 1.0);
//    pc.printf("Cakam 5 s \r\n");
    __enable_irq();     // Enable Interrupts
    while(poc<3000)
    {
        pc.printf("Hodnota pocitadla: %d\r\n", poc );
        wait(0.1);
    }
//    fclose(fp);
    pc.printf("File successfully written!\r\n");
}
  
    
/*    wait(2);
    pc.printf("Initializing\r\n");
    
    fp = fopen("/sd/hello.txt", "r");
    if (fp != NULL) {
        fclose(fp);
        remove("/sd/hello.txt");
        pc.printf("Remove an existing file with the same name\r\n");
    }
    
    fp = fopen("/sd/hello.txt", "w");
    if (fp == NULL) {
        pc.printf("Unable to write the file\r\n");
    } else {
        fprintf(fp, "mbed SDCard application!");
        fclose(fp);
        pc.printf("File successfully written!\r\n");
    }
*/

#include "mbed.h"
#include "SDFileSystem.h"
SDFileSystem sd(D11, D12, D13, D10, "sd"); // MOSI, MISO, SCK, CS
FILE *myLogFile;
Ticker sampleTicker;
AnalogIn sensor(A0);
Timer fileOpenTimer;
 
#define bufferSize 8192
float sensorReading[bufferSize];
unsigned int readPointer = 0;
volatile unsigned int writePointer = 0; // volatile so that the main loop knows to check for changes.
volatile unsigned int poc=0;
 
// opens the next unused file name in the format set.
// This can be a little slow the first time if there are already lots of log files
// since it tries each number in turn but the second call on will be fairly quick.
FILE *nextLogFile(void)
{
    static unsigned int fileNumber = 0;
    char fileName[32];
    FILE *filePtr = NULL;
    do {
        if (filePtr != NULL)
            fclose(filePtr);
        sprintf(fileName,"/sd/log%04u.csv",fileNumber++);
        filePtr = fopen(fileName,"r");
    } while (filePtr != NULL);
    return fopen( fileName,"w");
}
 
void onSampleTick(void)
{
    sensorReading[writePointer++] = sensor*3.2; // scale to give a voltage rather than value from 0 to 1.
    if (writePointer == bufferSize)
        writePointer = 0;
    if (writePointer == readPointer) {
        // BUFFER OVERFLOW. You may want to print an error message or turn an LED on
    }
    poc++;
}
 
 main()
{
    printf("ZACIATOK\r\n");
    myLogFile = nextLogFile();
    if (!myLogFile) {
        // ERROR failed to open the first log file for writing.
        // The SD card is missing, not working, read only or full?
 
        return 1; // probably want to exit the program in this situation
    }
 
    fileOpenTimer.start();
    sampleTicker.attach(&onSampleTick,0.000125); // sets the sample period in seconds
 
    while (true) {
 
        while (writePointer != readPointer) { // write any waiting data to the SD card
            fprintf(myLogFile,"%.2f\r\n",sensorReading[readPointer++]);
            if(poc>40000)
            {
                fclose(myLogFile);
                printf("KONIEC\r\n");
                exit(0);
            }
            if (readPointer == bufferSize)
                readPointer = 0;
        }
    }
}






