#include "Thermometer.h"

const double voltage_divider_ref = V_BATT_REFF * (1.0/(1.0+1.6));   // max uroven napatia na delici

Thermometer thermometer(true, true, false, THERM_PIN, BATTERY_PIN, FOTO_PIN);

Thermometer::Thermometer(bool crcOn, bool useAddr, bool parasitic, PinName pinThermometer, PinName bat, PinName fot)
    : thermometer(crcOn, useAddr, parasitic, pinThermometer),
      battery(bat),
      foto(fot)
{
    meassuredValue = 0.0;
    batteryValue = 0.0;
    fotoValue = 0.0;
    intervalSeconds = MEASURE_INTERVAL;
    counter = 0;
};

void Thermometer::Init()
{
    thermometer.initialize();
    thermometer.setResolution(THERMOMETER_RESOLUTION);
};

void Thermometer::StartPeriodicMeassure(int seconds)
{
    counter = 0;
    Meassure();
    intervalSeconds = seconds;
//    thermometerTicker.attach_us(this,&Thermometer::OnSampleTick,1000000);       // kazdu sekundu
    thermometerTicker.attach(this,&Thermometer::OnSampleTick,1.0);              // kazdu sekundu
};

void Thermometer::StopPeriodicMeassure()
{
    counter = 0;
    thermometerTicker.detach();
};

void Thermometer::Meassure()
{
    meassuredValue = thermometer.readTemperature();
    batteryValue = ((battery.read()*3.3)/voltage_divider_ref)*V_BATT_REFF;
    fotoValue = foto.read_u16();
    while((rint(meassuredValue)) == 85) {
        Init();
        meassuredValue = thermometer.readTemperature();
        batteryValue = ((battery.read()*3.3)/voltage_divider_ref)*V_BATT_REFF;
        fotoValue = foto.read_u16();
    }
    rfm.SendValue(GATEWAY_ID, meassuredValue, fotoValue, batteryValue);
};

void Thermometer::OnSampleTick()
{
    counter++;
    if(counter >= 60) {
        counter = 0;
        Meassure();
    }
};