#ifndef THERMOMETER_H
#define THERMOMETER_H

#include "mbed.h"
#include "RFM95W.h"
#include "Board.h"
#include "DS18B20.h"
#include "DS18S20.h"
#include "OneWireDefs.h"

#define THERMOMETER             DS18B20
#define THERMOMETER_CRC_ON      true
#define THERMOMETER_USE_ADDR    true
#define THERMOMETER_PARASITIC   false
#define THERMOMETER_RESOLUTION  twelveBit

class Thermometer
{
private:
    THERMOMETER thermometer;
    AnalogIn battery;
    AnalogIn foto;
    Ticker thermometerTicker;
    volatile float meassuredValue;
    volatile float batteryValue;
//    volatile float fotoValue;
    volatile uint16_t fotoValue;
    volatile int intervalSeconds;
    volatile int counter;

    void OnSampleTick();
public:
    Thermometer(bool crcOn, bool useAddr, bool parasitic, PinName pinThermometer, PinName battery, PinName foto);
    void Init();
    void Meassure();
    void StartPeriodicMeassure(int seconds);
    void StopPeriodicMeassure();
};

extern Thermometer thermometer;

#endif